/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.director.minings;

import java.util.HashMap;
import javax.datamining.NamedObject;
import javax.datamining.data.CategorySetFactory;
import javax.datamining.supervised.classification.ClassificationApplyContent;
import javax.datamining.supervised.classification.ClassificationApplySettings;
import javax.datamining.supervised.classification.ClassificationApplySettingsFactory;
import javax.datamining.supervised.classification.CostMatrix;
import javax.datamining.supervised.classification.CostMatrixFactory;
import javax.datamining.task.apply.ApplySettings;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.dm4j.datasources.TargetValueCostMatrixDataSource;
import oracle.dmt.dm4j.wizard.director.minings.ModelApplyBuilder;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ApplyCostMatrixState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ApplyTargetValueState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ClassificationApplyOutputOptionState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ClassificationModelState;
import oracle.dmt.dm4j.wizard.state.miningsteps.FinishState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.jdm.supervised.classification.OraClassificationApplyContent;

public class ClassificationModelApplyBuilder
extends ModelApplyBuilder {
    public static String COST_COLUMN_NAME = "COST";
    public static String PROBABILITY_COLUMN_NAME = "PROB";
    public static String RULEID_COLUMN_NAME = "RULE_ID";
    public static String NODEID_COLUMN_NAME = "NODE";
    public static String PROB_LOWER_COLUMN_NAME = "PROB_LOWER";
    public static String PROB_UPPER_COLUMN_NAME = "PROB_UPPER";
    private ClassificationApplySettingsFactory m_applySettingsFactory = null;
    private CostMatrixFactory m_costMatrixFactory = null;
    private CategorySetFactory m_catSetFactory = null;
    private String m_costMatrixName = null;

    public ClassificationModelApplyBuilder(WizardState wizardState) throws Exception {
        super(wizardState);
    }

    public void construct() throws Exception {
        super.construct();
        this.m_applySettingsFactory = (ClassificationApplySettingsFactory)this.m_state.getJDMConnection().getFactory("javax.datamining.supervised.classification.ClassificationApplySettings");
        this.m_costMatrixFactory = (CostMatrixFactory)this.m_state.getJDMConnection().getFactory("javax.datamining.supervised.classification.CostMatrix");
        this.m_catSetFactory = (CategorySetFactory)this.m_state.getJDMConnection().getFactory("javax.datamining.data.CategorySet");
    }

    public void cleanUp() {
        if (!this.m_isCancelable) {
            return;
        }
        try {
            if (this.m_costMatrixName != null) {
                this.m_state.getJDMConnection().removeObject("\"" + this.m_costMatrixName + "\"", NamedObject.costMatrix);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.cleanUp();
    }

    protected ApplySettings createApplySettings() throws Exception {
        ClassificationModelState classificationModelState = (ClassificationModelState)this.m_state.getStep(StepType.MODEL_STEP);
        FinishState finishState = (FinishState)this.m_state.getStep(StepType.FINISH_STEP);
        ClassificationApplySettings classificationApplySettings = this.m_applySettingsFactory.create();
        ApplyCostMatrixState applyCostMatrixState = (ApplyCostMatrixState)this.m_state.getStep(StepType.TARGET_VALUE_STEP);
        String string = applyCostMatrixState.getCostMatrixName();
        if (string != null) {
            CostMatrix costMatrix = (CostMatrix)this.m_state.getJDMConnection().retrieveObject(DMEMetadata.fixObjectNameWhenLoad(string), NamedObject.costMatrix);
            this.m_costMatrixName = DMEMetadata.fixObjectNameWhenSave(finishState.getCostMatrixName());
            this.m_state.getJDMConnection().saveObject(this.m_costMatrixName, costMatrix, true);
            classificationApplySettings.setCostMatrixName("\"" + this.m_costMatrixName + "\"");
        }
        return classificationApplySettings;
    }

    protected void addApplyMultipleScoringItem(ApplySettings applySettings) throws Exception {
        ClassificationApplyOutputOptionState classificationApplyOutputOptionState = (ClassificationApplyOutputOptionState)this.m_state.getStep(StepType.APPLY_OPTION_STEP);
        if (classificationApplyOutputOptionState.isTopNPredictions() || classificationApplyOutputOptionState.isMostProbable()) {
            ModelState modelState = (ModelState)this.m_state.getStep(StepType.MODEL_STEP);
            ClassificationApplySettings classificationApplySettings = (ClassificationApplySettings)applySettings;
            String string = modelState.getSelectedModelName();
            DMEMetadata dMEMetadata = DMEMetadata.getInstance();
            String string2 = dMEMetadata.getModelAlgoType(this.m_state.getConnection(), string);
            int n = classificationApplyOutputOptionState.getNumberOfTopNPredictions();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = "Top_" + i + "_Category";
            }
            if (string2.compareTo("DECISION_TREE") == 0) {
                classificationApplySettings.mapByRank(ClassificationApplyContent.nodeId, stringArray, true);
            } else if (string2.compareTo("ADAPTIVE_BAYES_NETWORK") == 0) {
                classificationApplySettings.mapByRank(ClassificationApplyContent.nodeId, stringArray, true);
            } else if (string2.compareTo("GENERALIZED_LINEAR_MODEL") == 0) {
                classificationApplySettings.mapByRank(OraClassificationApplyContent.probabilityLowerBound, stringArray, true);
                classificationApplySettings.mapByRank(OraClassificationApplyContent.probabilityUpperBound, stringArray, true);
            }
            classificationApplySettings.mapByRank(ClassificationApplyContent.predictedCategory, stringArray, true);
        }
    }

    protected void addApplyTargetProbabilityItem(ApplySettings applySettings) throws Exception {
        ClassificationApplyOutputOptionState classificationApplyOutputOptionState = (ClassificationApplyOutputOptionState)this.m_state.getStep(StepType.APPLY_OPTION_STEP);
        if (classificationApplyOutputOptionState.isSpecificPredictions()) {
            ModelState modelState = (ModelState)this.m_state.getStep(StepType.MODEL_STEP);
            ClassificationApplySettings classificationApplySettings = (ClassificationApplySettings)applySettings;
            String string = modelState.getSelectedModelName();
            DMEMetadata dMEMetadata = DMEMetadata.getInstance();
            String string2 = dMEMetadata.getModelAlgoType(this.m_state.getConnection(), string);
            HashMap hashMap = classificationApplyOutputOptionState.getClassificationTargetPredictionColumns(true);
            for (Object object : hashMap.keySet()) {
                String string3 = (String)hashMap.get(object);
                string3 = DM4JStringUtils.trimDoubleQuotes(string3);
                if (object instanceof String) {
                    object = DM4JStringUtils.escapeSingleQuotesForSQL((String)object);
                }
                if (string2.compareTo("DECISION_TREE") == 0) {
                    classificationApplySettings.mapByCategory(ClassificationApplyContent.nodeId, object, "\"" + NODEID_COLUMN_NAME + "_" + string3 + "\"");
                } else if (string2.compareTo("ADAPTIVE_BAYES_NETWORK") == 0) {
                    classificationApplySettings.mapByCategory(ClassificationApplyContent.nodeId, object, "\"" + RULEID_COLUMN_NAME + "_" + string3 + "\"");
                } else if (string2.compareTo("GENERALIZED_LINEAR_MODEL") == 0) {
                    classificationApplySettings.mapByCategory(OraClassificationApplyContent.probabilityLowerBound, object, "\"" + PROB_LOWER_COLUMN_NAME + "_" + string3 + "\"");
                    classificationApplySettings.mapByCategory(OraClassificationApplyContent.probabilityUpperBound, object, "\"" + PROB_UPPER_COLUMN_NAME + "_" + string3 + "\"");
                }
                classificationApplySettings.mapByCategory(ClassificationApplyContent.probability, object, "\"" + PROBABILITY_COLUMN_NAME + "_" + string3 + "\"");
                if (this.m_costMatrixName == null) continue;
                classificationApplySettings.mapByCategory(ClassificationApplyContent.cost, object, "\"" + COST_COLUMN_NAME + "_" + string3 + "\"");
            }
        }
    }

    private CostMatrix buildCostMatrix(ApplyTargetValueState applyTargetValueState) throws Exception {
        CostMatrix costMatrix = null;
        if (applyTargetValueState.getWeightedScoreIndicator()) {
            TargetValueCostMatrixDataSource targetValueCostMatrixDataSource = applyTargetValueState.getTargetValueCostMatrixDataSource();
            costMatrix = targetValueCostMatrixDataSource.generateCostMatrix(this.m_state.getJDMConnection());
        }
        return costMatrix;
    }
}

