/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.director.minings;

import javax.datamining.resource.Connection;
import oracle.bali.ewt.event.Cancelable;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.browser.LongRunningProcess;
import oracle.dmt.dm4j.datasources.CDSLDSDataSource;
import oracle.dmt.dm4j.datasources.CaseCountDataSource2;
import oracle.dmt.dm4j.datasources.ComplexDataStructure;
import oracle.dmt.dm4j.datasources.LDSDataSource;
import oracle.dmt.dm4j.wizard.state.minings.WizardStepState;
import oracle.dmt.dm4j.wizard.state.miningsteps.DataState;

public class AttributeExtractProcess
extends LongRunningProcess
implements Cancelable {
    private static String COMMAND_MONITOR = "AttributeExtractPanelMonitor";
    private boolean m_canceled = false;
    boolean m_dialogCanceled = false;
    boolean m_allowTextDataTypes = false;
    boolean m_gatherAttributeStatistics = false;
    boolean m_allowDataUsageAdjustments = true;
    WizardStepState m_stepState;
    Thread m_workerThread;
    Thread m_workerThread2;
    private String CREATE_LDS = "CreateLDS";
    private String CREATE_CASE_COUNT = "CreateCaseCount";
    private LDSDataSource m_ldsDataSource;
    private CaseCountDataSource2 m_caseCountDataSource;

    public AttributeExtractProcess(DataState dataState) throws Exception {
        this.m_stepState = dataState;
    }

    public AttributeExtractProcess(DataState dataState, boolean bl, boolean bl2) throws Exception {
        this.m_stepState = dataState;
        this.m_allowTextDataTypes = bl;
        this.m_gatherAttributeStatistics = bl2;
        this.m_allowDataUsageAdjustments = false;
    }

    public AttributeExtractProcess(DataState dataState, boolean bl, boolean bl2, boolean bl3) throws Exception {
        this.m_allowDataUsageAdjustments = bl;
        this.m_stepState = dataState;
        this.m_allowTextDataTypes = bl2;
        this.m_gatherAttributeStatistics = bl3;
    }

    public void run() {
        try {
            this.createWorkerThreads();
        }
        catch (Exception exception) {
            this.setException(exception);
            this.getProgressBar().setDoneStatus();
            exception.printStackTrace();
            return;
        }
        try {
            this.m_workerThread.join();
            if (this.m_ldsDataSource.getException() != null) {
                throw this.m_ldsDataSource.getException();
            }
            this.m_workerThread2.join();
            if (this.m_caseCountDataSource.getException() != null) {
                throw this.m_caseCountDataSource.getException();
            }
            if (this.m_ldsDataSource != null) {
                ((DataState)this.m_stepState).setLDSDataSource(this.m_ldsDataSource);
            }
            if (this.m_caseCountDataSource != null) {
                ((DataState)this.m_stepState).setCaseCount(this.m_caseCountDataSource.getCaseCount());
            }
            this.getProgressBar().setDoneStatus();
        }
        catch (InterruptedException interruptedException) {
            this.setException(interruptedException);
            this.getProgressBar().setDoneStatus();
            this.m_workerThread.interrupt();
        }
        catch (Exception exception) {
            this.setException(exception);
            this.getProgressBar().setDoneStatus();
            this.m_workerThread.interrupt();
        }
    }

    private void createWorkerThreads() throws Exception {
        ComplexDataStructure complexDataStructure = ((DataState)this.m_stepState).getInputCDS();
        if (complexDataStructure == null) {
            this.m_ldsDataSource = new LDSDataSource(DM4JConnectionManager.getDbConnection(), null, ((DataState)this.m_stepState).getSelectedSchemaName(), ((DataState)this.m_stepState).getSelectedTableName(), false, this.m_allowDataUsageAdjustments, this.m_allowTextDataTypes, this.m_gatherAttributeStatistics);
            this.m_ldsDataSource.setBuildStep(!this.m_allowDataUsageAdjustments);
        } else {
            this.m_ldsDataSource = new CDSLDSDataSource(DM4JConnectionManager.getDbConnection(), null, null, complexDataStructure, ((DataState)this.m_stepState).getSelectedSchemaName(), ((DataState)this.m_stepState).getSelectedTableName(), this.m_allowTextDataTypes, this.m_gatherAttributeStatistics);
            this.m_ldsDataSource.setBuildStep(true);
        }
        this.m_workerThread = new Thread((Runnable)this.m_ldsDataSource, this.CREATE_LDS);
        this.m_workerThread.setDaemon(false);
        this.m_workerThread.start();
        Connection connection = DM4JConnectionManager.getConnection();
        this.m_caseCountDataSource = new CaseCountDataSource2(connection, ((DataState)this.m_stepState).getSelectedSchemaName(), ((DataState)this.m_stepState).getSelectedTableName(), ((DataState)this.m_stepState).getInputCDS());
        this.m_workerThread2 = new Thread((Runnable)this.m_caseCountDataSource, this.CREATE_CASE_COUNT);
        this.m_workerThread2.setDaemon(false);
        this.m_workerThread2.start();
    }

    public boolean isCancelled() {
        return this.m_canceled;
    }

    public void cancel() {
        this.m_canceled = true;
    }
}

