/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.director.minings;

import java.util.Vector;
import javax.datamining.MiningAlgorithm;
import javax.datamining.MiningObject;
import javax.datamining.NamedObject;
import javax.datamining.algorithm.svm.KernelFunction;
import javax.datamining.base.AlgorithmSettings;
import javax.datamining.base.Model;
import javax.datamining.supervised.classification.ClassificationModel;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.director.minings.ModelBuildLoader;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.miningsteps.AnomalyDetectionAlgorithmState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelDataState;
import oracle.dmt.dm4j.wizard.state.miningsteps.OneClassSVMAlgorithmState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.jdm.algorithm.svm.classification.OraSVMClassificationSettings;

public class AnomalyDetectionModelBuildLoader
extends ModelBuildLoader {
    public AnomalyDetectionModelBuildLoader(WizardState wizardState, String string) {
        super(wizardState, string);
    }

    protected MiningObject restoreMiningObject(String string) throws Exception {
        ClassificationModel classificationModel = (ClassificationModel)this.m_state.getJDMConnection().retrieveObject(string, NamedObject.model);
        return classificationModel;
    }

    public boolean validate() throws Exception {
        Vector vector = new Vector();
        this.m_state.getStep(StepType.DATA_STEP).load();
        ModelDataState modelDataState = (ModelDataState)this.m_state.getStep(StepType.DATA_STEP);
        boolean bl = this.m_state.synchronize(vector, modelDataState);
        if (ValidationUtil.validationsContainsErrors(vector)) {
            DialogUtilities.displayValidations(vector, null, this.m_state.getDialog());
        }
        return bl;
    }

    public void buildAlgorithmSetting(AnomalyDetectionAlgorithmState anomalyDetectionAlgorithmState) throws Exception {
        Model model = (Model)this.getMiningObj();
        AlgorithmSettings algorithmSettings = this.getMiningFunctionSettings().getAlgorithmSettings();
        MiningAlgorithm miningAlgorithm = model.getMiningAlgorithm();
        if (miningAlgorithm.equals(MiningAlgorithm.svmClassification)) {
            OraSVMClassificationSettings oraSVMClassificationSettings = (OraSVMClassificationSettings)algorithmSettings;
            KernelFunction kernelFunction = oraSVMClassificationSettings.getKernelFunction();
            int n = 0;
            double d = 0.0;
            if (kernelFunction.equals(KernelFunction.kGaussian)) {
                n = oraSVMClassificationSettings.getKernelCacheSize();
                d = oraSVMClassificationSettings.getStandardDeviation();
            }
            double d2 = oraSVMClassificationSettings.getTolerance();
            double d3 = oraSVMClassificationSettings.getOutlierRate();
            OneClassSVMAlgorithmState oneClassSVMAlgorithmState = new OneClassSVMAlgorithmState(anomalyDetectionAlgorithmState, kernelFunction, new Double(d2), new Double(d), new Double(0.0), new Integer(n / 1000000), new Double(d3), oraSVMClassificationSettings.getActiveLearning());
            anomalyDetectionAlgorithmState.setSupportVectorMachineAlgorithm(oneClassSVMAlgorithmState);
        }
    }
}

