/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.dialogs;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JPanel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.dialogs.DM4JEvent;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.validation.StateValidation;

public class ValidationPanel
extends JPanel {
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private DM4JDialog m_validationDialog;
    private JDialog m_parentDialog;
    private Vector m_stateValidations;
    private Vector m_sortedValidations = new Vector();
    private String m_dialogTitle;
    private String m_currentValidationType;
    private MultiLineLabel lblErrorDetails = new MultiLineLabel();
    private int m_currentValidation = 0;
    private int m_buttonMask;
    private int m_numberOfErrors = 0;
    private int m_numberOfWarnings = 0;
    private int m_numberOfInformationals = 0;
    private static int WIDTH = 475;
    private static int HEIGHT = 200;

    public ValidationPanel(JDialog jDialog, Vector vector) throws Exception {
        this.m_stateValidations = vector;
        this.m_parentDialog = jDialog;
        this.tallyTypesOfValidations();
        this.createSortedValidations();
        this.jbInit();
        this.prepareNextMessage();
        this.prepareDialog();
        this.m_validationDialog = DM4JDialog.createDialog(jDialog, this.m_dialogTitle, this.m_buttonMask);
        this.addOKHelpCancelListeners();
        DialogUtilities.displayDialog(this.m_validationDialog, (JPanel)this, new Dimension(WIDTH, HEIGHT));
    }

    private void prepareDialog() {
        if ("ERROR".compareTo(this.m_currentValidationType) == 0) {
            this.m_dialogTitle = ResourceUtilities.getUILabel("ERROR_DIALOG_TITLE");
            this.m_buttonMask = 1;
        } else if ("WARNING".compareTo(this.m_currentValidationType) == 0) {
            this.m_dialogTitle = ResourceUtilities.getUILabel("WARNING_DIALOG_TITLE");
            this.m_buttonMask = 3;
        } else if ("INFORMATIONAL".compareTo(this.m_currentValidationType) == 0) {
            this.m_dialogTitle = ResourceUtilities.getUILabel("INFORMATIONAL_DIALOG_TITLE");
            this.m_buttonMask = 1;
        } else {
            this.m_dialogTitle = "Unknown validation type.";
            this.m_buttonMask = 1;
        }
    }

    private void createSortedValidations() {
        for (StateValidation stateValidation : this.m_stateValidations) {
            if ("ERROR".compareTo(stateValidation.getValidationType()) != 0) continue;
            this.m_sortedValidations.add(stateValidation);
        }
        for (StateValidation stateValidation : this.m_stateValidations) {
            if ("WARNING".compareTo(stateValidation.getValidationType()) != 0) continue;
            this.m_sortedValidations.add(stateValidation);
        }
        for (StateValidation stateValidation : this.m_stateValidations) {
            if ("ERROR".compareTo(stateValidation.getValidationType()) != 0) continue;
            this.m_sortedValidations.add(stateValidation);
        }
        for (StateValidation stateValidation : this.m_stateValidations) {
            String string = stateValidation.getClass().getName();
            if ("UNKNOWN".compareTo(stateValidation.getValidationType()) != 0) continue;
            this.m_sortedValidations.add(stateValidation);
        }
    }

    private boolean prepareNextMessage() {
        if (this.m_currentValidation > 0 && this.m_numberOfErrors > 0) {
            return false;
        }
        if (this.m_currentValidation > this.m_sortedValidations.size() - 1) {
            return false;
        }
        StateValidation stateValidation = (StateValidation)this.m_sortedValidations.get(this.m_currentValidation);
        this.lblErrorDetails.setText(stateValidation.getDescription());
        ++this.m_currentValidation;
        this.m_currentValidationType = stateValidation.getValidationType();
        return true;
    }

    public boolean containsErrors() {
        return this.m_numberOfErrors > 0;
    }

    private void jbInit() {
        this.setLayout(this.gridBagLayout);
        int n = 0;
        int n2 = 0;
        int n3 = 5;
        int n4 = 10;
        int n5 = 0;
        int n6 = 10;
        int n7 = 0;
        int n8 = 0;
        this.lblErrorDetails.setTextWrapper(WordWrapper.getTextWrapper());
        this.add((Component)this.lblErrorDetails, new GridBagConstraints(n2, n, 2, 2, 1.0, 1.0, 17, 1, new Insets(n3, n4, n5, n6), n7, n8));
        ++n;
    }

    private void tallyTypesOfValidations() {
        for (StateValidation stateValidation : this.m_stateValidations) {
            if ("ERROR".compareTo(stateValidation.getValidationType()) == 0) {
                ++this.m_numberOfErrors;
            }
            if ("WARNING".compareTo(stateValidation.getValidationType()) == 0) {
                ++this.m_numberOfWarnings;
            }
            if ("INFORMATIONAL".compareTo(stateValidation.getValidationType()) != 0) continue;
            ++this.m_numberOfInformationals;
        }
    }

    public boolean isCanceled() {
        return this.m_validationDialog.isCancelled();
    }

    protected void addOKHelpCancelListeners() {
        this.m_validationDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ValidationPanel.this.m_validationDialog_actionPerformed(actionEvent);
            }
        });
    }

    protected void m_validationDialog_actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("ok" == string) {
            this.m_validationDialog.setVisible(false);
            this.setCursor(new Cursor(3));
            if (this.prepareNextMessage()) {
                this.prepareDialog();
                this.m_validationDialog.setButtonMask(this.m_buttonMask);
                this.m_validationDialog.setTitle(this.m_dialogTitle);
                DM4JEvent dM4JEvent = (DM4JEvent)actionEvent;
                dM4JEvent.cancel();
                this.m_validationDialog.pack();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.m_validationDialog.setVisible(true);
            }
            this.setCursor(new Cursor(0));
        } else if ("cancel" == string) {
            // empty if block
        }
    }
}

