/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.dialogs.DM4JEvent;
import oracle.dmt.dm4j.wizard.dialogs.FileImportErrorPanel;
import oracle.dmt.dm4j.wizard.dialogs.SystemErrorPanel;
import oracle.dmt.dm4j.wizard.dialogs.UIErrorPanel;
import oracle.dmt.dm4j.wizard.dialogs.ValidationPanel;
import oracle.help.Help;

public final class DialogUtilities {
    private DialogUtilities() {
    }

    public static JEWTDialog createAndDisplayDialog(JDialog jDialog, String string, boolean bl, JPanel jPanel, int n, Dimension dimension) {
        JEWTDialog jEWTDialog = JEWTDialog.createDialog((Component)jDialog, (String)string, (int)n);
        DialogUtilities.displayDialog(jEWTDialog, jPanel, dimension);
        return jEWTDialog;
    }

    public static JEWTDialog createAndDisplayDialog(JFrame jFrame, String string, boolean bl, JPanel jPanel, int n, Dimension dimension) {
        JEWTDialog jEWTDialog = JEWTDialog.createDialog((Component)jFrame, (String)string, (int)n);
        DialogUtilities.displayDialog(jEWTDialog, jPanel, dimension);
        return jEWTDialog;
    }

    static void displayDialog(JEWTDialog jEWTDialog, JPanel jPanel, Dimension dimension) {
        jEWTDialog.setPreferredSize(dimension);
        jEWTDialog.setResizable(true);
        jEWTDialog.setContent((Component)jPanel);
        jEWTDialog.runDialog();
    }

    public static void displayDialog(DM4JDialog dM4JDialog, JTabbedPane jTabbedPane, Dimension dimension, String string) {
        dM4JDialog.setPreferredSize(dimension);
        dM4JDialog.setResizable(true);
        dM4JDialog.setContent(jTabbedPane);
        HelpUtils.setHelpProvider((JComponent)((JComponent)dM4JDialog.getContent()), (HelpProvider)BrowserFrame.getHelpObject());
        HelpUtils.setHelpID((JComponent)((JComponent)dM4JDialog.getContent()), (String)string);
        dM4JDialog.runDialog();
    }

    public static void displayDialog(DM4JDialog dM4JDialog, JPanel jPanel, Dimension dimension) {
        dM4JDialog.setPreferredSize(dimension);
        dM4JDialog.setResizable(true);
        dM4JDialog.setContent(jPanel);
        dM4JDialog.runDialog();
    }

    public static void displayDialog(DM4JDialog dM4JDialog, JPanel jPanel, Dimension dimension, String string) {
        DialogUtilities.displayDialog(dM4JDialog, jPanel, dimension, string, true);
    }

    public static void displayDialog(DM4JDialog dM4JDialog, JPanel jPanel, Dimension dimension, String string, boolean bl) {
        dM4JDialog.setModal(bl);
        dM4JDialog.setPreferredSize(dimension);
        dM4JDialog.setResizable(true);
        dM4JDialog.setContent(jPanel);
        HelpUtils.setHelpProvider((JComponent)((JComponent)dM4JDialog.getContent()), (HelpProvider)BrowserFrame.getHelpObject());
        HelpUtils.setHelpID((JComponent)((JComponent)dM4JDialog.getContent()), (String)string);
        dM4JDialog.runDialog();
    }

    public static void displayDialog(DM4JDialog dM4JDialog, JPanel jPanel, Dimension dimension, String string, Help help) {
        dM4JDialog.setPreferredSize(dimension);
        dM4JDialog.setResizable(true);
        dM4JDialog.setContent(jPanel);
        HelpUtils.setHelpProvider((JComponent)((JComponent)dM4JDialog.getContent()), (HelpProvider)help);
        HelpUtils.setHelpID((JComponent)((JComponent)dM4JDialog.getContent()), (String)string);
        dM4JDialog.runDialog();
    }

    public static void createSystemErrorDialog(JFrame jFrame, Exception exception) {
        SystemErrorPanel systemErrorPanel = new SystemErrorPanel(jFrame, exception);
    }

    public static void createFileImportErrorDialog(JFrame jFrame, Exception exception, File file, File file2) {
        FileImportErrorPanel fileImportErrorPanel = new FileImportErrorPanel(jFrame, exception, file, file2);
    }

    public static void createSystemErrorDialog(JDialog jDialog, Exception exception) {
        SystemErrorPanel systemErrorPanel = new SystemErrorPanel(jDialog, exception);
    }

    public static void createSystemErrorDialog(JDialog jDialog, Exception exception, boolean bl) {
        SystemErrorPanel systemErrorPanel = new SystemErrorPanel(jDialog, exception, bl);
    }

    public static void createUIErrorDialog(JFrame jFrame, String string) {
        UIErrorPanel uIErrorPanel = new UIErrorPanel(jFrame, string);
    }

    public static void createUIErrorDialog(JDialog jDialog, String string) {
        UIErrorPanel uIErrorPanel = new UIErrorPanel(jDialog, string);
    }

    public static boolean displayValidations(Vector vector, DM4JEvent dM4JEvent, JDialog jDialog) throws Exception {
        boolean bl = true;
        if (vector != null && !vector.isEmpty()) {
            ValidationPanel validationPanel = new ValidationPanel(jDialog, vector);
            if (validationPanel.containsErrors() || validationPanel.isCanceled()) {
                if (dM4JEvent != null) {
                    dM4JEvent.cancel();
                }
                bl = false;
            }
        }
        return bl;
    }
}

