/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.dialogs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.Vector;
import javax.datamining.algorithm.tree.TreeHomogeneityMetric;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.DM4JNumberTextField;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.dialogs.DM4JEvent;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.miningsteps.ClassificationAlgorithmState;

public class DecisionTreePanel
extends JPanel {
    private static int WIDTH = 450;
    private static int HEIGHT = 400;
    int tInd = 5;
    int lInd = 10;
    int bInd = 0;
    int rInd = 10;
    int wPad = 0;
    int hPad = 0;
    int l2Ind = 24;
    int bInstInd = 10;
    int tGroupInd = 10;
    int rowLength = 60;
    ClassificationAlgorithmState m_state;
    DM4JDialog m_parentDialog;
    GridBagLayout gridBagLayout = new GridBagLayout();
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    JLabel lblAttributeCount = new JLabel();
    JLabel lblAttributeCountValue = new JLabel();
    JLabel lblCaseCount = new JLabel();
    JLabel lblCaseCountValue = new JLabel();
    JButton butRestore = new JButton();
    JLabel lblBuildHomogeneityMetric = new JLabel();
    JComboBox comboBuildHomogeneityMetric = new JComboBox();
    DefaultComboBoxModel homogeneityMetricModel;
    JLabel lblBuildHomogeneityMetricHint1 = new JLabel();
    JLabel lblMaxDepth = new JLabel();
    JLabel lblMaxDepthHint1 = new JLabel();
    DM4JNumberTextField txtMaxDepth = new DM4JNumberTextField();
    JLabel lblMinSizeCnt = new JLabel();
    JLabel lblMinSizeCntHint1 = new JLabel();
    DM4JNumberTextField txtMinSizeCnt = new DM4JNumberTextField();
    JLabel lblMinSizePercent = new JLabel();
    JLabel lblMinSizePercentHint1 = new JLabel();
    DM4JNumberTextField txtMinSizePercent = new DM4JNumberTextField();
    JLabel lblNodeSizeCnt = new JLabel();
    JLabel lblNodeSizeCntHint1 = new JLabel();
    DM4JNumberTextField txtNodeSizeCnt = new DM4JNumberTextField();
    JLabel lblNodeSizePercent = new JLabel();
    JLabel lblNodeSizePercentHint1 = new JLabel();
    DM4JNumberTextField txtNodeSizePercent = new DM4JNumberTextField();
    JLabel lblFiller = new JLabel();
    boolean m_ignoreModelBuildTypeEvent = false;

    public DecisionTreePanel(DM4JDialog dM4JDialog, ClassificationAlgorithmState classificationAlgorithmState) throws Exception {
        this.m_parentDialog = dM4JDialog;
        this.m_state = classificationAlgorithmState;
        this.jbInit();
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout);
        int n = 0;
        int n2 = 0;
        n2 = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("ALGORITHM_STEP_DESCRIPTION"));
        this.mlblStepDescription.setPreferredRows(2);
        this.mlblStepDescription.setMinimumRows(2);
        this.mlblStepDescription.setPreferredColumns(this.rowLength);
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.add((Component)this.mlblStepDescription, new GridBagConstraints(n2, n, 3, 1, 1.0, 0.0, 17, 1, new Insets(this.tInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        ++n;
        n2 = 0;
        this.lblAttributeCount.setText(ResourceUtilities.getUILabel("ACTIVE_ATTRIBUTE_COUNT"));
        this.lblAttributeCount.setLabelFor(this.lblAttributeCountValue);
        this.add((Component)this.lblAttributeCount, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(this.tInd + this.tGroupInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        ++n2;
        this.add((Component)this.lblAttributeCountValue, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(this.tInd + this.tGroupInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        ++n;
        n2 = 0;
        this.lblCaseCount.setText(ResourceUtilities.getUILabel("SAMPLE_CASE_COUNT"));
        this.lblCaseCount.setLabelFor(this.lblCaseCountValue);
        this.add((Component)this.lblCaseCount, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(this.tInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        ++n2;
        this.add((Component)this.lblCaseCountValue, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(this.tInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        ++n;
        n2 = 0;
        this.butRestore.setText(ResourceUtilities.getUILabel("RESTORE_BUTTON"));
        this.butRestore.setMnemonic(ResourceUtilities.getUIMnemonic("RESTORE_BUTTON"));
        this.butRestore.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DecisionTreePanel.this.butRestore_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this.butRestore, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.tInd + this.tGroupInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        ++n;
        n2 = 0;
        this.lblBuildHomogeneityMetric.setText(ResourceUtilities.getUILabel("ALGO_DT_HOMOGENEITY_METRIC"));
        this.lblBuildHomogeneityMetric.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("ALGO_DT_HOMOGENEITY_METRIC"));
        this.lblBuildHomogeneityMetric.setLabelFor(this.comboBuildHomogeneityMetric);
        this.add((Component)this.lblBuildHomogeneityMetric, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.tInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        n2 = 1;
        this.comboBuildHomogeneityMetric.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DecisionTreePanel.this.comboBuildHomogeneityMetric_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this.comboBuildHomogeneityMetric, new GridBagConstraints(n2, n, 2, 1, 1.0, 0.0, 17, 0, new Insets(this.tInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        ++n;
        n2 = 0;
        this.lblMaxDepth.setText(ResourceUtilities.getUILabel("ALGO_DT_MAX_DEPTH"));
        this.lblMaxDepth.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("ALGO_DT_MAX_DEPTH"));
        this.lblMaxDepth.setLabelFor((Component)((Object)this.txtMaxDepth));
        this.add((Component)this.lblMaxDepth, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(this.tInd + this.tGroupInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        n2 = 1;
        this.txtMaxDepth.setLocale(Locale.getDefault());
        this.txtMaxDepth.setDataType(Integer.TYPE);
        this.txtMaxDepth.setSigned(false);
        this.add((Component)((Object)this.txtMaxDepth), new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.tInd + this.tGroupInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        ++n;
        n2 = 1;
        this.lblMaxDepthHint1.setText(ResourceUtilities.getUILabel("ALGO_DT_MAX_DEPTH_HINT1"));
        this.lblMaxDepthHint1.setLabelFor((Component)((Object)this.txtMaxDepth));
        this.add((Component)this.lblMaxDepthHint1, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        ++n;
        n2 = 0;
        this.lblMinSizeCnt.setText(ResourceUtilities.getUILabel("ALGO_DT_MIN_SIZE_CNT"));
        this.lblMinSizeCnt.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("ALGO_DT_MIN_SIZE_CNT"));
        this.lblMinSizeCnt.setLabelFor((Component)((Object)this.txtMinSizeCnt));
        this.add((Component)this.lblMinSizeCnt, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(this.tInd + this.tGroupInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        n2 = 1;
        this.txtMinSizeCnt.setLocale(Locale.getDefault());
        this.txtMinSizeCnt.setDataType(Integer.TYPE);
        this.txtMinSizeCnt.setSigned(false);
        this.add((Component)((Object)this.txtMinSizeCnt), new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.tInd + this.tGroupInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        ++n;
        n2 = 1;
        this.lblMinSizeCntHint1.setText(ResourceUtilities.getUILabel("ALGO_DT_MIN_SIZE_CNT_HINT1"));
        this.lblMinSizeCntHint1.setLabelFor((Component)((Object)this.txtMinSizeCnt));
        this.add((Component)this.lblMinSizeCntHint1, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        ++n;
        n2 = 0;
        this.lblMinSizePercent.setText(ResourceUtilities.getUILabel("ALGO_DT_MIN_SIZE_PERCENT"));
        this.lblMinSizePercent.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("ALGO_DT_MIN_SIZE_PERCENT"));
        this.lblMinSizePercent.setLabelFor((Component)((Object)this.txtMinSizePercent));
        this.add((Component)this.lblMinSizePercent, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(this.tInd + this.tGroupInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        n2 = 1;
        this.txtMinSizePercent.setLocale(Locale.getDefault());
        this.txtMinSizePercent.setDataType(Double.TYPE);
        this.txtMinSizePercent.setSigned(false);
        this.add((Component)((Object)this.txtMinSizePercent), new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.tInd + this.tGroupInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        ++n;
        n2 = 1;
        this.lblMinSizePercentHint1.setText(ResourceUtilities.getUILabel("ALGO_DT_MIN_SIZE_PERCENT_HINT1"));
        this.lblMinSizePercentHint1.setLabelFor((Component)((Object)this.txtMinSizePercent));
        this.add((Component)this.lblMinSizePercentHint1, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        ++n;
        n2 = 0;
        this.lblNodeSizeCnt.setText(ResourceUtilities.getUILabel("ALGO_DT_NODE_SIZE_CNT"));
        this.lblNodeSizeCnt.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("ALGO_DT_NODE_SIZE_CNT"));
        this.lblNodeSizeCnt.setLabelFor((Component)((Object)this.txtNodeSizeCnt));
        this.add((Component)this.lblNodeSizeCnt, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(this.tInd + this.tGroupInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        n2 = 1;
        this.txtNodeSizeCnt.setLocale(Locale.getDefault());
        this.txtNodeSizeCnt.setDataType(Integer.TYPE);
        this.txtNodeSizeCnt.setSigned(false);
        this.add((Component)((Object)this.txtNodeSizeCnt), new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.tInd + this.tGroupInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        ++n;
        n2 = 1;
        this.lblNodeSizeCntHint1.setText(ResourceUtilities.getUILabel("ALGO_DT_NODE_SIZE_CNT_HINT1"));
        this.lblNodeSizeCntHint1.setLabelFor((Component)((Object)this.txtNodeSizeCnt));
        this.add((Component)this.lblNodeSizeCntHint1, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        ++n;
        n2 = 0;
        this.lblNodeSizePercent.setText(ResourceUtilities.getUILabel("ALGO_DT_NODE_SIZE_PERCENT"));
        this.lblNodeSizePercent.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("ALGO_DT_NODE_SIZE_PERCENT"));
        this.lblNodeSizePercent.setLabelFor((Component)((Object)this.txtNodeSizePercent));
        this.add((Component)this.lblNodeSizePercent, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(this.tInd + this.tGroupInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        n2 = 1;
        this.txtNodeSizePercent.setLocale(Locale.getDefault());
        this.txtNodeSizePercent.setDataType(Double.TYPE);
        this.txtNodeSizePercent.setSigned(false);
        this.add((Component)((Object)this.txtNodeSizePercent), new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.tInd + this.tGroupInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        ++n;
        n2 = 1;
        this.lblNodeSizePercentHint1.setText(ResourceUtilities.getUILabel("ALGO_DT_NODE_SIZE_PERCENT_HINT1"));
        this.lblNodeSizePercentHint1.setLabelFor((Component)((Object)this.txtNodeSizePercent));
        this.add((Component)this.lblNodeSizePercentHint1, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        n2 = 0;
        ++n;
        this.add((Component)this.lblFiller, new GridBagConstraints(n2, n, 3, 1, 1.0, 1.0, 17, 1, new Insets(this.tInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        JButton[] jButtonArray = new JButton[]{this.butRestore};
        ResourceUtilities.setPreferredSize(jButtonArray, 100, 25);
        JComponent[] jComponentArray = new JComponent[]{this.txtMaxDepth, this.txtMinSizeCnt, this.txtMinSizePercent, this.txtNodeSizeCnt, this.txtNodeSizePercent};
        ResourceUtilities.setTextBoxSize(jComponentArray, 70, 20);
        JComponent[] jComponentArray2 = new JComponent[]{this.comboBuildHomogeneityMetric};
        ResourceUtilities.setTextBoxSize(jComponentArray2, 120, 20);
        this.addOKHelpCancelListeners();
        this.loadState();
    }

    protected void loadState() {
        this.setCounts();
        this.loadBuildHomogeneityMetricCombo();
        this.setDTSettings();
    }

    protected void setDTSettings() {
        if (this.m_state.getDecisionTree().getHomogeneityMetricSelected().equals(TreeHomogeneityMetric.gini)) {
            this.comboBuildHomogeneityMetric.setSelectedItem("Gini");
        } else if (this.m_state.getDecisionTree().getHomogeneityMetricSelected().equals(TreeHomogeneityMetric.entropy)) {
            this.comboBuildHomogeneityMetric.setSelectedItem("Entropy");
        }
        this.txtMaxDepth.setNumber(this.m_state.getDecisionTree().getMaxDepth());
        this.txtMinSizeCnt.setNumber(this.m_state.getDecisionTree().getMinSizeCnt());
        this.txtMinSizePercent.setNumber(this.m_state.getDecisionTree().getMinSizePercent());
        this.txtNodeSizeCnt.setNumber(this.m_state.getDecisionTree().getNodeSizeForSplitCnt());
        this.txtNodeSizePercent.setNumber(this.m_state.getDecisionTree().getNodeSizeForSplitPercent());
    }

    protected void setCounts() {
        this.lblAttributeCountValue.setText(DM4JNumericFormat.format(this.m_state.getActiveAttributeCountExcludingTargetsInteger()));
        this.lblCaseCountValue.setText(DM4JNumericFormat.format(this.m_state.getCaseCountInteger()));
    }

    protected void processUserInput() {
        this.m_state.getDecisionTree().setMaxDepth((Integer)this.txtMaxDepth.getNumber());
        this.m_state.getDecisionTree().setMinSizeCnt((Integer)this.txtMinSizeCnt.getNumber());
        this.m_state.getDecisionTree().setMinSizePercent((Double)this.txtMinSizePercent.getNumber());
        this.m_state.getDecisionTree().setNodeSizeForSplitCnt((Integer)this.txtNodeSizeCnt.getNumber());
        this.m_state.getDecisionTree().setNodeSizeForSplitPercent((Double)this.txtNodeSizePercent.getNumber());
    }

    protected void addOKHelpCancelListeners() {
        this.m_parentDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DecisionTreePanel.this.m_parentDialog_actionPerformed(actionEvent);
            }
        });
    }

    protected void m_parentDialog_actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("ok" == string) {
            Vector vector = null;
            try {
                this.processUserInput();
                vector = this.m_state.getDecisionTree().validate();
                DM4JEvent dM4JEvent = (DM4JEvent)actionEvent;
                DialogUtilities.displayValidations(vector, dM4JEvent, this.m_parentDialog);
            }
            catch (Exception exception) {
                this.m_state.getparentWizardState().doAbortCancel(exception);
            }
        } else if ("cancel" == string) {
            // empty if block
        }
    }

    protected void butRestore_actionPerformed(ActionEvent actionEvent) {
        this.m_state.getDecisionTree().restoreSettingsToDefault();
        this.setDTSettings();
    }

    protected void loadBuildHomogeneityMetricCombo() {
        this.m_ignoreModelBuildTypeEvent = true;
        Vector<String> vector = new Vector<String>();
        vector.add("Gini");
        vector.add("Entropy");
        this.homogeneityMetricModel = new DefaultComboBoxModel(vector);
        this.comboBuildHomogeneityMetric.setModel(this.homogeneityMetricModel);
        this.m_ignoreModelBuildTypeEvent = false;
    }

    protected void comboBuildHomogeneityMetric_actionPerformed(ActionEvent actionEvent) {
        try {
            if (!this.m_ignoreModelBuildTypeEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                String string = (String)jComboBox.getSelectedItem();
                if (string.equals("Gini")) {
                    this.m_state.getDecisionTree().setHomogeneityMetricSelected(TreeHomogeneityMetric.gini);
                } else if (string.equals("Entropy")) {
                    this.m_state.getDecisionTree().setHomogeneityMetricSelected(TreeHomogeneityMetric.entropy);
                }
            }
        }
        catch (Exception exception) {
            this.m_state.getparentWizardState().doAbortCancel(exception);
        }
    }
}

