/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.dialogs;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.DefaultFocusManager;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.border.GrayPane;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.help.HelpUnavailableException;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.dmt.dm4j.wizard.dialogs.DM4JEvent;

public class DM4JDialog
extends JDialog {
    public static final int BUTTON_NONE = 0;
    public static final int BUTTON_OK = 1;
    public static final int BUTTON_CANCEL = 2;
    public static final int BUTTON_HELP = 4;
    public static final int BUTTON_APPLY = 8;
    public static final int BUTTON_DEFAULT = 7;
    public static final String PROPERTY_CLOSED = "closed";
    public static final String ACTION_APPLY = "apply";
    public static final String ACTION_OK = "ok";
    public static final String ACTION_CANCEL = "cancel";
    private static boolean _IS_LINUX;
    private static int _MAX_DEFAULT_WIDTH;
    private static int _MAX_DEFAULT_HEIGHT;
    private static final Border _sOuterBorder;
    private static final Border _sInnerBorder;
    private static final String _RESOURCE = "oracle.bali.ewt.resource.JEWTBundle";
    private static final String _KEY_APPLY = "WIZARD.APPLY";
    private static final String _KEY_OK = "OK";
    private static final String _KEY_CANCEL = "CANCEL";
    private static final String _KEY_HELP = "HELP";
    private int _buttonMask;
    private Vector _buttons = new Vector();
    private DialogButtonBar _bar;
    private GrayPane _pane;
    private JPanel _contentContainer;
    private JButton _ok;
    private JButton _apply;
    private JButton _cancel;
    private JButton _help;
    private int _defaultButtonIndex;
    private boolean _cancelled;
    private UIListener _listener;
    private Component _centerOver;
    private PropertyChangeSupport _propertyChangeSupport;
    private VetoableChangeSupport _vetoableChangeSupport;
    private Component _initialFocus;
    private ListenerManager _actionListeners;
    private JButton _defaultButton;
    private int _prefWidth;
    private int _prefHeight;
    private int _initialWidth = -1;
    private int _initialHeight = -1;
    private boolean _isOKDefaulted = true;
    private boolean _isCancelDefaulted = true;
    protected boolean _isDialogBusy = false;
    protected Cursor _originalCursor = this.getCursor();

    public static DM4JDialog createDialog(Component component, String string, int n) {
        DM4JDialog dM4JDialog = null;
        while (component != null) {
            if (component instanceof Dialog) {
                dM4JDialog = new DM4JDialog((Dialog)component, string, n);
                break;
            }
            if (component instanceof Frame) {
                dM4JDialog = new DM4JDialog((Frame)component, string, n);
                break;
            }
            component = SwingUtilities.getWindowAncestor(component);
        }
        if (dM4JDialog == null) {
            dM4JDialog = new DM4JDialog((Frame)null, string, n);
        }
        return dM4JDialog;
    }

    public DM4JDialog() {
        this((Frame)null);
    }

    public DM4JDialog(Frame frame) {
        this(frame, "DM4JDialog");
    }

    public DM4JDialog(Frame frame, String string) {
        this(frame, string, 1);
    }

    public DM4JDialog(Frame frame, String string, int n) {
        super(frame, string);
        WindowUtils.registerWindow((Window)this);
        this.addListener();
        this.setModal(true);
        this.setResizable(false);
        this._buttonMask = n;
        this.dialogInit();
        this.setDefaultButton(1);
    }

    public DM4JDialog(Dialog dialog) {
        this(dialog, "DM4JDialog");
    }

    public DM4JDialog(Dialog dialog, String string) {
        this(dialog, string, 1);
    }

    public DM4JDialog(Dialog dialog, String string, int n) {
        super(dialog, string);
        WindowUtils.registerWindow((Window)this);
        this.addListener();
        this.setModal(true);
        this.setResizable(false);
        this._buttonMask = n;
        this.dialogInit();
        this.setDefaultButton(1);
    }

    public Component getCenterOver() {
        return this._centerOver;
    }

    public void setCenterOver(Component component) {
        this._centerOver = component;
    }

    public boolean isCancelled() {
        return this._cancelled;
    }

    public boolean runDialog() {
        this._initStrings();
        this._initialWidth = -1;
        this._initialHeight = -1;
        this.pack();
        Component component = this.getCenterOver();
        if (component == null) {
            component = this.getParent();
        }
        WindowUtils.centerWindow((Window)this, (Component)component);
        this._cancelled = false;
        this._initialWidth = this.getWidth();
        this._initialHeight = this.getHeight();
        this.setVisible(true);
        return !this._cancelled;
    }

    public void dispose() {
        if (this._contentContainer == null) {
            return;
        }
        WindowUtils.unregisterWindow((Window)this);
        this.setCenterOver(null);
        this.setContent(null);
        this._contentContainer = null;
        this._bar.removeAll();
        this._bar = null;
        this._buttons.removeAllElements();
        this._buttons = null;
        if (this._ok != null) {
            this._ok.removeActionListener(this._listener);
            this._ok.removeFocusListener(this._listener);
        }
        if (this._cancel != null) {
            this._cancel.removeActionListener(this._listener);
            this._cancel.removeFocusListener(this._listener);
        }
        if (this._help != null) {
            this._help.removeActionListener(this._listener);
            this._help.removeFocusListener(this._listener);
        }
        if (this._apply != null) {
            this._apply.removeActionListener(this._listener);
            this._apply.removeFocusListener(this._listener);
        }
        this._listener = null;
        this._apply = null;
        this._help = null;
        this._cancel = null;
        this._ok = null;
        this._defaultButton = null;
        this._pane.setContent(null);
        this._pane = null;
        super.dispose();
    }

    public final void setPreferredSize(Dimension dimension) {
        if (dimension == null) {
            dimension = new Dimension(-1, -1);
        }
        this.setPreferredSize(dimension.width, dimension.height);
    }

    public void setPreferredSize(int n, int n2) {
        this._prefWidth = n;
        this._prefHeight = n2;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = null;
        dimension = this._prefWidth != -1 && this._prefHeight != -1 ? new Dimension(this._prefWidth, this._prefHeight) : super.getPreferredSize();
        if (dimension.width > _MAX_DEFAULT_WIDTH) {
            dimension.width = _MAX_DEFAULT_WIDTH;
        }
        if (dimension.height > _MAX_DEFAULT_HEIGHT) {
            dimension.height = _MAX_DEFAULT_HEIGHT;
        }
        return dimension;
    }

    public Component getContent() {
        return this._contentContainer.getComponentCount() == 0 ? null : this._contentContainer.getComponent(0);
    }

    public void setContent(Component component) {
        boolean bl = this.getContent() instanceof JTabbedPane;
        this._contentContainer.removeAll();
        if (component instanceof JTabbedPane && !bl) {
            Container container = this.getContentPane();
            container.remove((Component)this._pane);
            container.add("Center", this._contentContainer);
            this._contentContainer.setBorder(null);
        } else if (bl) {
            Container container = this.getContentPane();
            container.remove(this._contentContainer);
            this._pane = new GrayPane((Component)this._contentContainer);
            container.add("Center", (Component)this._pane);
            this._contentContainer.setBorder(_sInnerBorder);
        }
        if (component != null) {
            this._contentContainer.add("Center", component);
        }
        this._contentContainer.revalidate();
    }

    public int getButtonMask() {
        return this._buttonMask;
    }

    public void setButtonMask(int n) {
        if (n > 15) {
            throw new IllegalArgumentException("Button Mask out of range");
        }
        if (n != this._buttonMask) {
            int n2 = this._buttonMask & ~n;
            if ((n2 & 1) > 0) {
                this._removeOk(this._bar);
            }
            if ((n2 & 2) > 0) {
                this._removeCancel(this._bar);
            }
            if ((n2 & 4) > 0) {
                this._removeHelp(this._bar);
            }
            if ((n2 & 8) > 0) {
                this._removeApply(this._bar);
            }
            this._buttonMask = n;
            Locale locale = LocaleUtils.getDefaultableLocale((Component)this);
            ResourceBundle resourceBundle = ResourceBundle.getBundle(_RESOURCE, locale);
            if ((this._buttonMask & 1) > 0) {
                this._addOk(resourceBundle, this._bar);
            }
            if ((this._buttonMask & 2) > 0) {
                this._addCancel(resourceBundle, this._bar);
            }
            if ((this._buttonMask & 4) > 0) {
                this._addHelp(resourceBundle, this._bar);
            }
            if ((this._buttonMask & 8) > 0) {
                this._addApply(resourceBundle, this._bar);
            }
            this._contentContainer.revalidate();
        }
    }

    public void addCustomButton(Component component) {
        if (!this._buttons.contains(component)) {
            this._bar.add(component);
            this._buttons.addElement(component);
        }
    }

    public void removeCustomButton(Component component) {
        this._bar.remove(component);
        this._buttons.removeElement(component);
    }

    public int getCustomButtonCount() {
        return this._buttons.size();
    }

    public Component getCustomButton(int n) {
        if (this.getCustomButtonCount() > n) {
            return (Component)this._buttons.elementAt(n);
        }
        return null;
    }

    public int getDefaultButton() {
        return this._defaultButtonIndex;
    }

    public void setDefaultButton(int n) {
        if (n < 0 || n > 8) {
            throw new IllegalArgumentException("Undefined button constant");
        }
        if (n != this._defaultButtonIndex) {
            JButton jButton = this.getRootPane().getDefaultButton();
            if (jButton != null) {
                jButton.setDefaultCapable(false);
            }
            switch (n) {
                case 1: {
                    this._defaultButton = this._ok;
                    break;
                }
                case 2: {
                    this._defaultButton = this._cancel;
                    break;
                }
                case 4: {
                    this._defaultButton = this._help;
                    break;
                }
                case 8: {
                    this._defaultButton = this._apply;
                    break;
                }
                default: {
                    this._defaultButton = null;
                }
            }
            this._defaultButtonIndex = n;
            this.getRootPane().setDefaultButton(this._defaultButton);
            if (this._defaultButton != null) {
                this._defaultButton.setDefaultCapable(true);
            }
        }
    }

    public void setOKButtonEnabled(boolean bl) {
        if (this._ok != null) {
            this._ok.setEnabled(bl);
        }
    }

    public boolean isOKButtonEnabled() {
        return this._ok != null ? this._ok.isEnabled() : false;
    }

    public void setOKButtonText(String string) {
        if (this._ok == null) {
            this.setButtonMask(this.getButtonMask() | 1);
        }
        this._ok.setText(StringUtils.stripMnemonic((String)string));
        this._ok.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this._isOKDefaulted = false;
    }

    public String getOKButtonText() {
        return this._ok != null ? this._ok.getText() : null;
    }

    public int getOKButtonMnemonic() {
        return this._ok != null ? this._ok.getMnemonic() : -1;
    }

    public void setOKButtonMnemonic(int n) {
        if (this._ok == null) {
            this.setButtonMask(this.getButtonMask() | 1);
        }
        this._ok.setMnemonic(n);
    }

    public void setCancelButtonText(String string) {
        if (this._cancel == null) {
            this.setButtonMask(this.getButtonMask() | 2);
        }
        this._cancel.setText(StringUtils.stripMnemonic((String)string));
        this._cancel.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this._isCancelDefaulted = false;
    }

    public String getCancelButtonText() {
        return this._cancel != null ? this._cancel.getText() : null;
    }

    public int getCancelButtonMnemonic() {
        return this._cancel != null ? this._cancel.getMnemonic() : -1;
    }

    public void setCancelButtonMnemonic(int n) {
        if (this._cancel == null) {
            this.setButtonMask(this.getButtonMask() | 2);
        }
        this._cancel.setMnemonic(n);
    }

    public void addActionListener(ActionListener actionListener) {
        if (this._actionListeners == null) {
            this._actionListeners = new ListenerManager();
        }
        this._actionListeners.addListener((EventListener)actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        if (this._actionListeners != null) {
            this._actionListeners.removeListener((EventListener)actionListener);
        }
    }

    public void addNotify() {
        super.addNotify();
        final Window window = WindowUtils.getWindow((Component)this);
        window.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                if (DM4JDialog.this._initialFocus != null) {
                    DM4JDialog.this._initialFocus.requestFocus();
                } else {
                    Component component = DM4JDialog.this._getFirstFocusableComponent();
                    if (component != null) {
                        component.requestFocus();
                    } else if (DM4JDialog.this._defaultButton != null && DM4JDialog.this._defaultButton.isEnabled()) {
                        DM4JDialog.this._defaultButton.requestFocus();
                    } else if (DM4JDialog.this._ok != null && DM4JDialog.this._ok.isEnabled()) {
                        DM4JDialog.this._ok.requestFocus();
                    }
                }
                window.removeWindowListener(this);
            }
        });
    }

    public Component getInitialFocus() {
        return this._initialFocus;
    }

    public void setInitialFocus(Component component) {
        this._initialFocus = component;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propertyChangeSupport == null) {
            this._propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this._propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propertyChangeSupport != null) {
            this._propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this._vetoableChangeSupport == null) {
            this._vetoableChangeSupport = new VetoableChangeSupport(this);
        }
        this._vetoableChangeSupport.addVetoableChangeListener(vetoableChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this._vetoableChangeSupport != null) {
            this._vetoableChangeSupport.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public static boolean isDialogClosingEvent(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        Object object2 = propertyChangeEvent.getOldValue();
        return PROPERTY_CLOSED.equals(string) && Boolean.TRUE.equals(object) && Boolean.FALSE.equals(object2);
    }

    public void pack() {
        if (_IS_LINUX && !this.isResizable()) {
            this._kdePackFix();
        } else {
            super.pack();
        }
    }

    public void setDialogBusy(boolean bl) {
        this._isDialogBusy = bl;
        if (bl) {
            this._originalCursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.setCursor(this._originalCursor);
        }
    }

    public boolean getDialogBusy() {
        return this._isDialogBusy;
    }

    protected void processComponentEvent(ComponentEvent componentEvent) {
        int n;
        int n2;
        super.processComponentEvent(componentEvent);
        if (componentEvent.getID() != 101) {
            return;
        }
        int n3 = n2 = this.getWidth();
        int n4 = n = this.getHeight();
        if (this._initialWidth != -1) {
            n3 = Math.max(this._initialWidth, n3);
        }
        if (this._initialHeight != -1) {
            n4 = Math.max(this._initialHeight, n4);
        }
        if (n2 != n3 || n != n4) {
            this.setSize(n3, n4);
        }
    }

    protected void dialogInit() {
        super.dialogInit();
        this.enableEvents(1L);
        this.setPreferredSize(-1, -1);
        this.setResizable(false);
        Locale locale = LocaleUtils.getDefaultableLocale((Component)this);
        ResourceBundle resourceBundle = ResourceBundle.getBundle(_RESOURCE, locale);
        this._listener = new UIListener();
        this._contentContainer = new JPanel(new BorderLayout());
        this._contentContainer.setBorder(_sInnerBorder);
        this._pane = new GrayPane((Component)this._contentContainer);
        this._bar = new DialogButtonBar();
        if ((this._buttonMask & 1) > 0) {
            this._addOk(resourceBundle, this._bar);
        }
        if ((this._buttonMask & 2) > 0) {
            this._addCancel(resourceBundle, this._bar);
        }
        if ((this._buttonMask & 4) > 0) {
            this._addHelp(resourceBundle, this._bar);
        }
        if ((this._buttonMask & 8) > 0) {
            this._addApply(resourceBundle, this._bar);
        }
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.setLayout(new BorderLayout(0, 8));
        jComponent.setBorder(_sOuterBorder);
        jComponent.add("Center", (Component)this._pane);
        jComponent.add("South", (Component)this._bar);
        Color color = UIManager.getColor("EWTDialog.background");
        if (color != null) {
            this.setBackground(color);
            this.getContentPane().setBackground(color);
        }
        this.enableEvents(64L);
        this._registerKeyboardActions();
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            this.dismissDialog(true);
        }
    }

    protected void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        if (this._vetoableChangeSupport != null) {
            this._vetoableChangeSupport.fireVetoableChange(string, object, object2);
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this._propertyChangeSupport != null) {
            this._propertyChangeSupport.firePropertyChange(string, object, object2);
        }
    }

    protected void dismissDialog(boolean bl) {
        if (!bl) {
            try {
                this.fireVetoableChange(PROPERTY_CLOSED, Boolean.FALSE, Boolean.TRUE);
            }
            catch (PropertyVetoException propertyVetoException) {
                return;
            }
        }
        this._cancelled = bl;
        if (this.isVisible()) {
            this.setVisible(false);
        }
        this.firePropertyChange(PROPERTY_CLOSED, Boolean.FALSE, Boolean.TRUE);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        if (this._actionListeners == null) {
            return;
        }
        Enumeration enumeration = this._actionListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (actionEvent.getID()) {
            case 1001: {
                while (enumeration.hasMoreElements()) {
                    ((ActionListener)enumeration.nextElement()).actionPerformed(actionEvent);
                }
                break;
            }
        }
    }

    void fireHelpEvent() {
        try {
            Component component = this.getContent();
            if (component == null) {
                component = this;
            }
            HelpUtils.showHelp((Component)component);
        }
        catch (HelpUnavailableException helpUnavailableException) {
            // empty catch block
        }
    }

    private Component _getFirstFocusableComponent() {
        Component component;
        Container container = null;
        Component component2 = this.getContent();
        if (component2 != null && component2.isEnabled() && component2.isVisible() && component2.isFocusable()) {
            return component2;
        }
        container = component2 instanceof Container ? (Container)component2 : this.getRootPane();
        Component component3 = component = container.getComponentCount() == 0 ? null : container.getComponent(0);
        if (component == null) {
            return null;
        }
        DefaultFocusManager defaultFocusManager = new DefaultFocusManager();
        HashSet<Component> hashSet = new HashSet<Component>();
        while ((component = this.getNextComponent(component, container, true, defaultFocusManager)) != null) {
            if (!hashSet.add(component)) {
                component = null;
                break;
            }
            if (!component.isVisible() || !component.isFocusable() || !component.isEnabled()) continue;
        }
        return component;
    }

    private Component getNextComponent(Component component, Container container, boolean bl, DefaultFocusManager defaultFocusManager) {
        Component component2 = null;
        if (bl && component.isVisible() && component instanceof Container && ((Container)component).getComponentCount() > 0) {
            return defaultFocusManager.getFirstComponent((Container)component);
        }
        Container container2 = component.getParent();
        component2 = defaultFocusManager.getComponentAfter(container2, component);
        if (component2 != null) {
            return component2;
        }
        if (container2 == container) {
            return container;
        }
        return this.getNextComponent(container2, container, false, defaultFocusManager);
    }

    private void _registerKeyboardActions() {
        JRootPane jRootPane = this.getRootPane();
        jRootPane.registerKeyboardAction(this._listener, _KEY_CANCEL, KeyStroke.getKeyStroke(27, 0), 1);
        jRootPane.registerKeyboardAction(this._listener, _KEY_HELP, KeyStroke.getKeyStroke(112, 0), 1);
        jRootPane.registerKeyboardAction(this._listener, _KEY_HELP, KeyStroke.getKeyStroke(156, 0), 1);
    }

    private void _unregisterKeyboardActions() {
        JRootPane jRootPane = this.getRootPane();
        jRootPane.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
        jRootPane.unregisterKeyboardAction(KeyStroke.getKeyStroke(112, 0));
        jRootPane.unregisterKeyboardAction(KeyStroke.getKeyStroke(156, 0));
    }

    private void _initStrings() {
        String string;
        Locale locale = LocaleUtils.getDefaultableLocale((Component)this);
        ResourceBundle resourceBundle = ResourceBundle.getBundle(_RESOURCE, locale);
        if (this._ok != null && this._isOKDefaulted) {
            string = resourceBundle.getString(_KEY_OK);
            this._ok.setText(StringUtils.stripMnemonic((String)string));
            this._ok.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        }
        if (this._apply != null) {
            string = resourceBundle.getString(_KEY_APPLY);
            this._apply.setText(StringUtils.stripMnemonic((String)string));
            this._apply.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        }
        if (this._cancel != null && this._isCancelDefaulted) {
            string = resourceBundle.getString(_KEY_CANCEL);
            this._cancel.setText(StringUtils.stripMnemonic((String)string));
            this._cancel.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        }
        if (this._help != null) {
            string = resourceBundle.getString(_KEY_HELP);
            this._help.setText(StringUtils.stripMnemonic((String)string));
            this._help.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        }
    }

    private void _addOk(ResourceBundle resourceBundle, DialogButtonBar dialogButtonBar) {
        if (this._ok == null) {
            String string = resourceBundle.getString(_KEY_OK);
            this._ok = new JButton(StringUtils.stripMnemonic((String)string));
            this._ok.setDefaultCapable(true);
            this._ok.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            this._ok.setActionCommand(_KEY_OK);
            this._ok.addActionListener(this._listener);
            this._ok.addFocusListener(this._listener);
        }
        dialogButtonBar.add((Component)this._ok, DialogButtonBar.CONSTRAINT_YES);
    }

    private void _addApply(ResourceBundle resourceBundle, DialogButtonBar dialogButtonBar) {
        if (this._apply == null) {
            String string = resourceBundle.getString(_KEY_APPLY);
            this._apply = new JButton(StringUtils.stripMnemonic((String)string));
            this._apply.setDefaultCapable(false);
            this._apply.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            this._apply.setActionCommand(_KEY_APPLY);
            this._apply.addActionListener(this._listener);
            this._apply.addFocusListener(this._listener);
        }
        dialogButtonBar.add((Component)this._apply, DialogButtonBar.CONSTRAINT_APPLY);
    }

    private void _addCancel(ResourceBundle resourceBundle, DialogButtonBar dialogButtonBar) {
        if (this._cancel == null) {
            String string = resourceBundle.getString(_KEY_CANCEL);
            this._cancel = new JButton(StringUtils.stripMnemonic((String)string));
            this._cancel.setDefaultCapable(false);
            this._cancel.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            this._cancel.setActionCommand(_KEY_CANCEL);
            this._cancel.addActionListener(this._listener);
            this._cancel.addFocusListener(this._listener);
        }
        dialogButtonBar.add((Component)this._cancel, DialogButtonBar.CONSTRAINT_CANCEL);
    }

    private void _addHelp(ResourceBundle resourceBundle, DialogButtonBar dialogButtonBar) {
        if (this._help == null) {
            String string = resourceBundle.getString(_KEY_HELP);
            this._help = new JButton(StringUtils.stripMnemonic((String)string));
            this._help.setDefaultCapable(false);
            this._help.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            this._help.setActionCommand(_KEY_HELP);
            this._help.addActionListener(this._listener);
            this._help.addFocusListener(this._listener);
        }
        dialogButtonBar.add((Component)this._help, DialogButtonBar.CONSTRAINT_HELP);
    }

    private void _removeOk(DialogButtonBar dialogButtonBar) {
        dialogButtonBar.remove((Component)this._ok);
    }

    private void _removeApply(DialogButtonBar dialogButtonBar) {
        dialogButtonBar.remove((Component)this._apply);
    }

    private void _removeCancel(DialogButtonBar dialogButtonBar) {
        dialogButtonBar.remove((Component)this._cancel);
    }

    private void _removeHelp(DialogButtonBar dialogButtonBar) {
        dialogButtonBar.remove((Component)this._help);
    }

    private void _kdePackFix() {
        this.setResizable(true);
        super.pack();
        this.setResizable(false);
    }

    private void addListener() {
        this.addMouseListener(new DM4JDialogMouseListener());
    }

    static {
        _MAX_DEFAULT_WIDTH = 800;
        _MAX_DEFAULT_HEIGHT = 700;
        String string = System.getProperty("os.name");
        _IS_LINUX = string != null && string.indexOf("Linux") != -1;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (dimension.width < _MAX_DEFAULT_WIDTH) {
            _MAX_DEFAULT_WIDTH = dimension.width;
        }
        if (dimension.height < _MAX_DEFAULT_HEIGHT) {
            _MAX_DEFAULT_HEIGHT = dimension.height;
        }
        _sOuterBorder = new EmptyBorder(6, 6, 8, 6);
        _sInnerBorder = new EmptyBorder(10, 10, 10, 10);
    }

    public class DM4JDialogMouseListener
    extends MouseAdapter {
        public void mouseEntered(MouseEvent mouseEvent) {
            if (DM4JDialog.this._isDialogBusy) {
                DM4JDialog.this.setCursor(Cursor.getPredefinedCursor(3));
            }
        }
    }

    private class UIListener
    implements ActionListener,
    FocusListener {
        private UIListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            JButton jButton;
            JButton jButton2 = DM4JDialog.this.getRootPane().getDefaultButton();
            if (jButton2 != (jButton = (JButton)focusEvent.getSource())) {
                if (jButton2 != null) {
                    jButton2.setDefaultCapable(false);
                }
                jButton.setDefaultCapable(true);
                DM4JDialog.this.getRootPane().setDefaultButton(jButton);
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            JButton jButton;
            if (!focusEvent.isTemporary() && (jButton = (JButton)focusEvent.getSource()) != DM4JDialog.this._defaultButton) {
                jButton.setDefaultCapable(false);
                DM4JDialog.this.getRootPane().setDefaultButton(DM4JDialog.this._defaultButton);
                if (DM4JDialog.this._defaultButton != null) {
                    DM4JDialog.this._defaultButton.setDefaultCapable(true);
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (DM4JDialog._KEY_OK.equals(string)) {
                DM4JEvent dM4JEvent = new DM4JEvent(DM4JDialog.this, 1001, DM4JDialog.ACTION_OK);
                DM4JDialog.this.processEvent(dM4JEvent);
                if (!dM4JEvent.isCancelled()) {
                    DM4JDialog.this.dismissDialog(false);
                }
            } else if (DM4JDialog._KEY_APPLY.equals(string)) {
                DM4JEvent dM4JEvent = new DM4JEvent(DM4JDialog.this, 1001, DM4JDialog.ACTION_APPLY);
                DM4JDialog.this.processEvent(dM4JEvent);
            } else if (DM4JDialog._KEY_CANCEL.equals(string)) {
                DM4JEvent dM4JEvent = new DM4JEvent(DM4JDialog.this, 1001, DM4JDialog.ACTION_CANCEL);
                DM4JDialog.this.processEvent(dM4JEvent);
                DM4JDialog.this.dismissDialog(true);
            } else if (DM4JDialog._KEY_HELP.equals(string)) {
                DM4JDialog.this.fireHelpEvent();
            }
        }
    }
}

