/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.sqlworksheet;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.sqlworksheet.DM4JToolButton;
import oracle.dmt.dm4j.sqlworksheet.DefaultResultSetNavigationBar;
import oracle.dmt.dm4j.sqlworksheet.ResultSetTableModel;
import oracle.dmt.dm4j.sqlworksheet.SqlEditor;
import oracle.dmt.dm4j.sqlworksheet.ToggleAction;
import oracle.dmt.dm4j.sqlworksheet.Toolbar;

public class SqlEditorMainPanel
extends JPanel {
    private static final String RESULT_PANEL_DATA = "Data";
    private static final String RESULT_PANEL_EXPLAIN = "Explain";
    private static final String RESULT_PANEL_TEXT = "Text";
    BorderLayout borderLayout1 = new BorderLayout();
    JSplitPane spMain = new JSplitPane();
    JPanel northPanel = new JPanel();
    JPanel southPane = new JPanel();
    JPanel southDataPanel = new JPanel();
    JPanel southTextPanel = new JPanel();
    JEditorPane textPanelArea = new JEditorPane();
    JScrollPane spTextPanelArea = new JScrollPane(this.textPanelArea, 22, 32);
    JPanel southPlanPanel = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    Toolbar toolBar = new Toolbar((JFrame)this.getParent());
    JEditorPane taSql = new JEditorPane();
    JScrollPane spSql = new JScrollPane(this.taSql, 22, 32);
    JTable tblResults = new JTable();
    JScrollPane spResults = new JScrollPane(this.tblResults, 22, 30);
    BorderLayout southDataLayout = new BorderLayout();
    BorderLayout southTextLayout = new BorderLayout();
    BorderLayout southPlanLayout = new BorderLayout();
    DM4JToolButton btnExecute = null;
    DM4JToolButton btnHistory = null;
    Border northBorder = BorderFactory.createTitledBorder(DM4JResourceUtilities.getUIString("SQLW_EDITOR_ENTER"));
    Border southDataBorder = BorderFactory.createTitledBorder(DM4JResourceUtilities.getUIString("SQLW_RESULTS_RESULTS"));
    Border southTextBorder = BorderFactory.createTitledBorder(DM4JResourceUtilities.getUIString("SQLW_RESULTS_RESULTS"));
    Border southPlanBorder = BorderFactory.createTitledBorder(DM4JResourceUtilities.getUIString("SQLW_RESULTS_EXPLAIN"));
    DefaultResultSetNavigationBar navBar = new DefaultResultSetNavigationBar();
    ResultSetTableModel _dataModel = null;
    private SqlEditor _editor = null;

    public SqlEditorMainPanel(SqlEditor sqlEditor) {
        try {
            this._editor = sqlEditor;
            this.jbInit();
            this.postInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.btnExecute.setEnabled(bl);
        this.btnHistory.setEnabled(bl);
        this.taSql.setEditable(bl);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.spMain.setOrientation(0);
        this.northPanel.setBorder(this.northBorder);
        this.southDataPanel.setBorder(this.southDataBorder);
        this.southDataPanel.setLayout(this.southDataLayout);
        this.southTextPanel.setBorder(this.southTextBorder);
        this.southTextPanel.setLayout(this.southTextLayout);
        this.southPlanPanel.setBorder(this.southPlanBorder);
        this.southPlanPanel.setLayout(this.southPlanLayout);
        Font font = this.taSql.getFont();
        Font font2 = new Font(font.getName(), font.getStyle(), 13);
        this.taSql.setFont(font2);
        this.taSql.setText("");
        this.textPanelArea.setText("");
        this.btnHistory = new DM4JToolButton(new ToggleAction("History", IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/history.gif")));
        this.btnExecute = new DM4JToolButton(new ToggleAction("Execute", IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/run.gif")));
        this.toolBar.add((Component)this.btnExecute, null);
        this.toolBar.add((Component)this.btnHistory, null);
        this.btnHistory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SqlEditorMainPanel.this._editor.doHistoryList();
            }
        });
        this.btnExecute.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SqlEditorMainPanel.this._editor.executeSql();
            }
        });
        this.northPanel.setLayout(this.borderLayout2);
        this.northPanel.add((Component)this.toolBar, "North");
        this.northPanel.add((Component)this.spSql, "Center");
        this.northPanel.setPreferredSize(new Dimension(200, 200));
        this.spMain.setLeftComponent(this.northPanel);
        this.southPane.setLayout(new CardLayout());
        this.southPane.add(RESULT_PANEL_DATA, this.southDataPanel);
        this.southDataPanel.add((Component)this.navBar, "North");
        this.southDataPanel.add((Component)this.spResults, "Center");
        this.southPane.add(RESULT_PANEL_EXPLAIN, this.southPlanPanel);
        this.southPane.add(RESULT_PANEL_TEXT, this.southTextPanel);
        this.southTextPanel.add((Component)this.spTextPanelArea, "Center");
        this.spMain.setRightComponent(this.southPane);
        this.spMain.revalidate();
        this.spMain.setDividerLocation(150);
        this.add((Component)this.spMain, "Center");
        this.tblResults.setAutoResizeMode(0);
    }

    private void postInit() throws Exception {
        this.btnHistory.setToolTipText(DM4JResourceUtilities.getUIString("SQLW_MENU_FILE_HISTORY"));
        this.btnExecute.setToolTipText(DM4JResourceUtilities.getUIString("SQLW_MENU_FILE_EXECUTE"));
        this.tblResults.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
            }
        });
    }

    public String getSqlStatement() {
        String string;
        String string2 = this.taSql.getSelectedText();
        String string3 = string = null != string2 ? string2 : this.taSql.getText();
        if (string == null) {
            return string;
        }
        return this._stripCarriageReturns(string.trim());
    }

    private String _stripCarriageReturns(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '\r') continue;
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }

    public void setSqlStatement(String string) {
        this.taSql.setText(string);
    }

    public final void setResultSet(ResultSet resultSet, String string, boolean bl, Connection connection, String string2) {
        this._closeTableModel();
        if (resultSet == null) {
            this._setResultSetText(string, bl);
        } else {
            this._setResultSetData(resultSet, string2);
        }
    }

    private final void _setResultSetData(ResultSet resultSet, String string) {
        int n = 10;
        Object var4_4 = null;
        Object var5_5 = null;
        try {
            this._dataModel = new ResultSetTableModel(resultSet, string, this.navBar);
            this.tblResults.setModel(this._dataModel);
            this._showResultPane(RESULT_PANEL_DATA);
        }
        catch (SQLException sQLException) {
            this._setResultSetText(sQLException.getMessage(), false);
        }
    }

    private void _closeTableModel() {
        if (this._dataModel != null) {
            this._dataModel.close();
            this._dataModel = null;
        }
    }

    private final void _setResultSetText(String string, boolean bl) {
        if (bl) {
            String string2 = string.equals("0") || string.equals("-1") ? DM4JResourceUtilities.getUIString("SQLW_RESULTS_COMPLETED") : (string.equals("1") ? DM4JResourceUtilities.getUIString("SQLW_RESULTS_ONEROW") : DM4JResourceUtilities.getUIString("SQLW_RESULTS_ROWS") + " " + string);
            this.textPanelArea.setEditable(true);
            this.textPanelArea.setText(string2);
            this.textPanelArea.setEditable(false);
        } else {
            this.textPanelArea.setEditable(true);
            this.textPanelArea.setText(string);
            this.textPanelArea.setEditable(false);
        }
        this._showResultPane(RESULT_PANEL_TEXT);
    }

    public final void explainPlan(Connection connection, String string) {
    }

    private void _showResultPane(String string) {
        CardLayout cardLayout = (CardLayout)this.southPane.getLayout();
        cardLayout.show(this.southPane, string);
    }
}

