/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.sqlworksheet;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.viewer.export.ExportDialog;
import oracle.dmt.dm4j.sqlworksheet.ResultSetNavigationBar;
import oracle.dmt.dm4j.sqlworksheet.ResultSetNavigationEvent;
import oracle.dmt.dm4j.sqlworksheet.ResultSetNavigationListener;

public class ResultSetTableModel
extends AbstractTableModel {
    private Connection _conn;
    private String _sql;
    private ResultSet _rs;
    private Statement _stmt;
    private ArrayList _colNames;
    private ArrayList _rows;
    private ResultSetNavigationBar _bar;
    private List _listenerList = Collections.synchronizedList(new ArrayList());
    private ActionListener _fetchActionListener;
    private ActionListener _refreshActionListener;
    private ActionListener _exportActionListener;

    public ResultSetTableModel(Connection connection, String string, ResultSetNavigationBar resultSetNavigationBar, boolean bl) {
        this._conn = connection;
        this._sql = string;
        this.setBar(resultSetNavigationBar);
        if (bl) {
            this.open();
        }
    }

    public ResultSetTableModel(ResultSet resultSet, String string, ResultSetNavigationBar resultSetNavigationBar) throws SQLException {
        this._rs = resultSet;
        this._stmt = resultSet.getStatement();
        this._conn = this._stmt.getConnection();
        this._sql = string;
        this.setBar(resultSetNavigationBar);
        this.open();
    }

    public void setBar(ResultSetNavigationBar resultSetNavigationBar) {
        if (resultSetNavigationBar != this._bar) {
            if (this._bar != null) {
                this.removeResultSetNavigationListener(this._bar);
                this._bar.removeFetchActionListener(this._fetchActionListener);
                this._bar.removeRefreshActionListener(this._refreshActionListener);
                this._bar.removeExportActionListener(this._exportActionListener);
                this._fetchActionListener = null;
                this._refreshActionListener = null;
                this._exportActionListener = null;
            }
            if (resultSetNavigationBar != null) {
                this._fetchActionListener = new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ResultSetTableModel.this._fetchNext();
                    }
                };
                resultSetNavigationBar.addFetchActionListener(this._fetchActionListener);
                this._refreshActionListener = new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ResultSetTableModel.this._refresh();
                    }
                };
                resultSetNavigationBar.addRefreshActionListener(this._refreshActionListener);
                this._exportActionListener = new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ResultSetTableModel.this._export();
                    }
                };
                resultSetNavigationBar.addExportActionListener(this._exportActionListener);
                this.addResultSetNavigationListener(resultSetNavigationBar);
            }
            this._bar = resultSetNavigationBar;
        }
    }

    public boolean open() {
        try {
            if (this._stmt == null) {
                this._stmt = this._conn.createStatement();
            }
            if (this._rs == null) {
                this._rs = this._stmt.executeQuery(this._sanitizeOracleSQL(this._sql));
            }
            this._createColumnNamesList();
            this.fireTableStructureChanged();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        try {
            if (this._bar != null) {
                this._bar.setFetchEnabled(true);
                this._bar.setRefreshEnabled(true);
                this._bar.setExportEnabled(true);
            }
            this._fetchNext();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private void _cleanup() {
        this._rows = null;
        try {
            if (this._rs != null) {
                this._rs.close();
            }
            this._rs = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean close() {
        this._cleanup();
        try {
            if (this._stmt != null) {
                this._stmt.close();
            }
            this._stmt = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this._bar != null) {
            this._bar.setFetchEnabled(false);
            this._bar.setRefreshEnabled(false);
            this._bar.setExportEnabled(false);
            this.setBar(null);
        }
        return true;
    }

    public int getRowCount() {
        if (this._rows != null) {
            return this._rows.size();
        }
        return 0;
    }

    public int getColumnCount() {
        return this._colNames != null ? this._colNames.size() : 0;
    }

    public String getColumnName(int n) {
        try {
            return (String)this._colNames.get(n);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object getValueAt(int n, int n2) {
        ArrayList arrayList;
        if (this._rows != null && (arrayList = (ArrayList)this._rows.get(n)) != null) {
            return arrayList.get(n2);
        }
        return null;
    }

    public void addResultSetNavigationListener(ResultSetNavigationListener resultSetNavigationListener) {
        this._listenerList.add(resultSetNavigationListener);
    }

    public void removeResultSetNavigationListener(ResultSetNavigationListener resultSetNavigationListener) {
        this._listenerList.remove(resultSetNavigationListener);
    }

    protected void fireFetchNextPerformed(int n) {
        ResultSetNavigationEvent resultSetNavigationEvent = new ResultSetNavigationEvent(this, this._bar.getFetchSize());
        resultSetNavigationEvent.setNumberFetched(n);
        Iterator iterator = this._listenerList.iterator();
        try {
            while (iterator.hasNext()) {
                ((ResultSetNavigationListener)iterator.next()).fetchNextPerformed(resultSetNavigationEvent);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void fireRefreshPerformed() {
        ResultSetNavigationEvent resultSetNavigationEvent = new ResultSetNavigationEvent(this, this._bar.getFetchSize());
        Iterator iterator = this._listenerList.iterator();
        try {
            while (iterator.hasNext()) {
                ((ResultSetNavigationListener)iterator.next()).refreshPerformed(resultSetNavigationEvent);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String _sanitizeOracleSQL(String string) {
        String string2 = string.trim();
        String string3 = string2.toUpperCase();
        if (string2.endsWith(";") && !string3.endsWith("END;")) {
            string2 = string2.substring(0, string2.lastIndexOf(";"));
        }
        return string2;
    }

    private void _createColumnNamesList() throws SQLException {
        ResultSetMetaData resultSetMetaData = this._rs.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        this._colNames = new ArrayList(n);
        for (int i = 1; i <= n; ++i) {
            this._colNames.add(resultSetMetaData.getColumnLabel(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _fetchNext() {
        int n = 0;
        int n2 = this._rows != null ? this._rows.size() : 0;
        try {
            int n3 = this._colNames.size();
            for (int i = this._getFetchSize(); i > 0 && this._rs.next(); --i) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int j = 1; j <= n3; ++j) {
                    arrayList.add(this._rs.getString(j));
                }
                if (this._rows == null) {
                    this._rows = new ArrayList(100);
                }
                this._rows.add(arrayList);
                ++n;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        finally {
            this.fireTableStructureChanged();
            this.fireFetchNextPerformed(n);
        }
        return n;
    }

    private void _refresh() {
        this._cleanup();
        this.open();
    }

    private void _export() {
        try {
            DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
            ExportDialog exportDialog = new ExportDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("EXPORT_TITLE"));
            if (!exportDialog.isCancelled()) {
                exportDialog.export(new JTable(this));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private int _getFetchSize() {
        return this._bar != null ? this._bar.getFetchSize() : 100;
    }

    private String _getDataAsTabDelimitedText() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer(this.getRowCount() * this.getColumnCount() * 20);
        try {
            Iterator iterator = this._colNames.iterator();
            boolean bl = true;
            while (iterator.hasNext()) {
                if (!bl) {
                    stringBuffer.append("\t");
                } else {
                    bl = false;
                }
                object = iterator.next();
                stringBuffer.append(object != null ? object.toString() : "");
            }
            stringBuffer.append("\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            for (ArrayList arrayList : this._rows) {
                object = arrayList.iterator();
                boolean bl = true;
                while (object.hasNext()) {
                    if (!bl) {
                        stringBuffer.append("\t");
                    } else {
                        bl = false;
                    }
                    Object e = object.next();
                    stringBuffer.append(e != null ? e.toString() : "");
                }
                stringBuffer.append("\n");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuffer.toString();
    }
}

