/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.sqlworksheet;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicBorders;
import oracle.dmt.dm4j.sqlworksheet.PropertyChangeAdaptor;
import oracle.dmt.dm4j.sqlworksheet.ThinBevel;
import oracle.dmt.dm4j.sqlworksheet.ToggleAction;
import oracle.dmt.dm4j.sqlworksheet.ToolbarItem;

public class RadioToolButton
extends JRadioButton
implements ItemListener,
MouseListener,
ToolbarItem {
    private static final Insets _margin = new Insets(2, 2, 2, 2);
    private static final Border _raised = new CompoundBorder(new ThinBevel(0), new BasicBorders.MarginBorder());
    private static final Border _lowered = new CompoundBorder(new ThinBevel(1), new BasicBorders.MarginBorder());
    private static final Border _inactive = new CompoundBorder(new EmptyBorder(1, 1, 1, 1), new BasicBorders.MarginBorder());
    private Action _action;

    public RadioToolButton(ToggleAction toggleAction) {
        super((Icon)toggleAction.getValue("SmallIcon"), toggleAction.getState());
        this._action = toggleAction;
        this.setHorizontalAlignment(0);
        this.setBorderPainted(true);
        this.setBorder(_inactive);
        this.setMargin(_margin);
        this.setRequestFocusEnabled(false);
        this.addItemListener(this);
        this.addMouseListener(this);
        this.setEnabled(toggleAction.isEnabled());
        this.addActionListener(toggleAction);
        this.addItemListener(toggleAction);
        toggleAction.addPropertyChangeListener(new PropertyChangeAdaptor(this){

            public void stateChanged(PropertyChangeEvent propertyChangeEvent) {
                final Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (RadioToolButton.this.isSelected() != bl.booleanValue()) {
                            RadioToolButton.this.setSelected(bl);
                        }
                    }
                });
            }
        });
    }

    public final Action getAction() {
        return this._action;
    }

    public final void setAction(Action action) {
        if (this._action != null) {
            return;
        }
        this._action = action;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension != null) {
            if (dimension.width % 2 == 0) {
                ++dimension.width;
            }
            if (dimension.height % 2 == 0) {
                ++dimension.height;
            }
        }
        return dimension;
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Icon getDisabledSelectedIcon() {
        Icon icon = super.getDisabledSelectedIcon();
        return icon != null ? icon : this.getDisabledIcon();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.setBorder(this.isSelected() ? _lowered : _inactive);
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.isEnabled()) {
            this.setBorder(_raised);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.isSelected()) {
            this.setBorder(_lowered);
        } else {
            this.setBorder(_inactive);
        }
    }
}

