/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.sqlworksheet;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.sqlworksheet.ResultSetNavigationBar;
import oracle.dmt.dm4j.sqlworksheet.ResultSetNavigationEvent;
import oracle.dmt.dm4j.sqlworksheet.ResultSetNavigationListener;

public class DefaultResultSetNavigationBar
extends JPanel
implements ResultSetNavigationBar,
ResultSetNavigationListener {
    private NumberTextField _tfSize = new NumberTextField();
    private JLabel _lblSize = new JLabel("");
    private JButton _btnFetch = new JButton();
    private JButton _btnRefresh = new JButton();
    private JButton _btnExport = new JButton(IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/save.gif"));

    public DefaultResultSetNavigationBar() {
        this._tfSize.setDataType(Integer.TYPE);
        this._tfSize.setNumber((Number)new Integer(100));
        this._tfSize.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_TIP_POSITIVE_INTEGER"));
        this._tfSize.setSigned(false);
        this._tfSize.setColumns(5);
        String string = DM4JResourceUtilities.getUIString("COMMON_FETCH_SIZE");
        this._lblSize.setText(string);
        this._lblSize.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("TBLVIEW_DATA_FETCHSIZE"));
        this._lblSize.setLabelFor((Component)this._tfSize);
        string = DM4JResourceUtilities.getUIString("TBLVIEW_DATA_FETCHNEXT");
        this._btnFetch.setText(string);
        this._btnFetch.setMnemonic(DM4JResourceUtilities.getUIMnemonic("TBLVIEW_DATA_FETCHNEXT"));
        this._btnFetch.setToolTipText(DM4JResourceUtilities.getUIString("TBLVIEW_DATA_FETCHNEXT_TIP"));
        this._btnFetch.setEnabled(false);
        string = DM4JResourceUtilities.getUIString("TBLVIEW_DATA_REFRESH");
        this._btnRefresh.setText(string);
        this._btnRefresh.setMnemonic(DM4JResourceUtilities.getUIMnemonic("TBLVIEW_DATA_REFRESH"));
        this._btnRefresh.setToolTipText(DM4JResourceUtilities.getUIString("TBLVIEW_DATA_REFRESH_TIP"));
        this._btnRefresh.setEnabled(false);
        this._btnExport.setToolTipText(DM4JResourceUtilities.getUIString("COMMON_EXPORT"));
        this._btnExport.setEnabled(false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        this.add((Component)this._lblSize, gridBagConstraints);
        this.add((Component)this._tfSize, gridBagConstraints);
        this.add((Component)this._btnFetch, gridBagConstraints);
        this.add((Component)this._btnRefresh, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)new JLabel(""), gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        this.add((Component)this._btnExport, gridBagConstraints);
    }

    public void addFetchActionListener(ActionListener actionListener) {
        this._btnFetch.addActionListener(actionListener);
    }

    public void removeFetchActionListener(ActionListener actionListener) {
        this._btnFetch.removeActionListener(actionListener);
    }

    public void addRefreshActionListener(ActionListener actionListener) {
        this._btnRefresh.addActionListener(actionListener);
    }

    public void removeRefreshActionListener(ActionListener actionListener) {
        this._btnRefresh.removeActionListener(actionListener);
    }

    public void addExportActionListener(ActionListener actionListener) {
        this._btnExport.addActionListener(actionListener);
    }

    public void removeExportActionListener(ActionListener actionListener) {
        this._btnExport.removeActionListener(actionListener);
    }

    public void setFetchEnabled(boolean bl) {
        this._btnFetch.setEnabled(bl);
    }

    public void setRefreshEnabled(boolean bl) {
        this._btnRefresh.setEnabled(bl);
    }

    public void setExportEnabled(boolean bl) {
        this._btnExport.setEnabled(bl);
    }

    public int getFetchSize() {
        int n = 0;
        try {
            n = this._tfSize.getNumber().intValue();
        }
        catch (NumberFormatException numberFormatException) {
            n = 100;
        }
        return n;
    }

    public void fetchNextPerformed(ResultSetNavigationEvent resultSetNavigationEvent) {
        this._btnFetch.setEnabled(resultSetNavigationEvent.getNumberFetched() == resultSetNavigationEvent.getFetchSize());
    }

    public void refreshPerformed(ResultSetNavigationEvent resultSetNavigationEvent) {
        this._btnFetch.setEnabled(true);
    }
}

