/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.sql;

import java.sql.Connection;
import oracle.bali.ewt.event.Cancelable;
import oracle.dmt.dm4j.browser.LongRunningProcess;
import oracle.jdbc.OracleCallableStatement;

public class SQLProcess
extends LongRunningProcess
implements Cancelable {
    private boolean m_canceled = false;
    private Connection m_dbConn = null;
    private StringBuffer[] m_plsqls = null;
    private OracleCallableStatement m_statement = null;

    public SQLProcess(Connection connection, String string) {
        this.m_dbConn = connection;
        this.m_plsqls = new StringBuffer[1];
        this.m_plsqls[0] = new StringBuffer(string);
    }

    public SQLProcess(Connection connection, StringBuffer[] stringBufferArray) {
        this.m_dbConn = connection;
        this.m_plsqls = stringBufferArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            if (this.m_plsqls != null) {
                for (int i = 0; i < this.m_plsqls.length; ++i) {
                    String string = this.m_plsqls[i].toString();
                    this.m_statement = (OracleCallableStatement)this.m_dbConn.prepareCall(string);
                    this.m_statement.execute();
                    this.m_statement.close();
                }
            }
            this.getProgressBar().setDoneStatus();
        }
        catch (Exception exception) {
            this.setException(exception);
            this.getProgressBar().setDoneStatus();
        }
        finally {
            try {
                if (this.m_statement != null) {
                    this.m_statement.close();
                }
                if (this.m_dbConn != null) {
                    this.m_dbConn.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public boolean isCancelled() {
        return this.m_canceled;
    }

    public void cancel() {
        if (this.m_statement != null) {
            try {
                this.m_statement.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_canceled = true;
    }
}

