/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.querybuilder;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Connection;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.querybuilder.CreateViewDialog;
import oracle.dmt.dm4j.querybuilder.CreateViewState;
import oracle.dmt.dm4j.querybuilder.DM4JJDBCQueryBuilder;
import oracle.dmt.dm4j.sql.SQLProcess;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.director.transforms.TransformsDirector;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.help.CSHManager;
import oracle.help.Help;

public class DM4JQueryBuilder
extends JFrame {
    private static Dimension m_prefJoinBuilderSize = new Dimension(700, 500);
    private JMenuBar m_menuBar = new JMenuBar();
    private JMenu m_menuFile = new JMenu();
    private JMenuItem m_menuFileSave = new JMenuItem();
    private JMenuItem m_menuFileExit = new JMenuItem();
    private JMenu m_menuHelp = new JMenu();
    private JMenuItem m_menuHelpContents = new JMenuItem();
    private BorderLayout m_borderLayout = new BorderLayout();
    private OraConnection m_conn = null;
    private CSHManager m_helpCxtMgr = null;
    private DM4JJDBCQueryBuilder m_viewBuilder;
    private String m_sql = null;

    public DM4JQueryBuilder(OraConnection oraConnection) throws Exception {
        this.m_conn = oraConnection;
        this.jbInit();
    }

    private void jbInit() throws Exception {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (!DM4JQueryBuilder.this.cancel_actionPerformed(null)) {
                    try {
                        DM4JQueryBuilder.this.m_conn.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    Window window = windowEvent.getWindow();
                    window.setVisible(false);
                    window.dispose();
                }
            }
        });
        ImageIcon imageIcon = (ImageIcon)IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/client.gif");
        this.setIconImage(imageIcon.getImage());
        this.getContentPane().setLayout(this.m_borderLayout);
        this.setSize(m_prefJoinBuilderSize);
        this.setTitle(ResourceUtilities.getUILabel("CREATE_VIEW_BUILDER"));
        Help.registerClientWindow((Window)this);
        this.m_helpCxtMgr = BrowserFrame.getCSHManager();
        this.m_helpCxtMgr.addComponent((Component)this, "dm4j_createviewbuilder_html", true, false);
        this.setJMenuBar(this.m_menuBar);
        this.m_menuFileSave.setText(ResourceUtilities.getUILabel("CREATE_VIEW_BUILDER_CREATE_VIEW"));
        this.m_menuFileSave.setMnemonic(ResourceUtilities.getUIMnemonic("CREATE_VIEW_BUILDER_CREATE_VIEW"));
        this.m_menuFileSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DM4JQueryBuilder.this.create_actionPerformed(actionEvent);
            }
        });
        this.m_menuFileExit.setText(ResourceUtilities.getUILabel("CREATE_VIEW_BUILDER_EXIT"));
        this.m_menuFileExit.setMnemonic(ResourceUtilities.getUIMnemonic("CREATE_VIEW_BUILDER_EXIT"));
        this.m_menuFileExit.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        this.m_menuFileExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DM4JQueryBuilder.this.cancel_actionPerformed(actionEvent);
            }
        });
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, true);
        this.getRootPane().getInputMap(0).put(keyStroke, "CancelAction");
        this.getRootPane().getActionMap().put("CancelAction", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                DM4JQueryBuilder.this.cancel_actionPerformed(actionEvent);
            }
        });
        keyStroke = KeyStroke.getKeyStroke(112, 0, true);
        this.getRootPane().getInputMap(2).put(keyStroke, "HelpAction");
        this.getRootPane().getActionMap().put("HelpAction", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                DM4JQueryBuilder.this.help_actionPerformed(actionEvent);
            }
        });
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DM4JQueryBuilder.this.help_actionPerformed(actionEvent);
            }
        };
        this.m_menuHelpContents.setText(ResourceUtilities.getUILabel("CREATE_VIEW_BUILDER_HELP_CONTENTS"));
        this.m_menuHelpContents.setMnemonic(ResourceUtilities.getUIMnemonic("CREATE_VIEW_BUILDER_HELP_CONTENTS"));
        this.m_menuHelpContents.addActionListener(actionListener);
        this.m_menuFile.setText(ResourceUtilities.getUILabel("CREATE_VIEW_BUILDER_FILE"));
        this.m_menuFile.setMnemonic(ResourceUtilities.getUIMnemonic("CREATE_VIEW_BUILDER_FILE"));
        this.m_menuFile.add(this.m_menuFileSave);
        this.m_menuFile.addSeparator();
        this.m_menuFile.add(this.m_menuFileExit);
        this.m_menuHelp.setText(ResourceUtilities.getUILabel("CREATE_VIEW_BUILDER_HELP"));
        this.m_menuHelp.setMnemonic(ResourceUtilities.getUIMnemonic("CREATE_VIEW_BUILDER_HELP_CONTENTS"));
        this.m_menuHelp.add(this.m_menuHelpContents);
        this.m_menuBar.add(this.m_menuFile);
        this.m_menuBar.add(this.m_menuHelp);
        class MenuListener
        extends MouseAdapter {
            MenuListener() {
            }

            public void mousePressed(MouseEvent mouseEvent) {
                DM4JQueryBuilder.this.m_menuFileSave.setEnabled(DM4JQueryBuilder.this.m_viewBuilder.getSQLString() != null);
            }
        }
        MenuListener menuListener = new MenuListener();
        this.m_menuFile.addMouseListener(menuListener);
        this.m_viewBuilder = new DM4JJDBCQueryBuilder();
        this.m_viewBuilder.setConnection(this.m_conn.getDatabaseConnection());
        this.getContentPane().add((Component)((Object)this.m_viewBuilder), "Center");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void create_actionPerformed(ActionEvent actionEvent) {
        String string = null;
        String string2 = null;
        Connection connection = null;
        SQLProcess sQLProcess = null;
        StringBuffer stringBuffer = new StringBuffer(1000);
        StringBuffer stringBuffer2 = new StringBuffer(1000);
        try {
            CreateViewState createViewState = new CreateViewState(this.m_conn.getDatabaseConnection());
            CreateViewDialog createViewDialog = new CreateViewDialog(this, createViewState);
            if (createViewState.getSave()) {
                string = createViewState.getView();
                string2 = createViewState.getComment();
                this.m_sql = this.m_viewBuilder.getSQLString();
                String string3 = "CREATE VIEW \"" + DM4JConnectionManager.getUser() + "\".\"" + string + "\" AS " + this.m_sql;
                stringBuffer.append(string3);
                String string4 = "COMMENT ON TABLE \"" + DM4JConnectionManager.getUser() + "\".\"" + string + "\" IS '" + TransformsDirector.getReplacedString(string2, "'", "''") + "'";
                stringBuffer2.append(string4);
                StringBuffer[] stringBufferArray = new StringBuffer[]{stringBuffer, stringBuffer2};
                connection = DM4JConnectionManager.getDbConnection();
                sQLProcess = new SQLProcess(connection, stringBufferArray);
                ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("TRANSFORMATION_FINISH_DIALOG_TITLE"), sQLProcess, true);
                sQLProcess.setProgressBar(progressBar);
                progressBar.start(ResourceUtilities.getUILabel("TRANSFORMATION_FINISH_DIALOG_TITLE"), ResourceUtilities.getUILabel("TRANSFORMATION_FINISH_DIALOG_DESC"));
                if (sQLProcess.getException() != null) {
                    throw sQLProcess.getException();
                }
                if (progressBar.hasUserCancelled()) {
                } else {
                    String string5 = null;
                    string5 = "VIEW";
                    BrowserFrame.getMainFrame().findSchemaObject(DM4JConnectionManager.getUser(), string, string5);
                    this.requestFocus();
                }
            }
        }
        catch (Exception exception) {
            if (exception.getMessage().indexOf("ORA-00957") != -1) {
                String string6 = ResourceUtilities.getUILabel("CREATE_VIEW_ERROR_DIALOG");
                String string7 = ResourceUtilities.getUILabel("CREATE_VIEW_DUPLICATE_COLUMNS");
                JOptionPane.showOptionDialog(this, string7, string6, -1, 0, null, null, null);
            } else {
                DialogUtilities.createSystemErrorDialog(this, exception);
                exception.printStackTrace();
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private boolean cancel_actionPerformed(ActionEvent actionEvent) {
        String string = this.m_viewBuilder.getSQLString();
        if (string != null && (this.m_sql == null || string.compareToIgnoreCase(this.m_sql) != 0)) {
            String string2 = ResourceUtilities.getUILabel("CREATE_VIEW_WARNING_DIALOG");
            String string3 = ResourceUtilities.getUILabel("CREATE_VIEW_WARNING_DESCRIPTION");
            int n = JOptionPane.showOptionDialog(this, string3, string2, 1, 2, null, null, null);
            if (n == 0) {
                this.create_actionPerformed(actionEvent);
            } else if (n == 2) {
                return false;
            }
        }
        Help.unregisterClientWindow((Window)this);
        try {
            this.m_conn.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setVisible(false);
        this.dispose();
        return true;
    }

    private void help_actionPerformed(ActionEvent actionEvent) {
        this.setCursor(new Cursor(3));
        try {
            this.m_helpCxtMgr.showTopic("dm4j_createviewbuilder_html");
        }
        catch (Exception exception) {
            this.m_helpCxtMgr.showTopic("BrowserHelpTopics.BROWSER_INTRODUCTION");
        }
        this.setCursor(new Cursor(0));
    }
}

