/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.querybuilder;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import oracle.bali.dbUI.db.Database;
import oracle.bali.dbUI.db.Schema;
import oracle.bali.dbUI.db.Table;
import oracle.bali.dbUI.util.jdbc.JDBCSchema;
import oracle.bali.dbUI.util.jdbc.JDBCTable;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;

public class DM4JJDBCSchema
extends JDBCSchema {
    private Connection _connection;
    private String[] _tableNames;
    private Table[] _tables;

    public DM4JJDBCSchema(Connection connection, Database database, String string) {
        super(connection, database, string);
        this._connection = connection;
    }

    public int getTableCount() {
        if (this._tableNames == null) {
            this._createTableNames();
        }
        return this._tableNames == null ? 0 : this._tableNames.length;
    }

    public Table getTable(int n) {
        if (this._tables == null) {
            this._tables = new Table[this.getTableCount()];
        }
        if (this._tables[n] == null) {
            this._tables[n] = this._createTable(n);
        }
        return this._tables[n];
    }

    public String getTableName(int n) {
        if (this._tableNames == null) {
            this._createTableNames();
        }
        return this._tableNames == null ? null : this._tableNames[n];
    }

    private Table _createTable(int n) {
        String string = this.getTableName(n);
        return new JDBCTable(this._connection, (Schema)this, string);
    }

    private void _createTableNames() {
        try {
            Vector vector = DatabaseMetadata.getAccessableTablesAndViews(this._connection, this.getName());
            this._tableNames = new String[vector.size()];
            if (vector.size() != 0) {
                vector.copyInto(this._tableNames);
            }
        }
        catch (SQLException sQLException) {
            System.err.println("A SQLException occured " + sQLException);
        }
    }
}

