/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.querybuilder;

import java.sql.Connection;
import java.text.Collator;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.db.Database;
import oracle.bali.dbUI.resultsTable.ModelFactory;
import oracle.bali.dbUI.resultsTable.ResultsTable;
import oracle.bali.dbUI.resultsTable.ResultsTableCustomizer;
import oracle.bali.dbUI.util.jdbc.JDBCQueryBuilder;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.NumberComparator;
import oracle.bali.share.sort.StringComparator;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JTruncatingNumberFormatPainter;
import oracle.dmt.dm4j.querybuilder.DM4JJDBCDatabase;
import oracle.dmt.dm4j.querybuilder.DM4JJDBCModelFactory;

public class DM4JJDBCQueryBuilder
extends JDBCQueryBuilder {
    public DM4JJDBCQueryBuilder() {
        ResultsTable resultsTable = this.getResultsTable();
        resultsTable.setCustomizer((ResultsTableCustomizer)new Customizer());
        resultsTable.updateResults();
    }

    public void setConnection(Connection connection) {
        super.setConnection(connection);
        if (connection != null) {
            this.setDatabase((Database)new DM4JJDBCDatabase(connection));
            this.setModelFactory((ModelFactory)new DM4JJDBCModelFactory(connection));
        }
    }

    class Customizer
    extends ResultsTableCustomizer {
        public Comparator getComparator(Column column) {
            if (column.getDataType() == Long.class || column.getDataType() == Float.class || column.getDataType() == Double.class) {
                return NumberComparator.getComparator();
            }
            if (column.getDataType() == String.class || column.getDataType() == Character.class) {
                return new StringComparator(Collator.getInstance());
            }
            return super.getComparator(column);
        }

        public Painter getPainter(Column column) {
            DM4JTruncatingNumberFormatPainter dM4JTruncatingNumberFormatPainter = new DM4JTruncatingNumberFormatPainter(DM4JNumericFormat.getInstance(true, 10));
            if (column.getDataType() == Long.class || column.getDataType() == Float.class || column.getDataType() == Double.class) {
                return dM4JTruncatingNumberFormatPainter;
            }
            return super.getPainter(column);
        }
    }
}

