/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.querybuilder;

import java.sql.Connection;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.transformsteps.NameStateError;

public class CreateViewState {
    private final int NAME_LENGTH_MAX = 30;
    private final int COMMENT_LENGTH_MAX = 4000;
    private Connection m_conn = null;
    private String m_schema = null;
    private boolean m_save = false;
    private StringBuffer m_view = new StringBuffer(0);
    private StringBuffer m_comment = new StringBuffer(0);

    public CreateViewState(Connection connection) throws Exception {
        this.m_conn = connection;
        this.loadDefaults();
    }

    public void validate(Vector vector) throws Exception {
        this.validateViewName(vector);
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.validateComment(vector);
        }
    }

    private void validateComment(Vector vector) throws Exception {
        if (!ValidationUtil.checkStringLength(this.m_comment.toString(), 4000)) {
            String string = ResourceUtilities.getstateExceptionMessage("FIELD_LENGTH_EXCEEDED");
            String[] stringArray = new String[]{ResourceUtilities.getstateExceptionMessage("VIEW_NAME_COMMENT"), Integer.toString(4000)};
            vector.add(new StateValidation(NameStateError.VIEW_NAME_COMMENT_EXCEEDS_MAXIMUM_LENGTH, string, stringArray));
        }
    }

    private void validateViewName(Vector vector) throws Exception {
        String[] stringArray;
        String string;
        if (this.m_view.length() == 0) {
            string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            stringArray = new String[]{ResourceUtilities.getUILabel("VIEW_NAME_STEP_NAME")};
            vector.add(new StateValidation(NameStateError.VIEW_NAME_EMPTY, string, stringArray));
        }
        if (!ValidationUtil.checkStringLength(this.m_view.toString(), 30)) {
            string = ResourceUtilities.getstateExceptionMessage("MAXIMUM_LENGTH_EXCEEDED");
            stringArray = new String[]{ResourceUtilities.getUILabel("VIEW_NAME_STEP_NAME"), Integer.toString(30)};
            vector.add(new StateValidation(NameStateError.VIEW_NAME_EXCEEDS_MAXIMUM_LENGTH, string, stringArray));
        }
        if (ValidationUtil.isGreater32BytesInDB(this.m_view.toString(), this.m_conn)) {
            string = ResourceUtilities.getstateExceptionMessage("GREATER_THAN_30BYTES");
            stringArray = new String[]{ResourceUtilities.getUILabel("VIEW_NAME_STEP_NAME")};
            vector.add(new StateValidation(NameStateError.VIEW_NAME_GREATER_30BYTES, string, stringArray));
        }
        if (ValidationUtil.containsDoubleQuote(this.m_view.toString())) {
            string = ResourceUtilities.getstateExceptionMessage("CONTAINS_DOUBLE_QUOTES");
            stringArray = new String[]{ResourceUtilities.getUILabel("VIEW_NAME_STEP_NAME")};
            vector.add(new StateValidation(NameStateError.VIEW_NAME_CONTAINS_DOUBLE_QUOTES, string, stringArray));
        }
        if (ValidationUtil.isEqualToROWID(this.m_view.toString())) {
            string = ResourceUtilities.getstateExceptionMessage("EQUALS_ROWID");
            stringArray = new String[]{ResourceUtilities.getUILabel("VIEW_NAME_STEP_NAME")};
            vector.add(new StateValidation(NameStateError.VIEW_NAME_EQUALS_ROWID, string, stringArray));
        }
        if (!ValidationUtil.isTableNameUnique(this.m_view.toString(), this.m_conn)) {
            vector.add(new StateValidation(NameStateError.VIEW_NAME_DUPLICATE));
        }
    }

    public String getSchema() {
        return this.m_schema;
    }

    public String getView() {
        return this.m_view.toString();
    }

    public String getComment() {
        return this.m_comment.toString();
    }

    public boolean getSave() {
        return this.m_save;
    }

    public void setSave(boolean bl) {
        this.m_save = bl;
    }

    public void setComment(String string) {
        String string2;
        if (string != null && !string.equals(string2 = this.m_comment.toString())) {
            this.m_comment.setLength(0);
            this.m_comment.append(string);
        }
    }

    public void setView(String string) {
        String string2;
        if (string != null && !string.equals(string2 = this.m_view.toString())) {
            this.m_view.setLength(0);
            this.m_view.append(string);
        }
    }

    protected void loadDefaults() throws Exception {
        this.m_schema = DM4JConnectionManager.getUser().toUpperCase();
        this.m_view.setLength(0);
        this.m_comment.setLength(0);
    }
}

