/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.lineage;

import java.util.EventObject;
import javax.swing.event.EventListenerList;
import oracle.dmt.dm4j.browser.worker.SwingWorker;
import oracle.dmt.dm4j.browser.worker.ThreadState;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;
import oracle.dmt.dm4j.lineage.DependentObjectsLoadedListener;
import oracle.dmt.dm4j.lineage.LineageTreeNode;
import oracle.dmt.dm4j.lineage.ViewDetailLoadedListener;
import oracle.dmt.dm4j.lineage.ViewDetailsPanel;

public class LoadViewDetailWorker
extends SwingWorker
implements ThreadState {
    private static int s_thread = 0;
    private EventListenerList listenerList = new EventListenerList();
    private LineageTreeNode m_node;

    public LoadViewDetailWorker(WorkerThreadManager workerThreadManager, LineageTreeNode lineageTreeNode) {
        super(workerThreadManager);
        this.m_node = lineageTreeNode;
    }

    public void addViewDetailLoadedListener(ViewDetailLoadedListener viewDetailLoadedListener) {
        this.listenerList.add(ViewDetailLoadedListener.class, viewDetailLoadedListener);
    }

    public void removeDependentObjectsLoadedListener(DependentObjectsLoadedListener dependentObjectsLoadedListener) {
        this.listenerList.remove(DependentObjectsLoadedListener.class, dependentObjectsLoadedListener);
    }

    public Object construct() {
        ViewDetailsPanel viewDetailsPanel = null;
        try {
            if (s_thread == 0) {
                this.m_threadManager.setRunningState(2);
            }
            ++s_thread;
            viewDetailsPanel = new ViewDetailsPanel(this.m_node);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return viewDetailsPanel;
    }

    public void finished() {
        if (--s_thread == 0) {
            this.m_threadManager.removeRunningState(2);
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ViewDetailLoadedListener.class) continue;
            ((ViewDetailLoadedListener)objectArray[i + 1]).viewDetailsLoaded(new EventObject(this.getValue()));
        }
    }
}

