/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.lineage;

import java.util.EventObject;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.viewer.EmptySelectionPanel;
import oracle.dmt.dm4j.browser.viewer.LoadingStatusPanel;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;
import oracle.dmt.dm4j.lineage.DependentObjectsLoadedListener;
import oracle.dmt.dm4j.lineage.LineageTreeCellRenderer;
import oracle.dmt.dm4j.lineage.LineageTreeNode;
import oracle.dmt.dm4j.lineage.LoadDependentViewsWorker;
import oracle.dmt.dm4j.lineage.LoadViewDetailWorker;
import oracle.dmt.dm4j.lineage.ViewDetailLoadedListener;
import oracle.dmt.dm4j.lineage.ViewDetailsPanel;

public class LineageViewerSplitPanel
extends JSplitPane
implements TreeExpansionListener,
TreeSelectionListener,
DependentObjectsLoadedListener,
ViewDetailLoadedListener {
    private String m_schema = null;
    private String m_view = null;
    private JTree m_navigator = new JTree();
    private DefaultTreeModel m_treeModel = null;
    private JScrollPane m_treeScrollPane = new JScrollPane();
    private LoadingStatusPanel m_loadingPanel = new LoadingStatusPanel();
    private int m_splitterDivPos = 0;

    public LineageViewerSplitPanel(String string, String string2) {
        this.m_schema = string;
        this.m_view = string2;
        this.jbInit();
    }

    void jbInit() {
        this.setOrientation(1);
        LineageTreeNode lineageTreeNode = new LineageTreeNode(this.m_schema, this.m_view, "VIEW");
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new Boolean(true));
        lineageTreeNode.add(defaultMutableTreeNode);
        this.m_treeModel = new DefaultTreeModel(lineageTreeNode);
        this.m_navigator.setModel(this.m_treeModel);
        LineageTreeCellRenderer lineageTreeCellRenderer = new LineageTreeCellRenderer();
        this.m_navigator.setCellRenderer(lineageTreeCellRenderer);
        this.m_navigator.setShowsRootHandles(true);
        this.m_navigator.setEditable(false);
        this.m_navigator.collapseRow(0);
        this.m_navigator.setSelectionRow(0);
        this.m_treeScrollPane.getViewport().add(this.m_navigator);
        this.setLeftComponent(this.m_treeScrollPane);
        this.setRightComponent(this.m_loadingPanel);
        this.m_navigator.addTreeExpansionListener(this);
        this.m_navigator.addTreeSelectionListener(this);
        WorkerThreadManager workerThreadManager = WorkerThreadManager.getInstance();
        LoadViewDetailWorker loadViewDetailWorker = (LoadViewDetailWorker)workerThreadManager.getLoadViewDetailWorker(lineageTreeNode);
        loadViewDetailWorker.addViewDetailLoadedListener(this);
        loadViewDetailWorker.start();
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Object object = defaultMutableTreeNode.getUserObject();
        if (defaultMutableTreeNode instanceof LineageTreeNode) {
            LineageTreeNode lineageTreeNode = (LineageTreeNode)defaultMutableTreeNode;
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getFirstChild();
            object = defaultMutableTreeNode2.getUserObject();
            if (object instanceof Boolean) {
                WorkerThreadManager workerThreadManager = WorkerThreadManager.getInstance();
                LoadDependentViewsWorker loadDependentViewsWorker = (LoadDependentViewsWorker)workerThreadManager.getLoadDependentViewsWorker(lineageTreeNode);
                loadDependentViewsWorker.addObjectsLoadedListener(this);
                loadDependentViewsWorker.start();
            }
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.saveSplitterPos();
        if (treeSelectionEvent.getNewLeadSelectionPath() == null) {
            this.setRightComponent(new EmptySelectionPanel(DM4JResourceUtilities.getUIString("COMMON_NO_ITEM_SELECTED")));
            return;
        }
        TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
        int n = this.m_navigator.getSelectionCount();
        if (n > 1) {
            this.setRightComponent(new EmptySelectionPanel(DM4JResourceUtilities.getUIString("COMMON_MULTI_ITEM_SELECTED")));
            return;
        }
        if (n < 1) {
            this.setRightComponent(new EmptySelectionPanel(DM4JResourceUtilities.getUIString("COMMON_NO_ITEM_SELECTED")));
            return;
        }
        LineageTreeNode lineageTreeNode = null;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (!(defaultMutableTreeNode instanceof LineageTreeNode)) {
            this.setRightComponent(new EmptySelectionPanel(DM4JResourceUtilities.getUIString("COMMON_NO_ITEM_SELECTED")));
            return;
        }
        lineageTreeNode = (LineageTreeNode)defaultMutableTreeNode;
        this.setRightComponent(this.m_loadingPanel);
        this.restoreSplitterPos();
        WorkerThreadManager workerThreadManager = WorkerThreadManager.getInstance();
        LoadViewDetailWorker loadViewDetailWorker = (LoadViewDetailWorker)workerThreadManager.getLoadViewDetailWorker(lineageTreeNode);
        loadViewDetailWorker.addViewDetailLoadedListener(this);
        loadViewDetailWorker.start();
    }

    public void viewDetailsLoaded(EventObject eventObject) {
        this.saveSplitterPos();
        if (this.m_navigator.getSelectionCount() > 1) {
            return;
        }
        TreePath treePath = this.m_navigator.getSelectionPath();
        if (null == treePath) {
            return;
        }
        ViewDetailsPanel viewDetailsPanel = (ViewDetailsPanel)eventObject.getSource();
        LineageTreeNode lineageTreeNode = (LineageTreeNode)treePath.getLastPathComponent();
        if (lineageTreeNode.getSchemaName().equals(viewDetailsPanel.getSchemaName()) && lineageTreeNode.getViewName().equals(viewDetailsPanel.getViewName())) {
            this.setRightComponent(viewDetailsPanel);
            this.restoreSplitterPos();
        }
    }

    private void saveSplitterPos() {
        this.m_splitterDivPos = this.getDividerLocation();
    }

    private void restoreSplitterPos() {
        this.setDividerLocation(this.m_splitterDivPos);
    }

    public void objectsLoaded(EventObject eventObject) {
        Object object = eventObject.getSource();
        if (object != null) {
            TreePath[] treePathArray = this.m_navigator.getSelectionPaths();
            this.m_treeModel.reload((DefaultMutableTreeNode)object);
            this.m_navigator.setSelectionPaths(treePathArray);
            if (treePathArray == null) {
                this.setRightComponent(new EmptySelectionPanel(DM4JResourceUtilities.getUIString("COMMON_NO_ITEM_SELECTED")));
            }
        }
    }

    public JTree getNavigatorTree() {
        return this.m_navigator;
    }
}

