/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.lineage;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.dm4j.lineage.LineageTreeNode;
import oracle.dmt.dm4j.lineage.LineageViewerSplitPanel;
import oracle.help.CSHManager;
import oracle.help.Help;

public class LineageViewerFrame
extends JFrame {
    private String m_schema = null;
    private String m_view = null;
    private CSHManager m_helpCxtMgr = null;
    private LineageViewerSplitPanel m_splitPane = null;
    private JTree m_navigator = null;
    private static ProgressBar s_progressDlg = null;
    private static String s_saveSQLFile = null;
    private static final String CREATE_VIEW = "CREATE VIEW \"{0}\".\"{1}\" AS \n{2};\n\n";

    private LineageViewerFrame() {
    }

    public LineageViewerFrame(String string, String string2, boolean bl) {
        this(string, string2);
        this.fileGenerateSQL_ActionPerformed(null);
    }

    public LineageViewerFrame(String string, String string2) {
        this.m_schema = string;
        this.m_view = string2;
        this.jbInit();
    }

    void jbInit() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
            }
        });
        KeyStroke keyStroke = KeyStroke.getKeyStroke(112, 0, true);
        this.getRootPane().getInputMap(1).put(keyStroke, "HelpAction");
        this.getRootPane().getActionMap().put("HelpAction", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                LineageViewerFrame.this.help_actionPerformed(actionEvent);
            }
        });
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(27, 0, true);
        this.getRootPane().getInputMap(2).put(keyStroke2, "EscAction");
        this.getRootPane().getActionMap().put("EscAction", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                LineageViewerFrame.this.esc_actionPerformed(actionEvent);
            }
        });
        this.setTitle(DM4JVersion.getFullBrowserName() + " - " + DM4JResourceUtilities.getUIString("LINEAGE_TITLE"));
        this.getContentPane().setLayout(new BorderLayout());
        this.setSize(600, 370);
        ImageIcon imageIcon = (ImageIcon)IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/client.gif");
        this.setIconImage(imageIcon.getImage());
        this.createMenuBar();
        Help.registerClientWindow((Window)this);
        this.m_helpCxtMgr = BrowserFrame.getCSHManager();
        this.m_helpCxtMgr.addComponent((Component)this, "LINEAGE_VIEWER", true, false);
        this.m_splitPane = new LineageViewerSplitPanel(this.m_schema, this.m_view);
        this.m_splitPane.setDividerSize(5);
        this.m_splitPane.setDividerLocation(200);
        this.getContentPane().add(this.m_splitPane);
        this.m_navigator = this.m_splitPane.getNavigatorTree();
        this.m_navigator.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (!mouseEvent.isPopupTrigger()) {
                    return;
                }
                LineageViewerFrame.this.doContextMenu(mouseEvent.getX(), mouseEvent.getY());
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (!mouseEvent.isPopupTrigger()) {
                    return;
                }
                LineageViewerFrame.this.doContextMenu(mouseEvent.getX(), mouseEvent.getY());
            }
        });
    }

    private void createMenuBar() {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu();
        final JMenuItem jMenuItem = new JMenuItem();
        JMenuItem jMenuItem2 = new JMenuItem();
        JMenu jMenu2 = new JMenu();
        final JMenuItem jMenuItem3 = new JMenuItem();
        final JMenuItem jMenuItem4 = new JMenuItem();
        JMenu jMenu3 = new JMenu();
        JMenuItem jMenuItem5 = new JMenuItem();
        jMenu.setText(DM4JResourceUtilities.getUIString("COMMON_FILE"));
        jMenu.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "MENU_FILE"));
        jMenuItem.setText(DM4JResourceUtilities.getUIString("LINEAGE_GENERATE_SQL"));
        jMenuItem.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "LINEAGE_GENERATE_SQL"));
        jMenuItem2.setText(DM4JResourceUtilities.getUIString("MENU_FILE_EXIT"));
        jMenuItem2.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "MENU_FILE_EXIT"));
        jMenu2.setText(DM4JResourceUtilities.getUIString("COMMON_VIEW"));
        jMenu2.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "MENU_VIEW"));
        jMenuItem3.setText(DM4JResourceUtilities.getUIString("COMMON_EXPAND_ALL"));
        jMenuItem3.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "COMMON_EXPAND_ALL"));
        jMenuItem4.setText(DM4JResourceUtilities.getUIString("LINEAGE_SHOW_IN_BROWSER"));
        jMenuItem4.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "LINEAGE_SHOW_IN_BROWSER"));
        jMenu3.setText(DM4JResourceUtilities.getUIString("COMMON_HELP"));
        jMenu3.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "COMMON_HELP"));
        jMenuItem5.setText(DM4JResourceUtilities.getUIString("COMMON_HELP_CONTENTS"));
        jMenuItem5.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "MENU_HELP_CONTENTS"));
        jMenu.add(jMenuItem);
        jMenu.add(new JSeparator());
        jMenu.add(jMenuItem2);
        jMenu2.add(jMenuItem3);
        jMenu2.add(jMenuItem4);
        jMenu3.add(jMenuItem5);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu3);
        this.setJMenuBar(jMenuBar);
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LineageViewerFrame.this.fileExit_ActionPerformed(actionEvent);
            }
        });
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LineageViewerFrame.this.fileGenerateSQL_ActionPerformed(actionEvent);
            }
        });
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LineageViewerFrame.this.viewExpandAll_ActionPerformed(actionEvent);
            }
        });
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreePath treePath = LineageViewerFrame.this.m_navigator.getSelectionPath();
                LineageTreeNode lineageTreeNode = (LineageTreeNode)treePath.getLastPathComponent();
                LineageViewerFrame.this.viewShowInBrowser_ActionPerformed(lineageTreeNode);
            }
        });
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LineageViewerFrame.this.helpHelpContents_ActionPerformed(actionEvent);
            }
        });
        jMenu2.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent menuEvent) {
            }

            public void menuDeselected(MenuEvent menuEvent) {
            }

            public void menuSelected(MenuEvent menuEvent) {
                jMenuItem3.setEnabled(WorkerThreadManager.getInstance().getState() == 1);
                if (LineageViewerFrame.this.m_navigator.getSelectionCount() == 1) {
                    TreePath treePath = LineageViewerFrame.this.m_navigator.getSelectionPath();
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    if (defaultMutableTreeNode instanceof LineageTreeNode) {
                        jMenuItem4.setEnabled(true);
                    } else {
                        jMenuItem4.setEnabled(false);
                    }
                } else {
                    jMenuItem4.setEnabled(false);
                }
            }
        });
        jMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent menuEvent) {
            }

            public void menuDeselected(MenuEvent menuEvent) {
            }

            public void menuSelected(MenuEvent menuEvent) {
                jMenuItem.setEnabled(WorkerThreadManager.getInstance().getState() == 1);
            }
        });
    }

    private void doContextMenu(int n, int n2) {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        TreePath treePath = this.m_navigator.getPathForLocation(n, n2);
        if (treePath == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (null == defaultMutableTreeNode || !(defaultMutableTreeNode instanceof LineageTreeNode)) {
            return;
        }
        this.m_navigator.setSelectionPath(treePath);
        final LineageTreeNode lineageTreeNode = (LineageTreeNode)defaultMutableTreeNode;
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(DM4JResourceUtilities.getUIString("LINEAGE_SHOW_IN_BROWSER"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LineageViewerFrame.this.viewShowInBrowser_ActionPerformed(lineageTreeNode);
            }
        });
        jPopupMenu.add(jMenuItem);
        jPopupMenu.show(this.m_navigator, n, n2);
    }

    private void fileExit_ActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void fileGenerateSQL_ActionPerformed(ActionEvent actionEvent) {
        BrowserFrame browserFrame = BrowserFrame.getMainFrame();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Connection connection = null;
                try {
                    connection = DM4JConnectionManager.getDbConnection();
                    s_progressDlg.updateProgress(DM4JResourceUtilities.getUIString("LINEAGE_GENERATE_SQL"), DM4JResourceUtilities.getUIString("LINEAGE_DISCOVERING"));
                    if (s_progressDlg.hasUserCancelled()) {
                        return;
                    }
                    DefaultTreeModel defaultTreeModel = (DefaultTreeModel)LineageViewerFrame.this.m_navigator.getModel();
                    LineageTreeNode lineageTreeNode = (LineageTreeNode)defaultTreeModel.getRoot();
                    LineageViewerFrame.this.expandAll(connection, lineageTreeNode);
                    if (s_progressDlg.hasUserCancelled()) {
                        return;
                    }
                    s_progressDlg.updateProgress(DM4JResourceUtilities.getUIString("LINEAGE_GENERATE_SQL"), DM4JResourceUtilities.getUIString("LINEAGE_GENERATING"));
                    OutputStreamWriter outputStreamWriter = LineageViewerFrame.this.initViewTextFile(s_saveSQLFile);
                    LineageViewerFrame.this.saveNodeSQL(connection, lineageTreeNode, outputStreamWriter);
                    outputStreamWriter.flush();
                    outputStreamWriter.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                finally {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    s_progressDlg.setDoneStatus();
                }
            }
        };
        JFileChooser jFileChooser = new JFileChooser();
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            int n2;
            File file = new File(jFileChooser.getSelectedFile().getAbsolutePath());
            if (file.exists() && (n2 = JOptionPane.showConfirmDialog(this, DM4JResourceUtilities.getUIString("COMMON_FILE_EXISTS"), DM4JResourceUtilities.getUIString("COMMON_FILE_OVERWRITE_PRMPT"), 0)) != 0) {
                return;
            }
            s_saveSQLFile = jFileChooser.getSelectedFile().getAbsolutePath();
            s_progressDlg = new ProgressBar(this, DM4JResourceUtilities.getUIString("LINEAGE_GENERATE_SQL"), runnable, true);
            s_progressDlg.start(DM4JResourceUtilities.getUIString("LINEAGE_GENERATE_SQL"), "");
            s_progressDlg.waitUntilDone();
        }
    }

    private OutputStreamWriter initViewTextFile(String string) throws IOException {
        String string2 = DM4JResourceUtilities.getUIString("LINEAGE_FILE_HEADER");
        FileOutputStream fileOutputStream = new FileOutputStream(new File(string));
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
        outputStreamWriter.write(string2);
        return outputStreamWriter;
    }

    private void viewExpandAll_ActionPerformed(ActionEvent actionEvent) {
        BrowserFrame browserFrame = BrowserFrame.getMainFrame();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Connection connection = null;
                try {
                    connection = DM4JConnectionManager.getDbConnection();
                    DefaultTreeModel defaultTreeModel = (DefaultTreeModel)LineageViewerFrame.this.m_navigator.getModel();
                    LineageTreeNode lineageTreeNode = (LineageTreeNode)defaultTreeModel.getRoot();
                    LineageViewerFrame.this.expandAll(connection, lineageTreeNode);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                finally {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    s_progressDlg.setDoneStatus();
                }
            }
        };
        s_progressDlg = new ProgressBar(this, DM4JResourceUtilities.getUIString("COMMON_EXPAND_ALL"), runnable, true);
        s_progressDlg.start(DM4JResourceUtilities.getUIString("LINEAGE_EXPAND_ALL_DEP_VIEWS"), DM4JResourceUtilities.getUIString("LINEAGE_DISCOVERING"));
        s_progressDlg.waitUntilDone();
    }

    private void viewShowInBrowser_ActionPerformed(LineageTreeNode lineageTreeNode) {
        this.m_navigator.setCursor(new Cursor(3));
        BrowserFrame browserFrame = BrowserFrame.getMainFrame();
        browserFrame.findSchemaObject(lineageTreeNode.getSchemaName(), lineageTreeNode.getViewName(), lineageTreeNode.getType());
        browserFrame.toFront();
        this.m_navigator.setCursor(new Cursor(0));
    }

    private void helpHelpContents_ActionPerformed(ActionEvent actionEvent) {
        this.setCursor(new Cursor(3));
        try {
            this.m_helpCxtMgr.showTopic("LINEAGE_VIEWER");
        }
        catch (Exception exception) {
            try {
                this.m_helpCxtMgr.showTopic("dm4j_introduction_html");
            }
            catch (Exception exception2) {
                JOptionPane.showOptionDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("COMMON_ERROR_NO_HELP"), DM4JVersion.getFullBrowserName(), -1, 0, null, null, null);
            }
        }
        this.setCursor(new Cursor(0));
    }

    private void expandAll(Connection connection, LineageTreeNode lineageTreeNode) throws Exception {
        if (!lineageTreeNode.isView()) {
            return;
        }
        if (s_progressDlg.hasUserCancelled()) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)lineageTreeNode.getFirstChild();
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof Boolean) {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.m_navigator.getModel();
            lineageTreeNode.remove(0);
            Vector vector = DatabaseMetadata.getDependentTables(connection, lineageTreeNode.getSchemaName(), lineageTreeNode.getViewName());
            for (int i = 0; i < vector.size(); ++i) {
                String string;
                ArrayList arrayList = (ArrayList)vector.get(i);
                String string2 = (String)arrayList.get(0);
                String string3 = (String)arrayList.get(1);
                LineageTreeNode lineageTreeNode2 = new LineageTreeNode(string3, string2, string = (String)arrayList.get(2));
                if (lineageTreeNode2.isView()) {
                    lineageTreeNode2.add(new DefaultMutableTreeNode(new Boolean(true)));
                }
                lineageTreeNode.add(lineageTreeNode2);
                defaultTreeModel.insertNodeInto(lineageTreeNode2, lineageTreeNode, i);
                defaultTreeModel.reload(lineageTreeNode);
                this.m_navigator.scrollPathToVisible(new TreePath(lineageTreeNode2.getPath()));
            }
        } else {
            this.m_navigator.expandPath(new TreePath(lineageTreeNode.getPath()));
        }
        if (s_progressDlg.hasUserCancelled()) {
            return;
        }
        int n = lineageTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            LineageTreeNode lineageTreeNode3 = (LineageTreeNode)lineageTreeNode.getChildAt(i);
            this.expandAll(connection, lineageTreeNode3);
        }
    }

    private void saveNodeSQL(Connection connection, LineageTreeNode lineageTreeNode, OutputStreamWriter outputStreamWriter) throws SQLException, IOException {
        int n = lineageTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            LineageTreeNode lineageTreeNode2 = (LineageTreeNode)lineageTreeNode.getChildAt(i);
            this.saveNodeSQL(connection, lineageTreeNode2, outputStreamWriter);
        }
        if (lineageTreeNode.isView()) {
            String string = DatabaseMetadata.getViewText(connection, lineageTreeNode.getSchemaName(), lineageTreeNode.getViewName());
            string = this.getCreateViewString(lineageTreeNode, string);
            outputStreamWriter.write(string);
        }
    }

    private String getCreateViewString(LineageTreeNode lineageTreeNode, String string) {
        Object[] objectArray = new Object[]{lineageTreeNode.getSchemaName(), lineageTreeNode.getViewName(), string};
        return MessageFormat.format(CREATE_VIEW, objectArray);
    }

    public void esc_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    public void help_actionPerformed(ActionEvent actionEvent) {
        try {
            BrowserFrame.getCSHManager().showTopic("LINEAGE_VIEWER");
        }
        catch (Exception exception) {
            BrowserFrame.showHelpError(this);
        }
    }
}

