/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.integrator.disco.report;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.browser.LongRunningProcess;
import oracle.dmt.dm4j.integrator.disco.DiscoIntegrationManager;
import oracle.dmt.dm4j.integrator.disco.DiscoODMrGateway;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.jdm.utils.OraStringUtils;

public abstract class DiscoReport
extends LongRunningProcess {
    protected static final boolean DEBUG = true;
    protected Vector m_reportTableNames = null;
    protected Vector m_reportTableDefinitions = null;
    protected Vector m_reportGWObjectNames = null;
    protected Vector m_GWObjectTypes = null;
    protected Vector m_schemaNames = null;
    protected Vector m_objDisplayName = null;
    protected Vector m_objDescription = null;
    protected Vector m_physicalColNames = null;
    protected Vector m_sqlDataTypes = null;
    protected Vector m_logicalColNames = null;
    private DiscoODMrGateway m_odmrEULGW = null;
    protected Connection m_dbConn = null;
    private boolean m_isView = false;
    protected Vector m_gwObjCreateFlags = null;
    private static String QRY_USER_GET_COL_DETAILS = "SELECT COLUMN_NAME,DATA_TYPE FROM USER_TAB_COLUMNS WHERE TABLE_NAME='";
    private static String QRY_ALL_GET_COL_DETAILS = "SELECT COLUMN_NAME,DATA_TYPE FROM ALL_TAB_COLUMNS WHERE OWNER='";
    protected static String TABLE = " TABLE ";

    DiscoReport(Connection connection) throws SQLException {
        this.m_dbConn = connection;
        this.m_odmrEULGW = DiscoIntegrationManager.createDiscoODMrGateway(connection, true);
    }

    public void setReportObjectType(boolean bl) {
        this.m_isView = bl;
    }

    public String getObjectType() {
        if (this.m_isView) {
            return " VIEW ";
        }
        return " TABLE ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createReportTables() throws Exception {
        if (this.m_reportTableDefinitions == null) return;
        int n = 0;
        while (n < this.m_reportTableDefinitions.size()) {
            if (((Boolean)this.m_gwObjCreateFlags.elementAt(n)).booleanValue()) {
                Object object;
                block43: {
                    boolean bl = "VIEWTABLE".equalsIgnoreCase((String)this.m_GWObjectTypes.elementAt(n));
                    String string = bl ? ValidationUtil.createUniqueTableName("DM$4JVIEWTABLE", this.m_dbConn, "DGW") : null;
                    Statement statement = null;
                    try {
                        object = "CREATE " + (bl ? "VIEW" : (String)this.m_GWObjectTypes.elementAt(n)) + " " + (bl ? string : DM4JStringUtils.addDoubleQuotes((String)this.m_reportTableNames.elementAt(n))) + " AS " + this.m_reportTableDefinitions.elementAt(n);
                        statement = this.m_dbConn.prepareStatement((String)object);
                        statement.execute();
                        if (!bl) break block43;
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        statement = this.m_dbConn.prepareStatement("CREATE TABLE " + DM4JStringUtils.addDoubleQuotes((String)this.m_reportTableNames.elementAt(n)) + " AS SELECT * FROM " + string);
                        statement.execute();
                    }
                    finally {
                        block44: {
                            if (bl) {
                                object = null;
                                try {
                                    object = this.m_dbConn.prepareStatement("DROP VIEW " + string);
                                    object.execute();
                                    if (object == null) break block44;
                                }
                                catch (Exception exception) {
                                    if (object != null) {
                                        try {
                                            object.close();
                                        }
                                        catch (Exception exception2) {}
                                    }
                                    break block44;
                                    catch (Throwable throwable) {
                                        if (object == null) throw throwable;
                                        try {
                                            object.close();
                                            throw throwable;
                                        }
                                        catch (Exception exception3) {}
                                    }
                                }
                                try {
                                    object.close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                object = null;
                try {
                    String string = "COMMENT ON TABLE " + DM4JStringUtils.addDoubleQuotes((String)this.m_reportTableNames.elementAt(n)) + " IS '" + DM4JStringUtils.escapeSingleQuotesForSQL((String)this.m_objDescription.elementAt(n)) + "'";
                    object = this.m_dbConn.prepareStatement(string);
                    object.execute();
                }
                finally {
                    if (object != null) {
                        try {
                            object.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropReportTables() throws Exception {
        Exception exception = null;
        for (int i = 0; i < this.m_reportTableNames.size(); ++i) {
            Statement statement = null;
            try {
                statement = this.m_dbConn.prepareStatement("DROP " + (String)this.m_GWObjectTypes.elementAt(i) + " " + DM4JStringUtils.addDoubleQuotes((String)this.m_reportTableNames.elementAt(i)));
                statement.execute();
                continue;
            }
            catch (Exception exception2) {
                if (exception == null) {
                    exception = exception2;
                    continue;
                }
                exception.initCause(exception2);
                continue;
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception3) {}
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public void registerReportTables() throws Exception {
        if (this.m_physicalColNames == null && this.m_reportTableNames != null) {
            this.m_physicalColNames = new Vector();
            this.m_sqlDataTypes = new Vector();
            Vector<String> vector = new Vector<String>();
            Vector<String> vector2 = new Vector<String>();
            Vector vector3 = new Vector();
            Vector vector4 = new Vector();
            Vector vector5 = new Vector();
            int n = this.m_reportTableNames.size();
            for (int i = 0; i < n; ++i) {
                if (!((Boolean)this.m_gwObjCreateFlags.elementAt(i)).booleanValue()) continue;
                String string = (String)this.m_reportTableNames.elementAt(i);
                vector.add(string);
                if (this.m_GWObjectTypes != null) {
                    vector3.add(this.m_GWObjectTypes.elementAt(i));
                } else {
                    vector3 = null;
                }
                if (this.m_objDisplayName != null) {
                    vector4.add(this.m_objDisplayName.elementAt(i));
                } else {
                    vector4 = null;
                }
                if (this.m_objDescription != null) {
                    vector5.add(this.m_objDescription.elementAt(i));
                } else {
                    vector5 = null;
                }
                String string2 = null;
                if (this.m_schemaNames != null && this.m_schemaNames.size() == n) {
                    string2 = (String)this.m_schemaNames.elementAt(i);
                    vector2.add(string2);
                } else {
                    vector2 = null;
                }
                String[][] stringArray = DiscoReport.getColumnDetails(this.m_dbConn, string2, string);
                this.m_physicalColNames.add(stringArray[0]);
                this.m_sqlDataTypes.add(stringArray[1]);
            }
            this.m_logicalColNames = this.m_physicalColNames;
            this.m_odmrEULGW.setGWObjectDetails(vector, vector3, vector, vector4, vector5, this.m_physicalColNames, this.m_logicalColNames, this.m_sqlDataTypes, vector2);
        } else {
            this.m_odmrEULGW.setGWObjectDetails(this.m_reportGWObjectNames, this.m_GWObjectTypes, this.m_reportTableNames, this.m_objDisplayName, this.m_objDescription, this.m_physicalColNames, this.m_logicalColNames, this.m_sqlDataTypes, this.m_schemaNames);
        }
        this.m_odmrEULGW.saveGWObjects();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.execute();
        }
        catch (Exception exception) {
            this.setException(exception);
        }
        finally {
            this.getProgressBar().setDoneStatus();
        }
    }

    public void execute() throws Exception {
        try {
            if (this.getProgressBar().hasUserCancelled()) {
                return;
            }
            this.createReportTables();
            if (this.getProgressBar().hasUserCancelled()) {
                this.dropReportTables();
                return;
            }
            this.registerReportTables();
            if (this.getProgressBar().hasUserCancelled()) {
                this.dropReportTables();
                return;
            }
        }
        catch (Exception exception) {
            try {
                this.dropReportTables();
            }
            catch (Exception exception2) {
                exception.initCause(exception2);
            }
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[][] getColumnDetails(Connection connection, String string, String string2) throws SQLException {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2;
        String string3 = null;
        String string4 = null;
        if (string != null) {
            string4 = string4 + QRY_ALL_GET_COL_DETAILS;
            string3 = OraStringUtils.processQuotedName(string);
            if (string3.equals(string)) {
                string3 = string.toUpperCase();
            }
            string4 = string4 + string3;
            string4 = string4 + "' AND TABLE_NAME='";
        } else {
            string4 = QRY_USER_GET_COL_DETAILS;
        }
        String string5 = OraStringUtils.processQuotedName(string2);
        if (string5.equals(string2)) {
            string5 = string2.toUpperCase();
        }
        string4 = string4 + string5 + "'";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(string4);
            resultSet = preparedStatement.executeQuery();
            arrayList2 = new ArrayList<String>();
            arrayList = new ArrayList<String>();
            while (resultSet.next()) {
                arrayList2.add(resultSet.getString(1));
                arrayList.add(resultSet.getString(2));
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        int n = arrayList2.size();
        String[][] stringArray = new String[2][n];
        System.arraycopy(arrayList2.toArray(), 0, stringArray[0], 0, n);
        System.arraycopy(arrayList.toArray(), 0, stringArray[1], 0, n);
        return stringArray;
    }
}

