/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.expressionbuilder;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import oracle.bali.ewt.util.WindowUtils;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.expressionbuilder.AbstractExpressionBuilderContext;
import oracle.dmt.dm4j.expressionbuilder.AggregateContext;
import oracle.dmt.dm4j.expressionbuilder.ComputeFieldContext;
import oracle.dmt.dm4j.expressionbuilder.ExpressionBuilderMainPanel;
import oracle.dmt.dm4j.expressionbuilder.Filter2DContext;
import oracle.dmt.dm4j.sql.PLSQLAnonymousBlock;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.help.CSHManager;
import oracle.help.Help;
import oracle.jdbc.OracleCallableStatement;

public class ExpressionBuilderDialog
extends JDialog {
    private AbstractExpressionBuilderContext m_ebc = null;
    private boolean m_isOk = false;
    private String m_origAttribName = null;
    private ExpressionBuilderMainPanel m_dialogPanel = null;
    private static final String newAttributeQuery = "SELECT {0} AS \"{1}\" FROM \"{2}\".\"{3}\"";
    private static final String aggregateQuery = "SELECT {0} FROM \"{1}\".\"{2}\"";
    private static final String filter2DQuery = "SELECT * FROM \"{0}\".\"{1}\" WHERE {2}";

    public ExpressionBuilderDialog(AbstractExpressionBuilderContext abstractExpressionBuilderContext) {
        super((Frame)BrowserFrame.getMainFrame(), true);
        try {
            this.m_ebc = abstractExpressionBuilderContext;
            if (this.m_ebc instanceof ComputeFieldContext) {
                this.m_origAttribName = ((ComputeFieldContext)abstractExpressionBuilderContext).getAttributeName();
            }
            this.setTitle(DM4JVersion.getFullBrowserName() + " - " + DM4JResourceUtilities.getUIString("EXPBLDR_TITLE"));
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(735, 532));
        WindowUtils.centerWindow((Window)this);
        this.m_dialogPanel = new ExpressionBuilderMainPanel(this.m_ebc, this);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.m_dialogPanel, "Center");
        GriddedPanel griddedPanel = new GriddedPanel();
        JButton jButton = new JButton(DM4JResourceUtilities.getUIString("COMMON_OK"));
        JButton jButton2 = new JButton(DM4JResourceUtilities.getUIString("COMMON_CANCEL"));
        JButton jButton3 = new JButton(DM4JResourceUtilities.getUIString("COMMON_HELP"));
        JLabel jLabel = new JLabel();
        griddedPanel.addFilledComponent(jButton3, GriddedPanel.DIALOG_BOTTOM_LEFTMOST_BUTTON, 0, 0, 1, 1, 2);
        griddedPanel.addFilledComponent(jLabel, GriddedPanel.DIALOG_BOTTOM_MID_BUTTONS, 0, 1, 4, 1, 2);
        griddedPanel.addFilledComponent(jButton, GriddedPanel.DIALOG_BOTTOM_MID_BUTTONS, 0, 5, 1, 1, 2);
        griddedPanel.addFilledComponent(jButton2, GriddedPanel.DIALOG_BOTTOM_RIGHTMOST_BUTTON, 0, 6, 1, 1, 2);
        this.getContentPane().add((Component)griddedPanel, "South");
        this.getRootPane().setDefaultButton(jButton);
        this.getRootPane().registerKeyboardAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExpressionBuilderDialog.this.cancel_actionPerformed(actionEvent);
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExpressionBuilderDialog.this.ok_actionPerformed(actionEvent);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExpressionBuilderDialog.this.cancel_actionPerformed(actionEvent);
            }
        });
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExpressionBuilderDialog.this.help_actionPerformed(actionEvent);
            }
        });
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ExpressionBuilderDialog.this.setVisible(false);
                ExpressionBuilderDialog.this.dispose();
            }
        });
    }

    private void ok_actionPerformed(ActionEvent actionEvent) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (this.m_ebc instanceof ComputeFieldContext) {
            try {
                if (!this.validateAttributeName()) {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.m_dialogPanel.isExpressionDirty()) {
            boolean bl = false;
            try {
                if (this.validateExpression()) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                this.m_dialogPanel.setValidationAreaText(exception.getLocalizedMessage());
                String string = DM4JResourceUtilities.getUIString("EXPBLDR_ERROR_PARSE");
                this.showMessage(string, -1, 0);
            }
            if (!bl) {
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
        }
        this.m_isOk = true;
        this.setVisible(false);
        this.dispose();
    }

    protected void help_actionPerformed(ActionEvent actionEvent) {
        Help.registerClientWindow((Window)this);
        CSHManager cSHManager = BrowserFrame.getCSHManager();
        try {
            cSHManager.addComponent((Component)this, "EXPRESSION_EDITOR_DLG", true, false);
            cSHManager.showTopic("EXPRESSION_EDITOR_DLG");
        }
        catch (Exception exception) {
            JOptionPane.showOptionDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("COMMON_ERROR_NO_HELP"), DM4JVersion.getFullBrowserName(), -1, 0, null, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateAttributeName() throws Exception {
        Object object;
        String string = this.getAttributeName();
        String string2 = null;
        if (!(this.m_ebc instanceof ComputeFieldContext)) {
            throw new Exception("Unexpected usage context.");
        }
        ComputeFieldContext computeFieldContext = (ComputeFieldContext)this.m_ebc;
        if (null == string || string.equalsIgnoreCase("")) {
            string2 = DM4JResourceUtilities.getUIString("EXPBLDR_ERROR_ATTRIBUTE_EMPTY");
            this.showMessage(string2, -1, 0);
            return false;
        }
        if (!ValidationUtil.checkStringLength(string, 30)) {
            string2 = DM4JResourceUtilities.getUIString("EXPBLDR_ERROR_ATTRIBUTE_TOOLONG");
            this.showMessage(string2, -1, 0);
            return false;
        }
        if (ValidationUtil.containsDoubleQuote(string)) {
            string2 = DM4JResourceUtilities.getUIString("EXPBLDR_ERROR_ATTRIBUTE_HASDBLQUOTE");
            this.showMessage(string2, -1, 0);
            return false;
        }
        if (ValidationUtil.isEqualToROWID(string)) {
            string2 = DM4JResourceUtilities.getUIString("EXPBLDR_ERROR_ATTRIBUTE_NAME_RESERVED");
            this.showMessage(string2, -1, 0);
            return false;
        }
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            if (ValidationUtil.isGreater32BytesInDB(string, connection)) {
                string2 = DM4JResourceUtilities.getUIString("EXPBLDR_ERROR_ATTRIBUTE_32");
                this.showMessage(string2, -1, 0);
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (null != connection) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        Vector vector = this.m_dialogPanel.getSourceAttributeNames();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!string.equals(object) || string.equals(this.m_origAttribName)) continue;
            string2 = DM4JResourceUtilities.getUIString("EXPBLDR_ERROR_ATTRIBUTE_EXISTS_IN_SOURCE");
            this.showMessage(string2, -1, 0);
            return false;
        }
        object = computeFieldContext.getDefinedFieldNames();
        for (int i = 0; i < ((String[])object).length; ++i) {
            if (!string.equals(object[i]) || string.equals(this.m_origAttribName)) continue;
            string2 = DM4JResourceUtilities.getUIString("EXPBLDR_ERROR_ATTRIBUTE_NOT_UNIQUE");
            this.showMessage(string2, -1, 0);
            return false;
        }
        return true;
    }

    public boolean validateExpression() throws Exception {
        String string = this.getExpression();
        String string2 = null;
        if (null == string || string.equalsIgnoreCase("")) {
            string2 = DM4JResourceUtilities.getUIString("EXPBLDR_ERROR_EXPRESSION_EMPTY");
            this.showMessage(string2, -1, 0);
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        if (this.m_ebc instanceof ComputeFieldContext) {
            stringBuffer.append(this.formNewAttributeQuery());
        } else if (this.m_ebc instanceof AggregateContext) {
            stringBuffer.append(this.formAggregateQuery());
        } else if (this.m_ebc instanceof Filter2DContext) {
            stringBuffer.append(this.formFilter2DQuery());
        } else {
            throw new Exception("Unexpected ExpressionBuilderContext type encountered");
        }
        StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.toString());
        StringBuffer[] stringBufferArray = new StringBuffer[]{stringBuffer2};
        PLSQLAnonymousBlock pLSQLAnonymousBlock = new PLSQLAnonymousBlock(stringBufferArray, true);
        String string3 = pLSQLAnonymousBlock.getResult();
        Connection connection = null;
        String string4 = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)connection.prepareCall(string3);
            oracleCallableStatement.registerOutParameter(1, 12);
            oracleCallableStatement.execute();
            string4 = oracleCallableStatement.getString(1);
            if (null != string4 && string4.length() > 0) {
                throw new Exception(string4);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return true;
    }

    private String formNewAttributeQuery() {
        Object[] objectArray = new Object[]{this.getExpression(), this.getAttributeName(), this.m_ebc.getSchemaName(), this.m_ebc.getTableName()};
        return MessageFormat.format(newAttributeQuery, objectArray);
    }

    private String formAggregateQuery() {
        String string = aggregateQuery;
        AggregateContext aggregateContext = (AggregateContext)this.m_ebc;
        String string2 = null;
        String string3 = null;
        if (aggregateContext.isGroupBy()) {
            string2 = this.getExpression();
            string3 = aggregateContext.getHavingExpression();
        } else {
            string2 = aggregateContext.getGroupByExpression();
            string3 = this.getExpression();
        }
        boolean bl = false;
        boolean bl2 = false;
        if (null != string2 && string2.length() > 0) {
            bl = true;
        }
        if (null != string3 && string3.length() > 0) {
            bl2 = true;
        }
        Object[] objectArray = new Object[]{aggregateContext.getSelectClause(), aggregateContext.getSchemaName(), aggregateContext.getTableName()};
        string = MessageFormat.format(aggregateQuery, objectArray);
        if (bl) {
            string = string + " GROUP BY " + string2;
        }
        if (bl2) {
            string = string + " HAVING " + string3;
        }
        return string;
    }

    private String formFilter2DQuery() {
        Filter2DContext filter2DContext = (Filter2DContext)this.m_ebc;
        Object[] objectArray = new Object[]{filter2DContext.getSchemaName(), filter2DContext.getTableName(), this.getExpression()};
        String string = MessageFormat.format(filter2DQuery, objectArray);
        return string;
    }

    private void cancel_actionPerformed(ActionEvent actionEvent) {
        this.m_isOk = false;
        this.setVisible(false);
        this.dispose();
    }

    public String getAttributeName() {
        return this.m_dialogPanel.getAttributeName();
    }

    public String getExpression() {
        return this.m_dialogPanel.getExpression();
    }

    public boolean isOk() {
        return this.m_isOk;
    }

    private int showMessage(String string, int n, int n2) {
        return JOptionPane.showOptionDialog(this, string, DM4JVersion.getFullBrowserName(), n, n2, null, null, null);
    }
}

