/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.diag;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Date;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import javax.datamining.Enum;
import javax.datamining.MiningAlgorithm;
import javax.datamining.MiningObject;
import javax.datamining.association.AssociationModel;
import javax.datamining.base.Model;
import javax.datamining.clustering.ClusteringModel;
import javax.datamining.supervised.classification.ClassificationTestMetrics;
import javax.datamining.supervised.regression.RegressionTestMetrics;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.dmt.dm4j.ConnectionPersistence;
import oracle.dmt.dm4j.ConnectionPersistenceInfo;
import oracle.dmt.dm4j.DM4JAccessibilityUtils;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.DM4JVersionException;
import oracle.dmt.dm4j.activity.ActivitySchema;
import oracle.dmt.dm4j.activity.task.ActivityTaskManager;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserPane;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.browser.UserPreferences;
import oracle.dmt.dm4j.browser.tree.ContextMenuHelper;
import oracle.dmt.dm4j.browser.tree.NavigationAction;
import oracle.dmt.dm4j.browser.tree.node.FolderNodeData;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.tree.node.NodeData;
import oracle.dmt.dm4j.browser.viewer.ConnectionFolderViewer;
import oracle.dmt.dm4j.browser.viewer.EmptySelectionPanel;
import oracle.dmt.dm4j.browser.viewer.FolderViewer;
import oracle.dmt.dm4j.browser.viewer.ListFolderViewer;
import oracle.dmt.dm4j.browser.viewer.LoadingStatusPanel;
import oracle.dmt.dm4j.browser.viewer.ModelViewer;
import oracle.dmt.dm4j.browser.viewer.RestoreFailedPanel;
import oracle.dmt.dm4j.browser.viewer.activity.ActivityViewer;
import oracle.dmt.dm4j.browser.viewer.association.AssociationModelViewer;
import oracle.dmt.dm4j.browser.viewer.attributeImportance.AttributeImportanceViewer;
import oracle.dmt.dm4j.browser.viewer.classification.ClassificationModelViewer;
import oracle.dmt.dm4j.browser.viewer.classification.DecisionTreeModelViewer;
import oracle.dmt.dm4j.browser.viewer.clustering.ClusteringModelViewer;
import oracle.dmt.dm4j.browser.viewer.featureExtraction.FeatureExtractionModelViewer;
import oracle.dmt.dm4j.browser.viewer.regression.RegressionModelViewer;
import oracle.dmt.dm4j.browser.viewer.results.apply.ApplyResultViewer;
import oracle.dmt.dm4j.browser.viewer.results.apply.ExplainResultViewer;
import oracle.dmt.dm4j.browser.viewer.results.apply.PredictResultViewer;
import oracle.dmt.dm4j.browser.viewer.results.apply.ResidualPlotResultViewer;
import oracle.dmt.dm4j.browser.viewer.table.TableViewer;
import oracle.dmt.dm4j.browser.viewer.task.ActiveActivitiesTable;
import oracle.dmt.dm4j.browser.viewer.task.ActiveTasksTable;
import oracle.dmt.dm4j.browser.viewer.task.TaskListPanel;
import oracle.dmt.dm4j.browser.viewer.task.TasksTableModel;
import oracle.dmt.dm4j.browser.viewer.testMetrics.ClassificationTestMetricsViewer;
import oracle.dmt.dm4j.browser.viewer.testMetrics.RegressionTestMetricsViewer;
import oracle.dmt.dm4j.browser.worker.RefreshObjectsWorker;
import oracle.dmt.dm4j.browser.worker.WorkerThreadManager;
import oracle.dmt.dm4j.browser.worker.listener.WorkerThreadListener;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.dm4j.diag.ActivityDiagViewer;
import oracle.dmt.dm4j.diag.NavigatorTree;
import oracle.dmt.dm4j.integrator.disco.DiscoIntegrationManager;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.jdm.OraMiningAlgorithm;
import oracle.dmt.jdm.attributeimportance.OraAttributeImportanceModel;
import oracle.dmt.jdm.base.OraModel;
import oracle.dmt.jdm.clustering.OraClusteringModel;
import oracle.dmt.jdm.jdmresult.OraMiningApplyResult;
import oracle.dmt.jdm.jdmresult.OraMiningExplainResult;
import oracle.dmt.jdm.jdmresult.OraMiningPredictResult;

public class DiagFrame
extends JFrame
implements WorkerThreadListener {
    private static DiagFrame s_frameInstance = null;
    private JScrollPane m_navigatorScrollPane = new JScrollPane();
    private JScrollPane m_viewerScrollPane = new JScrollPane();
    private int m_splitterDivPos = 0;
    private int m_navSplitterDivPos = 400;
    protected JMenuItem m_menuViewForward = new JMenuItem();
    protected JMenuItem m_menuViewBack = new JMenuItem();
    protected JButton m_buttonHelp = new JButton();
    protected JButton m_buttonClose = new JButton();
    protected JButton m_buttonOpen = new JButton();
    protected JToolBar m_toolBar = new JToolBar();
    protected JLabel m_statusBar = new JLabel();
    protected BorderLayout m_borderLayout = new BorderLayout();
    protected JSplitPane m_splitPane = new JSplitPane();
    protected JSplitPane m_navSplitPane = new JSplitPane(0);
    protected NavigatorTree m_navigatorTree = null;
    private ActiveTasksTable m_activeTaskTable = null;
    private ActiveActivitiesTable m_activeActivitiesTable = null;
    private BrowserPane m_navPane = null;
    private BrowserPane m_taskPane = null;
    private BrowserPane m_activityPane = null;
    private JTabbedPane m_activeTasksPane = new JTabbedPane(3);
    public static Dimension m_prefLeftPaneSize = new Dimension(100, 500);
    public static Dimension m_prefRightPaneSize = new Dimension(200, 500);
    private String m_user;
    private String m_host;
    private String m_port;
    private String m_sid;
    private static boolean m_noDesignFeatures = false;
    private static boolean s_noContextGrant = false;
    private static ProgressBar m_progressDlg;
    private static final int MAX_THREAD_ALLOWED = 10;
    private static final int ALLOW_REFRESH = 1;
    private WorkerThreadManager m_workerThreadManager = null;
    private int m_state = 1;
    private Date m_lastRefreshTime = null;
    private int m_maxThreadAllowed = 10;
    private LinkedList m_ignoredActions = new LinkedList();
    private Stack m_backStack = new Stack();
    private Stack m_forwardStack = new Stack();
    private NavigationAction m_currentAction = null;
    private LinkedList m_loadObjectQueue = new LinkedList();
    private static Exception s_connectionException;
    private static boolean s_usingConnectionManager;
    private String m_findTaskName = null;
    private static Exception s_syncException;

    public static ProgressBar getProgressDlg() {
        return m_progressDlg;
    }

    public DiagFrame(String string, String string2, String string3, String string4, boolean bl) {
        this.m_user = string;
        this.m_host = string2;
        this.m_port = string3;
        this.m_sid = string4;
        m_noDesignFeatures = bl;
        try {
            this.jbInit();
            this.m_workerThreadManager = WorkerThreadManager.getInstance();
            this.m_workerThreadManager.addWorkerThreadListener(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static DiagFrame getMainFrame() {
        return s_frameInstance;
    }

    public boolean isTaskObjectType(String string) {
        if (null == string) {
            return false;
        }
        return string.equals("TASKS") || string.equals("BUILD_TASK") || string.equals("APPLY_TASK") || string.equals("TEST_TASK") || string.equals("LIFT_TASK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static boolean validateDMSConnection() throws Exception {
        var0 = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                javax.datamining.resource.Connection connection = null;
                s_connectionException = null;
                try {
                    try {
                        connection = DM4JConnectionManager.getConnection();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        throw new Exception(DM4JResourceUtilities.getUIString("DMS_CONNECTION_NOCREATE"));
                    }
                }
                catch (Exception exception) {
                    s_connectionException = exception;
                }
                finally {
                    m_progressDlg.setDoneStatus();
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        };
        DiagFrame.m_progressDlg = new ProgressBar(DiagFrame.s_frameInstance, DM4JResourceUtilities.getUIString("CONNECT_PROGRESS_NAME"), var0, true);
        if (DiagFrame.isDisableDesignFeatures()) {
            var1_1 = new Thread(var0);
            var1_1.start();
            try {
                var1_1.join();
            }
            catch (Exception var2_2) {
                DiagFrame.s_connectionException = new Exception(var2_2);
                return (boolean)DiagFrame.s_connectionException;
            }
            finally {
                if (DiagFrame.s_connectionException == null) ** GOTO lbl19
                throw DiagFrame.s_connectionException;
            }
        } else {
            DiagFrame.m_progressDlg.start(DM4JResourceUtilities.getUIString("CONNECT_PROGRESS_TITLE"), "");
            DiagFrame.m_progressDlg.waitUntilDone();
            if (DiagFrame.m_progressDlg.hasUserCancelled()) {
                return false;
            }
        }
lbl19:
        // 4 sources

        if (DiagFrame.m_progressDlg.hasUserCancelled()) {
            return false;
        }
        if (DiagFrame.s_connectionException != null) {
            var1_1 = null;
            var1_1 = DiagFrame.s_connectionException instanceof DM4JVersionException != false ? ((DM4JVersionException)DiagFrame.s_connectionException).getDetailText() : DiagFrame.s_connectionException.getLocalizedMessage();
            JOptionPane.showOptionDialog(DiagFrame.s_frameInstance, var1_1, DM4JVersion.getFullBrowserName(), -1, 0, null, null, null);
            return false;
        }
        return true;
    }

    private static DiagFrame getBrowserInstance(String string, char[] cArray, String string2) throws Exception {
        int n = string2.indexOf(64);
        String string3 = string2.substring(n + 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ":");
        String string4 = stringTokenizer.nextToken();
        String string5 = stringTokenizer.nextToken();
        String string6 = stringTokenizer.nextToken();
        return DiagFrame.getBrowserInstance(string, cArray, string4, string5, string6, false, false);
    }

    public static DiagFrame getBrowserInstance(ConnectionPersistenceInfo connectionPersistenceInfo, char[] cArray) throws Exception {
        s_usingConnectionManager = true;
        String string = connectionPersistenceInfo.isUsingServiceName() ? connectionPersistenceInfo.getServiceName() : connectionPersistenceInfo.getSid();
        return DiagFrame.getBrowserInstance(connectionPersistenceInfo.getUser(), cArray, connectionPersistenceInfo.getHost(), connectionPersistenceInfo.getPort(), string, connectionPersistenceInfo.isUsingServiceName(), false);
    }

    private static DiagFrame getBrowserInstance(String string, char[] cArray, String string2, String string3, String string4) throws Exception {
        return DiagFrame.getBrowserInstance(string, cArray, string2, string3, string4, false, false);
    }

    private static DiagFrame getBrowserInstance(String string, char[] cArray, String string2, String string3, String string4, boolean bl, boolean bl2) throws Exception {
        Object object;
        Object object2;
        Object object3;
        String string5;
        Object object4;
        Object object5;
        DiagFrame diagFrame;
        string = string.toUpperCase();
        try {
            UserPreferences.init();
        }
        catch (Exception exception) {
            JOptionPane.showOptionDialog(DiagFrame.getMainFrame(), DM4JResourceUtilities.getUIString("PREF_ERROR_CANNOT_LOAD"), DM4JVersion.getFullBrowserName(), -1, 0, null, null, null);
        }
        if (null == s_frameInstance) {
            s_frameInstance = new DiagFrame(string, string2, string3, string4, bl2);
            try {
                DM4JConnectionManager.initialize(string2, string3, string4, bl, string, cArray, Locale.getDefault());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (!DiagFrame.validateDMSConnection()) {
                s_frameInstance.dispose();
                s_frameInstance = null;
                throw new Exception("Failed to connect to Data Mining Server");
            }
        } else {
            diagFrame = DiagFrame.getMainFrame();
            object5 = DM4JConnectionManager.getUser();
            object4 = diagFrame.getConnectionHost();
            string5 = diagFrame.getConnectionPort();
            object3 = diagFrame.getConnectionSid();
            if (!diagFrame.isConnectionInfoEqual(string, string2, string3, string4)) {
                diagFrame.setConnectionUser(string);
                diagFrame.setConnectionHost(string2);
                diagFrame.setConnectionPort(string3);
                diagFrame.setConnectionSid(string4);
                diagFrame.m_maxThreadAllowed = 1;
                if (!DiagFrame.validateDMSConnection()) {
                    diagFrame.setConnectionUser((String)object5);
                    diagFrame.setConnectionHost((String)object4);
                    diagFrame.setConnectionPort(string5);
                    diagFrame.setConnectionSid((String)object3);
                    throw new Exception("New connection not created.  Original connection restored.");
                }
                diagFrame.setCursor(new Cursor(3));
                object2 = new Runnable(){

                    public void run() {
                        diagFrame.setUIState(4);
                        diagFrame.emptyViewer();
                        diagFrame.m_navigatorTree.clearSelectedPaths();
                        diagFrame.m_maxThreadAllowed = 10;
                        RefreshObjectsWorker refreshObjectsWorker = (RefreshObjectsWorker)diagFrame.m_workerThreadManager.getRefreshObjectsWorker(diagFrame.m_navigatorTree.getTreeModel());
                        refreshObjectsWorker.addRefreshedListener(diagFrame.m_navigatorTree);
                        diagFrame.m_lastRefreshTime = new Date();
                        refreshObjectsWorker.start();
                    }
                };
                object = new Thread((Runnable)object2);
                ((Thread)object).start();
            }
        }
        diagFrame = DiagFrame.getMainFrame();
        object5 = (DefaultMutableTreeNode)diagFrame.m_navigatorTree.getModel().getRoot();
        object4 = (FolderNodeData)((DefaultMutableTreeNode)object5).getUserObject();
        string5 = null;
        object3 = ConnectionPersistence.getInstance();
        try {
            string5 = s_usingConnectionManager ? ((ConnectionPersistence)object3).getDefaultConnectionName() : DM4JConnectionManager.getUser();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string5 == null) {
            string5 = DM4JConnectionManager.getUser();
        }
        ((NodeData)object4).setName(string5);
        object2 = null;
        try {
            object2 = DM4JConnectionManager.getDbConnection();
            if (!DMEMetadata.validateRequiredUserGrants((Connection)object2)) {
                JOptionPane.showOptionDialog(DiagFrame.getMainFrame(), "User does not have all the necessary grants to access Oracle Data Mining option. \nRequired Grants are: \ngrant create procedure \ngrant create session \ngrant create table \ngrant create sequence \ngrant create view \ngrant create job \ngrant create type \ngrant create synonym \ngrant execute on ctxsys.ctx_ddl", DM4JVersion.getFullBrowserName(), -1, 0, null, null, null);
                System.exit(0);
            }
            if (!DMEMetadata.validateContextUserGrants((Connection)object2)) {
                JOptionPane.showOptionDialog(BrowserFrame.getMainFrame(), "User does not have all the necessary grants to use the text mining features. \nText mining features have been disabled. \n\nDatabase option must be installed, and a grant is required to use the text mining features: \n\ngrant execute on ctxsys.ctx_ddl", DM4JVersion.getFullBrowserName(), -1, 1, null, null, null);
                s_noContextGrant = true;
            }
        }
        catch (Exception exception) {
            throw new Exception("Failure in attempting to validate if user has all necessary grants for performing data mining.", exception);
        }
        finally {
            if (object2 != null) {
                try {
                    object2.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        object = null;
        try {
            object = DM4JConnectionManager.getDbConnection();
            if (ActivitySchema.isSchemaExists((Connection)object)) {
                int n;
                int n2;
                String string6;
                if (!DiscoIntegrationManager.hasDiscoODMrGatewayCreated((Connection)object)) {
                    DiscoIntegrationManager.createDiscoODMrGateway((Connection)object, true);
                }
                if (!DMEMetadata.isSchemaTablesExisted((Connection)object)) {
                    string6 = DM4JResourceUtilities.getUIString("DMS_MAIN_SCHEMA_CORRUPTED");
                    n2 = JOptionPane.showOptionDialog(DiagFrame.getMainFrame(), string6, DM4JVersion.getFullBrowserName(), 0, 2, null, null, null);
                    if (n2 == 0) {
                        ActivitySchema.dropSchema((Connection)object, false);
                        DMEMetadata.dropSchema((Connection)object);
                        ActivitySchema.createSchema((Connection)object);
                        DMEMetadata.createSchema((Connection)object);
                    } else {
                        System.exit(0);
                    }
                }
                if (!DiscoIntegrationManager.IsDiscoODMrGatewayExisted((Connection)object)) {
                    string6 = DM4JResourceUtilities.getUIString("DMS_DISCO_SCHEMA_CORRUPTED");
                    n2 = JOptionPane.showOptionDialog(DiagFrame.getMainFrame(), string6, DM4JVersion.getFullBrowserName(), 0, 2, null, null, null);
                    if (n2 == 0) {
                        DiscoIntegrationManager.dropSchema((Connection)object);
                        DiscoIntegrationManager.createDiscoODMrGateway((Connection)object, true);
                    } else {
                        System.exit(0);
                    }
                }
                if (!DMEMetadata.isSchemaViewsExisted((Connection)object)) {
                    DMEMetadata.createViews((Connection)object);
                }
                if (!ActivitySchema.isEqualVersion(n = ActivitySchema.getVersion((Connection)object))) {
                    String string7 = ActivitySchema.isOlderVersion(n) ? "WARNING: An older Data Miner schema version has been detected.\n\nThis version may not be compatible with this version of Data Miner.\n\nContinue?" : "WARNING: A newer Data Miner schema version has been detected.\n\nThis newer version may not compatible with this version of Data Miner.\n\nContinue?";
                    int n3 = JOptionPane.showOptionDialog(DiagFrame.getMainFrame(), string7, DM4JVersion.getFullBrowserName(), 0, 2, null, null, null);
                    if (n3 != 0) {
                        System.exit(0);
                    }
                }
                DMEMetadata.migration((Connection)object);
            } else {
                ActivitySchema.createSchema((Connection)object);
                DMEMetadata.createSchema((Connection)object);
                DiscoIntegrationManager.createDiscoODMrGateway((Connection)object, true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Exception("Failed to initialize activity schema", exception);
        }
        finally {
            if (object != null) {
                try {
                    object.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return s_frameInstance;
    }

    private void saveSplitterPos() {
        this.m_splitterDivPos = this.m_splitPane.getDividerLocation();
    }

    private void restoreSplitterPos() {
        this.m_splitPane.setDividerLocation(this.m_splitterDivPos);
    }

    public void saveFrameDimensions() {
        UserPreferences userPreferences = UserPreferences.getInstance();
        try {
            Dimension dimension = this.getSize();
            userPreferences.setIntegerValue("oracle.dmt.dm4j.browser.BrowserFrame.height", (int)dimension.getHeight());
            userPreferences.setIntegerValue("oracle.dmt.dm4j.browser.BrowserFrame.width", (int)dimension.getWidth());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void restoreFrameDimensions() {
        UserPreferences userPreferences = UserPreferences.getInstance();
        Integer n = userPreferences.getIntegerValue("oracle.dmt.dm4j.browser.BrowserFrame.height");
        Integer n2 = userPreferences.getIntegerValue("oracle.dmt.dm4j.browser.BrowserFrame.width");
        Dimension dimension = new Dimension(790, 590);
        if (n == null || n2 == null) {
            n = new Integer((int)dimension.getHeight());
            n2 = new Integer((int)dimension.getWidth());
        }
        dimension.setSize(n2.doubleValue(), n.doubleValue());
        this.setSize(dimension);
    }

    private void jbInit() throws Exception {
        UserPreferences userPreferences = UserPreferences.getInstance();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                int n;
                ActivityTaskManager activityTaskManager = ActivityTaskManager.getInstance();
                if (activityTaskManager.isRunningTasks() && (n = JOptionPane.showOptionDialog(DiagFrame.getMainFrame(), "Discontinue all current and subsequent client activity steps and exit client?.\n\nNOTE: Currently executing server tasks will not be stopped. To stop server tasks, click \"Stop Activity\" on the activity window.", DM4JVersion.getFullBrowserName(), 0, 2, null, null, null)) == 1) {
                    return;
                }
                DiagFrame.getMainFrame().saveFrameDimensions();
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                DM4JConnectionManager.close();
                s_frameInstance = null;
                System.exit(0);
            }
        });
        ImageIcon imageIcon = (ImageIcon)IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/client.gif");
        this.setIconImage(imageIcon.getImage());
        this.getContentPane().setLayout(this.m_borderLayout);
        this.restoreFrameDimensions();
        this.setTitle(DM4JVersion.getFullBrowserName());
        this.m_splitPane.setDividerSize(5);
        this.m_splitPane.setDividerLocation(200);
        this.getContentPane().add((Component)this.m_statusBar, "South");
        String string = DM4JResourceUtilities.getUIString("PANE_NAVIGATOR");
        String string2 = DM4JResourceUtilities.getUIString("PANE_ACTIVE_TASKS");
        String string3 = DM4JResourceUtilities.getUIString("PANE_ACTIVITIY_TASKS");
        this.m_navigatorTree = new NavigatorTree();
        DM4JAccessibilityUtils.setAccessibleName(this.m_navigatorTree, string);
        this.m_navigatorTree.setMainFrame(this);
        this.m_activeTaskTable = new ActiveTasksTable();
        this.m_activeActivitiesTable = new ActiveActivitiesTable();
        DM4JAccessibilityUtils.setAccessibleName(this.m_activeTaskTable, string2);
        DM4JAccessibilityUtils.setAccessibleName(this.m_activeActivitiesTable, string3);
        this.m_navPane = new BrowserPane(this.m_navigatorTree);
        this.m_taskPane = new BrowserPane(this.m_activeTaskTable);
        this.m_activityPane = new BrowserPane(this.m_activeActivitiesTable);
        this.m_activeTasksPane.addTab("Activities", this.m_activityPane);
        this.m_activeTasksPane.addTab("Server", this.m_taskPane);
        this.m_splitPane.setBorder(BorderFactory.createEmptyBorder());
        this.m_navSplitPane.setBorder(BorderFactory.createEmptyBorder());
        this.m_navPane.setTitle(string);
        this.m_taskPane.setTitle(string2);
        this.m_activityPane.setTitle(string3);
        boolean bl = userPreferences.getBooleanValue("ShowActiveTasksPane");
        if (bl) {
            this.m_navSplitPane.setDividerLocation(400);
            this.m_navSplitPane.setTopComponent(this.m_navPane);
            this.m_navSplitPane.setBottomComponent(this.m_activeTasksPane);
            this.m_splitPane.add((Component)this.m_navSplitPane, "left");
        } else {
            this.m_splitPane.setLeftComponent(this.m_navPane);
        }
        String string4 = DM4JResourceUtilities.getUIString("COMMON_NO_ITEM_SELECTED");
        EmptySelectionPanel emptySelectionPanel = new EmptySelectionPanel(string4);
        DM4JAccessibilityUtils.setAccessibleName(emptySelectionPanel, string4);
        this.m_splitPane.add((Component)emptySelectionPanel, "right");
        this.createMenuBar();
        ToolTipManager.sharedInstance().registerComponent(this.m_navigatorTree);
        this.getContentPane().add((Component)this.m_splitPane, "Center");
        this.m_lastRefreshTime = new Date();
        this.m_navigatorScrollPane.setMinimumSize(m_prefLeftPaneSize);
        this.m_viewerScrollPane.setMinimumSize(m_prefRightPaneSize);
    }

    private void createMenuBar() {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu();
        JMenuItem jMenuItem = new JMenuItem();
        this.setJMenuBar(jMenuBar);
        jMenu.setText(DM4JResourceUtilities.getUIString("MENU_FILE"));
        jMenu.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "MENU_FILE"));
        jMenuItem.setText(DM4JResourceUtilities.getUIString("MENU_FILE_EXIT"));
        jMenuItem.setMnemonic(DM4JResourceUtilities.getUIMnemonic(dM4JListResourceBundle, "MENU_FILE_EXIT"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DiagFrame.this.fileExit_ActionPerformed();
            }
        });
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        class MenuListener
        extends MouseAdapter {
            MenuListener() {
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.doPopup(mouseEvent);
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.doPopup(mouseEvent);
                }
            }

            private void doPopup(MouseEvent mouseEvent) {
                int n;
                int n2 = mouseEvent.getX();
                TreePath treePath = DiagFrame.this.m_navigatorTree.getPathForLocation(n2, n = mouseEvent.getY());
                if (treePath != null) {
                    JPopupMenu jPopupMenu = null;
                    int n3 = DiagFrame.this.m_navigatorTree.getSelectionCount();
                    if (n3 == 1) {
                        DefaultMutableTreeNode defaultMutableTreeNode = DiagFrame.this.getTreeNode(treePath);
                        DiagFrame.this.m_navigatorTree.setSelectionPath(treePath);
                        if (defaultMutableTreeNode.isLeaf()) {
                            jPopupMenu = ContextMenuHelper.createContextMenu(defaultMutableTreeNode);
                        }
                    } else if (n3 > 1) {
                        jPopupMenu = ContextMenuHelper.createContextMenu(null);
                    }
                    if (jPopupMenu != null) {
                        jPopupMenu.show(DiagFrame.this.m_navigatorTree, n2, n);
                    }
                }
            }
        }
        MenuListener menuListener = new MenuListener();
        this.m_navigatorTree.addMouseListener(menuListener);
        jMenu.addMouseListener(menuListener);
    }

    private String getObjectTypeUIString(String string) {
        String string2 = null;
        if (string.equals("ASSOCIATION_RULES_SETTING")) {
            string2 = DM4JResourceUtilities.getUIString("STRING_ASSOCIATION_RULES_SETTINGS");
        } else if (string.equals("ATTRIBUTE_IMPORTANCE_SETTING")) {
            string2 = DM4JResourceUtilities.getUIString("STRING_ATTRIBUTE_IMPORTANCE_SETTINGS");
        } else if (string.equals("CLASSIFICATION_ABN_SETTING") || string.equals("CLASSIFICATION_NB_SETTING") || string.equals("CLASSIFICATION_MS_SETTING")) {
            string2 = DM4JResourceUtilities.getUIString("STRING_CLASSIFICATION_SETTINGS");
        } else if (string.equals("CLUSTERING_KMEANS_SETTING") || string.equals("CLUSTERING_OCLUSTER_SETTING")) {
            string2 = DM4JResourceUtilities.getUIString("STRING_CLUSTERING_SETTINGS");
        } else if (string.equals("ASSOCIATION_RULES_MODEL")) {
            string2 = DM4JResourceUtilities.getUIString("STRING_ASSOCIATION_RULES_MODEL");
        } else if (string.equals("ATTRIBUTE_IMPORTANCE_MODEL")) {
            string2 = DM4JResourceUtilities.getUIString("STRING_ATTRIBUTE_IMPORTANCE_MODELS");
        } else if (string.equals("ABN_MODEL") || string.equals("NB_MODEL") || string.equals("SVM_CLASSIFICATION_MODEL")) {
            string2 = DM4JResourceUtilities.getUIString("STRING_CLASSIFICATION_MODELS");
        } else if (string.equals("NMF_MODEL")) {
            string2 = DM4JResourceUtilities.getUIString("STRING_NMF_MODELS");
        } else if (string.equals("SVM_REGRESSION_MODEL")) {
            string2 = DM4JResourceUtilities.getUIString("STRING_REGRESSION_MODELS");
        } else if (string.equals("CLUSTERING_OCLUSTER_MODEL") || string.equals("CLUSTERING_KMEANS_MODEL")) {
            string2 = DM4JResourceUtilities.getUIString("STRING_CLUSTERING_MODELS");
        } else if (string.equals("BUILD_RESULT")) {
            string2 = DM4JResourceUtilities.getUIString("STRING_BUILD_RESULTS");
        } else if (string.equals("TEST_RESULT")) {
            string2 = DM4JResourceUtilities.getUIString("STRING_TEST_RESULTS");
        } else if (string.equals("APPLY_RESULT")) {
            string2 = DM4JResourceUtilities.getUIString("STRING_APPLY_RESULTS");
        } else if (string.equals("PREDICT_RESULT")) {
            string2 = DM4JResourceUtilities.getUIString("STRING_PREDICT_RESULTS");
        } else if (string.equals("EXPLAIN_RESULT")) {
            string2 = DM4JResourceUtilities.getUIString("STRING_EXPLAIN_RESULTS");
        } else if (string.equals("MODELSEEKER_RESULT")) {
            string2 = DM4JResourceUtilities.getUIString("STRING_MODELSEEKER_RESULTS");
        } else if (string.equals("TABLE")) {
            string2 = DM4JResourceUtilities.getUIString("STRING_TABLE");
        } else if (string.equals("VIEW")) {
            string2 = DM4JResourceUtilities.getUIString("STRING_VIEW");
        } else if (string.equals("ASSOCIATION_RULES_ACTIVITY") || string.equals("ATTRIBUTE_IMPORTANCE_ACTIVITY") || string.equals("CLASSIFICATION_ACTIVITY") || string.equals("REGRESSION_ACTIVITY") || string.equals("FEATURE_EXTRACTION_ACTIVITY") || string.equals("ANOMALY_DETECTION_ACTIVITY") || string.equals("CLUSTERING_ACTIVITY")) {
            string2 = DM4JResourceUtilities.getUIString("STRING_MINING_ACTIVITY");
        } else if (string.equals("CLASSIFICATION_ACTIVITY_APPLY") || string.equals("REGRESSION_ACTIVITY_APPLY") || string.equals("FEATURE_EXTRACTION_ACTIVITY_APPLY") || string.equals("ANOMALY_DETECTION_ACTIVITY_APPLY") || string.equals("CLUSTERING_ACTIVITY_APPLY")) {
            string2 = DM4JResourceUtilities.getUIString("STRING_MINING_APPLY_ACTIVITY");
        } else if (string.equals("CLASSIFICATION_ACTIVITY_TEST") || string.equals("REGRESSION_ACTIVITY_TEST")) {
            string2 = DM4JResourceUtilities.getUIString("STRING_MINING_TEST_ACTIVITY");
        }
        return string2;
    }

    public void emptyViewer() {
        this.saveSplitterPos();
        this.m_splitPane.add((Component)this.m_viewerScrollPane, "right");
        this.restoreSplitterPos();
    }

    public void loadViewer(NodeData nodeData, javax.datamining.resource.Connection connection, int n) {
        String string = DM4JVersion.getFullBrowserName();
        DiagFrame.getMainFrame().setTitle(string);
        this.saveSplitterPos();
        if (nodeData == null) {
            this.loadMultipleSelectionViewer();
        } else if (nodeData instanceof FolderNodeData) {
            this.loadFolderViewer((FolderNodeData)nodeData);
            this.setTitle(nodeData);
        } else if (nodeData instanceof LeafNodeData) {
            this.loadLeafViewer((LeafNodeData)nodeData, connection, n);
            this.setTitle(nodeData);
        }
        this.m_navigatorTree.requestFocus();
        this.restoreSplitterPos();
    }

    public void loadTableViewer(LeafNodeData leafNodeData, TableViewer tableViewer) {
        this.saveSplitterPos();
        this.m_splitPane.add((Component)tableViewer, "right");
        this.setTitle(leafNodeData);
        this.m_navigatorTree.requestFocus();
        this.restoreSplitterPos();
    }

    public void loadActivityViewer(LeafNodeData leafNodeData, ActivityViewer activityViewer) {
        JComponent jComponent = new ActivityDiagViewer(leafNodeData, activityViewer);
        this.saveSplitterPos();
        if (null == activityViewer) {
            jComponent = new RestoreFailedPanel();
        }
        this.m_splitPane.add((Component)jComponent, "right");
        this.restoreSplitterPos();
        this.m_navigatorTree.requestFocus();
        this.setTitle(leafNodeData);
    }

    private void setTitle(NodeData nodeData) {
        String string;
        String string2 = string = DM4JVersion.getFullBrowserName();
        String string3 = this.getObjectTypeUIString(nodeData.getNodeType());
        string2 = string3 != null ? string2 + " - " + string3 + " : " + nodeData.getName() : string2 + " : " + nodeData.getName();
        super.setTitle(string2);
    }

    public void loadMultipleSelectionViewer() {
        this.saveSplitterPos();
        EmptySelectionPanel emptySelectionPanel = new EmptySelectionPanel(DM4JResourceUtilities.getUIString("TREE_MULTI_SELECT"));
        this.m_splitPane.add((Component)emptySelectionPanel, "right");
        this.restoreSplitterPos();
    }

    public void loadEmptySelectionViewer() {
        this.saveSplitterPos();
        EmptySelectionPanel emptySelectionPanel = new EmptySelectionPanel(DM4JResourceUtilities.getUIString("COMMON_NO_ITEM_SELECTED"));
        this.m_splitPane.add((Component)emptySelectionPanel, "right");
        this.m_navigatorTree.requestFocus();
        this.restoreSplitterPos();
    }

    private void loadFolderViewer(FolderNodeData folderNodeData) {
        String string = folderNodeData.getNodeType();
        if (string.equals("CONNECTION")) {
            ConnectionFolderViewer connectionFolderViewer = new ConnectionFolderViewer();
            this.m_splitPane.add((Component)connectionFolderViewer, "right");
        } else {
            FolderViewer folderViewer = new FolderViewer(string);
            this.m_splitPane.add((Component)folderViewer, "right");
        }
    }

    public void loadListFolderViewer(FolderNodeData folderNodeData, ListFolderViewer listFolderViewer) {
        this.saveSplitterPos();
        String string = folderNodeData.getNodeType();
        this.setTitle(folderNodeData);
        if (string.equals("MODELS") || string.equals("RESULTS") || string.equals("ACTIVITIES") || string.equals("ANOMALY_DETECTION_ACTIVITIES") || string.equals("ASSOCIATION_RULES_ACTIVITIES") || string.equals("ATTRIBUTE_IMPORTANCE_ACTIVITIES") || string.equals("CLASSIFICATION_ACTIVITIES") || string.equals("CLUSTERING_ACTIVITIES") || string.equals("FEATURE_EXTRACTION_ACTIVITIES") || string.equals("REGRESSION_ACTIVITIES") || string.equals("CONNECTION") || string.equals("ANOMALY_DETECTION_MODELS") || string.equals("ASSOCIATION_RULES_MODELS") || string.equals("ATTRIBUTE_IMPORTANCE_MODELS") || string.equals("CLASSIFICATION_MODELS") || string.equals("CLUSTERING_MODELS") || string.equals("FEATURE_EXTRACTION_MODELS") || string.equals("REGRESSION_MODELS") || string.equals("APPLY_RESULTS") || string.equals("BUILD_RESULTS") || string.equals("EXPLAIN_RESULTS") || string.equals("PREDICT_RESULTS") || string.equals("RESIDUAL_PLOT_RESULTS") || string.equals("TEST_METRICS_RESULTS") || string.equals("SCHEMAS") || string.equals("SCHEMA") || string.equals("TABLES_SCHEMA") || string.equals("VIEWS_SCHEMA") || string.equals("DISCOGW")) {
            JScrollPane jScrollPane = new JScrollPane(listFolderViewer);
            jScrollPane.getViewport().setBackground(listFolderViewer.getBackground());
            jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.m_splitPane.add((Component)jScrollPane, "right");
        } else {
            FolderViewer folderViewer = new FolderViewer(string);
            this.m_splitPane.add((Component)folderViewer, "right");
        }
        this.restoreSplitterPos();
    }

    private void loadLeafViewer(LeafNodeData leafNodeData, javax.datamining.resource.Connection connection, int n) {
        Serializable serializable;
        MiningObject miningObject = leafNodeData.getOdmObject();
        String string = leafNodeData.getNodeType();
        if (this.isTaskObjectType(string)) {
            JSplitPane jSplitPane = new JSplitPane(0);
            TaskListPanel taskListPanel = new TaskListPanel(jSplitPane, this.m_findTaskName);
            this.m_findTaskName = null;
            EmptySelectionPanel emptySelectionPanel = new EmptySelectionPanel(DM4JResourceUtilities.getUIString("TASK_NO_SELECTION"));
            jSplitPane.setDividerLocation(200);
            jSplitPane.add((Component)taskListPanel, "top");
            jSplitPane.add((Component)emptySelectionPanel, "bottom");
            jSplitPane.setMinimumSize(m_prefRightPaneSize);
            this.m_splitPane.add((Component)jSplitPane, "right");
            return;
        }
        JComponent jComponent = null;
        try {
            if (miningObject instanceof OraModel) {
                serializable = ((Model)miningObject).getMiningAlgorithm();
                if (serializable == null) {
                    if (miningObject instanceof OraAttributeImportanceModel) {
                        serializable = OraMiningAlgorithm.minimumDescriptionLength;
                    } else if (miningObject instanceof OraClusteringModel) {
                        serializable = ((OraClusteringModel)miningObject).getMiningAlgorithm();
                    } else if (miningObject instanceof AssociationModel) {
                        serializable = OraMiningAlgorithm.aprioriAssociationRules;
                    }
                }
                if (((Enum)serializable).equals(OraMiningAlgorithm.aprioriAssociationRules)) {
                    jComponent = new AssociationModelViewer(leafNodeData, connection, n);
                    this.m_splitPane.add((Component)jComponent, "right");
                } else if (((Enum)serializable).equals(OraMiningAlgorithm.minimumDescriptionLength)) {
                    jComponent = new AttributeImportanceViewer(leafNodeData, connection, n);
                    this.m_splitPane.add((Component)jComponent, "right");
                } else if (((Enum)serializable).equals(OraMiningAlgorithm.adaptiveBayesNetwork)) {
                    jComponent = new ClassificationModelViewer(leafNodeData, connection, n);
                    this.m_splitPane.add((Component)jComponent, "right");
                } else if (((Enum)serializable).equals(MiningAlgorithm.naiveBayes)) {
                    jComponent = new ClassificationModelViewer(leafNodeData, connection, n);
                    this.m_splitPane.add((Component)jComponent, "right");
                } else if (((Enum)serializable).equals(MiningAlgorithm.decisionTree)) {
                    jComponent = new DecisionTreeModelViewer(leafNodeData, connection, n);
                    this.m_splitPane.add((Component)jComponent, "right");
                } else if (((Enum)serializable).equals(OraMiningAlgorithm.nonNegativeMatrixFactorization)) {
                    jComponent = new FeatureExtractionModelViewer(leafNodeData, connection, n);
                    this.m_splitPane.add((Component)jComponent, "right");
                } else if (((Enum)serializable).equals(MiningAlgorithm.svmClassification)) {
                    jComponent = new ClassificationModelViewer(leafNodeData, connection, n);
                    this.m_splitPane.add((Component)jComponent, "right");
                } else if (((Enum)serializable).equals(MiningAlgorithm.svmRegression)) {
                    jComponent = new RegressionModelViewer(leafNodeData, connection, n);
                    this.m_splitPane.add((Component)jComponent, "right");
                } else if (miningObject instanceof ClusteringModel) {
                    jComponent = new ClusteringModelViewer(this, leafNodeData, connection, n);
                    this.m_splitPane.add((Component)jComponent, "right");
                }
            } else if (miningObject instanceof OraMiningApplyResult) {
                jComponent = leafNodeData.getNodeType().endsWith("RESIDUAL_PLOT_RESULT") ? new ResidualPlotResultViewer(leafNodeData) : new ApplyResultViewer(leafNodeData);
                this.m_splitPane.add((Component)jComponent, "right");
            } else if (miningObject instanceof OraMiningPredictResult) {
                jComponent = new PredictResultViewer(leafNodeData);
                this.m_splitPane.add((Component)jComponent, "right");
            } else if (miningObject instanceof OraMiningExplainResult) {
                jComponent = new ExplainResultViewer(leafNodeData);
                this.m_splitPane.add((Component)jComponent, "right");
            } else if (miningObject instanceof ClassificationTestMetrics) {
                jComponent = new ClassificationTestMetricsViewer(leafNodeData, connection, n);
                this.m_splitPane.add((Component)jComponent, "right");
            } else if (miningObject instanceof RegressionTestMetrics) {
                jComponent = new RegressionTestMetricsViewer(leafNodeData);
                this.m_splitPane.add((Component)jComponent, "right");
            } else {
                jComponent = new RestoreFailedPanel();
                this.m_splitPane.add((Component)jComponent, "right");
            }
        }
        catch (Exception exception) {
            jComponent = new RestoreFailedPanel();
            this.m_splitPane.add((Component)jComponent, "right");
        }
        if (jComponent instanceof ModelViewer) {
            serializable = (ModelViewer)jComponent;
            ((JTabbedPane)serializable).setSelectedIndex(n);
        }
    }

    public void loadStatusPane() {
        this.saveSplitterPos();
        LoadingStatusPanel loadingStatusPanel = new LoadingStatusPanel();
        this.m_splitPane.add((Component)loadingStatusPanel, "right");
        this.m_navigatorTree.requestFocus();
        this.restoreSplitterPos();
    }

    private void fileExit_ActionPerformed() {
        DiagFrame diagFrame = DiagFrame.getMainFrame();
        diagFrame.dispatchEvent(new WindowEvent(diagFrame, 201));
    }

    public static boolean isDisableDesignFeatures() {
        return m_noDesignFeatures;
    }

    public static boolean isDisabledTextMining() {
        return s_noContextGrant;
    }

    public void setVisibleTasksPane(boolean bl) {
        if (bl) {
            this.m_splitterDivPos = this.m_splitPane.getDividerLocation();
            this.m_navSplitPane.setTopComponent(this.m_navPane);
            this.m_navSplitPane.setBottomComponent(this.m_activeTasksPane);
            this.m_splitPane.setLeftComponent(this.m_navSplitPane);
            this.m_splitPane.setDividerLocation(this.m_splitterDivPos);
            this.m_navSplitPane.setDividerLocation(this.m_navSplitterDivPos);
            UserPreferences userPreferences = UserPreferences.getInstance();
            try {
                userPreferences.setBooleanValue("ShowActiveTasksPane", true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            this.m_splitterDivPos = this.m_splitPane.getDividerLocation();
            this.m_navSplitterDivPos = this.m_navSplitPane.getDividerLocation();
            this.m_splitPane.setLeftComponent(this.m_navPane);
            this.m_splitPane.setDividerLocation(this.m_splitterDivPos);
            UserPreferences userPreferences = UserPreferences.getInstance();
            try {
                userPreferences.setBooleanValue("ShowActiveTasksPane", false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private boolean isVisibleTasksPane() {
        Component component = this.m_splitPane.getLeftComponent();
        boolean bl = component instanceof JSplitPane;
        return bl;
    }

    public void showRunningTask(final String string, boolean bl, final boolean bl2) {
        Component component;
        if (!this.isVisibleTasksPane() && bl2) {
            this.setVisibleTasksPane(true);
        }
        if ((component = this.m_navSplitPane.getBottomComponent()) instanceof JTabbedPane) {
            JTable jTable;
            JTabbedPane jTabbedPane = (JTabbedPane)component;
            jTabbedPane.setSelectedIndex(bl ? 1 : 0);
            JTable jTable2 = jTable = bl ? this.m_activeTaskTable : this.m_activeActivitiesTable;
            if (!bl) {
                this.m_activeActivitiesTable.refresh(this.m_activeActivitiesTable);
            }
            Runnable runnable = new Runnable(){

                public void run() {
                    Object object;
                    TasksTableModel tasksTableModel = (TasksTableModel)jTable.getModel();
                    int n = tasksTableModel.findTaskIndex(string);
                    if (n >= 0) {
                        object = jTable.getSelectionModel();
                        object.setSelectionInterval(n, n);
                    }
                    if (!bl2 || n < 0) {
                        return;
                    }
                    object = new Runnable(){
                        private boolean shouldShow = false;
                        private final Color bCol;
                        private final Color fCol;
                        {
                            this.bCol = jTable.getSelectionBackground();
                            this.fCol = jTable.getSelectionForeground();
                        }

                        public void run() {
                            this.shouldShow = !this.shouldShow;
                            if (this.shouldShow) {
                                jTable.setSelectionBackground(this.fCol);
                                jTable.setSelectionForeground(this.bCol);
                            } else {
                                jTable.setSelectionBackground(this.bCol);
                                jTable.setSelectionForeground(this.fCol);
                            }
                        }
                    };
                    TimerTask timerTask = new TimerTask((Runnable)object){
                        private int count = 0;
                        final /* synthetic */ Runnable val$doFlashAction;
                        {
                            this.val$doFlashAction = runnable;
                        }

                        public void run() {
                            if (this.count > 3) {
                                this.cancel();
                                return;
                            }
                            EventQueue.invokeLater(this.val$doFlashAction);
                            ++this.count;
                        }
                    };
                    Timer timer = new Timer(true);
                    timer.schedule(timerTask, 0L, 200L);
                }
            };
            EventQueue.invokeLater(runnable);
        }
    }

    private void viewRefresh_ActionPerformed() {
        this.refresh();
    }

    private void refresh() {
        if (!this.checkThreadState(1) || !this.checkUIState(1)) {
            return;
        }
        this.m_navigatorTree.saveSelectedPaths();
        RefreshObjectsWorker refreshObjectsWorker = (RefreshObjectsWorker)this.m_workerThreadManager.getRefreshObjectsWorker(this.m_navigatorTree.getTreeModel());
        refreshObjectsWorker.addRefreshedListener(this.m_navigatorTree);
        this.setUIState(4);
        this.setCursor(new Cursor(3));
        this.m_lastRefreshTime = new Date();
        refreshObjectsWorker.start();
    }

    public void threadCountChanged(EventObject eventObject) {
        Object object = eventObject.getSource();
        int n = (Integer)object;
        if (n >= this.m_maxThreadAllowed) {
            this.setUIState(2);
            this.setCursor(new Cursor(3));
        } else {
            this.removeUIState(2);
            if (this.checkUIState(1)) {
                this.setCursor(new Cursor(0));
            }
        }
    }

    public void threadStateChanged(EventObject eventObject) {
    }

    public boolean checkUIState(int n) {
        return (this.m_state | n) == n;
    }

    public boolean checkThreadState(int n) {
        return (this.m_workerThreadManager.getState() | n) == n;
    }

    public void setUIState(int n) {
        this.m_state |= n;
    }

    public void removeUIState(int n) {
        this.m_state &= ~n;
    }

    private DefaultMutableTreeNode getTreeNode(TreePath treePath) {
        return (DefaultMutableTreeNode)treePath.getLastPathComponent();
    }

    public Date getLastRefreshTimestamp() {
        return this.m_lastRefreshTime;
    }

    private String getConnectionUser() {
        return this.m_user;
    }

    private void setConnectionUser(String string) {
        this.m_user = string;
    }

    private String getConnectionHost() {
        return this.m_host;
    }

    private void setConnectionHost(String string) {
        this.m_host = string;
    }

    private String getConnectionPort() {
        return this.m_port;
    }

    private void setConnectionPort(String string) {
        this.m_port = string;
    }

    private String getConnectionSid() {
        return this.m_sid;
    }

    public void setConnectionSid(String string) {
        this.m_sid = string;
    }

    public String getConnectionUrl() {
        return "jdbc:oracle:thin:@" + this.m_host + ":" + this.m_port + ":" + this.m_sid;
    }

    public boolean isConnectionInfoEqual(String string, String string2, String string3, String string4) {
        return string.equals(this.m_user) && string2.equals(this.m_host) && string3.equals(this.m_port) && string4.equals(this.m_sid);
    }

    public NavigatorTree getNavigatorTree() {
        return this.m_navigatorTree;
    }

    public ActiveTasksTable getActiveTasksTable() {
        return this.m_activeTaskTable;
    }

    public NodeData getSelectedNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_navigatorTree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode != null) {
            if (defaultMutableTreeNode.getUserObject() instanceof Boolean) {
                return null;
            }
            NodeData nodeData = (NodeData)defaultMutableTreeNode.getUserObject();
            return nodeData;
        }
        return null;
    }

    public LeafNodeData getSelectedLeafNode() {
        NodeData nodeData = this.getSelectedNode();
        if (null == nodeData) {
            return null;
        }
        if (nodeData instanceof LeafNodeData) {
            return (LeafNodeData)nodeData;
        }
        return null;
    }

    public void addLoadObjectAction(NavigationAction navigationAction) {
        this.m_loadObjectQueue.add(navigationAction);
    }

    public NavigationAction getLoadObjectAction(String string, String string2) {
        if (this.m_loadObjectQueue.isEmpty()) {
            return null;
        }
        NavigationAction navigationAction = (NavigationAction)this.m_loadObjectQueue.getLast();
        if (navigationAction.getName().equals(string) && navigationAction.getType().equals(string2)) {
            this.m_loadObjectQueue.removeLast();
            return navigationAction;
        }
        return null;
    }

    public void addIgnoreNavigationHistory(String string, String string2, String string3) {
        this.m_ignoredActions.addFirst(new NavigationAction(string, string2, string3));
    }

    public void addNavigationHistory(String string, String string2, String string3) {
        NavigationAction navigationAction;
        if (!this.m_ignoredActions.isEmpty() && (navigationAction = (NavigationAction)this.m_ignoredActions.getLast()).getName().equals(string2) && navigationAction.getType().equals(string3)) {
            this.m_ignoredActions.removeLast();
            this.updateViewHistoryMenu();
            return;
        }
        navigationAction = this.m_currentAction;
        NavigationAction navigationAction2 = new NavigationAction(string, string2, string3);
        Component component = this.m_splitPane.getRightComponent();
        if (component instanceof ModelViewer) {
            ModelViewer modelViewer = (ModelViewer)component;
            int n = modelViewer.getSelectedIndex();
            if (navigationAction != null) {
                navigationAction.setTabIndex(n);
            }
        }
        this.m_currentAction = navigationAction2;
        if (null != navigationAction) {
            this.m_backStack.push(navigationAction);
            this.m_forwardStack.removeAllElements();
        }
        this.updateViewHistoryMenu();
    }

    private void viewBack_ActionPerformed() {
        this.setCursor(new Cursor(3));
        if (null != this.m_currentAction) {
            this.m_forwardStack.push(this.m_currentAction);
            this.m_currentAction = null;
        }
        if (this.m_backStack.isEmpty()) {
            this.updateViewHistoryMenu();
            this.setCursor(new Cursor(0));
            return;
        }
        NavigationAction navigationAction = (NavigationAction)this.m_backStack.pop();
        TreePath treePath = null;
        treePath = navigationAction.getSchemaName() != null ? FolderNodeData.findSchemaObject(this.m_navigatorTree.getTreeModel(), navigationAction.getSchemaName(), navigationAction.getType(), navigationAction.getName(), false) : FolderNodeData.findComponent(this.m_navigatorTree.getTreeModel(), navigationAction.getType(), navigationAction.getName(), false);
        if (null != treePath) {
            this.m_currentAction = navigationAction;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (null != defaultMutableTreeNode) {
                NodeData nodeData = (NodeData)defaultMutableTreeNode.getUserObject();
                this.addIgnoreNavigationHistory(nodeData.getSchemaName(), nodeData.getName(), nodeData.getNodeType());
                Component component = this.m_splitPane.getRightComponent();
                if (component instanceof ModelViewer) {
                    ModelViewer modelViewer = (ModelViewer)component;
                    int n = modelViewer.getSelectedIndex();
                    navigationAction.setTabIndex(n);
                }
                this.addLoadObjectAction(navigationAction);
                this.m_navigatorTree.scrollPathToVisible(treePath);
                this.m_navigatorTree.setSelectionPath(treePath);
            }
        }
        this.updateViewHistoryMenu();
        this.setCursor(new Cursor(0));
    }

    private void viewForward_ActionPerformed() {
        this.setCursor(new Cursor(3));
        if (null != this.m_currentAction) {
            this.m_backStack.push(this.m_currentAction);
            this.m_currentAction = null;
        }
        if (this.m_forwardStack.isEmpty()) {
            this.updateViewHistoryMenu();
        }
        NavigationAction navigationAction = (NavigationAction)this.m_forwardStack.pop();
        TreePath treePath = null;
        treePath = navigationAction.getSchemaName() != null ? FolderNodeData.findSchemaObject(this.m_navigatorTree.getTreeModel(), navigationAction.getSchemaName(), navigationAction.getType(), navigationAction.getName(), false) : FolderNodeData.findComponent(this.m_navigatorTree.getTreeModel(), navigationAction.getType(), navigationAction.getName(), false);
        if (null != treePath) {
            this.m_currentAction = navigationAction;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (null != defaultMutableTreeNode) {
                NodeData nodeData = (NodeData)defaultMutableTreeNode.getUserObject();
                this.addIgnoreNavigationHistory(nodeData.getSchemaName(), nodeData.getName(), nodeData.getNodeType());
                Component component = this.m_splitPane.getRightComponent();
                if (component instanceof ModelViewer) {
                    ModelViewer modelViewer = (ModelViewer)component;
                    int n = modelViewer.getSelectedIndex();
                    navigationAction.setTabIndex(n);
                }
                this.addLoadObjectAction(navigationAction);
                this.m_navigatorTree.scrollPathToVisible(treePath);
                this.m_navigatorTree.setSelectionPath(treePath);
            }
        }
        this.updateViewHistoryMenu();
        this.setCursor(new Cursor(0));
    }

    public Component getViewerComponent() {
        return this.m_splitPane.getRightComponent();
    }

    private void displaySystemError(Exception exception) {
        DialogUtilities.createSystemErrorDialog(DiagFrame.getMainFrame(), exception);
        exception.printStackTrace();
    }

    public void toolsPreferences_ActionPerformed() {
    }

    private void toolsSync_ActionPerformed() {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Connection connection = null;
                s_syncException = null;
                try {
                    try {
                        connection = DM4JConnectionManager.getDbConnection();
                        DMEMetadata dMEMetadata = DMEMetadata.getInstance();
                        dMEMetadata.synchronize(connection);
                    }
                    catch (Exception exception) {
                        throw new Exception(DM4JResourceUtilities.getUIString("DMS_SYNC_FAILED"));
                    }
                }
                catch (Exception exception) {
                    s_syncException = exception;
                }
                finally {
                    m_progressDlg.setDoneStatus();
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        };
        m_progressDlg = new ProgressBar(s_frameInstance, DM4JResourceUtilities.getUIString("SYNC_PROGRESS_NAME"), runnable, true);
        m_progressDlg.start(DM4JResourceUtilities.getUIString("SYNC_PROGRESS_TITLE"), "");
        m_progressDlg.waitUntilDone();
        if (m_progressDlg.hasUserCancelled()) {
            return;
        }
        if (s_syncException != null) {
            String string = s_syncException.getLocalizedMessage();
            JOptionPane.showOptionDialog(s_frameInstance, string, DM4JVersion.getFullBrowserName(), -1, 0, null, null, null);
            return;
        }
    }

    private void updateViewHistoryMenu() {
        this.m_menuViewBack.setEnabled(!this.m_backStack.isEmpty());
        this.m_menuViewForward.setEnabled(!this.m_forwardStack.isEmpty());
    }

    static {
        s_connectionException = null;
        s_usingConnectionManager = false;
        s_syncException = null;
    }

    public static interface BrowserState {
        public static final int IDLE = 1;
        public static final int THREAD_WAIT = 2;
        public static final int OP_WAIT = 4;
    }
}

