/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.dmt.dm4j.datasources.DBDataSource;

public class XnlAttrListDataSource
extends DBDataSource {
    private static final int COLUMN_COUNT = 1;
    private static final String XNL_ATTR_LIST_COLUMN_NAME = "Attribute List Column";
    public static final int VALUE_COUNT = 0;
    private ArrayList m_attrs = new ArrayList();
    private String m_tableFullName;
    private String m_sequenceIdColumn;
    private String m_attrNameColumn;
    private String m_attrValColumn;

    public XnlAttrListDataSource(Connection connection, String string, String string2, String string3, String string4, String string5) {
        super(connection);
        this.m_tableFullName = string == null ? "\"" + string2 + "\"" : "\"" + string + "\"" + "." + "\"" + string2 + "\"";
        this.m_sequenceIdColumn = string3;
        this.m_attrNameColumn = string4;
        this.m_attrValColumn = string5;
    }

    public ArrayList getAttributeList() {
        return this.m_attrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createData() throws SQLException, Exception {
        String string = "SELECT DISTINCT \"" + this.m_attrNameColumn + "\" FROM " + this.m_tableFullName + "";
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        try {
            callableStatement = this.m_conn.prepareCall(string);
            this.m_statement = callableStatement;
            resultSet = callableStatement.executeQuery();
            while (resultSet.next()) {
                this.m_attrs.add(resultSet.getString(1));
            }
        }
        finally {
            if (callableStatement != null) {
                callableStatement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    protected ArrayOneDModel createColumns() throws Exception {
        this.addColumns(0, 1);
        Object[] objectArray = new String[]{XNL_ATTR_LIST_COLUMN_NAME};
        return new ArrayOneDModel(objectArray);
    }
}

