/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.activity.data.ActivityUtils;
import oracle.dmt.dm4j.activity.data.Column;
import oracle.dmt.dm4j.activity.data.Table;
import oracle.dmt.dm4j.datasources.DM4JDataSource;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;

public class TableColumnsDataSource
extends DM4JDataSource {
    protected String m_dataLocation = null;
    public static final int INCLUDE = 0;
    public static final int NAME = 1;
    public static final int DATA_TYPE = 2;
    private static final int COLUMN_COUNT = 3;
    protected static final String PRIMARY_KEY = "P";
    protected String _attribute_column_name = null;
    protected Hashtable _NameRow = new Hashtable();
    private Table _table = null;
    private Table _caseTable = null;
    private Column _primaryKey = null;
    private boolean _ignoreNestedColumns = true;
    private static final String GET_RELATED_COLUMNS = "select    cols.TABLE_NAME, cols.COLUMN_NAME as CASE_COLUMN, tbl.COLUMN_NAME as RELATED_COLUMN from    ALL_CONSTRAINTS cons, ALL_CONS_COLUMNS cols,   (select      tblcols.CONSTRAINT_NAME, tblcols.COLUMN_NAME    from      ALL_CONS_COLUMNS tblcols, ALL_CONSTRAINTS tblcons    where      tblcons.CONSTRAINT_NAME = tblcols.CONSTRAINT_NAME and      tblcons.TABLE_NAME = ? and      tblcons.OWNER = ?) tbl where    cols.CONSTRAINT_NAME = cons.R_CONSTRAINT_NAME and    cols.TABLE_NAME = ? and    cols.OWNER = ? and    cons.TABLE_NAME = ? and    cons.OWNER = ? and    cons.CONSTRAINT_NAME = tbl.CONSTRAINT_NAME and    cons.CONSTRAINT_TYPE = 'R'";
    private static final String GET_TABLE_COLUMNS = "SELECT c.COLUMN_NAME, c.DATA_TYPE, con.CONSTRAINT_TYPE, c.DATA_LENGTH, c.DATA_PRECISION, c.DATA_SCALE, c.NULLABLE, c.COLUMN_ID FROM all_tab_columns c, (SELECT cn.OWNER, cn.TABLE_NAME, cn.COLUMN_NAME, cd.CONSTRAINT_TYPE  FROM all_cons_columns cn, all_constraints cd WHERE cn.OWNER = cd.OWNER AND cn.TABLE_NAME = cd.TABLE_NAME AND cn.CONSTRAINT_NAME = cd.CONSTRAINT_NAME AND 'P' = cd.CONSTRAINT_TYPE AND 'ENABLED' = cd.STATUS) con WHERE  c.OWNER = ? AND c.TABLE_NAME = ? AND c.OWNER = con.OWNER(+) AND c.TABLE_NAME = con.TABLE_NAME(+) AND c.COLUMN_NAME = con.COLUMN_NAME(+) ORDER BY column_name ASC";

    public TableColumnsDataSource(Connection connection, String string, String string2) throws Exception {
        super(connection, string, string2);
    }

    public TableColumnsDataSource(Connection connection, Table table) {
        super(connection, table.getSchema(), table.getName());
        this._table = table;
    }

    public TableColumnsDataSource(Connection connection, Table table, Table table2) {
        this(connection, table);
        this._caseTable = table2;
    }

    public void setIgnoreNested(boolean bl) {
        this._ignoreNestedColumns = bl;
    }

    public void setAutoclose(boolean bl) {
        this.m_loadFromDMS = bl;
    }

    public String getDataSource() {
        return this.m_schema + "." + this.m_table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createData() throws Exception {
        Connection connection = this.m_conn;
        String string = this.m_schema;
        String string2 = this.m_table;
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        try {
            Object object;
            String string3;
            String string4;
            callableStatement = connection.prepareCall(GET_TABLE_COLUMNS);
            int n = 1;
            callableStatement.setString(n++, string);
            callableStatement.setString(n++, string2);
            resultSet = callableStatement.executeQuery();
            int n2 = 0;
            LinkedHashMap<String, Column> linkedHashMap = new LinkedHashMap<String, Column>();
            while (resultSet.next()) {
                String string5 = resultSet.getString("COLUMN_NAME");
                string4 = resultSet.getString("DATA_TYPE");
                string3 = resultSet.getString("CONSTRAINT_TYPE");
                int n3 = resultSet.getInt("DATA_LENGTH");
                int n4 = resultSet.getInt("DATA_PRECISION");
                int n5 = resultSet.getInt("DATA_SCALE");
                object = resultSet.getString("NULLABLE");
                int n6 = resultSet.getInt("COLUMN_ID");
                Column column = new Column();
                column.setName(string5);
                column.setAlias(string5);
                if (this._ignoreNestedColumns && ActivityUtils.isNestedDataType(string4)) {
                    column.setIsVisible(false);
                } else {
                    column.setIsVisible(true);
                }
                column.setIsInput(column.getIsVisible());
                column.setOriginalDataType(string4);
                column.setDataType(string4);
                column.setMiningType(TableColumnsDataSource.getDefaultMiningType(string4));
                column.setDataLength(n3);
                column.setDataPrecision(n4);
                column.setDataScale(n5);
                column.setColumnID(n6);
                column.setNullable((String)object);
                linkedHashMap.put(column.getName(), column);
                if (string3 != null && string3.equals(PRIMARY_KEY)) {
                    this._primaryKey = column;
                }
                this.addRows(n2, 1);
                super.setData(0, n2, (Object)new Boolean(column.getIsVisible()));
                super.setData(1, n2, (Object)column);
                super.setData(2, n2, (Object)string4);
                this._NameRow.put(string5, new Integer(n2));
                ++n2;
            }
            if (this._table == null) {
                this._table = new Table();
            }
            this._table.setSchema(string);
            this._table.setName(string2);
            this._table.setColumns(linkedHashMap);
            if (this._caseTable != null) {
                callableStatement.close();
                callableStatement = null;
                resultSet.close();
                resultSet = null;
                callableStatement = connection.prepareCall(GET_RELATED_COLUMNS);
                n = 1;
                callableStatement.setString(n++, string2);
                callableStatement.setString(n++, string);
                callableStatement.setString(n++, this._caseTable.getName());
                callableStatement.setString(n++, this._caseTable.getSchema());
                callableStatement.setString(n++, string2);
                callableStatement.setString(n++, string);
                resultSet = callableStatement.executeQuery();
                boolean bl = true;
                while (resultSet.next()) {
                    bl = false;
                    string4 = resultSet.getString("TABLE_NAME");
                    string3 = resultSet.getString("CASE_COLUMN");
                    String string6 = resultSet.getString("RELATED_COLUMN");
                    if (!string4.equals(this._caseTable.getName())) continue;
                    ArrayList arrayList = this._table.getCaseTableJoinColumns();
                    ArrayList arrayList2 = this._table.getJoinColumns();
                    object = this._caseTable.getColumnByName(string3);
                    Column column = this._table.getColumnByName(string6);
                    arrayList.add(new Column((Column)object));
                    arrayList2.add(new Column(column));
                }
                if (bl) {
                    callableStatement.close();
                    callableStatement = null;
                    resultSet.close();
                    resultSet = null;
                    callableStatement = connection.prepareCall(GET_RELATED_COLUMNS);
                    n = 1;
                    callableStatement.setString(n++, this._caseTable.getName());
                    callableStatement.setString(n++, this._caseTable.getSchema());
                    callableStatement.setString(n++, string2);
                    callableStatement.setString(n++, string);
                    callableStatement.setString(n++, this._caseTable.getName());
                    callableStatement.setString(n++, this._caseTable.getSchema());
                    resultSet = callableStatement.executeQuery();
                    while (resultSet.next()) {
                        string4 = resultSet.getString("TABLE_NAME");
                        string3 = resultSet.getString("CASE_COLUMN");
                        String string7 = resultSet.getString("RELATED_COLUMN");
                        if (!this._table.getName().equals(string4)) continue;
                        ArrayList arrayList = this._table.getCaseTableJoinColumns();
                        ArrayList arrayList3 = this._table.getJoinColumns();
                        object = this._caseTable.getColumnByName(string7);
                        Column column = this._table.getColumnByName(string3);
                        arrayList.add(new Column((Column)object));
                        arrayList3.add(new Column(column));
                    }
                }
            }
        }
        finally {
            if (callableStatement != null) {
                callableStatement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    public static String getDefaultMiningType(String string) {
        String string2 = null;
        string2 = string.equals("NUMBER") || string.equals("FLOAT") || string.equals("DATE") ? "numerical" : (string.equals("VARCHAR2") || string.equals("CHAR") ? "categorical" : (string.equals("DM_NESTED_NUMERICALS") ? "nested numerical" : (string.equals("DM_NESTED_CATEGORICALS") ? "nested categorical" : (string.equals("NVARCHAR2") || string.equals("NCHAR") ? "notApplicable" : (string.equals("BFILE") || string.equals("BLOB") || string.equals("CLOB") || string.equals("LONG") || string.equals("XMLTYPE") || string.equals("RAW") || string.equals("LONG RAW") ? "text" : "notApplicable")))));
        return string2;
    }

    public void setColumnVisible(int n, boolean bl) {
        Column column = (Column)this.getData(1, n);
        column.setIsVisible(bl);
        column.setIsInput(bl);
    }

    public Table getTable() {
        return this._table;
    }

    public Column getPrimaryKey() {
        return this._primaryKey;
    }

    public LinkedHashMap getAllAttributes() {
        return this._table.getColumns();
    }

    public Column getColumn(String string) {
        Column column = (Column)this._table.getColumns().get(string);
        return column;
    }

    public Column getColumnAt(int n) {
        return (Column)this.getData(1, n);
    }

    protected ArrayOneDModel createColumns() throws Exception {
        this.addColumns(0, 3);
        Object[] objectArray = new String[]{DM4JResourceUtilities.getUIString("COMMON_SELECT"), ResourceUtilities.getUILabel("DATA_USAGE_ATTRIBUTE_NAME"), ResourceUtilities.getUILabel("DATA_USAGE_DATA_TYPE")};
        return new ArrayOneDModel(objectArray);
    }

    public ArrayList getAttributes(boolean bl) {
        ArrayList<Object> arrayList;
        Boolean bl2 = Boolean.FALSE;
        if (bl) {
            arrayList = new ArrayList<Object>(this.getRowCount());
            for (int i = 0; i < this.getRowCount(); ++i) {
                bl2 = (Boolean)this.getData(0, i);
                if (!bl2.booleanValue()) continue;
                arrayList.add(this.getData(1, i));
            }
        } else {
            arrayList = new ArrayList(this.getRowCount());
            for (int i = 0; i < this.getRowCount(); ++i) {
                arrayList.add(this.getData(1, i));
            }
        }
        return arrayList;
    }

    public int getAttributeIndex(String string) {
        Integer n = (Integer)this._NameRow.get(string);
        return n == null ? -1 : n;
    }

    public String getAttributeDataType(String string) {
        String string2 = null;
        int n = this.getAttributeIndex(string);
        if (n >= 0) {
            string2 = (String)this.getData(2, n);
        }
        return string2;
    }

    public void sort(int n, boolean bl) {
        super.sort(n, bl);
        this._NameRow.clear();
        for (int i = 0; i < this.getRowCount(); ++i) {
            String string = ((Column)this.getData(1, i)).getName();
            this._NameRow.put(string, new Integer(i));
        }
    }
}

