/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.browser.UserPreferences;
import oracle.dmt.dm4j.datasources.DiscretizeDataSource;
import oracle.dmt.dm4j.wizard.director.transforms.TransformsDirector;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.odm.binning.BinningType;
import oracle.dmt.odm.binning.CategoricBin;

public class SummarizeDataSource
extends DiscretizeDataSource {
    protected AdditionalGrid m_extraGrid = new AdditionalGrid();
    protected final int ATTRIBUTE_SCAN_SIZE = 1000;
    private static final String SQL_COUNT_NON_NULL = "select count({0}) as N from ({1}) WHERE {0} IS NOT NULL";
    protected boolean m_bApplyEuristics = true;
    private int m_count;

    public void ignoreEuristics() {
        this.m_bApplyEuristics = false;
    }

    public void applyEuristics() {
        this.m_bApplyEuristics = true;
    }

    protected static void setNullCountHeader() {
        SummarizeDataSource.items[DiscretizeDataSource.COLUMN_NAMES.EXTRA_DATA_1] = ResourceUtilities.getUILabel("DISCRETIZATION_SETTINGS_NULL_COUNT");
    }

    protected SummarizeDataSource(Connection connection) throws Exception {
        super(connection);
        SummarizeDataSource.setNullCountHeader();
        this.m_preferences = UserPreferences.getInstance();
        this.setLabels(this.m_preferences.getBooleanValue("DISCRETIZATION_STRING"));
    }

    public SummarizeDataSource(Connection connection, String string, String string2, String string3) throws Exception {
        super(connection, null, string, string2, string3, null);
        SummarizeDataSource.setNullCountHeader();
        this.m_isTransactional = false;
    }

    public SummarizeDataSource(Connection connection, String string, String string2, String string3, String string4, String string5, String string6) throws Exception {
        super(connection, null, string, string2, string3, null, string4, string5, string6);
        this.m_isTransactional = true;
    }

    public String[] getAllAttributeNames() {
        int n = this.getRowCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)this.getData(DiscretizeDataSource.COLUMN_NAMES.NAME, i);
        }
        return stringArray;
    }

    protected void createData() throws Exception {
        if (this.m_isTransactional) {
            this.createDataFromTXSource();
        } else {
            this.createDataFrom2DSource();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createDataFromTXSource() throws Exception {
        Object object;
        Hashtable hashtable = this.getMiningTypeTX();
        String string = null;
        String string2 = "SELECT \"" + this.m_valueMapping + "\" " + " FROM " + this.getSampledDataLocation();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.m_conn.createStatement();
            resultSet = statement.executeQuery(string2);
            object = resultSet.getMetaData();
            string = object.getColumnTypeName(1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            resultSet.close();
            statement.close();
        }
        object = "SELECT DISTINCT \"" + this.m_attributeMapping + "\" " + " FROM " + this.getSampledDataLocation();
        Statement statement2 = null;
        ResultSet resultSet2 = null;
        try {
            int n = 0;
            statement2 = this.m_conn.createStatement();
            resultSet2 = statement2.executeQuery((String)object);
            Vector<String> vector = new Vector<String>();
            Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>();
            Vector<String> vector2 = new Vector<String>();
            Hashtable<String, Integer> hashtable3 = new Hashtable<String, Integer>();
            while (resultSet2.next()) {
                String string3 = resultSet2.getString(1);
                this.m_tableColumns.add(string3);
                if (0 != string.compareTo("NUMBER") && 0 != string.compareTo("CHAR") && 0 != string.compareTo("VARCHAR2") && 0 != string.compareTo("FLOAT")) continue;
                this.addRows(++n - 1, 1);
                this.setAttributeName(n - 1, string3);
                DiscretizeDataSource.DataInfo dataInfo = (DiscretizeDataSource.DataInfo)hashtable.get(string3);
                this.setData(DiscretizeDataSource.COLUMN_NAMES.MTYPE, n - 1, dataInfo == null ? null : dataInfo.m_AttrType);
                this.setData(DiscretizeDataSource.COLUMN_NAMES.DTYPE, n - 1, dataInfo == null ? null : dataInfo.m_DataType);
                this.setData(DiscretizeDataSource.COLUMN_NAMES.BINNUMBER, n - 1, new Integer(DEFAULT_BIN_NUMBER));
                this.setBinType(n - 1, BinningType.NONE.getName(), 0);
                if (dataInfo != null && 0 == dataInfo.m_AttrType.compareTo("NUMBER")) {
                    this.setData(DiscretizeDataSource.COLUMN_NAMES.TAILPERCENT, n - 1, new Double(0.0));
                } else {
                    this.setData(DiscretizeDataSource.COLUMN_NAMES.TAILPERCENT, n - 1, null);
                }
                this.setData(DiscretizeDataSource.COLUMN_NAMES.VIEW_DEFN, n - 1, null);
                this.setData(DiscretizeDataSource.COLUMN_NAMES.SKEW, n - 1, null);
                this.setData(DiscretizeDataSource.COLUMN_NAMES.KURT, n - 1, null);
                if (0 == string.compareTo("NUMBER")) {
                    vector.add(string3);
                    hashtable2.put(string3, new Integer(n - 1));
                    continue;
                }
                if (0 != string.compareTo("CHAR") && 0 != string.compareTo("VARCHAR2") && 0 != string.compareTo("NCHAR") && 0 != string.compareTo("NVARCHAR2")) continue;
                vector2.add(string3);
                hashtable3.put(string3, new Integer(n - 1));
            }
            if (!hashtable2.isEmpty()) {
                this.addNumericStatsTX(this.m_conn, hashtable2, null);
            }
            this.addCategoricStatsTX(this.m_conn, vector2, hashtable3, null);
            hashtable2.clear();
            hashtable3.clear();
            vector.clear();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                resultSet2.close();
                statement2.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createDataFrom2DSource() throws Exception {
        Hashtable hashtable = this.getMiningType2D();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = this.getSamplingViewDefinition();
        String string2 = "SELECT COLUMN_NAME, DATA_TYPE FROM all_tab_columns WHERE owner = '" + this.getSrcSchemaName() + "' and table_name = '" + TransformsDirector.getReplacedString(this.getSrcTableName(), "'", "''") + "'" + " order by COLUMN_NAME";
        try {
            preparedStatement = this.m_conn.prepareStatement(string2);
            resultSet = preparedStatement.executeQuery();
            Vector<String> vector = new Vector<String>();
            Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>();
            Vector<String> vector2 = new Vector<String>();
            Hashtable<String, Integer> hashtable3 = new Hashtable<String, Integer>();
            int n = 0;
            while (resultSet.next()) {
                String string3 = resultSet.getString("DATA_TYPE");
                String string4 = resultSet.getString("COLUMN_NAME");
                this.m_tableColumns.add(string4);
                if (0 != string3.compareTo("NUMBER") && 0 != string3.compareTo("CHAR") && 0 != string3.compareTo("VARCHAR2") && 0 != string3.compareTo("FLOAT") && 0 != string3.compareTo("NVARCHAR2") && 0 != string3.compareTo("NCHAR")) continue;
                this.addRows(++n - 1, 1);
                this.setAttributeName(n - 1, string4);
                DiscretizeDataSource.DataInfo dataInfo = (DiscretizeDataSource.DataInfo)hashtable.get(string4);
                this.setData(DiscretizeDataSource.COLUMN_NAMES.MTYPE, n - 1, dataInfo == null ? null : dataInfo.m_AttrType);
                this.setData(DiscretizeDataSource.COLUMN_NAMES.DTYPE, n - 1, dataInfo == null ? null : dataInfo.m_DataType);
                this.setData(DiscretizeDataSource.COLUMN_NAMES.BINNUMBER, n - 1, new Integer(DEFAULT_BIN_NUMBER));
                this.setBinType(n - 1, BinningType.NONE.getName(), 0);
                if (dataInfo != null && 0 == dataInfo.m_AttrType.compareTo("NUMBER")) {
                    this.setData(DiscretizeDataSource.COLUMN_NAMES.TAILPERCENT, n - 1, new Double(0.0));
                } else {
                    this.setData(DiscretizeDataSource.COLUMN_NAMES.TAILPERCENT, n - 1, null);
                }
                this.setData(DiscretizeDataSource.COLUMN_NAMES.VIEW_DEFN, n - 1, null);
                this.setData(DiscretizeDataSource.COLUMN_NAMES.SKEW, n - 1, null);
                this.setData(DiscretizeDataSource.COLUMN_NAMES.KURT, n - 1, null);
                if (0 == string3.compareTo("NUMBER") || 0 == string3.compareTo("FLOAT")) {
                    vector.add(string4);
                    hashtable2.put(string4, new Integer(n - 1));
                    continue;
                }
                if (0 != string3.compareTo("CHAR") && 0 != string3.compareTo("VARCHAR2") && 0 != string3.compareTo("NCHAR") && 0 != string3.compareTo("NVARCHAR2")) continue;
                vector2.add(string4);
                hashtable3.put(string4, new Integer(n - 1));
            }
            int n2 = this.getSampledTableRowCount(this.m_conn);
            this.addNumericStats(this.m_conn, n2, vector, hashtable2, string);
            this.addCategoricStats(this.m_conn, n2, vector2, hashtable3, string);
            hashtable2.clear();
            hashtable3.clear();
            vector.clear();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                resultSet.close();
                preparedStatement.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCategoricStats(Connection connection, int n, Vector vector, Hashtable hashtable, String string) {
        if (vector == null || vector.isEmpty()) {
            return;
        }
        int n2 = vector.size() / 1000 + 1;
        String string2 = "count ({0}) as N{1}, count (distinct{0}) as D{1} ";
        for (int i = 0; i < n2; ++i) {
            Object object;
            Object object2;
            int n3 = Math.min(vector.size(), 1000 * (i + 1));
            int n4 = 1000 * i;
            StringBuffer stringBuffer = new StringBuffer("SELECT ");
            for (int j = n4; j < n3; ++j) {
                object2 = "\"" + (String)vector.elementAt(j) + "\"";
                object = MessageFormat.format(string2, object2, String.valueOf(j));
                stringBuffer.append((String)object);
                if (j >= n3 - 1) continue;
                stringBuffer.append(",");
            }
            String string3 = MessageFormat.format(" from ({0})", string == null ? this.getSampledDataLocation() : string);
            stringBuffer.append(string3);
            object2 = null;
            object = null;
            try {
                object2 = connection.createStatement();
                object = object2.executeQuery(stringBuffer.toString());
                if (!object.next()) continue;
                for (int j = n4; j < n3; ++j) {
                    String string4 = String.valueOf(j);
                    String string5 = (String)vector.elementAt(j);
                    Integer n5 = (Integer)hashtable.get(string5);
                    if (n5 == null) continue;
                    int n6 = object.getInt("N" + string4);
                    this.setData(DiscretizeDataSource.COLUMN_NAMES.TOTAL, n5, new Integer(n6));
                    this.m_extraGrid.setNullCount(n5, new Integer(n - n6));
                    this.setData(DiscretizeDataSource.COLUMN_NAMES.EXTRA_DATA_1, n5, new Integer(n - n6));
                    int n7 = object.getInt("D" + string4);
                    this.m_extraGrid.setDistinctCount(n5, new Integer(n7));
                }
                continue;
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                continue;
            }
            finally {
                try {
                    object.close();
                    object2.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCategoricStatsTX(Connection connection, Vector vector, Hashtable hashtable, String string) {
        if (vector == null || vector.isEmpty()) {
            return;
        }
        String string2 = "SELECT {0} ANAME, count({1}) as N, count(distinct {1}) as D, stats_mode({1}) as S from {2} group by {0}";
        String string3 = MessageFormat.format(string2, "\"" + this.m_attributeMapping + "\"", "\"" + this.m_valueMapping + "\"", string == null ? this.getSampledDataLocation() : string);
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                String string4 = resultSet.getString("ANAME");
                Integer n = (Integer)hashtable.get(string4);
                if (n == null) continue;
                int n2 = resultSet.getInt("N");
                this.setData(DiscretizeDataSource.COLUMN_NAMES.TOTAL, n, new Integer(n2));
                this.m_count = n2;
            }
        }
        catch (Exception exception) {
            if (SummarizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNumericStats(Connection connection, int n, Vector vector, Hashtable hashtable, String string) {
        if (vector == null || vector.isEmpty()) {
            return;
        }
        int n2 = vector.size() / 1000 + 1;
        String string2 = "count({0}) as N{1}, count(distinct{0}) as COUNT{1}, avg({0}) as Average{1}, MAX({0}) Max{1} , MIN({0}) Min{1}, VARIANCE({0}) as Variance{1}, sum((abs({0})) - (floor({0}))) as FLOAT_IND{1}";
        for (int i = 0; i < n2; ++i) {
            Object object;
            Object object2;
            int n3 = Math.min(vector.size(), 1000 * (i + 1));
            int n4 = 1000 * i;
            StringBuffer stringBuffer = new StringBuffer("SELECT ");
            for (int j = n4; j < n3; ++j) {
                object2 = "\"" + (String)vector.elementAt(j) + "\"";
                object = MessageFormat.format(string2, object2, String.valueOf(j));
                stringBuffer.append((String)object);
                if (j >= n3 - 1) continue;
                stringBuffer.append(",");
            }
            String string3 = MessageFormat.format(" from ({0}) ", string == null ? this.getSampledDataLocation() : string);
            stringBuffer.append(string3);
            object2 = null;
            object = null;
            String string4 = null;
            String string5 = null;
            try {
                object2 = connection.createStatement();
                object = object2.executeQuery(stringBuffer.toString());
                if (!object.next()) continue;
                for (int j = n4; j < n3; ++j) {
                    String string6 = String.valueOf(j);
                    String string7 = (String)vector.elementAt(j);
                    Integer n5 = (Integer)hashtable.get(string7);
                    if (n5 == null) continue;
                    int n6 = object.getInt("N" + string6);
                    this.setData(DiscretizeDataSource.COLUMN_NAMES.TOTAL, n5, new Integer(n6));
                    this.m_extraGrid.setNullCount(n5, new Integer(n - n6));
                    this.setData(DiscretizeDataSource.COLUMN_NAMES.EXTRA_DATA_1, n5, new Integer(n - n6));
                    int n7 = object.getInt("COUNT" + string6);
                    this.m_extraGrid.setDistinctCount(n5, new Integer(n7));
                    double d = object.getDouble("Average" + string6);
                    this.setData(DiscretizeDataSource.COLUMN_NAMES.AVG, n5, new Double(d));
                    d = object.getDouble("Max" + string6);
                    this.setData(DiscretizeDataSource.COLUMN_NAMES.MAX, n5, new Double(d));
                    d = object.getDouble("Min" + string6);
                    this.setData(DiscretizeDataSource.COLUMN_NAMES.MIN, n5, new Double(d));
                    d = object.getDouble("Variance" + string6);
                    this.setData(DiscretizeDataSource.COLUMN_NAMES.VAR, n5, new Double(d));
                    d = Math.sqrt(d);
                    this.setData(DiscretizeDataSource.COLUMN_NAMES.STDDEV, n5, new Double(d));
                    if (!this.m_bApplyEuristics) continue;
                    double d2 = object.getDouble("FLOAT_IND" + string6);
                    if (d2 != 0.0) {
                        string4 = "FLOAT";
                        string5 = "numerical";
                    } else {
                        string4 = "NUMBER";
                        string5 = n7 <= this.m_preferences.getCutoffForNumberForCategorical() ? "categorical" : "numerical";
                    }
                    this.setData(DiscretizeDataSource.COLUMN_NAMES.MTYPE, n5, string5);
                    this.setData(DiscretizeDataSource.COLUMN_NAMES.DTYPE, n5, string4);
                }
                continue;
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                continue;
            }
            finally {
                try {
                    object.close();
                    object2.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNumericStatsTX(Connection connection, Hashtable hashtable, String string) {
        String string2 = "SELECT {0} ANAME, count({1}) as N, count(distinct{1}) as COUNT, sum((abs({1})) - (floor({1}))) as FLOAT_IND, MIN({1}) MINV, MAX({1}) MAXV, AVG({1}) AVGV, VARIANCE({1}) as Variance from {2} group by {0}";
        String string3 = MessageFormat.format(string2, "\"" + this.m_attributeMapping + "\"", "\"" + this.m_valueMapping + "\"", string == null ? this.getSampledDataLocation() : string);
        Statement statement = null;
        ResultSet resultSet = null;
        String string4 = null;
        String string5 = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                String string6 = resultSet.getString("ANAME");
                Integer n = (Integer)hashtable.get(string6);
                if (n == null) continue;
                int n2 = resultSet.getInt("N");
                this.setData(DiscretizeDataSource.COLUMN_NAMES.TOTAL, n, new Integer(n2));
                this.m_count = n2;
                int n3 = resultSet.getInt("COUNT");
                this.m_extraGrid.setDistinctCount(n, new Integer(n3));
                double d = resultSet.getDouble("MAXV");
                this.setData(DiscretizeDataSource.COLUMN_NAMES.MAX, n, new Double(d));
                d = resultSet.getDouble("MINV");
                this.setData(DiscretizeDataSource.COLUMN_NAMES.MIN, n, new Double(d));
                d = resultSet.getDouble("AVGV");
                this.setData(DiscretizeDataSource.COLUMN_NAMES.AVG, n, new Double(d));
                d = resultSet.getDouble("Variance");
                this.setData(DiscretizeDataSource.COLUMN_NAMES.VAR, n, new Double(d));
                d = Math.sqrt(d);
                this.setData(DiscretizeDataSource.COLUMN_NAMES.STDDEV, n, new Double(d));
                double d2 = resultSet.getDouble("FLOAT_IND");
                if (d2 != 0.0) {
                    string4 = "FLOAT";
                    string5 = "numerical";
                } else {
                    string4 = "NUMBER";
                    string5 = n3 <= this.m_preferences.getCutoffForNumberForCategorical() ? "categorical" : "numerical";
                }
                this.setData(DiscretizeDataSource.COLUMN_NAMES.MTYPE, n, string5);
                this.setData(DiscretizeDataSource.COLUMN_NAMES.DTYPE, n, string4);
            }
        }
        catch (Exception exception) {
            if (SummarizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAttributeCount(Connection connection, String string, String string2) {
        Statement statement = null;
        ResultSet resultSet = null;
        Object[] objectArray = new Object[]{string, string2};
        String string3 = MessageFormat.format(SQL_COUNT_NON_NULL, objectArray);
        int n = -1;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            if (resultSet.next()) {
                n = resultSet.getInt("N");
            }
        }
        catch (Exception exception) {
            n = -1;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return n;
    }

    public void setBinType(int n, String string, int n2) {
        if (0 == string.compareTo(BinningType.NONE.getName())) {
            this.setData(DiscretizeDataSource.COLUMN_NAMES.BINTYPE, n, string);
        } else {
            this.setData(DiscretizeDataSource.COLUMN_NAMES.BINTYPE, n, string + ":" + String.valueOf(n2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getDistinctCount(int n) {
        Integer n2 = this.m_extraGrid.getDistinctCount(n);
        if (n2 != null) {
            return n2;
        }
        String string = this.getAttributeName(n);
        Connection connection = null;
        int n3 = 0;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            n3 = this.m_isTransactional && !this.m_bSingleMetric ? this.getTXDistinctCount(connection, string) : this.get2DDistinctCount(connection, string);
            this.m_extraGrid.setDistinctCount(n, new Integer(n3));
        }
        catch (Exception exception) {
            if (SummarizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return new Integer(n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int get2DDistinctCount(Connection connection, String string) {
        String string2 = "select count ( distinct {0} ) from {1}";
        String string3 = MessageFormat.format(string2, "\"" + string + "\"", this.getSampledDataLocation());
        Statement statement = null;
        ResultSet resultSet = null;
        int n = 0;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
        }
        catch (Exception exception) {
            if (SummarizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getTXDistinctCount(Connection connection, String string) {
        String string2 = "select count ( distinct {0} ) from {1} where {2}={3}";
        String string3 = MessageFormat.format(string2, "\"" + this.m_valueMapping + "\"", this.getSampledDataLocation(), "\"" + this.m_attributeMapping + "\"", "'" + string + "'");
        Statement statement = null;
        ResultSet resultSet = null;
        int n = 0;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
        }
        catch (Exception exception) {
            if (SummarizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getTopNStats(int n, int n2) {
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            this.getTopNStats(connection, n, n2);
        }
        catch (Exception exception) {
            if (SummarizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getTopNStats(Connection connection, int n, int n2) {
        if (this.m_isTransactional && !this.m_bSingleMetric) {
            this.getTopNStatsTX(connection, n, n2);
            return;
        }
        String string = String.valueOf(n2);
        String string2 = this.getAttributeName(n);
        Statement statement = null;
        ResultSet resultSet = null;
        Vector<CategoricBin> vector = new Vector<CategoricBin>();
        try {
            String string3 = MessageFormat.format("SELECT * FROM (SELECT {0} FROM {1} GROUP BY {0} HAVING {0} IS NOT NULL ORDER BY COUNT(*) DESC, {0} DESC) WHERE rownum <= {2}", "\"" + string2 + "\"", this.getSampledDataLocation(), string);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                Vector<String> vector2 = new Vector<String>();
                String string4 = resultSet.getString(1);
                vector2.add(string4);
                CategoricBin categoricBin = new CategoricBin(string4, vector2);
                vector.add(categoricBin);
            }
            this.setBinBounds(n, vector);
        }
        catch (Exception exception) {
            if (SummarizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getTopNStatsTX(Connection connection, int n, int n2) {
        String string = String.valueOf(n2);
        String string2 = this.getAttributeName(n);
        Statement statement = null;
        ResultSet resultSet = null;
        Vector<CategoricBin> vector = new Vector<CategoricBin>();
        try {
            String string3 = MessageFormat.format("SELECT * FROM (SELECT {0} FROM {1}  WHERE {3}={4} GROUP BY {0} HAVING {0} IS NOT NULL ORDER BY COUNT(*) DESC, {0} DESC) WHERE rownum <= {2}", "\"" + this.m_valueMapping + "\"", this.getSampledDataLocation(), string, "\"" + this.m_attributeMapping + "\"", "'" + string2 + "'");
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                Vector<String> vector2 = new Vector<String>();
                String string4 = resultSet.getString(1);
                vector2.add(string4);
                CategoricBin categoricBin = new CategoricBin(string4, vector2, vector2);
                vector.add(categoricBin);
            }
            this.setBinBounds(n, vector);
        }
        catch (Exception exception) {
            if (SummarizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMode(int n) {
        String string = null;
        String string2 = this.getAttributeName(n);
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            string = this.m_isTransactional && !this.m_bSingleMetric ? this.getStatsModeTX(connection, string2) : this.getStatsMode2D(connection, string2);
            if (string != null) {
                this.m_extraGrid.setMode(n, string);
            }
        }
        catch (Exception exception) {
            if (SummarizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getStatsMode2D(Connection connection, String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("SELECT  ");
        String string2 = MessageFormat.format("stats_mode({0}) ", "\"" + string + "\"");
        stringBuffer.append(string2);
        String string3 = MessageFormat.format(" from ({0} t)", this.getSampledDataLocation());
        stringBuffer.append(string3);
        Statement statement = null;
        ResultSet resultSet = null;
        String string4 = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet.next()) {
                string4 = resultSet.getString(1);
            }
        }
        catch (Exception exception) {
            if (SummarizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStatsModeTX(Connection connection, String string) {
        if (string == null) {
            return null;
        }
        String string2 = "SELECT stats_mode({0}) from {2} where {1} = {3}";
        String string3 = MessageFormat.format(string2, "\"" + this.m_valueMapping + "\"", "\"" + this.m_attributeMapping + "\"", this.getSampledDataLocation(), "'" + string + "'");
        Statement statement = null;
        ResultSet resultSet = null;
        String string4 = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            if (resultSet.next()) {
                string4 = resultSet.getString(1);
            }
        }
        catch (Exception exception) {
            if (SummarizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return string4;
    }

    public int getAttributeTotalCount(String string) throws Exception {
        int n = this.getAttributeRow(string);
        if (n == -1) {
            throw new Exception();
        }
        Integer n2 = (Integer)this.getData(DiscretizeDataSource.COLUMN_NAMES.TOTAL, n);
        return n2 == null ? -1 : n2;
    }

    public int getAttributeDistinctCount(String string) throws Exception {
        int n = this.getAttributeRow(string);
        if (n == -1) {
            throw new Exception();
        }
        Integer n2 = this.m_extraGrid.getDistinctCount(n);
        return n2 == null ? -1 : n2;
    }

    public int getAttributeNullCount(String string) throws Exception {
        int n = this.getAttributeRow(string);
        if (n == -1) {
            throw new Exception();
        }
        Integer n2 = this.m_extraGrid.getNullCount(n);
        if (n2 != null) {
            return n2;
        }
        String string2 = "select count(*) from {1} where {0} is null";
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        int n3 = 0;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            String string3 = MessageFormat.format(string2, "\"" + string + "\"", this.getSampledDataLocation());
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            if (resultSet.next()) {
                n3 = resultSet.getInt(1);
                this.m_extraGrid.setNullCount(n, new Integer(n3));
                this.setData(DiscretizeDataSource.COLUMN_NAMES.EXTRA_DATA_1, n, new Integer(n3));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
                connection.close();
            }
            catch (Exception exception) {}
        }
        return n3;
    }

    public int getSampledTableRowCount() {
        return this.m_count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSampledTableRowCount(Connection connection) {
        if (this.m_count != 0) {
            return this.m_count;
        }
        StringBuffer stringBuffer = new StringBuffer("SELECT COUNT (*) ");
        String string = MessageFormat.format(" from ({0} t)", this.getSampledDataLocation());
        stringBuffer.append(string);
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet.next()) {
                this.m_count = resultSet.getInt(1);
            }
        }
        catch (Exception exception) {
            if (SummarizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.m_count;
    }

    public boolean isFloat(String string) throws Exception {
        int n = this.getAttributeRow(string);
        if (n == -1) {
            throw new Exception();
        }
        String string2 = (String)this.getData(DiscretizeDataSource.COLUMN_NAMES.DTYPE, n);
        return 0 == string2.compareTo("FLOAT");
    }

    public void sort(int n, boolean bl) {
        super.sort(n, bl);
        this.clearMap();
        for (int i = 0; i < this.getRowCount(); ++i) {
            String string = this.getAttributeName(i);
            this.m_NameRow.put(string, new Integer(i));
        }
    }

    protected class AdditionalGrid {
        private String DISTINCT_COUNT = "DISTINCT_COUNT";
        private String STATS_MODE = "STATS_MODE";
        private String NULL_COUNT = "NULL_COUNT";
        private Hashtable m_table = null;

        AdditionalGrid() {
        }

        private Object getInternalValue(String string, int n) {
            if (this.m_table == null) {
                this.m_table = new Hashtable(SummarizeDataSource.this.getRowCount());
            }
            if (this.m_table == null) {
                return null;
            }
            Hashtable hashtable = (Hashtable)this.m_table.get(new Integer(n));
            if (hashtable == null) {
                return null;
            }
            return hashtable.get(string);
        }

        private void setInternalValue(String string, int n, Object object) {
            Hashtable<String, Object> hashtable;
            if (this.m_table == null) {
                this.m_table = new Hashtable(SummarizeDataSource.this.getRowCount());
            }
            if ((hashtable = (Hashtable<String, Object>)this.m_table.get(new Integer(n))) == null) {
                hashtable = new Hashtable<String, Object>();
                this.m_table.put(new Integer(n), hashtable);
            }
            hashtable.put(string, object);
        }

        Integer getDistinctCount(int n) {
            return (Integer)this.getInternalValue(this.DISTINCT_COUNT, n);
        }

        void setDistinctCount(int n, Object object) {
            this.setInternalValue(this.DISTINCT_COUNT, n, object);
        }

        String getMode(int n) {
            return (String)this.getInternalValue(this.STATS_MODE, n);
        }

        void setMode(int n, String string) {
            this.setInternalValue(this.STATS_MODE, n, string);
        }

        Integer getNullCount(int n) {
            return (Integer)this.getInternalValue(this.NULL_COUNT, n);
        }

        void setNullCount(int n, Object object) {
            this.setInternalValue(this.NULL_COUNT, n, object);
        }
    }
}

