/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.datasources.DiscretizationLDSDataSource;
import oracle.dmt.dm4j.datasources.DiscretizeDataSource;
import oracle.dmt.dm4j.datasources.OutlierPredefinedNumericTreatment;
import oracle.dmt.dm4j.datasources.TXColumn;
import oracle.dmt.dm4j.wizard.director.transforms.TransformsDirector;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;

public class OutlierDiscretizeDataSource
extends DiscretizeDataSource {
    protected boolean m_bAutoRun;
    private static String TAB = "    ";
    protected static final String[] STAT_SQL_OUTLIER_PERCENT_2D = new String[]{"SELECT AVG(val) Average, MAX(val) Max, MIN(val) Min, VARIANCE(val) Variance FROM (SELECT val, ROW_NUMBER() OVER (ORDER BY val ASC) pos, COUNT(*) OVER () cnt ", "FROM (SELECT {0} val  FROM {1} ) WHERE val IS NOT NULL) WHERE pos >= TRUNC({2}*cnt/100) + 1 AND pos <= cnt - TRUNC({3}*cnt/100)"};
    private static final String[] STAT_SQL_OUTLIER_PERCENT_TX = new String[]{"SELECT AVG(val) Average, MAX(val) Max, MIN(val) Min, VARIANCE(val) Variance FROM  ( SELECT val, ROW_NUMBER() OVER (ORDER BY val ASC) pos, COUNT(*) OVER () cnt ", "FROM (SELECT {0} val  FROM ({1}) WHERE {4} = {5} ) WHERE val IS NOT NULL) ", "WHERE pos >= TRUNC({2}*cnt/100) + 1 AND pos <= cnt - TRUNC({3}*cnt/100)"};

    public static String getOpenBracket(boolean bl) {
        return bl ? "(" : "[";
    }

    public static String getCloseBracket(boolean bl) {
        return bl ? ")" : "]";
    }

    protected OutlierDiscretizeDataSource(Connection connection) throws Exception {
        super(connection);
    }

    public OutlierDiscretizeDataSource(Connection connection, DiscretizationLDSDataSource discretizationLDSDataSource, String string, String string2, String string3, String string4) throws Exception {
        super(connection, discretizationLDSDataSource, string, string2, string3, string4);
    }

    public OutlierDiscretizeDataSource(Connection connection, DiscretizationLDSDataSource discretizationLDSDataSource, String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl) throws Exception {
        super(connection, discretizationLDSDataSource, string, string2, string3, string4, string5, string6, string7, bl);
    }

    protected void doDefaultTreatment() {
        if (this.m_bAutoRun) {
            return;
        }
        OutlierPredefinedNumericTreatment outlierPredefinedNumericTreatment = new OutlierPredefinedNumericTreatment(this);
        outlierPredefinedNumericTreatment.processAttributes(this.m_context.getActivity().getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNumericStats2D(Connection connection, Vector vector, Hashtable hashtable, String string) {
        if (vector == null || vector.isEmpty()) {
            return;
        }
        int n = vector.size() / 1000 + 1;
        String string2 = "avg({0}) as Average{1}, MAX({0}) Max{1} , MIN({0}) Min{1}, VARIANCE({0}) as Variance{1}";
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            int n2 = Math.min(vector.size(), 1000 * (i + 1));
            int n3 = 1000 * i;
            StringBuffer stringBuffer = new StringBuffer("SELECT /*+ parallel (t) */");
            for (int j = n3; j < n2; ++j) {
                object2 = (String)vector.elementAt(j);
                object = MessageFormat.format(string2, "\"" + (String)object2 + "\"", String.valueOf(j));
                stringBuffer.append((String)object);
                if (j >= n2 - 1) continue;
                stringBuffer.append(",");
            }
            String string3 = MessageFormat.format(" from ({0} t)", string == null ? this.getSampledDataLocation() : string);
            stringBuffer.append(string3);
            object2 = null;
            object = null;
            try {
                object2 = connection.createStatement();
                object = object2.executeQuery(stringBuffer.toString());
                if (!object.next()) continue;
                for (int j = n3; j < n2; ++j) {
                    String string4 = String.valueOf(j);
                    String string5 = (String)vector.elementAt(j);
                    Integer n4 = (Integer)hashtable.get(string5);
                    if (n4 == null) continue;
                    double d = object.getDouble("Average" + string4);
                    this.setData(DiscretizeDataSource.COLUMN_NAMES.AVG, n4, new Double(d));
                    d = object.getDouble("Max" + string4);
                    this.setData(DiscretizeDataSource.COLUMN_NAMES.MAX, n4, new Double(d));
                    d = object.getDouble("Min" + string4);
                    this.setData(DiscretizeDataSource.COLUMN_NAMES.MIN, n4, new Double(d));
                    d = object.getDouble("Variance" + string4);
                    this.setData(DiscretizeDataSource.COLUMN_NAMES.STDDEV, n4, new Double(Math.sqrt(d)));
                }
                continue;
            }
            catch (Exception exception) {
                if (!OutlierDiscretizeDataSource.isDebug()) continue;
                exception.printStackTrace();
                continue;
            }
            finally {
                try {
                    object.close();
                    object2.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public void clearCutoffRange(int n) {
        this.setData(DiscretizeDataSource.COLUMN_NAMES.EXTRA_DATA_1, n, null);
        this.setData(DiscretizeDataSource.COLUMN_NAMES.EXTRA_DATA_2, n, null);
    }

    public void setCutoffRange(int n, String string, double d, double d2, boolean bl, int n2) {
        Object object;
        String string2 = this.getAttributeName(n);
        String string3 = this.m_lds.getComplexAttributeInfo(string2);
        String string4 = null;
        if (string3 != null) {
            object = this.m_sampledOutputCDS.getTXColumn(string3);
            string4 = ((TXColumn)object).getValueColumn();
        } else {
            string4 = string2;
        }
        object = new OutlierCutoffRange(string4, string, new Double(d), new Double(d2), bl, n2);
        this.setData(DiscretizeDataSource.COLUMN_NAMES.EXTRA_DATA_1, n, string);
        this.setData(DiscretizeDataSource.COLUMN_NAMES.EXTRA_DATA_2, n, object);
    }

    public void setCutoffRange(int n, String string, double d, double d2, double d3, boolean bl) {
        Object object;
        String string2 = this.getAttributeName(n);
        String string3 = this.m_lds.getComplexAttributeInfo(string2);
        String string4 = null;
        if (string3 != null) {
            object = this.m_sampledOutputCDS.getTXColumn(string3);
            string4 = ((TXColumn)object).getValueColumn();
        } else {
            string4 = string2;
        }
        object = new OutlierCutoffRange(string4, string, new Double(d), new Double(d2), new Double(d3), bl);
        this.setData(DiscretizeDataSource.COLUMN_NAMES.EXTRA_DATA_1, n, string);
        this.setData(DiscretizeDataSource.COLUMN_NAMES.EXTRA_DATA_2, n, object);
    }

    public void setCutoffRange(int n, String string, double d, double d2, double d3, double d4, boolean bl) {
        Object object;
        String string2 = this.getAttributeName(n);
        String string3 = this.m_lds.getComplexAttributeInfo(string2);
        String string4 = null;
        if (string3 != null) {
            object = this.m_sampledOutputCDS.getTXColumn(string3);
            string4 = ((TXColumn)object).getValueColumn();
        } else {
            string4 = string2;
        }
        object = new OutlierCutoffRange(string4, string, new Double(d), new Double(d2), new Double(d3), new Double(d4), bl);
        this.setData(DiscretizeDataSource.COLUMN_NAMES.EXTRA_DATA_1, n, string);
        this.setData(DiscretizeDataSource.COLUMN_NAMES.EXTRA_DATA_2, n, object);
    }

    public OutlierCutoffRange getCutoffRange(int n) {
        return (OutlierCutoffRange)this.getData(DiscretizeDataSource.COLUMN_NAMES.EXTRA_DATA_2, n);
    }

    public Object getOutlierViewDefinition(String string) {
        if (this.m_isTransactional && !this.m_bSingleMetric) {
            return this.getOutlierViewDefinitionTX(string);
        }
        return this.getOutlierViewDefinition2D(string);
    }

    protected Object getOutlierViewDefinition2D(String string) {
        Object object;
        String string2;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append("CREATE VIEW ");
            stringBuffer.append(string);
        }
        stringBuffer.append(" AS SELECT \n");
        Vector vector = new Vector(this.m_tableColumns);
        vector.addAll(this.m_lds.getSkippedAttributes());
        int n2 = vector.size();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        for (n = 0; n < n2; ++n) {
            string2 = (String)vector.elementAt(n);
            String string3 = this.m_lds.getComplexAttributeInfo(string2);
            if (string3 == null) {
                vector2.add(string2);
                continue;
            }
            vector3.add(string2);
        }
        for (n = 0; n < vector2.size(); ++n) {
            string2 = (String)vector2.elementAt(n);
            int n3 = this.getAttributeRow(string2);
            object = null;
            if (n3 != -1) {
                object = this.getCutoffRange(n3);
            }
            if (object != null) {
                stringBuffer.append(((OutlierCutoffRange)object).getWinsorizedView2D());
            } else {
                stringBuffer.append("\"" + this.getColumnName(string2) + "\"");
            }
            if (n >= vector2.size() - 1) continue;
            stringBuffer.append(",\n");
        }
        if (this.isSingleMetric() && this.isTransactional()) {
            stringBuffer.append(",");
            stringBuffer.append("\"" + this.m_attributeMapping + "\"");
            stringBuffer.append(",");
            stringBuffer.append("\"" + this.m_seqIdMapping + "\"");
        }
        if (n2 == 0) {
            stringBuffer.append(" * FROM ");
        } else {
            stringBuffer.append(" FROM ");
        }
        for (n = 0; n < vector3.size(); ++n) {
            TXColumn tXColumn;
            string2 = (String)vector3.elementAt(n);
            String string4 = this.m_lds.getComplexAttributeInfo(string2);
            if (string4 == null || (object = this.m_sampledInputCDS.getTXColumn(string4)) == null || (tXColumn = this.m_sampledOutputCDS.getTXColumn(string4)) == null) continue;
            String string5 = ((TXColumn)object).getNameColumn();
            String string6 = ((TXColumn)object).getTxColumnCaseId();
            StringBuffer stringBuffer2 = new StringBuffer("CREATE VIEW " + tXColumn.getDataLocation() + " AS SELECT " + (string5 == null ? "" : (DM4JStringUtils.isDoubleQuotedString(string5) ? string5 : DM4JStringUtils.addDoubleQuotes(string5)) + ",") + (DM4JStringUtils.isDoubleQuotedString(string6) ? string6 : DM4JStringUtils.addDoubleQuotes(string6)) + "," + "\n");
            int n4 = this.getAttributeRow(string2);
            OutlierCutoffRange outlierCutoffRange = null;
            if (n4 != -1) {
                outlierCutoffRange = this.getCutoffRange(n4);
            }
            if (outlierCutoffRange != null) {
                stringBuffer2.append(outlierCutoffRange.getWinsorizedView2D());
            } else {
                stringBuffer2.append("\"" + tXColumn.getValueColumn() + "\"");
            }
            stringBuffer2.append(" FROM " + ((TXColumn)object).getDataLocation());
            if (n4 != -1) {
                this.setViewDefinition(n4, stringBuffer2);
            }
            tXColumn.setSqlQuery(stringBuffer2);
        }
        return stringBuffer;
    }

    private StringBuffer getOutlierViewDefinitionTX(String string) {
        int n;
        CharSequence charSequence;
        int n2;
        StringBuffer stringBuffer = new StringBuffer("CREATE VIEW ");
        stringBuffer.append(string);
        stringBuffer.append(" AS SELECT ");
        String string2 = "CASE \"" + this.m_attributeMapping + "\"";
        int n3 = this.getTreatedCount();
        if (n3 == 0) {
            stringBuffer.append("\n");
            stringBuffer.append(" * FROM ");
            stringBuffer.append(this.m_sDataLocation);
            return stringBuffer;
        }
        stringBuffer.append("(\n" + string2);
        Vector vector = new Vector(this.m_tableColumns);
        vector.addAll(this.m_lds.getSkippedAttributes());
        int n4 = vector.size();
        int n5 = 0;
        int n6 = 0;
        StringBuffer stringBuffer2 = new StringBuffer(TAB);
        for (n2 = 0; n2 < n4; ++n2) {
            CharSequence charSequence2;
            charSequence = (String)vector.elementAt(n2);
            if (++n5 == 120) {
                n5 = 0;
                stringBuffer.append("\n" + stringBuffer2.toString() + "ELSE " + string2);
                stringBuffer2.append(TAB);
                ++n6;
            }
            n = this.getAttributeRow((String)charSequence);
            OutlierCutoffRange outlierCutoffRange = null;
            if (n != -1) {
                outlierCutoffRange = this.getCutoffRange(n);
            }
            stringBuffer.append("\n" + stringBuffer2.toString() + "WHEN ");
            try {
                charSequence2 = TransformsDirector.getReplacedString((String)charSequence, "'", "''");
            }
            catch (Exception exception) {
                charSequence2 = charSequence;
            }
            stringBuffer.append("'" + (String)charSequence2 + "'" + " THEN");
            if (outlierCutoffRange != null) {
                stringBuffer.append(" " + outlierCutoffRange.getWinsorizedViewTX(stringBuffer2.toString()));
                stringBuffer.append(" END");
                continue;
            }
            stringBuffer.append(" \"" + this.m_valueMapping + "\"");
        }
        stringBuffer.append("\n");
        for (n2 = 0; n2 < n6; ++n2) {
            charSequence = new StringBuffer();
            for (n = 0; n < n6 - n2; ++n) {
                ((StringBuffer)charSequence).append(TAB);
            }
            stringBuffer.append(((StringBuffer)charSequence).toString() + "END" + "\n");
        }
        stringBuffer.append(" END\n");
        stringBuffer.append(") \"" + this.m_valueMapping + "\"," + "\"" + this.m_attributeMapping + "\"," + "\"" + this.m_seqIdMapping + "\" ");
        stringBuffer.append(" FROM ");
        stringBuffer.append(this.m_sDataLocation);
        return stringBuffer;
    }

    private int getTreatedCount() {
        int n = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            OutlierCutoffRange outlierCutoffRange = this.getCutoffRange(i);
            if (outlierCutoffRange == null) continue;
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOutlierPercent(String[] stringArray, double d, double d2, boolean bl) {
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            for (int i = 0; i < stringArray.length; ++i) {
                int n = this.getAttributeRow(stringArray[i]);
                if (this.m_isTransactional && !this.m_bSingleMetric) {
                    this.setOutlierPercentTX(connection, n, stringArray[i], d, d2, bl);
                    continue;
                }
                this.setOutlierPercent2D(connection, n, stringArray[i], d, d2, bl);
            }
        }
        catch (Exception exception) {
            if (OutlierDiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setOutlierPercent2D(Connection connection, int n, String string, double d, double d2, boolean bl) {
        Object[] objectArray = new Object[]{"\"" + this.getColumnName(string) + "\"", this.getSampledDataLocation(), DM4JNumericFormat.SQLFormat(d), DM4JNumericFormat.SQLFormat(d2)};
        StringBuffer stringBuffer = new StringBuffer(STAT_SQL_OUTLIER_PERCENT_2D[0]);
        String string2 = MessageFormat.format(STAT_SQL_OUTLIER_PERCENT_2D[1], objectArray);
        stringBuffer.append(string2);
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet.next()) {
                double d3 = resultSet.getDouble("Average");
                double d4 = resultSet.getDouble("Max");
                double d5 = resultSet.getDouble("Min");
                double d6 = resultSet.getDouble("Variance");
                this.setAverage(n, d3);
                this.setMin(n, d5);
                this.setMax(n, d4);
                this.setVariance(n, Math.sqrt(d6));
                StringBuffer stringBuffer2 = new StringBuffer((bl ? "(" : "[") + String.valueOf(d) + "%, ");
                stringBuffer2.append(" ");
                stringBuffer2.append(String.valueOf(d2) + "%" + (bl ? ")" : "]"));
                this.setCutoffRange(this.getAttributeRow(string), stringBuffer2.toString(), d5, d4, d, d2, bl);
            }
        }
        catch (Exception exception) {
            if (OutlierDiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOutlierPercentTX(Connection connection, int n, String string, double d, double d2, boolean bl) {
        Object[] objectArray = new Object[]{"\"" + this.m_valueMapping + "\"", this.getSampledDataLocation(), DM4JNumericFormat.SQLFormat(d), DM4JNumericFormat.SQLFormat(d2), "\"" + this.m_attributeMapping + "\"", "'" + string + "'"};
        StringBuffer stringBuffer = new StringBuffer(STAT_SQL_OUTLIER_PERCENT_TX[0]);
        String string2 = MessageFormat.format(STAT_SQL_OUTLIER_PERCENT_TX[1], objectArray);
        stringBuffer.append(string2);
        string2 = MessageFormat.format(STAT_SQL_OUTLIER_PERCENT_TX[2], objectArray);
        stringBuffer.append(string2);
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet.next()) {
                double d3 = resultSet.getDouble("Average");
                double d4 = resultSet.getDouble("Max");
                double d5 = resultSet.getDouble("Min");
                double d6 = resultSet.getDouble("Variance");
                this.setAverage(n, d3);
                this.setMin(n, d5);
                this.setMax(n, d4);
                this.setVariance(n, Math.sqrt(d6));
                StringBuffer stringBuffer2 = new StringBuffer(String.valueOf(d) + "%, ");
                stringBuffer2.append(" ");
                stringBuffer2.append(String.valueOf(d2) + "%");
                this.setCutoffRange(this.getAttributeRow(string), stringBuffer2.toString(), d5, d4, d, d2, bl);
            }
        }
        catch (Exception exception) {
            if (OutlierDiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public boolean isSameStrategy(Integer[] integerArray) {
        if (integerArray == null) {
            return false;
        }
        OutlierCutoffRange outlierCutoffRange = this.getCutoffRange(integerArray[0]);
        if (outlierCutoffRange == null) {
            return false;
        }
        if (integerArray.length == 1) {
            return true;
        }
        for (int i = 1; i < integerArray.length; ++i) {
            OutlierCutoffRange outlierCutoffRange2 = this.getCutoffRange(integerArray[i]);
            if (outlierCutoffRange2 == null) {
                return false;
            }
            if (outlierCutoffRange2.isSameStrategy(outlierCutoffRange)) continue;
            return false;
        }
        return true;
    }

    public String getSampledDataLocation() {
        return this.m_isTransactional ? "(" + this.getOutlierTXNDefinition() + ")" : this.getSamplingViewDefinition();
    }

    protected String getOutlierTXNDefinition() {
        return this.getSamplingTXNViewDefinition().toString();
    }

    public String getSamplingViewDefinition() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.m_tableColumns.size();
        for (int i = 0; i < n; ++i) {
            string = (String)this.m_tableColumns.elementAt(i);
            int n2 = this.getAttributeRow(string);
            OutlierCutoffRange outlierCutoffRange = null;
            if (n2 != -1) {
                outlierCutoffRange = this.getCutoffRange(n2);
            }
            if (outlierCutoffRange != null) {
                stringBuffer.append(outlierCutoffRange.getWinsorizedView2D());
            } else {
                stringBuffer.append("\"" + string + "\"");
            }
            if (i >= n - 1) continue;
            stringBuffer.append(",");
        }
        Object[] objectArray = new Object[]{stringBuffer.toString(), this.getOriginalDataLocation(), String.valueOf(this.m_preferences.getSampleSize())};
        string = MessageFormat.format("(SELECT {0} FROM (  WITH s AS (SELECT COUNT(*) c FROM {1})   SELECT t.* FROM s, (SELECT t.*, ROWNUM RNUM FROM {1} t) t WHERE ORA_HASH(RNUM,(s.c-1),0) < {2} ))", objectArray);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getHistogramQuantileBinning(int n, Integer n2) {
        Connection connection = null;
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        hashtable.put(this.getAttributeName(n), new Integer(n));
        try {
            Object object;
            connection = DM4JConnectionManager.getDbConnection();
            int[] nArray = null;
            if (!hashtable.isEmpty()) {
                nArray = new int[hashtable.size()];
            }
            int n3 = 0;
            Vector<int[]> vector = new Vector<int[]>();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                Integer n4 = (Integer)hashtable.get(object);
                if (n4 == null) continue;
                int n5 = n4;
                nArray[n3++] = n5;
                vector.add((int[])object);
            }
            object = new int[n3];
            System.arraycopy(nArray, 0, object, 0, n3);
            this.getQtileStats(connection, vector, hashtable, null, n2);
        }
        catch (Exception exception) {
            if (OutlierDiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setAverage(int n, double d) {
        this.setData(DiscretizeDataSource.COLUMN_NAMES.AVG, n, new Double(d));
    }

    public void setMin(int n, double d) {
        this.setData(DiscretizeDataSource.COLUMN_NAMES.MIN, n, new Double(d));
    }

    public void setMax(int n, double d) {
        this.setData(DiscretizeDataSource.COLUMN_NAMES.MAX, n, new Double(d));
    }

    public void setVariance(int n, double d) {
        this.setData(DiscretizeDataSource.COLUMN_NAMES.VAR, n, new Double(d));
    }

    public String applyTreatment(String string) {
        int n = this.getAttributeRow(string);
        if (n == -1) {
            return super.applyTreatment(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string2 = this.m_lds.getComplexAttributeInfo(string);
            if (string2 == null) {
                OutlierCutoffRange outlierCutoffRange = this.getCutoffRange(n);
                if (outlierCutoffRange != null) {
                    stringBuffer.append(outlierCutoffRange.getWinsorizedView2D());
                } else {
                    stringBuffer.append("\"" + string + "\"");
                }
            } else {
                stringBuffer.append(" SELECT \n");
                TXColumn tXColumn = this.m_sampledInternallySampledCDS.getTXColumn(string2);
                OutlierCutoffRange outlierCutoffRange = this.getCutoffRange(n);
                if (outlierCutoffRange != null) {
                    stringBuffer.append(outlierCutoffRange.getWinsorizedView2D());
                } else {
                    stringBuffer.append("\"" + tXColumn.getValueColumn() + "\"");
                }
                stringBuffer.append(" FROM \n" + tXColumn.getDataLocation());
            }
        }
        catch (Exception exception) {
            if (OutlierDiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
            stringBuffer = new StringBuffer("\"" + string + "\"");
        }
        return stringBuffer.toString();
    }

    static {
        OutlierDiscretizeDataSource.items[DiscretizeDataSource.COLUMN_NAMES.EXTRA_DATA_1] = ResourceUtilities.getUILabel("OUTLIER_SETTINGS_TREATMENT");
    }

    public class OutlierCutoffRange {
        private String m_attributeName;
        private String m_displayName;
        private Double m_lowerValue;
        private Double m_upperValue;
        private Double m_lowerTailPercent = new Double(5.0);
        private Double m_upperTailPercent = new Double(5.0);
        private Double m_sigmaMultiple = new Double(3.0);
        private boolean m_bEdges = false;
        private int m_treatmentType;

        public OutlierCutoffRange(String string, String string2, Double d, Double d2, boolean bl, int n) {
            this.m_attributeName = string;
            this.m_displayName = string2;
            this.m_lowerValue = d;
            this.m_upperValue = d2;
            this.m_bEdges = bl;
            this.m_treatmentType = n;
        }

        public OutlierCutoffRange(String string, String string2, Double d, Double d2, Double d3, boolean bl) {
            this.m_attributeName = string;
            this.m_displayName = string2;
            this.m_sigmaMultiple = d3;
            this.m_lowerValue = d;
            this.m_upperValue = d2;
            this.m_bEdges = bl;
            this.m_treatmentType = 0;
        }

        public OutlierCutoffRange(String string, String string2, Double d, Double d2, Double d3, Double d4, boolean bl) {
            this.m_attributeName = string;
            this.m_displayName = string2;
            this.m_lowerValue = d;
            this.m_upperValue = d2;
            this.m_lowerTailPercent = d3;
            this.m_upperTailPercent = d4;
            this.m_bEdges = bl;
            this.m_treatmentType = 1;
        }

        private boolean isEqualDoubleValue(Double d, Double d2) {
            if (d != null && d != null) {
                return d.doubleValue() == d2.doubleValue();
            }
            return d == null && d == null;
        }

        public boolean isSameStrategy(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof OutlierCutoffRange)) {
                return false;
            }
            if (this.m_bEdges != ((OutlierCutoffRange)object).isEdges()) {
                return false;
            }
            if (this.m_treatmentType != ((OutlierCutoffRange)object).getTreatmentType()) {
                return false;
            }
            if (this.isPercentTreatment()) {
                if (!this.isEqualDoubleValue(this.m_lowerTailPercent, ((OutlierCutoffRange)object).getLowerTailPercent())) {
                    return false;
                }
                if (!this.isEqualDoubleValue(this.m_upperTailPercent, ((OutlierCutoffRange)object).getUpperTailPercent())) {
                    return false;
                }
            } else {
                if (this.isStdevTreatment()) {
                    return false != this.isEqualDoubleValue(this.m_sigmaMultiple, ((OutlierCutoffRange)object).getSigmaMultiple());
                }
                if (!this.isEqualDoubleValue(this.m_lowerValue, ((OutlierCutoffRange)object).getLowerValue())) {
                    return false;
                }
                if (!this.isEqualDoubleValue(this.m_upperValue, ((OutlierCutoffRange)object).getUpperValue())) {
                    return false;
                }
            }
            return true;
        }

        public int getTreatmentType() {
            return this.m_treatmentType;
        }

        public boolean isStdevTreatment() {
            return this.m_treatmentType == 0;
        }

        public boolean isPercentTreatment() {
            return this.m_treatmentType == 1;
        }

        public boolean isValueTreatment() {
            return this.m_treatmentType == 2;
        }

        public boolean isCustomTreatment() {
            return this.m_treatmentType == 3;
        }

        public void setLowerValue(Double d) {
            this.m_lowerValue = d;
        }

        public Double getLowerValue() {
            return this.m_lowerValue;
        }

        public void setUpperValue(Double d) {
            this.m_upperValue = d;
        }

        public Double getUpperValue() {
            return this.m_upperValue;
        }

        public void setDisplayName(String string) {
            this.m_displayName = string;
        }

        public String getDisplayName() {
            return this.m_displayName;
        }

        public void setEdges(boolean bl) {
            this.m_bEdges = bl;
        }

        public boolean isEdges() {
            return this.m_bEdges;
        }

        public Double getSigmaMultiple() {
            return this.m_sigmaMultiple;
        }

        public Double getLowerTailPercent() {
            return this.m_lowerTailPercent;
        }

        public Double getUpperTailPercent() {
            return this.m_upperTailPercent;
        }

        public String getWinsorizedView2D() {
            String[] stringArray = new String[]{"( CASE WHEN {0} < {1} THEN {3} ", "\n", "WHEN {0} >= {1} AND {0} <= {2} THEN {0} ", "\n", "WHEN {0} > {2} THEN {4} ", "\n", "end)  {0} ", "\n"};
            StringBuffer stringBuffer = new StringBuffer();
            DecimalFormat decimalFormat = this.formatWithPrecison(this.m_lowerValue, this.m_upperValue);
            for (int i = 0; i < stringArray.length; ++i) {
                String string = MessageFormat.format(stringArray[i], "\"" + OutlierDiscretizeDataSource.this.getColumnName(this.m_attributeName) + "\"", DM4JNumericFormat.SQLFormat(this.m_lowerValue, decimalFormat), DM4JNumericFormat.SQLFormat(this.m_upperValue, decimalFormat), this.m_bEdges ? DM4JNumericFormat.SQLFormat(this.m_lowerValue, decimalFormat) : "NULL", this.m_bEdges ? DM4JNumericFormat.SQLFormat(this.m_upperValue, decimalFormat) : "NULL");
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }

        private DecimalFormat formatWithPrecison(double d, double d2) {
            int n = 2;
            NumberFormat numberFormat = DecimalFormat.getNumberInstance();
            numberFormat.setGroupingUsed(true);
            numberFormat.setMaximumFractionDigits(n);
            numberFormat.setMinimumFractionDigits(0);
            DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
            DM4JNumericFormat.AdjustFormat(d, d2, decimalFormat);
            return decimalFormat;
        }

        public String getWinsorizedViewTX(String string) {
            if (string == null) {
                string = TAB;
            }
            String string2 = "CASE WHEN {0} < {1} THEN {3}  WHEN {0} >= {1} AND {0} <= {2} THEN {0} WHEN {0} > {2} THEN {4} ";
            String string3 = MessageFormat.format(string2, "\"" + OutlierDiscretizeDataSource.this.m_valueMapping + "\"", DM4JNumericFormat.SQLFormat(this.m_lowerValue), DM4JNumericFormat.SQLFormat(this.m_upperValue), this.m_bEdges ? DM4JNumericFormat.SQLFormat(this.m_lowerValue) : "NULL", this.m_bEdges ? DM4JNumericFormat.SQLFormat(this.m_upperValue) : "NULL");
            return string3;
        }
    }

    public static interface TREATMENT_TYPE {
        public static final int STDEV = 0;
        public static final int PERCENT = 1;
        public static final int VALUE = 2;
        public static final int CUSTOM = 3;
    }
}

