/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.text.MessageFormat;

public class NormalizeScheme {
    public static final int NONE = 0;
    public static final int EXP1 = 1;
    public static final int LN1 = 2;
    public static final int LN2 = 3;
    public static final int LOG = 4;
    public static final int SQRT = 5;
    public static final int EXP2 = 6;
    public static final int MEAN = 7;
    public static final int SCALE = 8;
    public static final int ZSCORE = 9;
    public static final int SPARSE_SCALE = 10;
    static int[] m_NumericSchemes = new int[]{0, 1, 2, 3, 4, 5, 6};
    static int[] m_NormalizeSchemes = new int[]{0, 8, 9, 10};
    private int m_scheme = 0;
    private float m_var1;
    private float m_var2;
    private float m_orgKurtosis;
    private float m_orgSkewness;
    private float m_orgMean;
    private float m_orgStd;
    private float m_orgMin;
    private float m_orgMax;
    private float m_newKurtosis;
    private float m_newSkewness;
    private float m_newMean;
    private float m_newStd;
    private float m_newMin;
    private float m_newMax;
    private String m_uniqueName;

    public static int[] getSchemes(boolean bl) {
        return bl ? m_NormalizeSchemes : m_NumericSchemes;
    }

    public void setScheme(int n, float f, float f2) {
        this.m_scheme = n;
        this.m_var1 = f;
        this.m_var2 = f2;
    }

    public void setOrgStats(float f, float f2, float f3, float f4, float f5, float f6) {
        this.setOrgKurtosis(f);
        this.setOrgSkewness(f2);
        this.setOrgMean(f3);
        this.setOrgStd(f4);
        this.setOrgMin(f5);
        this.setOrgMax(f6);
    }

    public void setNewStats(float f, float f2, float f3, float f4, float f5, float f6) {
        this.setNewKurtosis(f);
        this.setNewSkewness(f2);
        this.setNewMean(f3);
        this.setNewStd(f4);
        this.setNewMin(f5);
        this.setNewMax(f6);
    }

    public void setOrgKurtosis(float f) {
        this.m_orgKurtosis = f;
    }

    public void setOrgSkewness(float f) {
        this.m_orgSkewness = f;
    }

    public void setOrgMean(float f) {
        this.m_orgMean = f;
    }

    public void setOrgStd(float f) {
        this.m_orgStd = f;
    }

    public void setOrgMin(float f) {
        this.m_orgMin = f;
    }

    public void setOrgMax(float f) {
        this.m_orgMax = f;
    }

    public void setComplexAttributeInfo(String string) {
        this.m_uniqueName = string;
    }

    public float getOrgKurtosis() {
        return this.m_orgKurtosis;
    }

    public float getOrgSkewness() {
        return this.m_orgSkewness;
    }

    public float getOrgMean() {
        return this.m_orgMean;
    }

    public float getOrgStd() {
        return this.m_orgStd;
    }

    public float getOrgMin() {
        return this.m_orgMin;
    }

    public float getOrgMax() {
        return this.m_orgMax;
    }

    public String getComplexAttributeInfo() {
        return this.m_uniqueName;
    }

    public void setNewKurtosis(float f) {
        this.m_newKurtosis = f;
    }

    public void setNewSkewness(float f) {
        this.m_newSkewness = f;
    }

    public void setNewMean(float f) {
        this.m_newMean = f;
    }

    public void setNewStd(float f) {
        this.m_newStd = f;
    }

    public void setNewMin(float f) {
        this.m_newMin = f;
    }

    public void setNewMax(float f) {
        this.m_newMax = f;
    }

    public float getNewKurtosis() {
        return this.m_newKurtosis;
    }

    public float getNewSkewness() {
        return this.m_newSkewness;
    }

    public float getNewMean() {
        return this.m_newMean;
    }

    public float getNewStd() {
        return this.m_newStd;
    }

    public float getNewMin() {
        return this.m_newMin;
    }

    public float getNewMax() {
        return this.m_newMax;
    }

    public int getType() {
        return this.m_scheme;
    }

    public float getArg1() {
        return this.m_var1;
    }

    public float getArg2() {
        return this.m_var2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.m_scheme) {
            case 1: {
                stringBuffer.append("EXP(x)");
                break;
            }
            case 2: {
                String string = "LN(x + {0})";
                Object[] objectArray = new Object[]{this.m_var1 + ""};
                stringBuffer.append(MessageFormat.format(string, objectArray));
                break;
            }
            case 3: {
                String string = "LN((x - {0}) / ({1} - x))";
                Object[] objectArray = new Object[]{this.m_var1 + "", this.m_var2 + ""};
                stringBuffer.append(MessageFormat.format(string, objectArray));
                break;
            }
            case 4: {
                String string = "LOG(10, x + {0})";
                Object[] objectArray = new Object[]{this.m_var1 + ""};
                stringBuffer.append(MessageFormat.format(string, objectArray));
                break;
            }
            case 5: {
                String string = "SQRT(x)";
                stringBuffer.append(string);
                break;
            }
            case 6: {
                String string = "1 / EXP(AVG(x) - x)";
                stringBuffer.append(string);
                break;
            }
            case 7: {
                String string = "({0} / VARIANCE(x)) * (x - ({1} - AVG(x)))";
                Object[] objectArray = new Object[]{this.m_var1 + "", this.m_var2 + ""};
                stringBuffer.append(MessageFormat.format(string, objectArray));
                break;
            }
            case 8: {
                String string = "(x - MIN(x) / MAX(x) - MIN(x)) * ({1} - {0}) + {0}";
                Object[] objectArray = new Object[]{this.m_var1 + "", this.m_var2 + ""};
                stringBuffer.append(MessageFormat.format(string, objectArray));
                break;
            }
            case 9: {
                String string = "(x - AVG(x)) / SQRT(VARIANCE(x))";
                stringBuffer.append(string);
                break;
            }
            case 10: {
                String string = "(x / MAX(ABS(MIN(x)), ABS(MAX(x))))";
                stringBuffer.append(string);
                break;
            }
        }
        return stringBuffer.toString();
    }
}

