/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Vector;
import javax.datamining.base.Model;
import javax.datamining.data.AttributeDataType;
import javax.datamining.data.AttributeType;
import javax.datamining.data.SignatureAttribute;
import javax.datamining.resource.Connection;
import javax.datamining.supervised.SupervisedModel;
import javax.datamining.supervised.classification.ClassificationModel;
import javax.datamining.supervised.regression.RegressionModel;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.dmt.dm4j.DM4JException;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.data.ActivityUtils;
import oracle.dmt.dm4j.browser.UserPreferences;
import oracle.dmt.dm4j.datasources.DM4JDataSource;
import oracle.dmt.dm4j.datasources.DiffLDSDataSource;
import oracle.dmt.dm4j.datasources.MissingTargetAttributeException;
import oracle.dmt.dm4j.wizard.director.transforms.TransformsDirector;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.commonsteps.DataState;
import oracle.dmt.dm4j.wizard.state.commonsteps.MultiRecordCaseData;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;

public class LDSDataSource
extends DM4JDataSource {
    protected AbstractActivity m_activity;
    protected boolean m_bOverRideEuristics = false;
    public static final int REGRESSION = 1;
    public static final int CLASSIFICATION = 2;
    protected UserPreferences m_preferences = null;
    private static final String SQL_SAMPLING_VIEW = "(SELECT {0} FROM (  WITH s AS (SELECT COUNT(*) c FROM {1})   SELECT t.* FROM s, (SELECT t.*, ROWNUM RNUM FROM {1} t) t WHERE ORA_HASH(RNUM,(s.c-1),0) < {2} ))";
    protected static final String SQL_SAMPLING_VIEW_KNOWN_COUNT = "(SELECT {0} FROM (\n  SELECT t.* FROM (SELECT t.*, ROWNUM RNUM FROM {1} t) t WHERE ORA_HASH(RNUM,({3}-1),0) < {2} ))";
    private static final String SQL_TXN_SAMPLING_VIEW = "(SELECT ORIGINAL_DATA.* FROM   {0} ORIGINAL_DATA,   ( select {1}  from (       (select distinct t.{1}, ora_hash({1}, 99, 5 ) dm$rv from {0} t order by dm$rv)  ) where rownum <= {2} ) RANDOM_IDS WHERE RANDOM_IDS.{1} = ORIGINAL_DATA.{1})";
    private final int ATTRIBUTE_SCAN_SIZE = 1000;
    private String m_dataLocation = null;
    private static final int COLUMN_COUNT = 17;
    public static final int INCLUDE = 0;
    public static final int NAME = 1;
    public static final int DATA_TYPE = 2;
    public static final int MINING_TYPE = 3;
    public static final int USAGE_TYPE = 5;
    public static final int SPARSE = 4;
    public static final int DEFAULT_MINING_TYPE = 6;
    public static final int DEFAULT_USAGE_TYPE = 7;
    public static final int DEFAULT_INCLUDE = 8;
    public static final int DEFAULT_SPARSE = 9;
    public static final int COUNT = 10;
    public static final int NULLS = 11;
    public static final int CONTAINS_FLOATS = 12;
    public static final int MIN = 13;
    public static final int TOTAL_COUNT = 14;
    public static final int UNIQUE = 15;
    public static final int COMPLEX_ATTRIBUTE = 16;
    protected static final String PRIMARY_KEY = "ENABLED";
    private boolean m_acceptsTextData = false;
    private boolean m_acceptsNestedData = true;
    protected boolean m_adjustDataUsage = true;
    protected boolean m_getStatistics = false;
    private boolean m_bSingleMetric = false;
    protected boolean m_loadFromODM = false;
    protected Model m_miningModel = null;
    protected String m_attribute_column_name = null;
    protected String m_value_column_name = null;
    protected String m_seqid_column_name = null;
    protected Vector m_allAttributes = new Vector();
    protected Vector m_skippedAttributes = new Vector();
    protected boolean m_FormatIsTransactional = false;
    protected int m_caseCount = -1;
    public static final int CASE_COUNT = 0;
    protected Hashtable m_nestedAttributeCount = new Hashtable();
    protected Hashtable m_NameRow = new Hashtable();
    protected Hashtable m_AttributeNameValueMap;

    protected AbstractActivity getActivity() {
        return this.m_activity;
    }

    public void setBuildStep(boolean bl) {
        this.m_bOverRideEuristics = bl;
    }

    protected void setDataLocation(String string) {
        this.m_dataLocation = string;
    }

    public String getAttributeColumnName() {
        return this.m_attribute_column_name;
    }

    public String getValueColumnName() {
        return this.m_value_column_name;
    }

    public String getSeqIdName() {
        return this.m_seqid_column_name;
    }

    public Vector getSkippedAttributes() {
        return this.m_skippedAttributes;
    }

    public String getValueColumn(String string) {
        if (this.m_AttributeNameValueMap == null) {
            return null;
        }
        return (String)this.m_AttributeNameValueMap.get(string);
    }

    public Integer getNestedAttributeCount(String string) {
        if (this.m_nestedAttributeCount == null) {
            return null;
        }
        return (Integer)this.m_nestedAttributeCount.get(string);
    }

    public LDSDataSource() throws Exception {
        this.m_preferences = UserPreferences.getInstance();
    }

    public int getCaseCount() {
        return this.m_caseCount;
    }

    protected void countCasesFrom2DDBTable(java.sql.Connection connection, String string, String string2) throws SQLException {
        if (this.m_caseCount != -1) {
            return;
        }
        String string3 = "select COUNT(*) FROM \"" + string2 + "\".\"" + string + "\"";
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        try {
            callableStatement = connection.prepareCall(string3);
            resultSet = callableStatement.executeQuery();
            if (resultSet.next()) {
                this.m_caseCount = resultSet.getInt(1);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw sQLException;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (callableStatement != null) {
                callableStatement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void countCasesFromTransactionalDBTable(java.sql.Connection connection, String string, String string2, String string3) throws SQLException {
        String string4 = "select COUNT(DISTINCT (" + string3 + ")) from " + "\"" + string2 + "\".\"" + string + "\"";
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        try {
            callableStatement = connection.prepareCall(string4);
            resultSet = callableStatement.executeQuery();
            if (resultSet.next()) {
                this.m_caseCount = resultSet.getInt(1);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (callableStatement != null) {
                callableStatement.close();
            }
        }
    }

    public LDSDataSource(Connection connection, String string, String string2, boolean bl, boolean bl2) {
        this(connection, string, string2, bl, true, true, bl2);
    }

    public LDSDataSource(Connection connection, String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(connection, string, string2);
        this.m_acceptsTextData = bl;
        this.m_acceptsNestedData = bl2;
        this.m_adjustDataUsage = bl3;
        this.m_getStatistics = bl4;
        this.m_preferences = UserPreferences.getInstance();
    }

    public LDSDataSource(java.sql.Connection connection, DataState dataState, String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        super(connection, dataState, string, string2);
        this.m_acceptsTextData = bl;
        this.m_acceptsNestedData = true;
        this.m_adjustDataUsage = true;
        this.m_getStatistics = bl2;
        this.m_bSingleMetric = bl3;
        this.m_preferences = UserPreferences.getInstance();
    }

    public LDSDataSource(java.sql.Connection connection, DataState dataState, String string, String string2, boolean bl, boolean bl2) {
        this(connection, dataState, string, string2, bl, true, true, bl2);
    }

    public LDSDataSource(java.sql.Connection connection, DataState dataState, String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(connection, dataState, string, string2);
        this.m_acceptsTextData = bl;
        this.m_acceptsNestedData = bl2;
        this.m_adjustDataUsage = bl3;
        this.m_getStatistics = bl4;
        this.m_preferences = UserPreferences.getInstance();
    }

    public LDSDataSource(Connection connection, String string, String string2) {
        super(connection, string, string2);
        this.m_preferences = UserPreferences.getInstance();
    }

    public LDSDataSource(Connection connection, Model model) {
        super(connection, null, model.getName());
        this.m_miningModel = model;
        this.m_loadFromODM = true;
        this.m_preferences = UserPreferences.getInstance();
    }

    public LDSDataSource(Connection connection, Model model, boolean bl, boolean bl2) {
        this(connection, model, bl, true, true, bl2);
    }

    public LDSDataSource(Connection connection, Model model, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(connection, null, model.getName());
        this.m_miningModel = model;
        this.m_loadFromODM = true;
        this.m_acceptsTextData = bl;
        this.m_acceptsNestedData = bl2;
        this.m_adjustDataUsage = bl3;
        this.m_getStatistics = bl4;
        this.m_preferences = UserPreferences.getInstance();
    }

    public String getDataSource() {
        return this.m_schema + "." + this.m_table;
    }

    public boolean isDirty() {
        boolean bl = false;
        for (int i = 0; i < this.getRowCount(); ++i) {
            Boolean bl2 = (Boolean)this.getData(0, i);
            if (bl2.booleanValue()) {
                String string = (String)this.getData(1, i);
                String string2 = (String)this.getData(2, i);
                String string3 = (String)this.getData(3, i);
                if (!string3.equals("categorical") || !string2.equals("NUMBER") && !string2.equals("FLOAT") && !string2.equals("DATE")) continue;
                bl = true;
                break;
            }
            bl = true;
            break;
        }
        return bl;
    }

    public String getSQLString() {
        int n = this.getRowCount();
        if (n == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("SELECT ");
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Boolean bl = (Boolean)this.getData(0, i);
            if (!bl.booleanValue()) continue;
            String string = (String)this.getData(1, i);
            String string2 = (String)this.getData(2, i);
            String string3 = (String)this.getData(3, i);
            if (n2 > 0) {
                stringBuffer.append(",");
            }
            if ((string2.equals("NUMBER") || string2.equals("FLOAT")) && string3.equals("categorical")) {
                stringBuffer.append("TO_CHAR(\"" + string + "\") \"" + string + "\"");
            } else if (string2.equals("DATE") && string3.equals("categorical")) {
                stringBuffer.append("TO_CHAR(\"" + string + "\") \"" + string + "\"");
            } else {
                stringBuffer.append("\"" + string + "\"");
            }
            ++n2;
        }
        stringBuffer.append(" FROM ");
        if (this.m_schema != null) {
            stringBuffer.append("\"" + this.m_schema + "\"");
            if (this.m_table != null) {
                stringBuffer.append(".\"" + this.m_table + "\"");
            }
        } else if (this.m_table != null) {
            stringBuffer.append("\"" + this.m_table + "\"");
        } else {
            stringBuffer.append("DUAL");
        }
        return stringBuffer.toString();
    }

    protected void createData() throws Exception {
        if (this.m_loadFromDMS) {
            if (this.m_loadFromODM) {
                this.createDataFromODMModel();
            } else {
                this.createDataFromDB();
            }
        }
    }

    protected void createDataFromDB() throws SQLException, DM4JException, Exception {
        this.setDataLocation("\"" + this.m_schema + "\".\"" + this.m_table + "\"");
        if (this.m_dataState != null && this.m_dataState instanceof MultiRecordCaseData && ((MultiRecordCaseData)this.m_dataState).isMultipleRecordCaseFormat()) {
            this.m_FormatIsTransactional = true;
            if (!this.m_bSingleMetric) {
                this.formLDSFromTransactionalDBTable(this.m_conn, this.m_table, this.m_schema);
            } else {
                this.formLDSFromTransactionalDBTableSM(this.m_conn, this.m_table, this.m_schema);
            }
        } else {
            this.m_FormatIsTransactional = false;
            this.formLDSFrom2DDBTable(this.m_conn, this.m_table, this.m_schema);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void formLDSFrom2DDBTable(java.sql.Connection connection, String string, String string2) throws SQLException, Exception {
        String string3 = "SELECT c.COLUMN_NAME, c.DATA_TYPE, con.CONSTRAINT_TYPE FROM all_tab_columns c, (SELECT cn.OWNER, cn.TABLE_NAME, cn.COLUMN_NAME, cd.CONSTRAINT_TYPE FROM all_cons_columns cn, all_constraints cd WHERE cn.OWNER = cd.OWNER AND cn.TABLE_NAME = cd.TABLE_NAME AND cn.CONSTRAINT_NAME = cd.CONSTRAINT_NAME AND 'P' = cd.CONSTRAINT_TYPE AND 'ENABLED' = cd.STATUS) con WHERE c.OWNER = ? AND c.TABLE_NAME = ? AND c.OWNER = con.OWNER(+) AND c.TABLE_NAME = con.TABLE_NAME(+) AND c.COLUMN_NAME = con.COLUMN_NAME(+) ORDER BY column_name ASC";
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        Vector vector = new Vector();
        Hashtable hashtable = new Hashtable();
        Vector vector2 = new Vector();
        Hashtable hashtable2 = new Hashtable();
        try {
            callableStatement = connection.prepareCall(string3);
            int n = 1;
            boolean bl = false;
            String string4 = "";
            callableStatement.setString(n++, string2);
            callableStatement.setString(n++, string);
            resultSet = callableStatement.executeQuery();
            boolean bl2 = false;
            int n2 = 0;
            while (resultSet.next()) {
                String string5;
                boolean bl3 = false;
                bl2 = true;
                bl = false;
                String string6 = resultSet.getString("COLUMN_NAME");
                String string7 = resultSet.getString("DATA_TYPE");
                String string8 = resultSet.getString("CONSTRAINT_TYPE");
                Object var21_22 = null;
                if (string7.compareTo("NUMBER") == 0) {
                    string5 = "numerical";
                    string4 = string7;
                } else if (string7.compareTo("DM_NESTED_NUMERICALS") == 0) {
                    string5 = "numerical";
                    string4 = string7;
                } else if (string7.compareTo("DM_NESTED_CATEGORICALS") == 0) {
                    string5 = "categorical";
                    string4 = string7;
                } else if (string7.compareTo("DATE") == 0) {
                    string5 = "categorical";
                    string4 = string7;
                } else if (string7.compareTo("VARCHAR2") == 0 || string7.compareTo("CHAR") == 0) {
                    string5 = "categorical";
                    string4 = string7;
                } else if (string7.compareTo("FLOAT") == 0) {
                    string5 = "numerical";
                    string4 = string7;
                } else {
                    string4 = string7;
                    string5 = "notApplicable";
                    bl3 = true;
                }
                this.addRows(n2, 1);
                if (string6.compareTo(ActivityUtils.getCaseIdName()) == 0 || string8 == PRIMARY_KEY) {
                    super.setData(5, n2, (Object)"caseId");
                    super.setData(7, n2, (Object)"caseId");
                } else {
                    super.setData(5, n2, (Object)"active");
                    super.setData(7, n2, (Object)"active");
                }
                super.setData(0, n2, (Object)(bl3 ? Boolean.FALSE : Boolean.TRUE));
                super.setData(8, n2, (Object)(bl3 ? Boolean.FALSE : Boolean.TRUE));
                super.setData(1, n2, (Object)string6);
                this.m_NameRow.put(string6, new Integer(n2));
                this.m_allAttributes.add(string6);
                super.setData(2, n2, (Object)string4);
                super.setData(3, n2, (Object)string5);
                super.setData(6, n2, (Object)string5);
                super.setData(4, n2, (Object)new Boolean(bl));
                super.setData(9, n2, (Object)new Boolean(bl));
                super.setData(16, n2, null);
                if (this.m_getStatistics) {
                    boolean bl4 = false;
                    if (this.m_activity == null && (string7 == null || string7.equals("DM_NESTED_NUMERICALS") || string7.equals("DM_NESTED_CATEGORICALS"))) {
                        bl4 = true;
                    }
                    if (!bl4) {
                        this.addColumnNamesForStats(vector, hashtable, vector2, hashtable2, string6, string4, string5, n2);
                    }
                }
                ++n2;
            }
            if (this.getRowCount() > 0 && this.m_getStatistics) {
                this.countCasesFrom2DDBTable(connection, string, string2);
                String string9 = this.getSamplingViewDefinition();
                this.addAllStats(connection, vector, vector2, hashtable, hashtable2, string9);
                hashtable.clear();
                vector.clear();
            }
        }
        finally {
            if (callableStatement != null) {
                callableStatement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    protected boolean ignoreType(String string) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String determineLDSTransactionalDataType(java.sql.Connection connection, MultiRecordCaseData multiRecordCaseData, String string, String string2) throws SQLException, DM4JException, Exception {
        boolean bl = false;
        String string3 = null;
        String string4 = null;
        String string5 = "SELECT c.COLUMN_NAME, c.DATA_TYPE, c.DATA_SCALE,c.DATA_PRECISION, c.DATA_LENGTH,con.CONSTRAINT_TYPE FROM all_tab_columns c, (SELECT cn.OWNER, cn.TABLE_NAME, cn.COLUMN_NAME, cd.CONSTRAINT_TYPE FROM all_cons_columns cn, all_constraints cd WHERE cn.OWNER = cd.OWNER AND cn.TABLE_NAME = cd.TABLE_NAME AND cn.CONSTRAINT_NAME = cd.CONSTRAINT_NAME AND 'P' = cd.CONSTRAINT_TYPE AND 'ENABLED' = cd.STATUS) con WHERE c.OWNER = ? AND c.TABLE_NAME = ? AND c.OWNER = con.OWNER(+) AND c.TABLE_NAME = con.TABLE_NAME(+) AND c.COLUMN_NAME = con.COLUMN_NAME(+) AND c.COLUMN_NAME = ? ORDER BY column_name ASC";
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        try {
            callableStatement = connection.prepareCall(string5);
            int n = 1;
            String string6 = multiRecordCaseData.getValueMapping();
            string3 = TransformsDirector.getReplacedString(string6, "'", "''");
            callableStatement.setString(n++, string2);
            callableStatement.setString(n++, string);
            callableStatement.setString(n++, string6);
            resultSet = callableStatement.executeQuery();
            boolean bl2 = false;
            boolean bl3 = false;
            while (resultSet.next()) {
                bl = true;
                String string7 = resultSet.getString("COLUMN_NAME");
                String string8 = resultSet.getString("DATA_TYPE");
                int n2 = resultSet.getInt("DATA_SCALE");
                int n3 = resultSet.getInt("DATA_PRECISION");
                int n4 = resultSet.getInt("DATA_LENGTH");
                if (string8.compareTo("NUMBER") == 0) {
                    string4 = string8;
                    continue;
                }
                if (string8.compareTo("VARCHAR2") == 0 || string8.compareTo("CHAR") == 0) {
                    if (n4 == 1) {
                        string4 = "CHAR";
                        continue;
                    }
                    string4 = "VARCHAR2";
                    continue;
                }
                string4 = "";
                bl2 = true;
                this.m_skippedAttributes.add(string7);
            }
        }
        finally {
            if (callableStatement != null) {
                callableStatement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
        if (!bl) {
            DM4JException dM4JException = new DM4JException("No column definition found in table for column name: " + string3);
            throw dM4JException;
        }
        return string4;
    }

    protected void formLDSFromTransactionalDBTableSM(java.sql.Connection connection, String string, String string2) throws SQLException, DM4JException, Exception {
        String string3;
        if (!(this.m_dataState instanceof MultiRecordCaseData)) {
            throw new Exception();
        }
        MultiRecordCaseData multiRecordCaseData = (MultiRecordCaseData)this.m_dataState;
        boolean bl = false;
        String string4 = this.determineLDSTransactionalDataType(connection, multiRecordCaseData, string, string2);
        if (string4.compareTo("NUMBER") == 0) {
            string3 = "numerical";
        } else if (string4.compareTo("DM_NESTED_NUMERICALS") == 0) {
            string3 = "numerical";
        } else if (string4.compareTo("DM_NESTED_CATEGORICALS") == 0) {
            string3 = "categorical";
        } else if (string4.compareTo("DATE") == 0) {
            string3 = "categorical";
        } else if (string4.compareTo("VARCHAR2") == 0 || string4.compareTo("CHAR") == 0) {
            string3 = "categorical";
        } else if (string4.compareTo("FLOAT") == 0) {
            string3 = "numerical";
        } else {
            string3 = "notApplicable";
            bl = true;
        }
        if (bl) {
            return;
        }
        this.m_attribute_column_name = multiRecordCaseData.getAttributeNameMapping();
        this.m_value_column_name = multiRecordCaseData.getValueMapping();
        this.m_seqid_column_name = multiRecordCaseData.getSequenceIDMapping();
        this.m_AttributeNameValueMap = new Hashtable();
        this.m_AttributeNameValueMap.put(this.m_attribute_column_name, this.m_value_column_name);
        this.addRows(0, 1);
        super.setData(0, 0, (Object)Boolean.TRUE);
        super.setData(8, 0, (Object)Boolean.TRUE);
        super.setData(1, 0, (Object)this.m_attribute_column_name);
        this.m_NameRow.put(this.m_attribute_column_name, new Integer(0));
        this.m_allAttributes.add(this.m_value_column_name);
        super.setData(2, 0, (Object)string4);
        super.setData(3, 0, (Object)string3);
        super.setData(5, 0, (Object)"active");
        super.setData(7, 0, (Object)"active");
        super.setData(6, 0, (Object)string3);
        super.setData(4, 0, (Object)Boolean.FALSE);
        super.setData(9, 0, (Object)Boolean.FALSE);
        if (this.m_getStatistics) {
            String string5 = this.getSamplingViewDefinition();
            Hashtable hashtable = new Hashtable();
            Vector vector = new Vector();
            Hashtable hashtable2 = new Hashtable();
            Vector vector2 = new Vector();
            this.addColumnNamesForStats(vector, hashtable, vector2, hashtable2, this.m_value_column_name, string4, string3, 0);
            if (string4.equals("NUMBER")) {
                this.addNumericStats(connection, vector, hashtable, string5);
            } else if (string4.equals("VARCHAR2")) {
                this.addCategoricStats(connection, vector2, hashtable2, string5);
            }
            hashtable.clear();
            hashtable2.clear();
            vector.clear();
            vector2.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void formLDSFromTransactionalDBTable(java.sql.Connection connection, String string, String string2) throws SQLException, DM4JException, Exception {
        String string3;
        String string4;
        String string5;
        if (!(this.m_dataState instanceof MultiRecordCaseData)) {
            throw new Exception();
        }
        MultiRecordCaseData multiRecordCaseData = (MultiRecordCaseData)this.m_dataState;
        String string6 = this.determineLDSTransactionalDataType(connection, multiRecordCaseData, string, string2);
        this.m_attribute_column_name = string5 = multiRecordCaseData.getAttributeNameMapping();
        this.m_value_column_name = string4 = multiRecordCaseData.getValueMapping();
        this.m_seqid_column_name = string3 = multiRecordCaseData.getSequenceIDMapping();
        String string7 = " SELECT DISTINCT \"" + this.m_attribute_column_name + "\" as myDistincts FROM \"" + string2 + "\".\"" + string + "\" ORDER BY myDistincts ASC";
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        try {
            String string8;
            callableStatement = connection.prepareCall(string7);
            resultSet = callableStatement.executeQuery();
            int n = 0;
            while (resultSet.next()) {
                string8 = resultSet.getString("MYDISTINCTS");
                this.addRows(n, 1);
                super.setData(0, n, (Object)Boolean.TRUE);
                super.setData(8, n, (Object)Boolean.TRUE);
                super.setData(1, n, (Object)string8);
                this.m_NameRow.put(string8, new Integer(n));
                this.m_allAttributes.add(string8);
                super.setData(2, n, (Object)string6);
                super.setData(3, n, (Object)"numerical");
                super.setData(5, n, (Object)"active");
                super.setData(7, n, (Object)"active");
                super.setData(6, n, (Object)"numerical");
                super.setData(4, n, (Object)Boolean.FALSE);
                super.setData(9, n, (Object)Boolean.FALSE);
                if (this.m_getStatistics) {
                    hashtable.put(string8, new Integer(n));
                }
                ++n;
            }
            callableStatement.close();
            if (this.getRowCount() > 0 && this.m_getStatistics) {
                string8 = this.getSamplingTXNViewDefinition();
                this.addNumericStatsTX(connection, hashtable, string8);
                hashtable.clear();
            }
        }
        finally {
            if (callableStatement != null) {
                callableStatement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    protected ArrayOneDModel createColumns() throws Exception {
        this.addColumns(0, 17);
        Object[] objectArray = new String[17];
        objectArray[0] = ResourceUtilities.getUILabel("DATA_USAGE_INCLUDE");
        objectArray[1] = ResourceUtilities.getUILabel("DATA_USAGE_ATTRIBUTE_NAME");
        objectArray[2] = ResourceUtilities.getUILabel("DATA_USAGE_DATA_TYPE");
        objectArray[3] = ResourceUtilities.getUILabel("DATA_USAGE_MINING_TYPE");
        objectArray[4] = ResourceUtilities.getUILabel("DATA_USAGE_SPARSITY");
        objectArray[5] = "Usage type";
        objectArray[7] = "Default usage type";
        objectArray[6] = "Default mining type";
        objectArray[8] = "Default include";
        objectArray[9] = "Default sparsity";
        objectArray[10] = ResourceUtilities.getUILabel("DATA_USAGE_COUNT");
        objectArray[11] = ResourceUtilities.getUILabel("DATA_USAGE_MISSING");
        objectArray[12] = "Contains floats indicator";
        objectArray[14] = ResourceUtilities.getUILabel("DATA_USAGE_SAMPLE_COUNT");
        objectArray[15] = ResourceUtilities.getUILabel("DATA_USAGE_UNIDUE");
        objectArray[16] = "Complex Attribute";
        return new ArrayOneDModel(objectArray);
    }

    public Vector getAttributes(boolean bl, boolean bl2) {
        return this.getAttributes(bl, bl2, 2);
    }

    public Vector getAttributes(boolean bl, boolean bl2, int n) {
        Vector<Object> vector;
        Boolean bl3 = Boolean.FALSE;
        if (bl) {
            vector = new Vector<Object>(this.getRowCount());
            for (int i = 0; i < this.getRowCount(); ++i) {
                bl3 = (Boolean)this.getData(0, i);
                if (!bl3.booleanValue()) continue;
                if (bl2) {
                    if (!this.isEligibleForTarget((String)this.getData(2, i), n)) continue;
                    vector.add(this.getData(1, i));
                    continue;
                }
                vector.add(this.getData(1, i));
            }
        } else {
            vector = new Vector(this.getRowCount());
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (bl2) {
                    if (!this.isEligibleForTarget((String)this.getData(2, i), n)) continue;
                    vector.add(this.getData(1, i));
                    continue;
                }
                vector.add(this.getData(1, i));
            }
        }
        return vector;
    }

    private boolean isEligibleForTarget(String string, int n) {
        boolean bl = false;
        bl = n == 2 ? string.equals("VARCHAR2") || string.equals("CHAR") || string.equals("FLOAT") || string.equals("NUMBER") : string.equals("FLOAT") || string.equals("NUMBER");
        return bl;
    }

    public Vector getInEligibleTargetAttributeIndexes() {
        return this.getInEligibleTargetAttributeIndexes(2);
    }

    public Vector getInEligibleTargetAttributeIndexes(int n) {
        Vector<String> vector = new Vector<String>(this.getRowCount());
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (this.isEligibleForTarget((String)this.getData(2, i), n)) continue;
            vector.add(Integer.toString(i));
        }
        return vector;
    }

    public String getFirstQualifyingAttributeWithDataType(String[] stringArray) {
        String string = null;
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = 0; j < stringArray.length; ++j) {
                if (!stringArray[j].equals(this.getData(2, i))) continue;
                string = (String)this.getData(1, i);
                j = stringArray.length;
                i = this.getRowCount();
            }
        }
        return string;
    }

    public void setData(int n, int n2, Object object) {
        super.setData(n, n2, object);
    }

    public int getActiveAttributeCountExcludingTargets() {
        int n = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!((Boolean)this.getData(0, i)).booleanValue() || ((String)this.getData(5, i)).equals("target")) continue;
            if (this.getData(16, i) != null) {
                Integer n2 = this.getNestedAttributeCount((String)this.getData(1, i));
                if (n2 == null) continue;
                n += n2.intValue();
                continue;
            }
            ++n;
        }
        return n;
    }

    public int getCountOfTexts(boolean bl) {
        int n = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!((String)this.getData(3, i)).equals("text")) continue;
            if (bl) {
                if (!((Boolean)this.getData(0, i)).booleanValue()) continue;
                ++n;
                continue;
            }
            ++n;
        }
        return n;
    }

    public int getCountOfNestedColumns(boolean bl) {
        int n = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (this.getData(16, i) == null) continue;
            if (bl) {
                if (!((Boolean)this.getData(0, i)).booleanValue()) continue;
                ++n;
                continue;
            }
            ++n;
        }
        return n;
    }

    public Vector getInEligibleTextSequenceAttributes(boolean bl) {
        Vector<String> vector = new Vector<String>(this.getRowCount());
        for (int i = 0; i < this.getRowCount(); ++i) {
            String string = (String)this.getData(2, i);
            Double d = (Double)this.getData(13, i);
            Integer n = (Integer)this.getData(10, i);
            Integer n2 = (Integer)this.getData(14, i);
            if (!string.equals("FLOAT") && !string.equals("NUMBER") || n == null || n2 == null || n.intValue() != n2.intValue()) continue;
            if (bl) {
                if (((Boolean)this.getData(0, i)).booleanValue()) continue;
                vector.add(Integer.toString(i));
                continue;
            }
            vector.add(Integer.toString(i));
        }
        return vector;
    }

    public int getActiveAttributeCountIncludingTargets() {
        int n = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!((Boolean)this.getData(0, i)).booleanValue()) continue;
            if (this.getData(16, i) != null) {
                Integer n2 = this.getNestedAttributeCount((String)this.getData(1, i));
                if (n2 == null) continue;
                n += n2.intValue();
                continue;
            }
            ++n;
        }
        return n;
    }

    public int getCountOfCategoricals(boolean bl) {
        int n = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            Integer n2;
            if (!((String)this.getData(3, i)).equals("categorical") || ((String)this.getData(5, i)).equals("target")) continue;
            int n3 = 1;
            if (((String)this.getData(2, i)).equals("DM_NESTED_CATEGORICALS") && (n2 = (Integer)this.getData(10, i)) != null) {
                n3 = n2;
            }
            if (bl) {
                if (!((Boolean)this.getData(0, i)).booleanValue()) continue;
                n += n3;
                continue;
            }
            n += n3;
        }
        return n;
    }

    public int getCountOfNumericals(boolean bl) {
        int n = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            Integer n2;
            if (!((String)this.getData(3, i)).equals("numerical") || ((String)this.getData(5, i)).equals("target")) continue;
            int n3 = 1;
            if (((String)this.getData(2, i)).equals("DM_NESTED_NUMERICALS") && (n2 = (Integer)this.getData(10, i)) != null) {
                n3 = n2;
            }
            if (bl) {
                if (!((Boolean)this.getData(0, i)).booleanValue()) continue;
                n += n3;
                continue;
            }
            n += n3;
        }
        return n;
    }

    public int getCountOfStringAttributes(boolean bl) {
        int n = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!((String)this.getData(2, i)).equals("VARCHAR2") && !((String)this.getData(2, i)).equals("CHAR")) continue;
            if (bl) {
                if (!((Boolean)this.getData(0, i)).booleanValue()) continue;
                ++n;
                continue;
            }
            ++n;
        }
        return n;
    }

    public int getCountOfFloatAttributes(boolean bl) {
        int n = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!((String)this.getData(2, i)).equals("FLOAT")) continue;
            if (bl) {
                if (!((Boolean)this.getData(0, i)).booleanValue()) continue;
                ++n;
                continue;
            }
            ++n;
        }
        return n;
    }

    public int getAttributeIndex(String string) {
        Integer n = (Integer)this.m_NameRow.get(string);
        return n == null ? -1 : n;
    }

    public String getAttributeDataType(String string) {
        String string2 = null;
        int n = this.getAttributeIndex(string);
        if (n >= 0) {
            string2 = (String)this.getData(2, n);
        }
        return string2;
    }

    protected void createDataFromODMModel() throws SQLException, Exception {
        this.createDataFromModel(this.m_miningModel);
    }

    protected void createDataFromModel(Model model) throws SQLException, Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Vector vector = new Vector();
        Hashtable hashtable = new Hashtable();
        Vector vector2 = new Vector();
        Hashtable hashtable2 = new Hashtable();
        java.sql.Connection connection = this.m_conn;
        int n = 0;
        if (model instanceof SupervisedModel) {
            object7 = null;
            object6 = (SupervisedModel)model;
            object7 = object6.getTargetAttributeName();
            if (object7 != null) {
                object5 = null;
                object4 = null;
                if (model instanceof ClassificationModel) {
                    object3 = (ClassificationModel)model;
                    object4 = object3.getTargetCategorySet().getDataType();
                    if (object4 == AttributeDataType.stringType) {
                        object5 = AttributeType.categorical;
                    } else if (object4 == AttributeDataType.doubleType || object4 == AttributeDataType.integerType) {
                        object5 = AttributeType.numerical;
                    }
                } else if (model instanceof RegressionModel) {
                    object4 = AttributeDataType.doubleType;
                    object5 = AttributeType.numerical;
                }
                this.addRows(n, 1);
                super.setData(1, n, object7);
                this.m_NameRow.put(object7, new Integer(n));
                object3 = this.translateDataType((AttributeDataType)object4);
                super.setData(2, n, object3);
                object2 = this.translateMiningType((AttributeType)object5);
                super.setData(3, n, object2);
                object = "target";
                super.setData(5, n, object);
                super.setData(7, n, object);
                super.setData(6, n, object2);
                super.setData(0, n, (Object)Boolean.TRUE);
                super.setData(8, n, (Object)Boolean.TRUE);
                super.setData(4, n, (Object)Boolean.TRUE);
                super.setData(9, n, (Object)Boolean.TRUE);
                ++n;
            }
        }
        object7 = model.getSignature();
        object6 = object7.getAttributes();
        object5 = object6.iterator();
        while (object5.hasNext()) {
            object4 = (SignatureAttribute)object5.next();
            object3 = object4.getName();
            object2 = object4.getAttributeType();
            object = object4.getDataType();
            this.addRows(n, 1);
            super.setData(1, n, object3);
            this.m_NameRow.put(object3, new Integer(n));
            String string = this.translateDataType((AttributeDataType)object);
            super.setData(2, n, (Object)string);
            String string2 = this.translateMiningType((AttributeType)object2);
            super.setData(3, n, (Object)string2);
            String string3 = "active";
            super.setData(5, n, (Object)string3);
            super.setData(7, n, (Object)string3);
            super.setData(6, n, (Object)string2);
            super.setData(0, n, (Object)Boolean.TRUE);
            super.setData(8, n, (Object)Boolean.TRUE);
            super.setData(4, n, (Object)Boolean.TRUE);
            super.setData(9, n, (Object)Boolean.TRUE);
            if (this.m_getStatistics) {
                this.addColumnNamesForStats(vector, hashtable, vector2, hashtable2, (String)object3, string, string2, n);
            }
            ++n;
        }
        if (this.getRowCount() > 0 || this.m_getStatistics) {
            object4 = this.getSamplingViewDefinition();
            this.addNumericStats(connection, vector, hashtable, (String)object4);
            this.addCategoricStats(connection, vector2, hashtable2, (String)object4);
            hashtable.clear();
            vector.clear();
        }
    }

    public Vector validateCompatibilityReturnsIntegerVector(LDSDataSource lDSDataSource) {
        this.sort(1, true);
        lDSDataSource.sort(1, true);
        Vector<Integer> vector = new Vector<Integer>();
        boolean bl = false;
        for (int i = 0; i < this.getRowCount(); ++i) {
            bl = false;
            for (int j = 0; j < lDSDataSource.getRowCount(); ++j) {
                if (!((String)this.getData(1, i)).equals((String)lDSDataSource.getData(1, j)) || !((String)this.getData(2, i)).equals((String)lDSDataSource.getData(2, j))) continue;
                bl = true;
                j = lDSDataSource.getRowCount();
            }
            if (bl) continue;
            vector.add(new Integer(i));
        }
        return vector;
    }

    public Vector validateCompatibility(LDSDataSource lDSDataSource, boolean bl) {
        int n;
        this.sort(1, true);
        lDSDataSource.sort(1, true);
        Vector<String> vector = new Vector<String>();
        boolean bl2 = false;
        for (n = 0; n < lDSDataSource.getRowCount(); ++n) {
            lDSDataSource.setData(0, n, Boolean.FALSE);
        }
        for (n = 0; n < this.getRowCount(); ++n) {
            bl2 = false;
            bl2 = ((Boolean)this.getData(0, n)).booleanValue() ? (((String)this.getData(5, n)).equals("target") ? (bl ? this.performDataToModelCompatiblityCheck(lDSDataSource, n) : true) : this.performDataToModelCompatiblityCheck(lDSDataSource, n)) : true;
            if (bl2) continue;
            vector.add((String)this.getData(1, n));
        }
        return vector;
    }

    private boolean performDataToModelCompatiblityCheck(LDSDataSource lDSDataSource, int n) {
        boolean bl = false;
        for (int i = 0; i < lDSDataSource.getRowCount(); ++i) {
            if (!((String)this.getData(1, n)).equals((String)lDSDataSource.getData(1, i))) continue;
            if ((((String)this.getData(2, n)).equals("FLOAT") || ((String)this.getData(2, n)).equals("NUMBER")) && (((String)lDSDataSource.getData(2, i)).equals("FLOAT") || ((String)lDSDataSource.getData(2, i)).equals("NUMBER"))) {
                bl = this.setDSRowsEqual(lDSDataSource, n, i, false);
                break;
            }
            if ((((String)this.getData(2, n)).equals("CHAR") || ((String)this.getData(2, n)).equals("VARCHAR2")) && (((String)lDSDataSource.getData(2, i)).equals("FLOAT") || ((String)lDSDataSource.getData(2, i)).equals("NUMBER"))) {
                bl = this.setDSRowsEqual(lDSDataSource, n, i, false);
                break;
            }
            if ((((String)this.getData(2, n)).equals("CHAR") || ((String)this.getData(2, n)).equals("VARCHAR2")) && (((String)lDSDataSource.getData(2, i)).equals("CHAR") || ((String)lDSDataSource.getData(2, i)).equals("VARCHAR2"))) {
                bl = this.setDSRowsEqual(lDSDataSource, n, i, false);
                break;
            }
            if (!((String)this.getData(2, n)).equals((String)lDSDataSource.getData(2, i))) continue;
            bl = this.setDSRowsEqual(lDSDataSource, n, i, false);
            break;
        }
        return bl;
    }

    public DiffLDSDataSource syncrhonizeForModelBuild(LDSDataSource lDSDataSource, String string, boolean bl) throws MissingTargetAttributeException, Exception {
        int n;
        int n2;
        int n3;
        DiffLDSDataSource diffLDSDataSource = new DiffLDSDataSource();
        this.sort(1, true);
        lDSDataSource.sort(1, true);
        if (string != null && (n3 = lDSDataSource.getFirstRowByColumnValue(1, string)) == -1) {
            throw new MissingTargetAttributeException();
        }
        n3 = 0;
        for (n2 = 0; n2 < this.getRowCount(); ++n2) {
            n3 = 0;
            for (n = 0; n < lDSDataSource.getRowCount(); ++n) {
                if (!((String)this.getData(1, n2)).equals((String)lDSDataSource.getData(1, n))) continue;
                String string2 = (String)this.getData(2, n2);
                if (string2 == null || string2.length() == 0) {
                    n3 = 1;
                    continue;
                }
                if ((((String)this.getData(2, n2)).equals("FLOAT") || ((String)this.getData(2, n2)).equals("NUMBER")) && (((String)lDSDataSource.getData(2, n)).equals("FLOAT") || ((String)lDSDataSource.getData(2, n)).equals("NUMBER"))) {
                    n3 = this.setDSRowsEqual(lDSDataSource, n2, n, true) ? 1 : 0;
                    n = lDSDataSource.getRowCount();
                    continue;
                }
                if ((((String)this.getData(2, n2)).equals("CHAR") || ((String)this.getData(2, n2)).equals("VARCHAR2")) && (((String)lDSDataSource.getData(2, n)).equals("CHAR") || ((String)lDSDataSource.getData(2, n)).equals("VARCHAR2"))) {
                    n3 = this.setDSRowsEqual(lDSDataSource, n2, n, true) ? 1 : 0;
                    n = lDSDataSource.getRowCount();
                    continue;
                }
                if (!((String)this.getData(2, n2)).equals((String)lDSDataSource.getData(2, n))) continue;
                n3 = this.setDSRowsEqual(lDSDataSource, n2, n, true) ? 1 : 0;
                n = lDSDataSource.getRowCount();
            }
            if (n3 != 0) continue;
            diffLDSDataSource.addRows(diffLDSDataSource.getRowCount(), 1);
            diffLDSDataSource.setData(0, diffLDSDataSource.getRowCount() - 1, this.getData(1, n2));
            diffLDSDataSource.setData(2, diffLDSDataSource.getRowCount() - 1, this.getData(3, n2));
            diffLDSDataSource.setData(1, diffLDSDataSource.getRowCount() - 1, this.getData(2, n2));
            diffLDSDataSource.setData(3, diffLDSDataSource.getRowCount() - 1, ResourceUtilities.getUILabel("SYNCRHONIZE_MB_DROPPED"));
        }
        if (!bl) {
            for (n = 0; n < lDSDataSource.getRowCount(); ++n) {
                n3 = 0;
                for (int i = 0; i < this.getRowCount(); ++i) {
                    if (!((String)lDSDataSource.getData(1, n)).equals((String)this.getData(1, i)) || !((String)lDSDataSource.getData(2, n)).equals((String)this.getData(2, i))) continue;
                    n3 = 1;
                }
                if (n3 != 0) continue;
                diffLDSDataSource.addRows(diffLDSDataSource.getRowCount(), 1);
                diffLDSDataSource.setData(0, diffLDSDataSource.getRowCount() - 1, lDSDataSource.getData(1, n));
                diffLDSDataSource.setData(2, diffLDSDataSource.getRowCount() - 1, lDSDataSource.getData(3, n));
                diffLDSDataSource.setData(1, diffLDSDataSource.getRowCount() - 1, lDSDataSource.getData(2, n));
                diffLDSDataSource.setData(3, diffLDSDataSource.getRowCount() - 1, ResourceUtilities.getUILabel("SYNCRHONIZE_MB_ADDED"));
                n2 = lDSDataSource.getAttributeIndex((String)lDSDataSource.getData(1, n));
                lDSDataSource.setData(0, n2, Boolean.FALSE);
            }
        }
        if (diffLDSDataSource.getRowCount() > 0) {
            diffLDSDataSource.sort(1, true);
        }
        return diffLDSDataSource;
    }

    private boolean setDSRowsEqual(LDSDataSource lDSDataSource, int n, int n2, boolean bl) {
        boolean bl2 = true;
        lDSDataSource.setData(0, n2, this.getData(0, n));
        lDSDataSource.setData(3, n2, this.getData(3, n));
        lDSDataSource.setData(6, n2, this.getData(6, n));
        if (bl) {
            lDSDataSource.setData(5, n2, this.getData(5, n));
            lDSDataSource.setData(7, n2, this.getData(7, n));
            lDSDataSource.setData(4, n2, this.getData(4, n));
            lDSDataSource.setData(9, n2, this.getData(9, n));
        }
        return bl2;
    }

    public String getTargetAttributeName() {
        String string = "";
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.getData(5, i).equals("target")) continue;
            string = (String)this.getData(1, i);
            i = this.getRowCount();
        }
        return string;
    }

    public String getCaseIdAttributeName() {
        String string = "";
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.getData(5, i).equals("caseId")) continue;
            string = (String)this.getData(1, i);
            i = this.getRowCount();
        }
        return string;
    }

    public String getDefaultTextAttributeName() {
        String string = "";
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.getData(3, i).equals("text") || !((Boolean)this.getData(8, i)).booleanValue()) continue;
            string = (String)this.getData(1, i);
            break;
        }
        return string;
    }

    public String getSelectedTextAttributeName() {
        String string = "";
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.getData(3, i).equals("text") || !((Boolean)this.getData(0, i)).booleanValue()) continue;
            string = (String)this.getData(1, i);
            break;
        }
        return string;
    }

    public String getTargetAttributeDataType() {
        String string = "";
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.getData(5, i).equals("target")) continue;
            string = (String)this.getData(2, i);
            i = this.getRowCount();
        }
        return string;
    }

    public String getTargetAttributeMiningType() {
        String string = "";
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.getData(5, i).equals("target")) continue;
            string = (String)this.getData(3, i);
            i = this.getRowCount();
        }
        return string;
    }

    protected boolean isTextDataType(String string) {
        return string.compareTo("BFILE") == 0 || string.compareTo("BLOB") == 0 || string.compareTo("CLOB") == 0 || string.compareTo("CHAR") == 0 || string.compareTo("VARCHAR2") == 0 || string.compareTo("URITYPE") == 0 || string.compareTo("BLOB") == 0;
    }

    protected boolean isTextDataType(String string, java.sql.Connection connection, String string2, String string3, String string4) throws SQLException, Exception {
        if (!this.m_acceptsTextData) {
            return false;
        }
        if (!this.isTextDataType(string)) {
            return false;
        }
        return ValidationUtil.doesColumnHaveContextIndex(connection, string2, string3, string4);
    }

    protected void addColumnNamesForStats(Vector vector, Hashtable hashtable, Vector vector2, Hashtable hashtable2, String string, String string2, String string3, int n) {
        if (string2.equals("FLOAT") || string2.equals("NUMBER") || string2.equals("DM_NESTED_NUMERICALS")) {
            if (string3.equals("categorical")) {
                vector2.add(string);
                hashtable2.put(string, new Integer(n));
            } else if (string3.equals("numerical")) {
                vector.add(string);
                hashtable.put(string, new Integer(n));
            }
        } else if ((string2.equals("CHAR") || string2.equals("VARCHAR2") || string2.equals("DM_NESTED_CATEGORICALS")) && string3.equals("categorical")) {
            vector2.add(string);
            hashtable2.put(string, new Integer(n));
        }
    }

    public String getSamplingViewDefinition() {
        String string;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        Vector<String> vector = new Vector<String>();
        for (n = 0; n < this.m_allAttributes.size(); ++n) {
            string = (String)this.m_allAttributes.elementAt(n);
            if (null != this.getComplexAttributeInfo(string)) continue;
            vector.add(string);
        }
        for (n = 0; n < vector.size(); ++n) {
            stringBuffer.append("\"" + vector.elementAt(n) + "\"");
            if (n >= vector.size() - 1) continue;
            stringBuffer.append(",");
        }
        Object[] objectArray = null;
        string = null;
        if (this.m_caseCount == -1) {
            objectArray = new Object[]{stringBuffer.toString(), this.m_dataLocation, String.valueOf(this.m_preferences.getSampleSize())};
            string = MessageFormat.format(SQL_SAMPLING_VIEW, objectArray);
        } else {
            objectArray = new Object[]{stringBuffer.toString(), this.m_dataLocation, String.valueOf(this.m_preferences.getSampleSize()), String.valueOf(this.m_caseCount)};
            string = MessageFormat.format(SQL_SAMPLING_VIEW_KNOWN_COUNT, objectArray);
        }
        return string;
    }

    protected String getSamplingTXNViewDefinition() {
        return this.m_dataLocation;
    }

    protected int getSampleSize() {
        return this.m_preferences.getSampleSize();
    }

    protected float getUniquePercentage() {
        return this.m_preferences.getUniquePercentage();
    }

    protected int getNumberCutoffForCategorical() {
        return this.m_preferences.getCutoffForNumberForCategorical();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCategoricStats(java.sql.Connection connection, Vector vector, Hashtable hashtable, String string) {
        if (vector == null || vector.isEmpty()) {
            return;
        }
        int n = vector.size() / 1000 + 1;
        String string2 = "count(distinct {0}) as COUNT{1}, round((sum(nvl2({0},0,1))/Count(*))*100,3) as MISSING{1}";
        for (int i = 0; i < n; ++i) {
            Object object;
            int n2 = Math.min(vector.size(), 1000 * (i + 1));
            int n3 = 1000 * i;
            StringBuffer stringBuffer = new StringBuffer("SELECT Count(*) as TOTAL,");
            for (int j = n3; j < n2; ++j) {
                object = (String)vector.elementAt(j);
                int n4 = this.getAttributeIndex((String)object);
                String string3 = "\"" + (String)object + "\"";
                String string4 = MessageFormat.format(string2, string3, String.valueOf(j));
                if (j > n3) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(string4);
            }
            String string5 = MessageFormat.format(" from ({0})", string == null ? this.m_dataLocation : string);
            stringBuffer.append(string5);
            object = null;
            ResultSet resultSet = null;
            try {
                object = connection.createStatement();
                resultSet = object.executeQuery(stringBuffer.toString());
                int n5 = 0;
                int n6 = 0;
                boolean bl = false;
                boolean bl2 = false;
                if (!resultSet.next()) continue;
                for (int j = n3; j < n2; ++j) {
                    String string6 = String.valueOf(j);
                    String string7 = (String)vector.elementAt(j);
                    Integer n7 = (Integer)hashtable.get(string7);
                    if (n7 == null) continue;
                    int n8 = this.getAttributeIndex(string7);
                    n6 = resultSet.getInt("TOTAL");
                    super.setData(14, n7.intValue(), (Object)new Integer(n6));
                    n5 = resultSet.getInt("COUNT" + string6);
                    super.setData(10, n7.intValue(), (Object)new Integer(n5));
                    Float f = new Float(resultSet.getFloat("MISSING" + string6));
                    super.setData(11, n7.intValue(), (Object)f);
                    bl2 = false;
                    Boolean bl3 = Boolean.FALSE;
                    if (n5 == n6 && n6 == this.getSampleSize() && this.m_FormatIsTransactional || n5 == n6 && !this.m_FormatIsTransactional) {
                        bl3 = new Boolean(n5 == n6);
                    }
                    super.setData(15, n7.intValue(), (Object)bl3);
                    if (!this.m_adjustDataUsage || !bl2 || this.m_loadFromODM) continue;
                    super.setData(0, n7.intValue(), (Object)Boolean.FALSE);
                    super.setData(8, n7.intValue(), (Object)Boolean.FALSE);
                    super.setData(5, n7.intValue(), (Object)"inactive");
                    super.setData(7, n7.intValue(), (Object)"inactive");
                }
                continue;
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                continue;
            }
            finally {
                try {
                    resultSet.close();
                    object.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNumericStats(java.sql.Connection connection, Vector vector, Hashtable hashtable, String string) {
        if (vector == null || vector.isEmpty()) {
            return;
        }
        int n = vector.size() / 1000 + 1;
        String string2 = "\n\tcount(distinct {0}) as COUNT{1}, round((sum(nvl2({0},0,1))/Count(*))*100,3) as MISSING{1}, sum((abs({0})) - (floor({0}))) as FLOAT_IND{1}, min({0}) as MIN{1}";
        for (int i = 0; i < n; ++i) {
            String string3;
            Object object;
            int n2 = Math.min(vector.size(), 1000 * (i + 1));
            int n3 = 1000 * i;
            StringBuffer stringBuffer = new StringBuffer("SELECT Count(*) as TOTAL, ");
            for (int j = n3; j < n2; ++j) {
                object = (String)vector.elementAt(j);
                int n4 = this.getAttributeIndex((String)object);
                String string4 = "\"" + (String)object + "\"";
                string3 = MessageFormat.format(string2, string4, String.valueOf(j));
                if (j > n3) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(string3);
            }
            String string5 = MessageFormat.format(" from ({0}) ", string == null ? this.m_dataLocation : string);
            stringBuffer.append(string5);
            object = null;
            ResultSet resultSet = null;
            try {
                object = connection.createStatement();
                resultSet = object.executeQuery(stringBuffer.toString());
                if (!resultSet.next()) continue;
                for (int j = n3; j < n2; ++j) {
                    string3 = String.valueOf(j);
                    String string6 = (String)vector.elementAt(j);
                    Integer n5 = (Integer)hashtable.get(string6);
                    if (n5 == null) continue;
                    this.adjustNumericStats(resultSet, n5, string3);
                }
                continue;
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                continue;
            }
            finally {
                try {
                    resultSet.close();
                    object.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNumericStatsTX(java.sql.Connection connection, Hashtable hashtable, String string) {
        String string2 = "SELECT {0} NAME, count ({1}) as TOTAL, count(distinct {1}) as COUNT, round((sum(nvl2({1},0,1))/count ({1}))*100,3) as MISSING, sum((abs({1})) - (floor({1}))) as FLOAT_IND, min({1}) as MIN from {2} WHERE {1} IS NOT NULL group by {0}";
        String string3 = MessageFormat.format(string2, "\"" + this.m_attribute_column_name + "\"", "\"" + this.m_value_column_name + "\"", string == null ? this.m_dataLocation : string);
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                String string4 = resultSet.getString("NAME");
                Integer n = (Integer)hashtable.get(string4);
                if (n == null) continue;
                this.adjustNumericStats(resultSet, n, null);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    protected void adjustNumericStats(ResultSet resultSet, Integer n, String string) throws SQLException {
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        Object var6_6 = null;
        String string2 = null;
        String string3 = string != null ? string : "";
        int n2 = resultSet.getInt("TOTAL");
        super.setData(14, n.intValue(), (Object)new Integer(n2));
        int n3 = resultSet.getInt("COUNT" + string3);
        String string4 = (String)this.getData(1, n);
        if (this.getData(16, n) != null) {
            int n4 = resultSet.getInt("COUNT2" + string3);
            this.m_nestedAttributeCount.put(string4, new Integer(n4));
        }
        double d = resultSet.getDouble("MIN" + string3);
        super.setData(10, n.intValue(), (Object)new Integer(n3));
        super.setData(13, n.intValue(), (Object)new Double(d));
        float f = n3;
        float f2 = n2;
        double d2 = resultSet.getDouble("FLOAT_IND" + string3);
        Float f3 = new Float(resultSet.getFloat("MISSING" + string3));
        super.setData(11, n.intValue(), (Object)f3);
        if (this.m_adjustDataUsage && bl2 && !this.m_loadFromODM) {
            super.setData(0, n.intValue(), (Object)Boolean.FALSE);
            super.setData(8, n.intValue(), (Object)Boolean.FALSE);
            super.setData(5, n.intValue(), (Object)"inactive");
            super.setData(7, n.intValue(), (Object)"inactive");
        }
        if (d2 != 0.0) {
            bl = true;
            string2 = "numerical";
        } else {
            bl = false;
            object = (String)this.getData(2, n);
            string2 = ((String)object).equals("DM_NESTED_NUMERICALS") ? "numerical" : (n3 <= this.getNumberCutoffForCategorical() && !this.m_bOverRideEuristics ? "categorical" : "numerical");
        }
        super.setData(12, n.intValue(), (Object)new Boolean(bl));
        if (this.m_adjustDataUsage && !this.m_loadFromODM) {
            super.setData(3, n.intValue(), (Object)string2);
            super.setData(6, n.intValue(), (Object)string2);
        }
        object = Boolean.FALSE;
        if (string2 == "numerical" && (n3 == n2 && !bl && n2 == this.getSampleSize() && this.m_FormatIsTransactional || n3 == n2 && !bl && !this.m_FormatIsTransactional)) {
            object = Boolean.TRUE;
        }
        super.setData(15, n.intValue(), object);
    }

    public void setAttributesToIncludeOrExclude(boolean bl, String[] stringArray) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = 0; j < stringArray.length; ++j) {
                if (!this.getData(2, i).equals(stringArray[j])) continue;
                this.setData(0, i, new Boolean(bl));
            }
        }
    }

    public void setAttributesMiningType(String string, String[] stringArray) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = 0; j < stringArray.length; ++j) {
                if (!this.getData(2, i).equals(stringArray[j])) continue;
                this.setData(3, i, string);
            }
        }
    }

    public boolean areAttributesExceedingMinValue(int n, StringBuffer stringBuffer) {
        boolean bl = false;
        for (int i = 0; i < this.getRowCount(); ++i) {
            Double d;
            if (this.getData(5, i).equals("target") || !((Boolean)this.getData(0, i)).booleanValue() || !((String)this.getData(2, i)).equals("NUMBER") && !((String)this.getData(2, i)).equals("FLOAT") && !((String)this.getData(2, i)).equals("DM_NESTED_NUMERICALS") || (d = (Double)this.getData(13, i)) == null || d.intValue() >= n) continue;
            bl = true;
            stringBuffer.append((String)this.getData(1, i));
            break;
        }
        return bl;
    }

    public boolean areAttributesExceedingBinLimits(int n, int n2) {
        boolean bl = false;
        Integer n3 = new Integer(0);
        ++n;
        ++n2;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (this.getData(5, i).equals("target") || !((Boolean)this.getData(0, i)).booleanValue()) continue;
            if (((String)this.getData(3, i)).equals("numerical")) {
                n3 = (Integer)this.getData(10, i);
                if (n3 == null || n3 <= n2) continue;
                bl = true;
                break;
            }
            if (!((String)this.getData(3, i)).equals("categorical") || (n3 = (Integer)this.getData(10, i)) == null || n3 <= n) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void sort(int n, boolean bl) {
        super.sort(n, bl);
        this.m_NameRow.clear();
        for (int i = 0; i < this.getRowCount(); ++i) {
            String string = (String)this.getData(1, i);
            this.m_NameRow.put(string, new Integer(i));
        }
    }

    protected String translateMiningType(AttributeType attributeType) {
        String string = "";
        if (attributeType == AttributeType.categorical) {
            string = "categorical";
        } else if (attributeType == AttributeType.numerical) {
            string = "numerical";
        } else if (attributeType == AttributeType.notSpecified) {
            string = "notApplicable";
        }
        return string;
    }

    protected String translateDataType(AttributeDataType attributeDataType) {
        String string = "";
        if (attributeDataType == AttributeDataType.doubleType) {
            string = "NUMBER";
        } else if (attributeDataType == AttributeDataType.integerType) {
            string = "NUMBER";
        } else if (attributeDataType == AttributeDataType.stringType) {
            string = "VARCHAR2";
        }
        return string;
    }

    public String getComplexAttributeInfo(String string) {
        String string2 = null;
        int n = this.getAttributeIndex(string);
        if (n >= 0) {
            string2 = (String)this.getData(16, n);
        }
        return string2;
    }

    public void setAdjustDataUsage(boolean bl) {
        this.m_adjustDataUsage = bl;
    }

    public boolean isSingleMetric() {
        return this.m_bSingleMetric;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAllStats(java.sql.Connection connection, Vector vector, Vector vector2, Hashtable hashtable, Hashtable hashtable2, String string) {
        String string2;
        Object object;
        Object object2;
        int n;
        if ((vector == null || vector.isEmpty()) && (vector2 == null || vector2.isEmpty())) {
            return;
        }
        String string3 = "count(distinct {0}) as COUNT{1}, round((sum(nvl2({0},0,1))/Count(*))*100,3) as MISSING{1}, sum((abs({0})) - (floor({0}))) as FLOAT_IND{1}, min({0}) as MIN{1}";
        String string4 = "count(distinct {0}) as COUNT{1}, round((sum(nvl2({0},0,1))/Count(*))*100,3) as MISSING{1}";
        Vector<String> vector3 = new Vector<String>();
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer("SELECT Count(*) as TOTAL,\n");
        for (n = 0; n < vector.size(); ++n) {
            object2 = (String)vector.elementAt(n);
            vector3.add((String)object2);
            object = "\"" + (String)object2 + "\"";
            string2 = MessageFormat.format(string3, object, String.valueOf(n2++));
            stringBuffer.append(string2);
            if (n >= vector.size() - 1) continue;
            stringBuffer.append(",\n");
        }
        if (!vector.isEmpty() && !vector2.isEmpty()) {
            stringBuffer.append(",\n");
        }
        for (n = 0; n < vector2.size(); ++n) {
            object2 = (String)vector2.elementAt(n);
            vector3.add((String)object2);
            object = "\"" + (String)object2 + "\"";
            string2 = MessageFormat.format(string4, object, String.valueOf(n2++));
            stringBuffer.append(string2);
            if (n >= vector2.size() - 1) continue;
            stringBuffer.append(",\n");
        }
        String string5 = MessageFormat.format("\nfrom ({0}) ", string == null ? this.m_dataLocation : string);
        stringBuffer.append(string5);
        object2 = null;
        object = null;
        try {
            object2 = connection.createStatement();
            object = object2.executeQuery(stringBuffer.toString());
            if (object.next()) {
                for (int i = 0; i < vector3.size(); ++i) {
                    String string6 = (String)vector3.elementAt(i);
                    boolean bl = false;
                    Integer n3 = (Integer)hashtable.get(string6);
                    if (n3 == null) {
                        n3 = (Integer)hashtable2.get(string6);
                        if (n3 == null) {
                            continue;
                        }
                    } else {
                        bl = true;
                    }
                    String string7 = String.valueOf(i);
                    if (bl) {
                        this.adjustNumericStats((ResultSet)object, n3, String.valueOf(i));
                        continue;
                    }
                    int n4 = 0;
                    int n5 = 0;
                    boolean bl2 = false;
                    n5 = object.getInt("TOTAL");
                    super.setData(14, n3.intValue(), (Object)new Integer(n5));
                    n4 = object.getInt("COUNT" + string7);
                    super.setData(10, n3.intValue(), (Object)new Integer(n4));
                    Float f = new Float(object.getFloat("MISSING" + string7));
                    super.setData(11, n3.intValue(), (Object)f);
                    bl2 = false;
                    Boolean bl3 = Boolean.FALSE;
                    if (n4 == n5 && n5 == this.getSampleSize() && this.m_FormatIsTransactional || n4 == n5 && !this.m_FormatIsTransactional) {
                        bl3 = new Boolean(n4 == n5);
                    }
                    super.setData(15, n3.intValue(), (Object)bl3);
                    if (!this.m_adjustDataUsage || !bl2 || this.m_loadFromODM) continue;
                    super.setData(0, n3.intValue(), (Object)Boolean.FALSE);
                    super.setData(8, n3.intValue(), (Object)Boolean.FALSE);
                    super.setData(5, n3.intValue(), (Object)"inactive");
                    super.setData(7, n3.intValue(), (Object)"inactive");
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                object.close();
                object2.close();
            }
            catch (Exception exception) {}
        }
    }
}

