/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.EventListener;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.OneDModelEvent;
import oracle.bali.ewt.model.OneDModelListener;
import oracle.bali.share.event.ListenerManager;

public class JDBCModel
extends ArrayTwoDModel
implements OneDModel {
    private Connection _connection;
    private ResultSet _results;
    private ResultSetMetaData _metaData;
    private ListenerManager _oneDListenerManager;

    public JDBCModel() {
        super(0, 0);
    }

    public void setConnection(Connection connection) {
        this._connection = connection;
    }

    public void executeQuery(String string) throws SQLException {
        if (this._connection == null) {
            throw new NullPointerException("Must call setConnection first.");
        }
        PreparedStatement preparedStatement = this._connection.prepareStatement(string);
        ResultSet resultSet = preparedStatement.executeQuery();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        if (this.getColumnCount() > 0) {
            this.removeColumns(0, this.getColumnCount());
        }
        if (this.getRowCount() > 0) {
            this.removeRows(0, this.getRowCount());
        }
        this._results = resultSet;
        this._metaData = resultSetMetaData;
        this._updateData();
        try {
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            System.out.println("JDBCModel: Couldn't close statement.");
        }
    }

    public ResultSetMetaData getMetaData() {
        return this._metaData;
    }

    public int getItemCount() {
        return this.getColumnCount();
    }

    public Object getData(int n) {
        String string;
        if (this._metaData == null) {
            return null;
        }
        try {
            string = this._metaData.getColumnLabel(n + 1);
        }
        catch (SQLException sQLException) {
            return null;
        }
        return string;
    }

    public void setData(int n, Object object) {
        throw new RuntimeException("setData not allowed yet.");
    }

    public void addModelListener(OneDModelListener oneDModelListener) {
        if (this._oneDListenerManager == null) {
            this._oneDListenerManager = new ListenerManager();
        }
        this._oneDListenerManager.addListener((EventListener)oneDModelListener);
    }

    public void removeModelListener(OneDModelListener oneDModelListener) {
        if (this._oneDListenerManager != null) {
            this._oneDListenerManager.removeListener((EventListener)oneDModelListener);
        }
    }

    public void addColumns(int n, int n2) {
        super.addColumns(n, n2);
        this._addColumns(n, n2);
    }

    public void removeColumns(int n, int n2) {
        if (n2 > 0) {
            super.removeColumns(n, n2);
            this._removeColumns(n, n2);
        }
    }

    public void setData(int n, int n2, Object object) {
        throw new RuntimeException("setData not supported.");
    }

    private void _addColumns(int n, int n2) {
        if (this._oneDListenerManager == null) {
            return;
        }
        Enumeration enumeration = this._oneDListenerManager.getListeners();
        if (enumeration == null) {
            return;
        }
        OneDModelEvent oneDModelEvent = new OneDModelEvent((Object)this, 2001, n, n2);
        while (enumeration.hasMoreElements()) {
            OneDModelListener oneDModelListener = (OneDModelListener)enumeration.nextElement();
            oneDModelListener.itemsAdded(oneDModelEvent);
        }
    }

    private void _removeColumns(int n, int n2) {
        if (this._oneDListenerManager == null) {
            return;
        }
        Enumeration enumeration = this._oneDListenerManager.getListeners();
        if (enumeration == null) {
            return;
        }
        OneDModelEvent oneDModelEvent = new OneDModelEvent((Object)this, 2002, n, n2);
        while (enumeration.hasMoreElements()) {
            OneDModelListener oneDModelListener = (OneDModelListener)enumeration.nextElement();
            oneDModelListener.itemsRemoved(oneDModelEvent);
        }
    }

    private void _updateData() throws SQLException {
        int n = this._getColumnCount();
        int n2 = 0;
        Object object = null;
        this.addColumns(0, n);
        while (this._results.next()) {
            this.addRows(n2, 1);
            for (int i = 0; i < n; ++i) {
                try {
                    object = this._getColumnData(i + 1);
                }
                catch (SQLException sQLException) {
                    object = null;
                }
                super.setData(i, n2, object);
            }
            ++n2;
        }
    }

    private Object _getColumnData(int n) throws SQLException {
        Object object;
        int n2 = this._getType(n);
        switch (n2) {
            case 91: {
                object = this._results.getDate(n);
                break;
            }
            case 93: {
                object = this._results.getTimestamp(n);
                break;
            }
            case 92: {
                object = this._results.getTime(n);
                break;
            }
            case -7: {
                object = this._results.getBoolean(n) ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            default: {
                object = this._results.getString(n);
            }
        }
        return object;
    }

    private int _getType(int n) {
        int n2;
        try {
            n2 = this._metaData.getColumnType(n);
        }
        catch (SQLException sQLException) {
            return 12;
        }
        return n2;
    }

    private int _getColumnCount() {
        int n;
        try {
            n = this._metaData.getColumnCount();
        }
        catch (SQLException sQLException) {
            System.out.println("JDBCModel: Error getting column count.");
            return 0;
        }
        return n;
    }
}

