/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Vector;
import javax.datamining.JDMException;
import javax.datamining.resource.Connection;
import javax.swing.JOptionPane;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.datasources.DM4JDataSource;
import oracle.dmt.dm4j.wizard.director.minings.FeatureExtractionModelApplyBuilder;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;

public class FeatureIdSource
extends DM4JDataSource {
    private Vector m_selectedFeatures = null;
    private HashMap m_featurePredictionColumns = null;
    protected static final int COLUMN_COUNT = 3;
    public static final int INCLUDE = 0;
    public static final int FEATURE_ID = 1;
    public static final int FEATURE_PREDICTION = 2;

    public FeatureIdSource(Connection connection, String string) {
        super(connection, string);
    }

    public FeatureIdSource(Connection connection, String string, HashMap hashMap, Vector vector) {
        super(connection, string);
        this.m_featurePredictionColumns = hashMap;
        this.m_selectedFeatures = vector;
    }

    protected void createData() throws SQLException, JDMException {
        this.createDataFromDB();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createDataFromDB() throws SQLException, JDMException {
        java.sql.Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        int n = 1000;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            statement = connection.createStatement();
            statement.setFetchSize(n);
            String string = "select distinct feature_id from \"DM$PZ<model_name>\" order by feature_id";
            if (this.m_odmObjectName != null) {
                string = BrowserUtils.getReplacedString(string, "<model_name>", this.m_odmObjectName);
            }
            resultSet = statement.executeQuery(string);
            boolean bl = false;
            if (this.m_featurePredictionColumns != null && this.m_featurePredictionColumns.size() > 0) {
                bl = true;
            }
            int n2 = 0;
            while (resultSet.next()) {
                String string2 = resultSet.getString("feature_id");
                this.addRows(n2, 1);
                Integer n3 = new Integer(string2);
                this.setData(1, n2, n3);
                String string3 = null;
                string3 = bl ? (String)this.m_featurePredictionColumns.get(n3) : ((Object)n3).toString();
                this.setData(2, n2, string3);
                boolean bl2 = false;
                if (this.m_selectedFeatures != null) {
                    bl2 = this.m_selectedFeatures.contains(n3);
                }
                this.setData(0, n2, bl2 ? Boolean.TRUE : Boolean.FALSE);
                ++n2;
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    protected ArrayOneDModel createColumns() throws Exception {
        this.addColumns(0, 3);
        Object[] objectArray = new String[]{ResourceUtilities.getUILabel("DATA_USAGE_INCLUDE"), ResourceUtilities.getUILabel("FEATURE_ID"), ResourceUtilities.getUILabel("TARGET_PREDICTION_COLUMN")};
        return new ArrayOneDModel(objectArray);
    }

    public int getIncludedCount() {
        int n = 0;
        Boolean bl = new Boolean(false);
        for (int i = 0; i < this.getRowCount(); ++i) {
            bl = (Boolean)this.getData(0, i);
            if (!bl.booleanValue()) continue;
            ++n;
        }
        return n;
    }

    public Vector getIncludedFeatureIDs(boolean bl) {
        Vector<Object> vector = new Vector<Object>(this.getRowCount());
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (bl) {
                Boolean bl2 = (Boolean)this.getData(0, i);
                if (!bl2.booleanValue()) continue;
                vector.add(this.getData(1, i));
                continue;
            }
            vector.add(this.getData(1, i));
        }
        return vector;
    }

    public int getAttributeIndex(String string) {
        int n = -1;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!((String)this.getData(2, i)).equals(string)) continue;
            n = i;
            break;
        }
        return n;
    }

    public HashMap getFeaturePredictionColumns(boolean bl) {
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            Object object = this.getData(1, i);
            String string = (String)this.getData(2, i);
            if (bl) {
                Boolean bl2 = (Boolean)this.getData(0, i);
                if (!bl2.booleanValue()) continue;
                hashMap.put(object, string);
                continue;
            }
            hashMap.put(object, string);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateBaseColumnName(String string) {
        int n = 0;
        n = Math.max(30 - (new String(FeatureExtractionModelApplyBuilder.FEATURE_ID_COLUMN_NAME).length() + 1), n);
        n = Math.max(30 - (new String(FeatureExtractionModelApplyBuilder.MATCH_QUALITY_COLUMN_NAME).length() + 1), n);
        String string2 = null;
        if (string == null) {
            String string3 = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            Object[] objectArray = new Object[]{ResourceUtilities.getUILabel("COLUMN_NAME_ONLY")};
            string2 = MessageFormat.format(string3, objectArray);
        } else {
            boolean bl = DM4JStringUtils.isDoubleQuotedString(string);
            if (bl) {
                string = DM4JStringUtils.trimDoubleQuotes(string);
            }
            if (!ValidationUtil.checkStringLength(string, n)) {
                String string4 = ResourceUtilities.getstateExceptionMessage("FIELD_LENGTH_EXCEEDED");
                Object[] objectArray = new Object[]{ResourceUtilities.getUILabel("COLUMN_NAME_ONLY"), Integer.toString(n)};
                string2 = MessageFormat.format(string4, objectArray);
            } else {
                java.sql.Connection connection = null;
                try {
                    connection = DM4JConnectionManager.getDbConnection();
                    if (!ValidationUtil.checkStringDBLengthMax(string, connection, n)) {
                        String string5 = ResourceUtilities.getstateExceptionMessage("APPLY_OUTPUT_COLUMN_NAME_MAX_BTYES_EXCEEDED");
                        Object[] objectArray = new Object[]{Integer.toString(n)};
                        string2 = MessageFormat.format(string5, objectArray);
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
        if (string2 != null) {
            JOptionPane.showOptionDialog(BrowserFrame.getMainFrame(), string2, DM4JVersion.getFullBrowserName(), -1, 0, null, null, null);
            return false;
        }
        return true;
    }

    public String setFeaturePredictionAtIndex(int n, String string) {
        int n2 = this.getAttributeIndex(string);
        if (n2 >= 0 && n >= 0 && n != n2) {
            String string2 = ResourceUtilities.getstateExceptionMessage("OUTPUT_COLUMN_DUPLICATE_NAME");
            JOptionPane.showOptionDialog(BrowserFrame.getMainFrame(), string2, DM4JVersion.getFullBrowserName(), -1, 0, null, null, null);
            String string3 = (String)this.getData(2, n);
            return string3;
        }
        if (!this.validateBaseColumnName(string)) {
            String string4 = (String)this.getData(2, n);
            return string4;
        }
        return string;
    }
}

