/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Vector;
import oracle.bali.ewt.model.SortableTwoDModel;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.datasources.DiscretizationLDSDataSource;
import oracle.dmt.dm4j.datasources.DiscretizeDataSource;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.odm.binning.BinningType;
import oracle.dmt.odm.binning.DM4JTransformation;

class ExtraDataSource
extends SortableTwoDModel {
    private static String NUMERIC_BIN_TABLE_PREFIX = "DM4J$N";
    private static String CATEGORIC_BIN_TABLE_PREFIX = "DM4J$C";
    private static int A = 0;
    protected static int COLUMN_COUNT = COLUMN_NAMES.LAST;
    protected static String[] items = new String[COLUMN_COUNT];
    static int STAT_TOTAL;
    static int STAT_AVERAGE;
    static int STAT_MAX;
    static int STAT_MIN;
    static int STAT_VARIANCE;
    static int STAT_STDEV;
    static int STAT_SKEW;
    static int STAT_KURT;
    static int NUMBER_STATS;
    protected String m_attributeMapping;
    protected String m_valueMapping;
    protected String m_seqIdMapping;
    protected boolean m_isTransactional = false;
    protected boolean m_bSingleMetric = false;
    protected Hashtable m_AttributeNameValueMap;
    protected String m_numericalDiscretizationTableName = null;
    protected String m_categoricalDiscretizationTableName = null;
    private String m_userSchemaName = null;
    private StringBuffer m_txSampledViewDefinition;
    protected Hashtable m_NameRow = new Hashtable();
    private String m_sampled2DData;
    private String m_sampledTXData;
    protected DiscretizationLDSDataSource m_parent = null;

    StringBuffer getSampledTXViewDefinition() {
        return this.m_txSampledViewDefinition;
    }

    String getNumericBinBoundatyTableName() {
        return this.m_numericalDiscretizationTableName;
    }

    String getUserSchemaName() {
        return this.m_userSchemaName;
    }

    String getCategoricBinBoundatyTableName() {
        return this.m_categoricalDiscretizationTableName;
    }

    boolean isTX() {
        return this.m_isTransactional;
    }

    ExtraDataSource(Connection connection, String string, String string2, String string3, String string4, String string5) {
        this(COLUMN_COUNT, 1);
        this.m_sampledTXData = string2;
        this.m_isTransactional = true;
        this.m_attributeMapping = string3;
        this.m_valueMapping = string4;
        this.m_seqIdMapping = string5;
        this.m_userSchemaName = string;
        try {
            this.m_numericalDiscretizationTableName = ValidationUtil.createUniqueTableName(NUMERIC_BIN_TABLE_PREFIX, connection, "");
            this.m_categoricalDiscretizationTableName = ValidationUtil.createUniqueTableName(CATEGORIC_BIN_TABLE_PREFIX, connection, "");
            DM4JTransformation.createPhysicalTables(connection, this.m_numericalDiscretizationTableName, this.m_categoricalDiscretizationTableName, this.m_userSchemaName);
            this.m_txSampledViewDefinition = this.createTXViewDefinition(string2);
        }
        catch (Exception exception) {
            String string6 = String.valueOf(Math.random());
            this.m_numericalDiscretizationTableName = NUMERIC_BIN_TABLE_PREFIX + string6;
            this.m_categoricalDiscretizationTableName = NUMERIC_BIN_TABLE_PREFIX + string6;
        }
    }

    protected ExtraDataSource(String string) {
        this(COLUMN_COUNT, 1);
        this.m_sampled2DData = string;
        this.m_isTransactional = false;
        this.m_bSingleMetric = false;
    }

    protected ExtraDataSource(String string, Hashtable hashtable, boolean bl) {
        this(COLUMN_COUNT, 1);
        this.m_sampled2DData = string;
        this.m_isTransactional = false;
        this.m_bSingleMetric = bl;
        this.m_AttributeNameValueMap = hashtable;
    }

    protected ExtraDataSource(int n, int n2) {
        super(n, n2);
    }

    void populateTable(DiscretizationLDSDataSource discretizationLDSDataSource) {
        block3: {
            try {
                this.m_parent = discretizationLDSDataSource;
                for (int i = 0; i < discretizationLDSDataSource.getRowCount(); ++i) {
                    String string = discretizationLDSDataSource.getAttributeName(i);
                    this.addRows(i, 1);
                    this.setData(COLUMN_NAMES.NAME, i, string);
                    this.m_NameRow.put(string, new Integer(i));
                }
            }
            catch (Exception exception) {
                if (!DiscretizeDataSource.isDebug()) break block3;
                exception.printStackTrace();
            }
        }
    }

    boolean isAttributeBinned(int n) {
        String string = this.getBinType(n);
        if (string == null) {
            return false;
        }
        BinningType binningType = BinningType.getInstance(string);
        if (binningType == null) {
            return false;
        }
        return !binningType.equal(BinningType.NONE);
    }

    String getBinType(int n) {
        return (String)this.getData(COLUMN_NAMES.BINTYPE, n);
    }

    void setBinType(int n, String string, int n2) {
        if (0 == string.compareTo(BinningType.NONE.getName())) {
            this.setData(COLUMN_NAMES.BINTYPE, n, string);
        } else {
            this.setData(COLUMN_NAMES.BINTYPE, n, string + ":" + String.valueOf(n2));
        }
    }

    Integer getNumberOfBins(int n) {
        return (Integer)this.getData(COLUMN_NAMES.BINNUMBER, n);
    }

    void setNumberOfBins(int n, int n2) {
        this.setData(COLUMN_NAMES.BINNUMBER, n, new Integer(n2));
    }

    void markAttributeBinned(int n, BinningType binningType, int n2) {
        String string = binningType != null ? binningType.getName() : BinningType.NONE.getName();
        this.setData(COLUMN_NAMES.BINTYPE, n, string);
    }

    void setBinBounds(int n, Vector vector) {
        this.setData(COLUMN_NAMES.BINBOUNDS, n, vector);
    }

    Vector getBinBounds(int n) {
        return (Vector)this.getData(COLUMN_NAMES.BINBOUNDS, n);
    }

    void setTotalCount(int n, int n2) {
        this.setData(COLUMN_NAMES.TOTAL, n, new Integer(n2));
    }

    Integer getTotalCount(int n) {
        return (Integer)this.getData(COLUMN_NAMES.TOTAL, n);
    }

    void setAverage(int n, double d) {
        this.setData(COLUMN_NAMES.AVG, n, new Double(d));
    }

    void setMax(int n, double d) {
        this.setData(COLUMN_NAMES.MAX, n, new Double(d));
    }

    void setMin(int n, double d) {
        this.setData(COLUMN_NAMES.MIN, n, new Double(d));
    }

    void setVariance(int n, double d) {
        this.setData(COLUMN_NAMES.VAR, n, new Double(d));
    }

    void setStdev(int n, double d) {
        this.setData(COLUMN_NAMES.STDDEV, n, new Double(d));
    }

    Double getSigma(int n) {
        return (Double)this.getData(COLUMN_NAMES.STDDEV, n);
    }

    Double getSkew(int n) {
        return (Double)this.getData(COLUMN_NAMES.SKEW, n);
    }

    void setSkew(int n, Double d) {
        this.setData(COLUMN_NAMES.SKEW, n, d);
    }

    Double getKurtosis(int n) {
        return (Double)this.getData(COLUMN_NAMES.KURT, n);
    }

    void setKurtosis(int n, Double d) {
        this.setData(COLUMN_NAMES.KURT, n, d);
    }

    void setNullCount(int n, int n2) {
        this.setData(COLUMN_NAMES.NULLCOUNT, n, new Integer(n2));
    }

    int getNullCount(int n) {
        Integer n2 = (Integer)this.getData(COLUMN_NAMES.NULLCOUNT, n);
        return n2 != null ? n2 : 0;
    }

    Double getVariance(int n) {
        return (Double)this.getData(COLUMN_NAMES.VAR, n);
    }

    Double getAverage(int n) {
        return (Double)this.getData(COLUMN_NAMES.AVG, n);
    }

    Double getMin(int n) {
        return (Double)this.getData(COLUMN_NAMES.MIN, n);
    }

    Double getMax(int n) {
        return (Double)this.getData(COLUMN_NAMES.MAX, n);
    }

    void setStatsMode(int n, String string) {
        this.setData(COLUMN_NAMES.STATS_MODE, n, string);
    }

    String getStatsMode(int n) {
        return (String)this.getData(COLUMN_NAMES.STATS_MODE, n);
    }

    StringBuffer getViewDefinition(int n) {
        return (StringBuffer)this.getData(COLUMN_NAMES.VIEW_DEFN, n);
    }

    void setViewDefinition(int n, StringBuffer stringBuffer) {
        this.setData(COLUMN_NAMES.VIEW_DEFN, n, stringBuffer);
    }

    int getAttributeRow(String string) {
        Integer n = (Integer)this.m_NameRow.get(string);
        return n == null ? -1 : n;
    }

    Hashtable getDisplayNames(int n) {
        return (Hashtable)this.getData(COLUMN_NAMES.DISPLAY_NAMES, n);
    }

    void setDisplayNames(int n, Hashtable hashtable) {
        this.setData(COLUMN_NAMES.DISPLAY_NAMES, n, hashtable);
    }

    double[] getStats(int n) {
        double[] dArray = new double[NUMBER_STATS];
        Integer n2 = (Integer)this.getData(COLUMN_NAMES.TOTAL, n);
        dArray[ExtraDataSource.STAT_TOTAL] = n2 == null ? 0 : n2;
        Double d = (Double)this.getData(COLUMN_NAMES.AVG, n);
        dArray[ExtraDataSource.STAT_AVERAGE] = d == null ? 0.0 : d;
        d = (Double)this.getData(COLUMN_NAMES.MAX, n);
        dArray[ExtraDataSource.STAT_MAX] = d == null ? 0.0 : d;
        d = (Double)this.getData(COLUMN_NAMES.MIN, n);
        dArray[ExtraDataSource.STAT_MIN] = d == null ? 0.0 : d;
        d = (Double)this.getData(COLUMN_NAMES.VAR, n);
        dArray[ExtraDataSource.STAT_VARIANCE] = d == null ? 0.0 : d;
        d = (Double)this.getData(COLUMN_NAMES.STDDEV, n);
        dArray[ExtraDataSource.STAT_STDEV] = d == null ? 0.0 : d;
        dArray[ExtraDataSource.STAT_SKEW] = 0.0;
        dArray[ExtraDataSource.STAT_KURT] = 0.0;
        return dArray;
    }

    void markAttributeUnBinned(int n) {
        this.clearViewDefiniton(n);
        this.setBinTypeNONE(n);
        this.setNumberOfBins(n, 0);
        this.setBinBounds(n, null);
    }

    private void clearViewDefiniton(int n) {
        this.setViewDefinition(n, null);
        if (this.m_isTransactional) {
            this.removeNumericAttributeFromBinBoundary((String)this.getData(COLUMN_NAMES.NAME, n));
        }
    }

    void setBinTypeNONE(int n) {
        this.setData(COLUMN_NAMES.BINTYPE, n, BinningType.NONE.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishCleanUp() {
        try {
            this.m_NameRow.clear();
            DM4JTransformation.dropDatabaseObject(this.m_numericalDiscretizationTableName, this.m_userSchemaName, "TABLE", true, DiscretizeDataSource.isDebug());
            DM4JTransformation.dropDatabaseObject(this.m_categoricalDiscretizationTableName, this.m_userSchemaName, "TABLE", true, DiscretizeDataSource.isDebug());
            this.removeRows(0, this.getRowCount());
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abortCleanUp() {
        try {
            this.m_NameRow.clear();
            DM4JTransformation.dropDatabaseObject(this.m_numericalDiscretizationTableName, this.m_userSchemaName, "TABLE", true, DiscretizeDataSource.isDebug());
            DM4JTransformation.dropDatabaseObject(this.m_categoricalDiscretizationTableName, this.m_userSchemaName, "TABLE", true, DiscretizeDataSource.isDebug());
            this.removeRows(0, this.getRowCount());
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNumericAttributeFromBinBoundary(String string) {
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            String string2 = "\"" + this.m_userSchemaName + "\".\"" + this.m_numericalDiscretizationTableName + "\"";
            StringBuffer stringBuffer = new StringBuffer("DELETE FROM " + string2 + " WHERE \n");
            stringBuffer.append("COLUMN_NAME = '" + string + "'");
            DM4JTransformation.removeAttributesFromBinBoundaryTable(connection, stringBuffer.toString());
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private StringBuffer createTXViewDefinition(String string) {
        String string2 = "\"" + this.m_userSchemaName + "\".\"" + this.m_numericalDiscretizationTableName + "\"";
        String string3 = "\"" + this.m_userSchemaName + "\".\"" + this.m_categoricalDiscretizationTableName + "\"";
        String[] stringArray = new String[]{"SELECT /*+ PQ_DISTRIBUTE(tm BROADCAST, NONE) NO_MERGE(tm) NO_MERGE(bm) SWAP_JOIN_INPUTS(bm) USE_HASH(bm tm) */ ", "\n", "tm.id ", this.m_seqIdMapping, ",tm.cn ", "\"" + this.m_attributeMapping + "\"", ", ", "\n", "CASE WHEN tm.b IS NOT NULL THEN tm.b ELSE CASE WHEN bm.b IS NULL THEN tm.nv ", "\n", "ELSE CASE WHEN bm.b != 0 THEN bm.b ELSE NULL END END END ", "\n", "\"" + this.m_valueMapping + "\"", " FROM (SELECT /*+ PQ_DISTRIBUTE(tn BROADCAST, NONE) NO_MERGE(tn) NO_MERGE(bn) SWAP_JOIN_INPUTS(bn) USE_HASH(bn tn) */ ", "\n", "tn.id,tn.cn,tn.nv,CASE WHEN tn.b IS NOT NULL THEN tn.b ELSE bn.b END b ", "\n", "FROM (", "\n", "SELECT /*+ PARALLEL(tr) PQ_DISTRIBUTE(tr BROADCAST, NONE) NO_MERGE(tr) NO_MERGE(br) SWAP_JOIN_INPUTS(br) USE_HASH(br tr) */ ", "\n", "tr.", this.m_seqIdMapping, " id,tr.", "\"" + this.m_attributeMapping + "\"", " cn,tr.", "\"" + this.m_valueMapping + "\"", " nv,br.b FROM ", "\n", string, " tr ", "\n", "LEFT OUTER JOIN (", "\n", "SELECT /*+ PARALLEL(n) */ column_name c, lower_boundary l,upper_boundary u,bin_id b ", "\n", " FROM ", string2, " n ", "\n", "WHERE lower_boundary != upper_boundary) br ", "\n", "ON tr.", "\"" + this.m_attributeMapping + "\"", " = br.c AND tr.", "\"" + this.m_valueMapping + "\"", " > br.l AND tr.", "\"" + this.m_valueMapping + "\"", " < br.u) tn ", "\n", "LEFT OUTER JOIN (SELECT /*+ PARALLEL(c) */ column_name c,category_value n,group_id b ", "\n", " FROM ", string3, " c ", "\n", "WHERE category_value IS NOT NULL ", "\n", "UNION ALL ", "\n", "SELECT /*+ PARALLEL(n) */ column_name c,lower_boundary n,bin_id b ", "\n", " FROM ", string2, " n ", "\n", "WHERE lower_boundary != upper_boundary ", "\n", "UNION ALL ", "\n", "SELECT column_name c,upper_boundary n,bin_id b FROM (", "\n", "SELECT /*+ PARALLEL(n) */ n.*,MAX(bin_id) OVER (PARTITION BY column_name) max_bin ", "\n", " FROM ", string2, " n ", "\n", ") ", "\n", "WHERE bin_id = max_bin) bn ON tn.cn = bn.c AND tn.nv = bn.n) tm LEFT OUTER JOIN (SELECT /*+PARALLEL(c) */ ", "\n", "column_name c,group_id b ", "\n", " FROM ", string3, " c ", "\n", "WHERE category_value IS NULL ", "\n", "UNION ALL SELECT /*+ PARALLEL(n) */ column_name c,0 b ", "\n", " FROM ", string2, " n ", "\n", "WHERE bin_id = 1) bm ON tm.cn = bm.c ", "\n"};
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getDistinctValues(int n) {
        if (this.m_parent == null) {
            return new Vector();
        }
        String string = this.m_parent.getAttributeName(n);
        Vector vector = new Vector();
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            vector = this.isTX() ? this.getTXDistinctValues(connection, string) : this.get2DDistinctValues(connection, string);
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector get2DDistinctValues(Connection connection, String string) {
        String string2 = "select distinct {0} from {1} where {0} is not null";
        String string3 = MessageFormat.format(string2, "\"" + this.getColumnName(string) + "\"", this.m_sampled2DData);
        Statement statement = null;
        ResultSet resultSet = null;
        Vector<String> vector = new Vector<String>();
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                String string4 = resultSet.getString(1);
                vector.add(string4);
            }
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector getTXDistinctValues(Connection connection, String string) {
        String string2 = "select distinct {0} from {1} where {2}={3} and {0} is not null";
        String string3 = MessageFormat.format(string2, "\"" + this.m_valueMapping + "\"", this.m_sampledTXData, "\"" + this.m_attributeMapping + "\"", "'" + string + "'");
        Statement statement = null;
        ResultSet resultSet = null;
        Vector<String> vector = new Vector<String>();
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                String string4 = resultSet.getString(1);
                vector.add(string4);
            }
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
        return vector;
    }

    protected String getColumnName(String string) {
        String string2 = this.m_bSingleMetric ? this.getValueColumn(string) : string;
        return string2;
    }

    public String getValueColumn(String string) {
        if (this.m_AttributeNameValueMap == null) {
            return null;
        }
        return (String)this.m_AttributeNameValueMap.get(string);
    }

    static /* synthetic */ int access$008() {
        return A++;
    }

    static /* synthetic */ int access$000() {
        return A;
    }

    static {
        ExtraDataSource.items[COLUMN_NAMES.NAME] = "Bins Number";
        ExtraDataSource.items[COLUMN_NAMES.BINNUMBER] = "Bins Number";
        ExtraDataSource.items[COLUMN_NAMES.BINBOUNDS] = "Bin Boundaries";
        ExtraDataSource.items[COLUMN_NAMES.AVG] = "Average";
        ExtraDataSource.items[COLUMN_NAMES.MAX] = "Max";
        ExtraDataSource.items[COLUMN_NAMES.MIN] = "Min";
        ExtraDataSource.items[COLUMN_NAMES.TOTAL] = "Total Count";
        ExtraDataSource.items[COLUMN_NAMES.VAR] = "Variance";
        ExtraDataSource.items[COLUMN_NAMES.STDDEV] = "Sigma";
        ExtraDataSource.items[COLUMN_NAMES.SKEW] = "Skew";
        ExtraDataSource.items[COLUMN_NAMES.KURT] = "Kurtosis";
        ExtraDataSource.items[COLUMN_NAMES.VIEW_DEFN] = "View Definition";
        ExtraDataSource.items[COLUMN_NAMES.BINTYPE] = "Binning Type";
        ExtraDataSource.items[COLUMN_NAMES.NULLCOUNT] = "Null Count";
        ExtraDataSource.items[COLUMN_NAMES.STATS_MODE] = "Stats Mode";
        ExtraDataSource.items[COLUMN_NAMES.DISPLAY_NAMES] = "Display Names";
        ExtraDataSource.items[COLUMN_NAMES.COMPLEX_ATTRIBUTE] = "Complex Attribute";
        STAT_TOTAL = 0;
        STAT_AVERAGE = 1;
        STAT_MAX = 2;
        STAT_MIN = 3;
        STAT_VARIANCE = 4;
        STAT_STDEV = 5;
        STAT_SKEW = 6;
        STAT_KURT = 7;
        NUMBER_STATS = STAT_KURT + 1;
    }

    public static interface COLUMN_NAMES {
        public static final int NAME = ExtraDataSource.access$008();
        public static final int BINNUMBER = ExtraDataSource.access$008();
        public static final int BINBOUNDS = ExtraDataSource.access$008();
        public static final int AVG = ExtraDataSource.access$008();
        public static final int MAX = ExtraDataSource.access$008();
        public static final int MIN = ExtraDataSource.access$008();
        public static final int TOTAL = ExtraDataSource.access$008();
        public static final int VAR = ExtraDataSource.access$008();
        public static final int STDDEV = ExtraDataSource.access$008();
        public static final int SKEW = ExtraDataSource.access$008();
        public static final int KURT = ExtraDataSource.access$008();
        public static final int VIEW_DEFN = ExtraDataSource.access$008();
        public static final int BINTYPE = ExtraDataSource.access$008();
        public static final int NULLCOUNT = ExtraDataSource.access$008();
        public static final int STATS_MODE = ExtraDataSource.access$008();
        public static final int DISPLAY_NAMES = ExtraDataSource.access$008();
        public static final int COMPLEX_ATTRIBUTE = ExtraDataSource.access$008();
        public static final int LAST = ExtraDataSource.access$000();
    }
}

