/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.sql.Connection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.bali.ewt.event.Cancelable;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.browser.LongRunningProcess;
import oracle.dmt.dm4j.datasources.DiscretizeDataSource;

public class DiscretizeWinsorizeArray
extends LongRunningProcess
implements Cancelable {
    protected boolean m_canceled = false;
    protected DiscretizeDataSource m_model;
    protected int m_binNumber;
    protected double m_tailPercent;
    protected Hashtable m_namesRows = null;
    protected Hashtable m_failedAttributes = new Hashtable();

    public Hashtable getFailed() {
        return this.m_failedAttributes;
    }

    public DiscretizeWinsorizeArray(DiscretizeDataSource discretizeDataSource, Hashtable hashtable, int n, double d) {
        this.m_model = discretizeDataSource;
        this.m_namesRows = hashtable;
        this.m_binNumber = n;
        this.m_tailPercent = d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Connection connection = null;
        try {
            Object object;
            connection = DM4JConnectionManager.getDbConnection();
            int[] nArray = null;
            if (!this.m_namesRows.isEmpty()) {
                nArray = new int[this.m_namesRows.size()];
            }
            Vector vector = new Vector();
            int n = 0;
            Enumeration enumeration = this.m_namesRows.keys();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                Integer n2 = (Integer)this.m_namesRows.get(object);
                if (n2 == null) continue;
                int n3 = n2;
                nArray[n++] = n3;
                double[] dArray = this.m_model.getWinsorizedStats(connection, (String)object, this.m_tailPercent);
                if (dArray == null) continue;
                this.m_model.set1stOrderStatistics(n3, dArray);
                Vector vector2 = this.m_model.getEqualWidthBounds(dArray, this.m_binNumber);
                this.m_model.setBinBounds(n3, vector2);
                if (vector2 != null && vector2.size() != 0) continue;
                this.m_failedAttributes.put(object, n2);
            }
            object = new int[n];
            System.arraycopy(nArray, 0, object, 0, n);
            this.m_model.getViewDefinition(connection, (int[])object, true);
            this.getProgressBar().setDoneStatus();
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
            this.setException(exception);
            this.getProgressBar().setDoneStatus();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean isCancelled() {
        return this.m_canceled;
    }

    public void cancel() {
        this.m_canceled = true;
    }

    class WinsorizeThread
    extends Thread {
        Connection m_conn;
        int m_row;
        String m_columnName;
        private boolean m_isConnected = false;

        WinsorizeThread(String string, int n) {
            this.m_columnName = string;
            this.m_row = n;
            try {
                this.m_conn = DM4JConnectionManager.getDbConnection();
                this.m_isConnected = true;
            }
            catch (Exception exception) {
                System.out.println(exception);
                this.m_isConnected = false;
            }
        }

        public void run() {
            try {
                if (!this.m_isConnected) {
                    DiscretizeWinsorizeArray.this.m_model.markAttributeUnBinned(this.m_row);
                    return;
                }
                double[] dArray = DiscretizeWinsorizeArray.this.m_model.getWinsorizedStats(this.m_conn, this.m_columnName, DiscretizeWinsorizeArray.this.m_tailPercent);
                if (dArray != null) {
                    DiscretizeWinsorizeArray.this.m_model.set1stOrderStatistics(this.m_row, dArray);
                    Vector vector = DiscretizeWinsorizeArray.this.m_model.getEqualWidthBounds(dArray, DiscretizeWinsorizeArray.this.m_binNumber);
                    DiscretizeWinsorizeArray.this.m_model.setBinBounds(this.m_row, vector);
                }
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            try {
                if (this.m_conn != null) {
                    this.m_conn.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

