/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.sql.Connection;
import java.util.Hashtable;
import java.util.Vector;
import oracle.bali.ewt.event.Cancelable;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.browser.LongRunningProcess;
import oracle.dmt.dm4j.datasources.DiscretizeDataSource;
import oracle.dmt.dm4j.wizard.state.transformsteps.BinBoundary;
import oracle.dmt.dm4j.wizard.state.transformsteps.BinBoundaryTableModel;
import oracle.dmt.odm.binning.Bin;

public class DiscretizeQtileBounds
extends LongRunningProcess
implements Cancelable {
    protected boolean m_canceled = false;
    protected DiscretizeDataSource m_model;
    protected String m_columnName;
    protected int m_row;
    protected int m_binNumber;
    private BinBoundaryTableModel m_tableModel;
    private Vector m_attributeNames;
    private Hashtable m_columnNameIDMap;

    public DiscretizeQtileBounds(DiscretizeDataSource discretizeDataSource, BinBoundaryTableModel binBoundaryTableModel, String string, int n, int n2) {
        this.m_model = discretizeDataSource;
        this.m_columnName = string;
        this.m_row = n;
        this.m_binNumber = n2;
        this.m_tableModel = binBoundaryTableModel;
        this.m_attributeNames = new Vector();
        this.m_attributeNames.add(this.m_columnName);
        this.m_columnNameIDMap = new Hashtable();
        this.m_columnNameIDMap.put(this.m_columnName, new Integer(this.m_row));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            this.m_tableModel.deleteAllEntries();
            this.m_model.getQtileStats(connection, this.m_attributeNames, this.m_columnNameIDMap, null, this.m_binNumber);
            Vector vector = this.m_model.getBinBounds(this.m_row);
            if (vector != null) {
                for (int i = 0; i < vector.size() && !this.m_canceled; ++i) {
                    Bin bin = (Bin)vector.elementAt(i);
                    BinBoundary binBoundary = new BinBoundary(new Integer(i), new Double(bin.getLowerBound()));
                    this.m_tableModel.addEntry(binBoundary);
                }
            }
            this.getProgressBar().setDoneStatus();
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
            this.setException(exception);
            this.getProgressBar().setDoneStatus();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean isCancelled() {
        return this.m_canceled;
    }

    public void cancel() {
        this.m_canceled = true;
    }
}

