/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JOptionPane;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.activity.steps.DiscretizationStepOptions;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.browser.UserPreferences;
import oracle.dmt.dm4j.datasources.CategoricDiscretizeDataSource;
import oracle.dmt.dm4j.datasources.DiscretizeDataSource;
import oracle.dmt.dm4j.datasources.DiscretizeTopNArray;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.odm.binning.BinningType;
import oracle.dmt.odm.binning.CategoricalBackupData;
import oracle.dmt.odm.binning.DM4JTransformation;

public class DiscretizePredefinedCategoricTreatment {
    CategoricDiscretizeDataSource m_model;
    DiscretizationStepOptions m_options;
    Hashtable m_backupData = null;
    boolean m_bShowProgress;
    boolean m_bLabels = false;
    static String QUANTILE_BINNING = ResourceUtilities.getUILabel("QUANTILE_BINNING_STRATEGY_DIALOG_DESCRIPTION");
    static String EQUAL_WIDTH_BINNING = ResourceUtilities.getUILabel("EQUAL_WIDTH_BINNING_STRATEGY_DIALOG_DESCRIPTION");
    static String TOPN_BINNING = ResourceUtilities.getUILabel("TOPN_BINNING_STRATEGY_DIALOG_DESCRIPTION");
    static String NONE = ResourceUtilities.getUILabel("NONE");

    public DiscretizePredefinedCategoricTreatment(CategoricDiscretizeDataSource categoricDiscretizeDataSource, Hashtable hashtable) {
        this.m_bShowProgress = true;
        this.m_model = categoricDiscretizeDataSource;
        this.m_options = this.m_model.getDiscretizationStepOptions();
        this.m_backupData = hashtable;
        this.m_bLabels = this.m_model.isLabels();
    }

    public DiscretizePredefinedCategoricTreatment(CategoricDiscretizeDataSource categoricDiscretizeDataSource) {
        this.m_bShowProgress = false;
        this.m_model = categoricDiscretizeDataSource;
        this.m_options = this.m_model.getDiscretizationStepOptions();
        this.m_backupData = null;
        this.m_bLabels = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAttributes(ActivityType activityType) {
        String string = this.m_model.getCategoricBinBoundatyTableName();
        String string2 = this.m_model.getUserSchemaName();
        if (string != null) {
            String string3 = string2 != null ? "\"" + string2 + "\".\"" : "\"";
            String string4 = string3 + string + "\"";
            Connection connection = null;
            try {
                connection = DM4JConnectionManager.getDbConnection();
                DM4JTransformation.removeAttributesFromBinBoundaryTable(connection, "DELETE FROM " + string4);
            }
            catch (Exception exception) {
                if (DiscretizeDataSource.isDebug()) {
                    exception.printStackTrace();
                }
            }
            finally {
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        if (this.m_options == null) {
            if (activityType.equals(ActivityType.ADAPTIVE_NAIVE_BAYES) || activityType.equals(ActivityType.NAIVE_BAYES) || activityType.equals(ActivityType.ATTRIBUTE_IMPORTANCE)) {
                int n = this.getDefaultBinNumber(activityType);
                this.topN(n);
            } else {
                this.unbinAll();
            }
        } else if (this.m_options.getCategoricalDiscretizeTreatment().equalsIgnoreCase(TOPN_BINNING)) {
            if (activityType.equals(ActivityType.ADAPTIVE_NAIVE_BAYES) || activityType.equals(ActivityType.NAIVE_BAYES) || activityType.equals(ActivityType.ATTRIBUTE_IMPORTANCE)) {
                int n = this.getDefaultBinNumber(activityType);
                this.topN(n);
            } else {
                this.unbinAll();
            }
        } else {
            this.unbinAll();
        }
    }

    public void unbinAll() {
        for (int i = 0; i < this.m_model.getRowCount(); ++i) {
            this.m_model.markAttributeUnBinned(i);
            this.m_model.setActivityType(i, null);
        }
    }

    public int getDefaultBinNumber(ActivityType activityType) {
        UserPreferences userPreferences = UserPreferences.getInstance();
        int n = 0;
        n = true == activityType.equals(ActivityType.ADAPTIVE_NAIVE_BAYES) ? Math.min(userPreferences.getMaxABNCategoricalBin(), 125) : Math.min(userPreferences.getMaxCategoricalBin(), 125);
        if (this.m_options != null) {
            n = this.m_options.getCategoricalBinNumber();
        }
        return n;
    }

    public void topN(int n) {
        Object object;
        Object object2;
        this.m_model.setLabels(this.m_bLabels);
        if (this.m_backupData != null) {
            this.m_backupData.clear();
        }
        Hashtable<Object, Integer> hashtable = new Hashtable<Object, Integer>();
        Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>();
        for (int i = 0; i < this.m_model.getRowCount(); ++i) {
            object2 = new CategoricalBackupData(this.m_model, i);
            object = this.m_model.getAttributeName(i);
            hashtable2.put((String)object, new Integer(i));
            Integer n2 = this.m_model.getDistinctValue(i);
            if (n2 >= n) {
                int n3 = Math.min(125, n);
                hashtable.put(object, new Integer(n3));
            }
            if (this.m_backupData == null) continue;
            this.m_backupData.put(new Integer(i), object2);
        }
        if (!hashtable.isEmpty()) {
            int n4;
            String string;
            object2 = new StringBuffer();
            if (hashtable.size() < 10) {
                object = hashtable.keys();
                int n5 = 0;
                while (object.hasMoreElements()) {
                    String string2 = (String)object.nextElement();
                    ((StringBuffer)object2).append("\"" + string2 + "\"");
                    n5 += string2.length();
                    if (object.hasMoreElements()) {
                        ((StringBuffer)object2).append(",");
                        ++n5;
                    }
                    if (n5 < 40) continue;
                    ((StringBuffer)object2).append("\n");
                    n5 = 0;
                }
                string = MessageFormat.format(ResourceUtilities.getUILabel("TOPN_BINNING_STRATEGY_DIALOG_WARNING"), ((StringBuffer)object2).toString());
            } else {
                string = ResourceUtilities.getUILabel("TOPN_BINNING_STRATEGY_DIALOG_WARNING_MUTIPLE");
            }
            if (this.m_bShowProgress && ((n4 = JOptionPane.showOptionDialog(null, string, ResourceUtilities.getUILabel("WARNING_DIALOG_TITLE"), 0, 2, null, null, null)) == 1 || n4 == -1)) {
                if (this.m_backupData != null) {
                    this.m_backupData.clear();
                }
                return;
            }
        }
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            Integer n6 = (Integer)hashtable.get(object2);
            int n7 = 0;
            if (n6 == null) continue;
            n7 = n6;
            Integer n8 = (Integer)hashtable2.get(object2);
            this.m_model.markAttributeBinned(n8, BinningType.TOPN, n7);
            this.m_model.setNumberOfBins(n8, n7);
        }
        if (this.m_bShowProgress) {
            this.getTopNBounds(hashtable2);
        } else {
            this.getTopNBoundsSilent(hashtable2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getTopNBoundsSilent(Hashtable hashtable) {
        Connection connection = null;
        try {
            Object object;
            connection = DM4JConnectionManager.getDbConnection();
            int[] nArray = null;
            if (!hashtable.isEmpty()) {
                nArray = new int[hashtable.size()];
            }
            int n = 0;
            Vector<Object> vector = new Vector<Object>();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                Integer n2 = (Integer)hashtable.get(object);
                if (n2 == null) continue;
                int n3 = n2;
                nArray[n++] = n3;
                vector.add(object);
            }
            if (n > 0) {
                object = new int[n];
                System.arraycopy(nArray, 0, object, 0, n);
                if (!this.m_model.isTransactional()) {
                    this.m_model.getTopNStats(connection, vector, hashtable, null);
                } else {
                    this.m_model.getTopNStatsTXMultipleBins(connection, vector, hashtable, null);
                }
                this.m_model.getViewDefinition(connection, (int[])object, false);
            }
        }
        catch (Exception exception) {
            if (CategoricDiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getTopNBounds(Hashtable hashtable) {
        try {
            DiscretizeTopNArrayDefaultSettings discretizeTopNArrayDefaultSettings = new DiscretizeTopNArrayDefaultSettings(this.m_model, hashtable);
            discretizeTopNArrayDefaultSettings.setCleanupFlag(false);
            ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("BINNING_BOUNDARIES_CALCULATION_DIALOG_TITLE"), discretizeTopNArrayDefaultSettings, true);
            discretizeTopNArrayDefaultSettings.setProgressBar(progressBar);
            progressBar.start(ResourceUtilities.getUILabel("BINNING_BOUNDARIES_CALCULATION_DIALOG_TITLE"), ResourceUtilities.getUILabel("BINNING_BOUNDARIES_CALCULATION_DIALOG_DESC"));
            if (discretizeTopNArrayDefaultSettings.getException() != null) {
                this.restoreAttrubuteValues(hashtable);
            } else if (progressBar.hasUserCancelled()) {
                this.restoreAttrubuteValues(hashtable);
            }
        }
        catch (Exception exception) {}
    }

    private void restoreAttrubuteValues(Hashtable hashtable) {
        if (this.m_backupData == null) {
            return;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Integer n = (Integer)hashtable.get(string);
            if (n == null) continue;
            CategoricalBackupData categoricalBackupData = (CategoricalBackupData)this.m_backupData.get(n);
            int n2 = n;
            categoricalBackupData.restoreBackupData(this.m_model);
        }
    }

    protected String getWarningMessage() {
        return ResourceUtilities.getUILabel("DISCRETIZATION_SETTINGS_RESTORE");
    }

    public class DiscretizeTopNArrayDefaultSettings
    extends DiscretizeTopNArray {
        public DiscretizeTopNArrayDefaultSettings(CategoricDiscretizeDataSource categoricDiscretizeDataSource, Hashtable hashtable) {
            super(categoricDiscretizeDataSource, hashtable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Connection connection = null;
            try {
                Object object;
                connection = DM4JConnectionManager.getDbConnection();
                int[] nArray = null;
                if (!this.m_namesRows.isEmpty()) {
                    nArray = new int[this.m_namesRows.size()];
                }
                int n = 0;
                Vector<int[]> vector = new Vector<int[]>();
                Enumeration enumeration = this.m_namesRows.keys();
                while (enumeration.hasMoreElements()) {
                    object = (String)enumeration.nextElement();
                    Integer n2 = (Integer)this.m_namesRows.get(object);
                    if (n2 == null) continue;
                    int n3 = n2;
                    nArray[n++] = n3;
                    vector.add((int[])object);
                }
                object = new int[n];
                System.arraycopy(nArray, 0, object, 0, n);
                if (this.m_model.isTransactional() && !this.m_model.isSingleMetric()) {
                    this.m_model.getTopNStatsTXMultipleBins(connection, vector, this.m_namesRows, null);
                } else {
                    this.m_model.getTopNStats(connection, vector, this.m_namesRows, null);
                }
                this.m_model.getViewDefinition(connection, (int[])object, this.m_bCleanUp);
            }
            catch (Exception exception) {
                if (DiscretizeDataSource.isDebug()) {
                    exception.printStackTrace();
                }
                this.setException(exception);
            }
            finally {
                this.getProgressBar().setDoneStatus();
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }
}

