/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.sql.Connection;
import oracle.bali.ewt.event.Cancelable;
import oracle.dmt.dm4j.browser.LongRunningProcess;
import oracle.dmt.dm4j.datasources.DiscretizeDataSource;

public class DiscretizeFrequency
extends LongRunningProcess
implements Cancelable {
    private boolean m_canceled = false;
    private DiscretizeDataSource m_model;
    private int m_row;
    private String m_attributeName;
    private int[] m_frequency = null;
    private String m_samplingView = null;
    private Connection m_conn;

    public DiscretizeFrequency(Connection connection, DiscretizeDataSource discretizeDataSource, int n, String string) {
        this.m_conn = connection;
        this.m_model = discretizeDataSource;
        this.m_row = n;
        this.m_attributeName = this.m_model.getAttributeName(this.m_row);
        this.m_samplingView = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.m_frequency = new int[this.m_model.getNumberOfBins(this.m_row) + 1];
            this.m_frequency = this.m_model.getNumericFrequency(this.m_conn, this.m_attributeName, this.m_row, true);
            if (this.m_frequency != null && this.m_model.isNumeric(this.m_row)) {
                Double d = this.m_model.getSkew(this.m_row);
                Double d2 = this.m_model.getKurtosis(this.m_row);
                double[] dArray = null;
                if (d == null || d2 == null) {
                    dArray = this.m_model.getStats(this.m_row);
                    if (this.m_model.isWinsorizeBinning(this.m_row)) {
                        this.m_model.getWinsorized2ndorderStats(this.m_conn, this.m_row, dArray, this.m_attributeName, this.m_model.getTailPercent(this.m_row));
                    } else if (this.m_model.isCustomBinning(this.m_row)) {
                        this.m_model.getCustom2ndorderStats(this.m_conn, this.m_row, dArray, this.m_attributeName, this.m_model.getCustomLowerBound(this.m_row), this.m_model.getCustomUpperBound(this.m_row));
                    } else {
                        this.m_model.getEqualWidth2ndorderStats(this.m_conn, this.m_row, dArray, this.m_attributeName, this.m_samplingView);
                    }
                }
            }
            this.getProgressBar().setDoneStatus();
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
            this.setException(exception);
            this.m_frequency = null;
            this.getProgressBar().setDoneStatus();
        }
    }

    public boolean isCancelled() {
        return this.m_canceled;
    }

    public void cancel() {
        this.m_canceled = true;
    }

    public int[] getFrequency() {
        return this.m_frequency;
    }
}

