/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.sql.Connection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.bali.ewt.event.Cancelable;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.browser.LongRunningProcess;
import oracle.dmt.dm4j.datasources.DiscretizeDataSource;

public class DiscretizeEqualWidthArray
extends LongRunningProcess
implements Cancelable {
    protected boolean m_canceled = false;
    protected DiscretizeDataSource m_model;
    protected int m_binNumber;
    protected Hashtable m_namesRows = null;

    public DiscretizeEqualWidthArray(DiscretizeDataSource discretizeDataSource, Hashtable hashtable, int n) {
        this.m_model = discretizeDataSource;
        this.m_namesRows = hashtable;
        this.m_binNumber = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Connection connection = null;
        try {
            Object object;
            connection = DM4JConnectionManager.getDbConnection();
            int[] nArray = null;
            if (!this.m_namesRows.isEmpty()) {
                nArray = new int[this.m_namesRows.size()];
            }
            int n = 0;
            Vector<int[]> vector = new Vector<int[]>();
            Enumeration enumeration = this.m_namesRows.keys();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                Integer n2 = (Integer)this.m_namesRows.get(object);
                if (n2 == null) continue;
                int n3 = n2;
                nArray[n++] = n3;
                vector.add((int[])object);
            }
            object = new int[n];
            System.arraycopy(nArray, 0, object, 0, n);
            this.m_model.getEqualWidthStats(vector, this.m_namesRows, null, this.m_binNumber, true);
            this.m_model.getViewDefinition(connection, (int[])object, true);
            this.getProgressBar().setDoneStatus();
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
            this.setException(exception);
            this.getProgressBar().setDoneStatus();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean isCancelled() {
        return this.m_canceled;
    }

    public void cancel() {
        this.m_canceled = true;
    }
}

