/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Vector;
import javax.datamining.data.AttributeType;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.activity.data.Mapping;
import oracle.dmt.dm4j.activity.data.Table;
import oracle.dmt.dm4j.activity.steps.DiscretizationStepOptions;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.browser.UserPreferences;
import oracle.dmt.dm4j.datasources.CDSDataSource;
import oracle.dmt.dm4j.datasources.ComplexDataStructure;
import oracle.dmt.dm4j.datasources.DBDataSource;
import oracle.dmt.dm4j.datasources.DiscretizationLDSDataSource;
import oracle.dmt.dm4j.datasources.DiscretizeInvoke;
import oracle.dmt.dm4j.datasources.DiscretizePredefinedNumericTreatment;
import oracle.dmt.dm4j.datasources.TXColumn;
import oracle.dmt.dm4j.wizard.director.transforms.TransformsDirector;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.odm.binning.Bin;
import oracle.dmt.odm.binning.BinningType;
import oracle.dmt.odm.binning.CategoricBin;
import oracle.dmt.odm.binning.DM4JTransformation;
import oracle.jdbc.OraclePreparedStatement;

public class DiscretizeDataSource
extends DBDataSource
implements DiscretizeInvoke {
    protected boolean m_bDefaultProcessing = true;
    protected boolean m_bAutoRun;
    static final int BATCH_SIZE = 100;
    private static final boolean DEBUG = false;
    private static boolean m_bLabels;
    protected static String TEMPLATE_START_AUTO_BIN;
    protected static final int MAX_SAMPLE_COUNT = 50000;
    protected static final double BIN_FACTOR = 0.9;
    protected static final double MAX_NUMBER_OF_BINS = 100.0;
    CDSDataSource m_helper;
    public static final int MAXIMUM_NUMERIC_BIN_NUMBER = 127;
    private boolean m_acceptsTextData = false;
    protected static Hashtable m_AttributeType;
    protected DiscretizationStepOptions options = null;
    static String QUANTILE_BINNING;
    static String EQUAL_WIDTH_BINNING;
    static String TOPN_BINNING;
    static String NONE;
    public DiscretizeDataSource m_parentSource = null;
    DiscretizeDataSource m_additionalSource = null;
    protected ComplexDataStructure m_origInternallySampledCDS;
    protected ComplexDataStructure m_origInputCDS;
    protected ComplexDataStructure m_origOutputCDS;
    protected ComplexDataStructure m_sampledInternallySampledCDS;
    protected ComplexDataStructure m_sampledInputCDS;
    protected ComplexDataStructure m_sampledOutputCDS;
    protected static final String SQL_SAMPLING_VIEW = "(SELECT {0} FROM (  WITH s AS (SELECT COUNT(*) c FROM {1})   SELECT t.* FROM s, (SELECT t.*, ROWNUM RNUM FROM {1} t) t WHERE ORA_HASH(RNUM,(s.c-1),0) < {2} ))";
    protected static final String SQL_SAMPLING_VIEW_KNOWN_COUNT = "(SELECT {0} FROM (\n  SELECT t.* FROM (SELECT t.*, ROWNUM RNUM FROM {1} t) t WHERE ORA_HASH(RNUM,({3}-1),0) < {2} ))";
    private static final String SQL_TXN_SAMPLING_VIEW = "(SELECT ORIGINAL_DATA.* FROM   {0} ORIGINAL_DATA,   ( select {1}  from (       (select distinct t.{1}, ora_hash({1}, 99, 5 ) dm$rv from {0} t order by dm$rv)  ) where rownum <= {2} ) RANDOM_IDS WHERE RANDOM_IDS.{1} = ORIGINAL_DATA.{1})";
    protected boolean m_collectColumnNames = true;
    public static final int ATTRIBUTE_SCAN_SIZE = 1000;
    public static final int ATTRIBUTE_SCAN_SIZE_SMALL = 1000;
    protected static final String _SELECT = " SELECT ";
    public static final String AS_SELECT = " AS SELECT ";
    public static int STAT_TOTAL;
    public static int STAT_AVERAGE;
    public static int STAT_MAX;
    public static int STAT_MIN;
    public static int STAT_VARIANCE;
    public static int STAT_STDEV;
    public static int STAT_SKEW;
    public static int STAT_KURT;
    public static final String SEPARATOR = ":";
    public static int NUMBER_STATS;
    private static int A;
    private static int COLUMN_COUNT;
    static String STAT_SQL_EQ_WIDTH_1ST_ORDER;
    private static String STAT_SQL_EQ_WIDTH_1ST_ORDER_TX;
    public static String STAT_SQL_EQ_WIDTH_STDEV_COUNT;
    public static String STAT_SQL_EQ_WIDTH_STDEV_COUNT_TX;
    protected static String[] STAT_SQL_CUSTOM_1ST_ORDER;
    private static String[] STAT_SQL_CUSTOM_1ST_ORDER_TX;
    private static String[] STAT_SQL_CUSTOM_STDEV_COUNT;
    private static String[] STAT_SQL_CUSTOM_STDEV_COUNT_TX;
    private static final String[] STAT_SQL_WINSORIZE_1ST_ORDER;
    private static final String[] STAT_SQL_WINSORIZE_1ST_ORDER_TX;
    private static final String[] STAT_SQL_WINSORIZE_STDEV_COUNT;
    private static final String[] STAT_SQL_WINSORIZE_STDEV_COUNT_TX;
    public static String[] STAT_SQL_EQ_WIDTH_2ND_ORDER;
    public static String[] STAT_SQL_EQ_WIDTH_2ND_ORDER_TX;
    protected static String[] STAT_SQL_CUSTOM_2ND_ORDER;
    private static String[] STAT_SQL_CUSTOM_2ND_ORDER_TX;
    private static String[] STAT_SQL_WINSORIZE_2ND_ORDER;
    private static String[] STAT_SQL_WINSORIZE_2ND_ORDER_TX;
    public static final String[] HISTOGRAM_VALUES;
    public static final String[] HISTOGRAM_VALUES_LABELS;
    public static final String[] HISTOGRAM_VALUES_TX;
    static final String TOPN_STATS = "SELECT * FROM (SELECT {0} FROM {1} GROUP BY {0} HAVING {0} IS NOT NULL ORDER BY COUNT(*) DESC, {0} DESC) WHERE rownum <= {2}";
    static final String TOPN_STATS_TX = "SELECT * FROM (SELECT {0} FROM {1}  WHERE {3}={4} GROUP BY {0} HAVING {0} IS NOT NULL ORDER BY COUNT(*) DESC, {0} DESC) WHERE rownum <= {2}";
    public static int DEFAULT_BIN_NUMBER;
    public static int DEFAULT_ABN_BIN_NUMBER;
    public static double DEFAULT_TAIL_PERCENT;
    protected static String RESULT_VIEW_NAME;
    public static String SAMPLING_TABLE_PREFIX;
    protected static String NUMERIC_BIN_TABLE_PREFIX;
    protected static String CATEGORIC_BIN_TABLE_PREFIX;
    protected String m_numericalDiscretizationTableName = null;
    protected String m_categoricalDiscretizationTableName = null;
    protected String m_sDataLocation = null;
    protected String m_tableName = null;
    protected String m_dataSourceSchemaName = null;
    protected String m_userSchemaName = null;
    protected String m_resultViewName = null;
    protected String m_originalResultViewName;
    protected boolean m_bRemoveResultView = false;
    protected static String[] items;
    protected Vector m_tableColumns = new Vector();
    protected String m_samplingTableName = null;
    protected String m_attributeMapping;
    protected String m_valueMapping;
    protected String m_seqIdMapping;
    protected boolean m_isTransactional = false;
    protected boolean m_bSingleMetric = false;
    protected StringBuffer m_txSampledViewDefinition;
    protected StringBuffer m_txViewDefinition;
    protected Hashtable m_NameRow = new Hashtable();
    protected int m_nullCount = 0;
    protected UserPreferences m_preferences = UserPreferences.getInstance();
    private String m_sampling2DView = null;
    private String m_samplingTXView = null;
    DiscretizationLDSDataSource m_lds;
    protected BrowserContext m_context = null;

    public void setDefaultProcessing(boolean bl) {
        this.m_bDefaultProcessing = bl;
    }

    public boolean isDefaultProcessing() {
        return this.m_bDefaultProcessing;
    }

    public AttributeType getAttributeType(String string) {
        return (AttributeType)m_AttributeType.get(string);
    }

    public void setLabels(boolean bl) {
        m_bLabels = bl;
    }

    public boolean isLabels() {
        return m_bLabels;
    }

    public static boolean isDebug() {
        return false;
    }

    public void setAdditionalSource(DiscretizeDataSource discretizeDataSource) {
        this.m_additionalSource = discretizeDataSource;
        this.initAdditionalSource(this.m_additionalSource);
    }

    public ComplexDataStructure getOriginalInternallySampledCDS() {
        return this.m_origInternallySampledCDS;
    }

    public void setOriginalInternallySampledCDS(ComplexDataStructure complexDataStructure) {
        this.m_origInternallySampledCDS = complexDataStructure;
    }

    public ComplexDataStructure getOriginalInputCDS() {
        return this.m_origInputCDS;
    }

    public void setOriginalInputCDS(ComplexDataStructure complexDataStructure) {
        this.m_origInputCDS = complexDataStructure;
    }

    public ComplexDataStructure getOriginalOutputCDS() {
        return this.m_origOutputCDS;
    }

    public void setOriginalOutputCDS(ComplexDataStructure complexDataStructure) {
        this.m_origOutputCDS = complexDataStructure;
    }

    public ComplexDataStructure getSampledInputCDS() {
        return this.m_sampledInputCDS;
    }

    public void setSampledInputCDS(ComplexDataStructure complexDataStructure) {
        this.m_sampledInputCDS = complexDataStructure;
    }

    public ComplexDataStructure getSampledOutputCDS() {
        return this.m_sampledOutputCDS;
    }

    public void setSampledOutputCDS(ComplexDataStructure complexDataStructure) {
        this.m_sampledOutputCDS = complexDataStructure;
    }

    public ComplexDataStructure getSampledInternallySampledCDS() {
        return this.m_sampledInternallySampledCDS;
    }

    public void setSampledInternallySampledCDS(ComplexDataStructure complexDataStructure) {
        this.m_sampledInternallySampledCDS = complexDataStructure;
    }

    public void callCreateData() throws Exception {
        if (this.m_additionalSource != null) {
            this.m_additionalSource.m_collectColumnNames = false;
            this.m_additionalSource.m_columnModel = this.m_additionalSource.createColumns();
            this.m_additionalSource.m_context = this.m_context;
            this.m_additionalSource.m_tableColumns = this.m_tableColumns;
            this.m_additionalSource.m_parentSource = this;
            this.m_additionalSource.createData();
            this.m_additionalSource.createRowHeader();
        }
    }

    public String getResultViewName() {
        return this.m_resultViewName;
    }

    public String getOriginalResultViewName() {
        return this.m_originalResultViewName;
    }

    public void clearMap() {
        this.m_NameRow.clear();
    }

    public int getNullCount() {
        return this.m_nullCount;
    }

    public int getSampleSize() {
        return this.m_preferences.getSampleSize();
    }

    public void setBrowserContext(BrowserContext browserContext) {
        this.m_context = browserContext;
    }

    public boolean isTransactional() {
        return this.m_isTransactional;
    }

    public boolean isSingleMetric() {
        return this.m_bSingleMetric;
    }

    public String getNumericBinBoundatyTableName() {
        return this.m_numericalDiscretizationTableName;
    }

    public String getCategoricBinBoundatyTableName() {
        return this.m_categoricalDiscretizationTableName;
    }

    public void setNumericBinBoundatyTableName(String string) {
        this.m_numericalDiscretizationTableName = string;
    }

    public void setCategoricBinBoundatyTableName(String string) {
        this.m_categoricalDiscretizationTableName = string;
    }

    public String getUserSchemaName() {
        return this.m_userSchemaName;
    }

    protected String getSamplingTableLocation() {
        return "\"" + this.m_userSchemaName + "\".\"" + this.m_samplingTableName + "\"";
    }

    public Vector getColumns() {
        return this.m_tableColumns;
    }

    void setColumns(Vector vector) {
        this.m_tableColumns = vector;
    }

    public DiscretizeDataSource(Connection connection, DiscretizationLDSDataSource discretizationLDSDataSource, String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl) throws Exception {
        super(connection);
        m_bLabels = this.m_preferences.getBooleanValue("DISCRETIZATION_STRING");
        this.m_lds = discretizationLDSDataSource;
        this.m_tableName = string;
        this.m_dataSourceSchemaName = string2;
        this.m_userSchemaName = string3;
        if (string4 == null) {
            this.m_resultViewName = ValidationUtil.createUniqueTableName(RESULT_VIEW_NAME, connection, "");
            this.m_bRemoveResultView = true;
        } else {
            this.m_resultViewName = string4;
        }
        this.m_sDataLocation = "\"" + string2 + "\".\"" + string + "\"";
        this.m_attributeMapping = string5;
        this.m_valueMapping = string6;
        this.m_seqIdMapping = string7;
        this.m_isTransactional = true;
        this.m_bSingleMetric = bl;
        this.m_samplingTableName = ValidationUtil.createUniqueTableName(SAMPLING_TABLE_PREFIX, connection, "");
        if (bl) {
            this.getSampledDataLocationSM();
            return;
        }
        this.m_numericalDiscretizationTableName = ValidationUtil.createUniqueTableName(NUMERIC_BIN_TABLE_PREFIX, connection, "");
        this.m_categoricalDiscretizationTableName = ValidationUtil.createUniqueTableName(CATEGORIC_BIN_TABLE_PREFIX, connection, "");
        DM4JTransformation.createPhysicalTables(connection, this.m_numericalDiscretizationTableName, this.m_categoricalDiscretizationTableName, this.m_userSchemaName);
        this.m_txSampledViewDefinition = this.createTXViewDefinition(this.getSampledDataLocation(), this.m_userSchemaName, this.m_resultViewName);
        this.m_txViewDefinition = this.createTXViewDefinition(this.m_sDataLocation, this.m_userSchemaName, this.m_resultViewName);
    }

    public DiscretizeDataSource(Connection connection, DiscretizationLDSDataSource discretizationLDSDataSource, String string, String string2, String string3, String string4, String string5, String string6, String string7) throws Exception {
        super(connection);
        m_bLabels = this.m_preferences.getBooleanValue("DISCRETIZATION_STRING");
        this.m_lds = discretizationLDSDataSource;
        this.m_tableName = string;
        this.m_dataSourceSchemaName = string2;
        this.m_userSchemaName = string3;
        if (string4 == null) {
            this.m_resultViewName = ValidationUtil.createUniqueTableName(RESULT_VIEW_NAME, connection, "");
            this.m_bRemoveResultView = true;
        } else {
            this.m_resultViewName = string4;
        }
        this.m_sDataLocation = "\"" + string2 + "\".\"" + string + "\"";
        this.m_attributeMapping = string5;
        this.m_valueMapping = string6;
        this.m_seqIdMapping = string7;
        this.m_isTransactional = true;
        this.m_bSingleMetric = false;
        this.m_samplingTableName = ValidationUtil.createUniqueTableName(SAMPLING_TABLE_PREFIX, connection, "");
        this.m_numericalDiscretizationTableName = ValidationUtil.createUniqueTableName(NUMERIC_BIN_TABLE_PREFIX, connection, "");
        this.m_categoricalDiscretizationTableName = ValidationUtil.createUniqueTableName(CATEGORIC_BIN_TABLE_PREFIX, connection, "");
        DM4JTransformation.createPhysicalTables(connection, this.m_numericalDiscretizationTableName, this.m_categoricalDiscretizationTableName, this.m_userSchemaName);
        this.m_txSampledViewDefinition = this.createTXViewDefinition(this.getSampledDataLocation(), this.m_userSchemaName, this.m_resultViewName);
        this.m_txViewDefinition = this.createTXViewDefinition(this.m_sDataLocation, this.m_userSchemaName, this.m_resultViewName);
    }

    protected DiscretizeDataSource(Connection connection) throws Exception {
        super(connection);
        m_bLabels = this.m_preferences.getBooleanValue("DISCRETIZATION_STRING");
    }

    protected void initAdditionalSource(DiscretizeDataSource discretizeDataSource) {
        discretizeDataSource.m_lds = this.m_lds;
        discretizeDataSource.m_tableName = this.m_tableName;
        discretizeDataSource.m_dataSourceSchemaName = this.m_dataSourceSchemaName;
        discretizeDataSource.m_sDataLocation = this.m_sDataLocation;
        discretizeDataSource.m_userSchemaName = this.m_userSchemaName;
        discretizeDataSource.m_resultViewName = this.m_resultViewName;
        discretizeDataSource.m_bRemoveResultView = this.m_bRemoveResultView;
        discretizeDataSource.m_samplingTableName = this.m_samplingTableName;
        discretizeDataSource.m_attributeMapping = this.m_attributeMapping;
        discretizeDataSource.m_valueMapping = this.m_valueMapping;
        discretizeDataSource.m_seqIdMapping = this.m_seqIdMapping;
        discretizeDataSource.m_isTransactional = this.m_isTransactional;
        discretizeDataSource.m_bSingleMetric = this.m_bSingleMetric;
        discretizeDataSource.m_numericalDiscretizationTableName = this.m_numericalDiscretizationTableName;
        discretizeDataSource.m_categoricalDiscretizationTableName = this.m_categoricalDiscretizationTableName;
        discretizeDataSource.m_txSampledViewDefinition = this.m_txSampledViewDefinition;
        discretizeDataSource.m_txViewDefinition = this.m_txViewDefinition;
        discretizeDataSource.m_preferences = this.m_preferences;
        discretizeDataSource.m_sampling2DView = this.m_sampling2DView;
        discretizeDataSource.m_samplingTXView = this.m_samplingTXView;
    }

    public DiscretizeDataSource(Connection connection, DiscretizationLDSDataSource discretizationLDSDataSource, String string, String string2, String string3, String string4) throws Exception {
        super(connection);
        m_bLabels = this.m_preferences.getBooleanValue("DISCRETIZATION_STRING");
        this.m_lds = discretizationLDSDataSource;
        this.m_tableName = string;
        this.m_dataSourceSchemaName = string2;
        this.m_userSchemaName = string3;
        if (string4 == null) {
            this.m_resultViewName = ValidationUtil.createUniqueTableName(RESULT_VIEW_NAME, connection, "");
            this.m_bRemoveResultView = true;
        } else {
            this.m_resultViewName = string4;
        }
        this.m_sDataLocation = "\"" + string2 + "\".\"" + string + "\"";
        this.m_samplingTableName = ValidationUtil.createUniqueTableName(SAMPLING_TABLE_PREFIX, connection, "");
        this.getSampledDataLocation();
    }

    protected void createSamplingTable(Connection connection, String string) throws SQLException {
        DM4JTransformation.createSamplingTable(connection, this.getSamplingTableLocation(), string);
    }

    public String getSampledDataLocationSM() {
        if (this.m_sampling2DView == null) {
            this.m_sampling2DView = this.m_lds.getSamplingViewDefinition();
        }
        return this.m_sampling2DView;
    }

    public String getSampledDataLocation() {
        if (this.m_isTransactional) {
            if (this.m_bSingleMetric) {
                return this.getSampledDataLocationSM();
            }
            return this.getSamplingTXNViewDefinition();
        }
        return this.getSamplingViewDefinition();
    }

    public String getSamplingViewDefinition() {
        if (this.m_sampling2DView != null) {
            return this.m_sampling2DView;
        }
        Vector vector = new Vector();
        if (this.m_lds != null) {
            vector = this.m_lds.getAttributes(false, false);
        } else if (!this.m_tableColumns.isEmpty()) {
            vector = this.m_tableColumns;
        }
        if (vector.isEmpty()) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < vector.size(); ++i) {
            stringBuffer.append("\"" + (String)vector.elementAt(i) + "\"");
            if (i >= vector.size() - 1) continue;
            stringBuffer.append(",\n");
        }
        if (this.m_lds != null && this.m_lds.getCaseCount() != -1) {
            Object[] objectArray = new String[]{stringBuffer.toString(), this.getOriginalDataLocation(), String.valueOf(this.m_preferences.getSampleSize()), String.valueOf(this.m_lds.getCaseCount())};
            this.m_sampling2DView = MessageFormat.format(SQL_SAMPLING_VIEW_KNOWN_COUNT, objectArray);
        } else {
            Object[] objectArray = new String[]{stringBuffer.toString(), this.getOriginalDataLocation(), String.valueOf(this.m_preferences.getSampleSize())};
            this.m_sampling2DView = MessageFormat.format(SQL_SAMPLING_VIEW, objectArray);
        }
        return this.m_sampling2DView;
    }

    protected String getSamplingTXNViewDefinition() {
        return this.m_sDataLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishCleanUp() {
        try {
            this.clearMap();
            this.m_tableColumns.clear();
            DM4JTransformation.dropDatabaseObject(this.m_samplingTableName, this.m_userSchemaName, "TABLE", false, DiscretizeDataSource.isDebug());
            if (this.m_bRemoveResultView) {
                DM4JTransformation.dropDatabaseObject(this.m_resultViewName, this.m_userSchemaName, "VIEW", false, DiscretizeDataSource.isDebug());
                DM4JTransformation.dropDatabaseObject(this.m_originalResultViewName, this.m_userSchemaName, "VIEW", false, DiscretizeDataSource.isDebug());
            }
            this.removeRows(0, this.getRowCount());
            if (this.m_rowModel != null) {
                this.m_rowModel.removeItems(0, this.m_rowModel.getItemCount());
            }
        }
        catch (Exception exception) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortCleanUp() {
        try {
            this.clearMap();
            this.m_tableColumns.clear();
            DM4JTransformation.dropDatabaseObject(this.m_numericalDiscretizationTableName, this.m_userSchemaName, "TABLE", true, DiscretizeDataSource.isDebug());
            DM4JTransformation.dropDatabaseObject(this.m_categoricalDiscretizationTableName, this.m_userSchemaName, "TABLE", true, DiscretizeDataSource.isDebug());
            DM4JTransformation.dropDatabaseObject(this.m_samplingTableName, this.m_userSchemaName, "TABLE", false, DiscretizeDataSource.isDebug());
            if (this.m_bRemoveResultView) {
                DM4JTransformation.dropDatabaseObject(this.m_resultViewName, this.m_userSchemaName, "VIEW", false, DiscretizeDataSource.isDebug());
                DM4JTransformation.dropDatabaseObject(this.m_originalResultViewName, this.m_userSchemaName, "VIEW", false, DiscretizeDataSource.isDebug());
            }
            this.removeRows(0, this.getRowCount());
            if (this.m_rowModel != null) {
                this.m_rowModel.removeItems(0, this.m_rowModel.getItemCount());
            }
        }
        catch (Exception exception) {}
    }

    public String getOriginalDataLocation() {
        return this.m_sDataLocation;
    }

    protected String getSrcTableName() {
        return this.m_tableName;
    }

    protected String getSrcSchemaName() {
        return this.m_dataSourceSchemaName;
    }

    public String getDataSource() {
        return this.m_dataSourceSchemaName + "." + this.m_tableName;
    }

    protected ArrayOneDModel createColumns() throws Exception {
        this.addColumns(0, COLUMN_COUNT);
        return new ArrayOneDModel((Object[])items);
    }

    protected void createData() throws Exception {
        if (this.m_isTransactional && !this.m_bSingleMetric) {
            this.createDataFromTXSource();
        } else {
            this.createDataFrom2DSource();
        }
        if (this.isDefaultProcessing()) {
            this.performDefaultTreatment();
        }
        this.callCreateData();
    }

    public void performDefaultTreatment() {
        if (this.m_context != null && this.m_context.getLaunchPoint() == LaunchPoint.ACTIVITY_GUIDE) {
            this.doDefaultTreatment();
        }
    }

    protected void doDefaultTreatment() {
        if (this.m_bAutoRun) {
            return;
        }
        DiscretizePredefinedNumericTreatment discretizePredefinedNumericTreatment = new DiscretizePredefinedNumericTreatment(this);
        discretizePredefinedNumericTreatment.processAttributes(this.m_context.getActivity().getType());
    }

    public void restoreDefaultTreatment() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.markAttributeUnBinned(i);
        }
        this.doDefaultTreatment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createDataFromTXSourceWithoutLDS() throws Exception {
        Object object;
        Hashtable hashtable = this.getMiningTypeTX();
        String string = null;
        String string2 = "SELECT \"" + this.m_valueMapping + "\" " + " FROM " + this.getSampledDataLocation();
        Statement statement = null;
        ResultSet resultSet = null;
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2);
            object = resultSet.getMetaData();
            string = object.getColumnTypeName(1);
        }
        catch (Exception exception) {
        }
        finally {
            resultSet.close();
            statement.close();
        }
        object = "SELECT DISTINCT \"" + this.m_attributeMapping + "\" " + " FROM " + this.getSampledDataLocation();
        Statement statement2 = null;
        ResultSet resultSet2 = null;
        try {
            int n = 0;
            Vector<String> vector = new Vector<String>();
            Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>();
            statement2 = connection.createStatement();
            resultSet2 = statement2.executeQuery((String)object);
            while (resultSet2.next()) {
                String string3 = resultSet2.getString(1);
                if (this.m_collectColumnNames) {
                    this.m_tableColumns.add(string3);
                }
                if (0 != string.compareTo("NUMBER")) continue;
                DataInfo dataInfo = null;
                dataInfo = (DataInfo)hashtable.get(string3);
                if (dataInfo == null) continue;
                this.addRows(++n - 1, 1);
                this.setAttributeName(n - 1, string3);
                this.setMiningType(n - 1, dataInfo.m_AttrType);
                this.setData(COLUMN_NAMES.DTYPE, n - 1, dataInfo.m_DataType);
                this.setBinTypeNONE(n - 1);
                this.setNumberOfBins(n - 1);
                this.setData(COLUMN_NAMES.TAILPERCENT, n - 1, null);
                this.setViewDefinition(n - 1, null);
                this.setDisplayNames(n - 1, null);
                this.setData(COLUMN_NAMES.SKEW, n - 1, null);
                this.setData(COLUMN_NAMES.KURT, n - 1, null);
                vector.add(string3);
                hashtable2.put(string3, new Integer(n - 1));
            }
            this.addNumericStatsTX(connection, hashtable2, this.m_sDataLocation);
            hashtable2.clear();
            vector.clear();
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            try {
                resultSet2.close();
                statement2.close();
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    protected void createDataFromTXSource() throws Exception {
        if (this.m_lds == null) {
            this.createDataFromTXSourceWithoutLDS();
            return;
        }
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            if (this.m_collectColumnNames) {
                this.m_tableColumns = this.m_lds.getAllAttributes();
            }
            int n = 0;
            Vector vector = this.m_lds.getNonUniqueAttributes();
            Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
            for (int i = 0; i < vector.size(); ++i) {
                String string = (String)vector.elementAt(i);
                String string2 = this.m_lds.getMiningType(string);
                AttributeType attributeType = (AttributeType)m_AttributeType.get(string2);
                if (attributeType == null || !attributeType.equals(AttributeType.numerical)) continue;
                this.addRows(++n - 1, 1);
                this.setAttributeName(n - 1, string);
                this.setMiningType(n - 1, this.m_lds.getMiningType(string));
                this.setData(COLUMN_NAMES.DTYPE, n - 1, this.m_lds.getDataType(string));
                this.setBinTypeNONE(n - 1);
                this.setNumberOfBins(n - 1);
                this.setData(COLUMN_NAMES.TAILPERCENT, n - 1, null);
                this.setViewDefinition(n - 1, null);
                this.setDisplayNames(n - 1, null);
                this.setData(COLUMN_NAMES.SKEW, n - 1, null);
                this.setData(COLUMN_NAMES.KURT, n - 1, null);
                hashtable.put(string, new Integer(n - 1));
            }
            this.addNumericStatsTX(connection, hashtable, this.m_sDataLocation);
            hashtable.clear();
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createDataFrom2DSource() throws Exception {
        if (this.m_lds == null) {
            this.createDataFrom2DSourceWithoutLDS();
            return;
        }
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            if (this.m_collectColumnNames) {
                this.m_tableColumns = this.m_lds.getAllAttributes();
            }
            int n = 0;
            Vector vector = this.m_lds.getNonUniqueAttributes();
            Vector<String> vector2 = new Vector<String>();
            Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
            boolean bl = false;
            if (this.m_context != null && this.m_context.getLaunchPoint() == LaunchPoint.ACTIVITY_GUIDE) {
                bl = true;
            }
            for (int i = 0; i < vector.size(); ++i) {
                String string = (String)vector.elementAt(i);
                String string2 = this.m_lds.getMiningType(string);
                AttributeType attributeType = (AttributeType)m_AttributeType.get(string2);
                if (attributeType == null || !attributeType.equals(AttributeType.numerical)) continue;
                String string3 = this.m_lds.getDataType(string);
                if (!bl && (string3 == null || string3.equals("DM_NESTED_NUMERICALS"))) continue;
                this.addRows(++n - 1, 1);
                this.setAttributeName(n - 1, string);
                this.setMiningType(n - 1, string2);
                this.setData(COLUMN_NAMES.DTYPE, n - 1, string3);
                this.setBinTypeNONE(n - 1);
                this.setNumberOfBins(n - 1);
                this.setData(COLUMN_NAMES.TAILPERCENT, n - 1, null);
                this.setViewDefinition(n - 1, null);
                this.setDisplayNames(n - 1, null);
                this.setData(COLUMN_NAMES.SKEW, n - 1, null);
                this.setData(COLUMN_NAMES.KURT, n - 1, null);
                vector2.add(this.getColumnName(string));
                hashtable.put(this.getColumnName(string), new Integer(n - 1));
            }
            this.addNumericStats2D(connection, vector2, hashtable, null);
            hashtable.clear();
            vector2.clear();
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createDataFrom2DSourceWithoutLDS() throws Exception {
        Hashtable hashtable = this.getMiningType2D();
        Statement statement = null;
        ResultSet resultSet = null;
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            String string = "SELECT column_name, data_type FROM all_tab_columns WHERE owner = '" + this.m_dataSourceSchemaName + "' and table_name = '" + TransformsDirector.getReplacedString(this.m_tableName, "'", "''") + "'";
            statement = connection.prepareStatement(string);
            resultSet = statement.executeQuery();
            int n = 0;
            Vector<String> vector = new Vector<String>();
            Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>();
            while (resultSet.next()) {
                String string2 = resultSet.getString("DATA_TYPE");
                String string3 = resultSet.getString("COLUMN_NAME");
                if (this.m_collectColumnNames) {
                    this.m_tableColumns.add(string3);
                }
                if (0 != string2.compareTo("NUMBER")) continue;
                DataInfo dataInfo = null;
                dataInfo = (DataInfo)hashtable.get(string3);
                if (dataInfo == null) continue;
                this.addRows(++n - 1, 1);
                this.setAttributeName(n - 1, string3);
                this.setMiningType(n - 1, dataInfo.m_AttrType);
                this.setData(COLUMN_NAMES.DTYPE, n - 1, dataInfo.m_DataType);
                this.setBinTypeNONE(n - 1);
                this.setNumberOfBins(n - 1);
                this.setData(COLUMN_NAMES.TAILPERCENT, n - 1, null);
                this.setViewDefinition(n - 1, null);
                this.setDisplayNames(n - 1, null);
                this.setData(COLUMN_NAMES.SKEW, n - 1, null);
                this.setData(COLUMN_NAMES.KURT, n - 1, null);
                vector.add(string3);
                hashtable2.put(string3, new Integer(n - 1));
            }
            this.addNumericStats2D(connection, vector, hashtable2, null);
            hashtable2.clear();
            vector.clear();
        }
        catch (Exception exception) {
        }
        finally {
            try {
                resultSet.close();
                statement.close();
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getEqualWidthStdevCountTX(Connection connection, String string, String string2) {
        Statement statement = null;
        ResultSet resultSet = null;
        Object[] objectArray = new String[]{"\"" + this.m_valueMapping + "\"", string2 == null ? this.getSampledDataLocation() : string2, "\"" + this.m_attributeMapping + "\"", "'" + string + "'"};
        String string3 = MessageFormat.format(STAT_SQL_EQ_WIDTH_STDEV_COUNT_TX, objectArray);
        double[] dArray = new double[NUMBER_STATS];
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            if (resultSet.next()) {
                dArray[DiscretizeDataSource.STAT_TOTAL] = resultSet.getInt("N");
                dArray[DiscretizeDataSource.STAT_VARIANCE] = resultSet.getDouble("Variance");
                dArray[DiscretizeDataSource.STAT_STDEV] = Math.sqrt(dArray[STAT_VARIANCE]);
            }
        }
        catch (Exception exception) {
            dArray = null;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getEqualWidthStdevCount(Connection connection, String string, String string2) {
        Statement statement = null;
        ResultSet resultSet = null;
        Object[] objectArray = new Object[]{string, string2 == null ? this.getSampledDataLocation() : string2};
        String string3 = MessageFormat.format(STAT_SQL_EQ_WIDTH_STDEV_COUNT, objectArray);
        double[] dArray = new double[NUMBER_STATS];
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            if (resultSet.next()) {
                dArray[DiscretizeDataSource.STAT_TOTAL] = resultSet.getInt("N");
                dArray[DiscretizeDataSource.STAT_VARIANCE] = resultSet.getDouble("Variance");
                dArray[DiscretizeDataSource.STAT_STDEV] = Math.sqrt(dArray[STAT_VARIANCE]);
            }
        }
        catch (Exception exception) {
            dArray = null;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getEqualWidthStatsTX(Connection connection, String string, String string2) {
        Statement statement = null;
        ResultSet resultSet = null;
        Object[] objectArray = new Object[]{"\"" + this.m_valueMapping + "\"", string2 == null ? this.getSampledDataLocation() : string2, "\"" + this.m_attributeMapping + "\"", "'" + string + "'"};
        String string3 = MessageFormat.format(STAT_SQL_EQ_WIDTH_1ST_ORDER_TX, objectArray);
        double[] dArray = new double[NUMBER_STATS];
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            if (resultSet.next()) {
                dArray[DiscretizeDataSource.STAT_TOTAL] = resultSet.getInt("N");
                dArray[DiscretizeDataSource.STAT_AVERAGE] = resultSet.getDouble("Average");
                dArray[DiscretizeDataSource.STAT_MAX] = resultSet.getDouble("Max");
                dArray[DiscretizeDataSource.STAT_MIN] = resultSet.getDouble("Min");
                dArray[DiscretizeDataSource.STAT_VARIANCE] = resultSet.getDouble("Variance");
                dArray[DiscretizeDataSource.STAT_STDEV] = Math.sqrt(dArray[STAT_VARIANCE]);
            }
        }
        catch (Exception exception) {
            dArray = null;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getEqualWidthStats(Connection connection, String string, String string2) {
        if (this.m_isTransactional && !this.m_bSingleMetric) {
            return this.getEqualWidthStatsTX(connection, string, string2);
        }
        Statement statement = null;
        ResultSet resultSet = null;
        Object[] objectArray = new Object[]{"\"" + this.getColumnName(string) + "\"", string2 == null ? this.getSampledDataLocation() : string2};
        String string3 = MessageFormat.format(STAT_SQL_EQ_WIDTH_1ST_ORDER, objectArray);
        double[] dArray = new double[NUMBER_STATS];
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            if (resultSet.next()) {
                dArray[DiscretizeDataSource.STAT_TOTAL] = resultSet.getInt("N");
                dArray[DiscretizeDataSource.STAT_AVERAGE] = resultSet.getDouble("Average");
                dArray[DiscretizeDataSource.STAT_MAX] = resultSet.getDouble("Max");
                dArray[DiscretizeDataSource.STAT_MIN] = resultSet.getDouble("Min");
                dArray[DiscretizeDataSource.STAT_VARIANCE] = resultSet.getDouble("Variance");
                dArray[DiscretizeDataSource.STAT_STDEV] = Math.sqrt(dArray[STAT_VARIANCE]);
            }
        }
        catch (Exception exception) {
            dArray = null;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getEqualWidthStats(String string, String string2) {
        double[] dArray = new double[NUMBER_STATS];
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            dArray = this.getEqualWidthStats(connection, string, string2);
        }
        catch (Exception exception) {
            dArray = null;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getWinsorizedStdevCountTX(Connection connection, String string, double d) {
        Statement statement = null;
        ResultSet resultSet = null;
        Object[] objectArray = new Object[]{"\"" + this.m_valueMapping + "\"", this.getSampledDataLocation(), DM4JNumericFormat.SQLFormat(d), "\"" + this.m_attributeMapping + "\"", "'" + string + "'"};
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        for (int i = 0; i < STAT_SQL_WINSORIZE_STDEV_COUNT_TX.length; ++i) {
            string2 = MessageFormat.format(STAT_SQL_WINSORIZE_STDEV_COUNT_TX[i], objectArray);
            stringBuffer.append(string2);
        }
        double[] dArray = new double[NUMBER_STATS];
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet.next()) {
                dArray[DiscretizeDataSource.STAT_TOTAL] = resultSet.getInt("N");
                dArray[DiscretizeDataSource.STAT_VARIANCE] = resultSet.getDouble("Variance");
                dArray[DiscretizeDataSource.STAT_STDEV] = Math.sqrt(dArray[STAT_VARIANCE]);
            }
        }
        catch (Exception exception) {
            dArray = null;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getWinsorizedStdevCount(Connection connection, String string, double d) {
        Statement statement = null;
        ResultSet resultSet = null;
        Object[] objectArray = new Object[]{string, this.getSampledDataLocation(), DM4JNumericFormat.SQLFormat(d)};
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        for (int i = 0; i < STAT_SQL_WINSORIZE_STDEV_COUNT.length; ++i) {
            string2 = MessageFormat.format(STAT_SQL_WINSORIZE_STDEV_COUNT[i], objectArray);
            stringBuffer.append(string2);
        }
        double[] dArray = new double[NUMBER_STATS];
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet.next()) {
                dArray[DiscretizeDataSource.STAT_TOTAL] = resultSet.getInt("N");
                dArray[DiscretizeDataSource.STAT_VARIANCE] = resultSet.getDouble("Variance");
                dArray[DiscretizeDataSource.STAT_STDEV] = Math.sqrt(dArray[STAT_VARIANCE]);
            }
        }
        catch (Exception exception) {
            dArray = null;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getWinsorizedStatsTX(Connection connection, String string, double d) {
        Statement statement = null;
        ResultSet resultSet = null;
        Object[] objectArray = new Object[]{"\"" + this.m_valueMapping + "\"", this.getSampledDataLocation(), DM4JNumericFormat.SQLFormat(d), "\"" + this.m_attributeMapping + "\"", "'" + string + "'"};
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        for (int i = 0; i < STAT_SQL_WINSORIZE_1ST_ORDER_TX.length; ++i) {
            string2 = MessageFormat.format(STAT_SQL_WINSORIZE_1ST_ORDER_TX[i], objectArray);
            stringBuffer.append(string2);
        }
        double[] dArray = new double[NUMBER_STATS];
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet.next()) {
                dArray[DiscretizeDataSource.STAT_TOTAL] = resultSet.getInt("N");
                dArray[DiscretizeDataSource.STAT_AVERAGE] = resultSet.getDouble("Average");
                dArray[DiscretizeDataSource.STAT_MAX] = resultSet.getDouble("Max");
                dArray[DiscretizeDataSource.STAT_MIN] = resultSet.getDouble("Min");
                dArray[DiscretizeDataSource.STAT_VARIANCE] = resultSet.getDouble("Variance");
                dArray[DiscretizeDataSource.STAT_STDEV] = Math.sqrt(dArray[STAT_VARIANCE]);
            }
        }
        catch (Exception exception) {
            dArray = null;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getWinsorizedStats(Connection connection, String string, double d) {
        if (this.m_isTransactional && !this.m_bSingleMetric) {
            return this.getWinsorizedStatsTX(connection, string, d);
        }
        Statement statement = null;
        ResultSet resultSet = null;
        Object[] objectArray = new Object[]{"\"" + string + "\"", this.getSampledDataLocation(), DM4JNumericFormat.SQLFormat(d)};
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        for (int i = 0; i < STAT_SQL_WINSORIZE_1ST_ORDER.length; ++i) {
            string2 = MessageFormat.format(STAT_SQL_WINSORIZE_1ST_ORDER[i], objectArray);
            stringBuffer.append(string2);
        }
        double[] dArray = new double[NUMBER_STATS];
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet.next()) {
                dArray[DiscretizeDataSource.STAT_TOTAL] = resultSet.getInt("N");
                dArray[DiscretizeDataSource.STAT_AVERAGE] = resultSet.getDouble("Average");
                dArray[DiscretizeDataSource.STAT_MAX] = resultSet.getDouble("Max");
                dArray[DiscretizeDataSource.STAT_MIN] = resultSet.getDouble("Min");
                dArray[DiscretizeDataSource.STAT_VARIANCE] = resultSet.getDouble("Variance");
                dArray[DiscretizeDataSource.STAT_STDEV] = Math.sqrt(dArray[STAT_VARIANCE]);
            }
        }
        catch (Exception exception) {
            dArray = null;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getCustomStdevCountTX(Connection connection, String string, double d, double d2) {
        Statement statement = null;
        ResultSet resultSet = null;
        Object[] objectArray = new Object[]{"\"" + this.m_valueMapping + "\"", this.getSampledDataLocation(), String.valueOf(d), String.valueOf(d2), "\"" + this.m_attributeMapping + "\"", "'" + string + "'"};
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        for (int i = 0; i < STAT_SQL_CUSTOM_STDEV_COUNT_TX.length; ++i) {
            string2 = MessageFormat.format(STAT_SQL_CUSTOM_STDEV_COUNT_TX[i], objectArray);
            stringBuffer.append(string2);
        }
        double[] dArray = new double[NUMBER_STATS];
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet.next()) {
                dArray[DiscretizeDataSource.STAT_TOTAL] = resultSet.getInt("N");
                dArray[DiscretizeDataSource.STAT_VARIANCE] = resultSet.getDouble("Variance");
                dArray[DiscretizeDataSource.STAT_STDEV] = Math.sqrt(dArray[STAT_VARIANCE]);
            }
        }
        catch (Exception exception) {
            dArray = null;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getCustomStdevCount(Connection connection, String string, double d, double d2) {
        Statement statement = null;
        ResultSet resultSet = null;
        Object[] objectArray = new Object[]{"\"" + string + "\"", this.getSampledDataLocation(), String.valueOf(d), String.valueOf(d2)};
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        for (int i = 0; i < STAT_SQL_CUSTOM_STDEV_COUNT.length; ++i) {
            string2 = MessageFormat.format(STAT_SQL_CUSTOM_STDEV_COUNT[i], objectArray);
            stringBuffer.append(string2);
        }
        double[] dArray = new double[NUMBER_STATS];
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet.next()) {
                dArray[DiscretizeDataSource.STAT_TOTAL] = resultSet.getInt("N");
                dArray[DiscretizeDataSource.STAT_VARIANCE] = resultSet.getDouble("Variance");
                dArray[DiscretizeDataSource.STAT_STDEV] = Math.sqrt(dArray[STAT_VARIANCE]);
            }
        }
        catch (Exception exception) {
            dArray = null;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getCustomStatsTX(Connection connection, String string, double d, double d2) {
        Statement statement = null;
        ResultSet resultSet = null;
        Object[] objectArray = new Object[]{"\"" + this.m_valueMapping + "\"", this.getSampledDataLocation(), "\"" + this.m_attributeMapping + "\"", "'" + string + "'", DM4JNumericFormat.SQLFormat(d), DM4JNumericFormat.SQLFormat(d2)};
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        for (int i = 0; i < STAT_SQL_CUSTOM_1ST_ORDER_TX.length; ++i) {
            string2 = MessageFormat.format(STAT_SQL_CUSTOM_1ST_ORDER_TX[i], objectArray);
            stringBuffer.append(string2);
        }
        double[] dArray = new double[NUMBER_STATS];
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet.next()) {
                dArray[DiscretizeDataSource.STAT_TOTAL] = resultSet.getInt("N");
                dArray[DiscretizeDataSource.STAT_AVERAGE] = resultSet.getDouble("Average");
                dArray[DiscretizeDataSource.STAT_MAX] = resultSet.getDouble("Max");
                dArray[DiscretizeDataSource.STAT_MIN] = resultSet.getDouble("Min");
                dArray[DiscretizeDataSource.STAT_VARIANCE] = resultSet.getDouble("Variance");
                dArray[DiscretizeDataSource.STAT_STDEV] = Math.sqrt(dArray[STAT_VARIANCE]);
            }
        }
        catch (Exception exception) {
            dArray = null;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getCustomStats(Connection connection, String string, double d, double d2) {
        if (this.m_isTransactional && !this.m_bSingleMetric) {
            return this.getCustomStatsTX(connection, string, d, d2);
        }
        Statement statement = null;
        ResultSet resultSet = null;
        Object[] objectArray = new Object[]{"\"" + this.getColumnName(string) + "\"", this.getSampledDataLocation(), DM4JNumericFormat.format(d), DM4JNumericFormat.SQLFormat(d2)};
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        for (int i = 0; i < STAT_SQL_CUSTOM_1ST_ORDER.length; ++i) {
            string2 = MessageFormat.format(STAT_SQL_CUSTOM_1ST_ORDER[i], objectArray);
            stringBuffer.append(string2);
        }
        double[] dArray = new double[NUMBER_STATS];
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet.next()) {
                dArray[DiscretizeDataSource.STAT_TOTAL] = resultSet.getInt("N");
                dArray[DiscretizeDataSource.STAT_AVERAGE] = resultSet.getDouble("Average");
                dArray[DiscretizeDataSource.STAT_MAX] = resultSet.getDouble("Max");
                dArray[DiscretizeDataSource.STAT_MIN] = resultSet.getDouble("Min");
                dArray[DiscretizeDataSource.STAT_VARIANCE] = resultSet.getDouble("Variance");
                dArray[DiscretizeDataSource.STAT_STDEV] = Math.sqrt(dArray[STAT_VARIANCE]);
            }
        }
        catch (Exception exception) {
            dArray = null;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void getEqualWidth2ndorderStatsTX(Connection connection, int n, double[] dArray, String string, String string2) {
        Object object;
        Integer n2 = (Integer)this.getData(COLUMN_NAMES.TOTAL, n);
        Double d = (Double)this.getData(COLUMN_NAMES.STDDEV, n);
        if (n2 == null || d == null) {
            object = this.getEqualWidthStdevCountTX(connection, "\"" + string + "\"", string2);
            dArray[DiscretizeDataSource.STAT_TOTAL] = object[STAT_TOTAL];
            dArray[DiscretizeDataSource.STAT_STDEV] = object[STAT_STDEV];
            dArray[DiscretizeDataSource.STAT_VARIANCE] = object[STAT_VARIANCE];
            this.setData(COLUMN_NAMES.TOTAL, n, new Integer((int)dArray[STAT_TOTAL]));
            this.setData(COLUMN_NAMES.STDDEV, n, new Double(dArray[STAT_STDEV]));
            this.setData(COLUMN_NAMES.VAR, n, new Double(dArray[STAT_VARIANCE]));
        }
        object = null;
        ResultSet resultSet = null;
        Object[] objectArray = new Object[]{String.valueOf(dArray[STAT_AVERAGE]), "\"" + this.m_valueMapping + "\"", String.valueOf((int)dArray[STAT_TOTAL]), String.valueOf(dArray[STAT_STDEV]), string2 == null ? this.getSampledDataLocation() : string2, "\"" + this.m_attributeMapping + "\"", "'" + string + "'"};
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < STAT_SQL_EQ_WIDTH_2ND_ORDER_TX.length; ++i) {
            String string3 = MessageFormat.format(STAT_SQL_EQ_WIDTH_2ND_ORDER_TX[i], objectArray);
            stringBuffer.append(string3);
        }
        if (dArray[STAT_STDEV] != 0.0) {
            try {
                object = connection.createStatement();
                resultSet = object.executeQuery(stringBuffer.toString());
                if (!resultSet.next()) return;
                double d2 = resultSet.getDouble("Skew");
                double d3 = resultSet.getDouble("Kurtosis");
                this.setKurtosis(n, new Double(d3));
                this.setSkew(n, new Double(d2));
                return;
            }
            catch (Exception exception) {
                return;
            }
            finally {
                try {
                    resultSet.close();
                    object.close();
                }
                catch (Exception exception) {}
            }
        }
        this.setKurtosis(n, new Double(0.0));
        this.setSkew(n, new Double(0.0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void getEqualWidth2ndorderStats(Connection connection, int n, double[] dArray, String string, String string2) {
        Object object;
        if (this.m_isTransactional && !this.m_bSingleMetric) {
            this.getEqualWidth2ndorderStatsTX(connection, n, dArray, string, string2);
            return;
        }
        Integer n2 = (Integer)this.getData(COLUMN_NAMES.TOTAL, n);
        Double d = (Double)this.getData(COLUMN_NAMES.STDDEV, n);
        if (n2 == null || d == null) {
            object = this.getEqualWidthStdevCount(connection, "\"" + this.getColumnName(string) + "\"", string2);
            dArray[DiscretizeDataSource.STAT_TOTAL] = object[STAT_TOTAL];
            dArray[DiscretizeDataSource.STAT_STDEV] = object[STAT_STDEV];
            dArray[DiscretizeDataSource.STAT_VARIANCE] = object[STAT_VARIANCE];
            this.setData(COLUMN_NAMES.TOTAL, n, new Integer((int)dArray[STAT_TOTAL]));
            this.setData(COLUMN_NAMES.STDDEV, n, new Double(dArray[STAT_STDEV]));
            this.setData(COLUMN_NAMES.VAR, n, new Double(dArray[STAT_VARIANCE]));
        }
        object = null;
        ResultSet resultSet = null;
        Object[] objectArray = new Object[]{String.valueOf(dArray[STAT_AVERAGE]), "\"" + this.getColumnName(string) + "\"", String.valueOf((int)dArray[STAT_TOTAL]), String.valueOf(dArray[STAT_STDEV]), string2 == null ? this.getSampledDataLocation() : string2};
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < STAT_SQL_EQ_WIDTH_2ND_ORDER.length; ++i) {
            String string3 = MessageFormat.format(STAT_SQL_EQ_WIDTH_2ND_ORDER[i], objectArray);
            stringBuffer.append(string3);
        }
        if (dArray[STAT_STDEV] != 0.0) {
            try {
                object = connection.createStatement();
                resultSet = object.executeQuery(stringBuffer.toString());
                if (!resultSet.next()) return;
                double d2 = resultSet.getDouble("Skew");
                double d3 = resultSet.getDouble("Kurtosis");
                this.setKurtosis(n, new Double(d3));
                this.setSkew(n, new Double(d2));
                return;
            }
            catch (Exception exception) {
                return;
            }
            finally {
                try {
                    resultSet.close();
                    object.close();
                }
                catch (Exception exception) {}
            }
        }
        this.setKurtosis(n, new Double(0.0));
        this.setSkew(n, new Double(0.0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getCustom2ndorderStatsTX(Connection connection, int n, double[] dArray, String string, double d, double d2) {
        Object object;
        Integer n2 = (Integer)this.getData(COLUMN_NAMES.TOTAL, n);
        Double d3 = (Double)this.getData(COLUMN_NAMES.STDDEV, n);
        if (n2 == null || d3 == null) {
            object = this.getCustomStdevCountTX(connection, "\"" + string + "\"", d, d2);
            dArray[DiscretizeDataSource.STAT_TOTAL] = object[STAT_TOTAL];
            dArray[DiscretizeDataSource.STAT_STDEV] = object[STAT_STDEV];
            dArray[DiscretizeDataSource.STAT_VARIANCE] = object[STAT_VARIANCE];
            this.setData(COLUMN_NAMES.TOTAL, n, new Integer((int)dArray[STAT_TOTAL]));
            this.setData(COLUMN_NAMES.STDDEV, n, new Double(dArray[STAT_STDEV]));
            this.setData(COLUMN_NAMES.VAR, n, new Double(dArray[STAT_VARIANCE]));
        }
        object = null;
        ResultSet resultSet = null;
        Object[] objectArray = new Object[]{String.valueOf(dArray[STAT_AVERAGE]), "\"" + this.m_valueMapping + "\"", String.valueOf((int)dArray[STAT_TOTAL]), String.valueOf(dArray[STAT_STDEV]), this.getSampledDataLocation(), String.valueOf(d), String.valueOf(d2), "\"" + this.m_attributeMapping + "\"", "'" + string + "'"};
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < STAT_SQL_CUSTOM_2ND_ORDER_TX.length; ++i) {
            String string2 = MessageFormat.format(STAT_SQL_CUSTOM_2ND_ORDER_TX[i], objectArray);
            stringBuffer.append(string2);
        }
        try {
            object = connection.createStatement();
            resultSet = object.executeQuery(stringBuffer.toString());
            if (resultSet.next()) {
                double d4 = resultSet.getDouble("Skew");
                double d5 = resultSet.getDouble("Kurtosis");
                this.setKurtosis(n, new Double(d5));
                this.setSkew(n, new Double(d4));
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                resultSet.close();
                object.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getCustom2ndorderStats(Connection connection, int n, double[] dArray, String string, double d, double d2) {
        Object object;
        if (this.m_isTransactional && !this.m_bSingleMetric) {
            this.getCustom2ndorderStatsTX(connection, n, dArray, string, d, d2);
            return;
        }
        Integer n2 = (Integer)this.getData(COLUMN_NAMES.TOTAL, n);
        Double d3 = (Double)this.getData(COLUMN_NAMES.STDDEV, n);
        if (n2 == null || d3 == null) {
            object = this.getCustomStdevCount(connection, "\"" + this.getColumnName(string) + "\"", d, d2);
            dArray[DiscretizeDataSource.STAT_TOTAL] = object[STAT_TOTAL];
            dArray[DiscretizeDataSource.STAT_STDEV] = object[STAT_STDEV];
            dArray[DiscretizeDataSource.STAT_VARIANCE] = object[STAT_VARIANCE];
            this.setData(COLUMN_NAMES.TOTAL, n, new Integer((int)dArray[STAT_TOTAL]));
            this.setData(COLUMN_NAMES.STDDEV, n, new Double(dArray[STAT_STDEV]));
            this.setData(COLUMN_NAMES.VAR, n, new Double(dArray[STAT_VARIANCE]));
        }
        object = null;
        ResultSet resultSet = null;
        Object[] objectArray = new Object[]{String.valueOf(dArray[STAT_AVERAGE]), "\"" + this.getColumnName(string) + "\"", String.valueOf((int)dArray[STAT_TOTAL]), String.valueOf(dArray[STAT_STDEV]), this.getSampledDataLocation(), String.valueOf(d), String.valueOf(d2)};
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < STAT_SQL_CUSTOM_2ND_ORDER.length; ++i) {
            String string2 = MessageFormat.format(STAT_SQL_CUSTOM_2ND_ORDER[i], objectArray);
            stringBuffer.append(string2);
        }
        try {
            object = connection.createStatement();
            resultSet = object.executeQuery(stringBuffer.toString());
            if (resultSet.next()) {
                double d4 = resultSet.getDouble("Skew");
                double d5 = resultSet.getDouble("Kurtosis");
                this.setKurtosis(n, new Double(d5));
                this.setSkew(n, new Double(d4));
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                resultSet.close();
                object.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getWinsorized2ndorderStatsTX(Connection connection, int n, double[] dArray, String string, double d) {
        Object object;
        Integer n2 = (Integer)this.getData(COLUMN_NAMES.TOTAL, n);
        Double d2 = (Double)this.getData(COLUMN_NAMES.STDDEV, n);
        if (n2 == null || d2 == null) {
            object = this.getWinsorizedStdevCountTX(connection, string, this.getTailPercent(n));
            dArray[DiscretizeDataSource.STAT_TOTAL] = object[STAT_TOTAL];
            dArray[DiscretizeDataSource.STAT_STDEV] = object[STAT_STDEV];
            dArray[DiscretizeDataSource.STAT_VARIANCE] = object[STAT_VARIANCE];
            this.setData(COLUMN_NAMES.TOTAL, n, new Integer((int)dArray[STAT_TOTAL]));
            this.setData(COLUMN_NAMES.STDDEV, n, new Double(dArray[STAT_STDEV]));
            this.setData(COLUMN_NAMES.VAR, n, new Double(dArray[STAT_VARIANCE]));
        }
        object = null;
        ResultSet resultSet = null;
        Object[] objectArray = new Object[]{String.valueOf(dArray[STAT_AVERAGE]), "'" + string + "'", String.valueOf((int)dArray[STAT_TOTAL]), String.valueOf(dArray[STAT_STDEV]), this.getSampledDataLocation(), String.valueOf(d), "\"" + this.m_valueMapping + "\"", "\"" + this.m_attributeMapping + "\""};
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        for (int i = 0; i < STAT_SQL_WINSORIZE_2ND_ORDER_TX.length; ++i) {
            string2 = MessageFormat.format(STAT_SQL_WINSORIZE_2ND_ORDER_TX[i], objectArray);
            stringBuffer.append(string2);
        }
        try {
            object = connection.createStatement();
            resultSet = object.executeQuery(stringBuffer.toString());
            if (resultSet.next()) {
                double d3 = resultSet.getDouble("Skew");
                double d4 = resultSet.getDouble("Kurtosis");
                this.setKurtosis(n, new Double(d4));
                this.setSkew(n, new Double(d3));
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                resultSet.close();
                object.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getWinsorized2ndorderStats(Connection connection, int n, double[] dArray, String string, double d) {
        Object object;
        if (this.m_isTransactional && !this.m_bSingleMetric) {
            this.getWinsorized2ndorderStatsTX(connection, n, dArray, string, d);
            return;
        }
        Integer n2 = (Integer)this.getData(COLUMN_NAMES.TOTAL, n);
        Double d2 = (Double)this.getData(COLUMN_NAMES.STDDEV, n);
        if (n2 == null || d2 == null) {
            object = this.getWinsorizedStdevCount(connection, string, this.getTailPercent(n));
            dArray[DiscretizeDataSource.STAT_TOTAL] = object[STAT_TOTAL];
            dArray[DiscretizeDataSource.STAT_STDEV] = object[STAT_STDEV];
            dArray[DiscretizeDataSource.STAT_VARIANCE] = object[STAT_VARIANCE];
            this.setData(COLUMN_NAMES.TOTAL, n, new Integer((int)dArray[STAT_TOTAL]));
            this.setData(COLUMN_NAMES.STDDEV, n, new Double(dArray[STAT_STDEV]));
            this.setData(COLUMN_NAMES.VAR, n, new Double(dArray[STAT_VARIANCE]));
        }
        object = null;
        ResultSet resultSet = null;
        Object[] objectArray = new Object[]{String.valueOf(dArray[STAT_AVERAGE]), "\"" + string + "\"", String.valueOf((int)dArray[STAT_TOTAL]), String.valueOf(dArray[STAT_STDEV]), this.getSampledDataLocation(), String.valueOf(d)};
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        for (int i = 0; i < STAT_SQL_WINSORIZE_2ND_ORDER.length; ++i) {
            string2 = MessageFormat.format(STAT_SQL_WINSORIZE_2ND_ORDER[i], objectArray);
            stringBuffer.append(string2);
        }
        try {
            object = connection.createStatement();
            resultSet = object.executeQuery(stringBuffer.toString());
            if (resultSet.next()) {
                double d3 = resultSet.getDouble("Skew");
                double d4 = resultSet.getDouble("Kurtosis");
                this.setKurtosis(n, new Double(d4));
                this.setSkew(n, new Double(d3));
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                resultSet.close();
                object.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getNumericFrequencyTX(Connection connection, String string, int n, String string2) {
        Comparable<StringBuffer> comparable;
        String string3;
        Statement statement = null;
        ResultSet resultSet = null;
        int[] nArray = null;
        Object var8_8 = null;
        Vector<Integer> vector = new Vector<Integer>();
        Vector<String> vector2 = new Vector<String>();
        int n2 = 0;
        this.m_nullCount = 0;
        try {
            String string4;
            string3 = MessageFormat.format(HISTOGRAM_VALUES_TX[0], "\"" + this.m_valueMapping + "\"", "\"" + string + "\"");
            comparable = new StringBuffer("select * from (");
            ((StringBuffer)comparable).append(string3);
            ((StringBuffer)comparable).append(string2);
            try {
                string4 = TransformsDirector.getReplacedString(string, "'", "''");
            }
            catch (Exception exception) {
                string4 = string;
            }
            string3 = MessageFormat.format(HISTOGRAM_VALUES_TX[1], "\"" + this.m_valueMapping + "\"", "'" + string4 + "'", "\"" + this.m_attributeMapping + "\"");
            ((StringBuffer)comparable).append(string3);
            ((StringBuffer)comparable).append("\n) where  BIN_NUMBER is not null");
            statement = connection.createStatement();
            resultSet = statement.executeQuery(((StringBuffer)comparable).toString());
            while (resultSet.next()) {
                String string5 = resultSet.getString("BIN_NUMBER");
                int n3 = resultSet.getInt("FREQUENCY");
                if (string5 != null) {
                    ++n2;
                    vector.add(new Integer(n3));
                    vector2.add(string5);
                    continue;
                }
                this.m_nullCount = n3;
            }
        }
        catch (Exception exception) {
            nArray = null;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
        if (vector == null || vector.isEmpty()) {
            return null;
        }
        this.setNumberOfNonNulls(n, n2);
        this.setBinCategories(n, vector2);
        if (!this.isAttributeBinned(n)) {
            this.setNumberOfBins(n, n2);
            string3 = this.getBinType(n);
            this.setBinType(n, string3, n2);
        }
        nArray = new int[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            comparable = (Integer)vector.elementAt(i);
            nArray[i] = (Integer)comparable;
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getNumericFrequency(Connection connection, String string, int n, boolean bl) {
        String string2;
        Serializable serializable;
        Object object;
        if (!this.isNumeric(n)) {
            return this.getCategoricAttributeFrequency(connection, n, string, this.getSampledDataLocation());
        }
        if (this.m_isTransactional && !this.m_bSingleMetric) {
            int n2 = this.m_txSampledViewDefinition.indexOf(_SELECT);
            String string3 = this.m_txSampledViewDefinition.substring(n2);
            return this.getNumericFrequencyTX(connection, string, n, string3);
        }
        Statement statement = null;
        ResultSet resultSet = null;
        int[] nArray = null;
        StringBuffer stringBuffer = null;
        Vector<Integer> vector = new Vector<Integer>();
        Vector<String> vector2 = new Vector<String>();
        int n3 = 0;
        this.m_nullCount = 0;
        try {
            stringBuffer = this.getViewDefinition(n);
            if (stringBuffer == null) {
                stringBuffer = this.getSingleNumericAttributeViewDefinition(connection, n, bl);
            }
            if (stringBuffer == null) {
                int[] nArray2 = nArray;
                return nArray2;
            }
            object = null;
            object = !this.isLabels() ? MessageFormat.format(HISTOGRAM_VALUES[0], "\"" + this.getColumnName(string) + "\"") : MessageFormat.format(HISTOGRAM_VALUES_LABELS[0], "\"" + this.getColumnName(string) + "\"", this.prepareDecodeSatement(n));
            serializable = new StringBuffer((String)object);
            int n4 = stringBuffer.toString().indexOf("SELECT");
            StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.substring(n4));
            ((StringBuffer)serializable).append(stringBuffer2);
            object = !this.isLabels() ? MessageFormat.format(HISTOGRAM_VALUES[1], "\"" + this.getColumnName(string) + "\"") : MessageFormat.format(HISTOGRAM_VALUES_LABELS[1], "\"" + this.getColumnName(string) + "\"");
            ((StringBuffer)serializable).append((String)object);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(((StringBuffer)serializable).toString());
            int n5 = -1;
            String string4 = null;
            while (resultSet.next()) {
                string2 = resultSet.getString("BIN_NUMBER");
                int n6 = resultSet.getInt("FREQUENCY");
                if (string2 != null) {
                    if (-1 != string2.indexOf(">=")) {
                        n5 = n6;
                        string4 = string2;
                        continue;
                    }
                    ++n3;
                    vector.add(new Integer(n6));
                    vector2.add(string2);
                    continue;
                }
                this.m_nullCount = n6;
            }
            if (n5 != -1) {
                ++n3;
                vector.add(new Integer(n5));
                vector2.add(string4);
            }
        }
        catch (Exception exception) {
            nArray = null;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
        if (vector == null || vector.isEmpty()) {
            return null;
        }
        object = this.getAllCategorytoRangeList(n);
        serializable = new Vector();
        Integer[] integerArray = null;
        if (object != null && !((Vector)object).isEmpty()) {
            int n7;
            integerArray = new Integer[((Vector)object).size()];
            for (n7 = 0; n7 < ((Vector)object).size(); ++n7) {
                integerArray[n7] = 0;
                ((Vector)serializable).add(DM4JStringUtils.trimSingleQuotes((String)((Vector)object).elementAt(n7)));
            }
            block16: for (n7 = 0; n7 < ((Vector)serializable).size(); ++n7) {
                String string5 = (String)((Vector)serializable).elementAt(n7);
                for (int i = 0; i < vector2.size(); ++i) {
                    string2 = (String)vector2.elementAt(i);
                    if (!string2.equals(string5)) continue;
                    integerArray[n7] = (Integer)vector.elementAt(i);
                    continue block16;
                }
            }
        }
        if (serializable != null) {
            this.setNumberOfNonNulls(n, ((Vector)serializable).size());
            this.setBinCategories(n, new Vector(serializable));
        } else {
            this.setNumberOfNonNulls(n, n3);
            this.setBinCategories(n, vector2);
        }
        if (!this.isAttributeBinned(n)) {
            this.setNumberOfBins(n, n3);
            String string6 = this.getBinType(n);
            this.setBinType(n, string6, n3);
        }
        if (integerArray == null) {
            nArray = new int[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                Integer n8 = (Integer)vector.elementAt(i);
                nArray[i] = n8;
            }
        } else {
            nArray = new int[integerArray.length];
            for (int i = 0; i < integerArray.length; ++i) {
                Integer n9 = integerArray[i];
                nArray[i] = n9;
            }
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Hashtable getMiningType2D() throws SQLException, Exception {
        String string = "SELECT c.COLUMN_NAME, c.DATA_TYPE, c.DATA_SCALE,c.DATA_PRECISION, c.DATA_LENGTH,con.CONSTRAINT_TYPE FROM all_tab_columns c, (SELECT cn.OWNER, cn.TABLE_NAME, cn.COLUMN_NAME, cd.CONSTRAINT_TYPE FROM all_cons_columns cn, all_constraints cd WHERE cn.OWNER = cd.OWNER AND cn.TABLE_NAME = cd.TABLE_NAME AND cn.CONSTRAINT_NAME = cd.CONSTRAINT_NAME AND 'P' = cd.CONSTRAINT_TYPE AND 'ENABLED' = cd.STATUS) con WHERE c.OWNER = '" + this.m_dataSourceSchemaName + "' AND " + "c.TABLE_NAME = '" + TransformsDirector.getReplacedString(this.m_tableName, "'", "''") + "' AND " + "c.OWNER = con.OWNER(+) AND " + "c.TABLE_NAME = con.TABLE_NAME(+) AND " + "c.COLUMN_NAME = con.COLUMN_NAME(+) " + "ORDER BY column_name ASC";
        Hashtable<String, DataInfo> hashtable = new Hashtable<String, DataInfo>();
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            callableStatement = connection.prepareCall(string);
            resultSet = callableStatement.executeQuery();
            int n = 0;
            boolean bl = false;
            while (resultSet.next()) {
                String string2;
                String string3;
                String string4 = resultSet.getString("COLUMN_NAME");
                String string5 = resultSet.getString("DATA_TYPE");
                int n2 = resultSet.getInt("DATA_SCALE");
                int n3 = resultSet.getInt("DATA_PRECISION");
                int n4 = resultSet.getInt("DATA_LENGTH");
                String string6 = resultSet.getString("CONSTRAINT_TYPE");
                Object var16_16 = null;
                if (string5.compareTo("NUMBER") == 0) {
                    string3 = "numerical";
                    string2 = string5;
                } else if (string5.compareTo("VARCHAR2") == 0 || string5.compareTo("CHAR") == 0 || string5.compareTo("NVARCHAR2") == 0 || string5.compareTo("NCHAR") == 0) {
                    string3 = "categorical";
                    string2 = string5;
                } else if (string5.compareTo("FLOAT") == 0) {
                    string3 = "numerical";
                    string2 = string5;
                } else if (this.isTextDataType(string5, connection, this.m_tableName, this.m_dataSourceSchemaName, string4)) {
                    string3 = "text";
                    string2 = string5;
                } else {
                    string2 = "";
                    string3 = "";
                    bl = true;
                }
                if (!bl) {
                    hashtable.put(string4, new DataInfo(string3, string2));
                } else {
                    bl = false;
                }
                ++n;
            }
        }
        finally {
            if (callableStatement != null) {
                callableStatement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        return hashtable;
    }

    protected boolean isTextDataType(String string, Connection connection, String string2, String string3, String string4) throws SQLException, Exception {
        String string5;
        boolean bl = false;
        if (!this.m_acceptsTextData) {
            return bl;
        }
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        String string6 = DM4JConnectionManager.getUser();
        String string7 = TransformsDirector.getReplacedString(string2, "'", "''");
        String string8 = TransformsDirector.getReplacedString(string4, "'", "''");
        String string9 = TransformsDirector.getReplacedString(string3, "'", "''");
        if (DM4JConnectionManager.getUser().equals(string3)) {
            String string10 = "user_indexes";
            String string11 = "user_ind_columns";
            string5 = "select INDEX_NAME, ITYP_NAME from " + string10 + " " + "where ITYP_NAME = 'CONTEXT' AND " + "INDEX_NAME = " + "(select INDEX_NAME from " + string11 + " " + "where TABLE_NAME  = '" + string7 + "' AND " + "COLUMN_NAME = '" + string8 + "')";
        } else {
            String string12 = "all_indexes";
            String string13 = "all_ind_columns";
            string5 = "select INDEX_NAME, ITYP_NAME from " + string12 + " " + "where ITYP_NAME = 'CONTEXT' AND " + "INDEX_NAME = " + "(select INDEX_NAME from " + string13 + " " + "where TABLE_NAME  = '" + string7 + "' AND " + "TABLE_OWNER = '" + string9 + "' AND " + "COLUMN_NAME = '" + string8 + "')";
        }
        if (this.isTextDataType(string) && (resultSet = (callableStatement = connection.prepareCall(string5)).executeQuery()).next()) {
            bl = true;
        }
        return bl;
    }

    protected boolean isTextDataType(String string) {
        return string.compareTo("BFILE") == 0 || string.compareTo("BLOB") == 0 || string.compareTo("CLOB") == 0 || string.compareTo("URITYPE") == 0 || string.compareTo("BLOB") == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Hashtable getMiningTypeTX() throws SQLException, Exception {
        Hashtable<String, DataInfo> hashtable = new Hashtable<String, DataInfo>();
        String string = null;
        String string2 = "SELECT c.COLUMN_NAME, c.DATA_TYPE, c.DATA_SCALE,c.DATA_PRECISION, c.DATA_LENGTH,con.CONSTRAINT_TYPE FROM all_tab_columns c, (SELECT cn.OWNER, cn.TABLE_NAME, cn.COLUMN_NAME, cd.CONSTRAINT_TYPE FROM all_cons_columns cn, all_constraints cd WHERE cn.OWNER = cd.OWNER AND cn.TABLE_NAME = cd.TABLE_NAME AND cn.CONSTRAINT_NAME = cd.CONSTRAINT_NAME AND 'P' = cd.CONSTRAINT_TYPE AND 'ENABLED' = cd.STATUS) con WHERE c.OWNER = ? AND c.TABLE_NAME = ? AND c.OWNER = con.OWNER(+) AND c.TABLE_NAME = con.TABLE_NAME(+) AND c.COLUMN_NAME = con.COLUMN_NAME(+) AND c.COLUMN_NAME = ? ORDER BY column_name ASC";
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            callableStatement = connection.prepareCall(string2);
            int n = 1;
            callableStatement.setString(n++, this.m_dataSourceSchemaName);
            callableStatement.setString(n++, this.m_tableName);
            callableStatement.setString(n++, this.m_valueMapping);
            resultSet = callableStatement.executeQuery();
            boolean bl = false;
            boolean bl2 = false;
            while (resultSet.next()) {
                String string3 = resultSet.getString("COLUMN_NAME");
                String string4 = resultSet.getString("DATA_TYPE");
                int n2 = resultSet.getInt("DATA_SCALE");
                int n3 = resultSet.getInt("DATA_PRECISION");
                int n4 = resultSet.getInt("DATA_LENGTH");
                Object var15_16 = null;
                String string5 = null;
                if (string4.compareTo("NUMBER") == 0) {
                    string = string4;
                    string5 = "numerical";
                } else if (string4.compareTo("VARCHAR2") == 0 || string4.compareTo("CHAR") == 0) {
                    string = n4 == 1 ? "CHAR" : "VARCHAR2";
                    string5 = "categorical";
                } else {
                    string = "";
                    bl = true;
                }
                if (!bl) {
                    hashtable.put(string3, new DataInfo(string5, string));
                    continue;
                }
                bl = false;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (callableStatement != null) {
                callableStatement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        return hashtable;
    }

    public Vector getEqualWidthBounds(double[] dArray, int n) {
        return this.getEqualWidthBounds(dArray[STAT_MIN], dArray[STAT_MAX], n);
    }

    public Vector getEqualWidthBounds(double d, double d2, int n) {
        Object object;
        int n2;
        if (d >= d2) {
            Vector<Bin> vector = new Vector<Bin>();
            Bin bin = new Bin(0, d, d2);
            vector.add(bin);
            return vector;
        }
        Vector<Object> vector = new Vector<Object>();
        double d3 = (d2 - d) / (double)n;
        double d4 = d;
        double d5 = d4 + d3;
        for (n2 = 0; n2 < n; ++n2) {
            if (n2 == n - 1) {
                d5 = d2;
            }
            object = new Bin(n2, d4, d5);
            vector.add(object);
            d4 = d5;
            d5 += d3;
        }
        n2 = 2;
        object = DecimalFormat.getNumberInstance();
        ((NumberFormat)object).setGroupingUsed(true);
        ((NumberFormat)object).setMaximumFractionDigits(n2);
        ((NumberFormat)object).setMinimumFractionDigits(0);
        DecimalFormat decimalFormat = (DecimalFormat)object;
        for (int i = 0; i < vector.size(); ++i) {
            Bin bin = (Bin)vector.elementAt(i);
            DM4JNumericFormat.AdjustFormat(bin.getLowerBound(), bin.getUpperBound(), decimalFormat);
        }
        Vector<Bin> vector2 = new Vector<Bin>();
        for (int i = 0; i < vector.size(); ++i) {
            Bin bin = (Bin)vector.elementAt(i);
            String string = DM4JNumericFormat.SQLFormat(bin.getLowerBound(), decimalFormat);
            String string2 = DM4JNumericFormat.SQLFormat(bin.getUpperBound(), decimalFormat);
            vector2.add(new Bin(i, Double.parseDouble(string), Double.parseDouble(string2)));
        }
        return vector2;
    }

    public boolean isAttributeBinned(int n) {
        String string = this.getBinType(n);
        if (string == null) {
            return false;
        }
        BinningType binningType = BinningType.getInstance(string);
        if (binningType == null) {
            return false;
        }
        return !binningType.equal(BinningType.NONE);
    }

    public boolean isNumeric(int n) {
        String string = this.getMiningType(n);
        if (string == null) {
            return false;
        }
        return 0 == string.compareTo("numerical");
    }

    public String getMiningType(int n) {
        return (String)this.getData(COLUMN_NAMES.MTYPE, n);
    }

    public void setMiningType(int n, String string) {
        this.setData(COLUMN_NAMES.MTYPE, n, string);
    }

    public BinningType getBinningType(int n) {
        String string = this.getBinType(n);
        if (string == null) {
            return BinningType.NONE;
        }
        BinningType binningType = BinningType.getInstance(string);
        return binningType;
    }

    public boolean isEqualWidthBinning(int n) {
        BinningType binningType = this.getBinningType(n);
        return binningType.equal(BinningType.EQ_WIDTH);
    }

    public boolean isQtileBinning(int n) {
        BinningType binningType = this.getBinningType(n);
        return binningType.equal(BinningType.QTILE);
    }

    public boolean isTopNBinning(int n) {
        BinningType binningType = this.getBinningType(n);
        return binningType.equal(BinningType.TOPN);
    }

    public boolean isWinsorizeBinning(int n) {
        BinningType binningType = this.getBinningType(n);
        return binningType.equal(BinningType.WINSORIZE);
    }

    public boolean isCustomBinning(int n) {
        BinningType binningType = this.getBinningType(n);
        return binningType.equal(BinningType.CUSTOM);
    }

    public String getAttributeName(int n) {
        return (String)this.getData(COLUMN_NAMES.NAME, n);
    }

    public void setAttributeName(int n, String string) {
        this.setData(COLUMN_NAMES.NAME, n, string);
        this.m_NameRow.put(string, new Integer(n));
    }

    public int getAttributeRow(String string) {
        Integer n = (Integer)this.m_NameRow.get(string);
        return n == null ? -1 : n;
    }

    public String[] getAllAttributeNames() {
        int n = this.getRowCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.getAttributeName(i);
        }
        return stringArray;
    }

    public int getHistogramBins(int n) {
        Integer n2 = this.getNumberOfBins(n);
        int n3 = 0;
        if (n2 != null) {
            n3 = n2 + 2;
        }
        return n3;
    }

    public Double getTailPercent(int n) {
        return (Double)this.getData(COLUMN_NAMES.TAILPERCENT, n);
    }

    public Vector getBinBounds(int n) {
        return (Vector)this.getData(COLUMN_NAMES.BINBOUNDS, n);
    }

    public double getCustomLowerBound(int n) {
        Vector vector = this.getBinBounds(n);
        if (vector == null || vector.isEmpty()) {
            return 0.0;
        }
        Bin bin = (Bin)vector.get(0);
        return bin.getLowerBound();
    }

    public double getCustomUpperBound(int n) {
        Vector vector = this.getBinBounds(n);
        if (vector == null || vector.isEmpty()) {
            return 0.0;
        }
        Bin bin = (Bin)vector.get(vector.size() - 1);
        return bin.getUpperBound();
    }

    public void setBinBounds(int n, Vector vector) {
        this.setData(COLUMN_NAMES.BINBOUNDS, n, vector);
    }

    public void setTailPercent(int n, double d) {
        this.setData(COLUMN_NAMES.TAILPERCENT, n, new Double(d));
    }

    public void setNumberOfBins(int n, int n2) {
        this.setData(COLUMN_NAMES.BINNUMBER, n, new Integer(n2));
    }

    public void setNumberOfBins(int n) {
        this.setData(COLUMN_NAMES.BINNUMBER, n, null);
    }

    public void setBinCategories(int n, Vector vector) {
        this.setData(COLUMN_NAMES.EXTRA_DATA_4, n, vector);
    }

    public Vector getBinCategories(int n) {
        return (Vector)this.getData(COLUMN_NAMES.EXTRA_DATA_4, n);
    }

    public void setNumberOfNonNulls(int n, int n2) {
        this.setData(COLUMN_NAMES.EXTRA_DATA_5, n, new Integer(n2));
    }

    public int getNumberOfNonNulls(int n) {
        Integer n2 = (Integer)this.getData(COLUMN_NAMES.EXTRA_DATA_5, n);
        return n2 != null ? n2 : 0;
    }

    public Integer getNumberOfBins(int n) {
        return (Integer)this.getData(COLUMN_NAMES.BINNUMBER, n);
    }

    public void setEqualWidthBinning(int n, int n2) {
        this.setBinType(n, BinningType.EQ_WIDTH.getName(), n2);
    }

    public void setQtileBinning(int n, int n2) {
        this.setBinType(n, BinningType.QTILE.getName(), n2);
    }

    public void setWinsorizeBinning(int n, int n2) {
        this.setBinType(n, BinningType.WINSORIZE.getName(), n2);
    }

    public void setCustomBinning(int n, int n2) {
        this.setBinType(n, BinningType.CUSTOM.getName(), n2);
    }

    public void markAttributeUnBinned(int n) {
        this.clearViewDefiniton(n);
        this.setBinTypeNONE(n);
        this.setNumberOfBins(n, 0);
        this.setData(COLUMN_NAMES.TAILPERCENT, n, new Double(0.0));
        this.setBinBounds(n, null);
    }

    public void markAttributeBinned(int n, BinningType binningType, int n2) {
        this.setBinType(n, binningType.getName(), n2);
    }

    public Integer getTotalCount(int n) {
        return (Integer)this.getData(COLUMN_NAMES.TOTAL, n);
    }

    public void set1stOrderStatistics(int n, double[] dArray) {
        this.setData(COLUMN_NAMES.TOTAL, n, new Integer((int)dArray[STAT_TOTAL]));
        this.setData(COLUMN_NAMES.AVG, n, new Double(dArray[STAT_AVERAGE]));
        this.setData(COLUMN_NAMES.MAX, n, new Double(dArray[STAT_MAX]));
        this.setData(COLUMN_NAMES.MIN, n, new Double(dArray[STAT_MIN]));
        this.setData(COLUMN_NAMES.VAR, n, new Double(dArray[STAT_VARIANCE]));
        this.setData(COLUMN_NAMES.STDDEV, n, new Double(dArray[STAT_STDEV]));
        this.setData(COLUMN_NAMES.SKEW, n, null);
        this.setData(COLUMN_NAMES.KURT, n, null);
    }

    public double[] getStats(int n) {
        double[] dArray = new double[NUMBER_STATS];
        Integer n2 = (Integer)this.getData(COLUMN_NAMES.TOTAL, n);
        dArray[DiscretizeDataSource.STAT_TOTAL] = n2 == null ? 0 : n2;
        Double d = (Double)this.getData(COLUMN_NAMES.AVG, n);
        dArray[DiscretizeDataSource.STAT_AVERAGE] = d == null ? 0.0 : d;
        d = (Double)this.getData(COLUMN_NAMES.MAX, n);
        dArray[DiscretizeDataSource.STAT_MAX] = d == null ? 0.0 : d;
        d = (Double)this.getData(COLUMN_NAMES.MIN, n);
        dArray[DiscretizeDataSource.STAT_MIN] = d == null ? 0.0 : d;
        d = (Double)this.getData(COLUMN_NAMES.VAR, n);
        dArray[DiscretizeDataSource.STAT_VARIANCE] = d == null ? 0.0 : d;
        d = (Double)this.getData(COLUMN_NAMES.STDDEV, n);
        dArray[DiscretizeDataSource.STAT_STDEV] = d == null ? 0.0 : d;
        dArray[DiscretizeDataSource.STAT_SKEW] = 0.0;
        dArray[DiscretizeDataSource.STAT_KURT] = 0.0;
        return dArray;
    }

    public Double getSkew(int n) {
        return (Double)this.getData(COLUMN_NAMES.SKEW, n);
    }

    public void setSkew(int n, Double d) {
        this.setData(COLUMN_NAMES.SKEW, n, d);
    }

    public Double getKurtosis(int n) {
        return (Double)this.getData(COLUMN_NAMES.KURT, n);
    }

    public void setKurtosis(int n, Double d) {
        this.setData(COLUMN_NAMES.KURT, n, d);
    }

    public Double getAverage(int n) {
        return (Double)this.getData(COLUMN_NAMES.AVG, n);
    }

    public Double getMin(int n) {
        return (Double)this.getData(COLUMN_NAMES.MIN, n);
    }

    public Integer getDistinctValue(int n) {
        return (Integer)this.getData(COLUMN_NAMES.DISTINCT, n);
    }

    public Double getMax(int n) {
        return (Double)this.getData(COLUMN_NAMES.MAX, n);
    }

    public Double getVariance(int n) {
        return (Double)this.getData(COLUMN_NAMES.VAR, n);
    }

    public Double getSigma(int n) {
        return (Double)this.getData(COLUMN_NAMES.STDDEV, n);
    }

    public void set2ndOrderStatistics(int n, double[] dArray) {
        this.setData(COLUMN_NAMES.SKEW, n, new Double(dArray[STAT_SKEW]));
        this.setData(COLUMN_NAMES.KURT, n, new Double(dArray[STAT_KURT]));
    }

    public void setActivityType(int n, ActivityType activityType) {
        this.setData(COLUMN_NAMES.DEFAULT_ALGORITHM, n, activityType);
    }

    public ActivityType getActivityType(int n) {
        return (ActivityType)this.getData(COLUMN_NAMES.DEFAULT_ALGORITHM, n);
    }

    protected StringBuffer getCaseStatement(int n) {
        StringBuffer stringBuffer = new StringBuffer("");
        StringBuffer stringBuffer2 = this.getViewDefinition(n);
        if (stringBuffer2 == null || 0 == stringBuffer2.length()) {
            return stringBuffer;
        }
        int n2 = -1;
        int n3 = -1;
        boolean bl = false;
        for (int i = 0; i < stringBuffer2.length(); ++i) {
            if ('\"' == stringBuffer2.charAt(i)) {
                boolean bl2 = bl = !bl;
            }
            if ('(' != stringBuffer2.charAt(i) || bl) continue;
            n2 = i;
            String string = " end) ";
            int n4 = stringBuffer2.indexOf(string);
            if (n4 == -1) break;
            n3 = n4 + string.length();
            break;
        }
        if (n2 == -1 || n3 == -1) {
            if (DiscretizeDataSource.isDebug()) {
                System.out.println("malformed view definition");
            }
            return stringBuffer;
        }
        String string = stringBuffer2.substring(n2, n3);
        stringBuffer.append(string);
        return stringBuffer;
    }

    public void splitViewDefinitionTX(StringBuffer stringBuffer, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.setViewDefinition(nArray[i], stringBuffer);
        }
    }

    public void splitViewDefinition(StringBuffer stringBuffer, int[] nArray) {
        if (this.m_isTransactional && !this.m_bSingleMetric) {
            this.splitViewDefinitionTX(stringBuffer, nArray);
            return;
        }
        StringBuffer stringBuffer2 = new StringBuffer("CREATE VIEW ");
        stringBuffer2.append("\"" + this.m_userSchemaName + "\".\"" + this.m_resultViewName + "\"");
        stringBuffer2.append(AS_SELECT);
        String string = stringBuffer.toString();
        for (int i = 0; i < nArray.length; ++i) {
            String string2 = this.getAttributeName(nArray[i]);
            String string3 = "\"" + this.getColumnName(string2) + "\"";
            int n = string.indexOf("( CASE WHEN " + string3);
            if (n == -1) continue;
            BinningType binningType = this.getBinningType(nArray[i]);
            String string4 = null;
            string4 = binningType.equal(BinningType.QTILE) ? " end) " + string3 : "else null end) " + string3;
            int n2 = string.indexOf(string4);
            if (n2 == -1 && (n2 = string.indexOf(string4 = " is not null then 1 end) " + string3)) == -1) continue;
            StringBuffer stringBuffer3 = new StringBuffer(stringBuffer2.toString());
            stringBuffer3.append(string.substring(n, n2));
            stringBuffer3.append(string4);
            stringBuffer3.append(" FROM ");
            stringBuffer3.append(this.getSampledDataLocation());
            this.setViewDefinition(nArray[i], stringBuffer3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer getViewDefinition(Connection connection, int[] nArray, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer = this.createNumericOpenEndedViewDefinition(this.m_tableColumns, nArray, this.getSampledDataLocation(), this.m_userSchemaName, this.m_resultViewName, bl);
            this.splitViewDefinition(stringBuffer, nArray);
        }
        catch (Exception exception) {
            stringBuffer = new StringBuffer();
        }
        return stringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateBinBoundaries(AbstractActivity abstractActivity) throws SQLException {
        boolean bl = false;
        boolean bl2 = true;
        Connection connection = null;
        Statement statement = null;
        try {
            int n;
            Bin[] binArray;
            LinkedHashSet linkedHashSet;
            connection = DM4JConnectionManager.getDbConnection();
            if (this.m_numericalDiscretizationTableName == null) {
                this.m_numericalDiscretizationTableName = ValidationUtil.createUniqueTableName(NUMERIC_BIN_TABLE_PREFIX, connection, "");
            }
            DM4JTransformation.CREATE_BIN_NUM(connection, this.m_numericalDiscretizationTableName, this.m_userSchemaName);
            Object[] objectArray = new Object[]{this.m_userSchemaName, this.m_numericalDiscretizationTableName};
            String string = MessageFormat.format("INSERT INTO {0}.{1} VALUES (?, ?, ?, ?)", objectArray);
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            if (abstractActivity != null && (linkedHashSet = abstractActivity.getTables()) != null) {
                for (Serializable serializable : linkedHashSet) {
                    if (!((Table)serializable).isTransactionalRelationship() || (binArray = ((Table)serializable).getTxnMappings()) == null) continue;
                    for (n = 0; n < binArray.size(); ++n) {
                        Mapping mapping = (Mapping)binArray.get(n);
                        String string2 = mapping.getAlias();
                        String string3 = mapping.getPrefix();
                        hashtable.put(string2, string3);
                    }
                }
            }
            bl2 = connection.getAutoCommit();
            connection.setAutoCommit(false);
            statement = connection.prepareStatement(string);
            ((OraclePreparedStatement)statement).setExecuteBatch(100);
            for (int i = 0; i < this.getRowCount(); ++i) {
                Serializable serializable;
                String string4 = this.getAttributeName(i);
                serializable = this.getBinBounds(i);
                if (serializable == null) continue;
                binArray = new Bin[((Vector)serializable).size()];
                binArray = ((Vector)serializable).toArray(binArray);
                for (n = 0; n < binArray.length; ++n) {
                    double d = binArray[n].getLowerBound();
                    double d2 = binArray[n].getUpperBound();
                    int n2 = binArray[n].getBinNumber();
                    int n3 = 1;
                    try {
                        statement.setString(n3++, string4);
                        if (d < (double)1.4E-45f) {
                            d = 1.4E-45f;
                        }
                        statement.setDouble(n3++, d);
                        if (n == 0) {
                            statement.setNull(n3++, 12);
                        } else {
                            statement.setString(n3++, String.valueOf(n2));
                        }
                        String string5 = (String)hashtable.get(string4);
                        if (string5 != null) {
                            statement.setString(n3++, string5);
                        } else {
                            statement.setNull(n3++, 12);
                        }
                        bl = true;
                        statement.executeUpdate();
                        if (n != binArray.length - 1) continue;
                        n3 = 1;
                        statement.setString(n3++, string4);
                        statement.setDouble(n3++, d2);
                        statement.setString(n3++, String.valueOf(n2 + 1));
                        if (string5 != null) {
                            statement.setString(n3++, string5);
                        } else {
                            statement.setNull(n3++, 12);
                        }
                        statement.executeUpdate();
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (bl) {
                ((OraclePreparedStatement)statement).sendBatch();
                connection.commit();
            }
        }
        catch (Exception exception) {
        }
        finally {
            connection.setAutoCommit(bl2);
            if (statement != null) {
                statement.close();
            }
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateGroupNumericBinBoundaries(Connection connection, int[] nArray, String string, String string2) throws SQLException {
        if (nArray == null || nArray.length == 0) {
            return;
        }
        Object[] objectArray = new Object[]{string2, string};
        String string3 = MessageFormat.format("INSERT INTO {0}.{1} VALUES ( ?,?,?,?,?,?)", objectArray);
        Statement statement = null;
        boolean bl = false;
        boolean bl2 = true;
        try {
            bl2 = connection.getAutoCommit();
            connection.setAutoCommit(false);
            statement = connection.prepareStatement(string3);
            ((OraclePreparedStatement)statement).setExecuteBatch(100);
            for (int i = 0; i < nArray.length; ++i) {
                String string4 = this.getAttributeName(nArray[i]);
                Vector vector = this.getBinBounds(nArray[i]);
                if (vector == null) continue;
                Bin[] binArray = new Bin[vector.size()];
                binArray = vector.toArray(binArray);
                for (int j = 0; j < binArray.length; ++j) {
                    double d = binArray[j].getLowerBound();
                    double d2 = binArray[j].getUpperBound();
                    int n = binArray[j].getBinNumber();
                    StringBuffer stringBuffer = new StringBuffer(String.valueOf(d));
                    if (d < d2) {
                        stringBuffer.append(" - " + String.valueOf(d2));
                    }
                    String string5 = "T";
                    int n2 = 1;
                    try {
                        statement.setString(n2++, string4);
                        if (d < (double)1.4E-45f) {
                            d = 1.4E-45f;
                        }
                        statement.setDouble(n2++, d);
                        statement.setDouble(n2++, d2);
                        statement.setInt(n2++, n + 1);
                        statement.setString(n2++, string5);
                        statement.setString(n2++, stringBuffer.toString());
                        bl = true;
                        statement.executeUpdate();
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (!bl) {
                ((OraclePreparedStatement)statement).sendBatch();
                connection.commit();
            }
        }
        catch (Exception exception) {
        }
        finally {
            connection.setAutoCommit(bl2);
            if (statement != null) {
                statement.close();
            }
        }
    }

    private void insertBoundsQtile(PreparedStatement preparedStatement, String string, double d, double d2, int n, StringBuffer stringBuffer) {
        if (d <= (double)1.4E-45f) {
            return;
        }
        String string2 = "T";
        int n2 = 1;
        try {
            preparedStatement.setString(n2++, string);
            preparedStatement.setDouble(n2++, d);
            preparedStatement.setDouble(n2++, d2);
            preparedStatement.setInt(n2++, n);
            preparedStatement.setString(n2++, string2);
            preparedStatement.setString(n2++, stringBuffer.toString());
            preparedStatement.execute();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void insertBounds(PreparedStatement preparedStatement, String string, double d, double d2, int n, StringBuffer stringBuffer) {
        String string2 = "T";
        int n2 = 1;
        try {
            preparedStatement.setString(n2++, string);
            preparedStatement.setDouble(n2++, d);
            preparedStatement.setDouble(n2++, d2);
            preparedStatement.setInt(n2++, n + 1);
            preparedStatement.setString(n2++, string2);
            preparedStatement.setString(n2++, stringBuffer.toString());
            preparedStatement.execute();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNumericAttributeFromBinBoundary(String string) {
        Connection connection = null;
        try {
            String string2;
            connection = DM4JConnectionManager.getDbConnection();
            String string3 = "\"" + this.m_userSchemaName + "\".\"" + this.m_numericalDiscretizationTableName + "\"";
            StringBuffer stringBuffer = new StringBuffer("DELETE FROM " + string3 + " WHERE \n");
            try {
                string2 = TransformsDirector.getReplacedString(string, "'", "''");
            }
            catch (Exception exception) {
                string2 = string;
            }
            stringBuffer.append("COLUMN_NAME = '" + string2 + "'");
            DM4JTransformation.removeAttributesFromBinBoundaryTable(connection, stringBuffer.toString());
        }
        catch (Exception exception) {
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    StringBuffer createTXViewDefinition(String string, String string2, String string3) {
        String string4 = "\"" + this.m_userSchemaName + "\".\"" + this.m_numericalDiscretizationTableName + "\"";
        String string5 = "\"" + this.m_userSchemaName + "\".\"" + this.m_categoricalDiscretizationTableName + "\"";
        String[] stringArray = new String[]{"CREATE VIEW ", string2, ".", string3, AS_SELECT, "\n", "/*+ PQ_DISTRIBUTE(tm BROADCAST, NONE) NO_MERGE(tm) NO_MERGE(bm) SWAP_JOIN_INPUTS(bm) USE_HASH(bm tm) */ ", "\n", "tm.id ", "\"" + this.m_seqIdMapping + "\"", ",tm.cn ", "\"" + this.m_attributeMapping + "\"", ", ", "\n", "CASE WHEN tm.b IS NOT NULL THEN tm.b ELSE CASE WHEN bm.b IS NULL THEN tm.nv ", "\n", "ELSE CASE WHEN bm.b != 0 THEN bm.b ELSE NULL END END END ", "\n", "\"" + this.m_valueMapping + "\"", " FROM (SELECT /*+ PQ_DISTRIBUTE(tn BROADCAST, NONE) NO_MERGE(tn) NO_MERGE(bn) SWAP_JOIN_INPUTS(bn) USE_HASH(bn tn) */ ", "\n", "tn.id,tn.cn,tn.nv,CASE WHEN tn.b IS NOT NULL THEN tn.b ELSE bn.b END b ", "\n", "FROM (", "\n", "SELECT /*+ PARALLEL(tr) PQ_DISTRIBUTE(tr BROADCAST, NONE) NO_MERGE(tr) NO_MERGE(br) SWAP_JOIN_INPUTS(br) USE_HASH(br tr) */ ", "\n", "tr.", "\"" + this.m_seqIdMapping + "\"", " id,tr.", "\"" + this.m_attributeMapping + "\"", " cn,tr.", "\"" + this.m_valueMapping + "\"", " nv,br.b FROM ", "\n", string, " tr ", "\n", "LEFT OUTER JOIN (", "\n", "SELECT /*+ PARALLEL(n) */ column_name c, lower_boundary l,upper_boundary u,bin_id b ", "\n", " FROM ", string4, " n ", "\n", "WHERE lower_boundary != upper_boundary) br ", "\n", "ON tr.", "\"" + this.m_attributeMapping + "\"", " = br.c AND tr.", "\"" + this.m_valueMapping + "\"", " > br.l AND tr.", "\"" + this.m_valueMapping + "\"", " < br.u) tn ", "\n", "LEFT OUTER JOIN (SELECT /*+ PARALLEL(c) */ column_name c,category_value n,group_id b ", "\n", " FROM ", string5, " c ", "\n", "WHERE category_value IS NOT NULL ", "\n", "UNION ALL ", "\n", "SELECT /*+ PARALLEL(n) */ column_name c,lower_boundary n,bin_id b ", "\n", " FROM ", string4, " n ", "\n", "WHERE lower_boundary != upper_boundary ", "\n", "UNION ALL ", "\n", "SELECT column_name c,upper_boundary n,bin_id b FROM (", "\n", "SELECT /*+ PARALLEL(n) */ n.*,MAX(bin_id) OVER (PARTITION BY column_name) max_bin ", "\n", " FROM ", string4, " n ", "\n", ") ", "\n", "WHERE bin_id = max_bin) bn ON tn.cn = bn.c AND tn.nv = bn.n) tm LEFT OUTER JOIN (SELECT /*+PARALLEL(c) */ ", "\n", "column_name c,group_id b ", "\n", " FROM ", string5, " c ", "\n", "WHERE category_value IS NULL ", "\n", "UNION ALL SELECT /*+ PARALLEL(n) */ column_name c,0 b ", "\n", " FROM ", string4, " n ", "\n", "WHERE bin_id = 1) bm ON tm.cn = bm.c ", "\n"};
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StringBuffer createNumericOpenEndedViewDefinitionTX(Vector vector, int[] nArray, String string, String string2, boolean bl) {
        Connection connection = null;
        try {
            Object object;
            Object object2;
            String string3;
            int n;
            connection = DM4JConnectionManager.getDbConnection();
            if (bl) {
                String string4 = "\"" + this.m_userSchemaName + "\".\"" + this.m_numericalDiscretizationTableName + "\"";
                this.cleanBinBoundary(connection, string4, nArray);
            }
            this.populateGroupNumericBinBoundaries(connection, nArray, this.m_numericalDiscretizationTableName, this.m_userSchemaName);
            int n2 = vector.size();
            BinBoundMap binBoundMap = new BinBoundMap(n2);
            Hashtable<String, BinningType> hashtable = new Hashtable<String, BinningType>();
            for (n = 0; n < nArray.length; ++n) {
                string3 = this.getAttributeName(nArray[n]);
                hashtable.put(string3, this.getBinningType(nArray[n]));
                object2 = this.getBinBounds(nArray[n]);
                if (object2 == null || ((Vector)object2).size() == 0) continue;
                object = new Bin[((Vector)object2).size()];
                object = ((Vector)object2).toArray((T[])object);
                for (int i = 0; i < ((Bin[])object).length; ++i) {
                    int n3 = object[i].getBinNumber();
                    double d = ((Bin)object[i]).getLowerBound();
                    double d2 = ((Bin)object[i]).getUpperBound();
                    binBoundMap.addBinBound("\"" + string3 + "\"", new BinBound(n3, d, d2));
                }
            }
            for (n = 0; n < n2; ++n) {
                string3 = (String)vector.elementAt(n);
                object2 = "\"" + (String)vector.elementAt(n) + "\"";
                object = (BinningType)hashtable.get((String)vector.elementAt(n));
                if (binBoundMap.isEmpty((String)object2) || binBoundMap.size((String)object2) <= 1) continue;
                if (((BinningType)object).equal(BinningType.QTILE)) {
                    this.prepareQtileDefinitionTX(binBoundMap, (String)object2, string3);
                    continue;
                }
                this.prepareEqWidthDefinitionTX(binBoundMap, (String)object2, string3);
            }
            binBoundMap.clear();
        }
        catch (Exception exception) {
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return this.m_txSampledViewDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StringBuffer createNumericOpenEndedViewDefinitionLabelsTX(Vector vector, int[] nArray, String string, String string2, boolean bl) {
        Connection connection = null;
        try {
            Object object;
            Object object2;
            String string3;
            int n;
            connection = DM4JConnectionManager.getDbConnection();
            if (bl) {
                String string4 = "\"" + this.m_userSchemaName + "\".\"" + this.m_numericalDiscretizationTableName + "\"";
                this.cleanBinBoundary(connection, string4, nArray);
            }
            this.populateGroupNumericBinBoundaries(connection, nArray, this.m_numericalDiscretizationTableName, this.m_userSchemaName);
            int n2 = vector.size();
            BinBoundMap binBoundMap = new BinBoundMap(n2);
            Hashtable<String, BinningType> hashtable = new Hashtable<String, BinningType>();
            for (n = 0; n < nArray.length; ++n) {
                string3 = this.getAttributeName(nArray[n]);
                hashtable.put(string3, this.getBinningType(nArray[n]));
                object2 = this.getBinBounds(nArray[n]);
                if (object2 == null || ((Vector)object2).size() == 0) continue;
                object = new Bin[((Vector)object2).size()];
                object = ((Vector)object2).toArray((T[])object);
                for (int i = 0; i < ((Bin[])object).length; ++i) {
                    int n3 = object[i].getBinNumber();
                    double d = ((Bin)object[i]).getLowerBound();
                    double d2 = ((Bin)object[i]).getUpperBound();
                    binBoundMap.addBinBound("\"" + string3 + "\"", new BinBound(n3, d, d2));
                }
            }
            for (n = 0; n < n2; ++n) {
                string3 = (String)vector.elementAt(n);
                object2 = "\"" + (String)vector.elementAt(n) + "\"";
                object = (BinningType)hashtable.get((String)vector.elementAt(n));
                if (binBoundMap.isEmpty((String)object2) || binBoundMap.size((String)object2) <= 1) continue;
                if (((BinningType)object).equal(BinningType.QTILE)) {
                    this.prepareQtileDefinitionLabelsTX(binBoundMap, (String)object2, string3);
                    continue;
                }
                this.prepareEqWidthDefinitionLabelsTX(binBoundMap, (String)object2, string3);
            }
            binBoundMap.clear();
        }
        catch (Exception exception) {
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return this.m_txSampledViewDefinition;
    }

    protected StringBuffer createNumericOpenEndedViewDefinition(Vector vector, int[] nArray, String string, String string2, String string3, boolean bl) {
        int n;
        Object object;
        Object object2;
        if (this.isLabels()) {
            return this.createNumericOpenEndedViewDefinitionLabels(vector, nArray, string, string2, string3, bl);
        }
        if (this.m_isTransactional && !this.m_bSingleMetric) {
            return this.createNumericOpenEndedViewDefinitionTX(vector, nArray, string2, string3, bl);
        }
        StringBuffer stringBuffer = new StringBuffer("CREATE VIEW " + string2 + "." + string3 + AS_SELECT + "\n");
        int n2 = vector.size();
        BinBoundMap binBoundMap = new BinBoundMap(n2);
        Hashtable<Object, BinningType> hashtable = new Hashtable<Object, BinningType>();
        for (int i = 0; i < nArray.length; ++i) {
            object2 = this.getAttributeName(nArray[i]);
            object2 = this.getColumnName((String)object2);
            hashtable.put(object2, this.getBinningType(nArray[i]));
            Vector vector2 = this.getBinBounds(nArray[i]);
            if (vector2 == null || vector2.size() == 0) continue;
            object = new Bin[vector2.size()];
            object = vector2.toArray((T[])object);
            for (int j = 0; j < ((Bin[])object).length; ++j) {
                int n3 = object[j].getBinNumber();
                double d = object[j].getLowerBound();
                double d2 = object[j].getUpperBound();
                binBoundMap.addBinBound("\"" + (String)object2 + "\"", new BinBound(n3, d, d2));
            }
        }
        Vector<Bin[]> vector3 = new Vector<Bin[]>();
        object2 = new Vector();
        for (n = 0; n < n2; ++n) {
            String string4;
            object = (Bin[])vector.elementAt(n);
            String string5 = string4 = this.m_lds != null ? this.m_lds.getComplexAttributeInfo((String)object) : null;
            if (string4 != null) {
                vector3.add((Bin[])object);
                continue;
            }
            ((Vector)object2).add(object);
        }
        for (n = 0; n < ((Vector)object2).size(); ++n) {
            object = (String)vector.elementAt(n);
            String string6 = "\"" + this.getColumnName((String)object) + "\"";
            String string7 = (String)((Vector)object2).elementAt(n);
            BinningType binningType = (BinningType)hashtable.get(this.getColumnName(string7));
            if (binBoundMap.isEmpty(string6)) {
                stringBuffer.append(string6);
            } else if (binBoundMap.size(string6) == 1) {
                stringBuffer.append("( CASE ");
                stringBuffer.append("WHEN ");
                stringBuffer.append(string6);
                stringBuffer.append(" is not null then 1 end) " + string6);
                String string8 = ResourceUtilities.getUILabel("HISTOGRAM_NOT_NULL");
                Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
                Vector<String> vector4 = new Vector<String>();
                hashtable2.put(DiscretizeDataSource.appendSingleQuotes("1"), string8);
                this.setMapCategorytoRange(this.getAttributeRow((String)object), hashtable2);
                vector4.add(DiscretizeDataSource.appendSingleQuotes("1"));
                this.setAllCategorytoRangeList(this.getAttributeRow((String)object), vector4);
            } else if (binningType.equal(BinningType.QTILE)) {
                this.prepareQtileDefinition(stringBuffer, binBoundMap, string6, (String)object);
            } else {
                this.prepareEqWidthDefinition(stringBuffer, binBoundMap, string6, (String)object);
            }
            if (n < ((Vector)object2).size() - 1) {
                stringBuffer.append(",");
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append(" FROM " + string);
        for (n = 0; n < vector3.size(); ++n) {
            TXColumn tXColumn;
            String string9;
            object = (String)vector3.elementAt(n);
            int n4 = this.getAttributeRow((String)object);
            if (!this.isSelected(nArray, n4) || (string9 = this.m_lds.getComplexAttributeInfo((String)object)) == null || (tXColumn = this.m_sampledInputCDS.getTXColumn(string9)) == null) continue;
            try {
                this.processNumTxSource((String)object, tXColumn.getValueColumn(), string9, binBoundMap, hashtable);
                continue;
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
        binBoundMap.clear();
        return stringBuffer;
    }

    protected void prepareQtileDefinition(StringBuffer stringBuffer, BinBoundMap binBoundMap, String string, String string2) {
        Object object;
        int n;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Vector<String> vector = new Vector<String>();
        stringBuffer.append("( CASE ");
        Vector vector2 = binBoundMap.getBinBounds(string);
        int n2 = 2;
        NumberFormat numberFormat = DecimalFormat.getNumberInstance();
        numberFormat.setGroupingUsed(true);
        numberFormat.setMaximumFractionDigits(n2);
        numberFormat.setMinimumFractionDigits(0);
        DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
        for (n = 0; n < vector2.size(); ++n) {
            object = (BinBound)vector2.elementAt(n);
            DM4JNumericFormat.AdjustFormat(((BinBound)object).m_lowerBound, ((BinBound)object).m_upperBound, decimalFormat);
        }
        for (n = 0; n < vector2.size(); ++n) {
            object = String.valueOf(n + 1);
            String string3 = null;
            String string4 = null;
            stringBuffer.append("WHEN ");
            BinBound binBound = (BinBound)vector2.elementAt(n);
            if (n == 0) {
                if (vector2.size() > 2) {
                    string3 = " < " + DM4JNumericFormat.SQLFormat(binBound.m_upperBound, decimalFormat);
                    string4 = " < " + DM4JNumericFormat.format(binBound.m_upperBound);
                } else {
                    string3 = " <= " + DM4JNumericFormat.SQLFormat(binBound.m_upperBound, decimalFormat);
                    string4 = " <= " + DM4JNumericFormat.format(binBound.m_upperBound);
                }
            } else if (n == vector2.size() - 1) {
                string3 = " > " + DM4JNumericFormat.SQLFormat(binBound.m_lowerBound, decimalFormat);
                string4 = " > " + DM4JNumericFormat.format(binBound.m_lowerBound);
            } else {
                String[] stringArray = DM4JNumericFormat.SQLFormat(binBound.m_lowerBound, binBound.m_upperBound, decimalFormat);
                string4 = stringArray[0] + " - " + stringArray[1];
                string3 = " <= " + DM4JNumericFormat.SQLFormat(binBound.m_upperBound, decimalFormat);
            }
            stringBuffer.append(string + string3 + " THEN " + (String)object);
            stringBuffer.append("\n");
            hashtable.put(DiscretizeDataSource.appendSingleQuotes((String)object), string4);
            vector.add(DiscretizeDataSource.appendSingleQuotes((String)object));
        }
        stringBuffer.append(" end) " + string);
        this.setMapCategorytoRange(this.getAttributeRow(string2), hashtable);
        this.setAllCategorytoRangeList(this.getAttributeRow(string2), vector);
    }

    private void prepareQtileDefinitionTX(BinBoundMap binBoundMap, String string, String string2) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Vector<String> vector = new Vector<String>();
        Vector vector2 = binBoundMap.getBinBounds(string);
        for (int i = 0; i < vector2.size(); ++i) {
            String string3 = String.valueOf(i + 1);
            String string4 = null;
            BinBound binBound = (BinBound)vector2.elementAt(i);
            string4 = i == 0 ? " < " + DM4JNumericFormat.format(binBound.m_upperBound) : (i == vector2.size() - 1 ? " > " + DM4JNumericFormat.format(binBound.m_lowerBound) : DM4JNumericFormat.format(binBound.m_lowerBound) + " - " + DM4JNumericFormat.format(binBound.m_upperBound));
            hashtable.put(DiscretizeDataSource.appendSingleQuotes(string3), string4);
            vector.add(DiscretizeDataSource.appendSingleQuotes(string3));
        }
        this.setMapCategorytoRange(this.getAttributeRow(string2), hashtable);
        this.setAllCategorytoRangeList(this.getAttributeRow(string2), vector);
    }

    protected void prepareEqWidthDefinition(StringBuffer stringBuffer, BinBoundMap binBoundMap, String string, String string2) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Vector<String> vector = new Vector<String>();
        stringBuffer.append("( CASE ");
        Vector vector2 = binBoundMap.getBinBounds(string);
        int n = 2;
        NumberFormat numberFormat = DecimalFormat.getNumberInstance();
        numberFormat.setGroupingUsed(true);
        numberFormat.setMaximumFractionDigits(n);
        numberFormat.setMinimumFractionDigits(0);
        DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
        for (int i = 0; i < vector2.size(); ++i) {
            String[] stringArray;
            BinBound binBound;
            String string3 = String.valueOf(i + 1);
            String string4 = null;
            String string5 = null;
            stringBuffer.append("WHEN ");
            BinBound binBound2 = (BinBound)vector2.elementAt(i);
            if (i == 0) {
                if (vector2.size() == 1) {
                    string4 = " < " + DM4JNumericFormat.SQLFormat(binBound2.m_upperBound);
                } else {
                    binBound = (BinBound)vector2.elementAt(1);
                    stringArray = DM4JNumericFormat.SQLFormat(binBound2.m_upperBound, binBound.m_upperBound, decimalFormat);
                    string4 = " < " + stringArray[0];
                }
                string5 = " < " + DM4JNumericFormat.SQLFormat(binBound2.m_upperBound, decimalFormat);
            } else if (i == vector2.size() - 1) {
                string4 = " >= " + DM4JNumericFormat.SQLFormat(binBound2.m_lowerBound, decimalFormat);
                string5 = " >= " + DM4JNumericFormat.SQLFormat(binBound2.m_lowerBound, decimalFormat);
            } else {
                binBound = (BinBound)vector2.elementAt(i - 1);
                stringArray = DM4JNumericFormat.SQLFormat(binBound.m_upperBound, binBound2.m_upperBound, decimalFormat);
                string4 = " >= " + stringArray[0] + " AND " + string + " < " + stringArray[1];
                string5 = DM4JNumericFormat.SQLFormat(binBound.m_upperBound, decimalFormat) + " - " + DM4JNumericFormat.format(binBound2.m_upperBound, decimalFormat);
            }
            stringBuffer.append(string + string4 + " THEN " + string3);
            stringBuffer.append("\n");
            hashtable.put(DiscretizeDataSource.appendSingleQuotes(string3), string5);
            vector.add(DiscretizeDataSource.appendSingleQuotes(string3));
        }
        stringBuffer.append("else null end) " + string);
        this.setMapCategorytoRange(this.getAttributeRow(string2), hashtable);
        this.setAllCategorytoRangeList(this.getAttributeRow(string2), vector);
    }

    private void prepareEqWidthDefinitionTX(BinBoundMap binBoundMap, String string, String string2) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Vector<String> vector = new Vector<String>();
        Vector vector2 = binBoundMap.getBinBounds(string);
        for (int i = 0; i < vector2.size(); ++i) {
            String string3 = String.valueOf(i + 1);
            String string4 = null;
            BinBound binBound = (BinBound)vector2.elementAt(i);
            if (i == 0) {
                string4 = " < " + DM4JNumericFormat.format(binBound.m_upperBound);
            } else if (i == vector2.size() - 1) {
                string4 = " >= " + DM4JNumericFormat.format(binBound.m_lowerBound);
            } else {
                BinBound binBound2 = (BinBound)vector2.elementAt(i - 1);
                string4 = DM4JNumericFormat.format(binBound2.m_upperBound) + " - " + DM4JNumericFormat.format(binBound.m_upperBound);
            }
            hashtable.put(DiscretizeDataSource.appendSingleQuotes(string3), string4);
            vector.add(DiscretizeDataSource.appendSingleQuotes(string3));
        }
        this.setMapCategorytoRange(this.getAttributeRow(string2), hashtable);
        this.setAllCategorytoRangeList(this.getAttributeRow(string2), vector);
    }

    public static String appendSingleQuotes(String string) {
        StringBuffer stringBuffer = new StringBuffer("'" + string + "'");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getCategoricAttributeFrequency(Connection connection, int n, String string, String string2) {
        Object object;
        Object object2;
        if (this.m_isTransactional && !this.m_bSingleMetric) {
            return this.getCategoricAttributeFrequencyTX(connection, n, string, string2);
        }
        String[] stringArray = new String[]{"select {0} DISPLAY_NAME, count(*) FREQUENCY ", "from {1} group by {0} order by FREQUENCY desc"};
        String string3 = "\"" + this.getColumnName(string) + "\"";
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            object2 = MessageFormat.format(stringArray[i], string3, string2);
            stringBuffer.append((String)object2);
        }
        Hashtable<Integer, CategoricBin> hashtable = new Hashtable<Integer, CategoricBin>();
        object2 = this.getBinBounds(n);
        int n2 = ((Vector)object2).size();
        int[] nArray = new int[n2 + 1];
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(stringBuffer.toString());
            object = preparedStatement.executeQuery();
            boolean bl = false;
            while (object.next()) {
                String string4 = object.getString("DISPLAY_NAME");
                if (string4 == null) {
                    string4 = ResourceUtilities.getUILabel("HISTOGRAM_NULL_VALUE");
                }
                int n3 = object.getInt("FREQUENCY");
                boolean bl2 = false;
                for (int i = 0; i < n2; ++i) {
                    CategoricBin categoricBin = (CategoricBin)((Vector)object2).elementAt(i);
                    for (int j = 0; j < categoricBin.values.size(); ++j) {
                        if (0 != string4.compareTo((String)categoricBin.values.elementAt(j))) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl2) continue;
                    int n4 = i;
                    nArray[n4] = nArray[n4] + n3;
                    break;
                }
                if (bl2) continue;
                int n5 = n2;
                nArray[n5] = nArray[n5] + n3;
            }
            for (int i = 0; i < n2; ++i) {
                CategoricBin categoricBin = (CategoricBin)((Vector)object2).elementAt(i);
                hashtable.put(new Integer(i), categoricBin);
            }
            String string5 = ResourceUtilities.getUILabel("HISTOGRAM_OTHER");
            Vector vector = this.getOther((Vector)object2, n);
            hashtable.put(new Integer(n2), new CategoricBin(string5, vector));
        }
        catch (Exception exception) {
            hashtable.clear();
        }
        finally {
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {}
        }
        if (hashtable.isEmpty()) {
            return null;
        }
        this.setDisplayNames(n, hashtable);
        this.setNumberOfBins(n, n2);
        object = this.getBinType(n);
        this.setBinType(n, (String)object, n2);
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] getCategoricAttributeFrequencyTX(Connection connection, int n, String string, String string2) {
        Object object;
        String string3 = "SELECT {0} DISPLAY_NAME, COUNT(*) FREQUENCY FROM {1} WHERE {2}={3} GROUP BY {0} order by FREQUENCY desc";
        String string4 = "'" + string + "'";
        String string5 = MessageFormat.format(string3, "\"" + this.m_valueMapping + "\"", string2, "\"" + this.m_attributeMapping + "\"", string4);
        Hashtable<Integer, CategoricBin> hashtable = new Hashtable<Integer, CategoricBin>();
        Vector vector = this.getBinBounds(n);
        int n2 = vector.size();
        int[] nArray = new int[n2 + 1];
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(string5);
            object = preparedStatement.executeQuery();
            boolean bl = false;
            while (object.next()) {
                String string6 = object.getString("DISPLAY_NAME");
                if (string6 == null) {
                    string6 = ResourceUtilities.getUILabel("HISTOGRAM_NULL_VALUE");
                }
                int n3 = object.getInt("FREQUENCY");
                boolean bl2 = false;
                for (int i = 0; i < n2; ++i) {
                    CategoricBin categoricBin = (CategoricBin)vector.elementAt(i);
                    for (int j = 0; j < categoricBin.values.size(); ++j) {
                        if (0 != string6.compareTo((String)categoricBin.values.elementAt(j))) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl2) continue;
                    int n4 = i;
                    nArray[n4] = nArray[n4] + n3;
                    break;
                }
                if (bl2) continue;
                int n5 = n2;
                nArray[n5] = nArray[n5] + n3;
            }
            for (int i = 0; i < n2; ++i) {
                CategoricBin categoricBin = (CategoricBin)vector.elementAt(i);
                hashtable.put(new Integer(i), categoricBin);
            }
            String string7 = ResourceUtilities.getUILabel("HISTOGRAM_OTHER");
            Vector vector2 = this.getOther(vector, n);
            hashtable.put(new Integer(n2), new CategoricBin(string7, vector2));
        }
        catch (Exception exception) {
            hashtable.clear();
        }
        finally {
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {}
        }
        if (hashtable.isEmpty()) {
            return null;
        }
        this.setDisplayNames(n, hashtable);
        this.setNumberOfBins(n, n2);
        object = this.getBinType(n);
        this.setBinType(n, (String)object, n2);
        return nArray;
    }

    public StringBuffer getViewDefinition(int n) {
        return (StringBuffer)this.getData(COLUMN_NAMES.VIEW_DEFN, n);
    }

    public void setViewDefinition(int n, StringBuffer stringBuffer) {
        this.setData(COLUMN_NAMES.VIEW_DEFN, n, stringBuffer);
    }

    public void clearViewDefiniton(int n) {
        this.setViewDefinition(n, null);
        if (this.m_isTransactional && !this.m_bSingleMetric) {
            this.removeNumericAttributeFromBinBoundary(this.getAttributeName(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer getSingleNumericAttributeViewDefinition(Connection connection, int n, boolean bl) {
        StringBuffer stringBuffer = null;
        try {
            Vector<String> vector = new Vector<String>();
            vector.add(this.getAttributeName(n));
            stringBuffer = this.createNumericOpenEndedViewDefinition(vector, new int[]{n}, this.getSampledDataLocation(), this.m_userSchemaName, this.m_resultViewName, bl);
            this.setViewDefinition(n, stringBuffer);
        }
        catch (Exception exception) {
            this.setViewDefinition(n, null);
        }
        return stringBuffer;
    }

    public Hashtable getDisplayNames(int n) {
        return (Hashtable)this.getData(COLUMN_NAMES.DISPLAY_NAMES, n);
    }

    public void setDisplayNames(int n, Hashtable hashtable) {
        this.setData(COLUMN_NAMES.DISPLAY_NAMES, n, hashtable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNumericStats(Vector vector, Hashtable hashtable, String string) {
        if (vector == null || vector.isEmpty()) {
            return;
        }
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            if (this.m_isTransactional && !this.m_bSingleMetric) {
                this.addNumericStatsTX(connection, hashtable, string);
            } else {
                this.addNumericStats2D(connection, vector, hashtable, string);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNumericStatsTX(Connection connection, Hashtable hashtable, String string) {
        String string2 = "SELECT {0} ANAME, count({1}) as N, count(distinct {1}) as D, count(*) as T, MIN({1}) MINV, MAX({1}) MAXV, AVG({1}) AVGV, VARIANCE({1}) as Variance from {2} group by {0}";
        String string3 = MessageFormat.format(string2, "\"" + this.m_attributeMapping + "\"", "\"" + this.m_valueMapping + "\"", string == null ? this.getSampledDataLocation() : string);
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                String string4 = resultSet.getString("ANAME");
                Integer n = (Integer)hashtable.get(string4);
                if (n == null) continue;
                int n2 = resultSet.getInt("N");
                this.setData(COLUMN_NAMES.TOTAL, n, new Integer(n2));
                int n3 = resultSet.getInt("D");
                this.setData(COLUMN_NAMES.DISTINCT, n, new Integer(n3));
                int n4 = resultSet.getInt("T");
                int n5 = n4 - n2;
                double d = (double)n5 / (double)n4;
                this.setData(COLUMN_NAMES.MISSING_PERCENT, n, new Double(d));
                double d2 = resultSet.getDouble("MAXV");
                this.setData(COLUMN_NAMES.MAX, n, new Double(d2));
                d2 = resultSet.getDouble("MINV");
                this.setData(COLUMN_NAMES.MIN, n, new Double(d2));
                d2 = resultSet.getDouble("AVGV");
                this.setData(COLUMN_NAMES.AVG, n, new Double(d2));
                d2 = resultSet.getDouble("Variance");
                this.setData(COLUMN_NAMES.VAR, n, new Double(d2));
                d2 = Math.sqrt(d2);
                this.setData(COLUMN_NAMES.STDDEV, n, new Double(d2));
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNumericStats2D(Connection connection, Vector vector, Hashtable hashtable, String string) {
        if (vector == null || vector.isEmpty()) {
            return;
        }
        int n = vector.size() / 1000 + 1;
        String string2 = "count({0}) as N{1}, count(distinct {0}) as D{1}, avg({0}) as Average{1}, MAX({0}) Max{1} , MIN({0}) Min{1}, VARIANCE({0}) as Variance{1}";
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            int n2 = Math.min(vector.size(), 1000 * (i + 1));
            int n3 = 1000 * i;
            StringBuffer stringBuffer = new StringBuffer("SELECT /*+ parallel (t) */ count(*) as TOTAL, ");
            for (int j = n3; j < n2; ++j) {
                object2 = (String)vector.elementAt(j);
                object = MessageFormat.format(string2, "\"" + (String)object2 + "\"", String.valueOf(j));
                if (j > n3) {
                    stringBuffer.append(",\n");
                }
                stringBuffer.append((String)object);
            }
            String string3 = MessageFormat.format(" from ({0} t)", string == null ? this.getSampledDataLocation() : string);
            stringBuffer.append(string3);
            object2 = null;
            object = null;
            try {
                object2 = connection.createStatement();
                object = object2.executeQuery(stringBuffer.toString());
                if (!object.next()) continue;
                int n4 = object.getInt("TOTAL");
                for (int j = n3; j < n2; ++j) {
                    String string4 = String.valueOf(j);
                    String string5 = (String)vector.elementAt(j);
                    Integer n5 = (Integer)hashtable.get(string5);
                    if (n5 == null) continue;
                    int n6 = object.getInt("N" + string4);
                    this.setData(COLUMN_NAMES.TOTAL, n5, new Integer(n6));
                    int n7 = n4 - n6;
                    double d = (double)n7 / (double)n4 * 100.0;
                    this.setData(COLUMN_NAMES.MISSING_PERCENT, n5, new Double(d));
                    this.setData(COLUMN_NAMES.SPARSITY_FLAG, n5, new Boolean(d >= this.m_preferences.getSparsityCutoff()));
                    int n8 = object.getInt("D" + string4);
                    this.setData(COLUMN_NAMES.DISTINCT, n5, new Integer(n8));
                    double d2 = object.getDouble("Average" + string4);
                    this.setData(COLUMN_NAMES.AVG, n5, new Double(d2));
                    d2 = object.getDouble("Max" + string4);
                    this.setData(COLUMN_NAMES.MAX, n5, new Double(d2));
                    d2 = object.getDouble("Min" + string4);
                    this.setData(COLUMN_NAMES.MIN, n5, new Double(d2));
                    d2 = object.getDouble("Variance" + string4);
                    this.setData(COLUMN_NAMES.VAR, n5, new Double(d2));
                    d2 = Math.sqrt(d2);
                    this.setData(COLUMN_NAMES.STDDEV, n5, new Double(d2));
                }
                continue;
            }
            catch (Exception exception) {
                continue;
            }
            finally {
                try {
                    object.close();
                    object2.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void calculateBounds(Vector vector, Hashtable hashtable, int n) {
        if (vector == null || vector.isEmpty()) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Integer n2 = (Integer)hashtable.get((String)vector.elementAt(i));
            if (n2 == null) continue;
            int n3 = n2;
            Double d = (Double)this.getData(COLUMN_NAMES.MAX, n3);
            Double d2 = (Double)this.getData(COLUMN_NAMES.MIN, n3);
            if (d == null || d2 == null) continue;
            Vector vector2 = this.getEqualWidthBounds(d2, d, n);
            this.setBinBounds(n3, vector2);
            if (vector2 != null) continue;
            this.setViewDefinition(n3, null);
            this.setBinTypeNONE(n3);
            this.setNumberOfBins(n3, 0);
        }
    }

    protected void getQtileStats(Connection connection, Vector vector, Hashtable hashtable, String string, int n) {
        if (this.m_isTransactional && !this.m_bSingleMetric) {
            this.getQtileStatsTX(connection, vector, hashtable, null, n);
            return;
        }
        if (vector == null || vector.isEmpty()) {
            return;
        }
        this.quantileBinning2D(connection, vector, hashtable, string, n);
    }

    protected void getQtileStatsTX(Connection connection, Vector vector, Hashtable hashtable, String string, int n) {
        if (vector == null || vector.isEmpty()) {
            return;
        }
        this.quantileBinningTX(connection, vector, hashtable, string, n);
    }

    void getEqualWidthStats(Vector vector, Hashtable hashtable, String string, int n, boolean bl) {
        if (vector == null || vector.isEmpty()) {
            return;
        }
        this.calculateBounds(vector, hashtable, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void quantileBinningTX(Connection connection, Vector vector, Hashtable hashtable, String string, int n) {
        String string2 = "SELECT " + this.m_attributeMapping + ", MIN(VAL_VALUE) LOW_BOUND, MAX(VAL_VALUE) UP_BOUND FROM " + "( SELECT " + this.m_attributeMapping + ", " + this.m_valueMapping + " VAL_VALUE, NTILE(TO_CHAR(ABS(" + String.valueOf(n) + "))) OVER(PARTITION BY " + this.m_attributeMapping + " ORDER BY " + this.m_valueMapping + " ASC) qtile " + "FROM (" + (string == null ? this.getSampledDataLocation() : string) + ") WHERE " + this.m_valueMapping + " IS NOT NULL ) " + "GROUP BY qtile, " + this.m_attributeMapping + " ORDER BY " + this.m_attributeMapping + ", qtile ASC";
        Vector<Object> vector2 = new Vector<Object>();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            Object object;
            Hashtable<Object, BinVectors> hashtable2 = new Hashtable<Object, BinVectors>();
            Vector vector3 = null;
            Vector vector4 = null;
            int n2 = 0;
            statement = connection.prepareStatement(string2);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                object = resultSet.getString(1);
                if (null == hashtable2.get(object)) {
                    vector3 = new Vector();
                    vector4 = new Vector();
                    hashtable2.put(object, new BinVectors(vector3, vector4));
                }
                double d = resultSet.getDouble(2);
                double d2 = resultSet.getDouble(3);
                vector2.add(object);
                vector3.add(new Double(d));
                vector4.add(new Double(d2));
            }
            n2 = hashtable2.size();
            object = hashtable2.keys();
            while (object.hasMoreElements()) {
                QuantileDefinition quantileDefinition;
                String string3 = (String)object.nextElement();
                Integer n3 = (Integer)hashtable.get(string3);
                if (n3 == null) continue;
                BinVectors binVectors = (BinVectors)hashtable2.get(string3);
                vector3 = binVectors.getMinVector();
                vector4 = binVectors.getMaxVector();
                n2 = vector4.size();
                Vector<QuantileDefinition> vector5 = new Vector<QuantileDefinition>();
                if (n2 == 0) continue;
                vector3.add(vector4.elementAt(vector4.size() - 1));
                Double[] doubleArray = vector3.toArray(new Double[vector3.size()]);
                Double[] doubleArray2 = vector4.toArray(new Double[vector4.size()]);
                if (doubleArray[0].doubleValue() == doubleArray2[n2 - 1].doubleValue()) continue;
                int n4 = 0;
                for (int i = 0; i <= n2; ++i) {
                    if (i <= n2 - 1 && doubleArray[i].doubleValue() == doubleArray[i + 1].doubleValue()) continue;
                    quantileDefinition = new QuantileDefinition(n4, doubleArray[i]);
                    vector5.add(quantileDefinition);
                    ++n4;
                }
                Vector<Bin> vector6 = new Vector<Bin>();
                quantileDefinition = (QuantileDefinition)vector5.elementAt(0);
                for (int i = 1; i < vector5.size(); ++i) {
                    QuantileDefinition quantileDefinition2 = (QuantileDefinition)vector5.elementAt(i);
                    String string4 = String.valueOf(Double.MIN_VALUE);
                    Bin bin = new Bin(quantileDefinition2.getBinNumber() - 1, quantileDefinition.getMinNumber(), quantileDefinition2.getMinNumber());
                    vector6.add(bin);
                    quantileDefinition = quantileDefinition2;
                }
                this.setBinBounds(n3, vector6);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void quantileBinning2D(Connection connection, Vector vector, Hashtable hashtable, String string, int n) {
        this.getEqualWidthStats(vector, hashtable, string, n, false);
        String string2 = "SELECT MIN(val), MAX(val) FROM (SELECT {0} val,NTILE(TO_CHAR(ABS({1}))) OVER(ORDER BY {0} ASC) qtile FROM {2} WHERE {0} IS NOT NULL) GROUP BY qtile ORDER BY qtile ASC";
        for (int i = 0; i < vector.size(); ++i) {
            String string3 = (String)vector.elementAt(i);
            Integer n2 = (Integer)hashtable.get(string3);
            if (n2 == null) continue;
            string3 = this.getColumnName(string3);
            Vector<Double> vector2 = new Vector<Double>();
            Vector<Double> vector3 = new Vector<Double>();
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                String string4 = MessageFormat.format(string2, "\"" + string3 + "\"", new Integer(n), string == null ? this.getSampledDataLocation() : string);
                int n3 = 0;
                statement = connection.prepareStatement(string4);
                resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    double d = resultSet.getDouble(1);
                    double d2 = resultSet.getDouble(2);
                    vector2.add(new Double(d));
                    vector3.add(new Double(d2));
                    ++n3;
                }
                Vector<QuantileDefinition> vector4 = new Vector<QuantileDefinition>();
                if (n3 == 0) continue;
                vector2.add((Double)vector3.elementAt(vector3.size() - 1));
                Double[] doubleArray = vector2.toArray(new Double[vector2.size()]);
                Double[] doubleArray2 = vector3.toArray(new Double[vector3.size()]);
                Vector<Bin> vector5 = new Vector<Bin>();
                if (doubleArray[0].doubleValue() != doubleArray2[n3 - 1].doubleValue()) {
                    int n4 = 0;
                    for (int j = 0; j <= n3; ++j) {
                        if (j <= n3 - 1 && doubleArray[j].doubleValue() == doubleArray[j + 1].doubleValue()) continue;
                        QuantileDefinition quantileDefinition = new QuantileDefinition(n4, doubleArray[j]);
                        vector4.add(quantileDefinition);
                        ++n4;
                    }
                    QuantileDefinition quantileDefinition = (QuantileDefinition)vector4.elementAt(0);
                    for (int j = 1; j < vector4.size(); ++j) {
                        QuantileDefinition quantileDefinition2 = (QuantileDefinition)vector4.elementAt(j);
                        Bin bin = new Bin(quantileDefinition2.getBinNumber() - 1, quantileDefinition.getMinNumber(), quantileDefinition2.getMinNumber());
                        vector5.add(bin);
                        quantileDefinition = quantileDefinition2;
                    }
                } else {
                    Bin bin = new Bin(0, doubleArray[0], doubleArray2[n3 - 1]);
                    vector5.add(bin);
                }
                this.setBinBounds(n2, vector5);
                continue;
            }
            catch (Exception exception) {
                continue;
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public String getBinType(int n) {
        String string = (String)this.getData(COLUMN_NAMES.BINTYPE, n);
        int n2 = string.indexOf(SEPARATOR);
        if (n2 == -1) {
            return string;
        }
        return string.substring(0, n2);
    }

    public void setBinType(int n, String string, int n2) {
        if (0 == string.compareTo(BinningType.NONE.getName())) {
            this.setData(COLUMN_NAMES.BINTYPE, n, string);
        } else {
            this.setData(COLUMN_NAMES.BINTYPE, n, string + SEPARATOR + String.valueOf(n2));
        }
        if (this.options != null) {
            if (string.equalsIgnoreCase(BinningType.NONE.getName())) {
                this.options.setNumericalDiscretizeTreatment(NONE);
            } else if (string.equalsIgnoreCase(BinningType.QTILE.getName())) {
                this.options.setNumericalDiscretizeTreatment(QUANTILE_BINNING);
            } else if (string.equalsIgnoreCase(BinningType.EQ_WIDTH.getName())) {
                this.options.setNumericalDiscretizeTreatment(EQUAL_WIDTH_BINNING);
            }
        }
    }

    public void setBinTypeNONE(int n) {
        this.setData(COLUMN_NAMES.BINTYPE, n, BinningType.NONE.getName());
    }

    public String getMode(int n) {
        return "";
    }

    protected void debugOutSQL(StringBuffer stringBuffer, String string) {
        try {
            StringBuffer stringBuffer2 = new StringBuffer();
            if (string != null) {
                stringBuffer2.append(string + "\n");
            }
            stringBuffer2.append(stringBuffer.toString());
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter("c:\\temp\\stmt" + String.valueOf(Math.random()) + " .sql"));
            bufferedWriter.write(stringBuffer2.toString(), 0, stringBuffer2.length());
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void synchronize(DiscretizeDataSource discretizeDataSource, Hashtable hashtable) {
        Object object;
        int n;
        Vector vector = new Vector();
        String[] stringArray = discretizeDataSource.getAllAttributeNames();
        for (n = 0; n < stringArray.length; ++n) {
            String string;
            object = stringArray[n];
            int n2 = discretizeDataSource.getAttributeRow((String)object);
            if (null == hashtable.get(object)) {
                DiscretizeDataSource.addDescending(vector, new Integer(n2));
                continue;
            }
            String string2 = (String)hashtable.get(object);
            if (0 == string2.compareTo(string = discretizeDataSource.getMiningType(n2))) {
                hashtable.remove(object);
                continue;
            }
            DiscretizeDataSource.addDescending(vector, new Integer(n2));
        }
        if (vector.isEmpty()) {
            return;
        }
        for (n = 0; n < vector.size(); ++n) {
            object = (Integer)vector.elementAt(n);
            if (object == null) continue;
            discretizeDataSource.removeRows((Integer)object, 1);
        }
        vector.clear();
        discretizeDataSource.clearMap();
        for (n = 0; n < discretizeDataSource.getRowCount(); ++n) {
            object = discretizeDataSource.getAttributeName(n);
            discretizeDataSource.m_NameRow.put(object, new Integer(n));
        }
    }

    private static void addDescending(Vector vector, Integer n) {
        for (int i = 0; i < vector.size(); ++i) {
            Integer n2 = (Integer)vector.elementAt(i);
            if (n <= n2) continue;
            vector.add(i, n);
            return;
        }
        vector.add(n);
    }

    public void augmentDataSource(Connection connection, Hashtable hashtable, DiscretizationLDSDataSource discretizationLDSDataSource) throws Exception {
        this.m_lds = discretizationLDSDataSource;
        try {
            int n = this.getRowCount();
            Enumeration enumeration = hashtable.keys();
            Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>();
            Vector<String> vector = new Vector<String>();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)hashtable.get(string);
                AttributeType attributeType = (AttributeType)m_AttributeType.get(string2);
                if (attributeType == null || !attributeType.equals(AttributeType.numerical)) continue;
                this.addRows(++n - 1, 1);
                this.setAttributeName(n - 1, string);
                this.setMiningType(n - 1, string2);
                this.setData(COLUMN_NAMES.DTYPE, n - 1, this.m_lds.getDataType(string));
                this.setBinTypeNONE(n - 1);
                this.setNumberOfBins(n - 1);
                this.setData(COLUMN_NAMES.TAILPERCENT, n - 1, null);
                this.setViewDefinition(n - 1, null);
                this.setDisplayNames(n - 1, null);
                this.setData(COLUMN_NAMES.SKEW, n - 1, null);
                this.setData(COLUMN_NAMES.KURT, n - 1, null);
                vector.add(string);
                hashtable2.put(string, new Integer(n - 1));
            }
            if (this.m_isTransactional && !this.m_bSingleMetric) {
                this.addNumericStatsTX(connection, hashtable2, this.m_sDataLocation);
            } else {
                this.addNumericStats2D(connection, vector, hashtable2, null);
            }
            hashtable2.clear();
            vector.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void refreshAllColumnList() {
        this.m_tableColumns.clear();
        this.m_tableColumns = this.m_lds.getAttributes(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getHistogramQuantileBinning(int n, Integer n2, boolean bl) {
        Connection connection = null;
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        hashtable.put(this.getAttributeName(n), new Integer(n));
        try {
            Object object;
            connection = DM4JConnectionManager.getDbConnection();
            int[] nArray = null;
            if (!hashtable.isEmpty()) {
                nArray = new int[hashtable.size()];
            }
            int n3 = 0;
            Vector<int[]> vector = new Vector<int[]>();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                Integer n4 = (Integer)hashtable.get(object);
                if (n4 == null) continue;
                int n5 = n4;
                nArray[n3++] = n5;
                vector.add((int[])object);
            }
            object = new int[n3];
            System.arraycopy(nArray, 0, object, 0, n3);
            this.getQtileStats(connection, vector, hashtable, null, n2);
            this.getViewDefinition(connection, (int[])object, bl);
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected StringBuffer createNumericOpenEndedViewDefinitionLabels(Vector vector, int[] nArray, String string, String string2, String string3, boolean bl) {
        int n;
        Object object;
        Object object2;
        if (this.m_isTransactional && !this.m_bSingleMetric) {
            return this.createNumericOpenEndedViewDefinitionLabelsTX(vector, nArray, string2, string3, bl);
        }
        StringBuffer stringBuffer = new StringBuffer("CREATE VIEW " + string2 + "." + string3 + AS_SELECT + "\n");
        int n2 = vector.size();
        BinBoundMap binBoundMap = new BinBoundMap(n2);
        Hashtable<Object, BinningType> hashtable = new Hashtable<Object, BinningType>();
        for (int i = 0; i < nArray.length; ++i) {
            object2 = this.getAttributeName(nArray[i]);
            object2 = this.getColumnName((String)object2);
            hashtable.put(object2, this.getBinningType(nArray[i]));
            Vector vector2 = this.getBinBounds(nArray[i]);
            if (vector2 == null || vector2.size() == 0) continue;
            object = new Bin[vector2.size()];
            object = vector2.toArray((T[])object);
            for (int j = 0; j < ((Bin[])object).length; ++j) {
                int n3 = object[j].getBinNumber();
                double d = object[j].getLowerBound();
                double d2 = object[j].getUpperBound();
                binBoundMap.addBinBound("\"" + (String)object2 + "\"", new BinBound(n3, d, d2));
            }
        }
        Vector<Bin[]> vector3 = new Vector<Bin[]>();
        object2 = new Vector();
        for (n = 0; n < n2; ++n) {
            String string4;
            object = (Bin[])vector.elementAt(n);
            String string5 = string4 = this.m_lds != null ? this.m_lds.getComplexAttributeInfo((String)object) : null;
            if (string4 != null) {
                vector3.add((Bin[])object);
                continue;
            }
            ((Vector)object2).add(object);
        }
        for (n = 0; n < ((Vector)object2).size(); ++n) {
            object = (String)vector.elementAt(n);
            String string6 = "\"" + this.getColumnName((String)object) + "\"";
            String string7 = (String)((Vector)object2).elementAt(n);
            BinningType binningType = (BinningType)hashtable.get(this.getColumnName(string7));
            if (binBoundMap.isEmpty(string6)) {
                stringBuffer.append(string6);
            } else if (binBoundMap.size(string6) == 1) {
                stringBuffer.append("( CASE ");
                stringBuffer.append("WHEN ");
                stringBuffer.append(string6);
                stringBuffer.append(" is not null then 1 end) " + string6);
                String string8 = ResourceUtilities.getUILabel("HISTOGRAM_NOT_NULL");
                Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
                Vector<String> vector4 = new Vector<String>();
                hashtable2.put(DiscretizeDataSource.appendSingleQuotes("1"), string8);
                this.setMapCategorytoRange(this.getAttributeRow((String)object), hashtable2);
                vector4.add(DiscretizeDataSource.appendSingleQuotes("1"));
                this.setAllCategorytoRangeList(this.getAttributeRow((String)object), vector4);
            } else if (binningType.equal(BinningType.QTILE)) {
                this.prepareQtileDefinitionLabels(stringBuffer, binBoundMap, string6, (String)object);
            } else {
                this.prepareEqWidthDefinitionLabels(stringBuffer, binBoundMap, string6, (String)object);
            }
            if (n < ((Vector)object2).size() - 1) {
                stringBuffer.append(",");
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append(" FROM " + string);
        for (n = 0; n < vector3.size(); ++n) {
            TXColumn tXColumn;
            String string9;
            object = (String)vector3.elementAt(n);
            int n4 = this.getAttributeRow((String)object);
            if (!this.isSelected(nArray, n4) || (string9 = this.m_lds.getComplexAttributeInfo((String)object)) == null || (tXColumn = this.m_sampledInputCDS.getTXColumn(string9)) == null) continue;
            try {
                this.processNumTxSource((String)object, tXColumn.getValueColumn(), string9, binBoundMap, hashtable);
                continue;
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
        binBoundMap.clear();
        return stringBuffer;
    }

    protected void prepareQtileDefinitionLabels(StringBuffer stringBuffer, BinBoundMap binBoundMap, String string, String string2) {
        Object object;
        int n;
        Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
        Vector<Object> vector = new Vector<Object>();
        stringBuffer.append("( CASE ");
        Vector vector2 = binBoundMap.getBinBounds(string);
        int n2 = 2;
        NumberFormat numberFormat = DecimalFormat.getNumberInstance();
        numberFormat.setGroupingUsed(true);
        numberFormat.setMaximumFractionDigits(n2);
        numberFormat.setMinimumFractionDigits(0);
        DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
        for (n = 0; n < vector2.size(); ++n) {
            object = (BinBound)vector2.elementAt(n);
            DM4JNumericFormat.AdjustFormat(((BinBound)object).m_lowerBound, ((BinBound)object).m_upperBound, decimalFormat);
        }
        for (n = 0; n < vector2.size(); ++n) {
            object = null;
            String string3 = null;
            String string4 = null;
            stringBuffer.append("WHEN ");
            BinBound binBound = (BinBound)vector2.elementAt(n);
            if (n == 0) {
                if (vector2.size() > 2) {
                    string4 = " < " + DM4JNumericFormat.SQLFormat(binBound.m_upperBound, decimalFormat);
                    object = DiscretizeDataSource.appendSingleQuotes(string4);
                    string3 = " < " + DM4JNumericFormat.SQLFormat(binBound.m_upperBound, decimalFormat);
                } else {
                    string4 = " <= " + DM4JNumericFormat.SQLFormat(binBound.m_upperBound, decimalFormat);
                    object = DiscretizeDataSource.appendSingleQuotes(string4);
                    string3 = " <= " + DM4JNumericFormat.SQLFormat(binBound.m_upperBound, decimalFormat);
                }
            } else if (n == vector2.size() - 1) {
                string4 = " > " + DM4JNumericFormat.SQLFormat(binBound.m_lowerBound, decimalFormat);
                object = DiscretizeDataSource.appendSingleQuotes(string4);
                string3 = " > " + DM4JNumericFormat.SQLFormat(binBound.m_lowerBound, decimalFormat);
            } else {
                String[] stringArray = DM4JNumericFormat.SQLFormat(binBound.m_lowerBound, binBound.m_upperBound, decimalFormat);
                string4 = stringArray[0] + " - " + stringArray[1];
                object = DiscretizeDataSource.appendSingleQuotes(string4);
                string3 = " <= " + DM4JNumericFormat.SQLFormat(binBound.m_upperBound, decimalFormat);
            }
            stringBuffer.append(string + string3 + " THEN " + (String)object);
            stringBuffer.append("\n");
            hashtable.put(object, string4);
            vector.add(object);
        }
        stringBuffer.append("else null end) " + string);
        this.setMapCategorytoRange(this.getAttributeRow(string2), hashtable);
        this.setAllCategorytoRangeList(this.getAttributeRow(string2), vector);
    }

    protected String prepareDecodeSatement(int n) {
        String string = this.getAttributeName(n);
        int n2 = 2;
        NumberFormat numberFormat = DecimalFormat.getNumberInstance();
        numberFormat.setGroupingUsed(true);
        numberFormat.setMaximumFractionDigits(n2);
        numberFormat.setMinimumFractionDigits(0);
        DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
        BinBoundMap binBoundMap = new BinBoundMap(1);
        Vector vector = this.getBinBounds(n);
        if (vector == null || vector.size() == 0) {
            return "";
        }
        Bin[] binArray = new Bin[vector.size()];
        binArray = vector.toArray(binArray);
        for (int i = 0; i < binArray.length; ++i) {
            int n3 = binArray[i].getBinNumber();
            double d = binArray[i].getLowerBound();
            double d2 = binArray[i].getUpperBound();
            binBoundMap.addBinBound(string, new BinBound(n3, d, d2));
        }
        StringBuffer stringBuffer = new StringBuffer();
        BinningType binningType = this.getBinningType(n);
        Vector vector2 = binBoundMap.getBinBounds(string);
        for (int i = 0; i < vector2.size(); ++i) {
            String string2 = null;
            String string3 = null;
            String string4 = null;
            BinBound binBound = (BinBound)vector2.elementAt(i);
            if (binningType.equal(BinningType.QTILE)) {
                if (i == 0) {
                    string4 = " < " + DM4JNumericFormat.SQLFormat(binBound.m_upperBound, decimalFormat);
                    string2 = DiscretizeDataSource.appendSingleQuotes(string4);
                } else if (i == vector2.size() - 1) {
                    string4 = " > " + DM4JNumericFormat.SQLFormat(binBound.m_lowerBound, decimalFormat);
                    string2 = DiscretizeDataSource.appendSingleQuotes(string4);
                } else {
                    string4 = DM4JNumericFormat.SQLFormat(binBound.m_lowerBound, decimalFormat) + " - " + DM4JNumericFormat.SQLFormat(binBound.m_upperBound, decimalFormat);
                    string2 = DiscretizeDataSource.appendSingleQuotes(string4);
                }
            } else if (i == 0) {
                string4 = " < " + DM4JNumericFormat.SQLFormat(binBound.m_upperBound, decimalFormat);
                string2 = DiscretizeDataSource.appendSingleQuotes(string4);
                string3 = " < " + DM4JNumericFormat.SQLFormat(binBound.m_upperBound, decimalFormat);
            } else if (i == vector2.size() - 1) {
                string4 = " >= " + DM4JNumericFormat.SQLFormat(binBound.m_lowerBound, decimalFormat);
                string2 = DiscretizeDataSource.appendSingleQuotes(string4);
                string3 = " > " + DM4JNumericFormat.SQLFormat(binBound.m_lowerBound, decimalFormat);
            } else {
                BinBound binBound2 = (BinBound)vector2.elementAt(i - 1);
                string4 = DM4JNumericFormat.SQLFormat(binBound2.m_upperBound, decimalFormat) + " - " + DM4JNumericFormat.SQLFormat(binBound.m_upperBound, decimalFormat);
                string2 = DiscretizeDataSource.appendSingleQuotes(string4);
                string3 = " <= " + DM4JNumericFormat.SQLFormat(binBound.m_upperBound, decimalFormat);
            }
            stringBuffer.append(string2);
            stringBuffer.append("," + (i + 1));
            if (i < vector2.size() - 1) {
                stringBuffer.append(",");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private void prepareQtileDefinitionLabelsTX(BinBoundMap binBoundMap, String string, String string2) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Vector<String> vector = new Vector<String>();
        Vector vector2 = binBoundMap.getBinBounds(string);
        for (int i = 0; i < vector2.size(); ++i) {
            String string3 = String.valueOf(i + 1);
            String string4 = null;
            BinBound binBound = (BinBound)vector2.elementAt(i);
            string4 = i == 0 ? " <= " + DM4JNumericFormat.format(binBound.m_upperBound) : (i == vector2.size() - 1 ? " >= " + DM4JNumericFormat.format(binBound.m_lowerBound) : DM4JNumericFormat.format(binBound.m_lowerBound) + " - " + DM4JNumericFormat.format(binBound.m_upperBound));
            hashtable.put(DiscretizeDataSource.appendSingleQuotes(string3), string4);
            vector.add(DiscretizeDataSource.appendSingleQuotes(string3));
        }
        this.setMapCategorytoRange(this.getAttributeRow(string2), hashtable);
        this.setAllCategorytoRangeList(this.getAttributeRow(string2), vector);
    }

    protected void prepareEqWidthDefinitionLabels(StringBuffer stringBuffer, BinBoundMap binBoundMap, String string, String string2) {
        Object object;
        int n;
        Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
        Vector<Object> vector = new Vector<Object>();
        stringBuffer.append("( CASE ");
        Vector vector2 = binBoundMap.getBinBounds(string);
        int n2 = 2;
        NumberFormat numberFormat = DecimalFormat.getNumberInstance();
        numberFormat.setGroupingUsed(true);
        numberFormat.setMaximumFractionDigits(n2);
        numberFormat.setMinimumFractionDigits(0);
        DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
        for (n = 0; n < vector2.size(); ++n) {
            object = (BinBound)vector2.elementAt(n);
            DM4JNumericFormat.AdjustFormat(((BinBound)object).m_lowerBound, ((BinBound)object).m_upperBound, decimalFormat);
        }
        for (n = 0; n < vector2.size(); ++n) {
            String[] stringArray;
            BinBound binBound;
            object = null;
            String string3 = null;
            String string4 = null;
            stringBuffer.append("WHEN ");
            BinBound binBound2 = (BinBound)vector2.elementAt(n);
            if (n == 0) {
                if (vector2.size() == 1) {
                    string3 = " < " + DM4JNumericFormat.SQLFormat(binBound2.m_upperBound, decimalFormat);
                } else {
                    binBound = (BinBound)vector2.elementAt(1);
                    stringArray = DM4JNumericFormat.SQLFormat(binBound2.m_upperBound, binBound.m_upperBound, decimalFormat);
                    string3 = " < " + stringArray[0];
                }
                string4 = " < " + DM4JNumericFormat.SQLFormat(binBound2.m_upperBound, decimalFormat);
                object = DiscretizeDataSource.appendSingleQuotes(string4);
            } else if (n == vector2.size() - 1) {
                string4 = " > " + DM4JNumericFormat.SQLFormat(binBound2.m_lowerBound, decimalFormat);
                object = DiscretizeDataSource.appendSingleQuotes(string4);
                string3 = " > " + DM4JNumericFormat.SQLFormat(binBound2.m_lowerBound, decimalFormat);
            } else {
                binBound = (BinBound)vector2.elementAt(n - 1);
                stringArray = DM4JNumericFormat.SQLFormat(binBound.m_upperBound, binBound2.m_upperBound, decimalFormat);
                string4 = stringArray[0] + " - " + stringArray[1];
                object = DiscretizeDataSource.appendSingleQuotes(string4);
                string3 = " <= " + DM4JNumericFormat.SQLFormat(binBound2.m_upperBound, decimalFormat);
            }
            stringBuffer.append(string + string3 + " THEN " + (String)object);
            stringBuffer.append("\n");
            hashtable.put(object, string4);
            vector.add(object);
        }
        stringBuffer.append("else null end) " + string);
        this.setMapCategorytoRange(this.getAttributeRow(string2), hashtable);
        this.setAllCategorytoRangeList(this.getAttributeRow(string2), vector);
    }

    private void prepareEqWidthDefinitionLabelsTX(BinBoundMap binBoundMap, String string, String string2) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Vector<String> vector = new Vector<String>();
        Vector vector2 = binBoundMap.getBinBounds(string);
        for (int i = 0; i < vector2.size(); ++i) {
            String string3 = String.valueOf(i + 1);
            String string4 = null;
            BinBound binBound = (BinBound)vector2.elementAt(i);
            if (i == 0) {
                string4 = " <= " + DM4JNumericFormat.format(binBound.m_upperBound);
            } else if (i == vector2.size() - 1) {
                string4 = " >= " + DM4JNumericFormat.format(binBound.m_lowerBound);
            } else {
                BinBound binBound2 = (BinBound)vector2.elementAt(i - 1);
                string4 = DM4JNumericFormat.format(binBound2.m_upperBound) + " - " + DM4JNumericFormat.format(binBound.m_upperBound);
            }
            hashtable.put(DiscretizeDataSource.appendSingleQuotes(string3), string4);
            vector.add(DiscretizeDataSource.appendSingleQuotes(string3));
        }
        this.setMapCategorytoRange(this.getAttributeRow(string2), hashtable);
        this.setAllCategorytoRangeList(this.getAttributeRow(string2), vector);
    }

    public void clearMapCategorytoRange(int n) {
        Hashtable hashtable = this.getMapCategorytoRange(n);
        if (hashtable != null) {
            hashtable.clear();
        }
        this.setMapCategorytoRange(n, null);
        Vector vector = this.getAllCategorytoRangeList(n);
        if (vector != null) {
            vector.clear();
        }
        this.setAllCategorytoRangeList(n, null);
    }

    public void setMapCategorytoRange(int n, Hashtable hashtable) {
        this.setData(COLUMN_NAMES.EXTRA_DATA_3, n, hashtable);
    }

    public Hashtable getMapCategorytoRange(int n) {
        return (Hashtable)this.getData(COLUMN_NAMES.EXTRA_DATA_3, n);
    }

    public void setAllCategorytoRangeList(int n, Vector vector) {
        this.setData(COLUMN_NAMES.EXTRA_DATA_6, n, vector);
    }

    public Vector getAllCategorytoRangeList(int n) {
        return (Vector)this.getData(COLUMN_NAMES.EXTRA_DATA_6, n);
    }

    protected Vector getOther(Vector vector, int n) {
        Vector<String> vector2 = new Vector<String>();
        Vector vector3 = this.getDistinctValues(n);
        for (int i = 0; i < vector3.size(); ++i) {
            String string = (String)vector3.elementAt(i);
            boolean bl = false;
            for (int j = 0; j < vector.size(); ++j) {
                CategoricBin categoricBin = (CategoricBin)vector.elementAt(j);
                for (int k = 0; k < categoricBin.values.size(); ++k) {
                    if (0 == string.compareTo((String)categoricBin.values.elementAt(k))) {
                        bl = true;
                        break;
                    }
                    if (bl) break;
                }
                if (bl) break;
            }
            if (bl) continue;
            vector2.add(string);
        }
        return vector2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getDistinctValues(int n) {
        String string = this.getAttributeName(n);
        Connection connection = null;
        Vector vector = new Vector();
        try {
            connection = DM4JConnectionManager.getDbConnection();
            vector = this.m_isTransactional && !this.m_bSingleMetric ? this.getTXDistinctValues(connection, string) : this.get2DDistinctValues(connection, string);
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector get2DDistinctValues(Connection connection, String string) {
        String string2 = "select distinct {0} from {1} where {0} is not null";
        String string3 = MessageFormat.format(string2, "\"" + this.getColumnName(string) + "\"", this.getSampledDataLocation());
        Statement statement = null;
        ResultSet resultSet = null;
        Vector<String> vector = new Vector<String>();
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                String string4 = resultSet.getString(1);
                vector.add(string4);
            }
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector getTXDistinctValues(Connection connection, String string) {
        String string2 = "select distinct {0} from {1} where {2}={3} and {0} is not null";
        String string3 = MessageFormat.format(string2, "\"" + this.m_valueMapping + "\"", this.getSampledDataLocation(), "\"" + this.m_attributeMapping + "\"", "'" + string + "'");
        Statement statement = null;
        ResultSet resultSet = null;
        Vector<String> vector = new Vector<String>();
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                String string4 = resultSet.getString(1);
                vector.add(string4);
            }
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanNumericBinBoundary(int[] nArray) {
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            String string = "\"" + this.m_userSchemaName + "\".\"" + this.m_numericalDiscretizationTableName + "\"";
            this.cleanBinBoundary(connection, string, nArray);
        }
        catch (Exception exception) {
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    protected void cleanBinBoundary(Connection connection, String string, int[] nArray) {
        String string2 = new String("DELETE FROM " + string + " WHERE \n");
        int n = nArray.length / 10;
        int n2 = nArray.length - n * 10;
        if (n2 > 0) {
            ++n;
        }
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            StringBuffer stringBuffer = new StringBuffer(string2);
            for (int j = 0; j < 10; ++j) {
                String string3;
                int n4 = i * 10 + j;
                String string4 = this.getAttributeName(nArray[n4]);
                try {
                    string3 = TransformsDirector.getReplacedString(string4, "'", "''");
                }
                catch (Exception exception) {
                    string3 = string4;
                }
                stringBuffer.append("COLUMN_NAME = '" + string3 + "'");
                if (j < 9 && n4 != nArray.length - 1) {
                    stringBuffer.append(" OR ");
                }
                if (++n3 >= nArray.length) break;
            }
            try {
                DM4JTransformation.removeAttributesFromBinBoundaryTable(connection, stringBuffer.toString());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quantileBinningTXMultipleBins(Connection connection, String string, Hashtable hashtable, String string2, int n) {
        String string3 = "SELECT " + this.m_attributeMapping + ", MIN(VAL_VALUE) LOW_BOUND, MAX(VAL_VALUE) UP_BOUND FROM " + "( SELECT " + this.m_attributeMapping + ", " + this.m_valueMapping + " VAL_VALUE, NTILE(TO_CHAR(ABS(" + String.valueOf(n) + "))) OVER(PARTITION BY " + this.m_attributeMapping + " ORDER BY " + this.m_valueMapping + " ASC) qtile " + "FROM (" + (string2 == null ? this.getSampledDataLocation() : string2) + ") WHERE " + this.m_valueMapping + " IS NOT NULL " + "AND " + this.m_attributeMapping + " = '" + string + "'" + ") " + "GROUP BY qtile, " + this.m_attributeMapping + " ORDER BY " + this.m_attributeMapping + ", qtile ASC";
        Vector<Object> vector = new Vector<Object>();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            Object object;
            Hashtable<Object, BinVectors> hashtable2 = new Hashtable<Object, BinVectors>();
            Vector vector2 = null;
            Vector vector3 = null;
            int n2 = 0;
            statement = connection.prepareStatement(string3);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                object = resultSet.getString(1);
                if (null == hashtable2.get(object)) {
                    vector2 = new Vector();
                    vector3 = new Vector();
                    hashtable2.put(object, new BinVectors(vector2, vector3));
                }
                double d = resultSet.getDouble(2);
                double d2 = resultSet.getDouble(3);
                vector.add(object);
                vector2.add(new Double(d));
                vector3.add(new Double(d2));
            }
            n2 = hashtable2.size();
            object = hashtable2.keys();
            while (object.hasMoreElements()) {
                QuantileDefinition quantileDefinition;
                String string4 = (String)object.nextElement();
                Integer n3 = (Integer)hashtable.get(string4);
                if (n3 == null) continue;
                BinVectors binVectors = (BinVectors)hashtable2.get(string4);
                vector2 = binVectors.getMinVector();
                vector3 = binVectors.getMaxVector();
                n2 = vector3.size();
                Vector<QuantileDefinition> vector4 = new Vector<QuantileDefinition>();
                if (n2 == 0) continue;
                vector2.add(vector3.elementAt(vector3.size() - 1));
                Double[] doubleArray = vector2.toArray(new Double[vector2.size()]);
                Double[] doubleArray2 = vector3.toArray(new Double[vector3.size()]);
                if (doubleArray[0].doubleValue() == doubleArray2[n2 - 1].doubleValue()) continue;
                int n4 = 0;
                for (int i = 0; i <= n2; ++i) {
                    if (i <= n2 - 1 && doubleArray[i].doubleValue() == doubleArray[i + 1].doubleValue()) continue;
                    quantileDefinition = new QuantileDefinition(n4, doubleArray[i]);
                    vector4.add(quantileDefinition);
                    ++n4;
                }
                Vector<Bin> vector5 = new Vector<Bin>();
                quantileDefinition = (QuantileDefinition)vector4.elementAt(0);
                for (int i = 1; i < vector4.size(); ++i) {
                    QuantileDefinition quantileDefinition2 = (QuantileDefinition)vector4.elementAt(i);
                    String string5 = String.valueOf(Double.MIN_VALUE);
                    Bin bin = new Bin(quantileDefinition2.getBinNumber() - 1, quantileDefinition.getMinNumber(), quantileDefinition2.getMinNumber());
                    vector5.add(bin);
                    quantileDefinition = quantileDefinition2;
                }
                this.setBinBounds(n3, vector5);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
    }

    protected void processNumTxSource(String string, String string2, String string3, Object object, Hashtable hashtable) throws Exception {
    }

    public String applyTreatment(String string) {
        return "\"" + string + "\"";
    }

    public void setComplexAttribute(int n, String string) {
        this.setData(COLUMN_NAMES.COMPLEX_ATTRIBUTE, n, string);
    }

    public String getComplexAttribute(int n) {
        return (String)this.getData(COLUMN_NAMES.COMPLEX_ATTRIBUTE, n);
    }

    public void setSparsityFlag(int n, boolean bl) {
        this.setData(COLUMN_NAMES.SPARSITY_FLAG, n, new Boolean(bl));
    }

    public boolean getSparsityFlag(int n) {
        Boolean bl = (Boolean)this.getData(COLUMN_NAMES.SPARSITY_FLAG, n);
        return bl;
    }

    boolean isSelected(int[] nArray, int n) {
        if (nArray == null || nArray.length == 0) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public String getColumnName(String string) {
        String string2 = this.m_bSingleMetric ? this.m_lds.getValueColumn(string) : string;
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int calculateBinNumber(String string, String string2) {
        Connection connection = null;
        int n = 3;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            double[] dArray = this.getEqualWidthStats(connection, string2, string);
            n = this.autoBinnumberCalculation(string2, (int)dArray[STAT_TOTAL], dArray[STAT_STDEV], dArray[STAT_MAX], dArray[STAT_MIN]);
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                System.out.println(exception);
            }
            n = 3;
        }
        finally {
            try {
                connection.close();
            }
            catch (Exception exception) {}
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int autoBinnumberCalculation(String string, int n, double d, double d2, double d3) {
        int n2 = 3;
        try {
            String string2;
            AttributeType attributeType;
            int n3 = 50000;
            if (n > 0) {
                if (n < 50000) {
                    n3 = n;
                }
                int n4 = 0;
                if (d == 0.0) {
                    n4 = 1;
                } else {
                    n4 = (int)Math.min(Math.pow(n3, 0.3333333333333333) * 0.9 * (d2 - d3) / (3.49 * d), 100.0);
                    if (n4 < 3) {
                        n4 = 3;
                    }
                }
                n2 = n4;
            }
            if ((attributeType = (AttributeType)m_AttributeType.get(string2 = this.m_lds.getMiningType(string))) != null && attributeType.equals(AttributeType.numerical)) {
                n2 = (int)Math.min((double)n2, d2 - d3 + 1.0);
            }
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                System.out.println(exception);
            }
        }
        return n2;
    }

    public DiscretizationStepOptions getDiscretizationStepOptions() {
        return this.options;
    }

    public void setDiscretizationStepOptions(DiscretizationStepOptions discretizationStepOptions) {
        this.options = discretizationStepOptions;
    }

    static /* synthetic */ int access$008() {
        return A++;
    }

    static /* synthetic */ int access$000() {
        return A;
    }

    static {
        TEMPLATE_START_AUTO_BIN = "COUNT({0}) COUNT{1} , MAX({0}) Max{1} , MIN({0}) Min{1}, VARIANCE({0}) as Variance{1}";
        m_AttributeType = new Hashtable();
        QUANTILE_BINNING = ResourceUtilities.getUILabel("QUANTILE_BINNING_STRATEGY_DIALOG_DESCRIPTION");
        EQUAL_WIDTH_BINNING = ResourceUtilities.getUILabel("EQUAL_WIDTH_BINNING_STRATEGY_DIALOG_DESCRIPTION");
        TOPN_BINNING = ResourceUtilities.getUILabel("TOPN_BINNING_STRATEGY_DIALOG_DESCRIPTION");
        NONE = ResourceUtilities.getUILabel("NONE");
        m_AttributeType.put(AttributeType.categorical.name(), AttributeType.categorical);
        m_AttributeType.put(AttributeType.numerical.name(), AttributeType.numerical);
        m_AttributeType.put(AttributeType.ordinal.name(), AttributeType.ordinal);
        m_AttributeType.put(AttributeType.notSpecified.name(), AttributeType.notSpecified);
        STAT_TOTAL = 0;
        STAT_AVERAGE = 1;
        STAT_MAX = 2;
        STAT_MIN = 3;
        STAT_VARIANCE = 4;
        STAT_STDEV = 5;
        STAT_SKEW = 6;
        STAT_KURT = 7;
        NUMBER_STATS = STAT_KURT + 1;
        A = 0;
        COLUMN_COUNT = COLUMN_NAMES.LAST;
        STAT_SQL_EQ_WIDTH_1ST_ORDER = "select count({0}) as N, avg({0}) as Average, MAX({0}) Max , MIN({0}) Min, VARIANCE({0}) as Variance from ({1}) WHERE {0} IS NOT NULL";
        STAT_SQL_EQ_WIDTH_1ST_ORDER_TX = "SELECT count({0}) as N, avg({0}) as Average, MAX({0}) Max , MIN({0}) Min, VARIANCE({0}) as Variance from {1} WHERE {2} = {3} group by {2}";
        STAT_SQL_EQ_WIDTH_STDEV_COUNT = "select count({0}) as N, VARIANCE({0}) as Variance from ({1}) WHERE {0} IS NOT NULL";
        STAT_SQL_EQ_WIDTH_STDEV_COUNT_TX = "select count({0}) as N, VARIANCE({0}) as Variance from ({1}) WHERE {2}={3}";
        STAT_SQL_CUSTOM_1ST_ORDER = new String[]{"select count({0}) as N, avg({0}) as Average, MAX({0}) Max, MIN({0}) Min, VARIANCE({0}) as Variance from {1} ", "WHERE {0} IS NOT NULL AND {0} >= {2} AND {0} <= {3}"};
        STAT_SQL_CUSTOM_1ST_ORDER_TX = new String[]{"select count({0}) as N, avg({0}) as Average, MAX({0}) Max, MIN({0}) Min, VARIANCE({0}) as Variance ", "from {1} WHERE {2}={3} AND {0} >= {4} AND {0} <= {5}"};
        STAT_SQL_CUSTOM_STDEV_COUNT = new String[]{"select count({0}) as N, VARIANCE({0}) as Variance from {1} ", "WHERE {0} IS NOT NULL AND {0} >= {2} AND {0} <= {3}"};
        STAT_SQL_CUSTOM_STDEV_COUNT_TX = new String[]{"select count({0}) as N, VARIANCE({0}) as Variance from {1} ", "WHERE {0} IS NOT NULL AND {0} >= {2} AND {0} <= {3}"};
        STAT_SQL_WINSORIZE_1ST_ORDER = new String[]{"SELECT count(val) as N, AVG(val) Average, MAX(val) Max, MIN(val) Min, VARIANCE(val) as Variance  FROM (SELECT val, ROW_NUMBER() OVER (ORDER BY val ASC) pos, COUNT(*) OVER () cnt ", "FROM (SELECT {0} val  FROM {1} ) WHERE val IS NOT NULL) WHERE pos >= TRUNC({2}*cnt/100) + 1 AND pos <= cnt - TRUNC({2}*cnt/100)"};
        STAT_SQL_WINSORIZE_1ST_ORDER_TX = new String[]{"SELECT count(val) as N, AVG(val) Average, MAX(val) Max, MIN(val) Min, VARIANCE(val) as Variance ", "FROM ( SELECT val, ROW_NUMBER() OVER (ORDER BY val ASC) pos, COUNT(*) OVER () cnt ", "FROM (SELECT {0} val  FROM {1} WHERE {3} = {4} ) WHERE val IS NOT NULL) ", "WHERE pos >= TRUNC({2}*cnt/100) + 1 AND pos <= cnt - TRUNC({2}*cnt/100)"};
        STAT_SQL_WINSORIZE_STDEV_COUNT = new String[]{"SELECT count(val) as N, VARIANCE(val) as Variance  FROM (SELECT val, ROW_NUMBER() OVER (ORDER BY val ASC) pos, COUNT(*) OVER () cnt ", "FROM (SELECT {0} val  FROM {1} ) WHERE val IS NOT NULL) WHERE pos >= TRUNC({2}*cnt/100) + 1 AND pos <= cnt - TRUNC({2}*cnt/100)"};
        STAT_SQL_WINSORIZE_STDEV_COUNT_TX = new String[]{"SELECT count(val) as N, VARIANCE(val) as Variance  FROM (SELECT val, ROW_NUMBER() OVER (ORDER BY val ASC) pos, COUNT(*) OVER () cnt ", "FROM (SELECT {0} val  FROM {1} where {3}={4}) WHERE val IS NOT NULL) WHERE pos >= TRUNC({2}*cnt/100) + 1 AND pos <= cnt - TRUNC({2}*cnt/100)"};
        STAT_SQL_EQ_WIDTH_2ND_ORDER = new String[]{"select sum( power({1}-{0},3) / ({2}*power({3},3) ) ) as Skew, ", "sum( power({1}-{0},4) /( {2}*power({3},4)))-3 as Kurtosis ", "from ({4}) WHERE {1} IS NOT NULL"};
        STAT_SQL_EQ_WIDTH_2ND_ORDER_TX = new String[]{"select sum( power({1}-{0},3) / ({2}*power({3},3) ) ) as Skew, ", "sum( power({1}-{0},4) /( {2}*power({3},4)))-3 as Kurtosis ", "from ({4}) WHERE {5} = {6}"};
        STAT_SQL_CUSTOM_2ND_ORDER = new String[]{"select sum( power({1}-{0},3) / ({2}*power({3},3) ) ) as Skew, ", "sum( power({1}-{0},4) /( {2}*power({3},4)))-3 as Kurtosis ", "from {4} WHERE {1} IS NOT NULL AND {1} >= {5} AND {1} <= {6}"};
        STAT_SQL_CUSTOM_2ND_ORDER_TX = new String[]{"select sum( power({1}-{0},3) / ({2}*power({3},3) ) ) as Skew, ", "sum( power({1}-{0},4) /( {2}*power({3},4)))-3 as Kurtosis ", "from {4} WHERE {7}={8} AND {1} >= {5} AND {1} <= {6}"};
        STAT_SQL_WINSORIZE_2ND_ORDER = new String[]{"select sum( (power(val-{0},3) / ({2}*power({3},3) ) ) ) as Skew, ", "sum( power(val-{0},4) /( {2}*power({3},4)))-3 as Kurtosis ", "FROM (SELECT val, ROW_NUMBER() OVER (ORDER BY val ASC) pos, COUNT(*) OVER () cnt ", "FROM (SELECT {1} val  FROM {4} ) WHERE val IS NOT NULL) WHERE pos >= TRUNC({5}*cnt/100) + 1 AND pos <= cnt - TRUNC({5}*cnt/100)"};
        STAT_SQL_WINSORIZE_2ND_ORDER_TX = new String[]{"select sum( (power(val-{0},3) / ({2}*power({3},3) ) ) ) as Skew, ", "sum( power(val-{0},4) /( {2}*power({3},4)))-3 as Kurtosis ", "FROM (SELECT val, ROW_NUMBER() OVER (ORDER BY val ASC) pos, COUNT(*) OVER () cnt ", "FROM (SELECT {6} val  FROM {4} WHERE {7}={1} ) WHERE val IS NOT NULL) WHERE pos >= TRUNC({5}*cnt/100) + 1 AND pos <= cnt - TRUNC({5}*cnt/100)"};
        HISTOGRAM_VALUES = new String[]{"SELECT {0} BIN_NUMBER, COUNT(*) FREQUENCY FROM (", ") GROUP BY {0} ORDER BY BIN_NUMBER"};
        HISTOGRAM_VALUES_LABELS = new String[]{"SELECT {0} BIN_NUMBER,  DECODE ({0}, {1}) BINID, COUNT(*) FREQUENCY FROM (", ") GROUP BY {0} ORDER BY BINID"};
        HISTOGRAM_VALUES_TX = new String[]{"SELECT {0} BIN_NUMBER, COUNT(*) FREQUENCY FROM (", ") WHERE {2}={1} GROUP BY {0} order by {0}"};
        DEFAULT_BIN_NUMBER = 10;
        DEFAULT_ABN_BIN_NUMBER = 5;
        DEFAULT_TAIL_PERCENT = 0.0;
        RESULT_VIEW_NAME = "DM4J$V";
        SAMPLING_TABLE_PREFIX = "DM4J$T";
        NUMERIC_BIN_TABLE_PREFIX = "DM4J$N";
        CATEGORIC_BIN_TABLE_PREFIX = "DM4J$C";
        items = new String[COLUMN_COUNT];
        DiscretizeDataSource.items[COLUMN_NAMES.NAME] = ResourceUtilities.getUILabel("DISCRETIZATION_SETTINGS_ATTRIBUTE_LIST_NAME");
        DiscretizeDataSource.items[COLUMN_NAMES.MTYPE] = "Mining Attribute Type";
        DiscretizeDataSource.items[COLUMN_NAMES.DTYPE] = "Attribute Data Type";
        DiscretizeDataSource.items[COLUMN_NAMES.BINNUMBER] = "Bins Number";
        DiscretizeDataSource.items[COLUMN_NAMES.TAILPERCENT] = "Tail Percent";
        DiscretizeDataSource.items[COLUMN_NAMES.BINBOUNDS] = "Bin Boundaries";
        DiscretizeDataSource.items[COLUMN_NAMES.AVG] = ResourceUtilities.getUILabel("DISCRETIZATION_SETTINGS_ATTRIBUTE_LIST_AVERAGE");
        DiscretizeDataSource.items[COLUMN_NAMES.MAX] = ResourceUtilities.getUILabel("DISCRETIZATION_SETTINGS_ATTRIBUTE_LIST_MAX");
        DiscretizeDataSource.items[COLUMN_NAMES.MIN] = ResourceUtilities.getUILabel("DISCRETIZATION_SETTINGS_ATTRIBUTE_LIST_MIN");
        DiscretizeDataSource.items[COLUMN_NAMES.MISSING_PERCENT] = ResourceUtilities.getUILabel("MISSING_VALUES_PERCENT");
        DiscretizeDataSource.items[COLUMN_NAMES.TOTAL] = ResourceUtilities.getUILabel("DISCRETIZATION_SETTINGS_ATTRIBUTE_SIZE");
        DiscretizeDataSource.items[COLUMN_NAMES.DISTINCT] = ResourceUtilities.getUILabel("DISTINCT_COUNT");
        DiscretizeDataSource.items[COLUMN_NAMES.DROP_ATTRIBUTE] = ResourceUtilities.getUILabel("DROP_ATTRIBUTE");
        DiscretizeDataSource.items[COLUMN_NAMES.BINTYPE] = ResourceUtilities.getUILabel("BINNING_STRATEGY_GRID_TITLE");
        DiscretizeDataSource.items[COLUMN_NAMES.VAR] = ResourceUtilities.getUILabel("DISCRETIZATION_SETTINGS_ATTRIBUTE_LIST_VAR");
        DiscretizeDataSource.items[COLUMN_NAMES.STDDEV] = ResourceUtilities.getUILabel("DISCRETIZATION_SETTINGS_ATTRIBUTE_LIST_SIGMA");
        DiscretizeDataSource.items[COLUMN_NAMES.SKEW] = ResourceUtilities.getUILabel("DISCRETIZATION_SETTINGS_ATTRIBUTE_LIST_SKEW");
        DiscretizeDataSource.items[COLUMN_NAMES.KURT] = ResourceUtilities.getUILabel("DISCRETIZATION_SETTINGS_ATTRIBUTE_LIST_KURT");
        DiscretizeDataSource.items[COLUMN_NAMES.VIEW_DEFN] = "View Definition";
        DiscretizeDataSource.items[COLUMN_NAMES.DISPLAY_NAMES] = "Display Names";
        DiscretizeDataSource.items[COLUMN_NAMES.EXTRA_DATA_1] = "";
        DiscretizeDataSource.items[COLUMN_NAMES.EXTRA_DATA_2] = "";
        DiscretizeDataSource.items[COLUMN_NAMES.EXTRA_DATA_3] = "";
        DiscretizeDataSource.items[COLUMN_NAMES.EXTRA_DATA_4] = "";
        DiscretizeDataSource.items[COLUMN_NAMES.EXTRA_DATA_5] = "";
        DiscretizeDataSource.items[COLUMN_NAMES.DEFAULT_ALGORITHM] = "";
        DiscretizeDataSource.items[COLUMN_NAMES.COMPLEX_ATTRIBUTE] = "";
        DiscretizeDataSource.items[COLUMN_NAMES.SPARSITY_FLAG] = ResourceUtilities.getUILabel("DATA_USAGE_SPARSITY");
        DiscretizeDataSource.items[COLUMN_NAMES.EXTRA_DATA_6] = "";
    }

    static class BinBoundMap {
        Hashtable m_ht;

        BinBoundMap(int n) {
            this.m_ht = new Hashtable(n);
        }

        void addBinBound(String string, BinBound binBound) {
            Vector<BinBound> vector = (Vector<BinBound>)this.m_ht.get(string);
            if (vector == null) {
                vector = new Vector<BinBound>();
                vector.add(binBound);
                this.m_ht.put(string, vector);
            } else {
                vector.add(binBound);
            }
        }

        Vector getBinBounds(String string) {
            return (Vector)this.m_ht.get(string);
        }

        boolean isEmpty(String string) {
            Vector vector = (Vector)this.m_ht.get(string);
            return vector == null || vector.size() == 0;
        }

        int size(String string) {
            Vector vector = (Vector)this.m_ht.get(string);
            if (vector == null || vector.size() == 0) {
                return 0;
            }
            return vector.size();
        }

        void clear() {
            Enumeration enumeration = this.m_ht.keys();
            if (enumeration == null) {
                return;
            }
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Vector vector = (Vector)this.m_ht.get(string);
                if (vector == null) continue;
                vector.clear();
            }
            this.m_ht.clear();
        }
    }

    public static class BinBound {
        public int m_binNumber;
        public double m_lowerBound;
        public double m_upperBound;

        BinBound(int n, double d, double d2) {
            this.m_binNumber = n;
            this.m_lowerBound = d;
            this.m_upperBound = d2;
        }
    }

    public static class BinVectors {
        Vector mins;
        Vector maxs;

        public BinVectors() {
        }

        public void setMinVector(Vector vector) {
            this.mins = vector;
        }

        public void setMaxVector(Vector vector) {
            this.maxs = vector;
        }

        public BinVectors(Vector vector, Vector vector2) {
            this.mins = vector;
            this.maxs = vector2;
        }

        public Vector getMinVector() {
            return this.mins;
        }

        public Vector getMaxVector() {
            return this.maxs;
        }
    }

    public static class QuantileDefinition {
        int binNumber;
        double minValue;

        public QuantileDefinition(int n, double d) {
            this.binNumber = n;
            this.minValue = d;
        }

        public int getBinNumber() {
            return this.binNumber;
        }

        public double getMinNumber() {
            return this.minValue;
        }
    }

    class DataInfo {
        public String m_AttrType;
        public String m_DataType;

        public DataInfo(String string, String string2) {
            this.m_AttrType = string;
            this.m_DataType = string2;
        }
    }

    public static interface COLUMN_NAMES {
        public static final int NAME = DiscretizeDataSource.access$008();
        public static final int MTYPE = DiscretizeDataSource.access$008();
        public static final int DTYPE = DiscretizeDataSource.access$008();
        public static final int BINNUMBER = DiscretizeDataSource.access$008();
        public static final int TAILPERCENT = DiscretizeDataSource.access$008();
        public static final int BINBOUNDS = DiscretizeDataSource.access$008();
        public static final int AVG = DiscretizeDataSource.access$008();
        public static final int MAX = DiscretizeDataSource.access$008();
        public static final int MIN = DiscretizeDataSource.access$008();
        public static final int MISSING_PERCENT = DiscretizeDataSource.access$008();
        public static final int TOTAL = DiscretizeDataSource.access$008();
        public static final int DISTINCT = DiscretizeDataSource.access$008();
        public static final int DROP_ATTRIBUTE = DiscretizeDataSource.access$008();
        public static final int BINTYPE = DiscretizeDataSource.access$008();
        public static final int VAR = DiscretizeDataSource.access$008();
        public static final int STDDEV = DiscretizeDataSource.access$008();
        public static final int SKEW = DiscretizeDataSource.access$008();
        public static final int KURT = DiscretizeDataSource.access$008();
        public static final int VIEW_DEFN = DiscretizeDataSource.access$008();
        public static final int DISPLAY_NAMES = DiscretizeDataSource.access$008();
        public static final int EXTRA_DATA_1 = DiscretizeDataSource.access$008();
        public static final int EXTRA_DATA_2 = DiscretizeDataSource.access$008();
        public static final int EXTRA_DATA_3 = DiscretizeDataSource.access$008();
        public static final int EXTRA_DATA_4 = DiscretizeDataSource.access$008();
        public static final int EXTRA_DATA_5 = DiscretizeDataSource.access$008();
        public static final int DEFAULT_ALGORITHM = DiscretizeDataSource.access$008();
        public static final int COMPLEX_ATTRIBUTE = DiscretizeDataSource.access$008();
        public static final int SPARSITY_FLAG = DiscretizeDataSource.access$008();
        public static final int EXTRA_DATA_6 = DiscretizeDataSource.access$008();
        public static final int LAST = DiscretizeDataSource.access$000();
    }
}

