/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.sql.Connection;
import oracle.bali.ewt.event.Cancelable;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.browser.LongRunningProcess;
import oracle.dmt.dm4j.datasources.DiscretizeDataSource;

public class DiscretizeCustomStats
extends LongRunningProcess
implements Cancelable {
    protected boolean m_canceled = false;
    protected DiscretizeDataSource m_model;
    private String m_columnName;
    private double m_lowerBound;
    private double m_upperBound;
    private double[] m_stats = null;
    private int m_row;

    public DiscretizeCustomStats(DiscretizeDataSource discretizeDataSource, String string, double d, double d2, int n) {
        this.m_model = discretizeDataSource;
        this.m_columnName = string;
        this.m_lowerBound = d;
        this.m_upperBound = d2;
        this.m_row = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            this.m_stats = this.m_model.getCustomStats(connection, this.m_columnName, this.m_lowerBound, this.m_upperBound);
            if (this.m_stats != null) {
                this.m_model.set1stOrderStatistics(this.m_row, this.m_stats);
            }
            this.m_model.getSingleNumericAttributeViewDefinition(connection, this.m_row, true);
            this.getProgressBar().setDoneStatus();
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
            this.setException(exception);
            this.getProgressBar().setDoneStatus();
        }
        finally {
            try {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean isCancelled() {
        return this.m_canceled;
    }

    public void cancel() {
        this.m_canceled = true;
    }

    public double[] getCustomStats() {
        return this.m_stats;
    }
}

