/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.bali.ewt.event.Cancelable;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.datasources.DiscretizeDataSource;
import oracle.dmt.dm4j.datasources.ExtraDataSource;
import oracle.dmt.dm4j.datasources.LDSDataSource;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.commonsteps.DataState;
import oracle.dmt.odm.binning.Bin;
import oracle.dmt.odm.binning.BinningType;
import oracle.dmt.odm.binning.CategoricBin;
import oracle.dmt.odm.binning.DM4JTransformation;

public class DiscretizationLDSDataSource
extends LDSDataSource
implements Cancelable {
    protected ProgressBar m_progressBar = null;
    private boolean m_canceled = false;
    protected Statement m_statement;
    private Exception m_exception = null;
    protected ExtraDataSource m_extraModel;

    public DiscretizationLDSDataSource(Connection connection, DataState dataState, String string, String string2, boolean bl, boolean bl2) {
        super(connection, dataState, string, string2, bl, bl2, false);
    }

    public DiscretizationLDSDataSource(Connection connection, DataState dataState, String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        super(connection, dataState, string, string2, bl, bl2, bl3);
    }

    public void setProgressBar(ProgressBar progressBar) {
        this.m_progressBar = progressBar;
    }

    protected ProgressBar getProgressBar() {
        return this.m_progressBar;
    }

    public boolean isCancelled() {
        return this.m_canceled;
    }

    public void populate() {
        this.m_extraModel.populateTable(this);
    }

    public void cancel() {
        if (this.m_statement != null) {
            try {
                this.m_statement.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_canceled = true;
    }

    protected void setException(Exception exception) {
        this.m_exception = exception;
    }

    public Exception getException() {
        return this.m_exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createData() throws Exception {
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            super.createData();
            this.m_extraModel = !this.m_FormatIsTransactional ? new ExtraDataSource(this.getSamplingViewDefinition()) : (!this.isSingleMetric() ? new ExtraDataSource(connection, this.m_schema, this.getSamplingTXNViewDefinition(), this.m_attribute_column_name, this.m_value_column_name, this.m_seqid_column_name) : new ExtraDataSource(this.getSamplingViewDefinition(), this.m_AttributeNameValueMap, true));
            this.m_extraModel.populateTable(this);
            if (!this.m_FormatIsTransactional) {
                this.countCasesFrom2DDBTable(connection, this.m_table, this.m_schema);
            } else if (!this.isSingleMetric()) {
                this.countCasesFromTransactionalDBTable(connection, this.m_dataState.getSelectedTableName(), this.m_schema, this.m_attribute_column_name);
            } else {
                this.countCasesFromTransactionalDBTable(connection, this.m_dataState.getSelectedTableName(), this.m_schema, this.m_value_column_name);
            }
        }
        finally {
            this.m_progressBar.setDoneStatus();
            if (connection != null) {
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public String getDataType(String string) {
        int n = this.getAttributeIndex(string);
        if (n != -1) {
            return (String)this.getData(2, n);
        }
        return null;
    }

    public String getMiningType(String string) {
        int n = this.getAttributeIndex(string);
        if (n != -1) {
            return (String)this.getData(3, n);
        }
        return null;
    }

    public String getMiningType(int n) {
        return (String)this.getData(3, n);
    }

    public boolean isNumeric(int n) {
        String string = this.getMiningType(n);
        return 0 == string.compareTo("numerical");
    }

    public Vector getNonUniqueAttributes() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            Boolean bl = (Boolean)this.getData(15, i);
            if (bl != null && bl.booleanValue()) continue;
            String string = (String)this.getData(1, i);
            vector.add(string);
        }
        return vector;
    }

    public Vector getAllAttributes() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            String string = (String)this.getData(1, i);
            vector.add(string);
        }
        return vector;
    }

    public String getAttributeName(int n) {
        return (String)this.getData(1, n);
    }

    public Integer getDistinctCount(int n) {
        return (Integer)this.getData(10, n);
    }

    public Integer getNumberOfBins(int n) {
        return this.m_extraModel.getNumberOfBins(n);
    }

    public void markAttributeBinned(int n, BinningType binningType, int n2) {
        this.m_extraModel.markAttributeBinned(n, binningType, n2);
    }

    public void setNumberOfBins(int n, int n2) {
        this.m_extraModel.setNumberOfBins(n, n2);
    }

    public boolean isAttributeBinned(int n) {
        return this.m_extraModel.isAttributeBinned(n);
    }

    public void setBinBounds(int n, Vector vector) {
        this.m_extraModel.setBinBounds(n, vector);
    }

    public StringBuffer getViewDefinition(int n) {
        return this.m_extraModel.getViewDefinition(n);
    }

    public void setViewDefinition(int n, StringBuffer stringBuffer) {
        this.m_extraModel.setViewDefinition(n, stringBuffer);
    }

    public void setNullCount(int n, int n2) {
        this.m_extraModel.setNullCount(n, n2);
    }

    public int getNullCount(int n) {
        return this.m_extraModel.getNullCount(n);
    }

    public Integer getTotalCount(int n) {
        return this.m_extraModel.getTotalCount(n);
    }

    public void setTotalCount(int n, int n2) {
        this.m_extraModel.setTotalCount(n, n2);
    }

    public void setBinType(int n, String string, int n2) {
        this.m_extraModel.setBinType(n, string, n2);
    }

    public String getBinType(int n) {
        return this.m_extraModel.getBinType(n);
    }

    public int getAttributeRow(String string) {
        return this.m_extraModel.getAttributeRow(string);
    }

    public Vector getBinBounds(int n) {
        return this.m_extraModel.getBinBounds(n);
    }

    public Double getSkew(int n) {
        return this.m_extraModel.getSkew(n);
    }

    public void setSkew(int n, Double d) {
        this.m_extraModel.setSkew(n, d);
    }

    public Double getKurtosis(int n) {
        return this.m_extraModel.getKurtosis(n);
    }

    public void setKurtosis(int n, Double d) {
        this.m_extraModel.setKurtosis(n, d);
    }

    public double[] getStats(int n) {
        return this.m_extraModel.getStats(n);
    }

    public boolean isTx() {
        return this.m_extraModel.isTX();
    }

    public void setStdev(int n, double d) {
        this.m_extraModel.setStdev(n, d);
    }

    public Double getSigma(int n) {
        return this.m_extraModel.getSigma(n);
    }

    public void setVariance(int n, double d) {
        this.m_extraModel.setVariance(n, d);
    }

    public Double getVariance(int n) {
        return this.m_extraModel.getVariance(n);
    }

    public Double getAverage(int n) {
        return this.m_extraModel.getAverage(n);
    }

    public Double getMin(int n) {
        return this.m_extraModel.getMin(n);
    }

    public Double getMax(int n) {
        return this.m_extraModel.getMax(n);
    }

    public void setStatsMode(int n, String string) {
        this.m_extraModel.setStatsMode(n, string);
    }

    public String getStatsMode(int n) {
        return this.m_extraModel.getStatsMode(n);
    }

    public void markAttributeUnBinned(int n) {
        this.m_extraModel.markAttributeUnBinned(n);
    }

    public Hashtable getDisplayNames(int n) {
        return this.m_extraModel.getDisplayNames(n);
    }

    public void setDisplayNames(int n, Hashtable hashtable) {
        this.m_extraModel.setDisplayNames(n, hashtable);
    }

    public void finishCleanUp() {
        this.m_allAttributes.clear();
        this.m_skippedAttributes.clear();
        this.removeRows(0, this.getRowCount());
        this.m_rowModel.removeItems(0, this.m_rowModel.getItemCount());
        this.m_NameRow.clear();
        if (this.m_extraModel != null) {
            this.m_extraModel.finishCleanUp();
        }
    }

    public void abortCleanUp() {
        this.m_allAttributes.clear();
        this.m_skippedAttributes.clear();
        this.removeRows(0, this.getRowCount());
        if (this.m_rowModel != null && 0 != this.m_rowModel.getItemCount()) {
            this.m_rowModel.removeItems(0, this.m_rowModel.getItemCount());
        }
        this.m_NameRow.clear();
        if (this.m_extraModel != null) {
            this.m_extraModel.abortCleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getTopNStats(int n, int n2) {
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            this.getTopNStats(connection, n, n2);
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void getTopNStats(Connection connection, int n, int n2) {
        String string = this.getAttributeName(n);
        if (this.isTx()) {
            this.getTopNStatsTX(connection, n, n2);
            this.getStatsModeTX(connection, string, n);
        } else {
            this.getTopNStats2D(connection, n, n2);
            this.getStatsMode2D(connection, this.getColumnName(string), n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getTopNStats2D(Connection connection, int n, int n2) {
        String string = String.valueOf(n2);
        String string2 = this.getAttributeName(n);
        String string3 = this.getColumnName(string2);
        Statement statement = null;
        ResultSet resultSet = null;
        Vector<CategoricBin> vector = new Vector<CategoricBin>();
        try {
            String string4 = MessageFormat.format("SELECT * FROM (SELECT {0} FROM {1} GROUP BY {0} HAVING {0} IS NOT NULL ORDER BY COUNT(*) DESC, {0} DESC) WHERE rownum <= {2}", "\"" + string3 + "\"", this.getSamplingViewDefinition(), string);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string4);
            while (resultSet.next()) {
                Vector<String> vector2 = new Vector<String>();
                String string5 = resultSet.getString(1);
                vector2.add(string5);
                CategoricBin categoricBin = new CategoricBin(string5, vector2);
                vector.add(categoricBin);
            }
            this.setBinBounds(n, vector);
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getTopNStatsTX(Connection connection, int n, int n2) {
        String string = String.valueOf(n2);
        String string2 = this.getAttributeName(n);
        Statement statement = null;
        ResultSet resultSet = null;
        Vector<CategoricBin> vector = new Vector<CategoricBin>();
        boolean bl = true;
        try {
            String string3 = MessageFormat.format("SELECT * FROM (SELECT {0} FROM {1}  WHERE {3}={4} GROUP BY {0} HAVING {0} IS NOT NULL ORDER BY COUNT(*) DESC, {0} DESC) WHERE rownum <= {2}", "\"" + this.m_value_column_name + "\"", this.getSamplingTXNViewDefinition(), string, "\"" + this.m_attribute_column_name + "\"", "'" + string2 + "'");
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                Vector<String> vector2 = new Vector<String>();
                String string4 = resultSet.getString(1);
                vector2.add(string4);
                CategoricBin categoricBin = new CategoricBin(string4, vector2, vector2);
                vector.add(categoricBin);
            }
            this.setBinBounds(n, vector);
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getHistogramQuantileBinning(int n, Integer n2) {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        hashtable.put(this.getAttributeName(n), new Integer(n));
        Connection connection = null;
        try {
            Object object;
            connection = DM4JConnectionManager.getDbConnection();
            int[] nArray = null;
            if (!hashtable.isEmpty()) {
                nArray = new int[hashtable.size()];
            }
            int n3 = 0;
            Vector<int[]> vector = new Vector<int[]>();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                Integer n4 = (Integer)hashtable.get(object);
                if (n4 == null) continue;
                int n5 = n4;
                nArray[n3++] = n5;
                vector.add((int[])object);
            }
            object = new int[n3];
            System.arraycopy(nArray, 0, object, 0, n3);
            this.getQtileStats(connection, vector, hashtable, n2);
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    protected void getQtileStats(Connection connection, Vector vector, Hashtable hashtable, int n) {
        if (vector == null || vector.isEmpty()) {
            return;
        }
        if (this.isTx()) {
            this.quantileBinningTX(connection, vector, hashtable, n);
            return;
        }
        this.quantileBinning2D(connection, vector, hashtable, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void quantileBinningTX(Connection connection, Vector vector, Hashtable hashtable, int n) {
        this.getEqualWidthStatsTX(connection, vector, hashtable, n);
        String string = "SELECT " + this.m_attribute_column_name + ", MIN(VAL_VALUE) LOW_BOUND, MAX(VAL_VALUE) UP_BOUND FROM " + "( SELECT " + this.m_attribute_column_name + ", " + this.m_value_column_name + " VAL_VALUE, NTILE(TO_CHAR(ABS(" + String.valueOf(n) + "))) OVER(PARTITION BY " + this.m_attribute_column_name + " ORDER BY " + this.m_value_column_name + " ASC) qtile " + "FROM (" + this.getSamplingTXNViewDefinition() + ") WHERE " + this.m_value_column_name + " IS NOT NULL ) " + "GROUP BY qtile, " + this.m_attribute_column_name + " ORDER BY " + this.m_attribute_column_name + ", qtile ASC";
        Vector<Object> vector2 = new Vector<Object>();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            Object object;
            Hashtable<Object, DiscretizeDataSource.BinVectors> hashtable2 = new Hashtable<Object, DiscretizeDataSource.BinVectors>();
            Vector vector3 = null;
            Vector vector4 = null;
            int n2 = 0;
            statement = connection.prepareStatement(string);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                object = resultSet.getString(1);
                if (null == hashtable2.get(object)) {
                    vector3 = new Vector();
                    vector4 = new Vector();
                    hashtable2.put(object, new DiscretizeDataSource.BinVectors(vector3, vector4));
                }
                double d = resultSet.getDouble(2);
                double d2 = resultSet.getDouble(3);
                vector2.add(object);
                vector3.add(new Double(d));
                vector4.add(new Double(d2));
            }
            n2 = hashtable2.size();
            object = hashtable2.keys();
            while (object.hasMoreElements()) {
                String string2 = (String)object.nextElement();
                Integer n3 = (Integer)hashtable.get(string2);
                if (n3 == null) continue;
                DiscretizeDataSource.BinVectors binVectors = (DiscretizeDataSource.BinVectors)hashtable2.get(string2);
                vector3 = binVectors.getMinVector();
                vector4 = binVectors.getMaxVector();
                n2 = vector4.size();
                Vector<DiscretizeDataSource.QuantileDefinition> vector5 = new Vector<DiscretizeDataSource.QuantileDefinition>();
                if (n2 == 0) continue;
                vector3.add(vector4.elementAt(vector4.size() - 1));
                Double[] doubleArray = vector3.toArray(new Double[vector3.size()]);
                Double[] doubleArray2 = vector4.toArray(new Double[vector4.size()]);
                Vector<Bin> vector6 = new Vector<Bin>();
                if (doubleArray[0].doubleValue() != doubleArray2[n2 - 1].doubleValue()) {
                    int n4 = 0;
                    for (int i = 0; i <= n2; ++i) {
                        if (i <= n2 - 1 && doubleArray[i].doubleValue() == doubleArray[i + 1].doubleValue()) continue;
                        DiscretizeDataSource.QuantileDefinition quantileDefinition = new DiscretizeDataSource.QuantileDefinition(n4, doubleArray[i]);
                        vector5.add(quantileDefinition);
                        ++n4;
                    }
                    DiscretizeDataSource.QuantileDefinition quantileDefinition = null;
                    for (int i = 1; i < vector5.size(); ++i) {
                        DiscretizeDataSource.QuantileDefinition quantileDefinition2 = (DiscretizeDataSource.QuantileDefinition)vector5.elementAt(i);
                        Bin bin = new Bin(quantileDefinition2.getBinNumber() - 1, quantileDefinition.getMinNumber(), quantileDefinition2.getMinNumber());
                        vector6.add(bin);
                        quantileDefinition = quantileDefinition2;
                    }
                } else {
                    Bin bin = new Bin(0, doubleArray[0], doubleArray2[n2 - 1]);
                    vector6.add(bin);
                }
                this.setBinBounds(n3, vector6);
            }
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                System.out.println(exception.getMessage());
            }
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void quantileBinning2D(Connection connection, Vector vector, Hashtable hashtable, int n) {
        this.getEqualWidthStats2D(connection, vector, hashtable, n);
        String string = "SELECT MIN(val), MAX(val) FROM (SELECT {0} val,NTILE(TO_CHAR(ABS({1}))) OVER(ORDER BY {0} ASC) qtile FROM {2} WHERE {0} IS NOT NULL) GROUP BY qtile ORDER BY qtile ASC";
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = (String)vector.elementAt(i);
            Integer n2 = (Integer)hashtable.get(string2);
            if (n2 == null) continue;
            string2 = this.getColumnName(string2);
            Vector<Double> vector2 = new Vector<Double>();
            Vector<Double> vector3 = new Vector<Double>();
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                String string3 = MessageFormat.format(string, "\"" + string2 + "\"", new Integer(n), this.getSamplingViewDefinition());
                int n3 = 0;
                statement = connection.prepareStatement(string3);
                resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    double d = resultSet.getDouble(1);
                    double d2 = resultSet.getDouble(2);
                    vector2.add(new Double(d));
                    vector3.add(new Double(d2));
                    ++n3;
                }
                Vector<DiscretizeDataSource.QuantileDefinition> vector4 = new Vector<DiscretizeDataSource.QuantileDefinition>();
                if (n3 == 0) continue;
                vector2.add((Double)vector3.elementAt(vector3.size() - 1));
                Double[] doubleArray = vector2.toArray(new Double[vector2.size()]);
                Double[] doubleArray2 = vector3.toArray(new Double[vector3.size()]);
                Vector<Bin> vector5 = new Vector<Bin>();
                if (doubleArray[0].doubleValue() != doubleArray2[n3 - 1].doubleValue()) {
                    int n4 = 0;
                    for (int j = 0; j <= n3; ++j) {
                        if (j <= n3 - 1 && doubleArray[j].doubleValue() == doubleArray[j + 1].doubleValue()) continue;
                        DiscretizeDataSource.QuantileDefinition quantileDefinition = new DiscretizeDataSource.QuantileDefinition(n4, doubleArray[j]);
                        vector4.add(quantileDefinition);
                        ++n4;
                    }
                    DiscretizeDataSource.QuantileDefinition quantileDefinition = (DiscretizeDataSource.QuantileDefinition)vector4.elementAt(0);
                    for (int j = 1; j < vector4.size(); ++j) {
                        DiscretizeDataSource.QuantileDefinition quantileDefinition2 = (DiscretizeDataSource.QuantileDefinition)vector4.elementAt(j);
                        Bin bin = new Bin(quantileDefinition2.getBinNumber() - 1, quantileDefinition.getMinNumber(), quantileDefinition2.getMinNumber());
                        vector5.add(bin);
                        quantileDefinition = quantileDefinition2;
                    }
                } else {
                    Bin bin = new Bin(0, doubleArray[0], doubleArray2[n3 - 1]);
                    vector5.add(bin);
                }
                this.setBinBounds(n2, vector5);
                continue;
            }
            catch (Exception exception) {
                if (!DiscretizeDataSource.isDebug()) continue;
                exception.printStackTrace();
                continue;
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getEqualWidthStats2D(Connection connection, Vector vector, Hashtable hashtable, int n) {
        int n2 = vector.size() / 1000 + 1;
        String string = "count({0}) as N{1}, avg({0}) as Average{1}, MAX({0}) Max{1} , MIN({0}) Min{1}, VARIANCE({0}) as Variance{1}";
        for (int i = 0; i < n2; ++i) {
            Object object;
            Object object2;
            int n3 = Math.min(vector.size(), 1000 * (i + 1));
            int n4 = 1000 * i;
            StringBuffer stringBuffer = new StringBuffer("SELECT /*+ parallel (t) */");
            for (int j = n4; j < n3; ++j) {
                object2 = (String)vector.elementAt(j);
                object = "\"" + this.getColumnName((String)object2) + "\"";
                String string2 = MessageFormat.format(string, object, String.valueOf(j));
                stringBuffer.append(string2);
                if (j >= n3 - 1) continue;
                stringBuffer.append(",");
            }
            String string3 = MessageFormat.format(" from ({0} t)", this.getSamplingViewDefinition());
            stringBuffer.append(string3);
            object2 = null;
            object = null;
            try {
                object2 = connection.createStatement();
                object = object2.executeQuery(stringBuffer.toString());
                if (!object.next()) continue;
                for (int j = n4; j < n3; ++j) {
                    String string4 = String.valueOf(j);
                    String string5 = (String)vector.elementAt(j);
                    Integer n5 = (Integer)hashtable.get(string5);
                    if (n5 == null) continue;
                    int n6 = object.getInt("N" + string4);
                    this.setTotalCount(n5, n6);
                    double d = object.getDouble("Average" + string4);
                    this.m_extraModel.setAverage(n5, d);
                    double d2 = object.getDouble("Max" + string4);
                    this.m_extraModel.setMax(n5, d2);
                    double d3 = object.getDouble("Min" + string4);
                    this.m_extraModel.setMin(n5, d3);
                    d = object.getDouble("Variance" + string4);
                    this.setVariance(n5, d);
                    d = Math.sqrt(d);
                    this.setStdev(n5, d);
                }
                continue;
            }
            catch (Exception exception) {
                if (!DiscretizeDataSource.isDebug()) continue;
                exception.printStackTrace();
                continue;
            }
            finally {
                try {
                    object.close();
                    object2.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getEqualWidthStatsTX(Connection connection, Vector vector, Hashtable hashtable, int n) {
        Object object;
        String string = "SELECT {0} ANAME, count({1}) as N, MIN({1}) MINV, MAX({1}) MAXV, AVG({1}) AVGV, VARIANCE({1}) as Variance from {2} ";
        String string2 = MessageFormat.format(string, "\"" + this.m_attribute_column_name + "\"", "\"" + this.m_value_column_name + "\"", this.getSamplingTXNViewDefinition());
        StringBuffer stringBuffer = new StringBuffer(string2);
        stringBuffer.append(" where ");
        for (int i = 0; i < vector.size(); ++i) {
            object = (String)vector.elementAt(i);
            stringBuffer.append("\"" + this.m_attribute_column_name + "\"" + " = '" + (String)object + "'");
            if (i >= vector.size() - 1) continue;
            stringBuffer.append(" or ");
        }
        stringBuffer.append(" group by \"" + this.m_attribute_column_name + "\"");
        Statement statement = null;
        object = null;
        try {
            statement = connection.createStatement();
            object = statement.executeQuery(stringBuffer.toString());
            while (object.next()) {
                String string3 = object.getString("ANAME");
                Integer n2 = (Integer)hashtable.get(string3);
                if (n2 == null) continue;
                int n3 = object.getInt("N");
                this.setTotalCount(n2, n3);
                double d = object.getDouble("MAXV");
                this.m_extraModel.setMax(n2, d);
                double d2 = object.getDouble("MINV");
                this.m_extraModel.setMin(n2, d2);
                double d3 = object.getDouble("AVGV");
                this.m_extraModel.setAverage(n2, d3);
                d3 = object.getDouble("Variance");
                this.setVariance(n2, d3);
                d3 = Math.sqrt(d3);
                this.setStdev(n2, d3);
            }
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                object.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    public int[] getFrequency(Connection connection, String string, int n) {
        if (this.isNumeric(n)) {
            return this.getNumericFrequency(connection, string, n);
        }
        return this.getCategoricAttributeFrequency(connection, n, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] getCategoricAttributeFrequency(Connection connection, int n, String string) {
        Object object;
        Object object2;
        if (this.isTx()) {
            return this.getCategoricAttributeFrequencyTX(connection, n, string, this.getSamplingTXNViewDefinition());
        }
        String[] stringArray = new String[]{"select {0} DISPLAY_NAME, count(*) FREQUENCY ", "from {1} group by {0} order by FREQUENCY desc"};
        String string2 = "\"" + this.getColumnName(string) + "\"";
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            object2 = MessageFormat.format(stringArray[i], string2, this.getSamplingViewDefinition());
            stringBuffer.append((String)object2);
        }
        Hashtable<Integer, CategoricBin> hashtable = new Hashtable<Integer, CategoricBin>();
        object2 = this.getBinBounds(n);
        int n2 = ((Vector)object2).size();
        int[] nArray = new int[n2 + 1];
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(stringBuffer.toString());
            object = preparedStatement.executeQuery();
            boolean bl = false;
            while (object.next()) {
                String string3 = object.getString("DISPLAY_NAME");
                if (string3 == null) {
                    string3 = ResourceUtilities.getUILabel("HISTOGRAM_NULL_VALUE");
                }
                int n3 = object.getInt("FREQUENCY");
                boolean bl2 = false;
                for (int i = 0; i < n2; ++i) {
                    CategoricBin categoricBin = (CategoricBin)((Vector)object2).elementAt(i);
                    for (int j = 0; j < categoricBin.values.size(); ++j) {
                        if (0 != string3.compareTo((String)categoricBin.values.elementAt(j))) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl2) continue;
                    int n4 = i;
                    nArray[n4] = nArray[n4] + n3;
                    break;
                }
                if (bl2) continue;
                int n5 = n2;
                nArray[n5] = nArray[n5] + n3;
            }
            for (int i = 0; i < n2; ++i) {
                CategoricBin categoricBin = (CategoricBin)((Vector)object2).elementAt(i);
                hashtable.put(new Integer(i), categoricBin);
            }
            String string4 = ResourceUtilities.getUILabel("HISTOGRAM_OTHER");
            Vector vector = this.getOther((Vector)object2, n);
            hashtable.put(new Integer(n2), new CategoricBin(string4, vector));
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
            hashtable.clear();
        }
        finally {
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {}
        }
        if (hashtable.isEmpty()) {
            return null;
        }
        this.setDisplayNames(n, hashtable);
        this.setNumberOfBins(n, n2);
        object = this.getBinType(n);
        this.setBinType(n, (String)object, n2);
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] getCategoricAttributeFrequencyTX(Connection connection, int n, String string, String string2) {
        Object object;
        String string3 = "SELECT {0} DISPLAY_NAME, COUNT(*) FREQUENCY FROM {1} WHERE {2}={3} GROUP BY {0} order by FREQUENCY desc";
        String string4 = "'" + string + "'";
        String string5 = MessageFormat.format(string3, "\"" + this.m_value_column_name + "\"", string2, "\"" + this.m_attribute_column_name + "\"", string4);
        Hashtable<Integer, CategoricBin> hashtable = new Hashtable<Integer, CategoricBin>();
        Vector vector = this.getBinBounds(n);
        int n2 = vector.size();
        int[] nArray = new int[n2 + 1];
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(string5);
            object = preparedStatement.executeQuery();
            boolean bl = false;
            while (object.next()) {
                String string6 = object.getString("DISPLAY_NAME");
                if (string6 == null) {
                    string6 = ResourceUtilities.getUILabel("HISTOGRAM_NULL_VALUE");
                }
                int n3 = object.getInt("FREQUENCY");
                boolean bl2 = false;
                for (int i = 0; i < n2; ++i) {
                    CategoricBin categoricBin = (CategoricBin)vector.elementAt(i);
                    for (int j = 0; j < categoricBin.values.size(); ++j) {
                        if (0 != string6.compareTo((String)categoricBin.values.elementAt(j))) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl2) continue;
                    int n4 = i;
                    nArray[n4] = nArray[n4] + n3;
                    break;
                }
                if (bl2) continue;
                int n5 = n2;
                nArray[n5] = nArray[n5] + n3;
            }
            for (int i = 0; i < n2; ++i) {
                CategoricBin categoricBin = (CategoricBin)vector.elementAt(i);
                hashtable.put(new Integer(i), categoricBin);
            }
            String string7 = ResourceUtilities.getUILabel("HISTOGRAM_OTHER");
            Vector vector2 = this.getOther(vector, n);
            hashtable.put(new Integer(n2), new CategoricBin(string7, vector2));
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
            hashtable.clear();
        }
        finally {
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {}
        }
        if (hashtable.isEmpty()) {
            return null;
        }
        this.setDisplayNames(n, hashtable);
        this.setNumberOfBins(n, n2);
        object = this.getBinType(n);
        this.setBinType(n, (String)object, n2);
        return nArray;
    }

    private int[] getNumericFrequency(Connection connection, String string, int n) {
        if (this.isTx()) {
            return this.getNumericFrequencyTX(connection, string, n);
        }
        return this.getNumericFrequency2D(connection, string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] getNumericFrequency2D(Connection connection, String string, int n) {
        String string2;
        String string3 = this.getDataType(string);
        boolean bl = string3.compareTo("DM_NESTED_NUMERICALS") == 0;
        Statement statement = null;
        ResultSet resultSet = null;
        int[] nArray = null;
        StringBuffer stringBuffer = null;
        Vector<Integer> vector = new Vector<Integer>();
        int n2 = 0;
        int n3 = 0;
        try {
            string2 = MessageFormat.format(DiscretizeDataSource.HISTOGRAM_VALUES[0], "\"" + this.getColumnName(string) + "\"");
            StringBuffer stringBuffer2 = new StringBuffer(string2);
            stringBuffer = this.m_extraModel.getViewDefinition(n);
            if (stringBuffer == null) {
                stringBuffer = this.getSingleNumericAttributeViewDefinition(connection, n);
            }
            if (stringBuffer == null) {
                int[] nArray2 = nArray;
                return nArray2;
            }
            int n4 = stringBuffer.toString().indexOf("SELECT");
            StringBuffer stringBuffer3 = new StringBuffer(stringBuffer.substring(n4));
            if (bl) {
                stringBuffer2.append(MessageFormat.format("\nSELECT m.attribute_name {0}, m.VALUE VALUE FROM (\n", "\"" + this.getColumnName(string) + "\""));
            }
            stringBuffer2.append(stringBuffer3);
            if (bl) {
                stringBuffer2.append(MessageFormat.format("\n) t, TABLE(t.{0}) m \n", "\"" + this.getColumnName(string) + "\""));
            }
            string2 = MessageFormat.format(DiscretizeDataSource.HISTOGRAM_VALUES[1], "\"" + this.getColumnName(string) + "\"");
            stringBuffer2.append(string2);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(stringBuffer2.toString());
            while (resultSet.next()) {
                String string4 = resultSet.getString("BIN_NUMBER");
                int n5 = resultSet.getInt("FREQUENCY");
                if (string4 != null) {
                    ++n2;
                    vector.add(new Integer(n5));
                    continue;
                }
                n3 = n5;
            }
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
            nArray = null;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
        if (vector == null || vector.isEmpty()) {
            return null;
        }
        this.setNumberOfBins(n, n2);
        this.setNullCount(n, n3);
        string2 = this.getBinType(n);
        this.setBinType(n, string2, n2);
        nArray = new int[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            Integer n6 = (Integer)vector.elementAt(i);
            nArray[i] = n6;
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer getSingleNumericAttributeViewDefinition(Connection connection, int n) {
        StringBuffer stringBuffer = null;
        try {
            Vector<String> vector = new Vector<String>();
            vector.add(this.getAttributeName(n));
            stringBuffer = this.createNumericOpenEndedViewDefinition(connection, vector, new int[]{n}, this.isTx() ? this.getSamplingTXNViewDefinition() : this.getSamplingViewDefinition());
            this.setViewDefinition(n, stringBuffer);
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
            this.setViewDefinition(n, null);
        }
        return stringBuffer;
    }

    protected StringBuffer createNumericOpenEndedViewDefinition(Connection connection, Vector vector, int[] nArray, String string) {
        Bin[] binArray;
        Object object;
        String string2;
        int n;
        if (this.isTx()) {
            return this.createNumericOpenEndedViewDefinitionTX(connection, vector, nArray);
        }
        StringBuffer stringBuffer = new StringBuffer("SELECT \n");
        int n2 = vector.size();
        DiscretizeDataSource.BinBoundMap binBoundMap = new DiscretizeDataSource.BinBoundMap(n2);
        Hashtable<String, BinningType> hashtable = new Hashtable<String, BinningType>();
        for (n = 0; n < nArray.length; ++n) {
            string2 = this.getAttributeName(nArray[n]);
            string2 = this.getColumnName(string2);
            hashtable.put(string2, BinningType.getInstance(this.getBinType(nArray[n])));
            object = this.getBinBounds(nArray[n]);
            if (object == null || ((Vector)object).size() == 0) continue;
            binArray = new Bin[((Vector)object).size()];
            binArray = ((Vector)object).toArray(binArray);
            for (int i = 0; i < binArray.length; ++i) {
                int n3 = binArray[i].getBinNumber();
                double d = binArray[i].getLowerBound();
                double d2 = binArray[i].getUpperBound();
                binBoundMap.addBinBound("\"" + string2 + "\"", new DiscretizeDataSource.BinBound(n3, d, d2));
            }
        }
        for (n = 0; n < n2; ++n) {
            string2 = (String)vector.elementAt(n);
            object = "\"" + this.getColumnName(string2) + "\"";
            binArray = (Bin[])hashtable.get(this.getColumnName(string2));
            if (binBoundMap.isEmpty((String)object)) {
                stringBuffer.append((String)object);
            } else if (binBoundMap.size((String)object) == 1) {
                stringBuffer.append("( CASE ");
                stringBuffer.append("WHEN ");
                stringBuffer.append((String)object);
                stringBuffer.append(" is not null then 1 end) " + (String)object);
            } else if (binArray.equal(BinningType.QTILE)) {
                this.prepareQtileDefinition(stringBuffer, binBoundMap, (String)object);
            } else {
                this.prepareEqWidthDefinition(stringBuffer, binBoundMap, (String)object);
            }
            if (n < n2 - 1) {
                stringBuffer.append(",");
            }
            stringBuffer.append("\n");
        }
        binBoundMap.clear();
        stringBuffer.append(" FROM " + string);
        return stringBuffer;
    }

    protected void prepareQtileDefinition(StringBuffer stringBuffer, DiscretizeDataSource.BinBoundMap binBoundMap, String string) {
        DiscretizeDataSource.BinBound binBound;
        int n;
        stringBuffer.append("( CASE ");
        Vector vector = binBoundMap.getBinBounds(string);
        int n2 = 2;
        NumberFormat numberFormat = DecimalFormat.getNumberInstance();
        numberFormat.setGroupingUsed(true);
        numberFormat.setMaximumFractionDigits(n2);
        numberFormat.setMinimumFractionDigits(0);
        DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
        for (n = 0; n < vector.size(); ++n) {
            binBound = (DiscretizeDataSource.BinBound)vector.elementAt(n);
            DM4JNumericFormat.AdjustFormat(binBound.m_lowerBound, binBound.m_upperBound, decimalFormat);
        }
        for (n = 1; n < vector.size(); ++n) {
            stringBuffer.append("WHEN ");
            binBound = (DiscretizeDataSource.BinBound)vector.elementAt(n);
            if (n == 1) {
                stringBuffer.append(string + " < " + DM4JNumericFormat.SQLFormat(binBound.m_upperBound, decimalFormat) + " THEN ");
                stringBuffer.append(String.valueOf(n));
            } else if (n == vector.size() - 1) {
                stringBuffer.append(string + " > " + DM4JNumericFormat.SQLFormat(binBound.m_lowerBound, decimalFormat) + " THEN " + n);
            } else {
                stringBuffer.append(string + " <= " + DM4JNumericFormat.SQLFormat(binBound.m_upperBound, decimalFormat) + " THEN " + n);
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append(" end) " + string);
    }

    protected void prepareEqWidthDefinition(StringBuffer stringBuffer, DiscretizeDataSource.BinBoundMap binBoundMap, String string) {
        DiscretizeDataSource.BinBound binBound;
        int n;
        stringBuffer.append("( CASE ");
        Vector vector = binBoundMap.getBinBounds(string);
        int n2 = 2;
        NumberFormat numberFormat = DecimalFormat.getNumberInstance();
        numberFormat.setGroupingUsed(true);
        numberFormat.setMaximumFractionDigits(n2);
        numberFormat.setMinimumFractionDigits(0);
        DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
        for (n = 0; n < vector.size(); ++n) {
            binBound = (DiscretizeDataSource.BinBound)vector.elementAt(n);
            DM4JNumericFormat.AdjustFormat(binBound.m_lowerBound, binBound.m_upperBound, decimalFormat);
        }
        for (n = 0; n < vector.size(); ++n) {
            stringBuffer.append("WHEN ");
            binBound = (DiscretizeDataSource.BinBound)vector.elementAt(n);
            if (n == 0) {
                stringBuffer.append(string + " < " + DM4JNumericFormat.SQLFormat(binBound.m_upperBound, decimalFormat) + " THEN ");
                stringBuffer.append(String.valueOf(n + 1));
            } else if (n == vector.size() - 1) {
                stringBuffer.append(string + " >= " + DM4JNumericFormat.SQLFormat(binBound.m_lowerBound, decimalFormat) + " THEN " + (n + 1));
            } else {
                DiscretizeDataSource.BinBound binBound2 = (DiscretizeDataSource.BinBound)vector.elementAt(n - 1);
                stringBuffer.append(string + " >= " + DM4JNumericFormat.SQLFormat(binBound2.m_upperBound, decimalFormat) + " AND " + string + " < " + DM4JNumericFormat.SQLFormat(binBound.m_upperBound, decimalFormat) + " THEN " + (n + 1));
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append("else null end) " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer createNumericOpenEndedViewDefinitionTX(Connection connection, Vector vector, int[] nArray) {
        String string = "\"" + this.m_schema + "\".\"" + this.m_extraModel.getNumericBinBoundatyTableName() + "\"";
        StringBuffer stringBuffer = new StringBuffer("DELETE FROM " + string + " WHERE \n");
        for (int i = 0; i < nArray.length; ++i) {
            String string2 = this.getAttributeName(nArray[i]);
            stringBuffer.append("COLUMN_NAME = '" + string2 + "'");
            if (i >= nArray.length - 1) continue;
            stringBuffer.append(" OR ");
        }
        try {
            block8: {
                try {
                    DM4JTransformation.removeAttributesFromBinBoundaryTable(connection, stringBuffer.toString());
                }
                catch (Exception exception) {
                    if (!DiscretizeDataSource.isDebug()) break block8;
                    exception.printStackTrace();
                }
            }
            this.populateGroupNumericBinBoundaries(connection, nArray, this.m_extraModel.getNumericBinBoundatyTableName(), this.m_extraModel.getUserSchemaName());
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        return this.m_extraModel.getSampledTXViewDefinition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateGroupNumericBinBoundaries(Connection connection, int[] nArray, String string, String string2) throws SQLException {
        if (nArray == null || nArray.length == 0) {
            return;
        }
        Object[] objectArray = new Object[]{string2, string};
        String string3 = MessageFormat.format("INSERT INTO {0}.{1} VALUES ( ?,?,?,?,?,?)", objectArray);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(string3);
            for (int i = 0; i < nArray.length; ++i) {
                String string4 = this.getAttributeName(nArray[i]);
                Vector vector = this.getBinBounds(nArray[i]);
                Bin[] binArray = new Bin[vector.size()];
                binArray = vector.toArray(binArray);
                for (int j = 0; j < binArray.length; ++j) {
                    double d = binArray[j].getLowerBound();
                    double d2 = binArray[j].getUpperBound();
                    int n = binArray[j].getBinNumber();
                    StringBuffer stringBuffer = new StringBuffer(String.valueOf(d));
                    if (d < d2) {
                        stringBuffer.append(" - " + String.valueOf(d2));
                    }
                    String string5 = "T";
                    int n2 = 1;
                    try {
                        preparedStatement.setString(n2++, string4);
                        if (d < (double)1.4E-45f) {
                            d = 1.4E-45f;
                        }
                        preparedStatement.setDouble(n2++, d);
                        preparedStatement.setDouble(n2++, d2);
                        preparedStatement.setInt(n2++, n + 1);
                        preparedStatement.setString(n2++, string5);
                        preparedStatement.setString(n2++, stringBuffer.toString());
                        preparedStatement.execute();
                        continue;
                    }
                    catch (Exception exception) {
                        if (!DiscretizeDataSource.isDebug()) continue;
                        exception.printStackTrace();
                    }
                }
            }
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getNumericFrequencyTX(Connection connection, String string, int n) {
        String string2;
        Statement statement = null;
        ResultSet resultSet = null;
        int[] nArray = null;
        StringBuffer stringBuffer = null;
        Vector<Integer> vector = new Vector<Integer>();
        int n2 = 0;
        int n3 = 0;
        try {
            string2 = MessageFormat.format(DiscretizeDataSource.HISTOGRAM_VALUES_TX[0], "\"" + this.m_value_column_name + "\"", "\"" + string + "\"");
            StringBuffer stringBuffer2 = new StringBuffer(string2);
            stringBuffer = this.getViewDefinition(n);
            if (stringBuffer == null) {
                stringBuffer = this.getSingleNumericAttributeViewDefinition(connection, n);
            }
            if (stringBuffer == null) {
                int[] nArray2 = nArray;
                return nArray2;
            }
            int n4 = stringBuffer.toString().indexOf("SELECT");
            StringBuffer stringBuffer3 = new StringBuffer(stringBuffer.substring(n4));
            stringBuffer2.append(stringBuffer3);
            string2 = MessageFormat.format(DiscretizeDataSource.HISTOGRAM_VALUES_TX[1], "\"" + this.m_value_column_name + "\"", "'" + string + "'", "\"" + this.m_attribute_column_name + "\"");
            stringBuffer2.append(string2);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(stringBuffer2.toString());
            while (resultSet.next()) {
                String string3 = resultSet.getString("BIN_NUMBER");
                int n5 = resultSet.getInt("FREQUENCY");
                if (string3 != null) {
                    ++n2;
                    vector.add(new Integer(n5));
                    continue;
                }
                n3 = n5;
            }
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
            nArray = null;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
        if (vector == null || vector.isEmpty()) {
            return null;
        }
        this.setNullCount(n, n3);
        this.setNumberOfBins(n, n2);
        string2 = this.getBinType(n);
        this.setBinType(n, string2, n2);
        nArray = new int[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            Integer n6 = (Integer)vector.elementAt(i);
            nArray[i] = n6;
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void getEqualWidth2ndorderStats(Connection connection, int n, double[] dArray, String string) {
        Object object;
        if (this.isTx()) {
            this.getEqualWidth2ndorderStatsTX(connection, n, dArray, string, this.getSamplingTXNViewDefinition());
            return;
        }
        Integer n2 = this.getTotalCount(n);
        Double d = this.getSigma(n);
        if (n2 == null || d == null) {
            object = this.getEqualWidthStdevCount(connection, "\"" + this.getColumnName(string) + "\"", this.getSamplingViewDefinition());
            dArray[ExtraDataSource.STAT_TOTAL] = (double)object[ExtraDataSource.STAT_TOTAL];
            dArray[ExtraDataSource.STAT_STDEV] = (double)object[ExtraDataSource.STAT_STDEV];
            dArray[ExtraDataSource.STAT_VARIANCE] = (double)object[ExtraDataSource.STAT_VARIANCE];
            this.setTotalCount(n, (int)dArray[ExtraDataSource.STAT_TOTAL]);
            this.setStdev(n, dArray[ExtraDataSource.STAT_STDEV]);
            this.setVariance(n, dArray[ExtraDataSource.STAT_VARIANCE]);
        }
        object = this.getSamplingViewDefinition();
        String string2 = this.getDataType(DM4JStringUtils.trimDoubleQuotes(string));
        boolean bl = string2.compareTo("DM_NESTED_NUMERICALS") == 0;
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append(MessageFormat.format("\nSELECT m.VALUE {0} FROM (\n", "\"" + this.getColumnName(string) + "\""));
        }
        stringBuffer.append((String)object);
        if (bl) {
            stringBuffer.append(MessageFormat.format("\n) t, TABLE(t.{0}) m \n", "\"" + this.getColumnName(string) + "\""));
        }
        Statement statement = null;
        ResultSet resultSet = null;
        Object[] objectArray = new Object[]{String.valueOf(dArray[ExtraDataSource.STAT_AVERAGE]), "\"" + this.getColumnName(string) + "\"", String.valueOf((int)dArray[ExtraDataSource.STAT_TOTAL]), String.valueOf(dArray[ExtraDataSource.STAT_STDEV]), stringBuffer.toString()};
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < DiscretizeDataSource.STAT_SQL_EQ_WIDTH_2ND_ORDER.length; ++i) {
            String string3 = MessageFormat.format(DiscretizeDataSource.STAT_SQL_EQ_WIDTH_2ND_ORDER[i], objectArray);
            stringBuffer2.append(string3);
        }
        if (dArray[ExtraDataSource.STAT_STDEV] != 0.0) {
            try {
                statement = connection.createStatement();
                resultSet = statement.executeQuery(stringBuffer2.toString());
                if (!resultSet.next()) return;
                double d2 = resultSet.getDouble("Skew");
                double d3 = resultSet.getDouble("Kurtosis");
                this.setKurtosis(n, new Double(d3));
                this.setSkew(n, new Double(d2));
                return;
            }
            catch (Exception exception) {
                if (!DiscretizeDataSource.isDebug()) return;
                exception.printStackTrace();
                return;
            }
            finally {
                try {
                    resultSet.close();
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
        this.setKurtosis(n, new Double(0.0));
        this.setSkew(n, new Double(0.0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getEqualWidthStdevCount(Connection connection, String string, String string2) {
        Statement statement = null;
        ResultSet resultSet = null;
        String string3 = this.getDataType(DM4JStringUtils.trimDoubleQuotes(string));
        boolean bl = string3.compareTo("DM_NESTED_NUMERICALS") == 0;
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append(MessageFormat.format("\nSELECT m.VALUE {0} FROM (\n", string));
        }
        stringBuffer.append(string2);
        if (bl) {
            stringBuffer.append(MessageFormat.format("\n) t, TABLE(t.{0}) m \n", string));
        }
        Object[] objectArray = new Object[]{string, stringBuffer.toString()};
        String string4 = MessageFormat.format(DiscretizeDataSource.STAT_SQL_EQ_WIDTH_STDEV_COUNT, objectArray);
        double[] dArray = new double[ExtraDataSource.NUMBER_STATS];
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string4);
            if (resultSet.next()) {
                dArray[ExtraDataSource.STAT_TOTAL] = resultSet.getInt("N");
                dArray[ExtraDataSource.STAT_VARIANCE] = resultSet.getDouble("Variance");
                dArray[ExtraDataSource.STAT_STDEV] = Math.sqrt(dArray[ExtraDataSource.STAT_VARIANCE]);
            }
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
            dArray = null;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void getEqualWidth2ndorderStatsTX(Connection connection, int n, double[] dArray, String string, String string2) {
        Object object;
        Integer n2 = this.getTotalCount(n);
        Double d = this.getSigma(n);
        if (n2 == null || d == null) {
            object = this.getEqualWidthStdevCountTX(connection, "\"" + string + "\"", string2);
            dArray[ExtraDataSource.STAT_TOTAL] = object[ExtraDataSource.STAT_TOTAL];
            dArray[ExtraDataSource.STAT_STDEV] = object[ExtraDataSource.STAT_STDEV];
            dArray[ExtraDataSource.STAT_VARIANCE] = object[ExtraDataSource.STAT_VARIANCE];
            this.setTotalCount(n, (int)dArray[ExtraDataSource.STAT_TOTAL]);
            this.setStdev(n, dArray[ExtraDataSource.STAT_STDEV]);
            this.setVariance(n, dArray[ExtraDataSource.STAT_VARIANCE]);
        }
        object = null;
        ResultSet resultSet = null;
        Object[] objectArray = new Object[]{String.valueOf(dArray[ExtraDataSource.STAT_AVERAGE]), "\"" + this.m_value_column_name + "\"", String.valueOf((int)dArray[ExtraDataSource.STAT_TOTAL]), String.valueOf(dArray[ExtraDataSource.STAT_STDEV]), string2, "\"" + this.m_attribute_column_name + "\"", "'" + string + "'"};
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < DiscretizeDataSource.STAT_SQL_EQ_WIDTH_2ND_ORDER_TX.length; ++i) {
            String string3 = MessageFormat.format(DiscretizeDataSource.STAT_SQL_EQ_WIDTH_2ND_ORDER_TX[i], objectArray);
            stringBuffer.append(string3);
        }
        if (dArray[ExtraDataSource.STAT_STDEV] != 0.0) {
            try {
                object = connection.createStatement();
                resultSet = object.executeQuery(stringBuffer.toString());
                if (!resultSet.next()) return;
                double d2 = resultSet.getDouble("Skew");
                double d3 = resultSet.getDouble("Kurtosis");
                this.setKurtosis(n, new Double(d3));
                this.setSkew(n, new Double(d2));
                return;
            }
            catch (Exception exception) {
                if (!DiscretizeDataSource.isDebug()) return;
                exception.printStackTrace();
                return;
            }
            finally {
                try {
                    resultSet.close();
                    object.close();
                }
                catch (Exception exception) {}
            }
        }
        this.setKurtosis(n, new Double(0.0));
        this.setSkew(n, new Double(0.0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getEqualWidthStdevCountTX(Connection connection, String string, String string2) {
        Statement statement = null;
        ResultSet resultSet = null;
        Object[] objectArray = new Object[]{"\"" + this.m_value_column_name + "\"", string2, "\"" + this.m_attribute_column_name + "\"", "'" + string + "'"};
        String string3 = MessageFormat.format(DiscretizeDataSource.STAT_SQL_EQ_WIDTH_STDEV_COUNT_TX, objectArray);
        double[] dArray = new double[ExtraDataSource.NUMBER_STATS];
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            if (resultSet.next()) {
                dArray[ExtraDataSource.STAT_TOTAL] = resultSet.getInt("N");
                dArray[ExtraDataSource.STAT_VARIANCE] = resultSet.getDouble("Variance");
                dArray[ExtraDataSource.STAT_STDEV] = Math.sqrt(dArray[ExtraDataSource.STAT_VARIANCE]);
            }
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
            dArray = null;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getStatsModeTX(Connection connection, String string, int n) {
        if (string == null) {
            return;
        }
        String string2 = "SELECT stats_mode({0}), count({0}) from {2} where {1} = {3}";
        String string3 = MessageFormat.format(string2, "\"" + this.m_value_column_name + "\"", "\"" + this.m_attribute_column_name + "\"", this.getSamplingTXNViewDefinition(), "'" + string + "'");
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            if (resultSet.next()) {
                String string4 = resultSet.getString(1);
                int n2 = resultSet.getInt(2);
                this.setStatsMode(n, string4);
                this.setTotalCount(n, n2);
            }
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getStatsMode2D(Connection connection, String string, int n) {
        if (string == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer("SELECT  ");
        String string2 = MessageFormat.format("stats_mode({0}), count({0}) ", "\"" + string + "\"");
        stringBuffer.append(string2);
        String string3 = MessageFormat.format(" from ({0} t)", this.getSamplingViewDefinition());
        stringBuffer.append(string3);
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet.next()) {
                String string4 = resultSet.getString(1);
                int n2 = resultSet.getInt(2);
                this.setStatsMode(n, string4);
                this.setTotalCount(n, n2);
            }
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    protected boolean ignoreType(String string) {
        return string.compareTo("NVARCHAR2") != 0 && string.compareTo("NCHAR") != 0;
    }

    protected Vector getOther(Vector vector, int n) {
        Vector<String> vector2 = new Vector<String>();
        Vector vector3 = this.m_extraModel.getDistinctValues(n);
        for (int i = 0; i < vector3.size(); ++i) {
            String string = (String)vector3.elementAt(i);
            boolean bl = false;
            for (int j = 0; j < vector.size(); ++j) {
                CategoricBin categoricBin = (CategoricBin)vector.elementAt(j);
                for (int k = 0; k < categoricBin.values.size(); ++k) {
                    if (0 == string.compareTo((String)categoricBin.values.elementAt(k))) {
                        bl = true;
                        break;
                    }
                    if (bl) break;
                }
                if (bl) break;
            }
            if (bl) continue;
            vector2.add(string);
        }
        return vector2;
    }

    public ArrayList getAttributeList() {
        return new ArrayList(this.m_allAttributes);
    }

    public String getColumnName(String string) {
        String string2 = this.isSingleMetric() ? this.getValueColumn(string) : string;
        return string2;
    }
}

