/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.tree.node.JLabelNode;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.tree.node.NodeData;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.dm4j.datasources.JDBCModel;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;

public class DatabaseMetadata {
    private static String ODM_SCHEMA_NAME = "ODM";
    private static String SYS_SCHEMA_NAME = "SYS";
    private static String SELECT_CATALOG_ROLE_SCHEMA_NAME = "SELECT_CATALOG_ROLE";
    private static String PUBLIC_SCHEMA_NAME = "PUBLIC";
    private static String ALL_TAB_PRIVS = "all_tab_privs";
    private static String[] m_TableSpaceObjectTypes = new String[]{"SYNONYM", "TABLE", "VIEW", "SEQUENCE", "PROCEDURE", "PACKAGE", "PACKAGE_BODY", "PROGRAM", "TYPE BODY", "TYPE", "FUNCTION", "JOB", "UNDEFINED", "INDEX PARTITION", "TABLE PARTITION", "MATERIALIZE VIEW"};
    private static String GRANTOR = "GRANTOR";
    private static String GRANTEE = "GRANTEE";
    private static String TABLE_NAME = "TABLE_NAME";
    private static String PRIVILEGE = "PRIVILEGE";
    private static String COLUMN_NAME = "COLUMN_NAME";
    private static String COMMENTS = "COMMENTS";
    private static String INDEX_NAME = "INDEX_NAME";
    private static String OWNER = "OWNER";
    private static final String ESCAPE_STRING = " ESCAPE '@' ";
    private static final String EXCLUDE_TABLES_STRING = "TABLE_NAME NOT LIKE 'BIN$%'AND TABLE_NAME NOT LIKE 'DM$%'AND TABLE_NAME NOT LIKE 'DM4J$%'AND TABLE_NAME NOT LIKE 'DR$%'AND TABLE_NAME NOT LIKE 'Z__@___@___@___%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'ODMNUM@_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'EUL_GW_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'SYS_IOT_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'ODMCAT@_%' ESCAPE '@' ";
    private static final String QUALIFIED_EXCLUDE_TABLES_STRING = "T.TABLE_NAME NOT LIKE 'BIN$%'AND T.TABLE_NAME NOT LIKE 'DM$%'AND T.TABLE_NAME NOT LIKE 'DM4J$%'AND T.TABLE_NAME NOT LIKE 'DR$%'AND T.TABLE_NAME NOT LIKE 'Z__@___@___@___%' ESCAPE '@' AND T.TABLE_NAME NOT LIKE 'ODMNUM@_%' ESCAPE '@' AND T.TABLE_NAME NOT LIKE 'EUL_GW_%' ESCAPE '@' AND T.TABLE_NAME NOT LIKE 'SYS_IOT_%' ESCAPE '@' AND T.TABLE_NAME NOT LIKE 'ODMCAT@_%' ESCAPE '@' ";
    private static final String EXCLUDE_VIEWS_STRING = "VIEW_NAME NOT LIKE 'DM$%'AND VIEW_NAME NOT LIKE 'DM4J$%'";
    private static final String QUALIFIED_EXCLUDE_VIEWS_STRING = "VIEW_NAME NOT LIKE 'DM$%'AND VIEW_NAME NOT LIKE 'DM4J$%'";

    public static String getReplacedString(String string, String string2, String string3) {
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        if (string2.length() > 0) {
            while ((n2 = string.indexOf(string2, n)) >= 0) {
                stringBuffer.append(string.substring(n, n2));
                stringBuffer.append(string3);
                n = n2 + string2.length();
            }
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dropTableOrView(Connection connection, String string, String string2, boolean bl) throws SQLException, Exception {
        Statement statement = null;
        ResultSet resultSet = null;
        Object var6_6 = null;
        try {
            String string3 = null;
            string3 = bl ? "DROP TABLE \"" + DM4JStringUtils.trimDoubleQuotes(string) + "\"." + "\"" + DM4JStringUtils.trimDoubleQuotes(string2) + "\" PURGE" : "DROP VIEW \"" + DM4JStringUtils.trimDoubleQuotes(string) + "\"." + "\"" + DM4JStringUtils.trimDoubleQuotes(string2) + "\"";
            statement = connection.prepareStatement(string3);
            resultSet = statement.executeQuery();
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTableAs(Connection connection, String string, String string2, String string3, String string4) throws SQLException {
        String string5 = null;
        Object var6_6 = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        string5 = "create table \"{0}\".\"{1}\" as select * from \"{2}\".\"{3}\" ";
        Object[] objectArray = new Object[]{DM4JStringUtils.trimDoubleQuotes(string3), DM4JStringUtils.trimDoubleQuotes(string4), DM4JStringUtils.trimDoubleQuotes(string), DM4JStringUtils.trimDoubleQuotes(string2)};
        string5 = MessageFormat.format(string5, objectArray);
        try {
            preparedStatement = connection.prepareStatement(string5);
            preparedStatement.execute();
        }
        finally {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {}
            try {
                preparedStatement.close();
                preparedStatement = null;
            }
            catch (Exception exception) {}
        }
    }

    public static String getCreateTableAsSQL(String string, String string2, String[] stringArray, String string3, String string4) throws Exception {
        CharSequence charSequence;
        String string5 = null;
        string5 = " execute immediate 'create table \"<outputSchemaName>\".\"<outputTableName>\" as select <selectedColumns> from \"<inputSchemaName>\".\"<inputTableName>\"'; \n";
        if (stringArray == null) {
            string5 = BrowserUtils.getReplacedString(string5, "<selectedColumns>", "*");
        } else {
            charSequence = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                charSequence = ((StringBuffer)charSequence).append("\"" + DatabaseMetadata.getReplacedString(stringArray[i], "'", "''") + "\"");
                if (i == stringArray.length - 1) continue;
                charSequence = ((StringBuffer)charSequence).append(",");
            }
            string5 = BrowserUtils.getReplacedString(string5, "<selectedColumns>", ((StringBuffer)charSequence).toString());
        }
        DM4JStringUtils.trimDoubleQuotes(string3);
        DM4JStringUtils.trimDoubleQuotes(string4);
        DM4JStringUtils.trimDoubleQuotes(string);
        DM4JStringUtils.trimDoubleQuotes(string2);
        charSequence = DatabaseMetadata.getReplacedString(string2, "'", "''");
        string5 = BrowserUtils.getReplacedString(string5, "<outputSchemaName>", string3);
        string5 = BrowserUtils.getReplacedString(string5, "<outputTableName>", string4);
        string5 = BrowserUtils.getReplacedString(string5, "<inputSchemaName>", string);
        string5 = BrowserUtils.getReplacedString(string5, "<inputTableName>", (String)charSequence);
        return string5;
    }

    public static String getCreateTableAsSQL(String string, String string2, String string3, String string4) throws Exception {
        return DatabaseMetadata.getCreateTableAsSQL(string, string2, null, string3, string4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createViewAs(Connection connection, String string, String string2, String string3) throws SQLException {
        String string4 = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        string4 = "create view \"{0}\".\"{1}\" as ";
        Object[] objectArray = new Object[]{DM4JStringUtils.trimDoubleQuotes(string2), DM4JStringUtils.trimDoubleQuotes(string3)};
        string4 = MessageFormat.format(string4, objectArray);
        string4 = string4 + string;
        try {
            preparedStatement = connection.prepareStatement(string4);
            preparedStatement.execute();
        }
        finally {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {}
            try {
                preparedStatement.close();
                preparedStatement = null;
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createIndex(Connection connection, String string, String string2, String string3) throws Exception {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string4 = "CREATE INDEX \"" + DM4JStringUtils.trimDoubleQuotes(string) + "\".BPRESS_CTX1 ON \"" + DM4JStringUtils.trimDoubleQuotes(string) + "\".\"" + DM4JStringUtils.trimDoubleQuotes(string2) + "\" " + "(\"" + string3 + "\") INDEXTYPE IS CTXSYS.CONTEXT PARAMETERS('nopopulate')";
        try {
            preparedStatement = connection.prepareStatement(string4);
            preparedStatement.execute();
        }
        finally {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {}
            try {
                preparedStatement.close();
                preparedStatement = null;
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createContextIndex(Connection connection, String string, String string2, String string3, String string4, String string5) throws Exception {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string6 = "CREATE INDEX \"" + DM4JStringUtils.trimDoubleQuotes(string2) + "\".\"" + string.toUpperCase() + "\" ON \"" + DM4JStringUtils.trimDoubleQuotes(string2) + "\".\"" + DM4JStringUtils.trimDoubleQuotes(string3) + "\" " + "(\"" + string4 + "\") INDEXTYPE IS CTXSYS.CONTEXT PARAMETERS('<settings>')";
        string6 = BrowserUtils.getReplacedString(string6, "<settings>", string5);
        try {
            preparedStatement = connection.prepareStatement(string6);
            preparedStatement.execute();
        }
        finally {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {}
            try {
                preparedStatement.close();
                preparedStatement = null;
            }
            catch (Exception exception) {}
        }
    }

    public static String getCreateContextIndexSQL(String string, String string2, String string3, String string4, String string5) throws Exception {
        String string6 = " execute immediate 'CREATE INDEX \"" + DM4JStringUtils.trimDoubleQuotes(string2) + "\".\"" + string.toUpperCase() + "\" ON \"" + DM4JStringUtils.trimDoubleQuotes(string2) + "\".\"" + DM4JStringUtils.trimDoubleQuotes(string3) + "\" " + "(\"" + string4 + "\") INDEXTYPE IS CTXSYS.CONTEXT PARAMETERS(''<settings>'')'; \n";
        string6 = BrowserUtils.getReplacedString(string6, "<settings>", string5);
        return string6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropContextIndex(Connection connection, String string, String string2) throws Exception {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string3 = "DROP INDEX \"" + DM4JStringUtils.trimDoubleQuotes(string) + "\"." + string2.toUpperCase();
        try {
            preparedStatement = connection.prepareStatement(string3);
            preparedStatement.execute();
        }
        finally {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {}
            try {
                preparedStatement.close();
                preparedStatement = null;
            }
            catch (Exception exception) {}
        }
    }

    public static String getDropContextIndexSQL(String string, String string2) throws Exception {
        String string3 = " execute immediate 'DROP INDEX \"" + DM4JStringUtils.trimDoubleQuotes(string) + "\".\"" + string2.toUpperCase() + "\"'; \n";
        return string3;
    }

    public static void dropTable(Connection connection, String string, String string2) throws SQLException, Exception {
        DatabaseMetadata.dropTableOrView(connection, string, string2, true);
    }

    public static void dropView(Connection connection, String string, String string2) throws SQLException, Exception {
        DatabaseMetadata.dropTableOrView(connection, string, string2, false);
    }

    public static Vector getAccessibleSchemas(Connection connection) throws SQLException {
        Vector<String> vector = new Vector<String>();
        String string = DM4JConnectionManager.getUser();
        String string2 = "'" + string + "'";
        String string3 = "select DISTINCT GRANTOR from ALL_TAB_PRIVS where PRIVILEGE = 'SELECT' AND NOT GRANTOR = " + string2 + " order by GRANTOR";
        PreparedStatement preparedStatement = connection.prepareStatement(string3);
        ResultSet resultSet = preparedStatement.executeQuery();
        vector.add(string);
        while (resultSet.next()) {
            vector.add(resultSet.getString(GRANTOR));
        }
        resultSet.close();
        preparedStatement.close();
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getDependentTables(Connection connection, String string, String string2) throws SQLException {
        Vector vector = new Vector();
        ArrayList<String> arrayList = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        string3 = "select REFERENCED_NAME, REFERENCED_OWNER, REFERENCED_TYPE from ALL_DEPENDENCIES where (OWNER = ? and NAME = ?) and REFERENCED_TYPE in('TABLE','VIEW')";
        try {
            preparedStatement = connection.prepareStatement(string3);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            resultSet = preparedStatement.executeQuery();
            Object var11_11 = null;
            while (resultSet.next()) {
                int n = 0;
                arrayList = new ArrayList<String>(3);
                string4 = resultSet.getString("REFERENCED_NAME");
                arrayList.add(n++, string4);
                string5 = resultSet.getString("REFERENCED_OWNER");
                arrayList.add(n++, string5);
                string6 = resultSet.getString("REFERENCED_TYPE");
                arrayList.add(n++, string6);
                vector.add(arrayList);
            }
        }
        finally {
            if (null != resultSet) {
                try {
                    resultSet.close();
                    resultSet = null;
                }
                catch (Exception exception) {}
            }
            if (null != preparedStatement) {
                try {
                    preparedStatement.close();
                    preparedStatement = null;
                }
                catch (Exception exception) {}
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getViewText(Connection connection, String string, String string2) throws SQLException {
        String string3 = null;
        String string4 = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        string3 = "select TEXT from ALL_VIEWS where OWNER = ? and VIEW_NAME = ?";
        try {
            preparedStatement = connection.prepareStatement(string3);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            resultSet = preparedStatement.executeQuery();
            Object var7_7 = null;
            if (resultSet.next()) {
                string4 = resultSet.getString("TEXT");
            }
        }
        finally {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {}
            try {
                preparedStatement.close();
                preparedStatement = null;
            }
            catch (Exception exception) {}
        }
        return string4;
    }

    public static Vector getContextSettingsNames(Connection connection, String string, String string2) throws SQLException {
        Vector<String> vector = new Vector<String>(1000, 500);
        String string3 = null;
        boolean bl = false;
        string3 = "select PRE_NAME from CTX_PREFERENCES where PRE_CLASS = '" + string2.toUpperCase() + "' " + "AND PRE_OWNER = '" + string + "' " + "order by PRE_NAME ";
        PreparedStatement preparedStatement = connection.prepareStatement(string3);
        preparedStatement.setFetchSize(1000);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            vector.add(resultSet.getString("PRE_NAME"));
        }
        resultSet.close();
        preparedStatement.close();
        resultSet = null;
        preparedStatement = null;
        return vector;
    }

    public static Vector getContextSettingsStoplistNames(Connection connection, String string) throws SQLException {
        Vector<String> vector = new Vector<String>(1000, 500);
        String string2 = null;
        boolean bl = false;
        string2 = "select SPL_NAME as PRE_NAME from CTX_STOPLISTS where SPL_OWNER = '" + string + "' " + " order by SPL_NAME ";
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        preparedStatement.setFetchSize(1000);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            vector.add(resultSet.getString("PRE_NAME"));
        }
        resultSet.close();
        preparedStatement.close();
        resultSet = null;
        preparedStatement = null;
        return vector;
    }

    public static Vector getContextSettingsSectionNames(Connection connection, String string) throws SQLException {
        Vector<String> vector = new Vector<String>(1000, 500);
        String string2 = null;
        boolean bl = false;
        string2 = "select SGP_NAME as PRE_NAME from CTX_SECTION_GROUPS where SGP_OWNER = '" + string + "' " + " order by SGP_NAME ";
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        preparedStatement.setFetchSize(1000);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            vector.add(resultSet.getString("PRE_NAME"));
        }
        resultSet.close();
        preparedStatement.close();
        resultSet = null;
        preparedStatement = null;
        return vector;
    }

    public static Vector getAccessableTablesAndViews(Connection connection, String string) throws SQLException {
        Vector<String> vector = new Vector<String>(1000, 500);
        String string2 = null;
        boolean bl = false;
        if (DM4JConnectionManager.getUser().equals(string)) {
            string2 = "select TABLE_NAME from ( select TABLE_NAME from USER_TABLES union select VIEW_NAME as TABLE_NAME from USER_VIEWS) where TABLE_NAME NOT LIKE 'BIN$%'AND TABLE_NAME NOT LIKE 'DM$%'AND TABLE_NAME NOT LIKE 'DM4J$%'AND TABLE_NAME NOT LIKE 'DR$%'AND TABLE_NAME NOT LIKE 'Z__@___@___@___%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'ODMNUM@_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'EUL_GW_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'SYS_IOT_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'ODMCAT@_%' ESCAPE '@' order by TABLE_NAME ";
            bl = true;
        } else {
            string2 = "select TABLE_NAME from ( select TABLE_NAME, OWNER from ALL_TABLES union select VIEW_NAME as TABLE_NAME, OWNER from ALL_VIEWS) where OWNER = ? and TABLE_NAME NOT LIKE 'BIN$%'AND TABLE_NAME NOT LIKE 'DM$%'AND TABLE_NAME NOT LIKE 'DM4J$%'AND TABLE_NAME NOT LIKE 'DR$%'AND TABLE_NAME NOT LIKE 'Z__@___@___@___%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'ODMNUM@_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'EUL_GW_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'SYS_IOT_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'ODMCAT@_%' ESCAPE '@'  order by TABLE_NAME ";
        }
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        if (!bl) {
            preparedStatement.setString(1, string);
        }
        preparedStatement.setFetchSize(1000);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            vector.add(resultSet.getString(TABLE_NAME));
        }
        resultSet.close();
        preparedStatement.close();
        resultSet = null;
        preparedStatement = null;
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getAccessableTablesFolder(Connection connection, String string) throws Exception {
        Vector<Object[]> vector = new Vector<Object[]>(1000, 500);
        Object[] objectArray = null;
        String string2 = null;
        boolean bl = false;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            Object object;
            if (DM4JConnectionManager.getUser().equals(string)) {
                string2 = "select T.TABLE_NAME, O.OBJECT_TYPE as TYPE, O.CREATED, C.COMMENTS   from user_tables T, user_tab_comments C, user_objects O where T.TABLE_NAME NOT LIKE 'BIN$%'AND T.TABLE_NAME NOT LIKE 'DM$%'AND T.TABLE_NAME NOT LIKE 'DM4J$%'AND T.TABLE_NAME NOT LIKE 'DR$%'AND T.TABLE_NAME NOT LIKE 'Z__@___@___@___%' ESCAPE '@' AND T.TABLE_NAME NOT LIKE 'ODMNUM@_%' ESCAPE '@' AND T.TABLE_NAME NOT LIKE 'EUL_GW_%' ESCAPE '@' AND T.TABLE_NAME NOT LIKE 'SYS_IOT_%' ESCAPE '@' AND T.TABLE_NAME NOT LIKE 'ODMCAT@_%' ESCAPE '@'  AND T.TABLE_NAME = C.TABLE_NAME(+)  AND T.TABLE_NAME = O.OBJECT_NAME(+)  AND 'TABLE' = O.OBJECT_TYPE(+)  order by T.TABLE_NAME ";
                object = "select T.TABLE_NAME, O.OBJECT_TYPE as TYPE, O.CREATED, C.COMMENTS   from user_tables T, user_tab_comments C, user_objects O where T.TABLE_NAME NOT LIKE 'BIN$%'AND T.TABLE_NAME NOT LIKE 'DM$%'AND T.TABLE_NAME NOT LIKE 'DM4J$%'AND T.TABLE_NAME NOT LIKE 'DR$%'AND T.TABLE_NAME NOT LIKE 'Z__@___@___@___%' ESCAPE '@' AND T.TABLE_NAME NOT LIKE 'ODMNUM@_%' ESCAPE '@' AND T.TABLE_NAME NOT LIKE 'EUL_GW_%' ESCAPE '@' AND T.TABLE_NAME NOT LIKE 'SYS_IOT_%' ESCAPE '@' AND T.TABLE_NAME NOT LIKE 'ODMCAT@_%' ESCAPE '@'  AND T.TABLE_NAME = C.TABLE_NAME(+)  AND T.TABLE_NAME = O.OBJECT_NAME(+)  AND 'TABLE' = O.OBJECT_TYPE(+)  order by T.TABLE_NAME ";
                bl = true;
            } else {
                string2 = "select T.TABLE_NAME, 'TABLE' as TYPE, C.COMMENTS   from all_tables T, all_tab_comments C where  T.OWNER = ? AND  C.OWNER = ? AND T.TABLE_NAME NOT LIKE 'BIN$%'AND T.TABLE_NAME NOT LIKE 'DM$%'AND T.TABLE_NAME NOT LIKE 'DM4J$%'AND T.TABLE_NAME NOT LIKE 'DR$%'AND T.TABLE_NAME NOT LIKE 'Z__@___@___@___%' ESCAPE '@' AND T.TABLE_NAME NOT LIKE 'ODMNUM@_%' ESCAPE '@' AND T.TABLE_NAME NOT LIKE 'EUL_GW_%' ESCAPE '@' AND T.TABLE_NAME NOT LIKE 'SYS_IOT_%' ESCAPE '@' AND T.TABLE_NAME NOT LIKE 'ODMCAT@_%' ESCAPE '@'  AND T.TABLE_NAME = C.TABLE_NAME(+)  AND C.TABLE_TYPE = 'TABLE'  order by T.TABLE_NAME ";
            }
            statement = connection.prepareStatement(string2);
            if (!bl) {
                statement.setString(1, string);
                statement.setString(2, string);
            }
            statement.setFetchSize(1000);
            resultSet = statement.executeQuery();
            object = null;
            String string3 = null;
            while (resultSet.next()) {
                objectArray = DM4JConnectionManager.getUser().equals(string) ? new Object[4] : new Object[3];
                string3 = resultSet.getString("TABLE_NAME");
                object = new LeafNodeData(string3, "TABLE");
                ((NodeData)object).setSchemaName(string);
                JLabelNode jLabelNode = new JLabelNode((NodeData)object);
                objectArray[0] = jLabelNode;
                objectArray[1] = resultSet.getString("TYPE");
                objectArray[2] = resultSet.getString("COMMENTS");
                if (DM4JConnectionManager.getUser().equals(string)) {
                    objectArray[3] = resultSet.getDate("CREATED");
                }
                vector.add(objectArray);
            }
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                resultSet = null;
                statement = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getAccessableViewsFolder(Connection connection, String string) throws Exception {
        Vector<Object[]> vector = new Vector<Object[]>(1000, 500);
        Object[] objectArray = null;
        String string2 = null;
        boolean bl = false;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            Object object;
            if (DM4JConnectionManager.getUser().equals(string)) {
                string2 = "select T.VIEW_NAME, O.OBJECT_TYPE as TYPE, O.CREATED, C.COMMENTS   from user_views T, user_tab_comments C, user_objects O where VIEW_NAME NOT LIKE 'DM$%'AND VIEW_NAME NOT LIKE 'DM4J$%' AND T.VIEW_NAME = C.TABLE_NAME(+)  AND T.VIEW_NAME = O.OBJECT_NAME(+)  AND 'VIEW' = O.OBJECT_TYPE(+)  order by T.VIEW_NAME ";
                object = "select T.VIEW_NAME, O.OBJECT_TYPE as TYPE, O.CREATED, C.COMMENTS   from user_views T, user_tab_comments C, user_objects O where VIEW_NAME NOT LIKE 'DM$%'AND VIEW_NAME NOT LIKE 'DM4J$%' AND T.VIEW_NAME = C.TABLE_NAME(+)  AND T.VIEW_NAME = O.OBJECT_NAME(+)  AND 'VIEW' = O.OBJECT_TYPE(+)  order by T.VIEW_NAME ";
                bl = true;
            } else {
                string2 = "select T.VIEW_NAME, 'VIEW' as TYPE, C.COMMENTS   from all_views T, all_tab_comments C where  T.OWNER = ? AND  C.OWNER = ? AND VIEW_NAME NOT LIKE 'DM$%'AND VIEW_NAME NOT LIKE 'DM4J$%' AND T.VIEW_NAME = C.TABLE_NAME(+) AND C.TABLE_TYPE = 'VIEW'  order by T.VIEW_NAME ";
            }
            statement = connection.prepareStatement(string2);
            if (!bl) {
                statement.setString(1, string);
                statement.setString(2, string);
            }
            statement.setFetchSize(1000);
            resultSet = statement.executeQuery();
            object = null;
            String string3 = null;
            while (resultSet.next()) {
                objectArray = DM4JConnectionManager.getUser().equals(string) ? new Object[4] : new Object[3];
                string3 = resultSet.getString("VIEW_NAME");
                object = new LeafNodeData(string3, "VIEW");
                ((NodeData)object).setSchemaName(string);
                JLabelNode jLabelNode = new JLabelNode((NodeData)object);
                objectArray[0] = jLabelNode;
                objectArray[1] = resultSet.getString("TYPE");
                objectArray[2] = resultSet.getString("COMMENTS");
                if (DM4JConnectionManager.getUser().equals(string)) {
                    objectArray[3] = resultSet.getDate("CREATED");
                }
                vector.add(objectArray);
            }
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                resultSet = null;
                statement = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return vector;
    }

    public static Vector getAccessableTables(Connection connection, String string) throws SQLException {
        Vector<String> vector = new Vector<String>(1000, 500);
        String string2 = null;
        boolean bl = false;
        if (DM4JConnectionManager.getUser().equals(string)) {
            string2 = "select TABLE_NAME  from user_tables where TABLE_NAME NOT LIKE 'BIN$%'AND TABLE_NAME NOT LIKE 'DM$%'AND TABLE_NAME NOT LIKE 'DM4J$%'AND TABLE_NAME NOT LIKE 'DR$%'AND TABLE_NAME NOT LIKE 'Z__@___@___@___%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'ODMNUM@_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'EUL_GW_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'SYS_IOT_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'ODMCAT@_%' ESCAPE '@'  order by TABLE_NAME ";
            bl = true;
        } else {
            string2 = "select TABLE_NAME  from all_tables  WHERE OWNER = ? and TABLE_NAME NOT LIKE 'BIN$%'AND TABLE_NAME NOT LIKE 'DM$%'AND TABLE_NAME NOT LIKE 'DM4J$%'AND TABLE_NAME NOT LIKE 'DR$%'AND TABLE_NAME NOT LIKE 'Z__@___@___@___%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'ODMNUM@_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'EUL_GW_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'SYS_IOT_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'ODMCAT@_%' ESCAPE '@'  order by TABLE_NAME ";
        }
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        if (!bl) {
            preparedStatement.setString(1, string);
        }
        preparedStatement.setFetchSize(1000);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            vector.add(resultSet.getString(TABLE_NAME));
        }
        resultSet.close();
        preparedStatement.close();
        resultSet = null;
        preparedStatement = null;
        return vector;
    }

    public static Vector getAccessableViews(Connection connection, String string) throws SQLException {
        Vector<String> vector = new Vector<String>(1000, 500);
        String string2 = null;
        boolean bl = false;
        if (DM4JConnectionManager.getUser().equals(string)) {
            string2 = "select VIEW_NAME as TABLE_NAME from user_views  WHERE VIEW_NAME NOT LIKE 'DM$%'AND VIEW_NAME NOT LIKE 'DM4J$%' order by TABLE_NAME ";
            bl = true;
        } else {
            string2 = "select VIEW_NAME as TABLE_NAME from all_views  WHERE OWNER = ?  and VIEW_NAME NOT LIKE 'DM$%'AND VIEW_NAME NOT LIKE 'DM4J$%' order by TABLE_NAME ";
        }
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        if (!bl) {
            preparedStatement.setString(1, string);
        }
        preparedStatement.setFetchSize(1000);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            vector.add(resultSet.getString(TABLE_NAME));
        }
        resultSet.close();
        preparedStatement.close();
        resultSet = null;
        preparedStatement = null;
        return vector;
    }

    public static Vector getPrimaryObjectNamespaceVector(Connection connection) throws SQLException {
        return DatabaseMetadata.getNamespaceVector(connection, m_TableSpaceObjectTypes);
    }

    public static HashMap getPrimaryObjectNamespaceHashMap(Connection connection) throws SQLException {
        return DatabaseMetadata.getNamespaceHashMap(connection, m_TableSpaceObjectTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap getUserConstraintNamespaceHashMap(Connection connection) throws SQLException {
        HashMap<String, String> hashMap = new HashMap<String, String>(1000);
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("select CONSTRAINT_NAME from USER_CONSTRAINTS ");
        stringBuffer.append("order by CONSTRAINT_NAME");
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(stringBuffer.toString());
            preparedStatement.setFetchSize(1000);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                hashMap.put(resultSet.getString(1), resultSet.getString(1));
            }
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {}
        }
        return hashMap;
    }

    public static String[] getPrimaryObjectNamespace(Connection connection) throws SQLException {
        return DatabaseMetadata.getNamespace(connection, m_TableSpaceObjectTypes);
    }

    private static String addObjectTypes(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append("'" + stringArray[i] + "',");
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap getNamespaceHashMap(Connection connection, String[] stringArray) throws SQLException {
        HashMap<String, String> hashMap = new HashMap<String, String>(1000);
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("select OBJECT_NAME from USER_OBJECTS ");
        stringBuffer.append("where OBJECT_TYPE in (" + DatabaseMetadata.addObjectTypes(stringArray) + ")");
        stringBuffer.append("order by OBJECT_NAME");
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(stringBuffer.toString());
            preparedStatement.setFetchSize(1000);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                hashMap.put(resultSet.getString(1), resultSet.getString(1));
            }
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {}
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getNamespaceVector(Connection connection, String[] stringArray) throws SQLException {
        Vector<String> vector = new Vector<String>(1000, 1000);
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("select OBJECT_NAME from USER_OBJECTS ");
        stringBuffer.append("where OBJECT_TYPE in (" + DatabaseMetadata.addObjectTypes(stringArray) + ")");
        stringBuffer.append("order by OBJECT_NAME");
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(stringBuffer.toString());
            preparedStatement.setFetchSize(1000);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                vector.add(resultSet.getString(1));
            }
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {}
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getNamespace(Connection connection, String[] stringArray) throws SQLException {
        String[] stringArray2;
        Vector<String> vector = new Vector<String>(1000, 1000);
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("select OBJECT_NAME from USER_OBJECTS ");
        stringBuffer.append("where OBJECT_TYPE in (" + DatabaseMetadata.addObjectTypes(stringArray) + ")");
        stringBuffer.append("order by OBJECT_NAME");
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(stringBuffer.toString());
            preparedStatement.setFetchSize(1000);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                vector.add(resultSet.getString(1));
            }
            stringArray2 = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                stringArray2[i] = (String)vector.get(i);
            }
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {}
        }
        return stringArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isUniqueInNamespace(Connection connection, String[] stringArray, String string) throws SQLException {
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("select OBJECT_NAME from USER_OBJECTS ");
        stringBuffer.append("where OBJECT_TYPE in (" + DatabaseMetadata.addObjectTypes(stringArray) + ")");
        stringBuffer.append("and OBJECT_NAME = '" + string + "'");
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(stringBuffer.toString());
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                string2 = resultSet.getString(1);
            }
        }
        catch (Exception exception) {
            string2 = null;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {}
        }
        return string2 == null;
    }

    public static String[] getTablesReturnStrings(Connection connection, String string, boolean bl) throws SQLException {
        Vector vector = DatabaseMetadata.getAccessableTablesAndViews(connection, string);
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.get(i);
        }
        return stringArray;
    }

    public static String getTableComment(Connection connection, String string, String string2) throws Exception {
        StringBuffer stringBuffer = new StringBuffer("select COMMENTS  from ALL_TAB_COMMENTS  where OWNER =  ? AND TABLE_NAME = ?");
        PreparedStatement preparedStatement = connection.prepareStatement(stringBuffer.toString());
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        ResultSet resultSet = preparedStatement.executeQuery();
        String string3 = "";
        boolean bl = false;
        while (resultSet.next()) {
            string3 = resultSet.getString(COMMENTS);
            if (!resultSet.wasNull()) continue;
            string3 = new String("");
        }
        resultSet.close();
        preparedStatement.close();
        resultSet = null;
        preparedStatement = null;
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getRowCount(Connection connection, String string) {
        String string2 = "SELECT count (*) from " + DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(string));
        Statement statement = null;
        ResultSet resultSet = null;
        int n = -1;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2);
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            n = -1;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getRowCountFromQuery(Connection connection, String string) throws Exception {
        String string2 = "SELECT count (*) " + string;
        Statement statement = null;
        ResultSet resultSet = null;
        int n = -1;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2);
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return n;
    }

    public static String getIndexName(Connection connection, String string, String string2, String string3) throws Exception {
        String string4 = null;
        StringBuffer stringBuffer = new StringBuffer("select INDEX_NAME  from all_ind_columns  where TABLE_NAME = ?  AND TABLE_OWNER = ?  AND COLUMN_NAME = ?");
        PreparedStatement preparedStatement = connection.prepareStatement(stringBuffer.toString());
        preparedStatement.setString(1, string2);
        preparedStatement.setString(2, string);
        preparedStatement.setString(3, string3);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            string4 = resultSet.getString(INDEX_NAME);
        }
        resultSet.close();
        preparedStatement.close();
        resultSet = null;
        preparedStatement = null;
        return string4;
    }

    public static String getContextIndexName(Connection connection, String string, String string2, String string3) throws Exception {
        String string4 = null;
        StringBuffer stringBuffer = new StringBuffer("select a.INDEX_NAME  from all_ind_columns a, all_indexes b  where a.TABLE_NAME = ?  AND a.TABLE_OWNER = ?  AND a.COLUMN_NAME = ?  AND a.INDEX_NAME = b.INDEX_NAME  AND b.ITYP_NAME = 'CONTEXT' ");
        PreparedStatement preparedStatement = connection.prepareStatement(stringBuffer.toString());
        preparedStatement.setString(1, string2);
        preparedStatement.setString(2, string);
        preparedStatement.setString(3, string3);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            string4 = resultSet.getString(INDEX_NAME);
        }
        resultSet.close();
        preparedStatement.close();
        resultSet = null;
        preparedStatement = null;
        return string4;
    }

    public static void createFeatureTable(Connection connection, String string, String string2, String string3, String string4, String string5) throws Exception {
        String string6 = " BEGIN   ctx_ddl.create_preference('<preferenceTableName>','SVM_CLASSIFIER');  execute immediate 'create table <tempTableName> (id number, cid number)';  execute immediate 'select * from table(drvodm.feature_prep(''<indexName>'',''<caseID>'',''<tempTableName>'',''id'',''cid'',''<featureTableName>'',''<preferenceTableName>''))';  END; ";
        string6 = BrowserUtils.getReplacedString(string6, "<preferenceTableName>", string);
        string6 = BrowserUtils.getReplacedString(string6, "<tempTableName>", string2);
        string6 = BrowserUtils.getReplacedString(string6, "<featureTableName>", string3);
        string6 = BrowserUtils.getReplacedString(string6, "<indexName>", string4);
        string6 = BrowserUtils.getReplacedString(string6, "<caseID>", string5);
        PreparedStatement preparedStatement = connection.prepareStatement(string6);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.close();
        preparedStatement.close();
        resultSet = null;
        preparedStatement = null;
    }

    public static void createODMrTextTables(Connection connection, String string, String string2, String string3, String string4, String string5, String string6, Integer n, Integer n2, boolean bl, boolean bl2, boolean bl3, Integer n3) throws Exception {
        String string7 = ValidationUtil.createUniqueTableName(DM4JStringUtils.trimDoubleQuotes(string5), connection, "_PF");
        String string8 = ValidationUtil.createUniqueTableName(DM4JStringUtils.trimDoubleQuotes(string5), connection, "_T");
        String string9 = ValidationUtil.createUniqueTableName(DM4JStringUtils.trimDoubleQuotes(string5), connection, "_FE");
        String string10 = ValidationUtil.createUniqueIndexName(DM4JStringUtils.trimDoubleQuotes(string), connection, "_IX");
        String string11 = ValidationUtil.createUniqueIndexName(DM4JStringUtils.trimDoubleQuotes(string3), connection, "_IX");
        String string12 = " BEGIN     ctx_ddl.create_preference('<preferenceTableName>','SVM_CLASSIFIER'); ";
        if (n != null && n > 0) {
            string12 = string12 + " ctx_ddl.set_attribute('<preferenceTableName>','MAX_DOCTERMS', <maximumTerms>); ";
        }
        if (n2 != null && n2 > 0) {
            string12 = string12 + " ctx_ddl.set_attribute('<preferenceTableName>','MAX_FEATURES', <maximumDistinctFeatures>); ";
        }
        string12 = bl ? string12 + " ctx_ddl.set_attribute('<preferenceTableName>','THEME_ON', 'TRUE'); " : string12 + " ctx_ddl.set_attribute('<preferenceTableName>','THEME_ON', 'FALSE'); ";
        string12 = bl2 ? string12 + " ctx_ddl.set_attribute('<preferenceTableName>','TOKEN_ON', 'TRUE'); " : string12 + " ctx_ddl.set_attribute('<preferenceTableName>','TOKEN_ON', 'FALSE'); ";
        string12 = bl3 ? string12 + " ctx_ddl.set_attribute('<preferenceTableName>','STEM_ON', 'TRUE'); " : string12 + " ctx_ddl.set_attribute('<preferenceTableName>','STEM_ON', 'FALSE'); ";
        if (n3 != null && n3 > 0) {
            string12 = string12 + " ctx_ddl.set_attribute('<preferenceTableName>','MEMORY_SIZE', <memorySize>); ";
        }
        string12 = string12 + " execute immediate 'create table <tempTableName> (id number, cid number)'; " + " execute immediate 'create table <explainTableName> as select sequence_id, attribute_id, value from table(drvodm.feature_prep(''<indexName>'',''<caseID>'',''<tempTableName>'',''id'',''cid'',''<featureTableName>'',''<preferenceTableName>''))'; ";
        string12 = string12 + " execute immediate 'comment on table \"<user>\".\"<explainTableCommentTableName>\" is ''<explainTableComment>'' '; ";
        string12 = string12 + " execute immediate 'create index <explainTableIndexName> on <explainTableName>(sequence_id)'; " + " END; ";
        string12 = BrowserUtils.getReplacedString(string12, "<preferenceTableName>", string7);
        string12 = BrowserUtils.getReplacedString(string12, "<maximumTerms>", n + "");
        string12 = BrowserUtils.getReplacedString(string12, "<maximumDistinctFeatures>", n2 + "");
        string12 = BrowserUtils.getReplacedString(string12, "<memorySize>", n3 + "");
        string12 = BrowserUtils.getReplacedString(string12, "<tempTableName>", string8);
        string12 = BrowserUtils.getReplacedString(string12, "<user>", DM4JConnectionManager.getUser());
        string12 = BrowserUtils.getReplacedString(string12, "<explainTableName>", string);
        string12 = BrowserUtils.getReplacedString(string12, "<explainTableCommentTableName>", DM4JStringUtils.trimDoubleQuotes(string));
        string12 = BrowserUtils.getReplacedString(string12, "<explainTableComment>", DatabaseMetadata.getReplacedString(string2, "'", "`"));
        string12 = BrowserUtils.getReplacedString(string12, "<explainTableIndexName>", string10);
        string12 = BrowserUtils.getReplacedString(string12, "<featureTableName>", string9);
        string12 = BrowserUtils.getReplacedString(string12, "<indexName>", string5);
        string12 = BrowserUtils.getReplacedString(string12, "<caseID>", string6);
        PreparedStatement preparedStatement = connection.prepareStatement(string12);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.close();
        preparedStatement.close();
        resultSet = null;
        preparedStatement = null;
        String string13 = " BEGIN   execute immediate 'create table <mappingTableName> as select distinct a.attribute_id, b.text from <explainTableName> a, table(drvodm.feature_explain(''<featureTableName>'')) b where a.attribute_id = b.id'; ";
        string13 = string13 + " execute immediate 'comment on table \"<user>\".\"<mappingTableCommentTableName>\" is ''<mappingTableComment>'' '; ";
        string13 = string13 + " execute immediate 'create index <mappingTableIndexName> on <mappingTableName>(attribute_id)'; " + " END; ";
        string13 = BrowserUtils.getReplacedString(string13, "<user>", DM4JConnectionManager.getUser());
        string13 = BrowserUtils.getReplacedString(string13, "<mappingTableName>", string3);
        string13 = BrowserUtils.getReplacedString(string13, "<mappingTableCommentTableName>", DM4JStringUtils.trimDoubleQuotes(string3));
        string13 = BrowserUtils.getReplacedString(string13, "<mappingTableComment>", DatabaseMetadata.getReplacedString(string4, "'", "`"));
        string13 = BrowserUtils.getReplacedString(string13, "<mappingTableIndexName>", string11);
        string13 = BrowserUtils.getReplacedString(string13, "<explainTableName>", string);
        string13 = BrowserUtils.getReplacedString(string13, "<featureTableName>", string9);
        PreparedStatement preparedStatement2 = connection.prepareStatement(string13);
        ResultSet resultSet2 = preparedStatement2.executeQuery();
        resultSet2.close();
        preparedStatement2.close();
        resultSet2 = null;
        preparedStatement2 = null;
        String string14 = " BEGIN  ctx_ddl.drop_preference('<preferenceTableName>');  execute immediate 'drop table <tempTableName>';  execute immediate 'drop table <featureTableName>';  END; ";
        string14 = BrowserUtils.getReplacedString(string14, "<preferenceTableName>", string7);
        string14 = BrowserUtils.getReplacedString(string14, "<tempTableName>", string8);
        string14 = BrowserUtils.getReplacedString(string14, "<featureTableName>", string9);
        PreparedStatement preparedStatement3 = connection.prepareStatement(string14);
        ResultSet resultSet3 = preparedStatement3.executeQuery();
        resultSet3.close();
        preparedStatement3.close();
        resultSet3 = null;
        preparedStatement3 = null;
    }

    public static String getODMrTextTablesSQL(Connection connection, String string, String string2, String string3, String string4, String string5, String string6, Integer n, Integer n2, boolean bl, boolean bl2, boolean bl3, Integer n3, String string7, boolean bl4) throws Exception {
        String string8 = ValidationUtil.createUniqueTableName(DM4JStringUtils.trimDoubleQuotes(string5), connection, "_PF");
        String string9 = ValidationUtil.createUniqueTableName(DM4JStringUtils.trimDoubleQuotes(string5), connection, "_T");
        String string10 = ValidationUtil.createUniqueTableName(DM4JStringUtils.trimDoubleQuotes(string5), connection, "_FE");
        String string11 = ValidationUtil.createUniqueIndexName(DM4JStringUtils.trimDoubleQuotes(string), connection, "_IX");
        String string12 = ValidationUtil.createUniqueIndexName(DM4JStringUtils.trimDoubleQuotes(string3), connection, "_IX");
        if (string7 != null) {
            string10 = string7;
        }
        String string13 = null;
        if (bl4) {
            string13 = " execute immediate 'create table \"<explainTableName>\" as select sequence_id, attribute_id, sum(value)/count(attribute_id) as value from table(drvodm.feature_prep(''<indexName>'',''<caseID>'',''<featureTableName>'')) group by sequence_id, attribute_id '; \n";
            string13 = string13 + " execute immediate 'comment on table \"<user>\".\"<explainTableCommentTableName>\" is ''<explainTableComment>'' '; \n";
            string13 = string13 + " execute immediate 'create index \"<explainTableIndexName>\" on \"<explainTableName>\"(sequence_id)'; \n";
        } else {
            string13 = " ctx_ddl.create_preference('\"<preferenceTableName>\"','SVM_CLASSIFIER'); \n";
            if (n != null && n > 0) {
                string13 = string13 + " ctx_ddl.set_attribute('\"<preferenceTableName>\"','MAX_DOCTERMS', <maximumTerms>); \n";
            }
            if (n2 != null && n2 > 0) {
                string13 = string13 + " ctx_ddl.set_attribute('\"<preferenceTableName>\"','MAX_FEATURES', <maximumDistinctFeatures>); \n";
            }
            string13 = bl ? string13 + " ctx_ddl.set_attribute('\"<preferenceTableName>\"','THEME_ON', 'TRUE'); \n" : string13 + " ctx_ddl.set_attribute('\"<preferenceTableName>\"','THEME_ON', 'FALSE'); \n";
            string13 = bl2 ? string13 + " ctx_ddl.set_attribute('\"<preferenceTableName>\"','TOKEN_ON', 'TRUE'); \n" : string13 + " ctx_ddl.set_attribute('\"<preferenceTableName>\"','TOKEN_ON', 'FALSE'); \n";
            string13 = bl3 ? string13 + " ctx_ddl.set_attribute('\"<preferenceTableName>\"','STEM_ON', 'TRUE'); \n" : string13 + " ctx_ddl.set_attribute('\"<preferenceTableName>\"','STEM_ON', 'FALSE'); \n";
            if (n3 != null && n3 > 0) {
                string13 = string13 + " ctx_ddl.set_attribute('\"<preferenceTableName>\"','MEMORY_SIZE', <memorySize>); \n";
            }
            string13 = string13 + " execute immediate 'create table \"<tempTableName>\" (id number, cid number)'; \n" + " execute immediate 'create table \"<explainTableName>\" as select sequence_id, attribute_id, sum(value)/count(attribute_id) as value from table(drvodm.feature_prep(''<indexName>'',''<caseID>'',''<tempTableName>'',''id'',''cid'',''<featureTableName>'',''<preferenceTableName>'')) group by sequence_id, attribute_id '; \n";
            string13 = string13 + " execute immediate 'comment on table \"<user>\".\"<explainTableCommentTableName>\" is ''<explainTableComment>'' '; \n";
            string13 = string13 + " execute immediate 'create index \"<explainTableIndexName>\" on \"<explainTableName>\"(sequence_id)'; \n";
        }
        string13 = BrowserUtils.getReplacedString(string13, "<preferenceTableName>", string8);
        string13 = BrowserUtils.getReplacedString(string13, "<maximumTerms>", n + "");
        string13 = BrowserUtils.getReplacedString(string13, "<maximumDistinctFeatures>", n2 + "");
        string13 = BrowserUtils.getReplacedString(string13, "<memorySize>", n3 + "");
        string13 = BrowserUtils.getReplacedString(string13, "<tempTableName>", string9);
        string13 = BrowserUtils.getReplacedString(string13, "<user>", DM4JConnectionManager.getUser());
        string13 = BrowserUtils.getReplacedString(string13, "<explainTableName>", DM4JStringUtils.trimDoubleQuotes(string));
        string13 = BrowserUtils.getReplacedString(string13, "<explainTableCommentTableName>", DM4JStringUtils.trimDoubleQuotes(string));
        string13 = BrowserUtils.getReplacedString(string13, "<explainTableComment>", DatabaseMetadata.getReplacedString(string2, "'", "`"));
        string13 = BrowserUtils.getReplacedString(string13, "<explainTableIndexName>", string11);
        string13 = BrowserUtils.getReplacedString(string13, "<featureTableName>", string10);
        string13 = BrowserUtils.getReplacedString(string13, "<indexName>", string5);
        string13 = BrowserUtils.getReplacedString(string13, "<caseID>", string6);
        String string14 = " execute immediate 'create table \"<mappingTableName>\" as select distinct a.attribute_id, b.text from \"<explainTableName>\" a, table(drvodm.feature_explain(''<featureTableName>'')) b where a.attribute_id = b.id'; \n";
        string14 = string14 + " execute immediate 'comment on table \"<user>\".\"<mappingTableCommentTableName>\" is ''<mappingTableComment>'' '; \n";
        string14 = string14 + " execute immediate 'create index \"<mappingTableIndexName>\" on \"<mappingTableName>\"(attribute_id)'; \n";
        string14 = BrowserUtils.getReplacedString(string14, "<user>", DM4JConnectionManager.getUser());
        string14 = BrowserUtils.getReplacedString(string14, "<mappingTableName>", DM4JStringUtils.trimDoubleQuotes(string3));
        string14 = BrowserUtils.getReplacedString(string14, "<mappingTableCommentTableName>", DM4JStringUtils.trimDoubleQuotes(string3));
        string14 = BrowserUtils.getReplacedString(string14, "<mappingTableComment>", DatabaseMetadata.getReplacedString(string4, "'", "`"));
        string14 = BrowserUtils.getReplacedString(string14, "<mappingTableIndexName>", string12);
        string14 = BrowserUtils.getReplacedString(string14, "<explainTableName>", string);
        string14 = BrowserUtils.getReplacedString(string14, "<featureTableName>", string10);
        String string15 = "";
        if (!bl4) {
            string15 = " ctx_ddl.drop_preference('<preferenceTableName>'); \n execute immediate 'drop table \"<tempTableName>\"'; \n";
            if (string7 == null) {
                string15 = string15 + " execute immediate 'drop table \"<featureTableName>\"'; \n";
            }
        }
        string15 = BrowserUtils.getReplacedString(string15, "<preferenceTableName>", string8);
        string15 = BrowserUtils.getReplacedString(string15, "<tempTableName>", string9);
        string15 = BrowserUtils.getReplacedString(string15, "<featureTableName>", string10);
        return string13 + " \n " + string14 + " \n " + string15;
    }

    public static void dropFeatureTable(Connection connection, String string, String string2, String string3) throws Exception {
        String string4 = " BEGIN   ctx_ddl.drop_preference('<preferenceTableName>');  execute immediate 'drop table <tempTableName>';   execute immediate 'drop table <featureTableName>';  END;";
        string4 = BrowserUtils.getReplacedString(string4, "<preferenceTableName>", string);
        string4 = BrowserUtils.getReplacedString(string4, "<tempTableName>", string2);
        string4 = BrowserUtils.getReplacedString(string4, "<featureTableName>", string3);
        PreparedStatement preparedStatement = connection.prepareStatement(string4);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.close();
        preparedStatement.close();
        resultSet = null;
        preparedStatement = null;
    }

    public static Vector getColumnNames(Connection connection, String string, String string2) throws Exception {
        Vector<String> vector = new Vector<String>(500, 100);
        StringBuffer stringBuffer = new StringBuffer("select COLUMN_NAME  from all_tab_columns  where TABLE_NAME = ?  AND OWNER = ?");
        PreparedStatement preparedStatement = connection.prepareStatement(stringBuffer.toString());
        preparedStatement.setString(1, string2);
        preparedStatement.setString(2, string);
        preparedStatement.setFetchSize(500);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            vector.add(resultSet.getString(COLUMN_NAME));
        }
        resultSet.close();
        preparedStatement.close();
        resultSet = null;
        preparedStatement = null;
        return vector;
    }

    public static boolean hasColumnName(Connection connection, String string, String string2, String string3) throws Exception {
        StringBuffer stringBuffer = new StringBuffer("select COLUMN_NAME  from all_tab_columns  where TABLE_NAME = ?  AND OWNER = ?  AND COLUMN_NAME = ?");
        PreparedStatement preparedStatement = connection.prepareStatement(stringBuffer.toString());
        preparedStatement.setString(1, string2);
        preparedStatement.setString(2, string);
        preparedStatement.setString(3, string3);
        preparedStatement.setFetchSize(500);
        ResultSet resultSet = preparedStatement.executeQuery();
        boolean bl = false;
        while (resultSet.next()) {
            bl = true;
        }
        resultSet.close();
        preparedStatement.close();
        resultSet = null;
        preparedStatement = null;
        return bl;
    }

    public static Vector getColumnNames(Connection connection, String string, String string2, String string3) throws Exception {
        Vector<String> vector = new Vector<String>(500, 100);
        StringBuffer stringBuffer = new StringBuffer("select COLUMN_NAME  from all_tab_columns  where TABLE_NAME = ?  AND OWNER = ?  AND DATA_TYPE = ?");
        PreparedStatement preparedStatement = connection.prepareStatement(stringBuffer.toString());
        preparedStatement.setString(1, string2);
        preparedStatement.setString(2, string);
        preparedStatement.setString(3, string3);
        preparedStatement.setFetchSize(500);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            vector.add(resultSet.getString(COLUMN_NAME));
        }
        resultSet.close();
        preparedStatement.close();
        resultSet = null;
        preparedStatement = null;
        return vector;
    }

    public static Vector getColumnNamesBasedOnDataTypes(Connection connection, String string, String string2, Vector vector) throws Exception {
        Vector<String> vector2 = new Vector<String>(500, 100);
        StringBuffer stringBuffer = new StringBuffer("select COLUMN_NAME  from all_tab_columns  where TABLE_NAME = ?  AND OWNER = ?  AND DATA_TYPE IN (");
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < vector.size(); ++i) {
            stringBuffer2.append("'" + (String)vector.get(i) + "'" + ",");
        }
        if (vector.size() > 0) {
            stringBuffer2.deleteCharAt(stringBuffer2.length() - 1);
            stringBuffer2.append(")");
        }
        stringBuffer.append(stringBuffer2);
        PreparedStatement preparedStatement = connection.prepareStatement(stringBuffer.toString());
        preparedStatement.setString(1, string2);
        preparedStatement.setString(2, string);
        preparedStatement.setFetchSize(500);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            vector2.add(resultSet.getString(COLUMN_NAME));
        }
        resultSet.close();
        preparedStatement.close();
        resultSet = null;
        preparedStatement = null;
        return vector2;
    }

    public static Vector getSequenceColumn(Connection connection, String string, String string2) throws Exception {
        Vector vector = new Vector();
        int n = 0;
        String string3 = "select count(*) from <owner>.<table> ";
        string3 = BrowserUtils.getReplacedString(string3, "<owner>", DM4JStringUtils.isDoubleQuotedString(string) ? string : "\"" + string + "\"");
        string3 = BrowserUtils.getReplacedString(string3, "<table>", DM4JStringUtils.isDoubleQuotedString(string2) ? string2 : "\"" + string2 + "\"");
        PreparedStatement preparedStatement = connection.prepareStatement(string3);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            n = Integer.parseInt(resultSet.getString(1));
        }
        resultSet.close();
        preparedStatement.close();
        resultSet = null;
        preparedStatement = null;
        if (n > 0) {
            Vector vector2 = new Vector(500, 100);
            Vector<String> vector3 = new Vector<String>(500, 100);
            vector2 = DatabaseMetadata.getColumnNames(connection, string, string2, "NUMBER");
            string3 = "select <distinct> from <owner>.<table> ";
            String string4 = "";
            for (int i = 0; i < vector2.size(); ++i) {
                string4 = i == 0 ? string4 + " count(distinct(\"" + vector2.get(i) + "\"))" : string4 + ", count(distinct(\"" + vector2.get(i) + "\"))";
            }
            string3 = BrowserUtils.getReplacedString(string3, "<distinct>", string4);
            string3 = BrowserUtils.getReplacedString(string3, "<table>", DM4JStringUtils.isDoubleQuotedString(string2) ? string2 : "\"" + string2 + "\"");
            string3 = BrowserUtils.getReplacedString(string3, "<owner>", DM4JStringUtils.isDoubleQuotedString(string) ? string : "\"" + string + "\"");
            string3 = BrowserUtils.getReplacedString(string3, "<tableName>", DM4JStringUtils.isDoubleQuotedString(string2) ? string2 : "\"" + string2 + "\"");
            PreparedStatement preparedStatement2 = connection.prepareStatement(string3);
            preparedStatement2.setFetchSize(500);
            ResultSet resultSet2 = preparedStatement2.executeQuery();
            while (resultSet2.next()) {
                String string5 = null;
                for (int i = 0; i < vector2.size(); ++i) {
                    string5 = resultSet2.getString(i + 1);
                    vector3.add(string5);
                    if (Integer.parseInt(string5) != n) continue;
                    vector.add(vector2.get(i));
                }
            }
            resultSet2.close();
            preparedStatement2.close();
            resultSet2 = null;
            preparedStatement2 = null;
        }
        return vector;
    }

    public static Vector getSortedColumnNames(Connection connection, String string, String string2) throws Exception {
        Vector<String> vector = new Vector<String>(500, 100);
        StringBuffer stringBuffer = new StringBuffer("select COLUMN_NAME  from all_tab_columns  where TABLE_NAME = ?  AND OWNER = ?  ORDER BY COLUMN_NAME ");
        PreparedStatement preparedStatement = connection.prepareStatement(stringBuffer.toString());
        preparedStatement.setString(1, string2);
        preparedStatement.setString(2, string);
        preparedStatement.setFetchSize(500);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            vector.add(resultSet.getString(COLUMN_NAME));
        }
        resultSet.close();
        preparedStatement.close();
        resultSet = null;
        preparedStatement = null;
        return vector;
    }

    public static JDBCModel getColumnData(Connection connection, String string) throws Exception {
        JDBCModel jDBCModel = new JDBCModel();
        jDBCModel.setConnection(connection);
        StringBuffer stringBuffer = new StringBuffer("select COLUMN_NAME  from all_tab_columns  where TABLE_NAME = '" + string + "'");
        jDBCModel.executeQuery(stringBuffer.toString());
        return jDBCModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean datasourceExists(Connection connection, String string, String string2) throws Exception {
        String string3;
        String string4 = "select table_name from all_tables where owner = {owner} and table_name = {table}";
        String string5 = "select view_name from all_views where owner = {owner} and view_name = {table}";
        boolean bl = false;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            string = DM4JStringUtils.isDoubleQuotedString(string) ? DM4JStringUtils.trimDoubleQuotes(string) : string.toUpperCase();
            string = "'" + DatabaseMetadata.getReplacedString(string, "'", "''") + "'";
            string2 = DM4JStringUtils.isDoubleQuotedString(string2) ? DM4JStringUtils.trimDoubleQuotes(string2) : string2.toUpperCase();
            string2 = "'" + DatabaseMetadata.getReplacedString(string2, "'", "''") + "'";
            string4 = DatabaseMetadata.getReplacedString(string4, "{owner}", string);
            string4 = DatabaseMetadata.getReplacedString(string4, "{table}", string2);
            statement = connection.prepareStatement(string4);
            resultSet = statement.executeQuery();
            if (resultSet.next() && (string3 = resultSet.getString(1)) != null) {
                boolean bl2 = true;
                return bl2;
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {}
        }
        try {
            string5 = DatabaseMetadata.getReplacedString(string5, "{owner}", string);
            string5 = DatabaseMetadata.getReplacedString(string5, "{table}", string2);
            statement = connection.prepareStatement(string5);
            resultSet = statement.executeQuery();
            if (resultSet.next() && (string3 = resultSet.getString(1)) != null) {
                boolean bl3 = true;
                return bl3;
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {}
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTable(Connection connection, String string, String string2) throws Exception {
        String string3 = "select table_name from all_tables where owner = {owner} and table_name = {table}";
        boolean bl = false;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            String string4;
            string = DM4JStringUtils.isDoubleQuotedString(string) ? DM4JStringUtils.trimDoubleQuotes(string) : string;
            string = "'" + DatabaseMetadata.getReplacedString(string, "'", "''") + "'";
            string2 = DM4JStringUtils.isDoubleQuotedString(string2) ? DM4JStringUtils.trimDoubleQuotes(string2) : string2;
            string2 = "'" + DatabaseMetadata.getReplacedString(string2, "'", "''") + "'";
            string3 = DatabaseMetadata.getReplacedString(string3, "{owner}", string);
            string3 = DatabaseMetadata.getReplacedString(string3, "{table}", string2);
            statement = connection.prepareStatement(string3);
            resultSet = statement.executeQuery();
            if (resultSet.next() && (string4 = resultSet.getString(1)) != null) {
                bl = true;
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {}
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTableWithIndex(Connection connection, String string, String string2, String string3, String string4) throws SQLException {
        String string5 = null;
        PreparedStatement preparedStatement = null;
        string5 = "create table \"{0}\".\"{1}\" as ";
        Object[] objectArray = new Object[]{DM4JStringUtils.trimDoubleQuotes(string2), DM4JStringUtils.trimDoubleQuotes(string3)};
        string5 = MessageFormat.format(string5, objectArray) + string;
        try {
            preparedStatement = connection.prepareStatement(string5);
            preparedStatement.execute();
            if (string4 != null) {
                preparedStatement.close();
                String string6 = ValidationUtil.createUniquePKConstraintName(string4, connection);
                string5 = "alter table \"{0}\".\"{1}\" add constraint " + string6 + " primary key (\"{2}\")";
                objectArray = new Object[]{DM4JStringUtils.trimDoubleQuotes(string2), DM4JStringUtils.trimDoubleQuotes(string3), DM4JStringUtils.trimDoubleQuotes(string4)};
                string5 = MessageFormat.format(string5, objectArray);
                preparedStatement = connection.prepareStatement(string5);
                preparedStatement.execute();
            }
        }
        finally {
            try {
                preparedStatement.close();
                preparedStatement = null;
            }
            catch (Exception exception) {}
        }
    }

    public static void createTableAs(Connection connection, String string, String string2, String string3) throws SQLException {
        DatabaseMetadata.createTableWithIndex(connection, string, string2, string3, null);
    }

    public static Hashtable getODMrTextLookupTable(Connection connection, String string) throws SQLException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string2 = null;
        string2 = "select ATTRIBUTE_ID, TEXT from " + string.toUpperCase();
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        preparedStatement.setFetchSize(1000);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            hashtable.put(resultSet.getString("ATTRIBUTE_ID"), resultSet.getString("TEXT"));
        }
        resultSet.close();
        preparedStatement.close();
        resultSet = null;
        preparedStatement = null;
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable getODMrTextLookupTable(String string) {
        Hashtable hashtable = null;
        String string2 = null;
        Hashtable hashtable2 = null;
        Connection connection = null;
        try {
            DMEMetadata dMEMetadata = DMEMetadata.getInstance();
            connection = DM4JConnectionManager.getDbConnection();
            hashtable2 = dMEMetadata.getTransparencyTables(connection, null, string);
            if (hashtable2 != null) {
                string2 = (String)hashtable2.get("XTMAP");
            }
            if (string2 != null) {
                hashtable = DatabaseMetadata.getODMrTextLookupTable(connection, string2);
            }
        }
        catch (Exception exception) {
            string2 = null;
        }
        finally {
            try {
                connection.close();
            }
            catch (Exception exception) {}
        }
        return hashtable;
    }
}

