/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.tree.node.JLabelNode;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.integrator.disco.DiscoODMrGateway;

public class DMEMetadata {
    public static final String CLASSIFICATION = "CLASSIFICATION";
    public static final String ASSOCIATION_RULES = "ASSOCIATION_RULES";
    public static final String ATTRIBUTE_IMPORTANCE = "ATTRIBUTE_IMPORTANCE";
    public static final String CLUSTERING = "CLUSTERING";
    public static final String FEATURE_EXTRACTION = "FEATURE_EXTRACTION";
    public static final String REGRESSION = "REGRESSION";
    public static final String ANOMALY_DETECTION = "ANOMALY_DETECTION";
    public static final String ADAPTIVE_BAYES_NETWORK_MODEL = "ADAPTIVE_BAYES_NETWORK";
    public static final String NAIVE_BAYES_MODEL = "NAIVE_BAYES";
    public static final String SUPPORT_VECTOR_MACHINES_MODEL = "SUPPORT_VECTOR_MACHINES";
    public static final String GENERALIZED_LINEAR_MODEL = "GENERALIZED_LINEAR_MODEL";
    public static final String ONE_CLASS_SVM_MODEL = "ONE_CLASS_SVM";
    public static final String DECISION_TREE_MODEL = "DECISION_TREE";
    public static final String KMEANS_MODEL = "KMEANS";
    public static final String O_CLUSTER_MODEL = "O_CLUSTER";
    public static final String APRIORI_ASSOCIATION_RULES_MODEL = "APRIORI_ASSOCIATION_RULES";
    public static final String MINIMUM_DESCRIPTION_LENGTH_MODEL = "MINIMUM_DESCRIPTION_LENGTH";
    public static final String NONNEGATIVE_MATRIX_FACTOR_MODEL = "NONNEGATIVE_MATRIX_FACTOR";
    public static final String BUILD_TYPE = "BUILD";
    public static final String TEST_TYPE = "TEST";
    public static final String RESIDUAL_PLOT_TYPE = "PLOT";
    public static final String APPLY_TYPE = "APPLY";
    public static final String XBINC = "XBINC";
    public static final String XBINN = "XBINN";
    public static final String XNORM = "XNORM";
    public static final String XNORM_SHIFT = "SHIFT";
    public static final String XNORM_SCALE = "SCALE";
    public static final String XMAP = "XMAP";
    public static final String XPCV = "XPCV";
    public static final String XTFEA = "XTFEA";
    public static final String XTMAP = "XTMAP";
    public static final String XFORM_TEXT_TYPE = "XTEXT";
    public static final String PREDICT_TYPE = "PRDCT";
    public static final String EXPLAIN_TYPE = "EXPLN";
    public static final String ALL_TYPE = "ALL";
    public static final String TASK_NAME = "TASK_NAME";
    public static final String TASK_TYPE = "TASK_TYPE";
    public static final String TASK_STATE = "TASK_STATE";
    public static final String TASK_DATE = "TASK_DATE";
    public static final String UNKNOWN_VALUE = "DM4J$UNKNOWN";
    private static final String MODEL_VIEW = "DM_USER_MODELS";
    private static final String RESULTS_TABLE = "DM4J$RESULTS";
    private static final String TRANSFORMS_TABLE = "DM4J$TRANSFORMS";
    private static final String RESULTS_STATE_VIEW = "DM4J$RESULTS_STATE_V";
    private static final String MODEL_RESULTS_VIEW = "DM4J$MODEL_RESULTS_V";
    private static final String RESULT_COLUMN = "RESULT_NAME";
    private static final String TASK_NAME_COLUMN = "TASK_NAME";
    private static final String TYPE_COLUMN = "TYPE";
    private static final String MODEL_COLUMN = "MODEL_NAME";
    private static final String ACTIVITY_COLUMN = "ACTIVITY_NAME";
    private static final String CREATION_DATE_COLUMN = "CREATION_DATE";
    private static final String FUNCTION_NAME_COLUMN = "FUNCTION_NAME";
    private static final String ALGORITHM_NAME_COLUMN = "ALGORITHM_NAME";
    private static final String MODEL_SIZE_COLUMN = "MODEL_SIZE";
    private static final String STATE_COLUMN = "STATE";
    private static final String XFORM_TABLE = "XFORM_TABLE";
    private static final String NAME_COLUMN = "NAME";
    private static final String ACTIVITY_NAME_COLUMN = "ACTIVITY_NAME";
    private static final String BUILD_DURATION_COLUMN = "BUILD_DURATION";
    private static final String TARGET_ATTRIBUTE_COLUMN = "TARGET_ATTRIBUTE";
    private static DMEMetadata _instance = null;
    private static final String ACTIVITIES_TABLE = "DM4J$ACTIVITIES";
    private static final String CG_ACTIVITY_NAME = "ACTIVITY_NAME";
    private static final String CG_ACTIVITY_TYPE = "ACTIVITY_TYPE";
    private static final String CG_MODEL_NAME = "MODEL_NAME";
    private static final String CG_ACTIVITY_COMMENTS = "ACTIVITY_COMMENTS";
    private static final String CG_ACTIVITY_CREATION_DATE = "ACTIVITY_CREATION_DATE";
    private static int A = 0;
    public static final int CG_ACTIVITY_SELECTED_COLUMN = A++;
    public static final int CG_ACTIVITY_NAME_COLUMN = A++;
    public static final int CG_ACTIVITY_TYPE_COLUMN = A++;
    public static final int CG_ACTIVITY_FUNCTION_NAME_COLUMN = A++;
    public static final int CG_ACTIVITY_ALG_NAME_COLUMN = A++;
    public static final int CG_ACTIVITY_MODEL_COLUMN = A++;
    public static final int CG_ACTIVITY_CREATION_DATE_COLUMN = A++;
    public static final int CG_ACTIVITY_COMMENT_COLUMN = A++;
    public static final int CG_TOTAL_COUNT = A;
    private static final String ACTIVITIES_LIST = "select distinct ACTIVITY_NAME, ACTIVITY_TYPE, ACTIVITY_COMMENTS, ACTIVITY_CREATION_DATE, MODEL_NAME from\n  (select activities.name          ACTIVITY_NAME,\n          activities.type          ACTIVITY_TYPE,\n          activities.comments      ACTIVITY_COMMENTS,\n          activities.creation_date ACTIVITY_CREATION_DATE,\n          results.model_name       MODEL_NAME\nfrom \"DM4J$ACTIVITIES\" activities, \"DM4J$RESULTS\" results\nwhere activities.name=results.activity_name)";
    private static final String ACTIVITIES_TABLE_CHECK = "SELECT COUNT (*) FROM \"DM4J$ACTIVITIES\"";
    private static String ALL_PACKAGES = "select object_name from user_objects where object_type ='PACKAGE'";

    private DMEMetadata() {
    }

    public static DMEMetadata getInstance() {
        if (null == _instance) {
            _instance = new DMEMetadata();
        }
        return _instance;
    }

    public static boolean isSVMModelLinear(String string) throws Exception {
        Statement statement = null;
        ResultSet resultSet = null;
        boolean bl = false;
        Connection connection = null;
        try {
            String string2;
            connection = DM4JConnectionManager.getDbConnection();
            String string3 = "SELECT setting_name, setting_value\n  FROM TABLE(DBMS_DATA_MINING.GET_MODEL_SETTINGS('" + string + "'))\n" + "  WHERE setting_name = 'SVMS_KERNEL_FUNCTION' and setting_value = 'SVMS_LINEAR'";
            statement = connection.prepareStatement(string3);
            resultSet = statement.executeQuery();
            bl = resultSet.next() ? null != (string2 = resultSet.getString(1)) : false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            if (null != statement) {
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (null != resultSet) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return bl;
    }

    public static boolean isABNModelSingleFeature(String string) throws Exception {
        Statement statement = null;
        ResultSet resultSet = null;
        boolean bl = false;
        Connection connection = null;
        try {
            String string2;
            connection = DM4JConnectionManager.getDbConnection();
            String string3 = "SELECT setting_name, setting_value\n  FROM TABLE(DBMS_DATA_MINING.GET_MODEL_SETTINGS('" + string + "'))\n" + "  WHERE setting_name = 'ABNS_MODEL_TYPE' and setting_value = 'ABNS_SINGLE_FEATURE'";
            statement = connection.prepareStatement(string3);
            resultSet = statement.executeQuery();
            bl = resultSet.next() ? null != (string2 = resultSet.getString(1)) : false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            if (null != statement) {
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (null != resultSet) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSchemaTablesExisted(Connection connection) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            String string;
            String string2 = "SELECT TABLE_NAME FROM USER_TABLES WHERE TABLE_NAME = 'DM4J$RESULTS'";
            String string3 = "SELECT TABLE_NAME FROM USER_TABLES WHERE TABLE_NAME = 'DM4J$TRANSFORMS'";
            preparedStatement = connection.prepareStatement(string2);
            resultSet = preparedStatement.executeQuery();
            bl = resultSet.next() ? null != (string = resultSet.getString(1)) : false;
            resultSet.close();
            resultSet = null;
            preparedStatement.close();
            preparedStatement = null;
            preparedStatement = connection.prepareStatement(string3);
            resultSet = preparedStatement.executeQuery();
            bl2 = resultSet.next() ? null != (string = resultSet.getString(1)) : false;
        }
        catch (Exception exception) {
        }
        finally {
            if (null != preparedStatement) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
            if (null != resultSet) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
        }
        return bl && bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSchemaViewsExisted(Connection connection) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            String string;
            String string2 = "SELECT VIEW_NAME FROM USER_VIEWS WHERE VIEW_NAME = 'DM4J$RESULTS_STATE_V'";
            String string3 = "SELECT VIEW_NAME FROM USER_VIEWS WHERE VIEW_NAME = 'DM4J$MODEL_RESULTS_V'";
            preparedStatement = connection.prepareStatement(string2);
            resultSet = preparedStatement.executeQuery();
            bl = resultSet.next() ? null != (string = resultSet.getString(1)) : false;
            resultSet.close();
            resultSet = null;
            preparedStatement.close();
            preparedStatement = null;
            preparedStatement = connection.prepareStatement(string3);
            resultSet = preparedStatement.executeQuery();
            bl2 = resultSet.next() ? null != (string = resultSet.getString(1)) : false;
        }
        catch (Exception exception) {
        }
        finally {
            if (null != preparedStatement) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
            if (null != resultSet) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
        }
        return bl && bl2;
    }

    public static void dropSchema(Connection connection) throws Exception {
        boolean bl;
        PreparedStatement preparedStatement = null;
        String string = null;
        try {
            string = "DROP VIEW DM4J$RESULTS_STATE_V";
            preparedStatement = connection.prepareStatement(string);
            bl = preparedStatement.execute();
            preparedStatement.close();
            preparedStatement = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            string = "DROP VIEW DM4J$MODEL_RESULTS_V";
            preparedStatement = connection.prepareStatement(string);
            bl = preparedStatement.execute();
            preparedStatement.close();
            preparedStatement = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            string = "DROP TABLE DM4J$TRANSFORMS";
            preparedStatement = connection.prepareStatement(string);
            bl = preparedStatement.execute();
            preparedStatement.close();
            preparedStatement = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            string = "DROP TABLE DM4J$RESULTS";
            preparedStatement = connection.prepareStatement(string);
            bl = preparedStatement.execute();
            preparedStatement.close();
            preparedStatement = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void migration(Connection connection) throws Exception {
        PreparedStatement preparedStatement = null;
        try {
            String string = "ALTER TABLE DM4J$RESULTS MODIFY (ACTIVITY_NAME VARCHAR2(100))";
            String string2 = "UPDATE DM4J$RESULTS a SET (RESULT_NAME) = (  SELECT TRIM(BOTH '\"' FROM RESULT_NAME)  FROM DM4J$RESULTS b  WHERE a.TASK_NAME = b.TASK_NAME)";
            preparedStatement = connection.prepareStatement(string);
            boolean bl = preparedStatement.execute();
            preparedStatement.close();
            preparedStatement = null;
            preparedStatement = connection.prepareStatement(string2);
            bl = preparedStatement.execute();
            preparedStatement.close();
            preparedStatement = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            if (null != preparedStatement) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void createSchema(Connection connection) throws Exception {
        PreparedStatement preparedStatement = null;
        try {
            String string = "CREATE TABLE DM4J$RESULTS (RESULT_NAME VARCHAR2(32) NOT NULL, TASK_NAME VARCHAR2(32) NOT NULL CONSTRAINT TASK_NAME_U  UNIQUE, TYPE VARCHAR2(10) NOT NULL, MODEL_NAME VARCHAR2(32) NOT NULL, ACTIVITY_NAME VARCHAR2(100) NOT NULL, CREATION_DATE DATE DEFAULT SYSDATE)";
            preparedStatement = connection.prepareStatement(string);
            boolean bl = preparedStatement.execute();
            preparedStatement.close();
            preparedStatement = null;
            string = "CREATE INDEX RESULT_NAME_IND ON DM4J$RESULTS (RESULT_NAME)";
            preparedStatement = connection.prepareStatement(string);
            bl = preparedStatement.execute();
            preparedStatement.close();
            preparedStatement = null;
            string = "CREATE INDEX MODEL_NAME_IND ON DM4J$RESULTS (MODEL_NAME)";
            preparedStatement = connection.prepareStatement(string);
            bl = preparedStatement.execute();
            preparedStatement.close();
            preparedStatement = null;
            string = "CREATE INDEX ACTIVITY_NAME_IND ON DM4J$RESULTS (ACTIVITY_NAME)";
            preparedStatement = connection.prepareStatement(string);
            bl = preparedStatement.execute();
            preparedStatement.close();
            preparedStatement = null;
            string = "CREATE TABLE DM4J$TRANSFORMS (TASK_NAME VARCHAR2(32) NOT NULL CONSTRAINT fk_results REFERENCES  DM4J$RESULTS(TASK_NAME) ON DELETE CASCADE, MODEL_NAME VARCHAR2(32) NOT NULL, TYPE VARCHAR2(10) NOT NULL, XFORM_TABLE VARCHAR2(32) NOT NULL )";
            preparedStatement = connection.prepareStatement(string);
            bl = preparedStatement.execute();
            preparedStatement.close();
            preparedStatement = null;
            string = "CREATE INDEX MODEL_NAME_IND_TRANS ON DM4J$TRANSFORMS (MODEL_NAME)";
            preparedStatement = connection.prepareStatement(string);
            bl = preparedStatement.execute();
            preparedStatement.close();
            preparedStatement = null;
            DMEMetadata.createViews(connection);
        }
        catch (Exception exception) {
            DMEMetadata.dropSchema(connection);
            exception.printStackTrace();
            throw exception;
        }
        finally {
            if (null != preparedStatement) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void createViews(Connection connection) throws Exception {
        PreparedStatement preparedStatement = null;
        try {
            String string = "CREATE OR REPLACE VIEW DM4J$RESULTS_STATE_V AS SELECT   r.TASK_NAME, r.RESULT_NAME, r.TYPE, r.MODEL_NAME, r.CREATION_DATE, r.ACTIVITY_NAME, j.state FROM DM4J$RESULTS r, USER_SCHEDULER_JOBS j WHERE r.TASK_NAME=j.job_name";
            preparedStatement = connection.prepareStatement(string);
            boolean bl = preparedStatement.execute();
            preparedStatement.close();
            preparedStatement = null;
            string = "CREATE OR REPLACE VIEW DM4J$MODEL_RESULTS_V AS SELECT   r.TASK_NAME, r.RESULT_NAME, r.TYPE, r.MODEL_NAME, r.ACTIVITY_NAME,   m.FUNCTION_NAME, m.ALGORITHM_NAME, m.CREATION_DATE, m.MODEL_SIZE FROM DM4J$RESULTS r, DM_USER_MODELS m WHERE UPPER(r.MODEL_NAME)=m.NAME";
            preparedStatement = connection.prepareStatement(string);
            bl = preparedStatement.execute();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            if (null != preparedStatement) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static String fixObjectNameWhenSave(String string) {
        return DM4JStringUtils.isDoubleQuotedString(string) ? DM4JStringUtils.trimDoubleQuotes(string) : string.toUpperCase();
    }

    public static String fixObjectNameWhenLoad(String string) {
        return DM4JStringUtils.isDoubleQuotedString(string) ? string : DM4JStringUtils.addDoubleQuotes(string);
    }

    public synchronized void insertBuildRec(Connection connection, String string, String string2, String string3) throws Exception {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("INSERT INTO DM4J$RESULTS (RESULT_NAME, TASK_NAME, TYPE, MODEL_NAME, ACTIVITY_NAME) VALUES (?, ?, ?, ?, ?)");
            preparedStatement.setString(1, string2.toUpperCase());
            preparedStatement.setString(2, DMEMetadata.fixObjectNameWhenSave(string));
            preparedStatement.setString(3, BUILD_TYPE);
            preparedStatement.setString(4, string2.toUpperCase());
            preparedStatement.setString(5, string3);
            preparedStatement.executeUpdate();
            connection.commit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            if (null != preparedStatement) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public synchronized void deleteBuildRec(Connection connection, String string, String string2) throws Exception {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("DELETE FROM DM4J$RESULTS WHERE TYPE = ? AND RESULT_NAME LIKE ? AND TASK_NAME LIKE ?".toString());
            preparedStatement.setString(1, BUILD_TYPE);
            preparedStatement.setString(2, string2 == null ? "%" : string2.toUpperCase());
            preparedStatement.setString(3, string == null ? "%" : DMEMetadata.fixObjectNameWhenSave(string));
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            if (null != preparedStatement) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public synchronized void insertTestRec(Connection connection, String string, String string2, String string3, String string4) throws Exception {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("INSERT INTO DM4J$RESULTS (RESULT_NAME, TASK_NAME, TYPE, MODEL_NAME, ACTIVITY_NAME) VALUES (?, ?, ?, ?, ?)");
            preparedStatement.setString(1, DMEMetadata.fixObjectNameWhenSave(string));
            preparedStatement.setString(2, DMEMetadata.fixObjectNameWhenSave(string2));
            preparedStatement.setString(3, TEST_TYPE);
            preparedStatement.setString(4, string3.toUpperCase());
            preparedStatement.setString(5, string4);
            preparedStatement.executeUpdate();
            connection.commit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            if (null != preparedStatement) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public synchronized void deleteTestRec(Connection connection, String string, String string2) throws Exception {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("DELETE FROM DM4J$RESULTS WHERE TYPE = ? AND RESULT_NAME LIKE ? AND TASK_NAME LIKE ?");
            preparedStatement.setString(1, TEST_TYPE);
            preparedStatement.setString(2, string2 == null ? "%" : DMEMetadata.fixObjectNameWhenSave(string2));
            preparedStatement.setString(3, string == null ? "%" : DMEMetadata.fixObjectNameWhenSave(string));
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            if (null != preparedStatement) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public synchronized void insertPlotsRec(Connection connection, String string, String string2, String string3, String string4) throws Exception {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("INSERT INTO DM4J$RESULTS (RESULT_NAME, TASK_NAME, TYPE, MODEL_NAME, ACTIVITY_NAME) VALUES (?, ?, ?, ?, ?)");
            preparedStatement.setString(1, DMEMetadata.fixObjectNameWhenSave(string));
            preparedStatement.setString(2, DMEMetadata.fixObjectNameWhenSave(string2));
            preparedStatement.setString(3, RESIDUAL_PLOT_TYPE);
            preparedStatement.setString(4, string3.toUpperCase());
            preparedStatement.setString(5, string4);
            preparedStatement.executeUpdate();
            connection.commit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            if (null != preparedStatement) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public synchronized void deletePlotsRec(Connection connection, String string, String string2) throws Exception {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("DELETE FROM DM4J$RESULTS WHERE TYPE = ? AND RESULT_NAME LIKE ? AND TASK_NAME LIKE ?");
            preparedStatement.setString(1, RESIDUAL_PLOT_TYPE);
            preparedStatement.setString(2, string2 == null ? "%" : DMEMetadata.fixObjectNameWhenSave(string2));
            preparedStatement.setString(3, string == null ? "%" : DMEMetadata.fixObjectNameWhenSave(string));
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            if (null != preparedStatement) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public synchronized void insertApplyRec(Connection connection, String string, String string2, String string3, String string4) throws Exception {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("INSERT INTO DM4J$RESULTS (RESULT_NAME, TASK_NAME, TYPE, MODEL_NAME, ACTIVITY_NAME) VALUES (?, ?, ?, ?, ?)");
            preparedStatement.setString(1, DMEMetadata.fixObjectNameWhenSave(string));
            preparedStatement.setString(2, DMEMetadata.fixObjectNameWhenSave(string2));
            preparedStatement.setString(3, APPLY_TYPE);
            preparedStatement.setString(4, string3.toUpperCase());
            preparedStatement.setString(5, string4);
            preparedStatement.executeUpdate();
            connection.commit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            if (null != preparedStatement) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public synchronized void deleteApplyRec(Connection connection, String string, String string2) throws Exception {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("DELETE FROM DM4J$RESULTS WHERE TYPE = ? AND RESULT_NAME LIKE ? AND TASK_NAME LIKE ?");
            preparedStatement.setString(1, APPLY_TYPE);
            preparedStatement.setString(2, string2 == null ? "%" : DMEMetadata.fixObjectNameWhenSave(string2));
            preparedStatement.setString(3, string == null ? "%" : DMEMetadata.fixObjectNameWhenSave(string));
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            if (null != preparedStatement) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public synchronized void insertXformRec(Connection connection, String string, String string2, String string3, String string4) throws Exception {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("INSERT INTO DM4J$RESULTS (RESULT_NAME, TASK_NAME, TYPE, MODEL_NAME, ACTIVITY_NAME) VALUES (?, ?, ?, ?, ?)");
            preparedStatement.setString(1, DMEMetadata.fixObjectNameWhenSave(string));
            preparedStatement.setString(2, DMEMetadata.fixObjectNameWhenSave(string2));
            preparedStatement.setString(3, XFORM_TEXT_TYPE);
            preparedStatement.setString(4, DMEMetadata.fixObjectNameWhenSave(string3));
            preparedStatement.setString(5, string4);
            preparedStatement.executeUpdate();
            connection.commit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            if (null != preparedStatement) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public synchronized void deleteXformRec(Connection connection, String string, String string2) throws Exception {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("DELETE FROM DM4J$RESULTS WHERE TYPE = ? AND RESULT_NAME LIKE ? AND TASK_NAME LIKE ?");
            preparedStatement.setString(1, XFORM_TEXT_TYPE);
            preparedStatement.setString(2, string2 == null ? "%" : DMEMetadata.fixObjectNameWhenSave(string2));
            preparedStatement.setString(3, string == null ? "%" : DMEMetadata.fixObjectNameWhenSave(string));
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            if (null != preparedStatement) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public synchronized void insertPredictRec(Connection connection, String string, String string2, String string3) throws Exception {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("INSERT INTO DM4J$RESULTS (RESULT_NAME, TASK_NAME, TYPE, MODEL_NAME, ACTIVITY_NAME) VALUES (?, ?, ?, ?, ?)");
            preparedStatement.setString(1, DMEMetadata.fixObjectNameWhenSave(string));
            preparedStatement.setString(2, DMEMetadata.fixObjectNameWhenSave(string2));
            preparedStatement.setString(3, PREDICT_TYPE);
            preparedStatement.setString(4, DMEMetadata.fixObjectNameWhenSave(string3));
            preparedStatement.setString(5, UNKNOWN_VALUE);
            preparedStatement.executeUpdate();
            connection.commit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            if (null != preparedStatement) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public synchronized void deletePredictRec(Connection connection, String string, String string2) throws Exception {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("DELETE FROM DM4J$RESULTS WHERE TASK_NAME = ? AND RESULT_NAME LIKE ? AND TASK_NAME LIKE ?");
            preparedStatement.setString(1, PREDICT_TYPE);
            preparedStatement.setString(2, string2 == null ? "%" : DMEMetadata.fixObjectNameWhenSave(string2));
            preparedStatement.setString(3, string == null ? "%" : DMEMetadata.fixObjectNameWhenSave(string));
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            if (null != preparedStatement) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public synchronized void insertExplainRec(Connection connection, String string, String string2, String string3) throws Exception {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("INSERT INTO DM4J$RESULTS (RESULT_NAME, TASK_NAME, TYPE, MODEL_NAME, ACTIVITY_NAME) VALUES (?, ?, ?, ?, ?)");
            preparedStatement.setString(1, DMEMetadata.fixObjectNameWhenSave(string));
            preparedStatement.setString(2, DMEMetadata.fixObjectNameWhenSave(string2));
            preparedStatement.setString(3, EXPLAIN_TYPE);
            preparedStatement.setString(4, DMEMetadata.fixObjectNameWhenSave(string3));
            preparedStatement.setString(5, UNKNOWN_VALUE);
            preparedStatement.executeUpdate();
            connection.commit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            if (null != preparedStatement) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public synchronized void deleteExplainRec(Connection connection, String string, String string2) throws Exception {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("DELETE FROM DM4J$RESULTS WHERE TYPE = ? AND RESULT_NAME LIKE ? AND TASK_NAME LIKE ?");
            preparedStatement.setString(1, EXPLAIN_TYPE);
            preparedStatement.setString(2, string2 == null ? "%" : DMEMetadata.fixObjectNameWhenSave(string2));
            preparedStatement.setString(3, string == null ? "%" : DMEMetadata.fixObjectNameWhenSave(string));
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            if (null != preparedStatement) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public synchronized void synchronize(Connection connection) throws Exception {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String string = "SELECT job_name, program_name, end_date, argument_name, value FROM ( SELECT   j.job_name, j.program_name, j.end_date, a.argument_name, a.value FROM USER_SCHEDULER_JOB_ARGS a, USER_SCHEDULER_JOBS j WHERE j.job_name = a.job_name   and j.program_name IN     ('BUILD_PROGRAM', 'TEST_PROGRAM','SQL_APPLY_PROGRAM', 'XFORM_PROGRAM', 'PREDICT_PROGRAM', 'EXPLAIN_PROGRAM')   and j.job_name NOT IN (SELECT TASK_NAME FROM DM4J$RESULTS) order by program_name, job_name ) WHERE argument_name in ('MODEL_NAME','TEST_METRICS_NAME','RESULT_TABLE_NAME','DATA_TABLE_NAME','INPUT_TABLE_NAME','OUTPUT_TABLE_NAME','XFORM_TYPE')";
            preparedStatement = connection.prepareStatement(string);
            resultSet = preparedStatement.executeQuery();
            String string2 = "";
            while (resultSet.next()) {
                String string3 = resultSet.getString("job_name");
                if (string3.compareToIgnoreCase(string2) == 0) {
                    boolean bl = false;
                    while (resultSet.next()) {
                        string3 = resultSet.getString("job_name");
                        if (string3.compareToIgnoreCase(string2) == 0) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) break;
                }
                String string4 = resultSet.getString("program_name");
                if (string3.compareToIgnoreCase(string2) != 0) {
                    String string5;
                    String string6;
                    String string7;
                    String string8;
                    String string9;
                    if (string4.compareToIgnoreCase("BUILD_PROGRAM") == 0) {
                        string9 = null;
                        do {
                            string8 = resultSet.getString("argument_name");
                            string7 = resultSet.getString("value");
                            if (string8.compareToIgnoreCase("MODEL_NAME") != 0) continue;
                            string9 = string7 == null ? UNKNOWN_VALUE : string7;
                            break;
                        } while (resultSet.next());
                        try {
                            this.insertBuildRec(connection, string3, string9, UNKNOWN_VALUE);
                        }
                        catch (Exception exception) {}
                    } else if (string4.compareToIgnoreCase("TEST_PROGRAM") == 0) {
                        string9 = null;
                        string8 = null;
                        string7 = null;
                        do {
                            string6 = resultSet.getString("argument_name");
                            string5 = resultSet.getString("value");
                            if (string6.compareToIgnoreCase("TEST_METRICS_NAME") == 0) {
                                String string10 = string8 = string5 == null ? UNKNOWN_VALUE : string5;
                            }
                            if (string6.compareToIgnoreCase("MODEL_NAME") == 0) {
                                String string11 = string9 = string5 == null ? UNKNOWN_VALUE : string5;
                            }
                            if (string6.compareToIgnoreCase("DATA_TABLE_NAME") != 0) continue;
                            String string12 = string7 = string5 == null ? UNKNOWN_VALUE : string5;
                        } while ((string8 == null || string9 == null || string7 == null) && resultSet.next());
                        if (string9.equals(UNKNOWN_VALUE)) {
                            string9 = string7;
                        }
                        try {
                            this.insertTestRec(connection, string8, string3, string9, UNKNOWN_VALUE);
                        }
                        catch (Exception exception) {}
                    } else if (string4.compareToIgnoreCase("SQL_APPLY_PROGRAM") == 0) {
                        string9 = null;
                        string8 = null;
                        do {
                            string7 = resultSet.getString("argument_name");
                            string6 = resultSet.getString("value");
                            if (string7.compareToIgnoreCase("RESULT_TABLE_NAME") == 0) {
                                String string13 = string8 = string6 == null ? UNKNOWN_VALUE : string6;
                            }
                            if (string7.compareToIgnoreCase("MODEL_NAME") != 0) continue;
                            String string14 = string9 = string6 == null ? UNKNOWN_VALUE : string6;
                        } while ((string8 == null || string9 == null) && resultSet.next());
                        try {
                            this.insertApplyRec(connection, string8, string3, string9, UNKNOWN_VALUE);
                        }
                        catch (Exception exception) {}
                    } else if (string4.compareToIgnoreCase("XFORM_PROGRAM") == 0) {
                        string9 = null;
                        string8 = null;
                        string7 = null;
                        do {
                            string6 = resultSet.getString("argument_name");
                            string5 = resultSet.getString("value");
                            if (string6.compareToIgnoreCase("INPUT_TABLE_NAME") == 0) {
                                String string15 = string9 = string5 == null ? UNKNOWN_VALUE : string5;
                            }
                            if (string6.compareToIgnoreCase("OUTPUT_TABLE_NAME") == 0) {
                                String string16 = string8 = string5 == null ? UNKNOWN_VALUE : string5;
                            }
                            if (string6.compareToIgnoreCase("XFORM_TYPE") != 0) continue;
                            String string17 = string7 = string5 == null ? UNKNOWN_VALUE : string5;
                        } while ((string9 == null || string8 == null || string7 == null) && resultSet.next());
                        if (string7.compareToIgnoreCase("TEXT") == 0) {
                            try {
                                this.insertXformRec(connection, string8, string3, string9, UNKNOWN_VALUE);
                            }
                            catch (Exception exception) {}
                        }
                    } else if (string4.compareToIgnoreCase("PREDICT_PROGRAM") == 0) {
                        string9 = null;
                        string8 = null;
                        do {
                            string7 = resultSet.getString("argument_name");
                            string6 = resultSet.getString("value");
                            if (string7.compareToIgnoreCase("RESULT_TABLE_NAME") == 0) {
                                String string18 = string9 = string6 == null ? UNKNOWN_VALUE : string6;
                            }
                            if (string7.compareToIgnoreCase("DATA_TABLE_NAME") != 0) continue;
                            String string19 = string8 = string6 == null ? UNKNOWN_VALUE : string6;
                        } while ((string9 == null || string8 == null) && resultSet.next());
                        try {
                            this.insertPredictRec(connection, string9, string3, string8);
                        }
                        catch (Exception exception) {}
                    } else if (string4.compareToIgnoreCase("EXPLAIN_PROGRAM") == 0) {
                        string9 = null;
                        string8 = null;
                        do {
                            string7 = resultSet.getString("argument_name");
                            string6 = resultSet.getString("value");
                            if (string7.compareToIgnoreCase("RESULT_TABLE_NAME") == 0) {
                                String string20 = string9 = string6 == null ? UNKNOWN_VALUE : string6;
                            }
                            if (string7.compareToIgnoreCase("DATA_TABLE_NAME") != 0) continue;
                            String string21 = string8 = string6 == null ? UNKNOWN_VALUE : string6;
                        } while ((string9 == null || string8 == null) && resultSet.next());
                        try {
                            this.insertExplainRec(connection, string9, string3, string8);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                string2 = string3;
            }
            preparedStatement.close();
            preparedStatement = null;
            resultSet.close();
            resultSet = null;
            string = "DELETE FROM DM4J$RESULTS  WHERE TASK_NAME NOT IN (SELECT job_name FROM USER_SCHEDULER_JOBS)";
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.executeUpdate();
            DiscoODMrGateway.cleanMetaData(connection);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            if (null != resultSet) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (null != preparedStatement) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getResultNames(Connection connection, String string, String string2) {
        Statement statement = null;
        ResultSet resultSet = null;
        String[] stringArray = null;
        String string3 = string2 == null ? "%" : string2.toUpperCase();
        try {
            boolean bl = true;
            Vector<String> vector = new Vector<String>();
            String string4 = string == ALL_TYPE ? "%" : string;
            statement = connection.prepareStatement("SELECT RESULT_NAME FROM DM4J$RESULTS_STATE_V WHERE TYPE LIKE ? AND MODEL_NAME LIKE ? AND STATE ='SUCCEEDED' ORDER BY RESULT_NAME");
            statement.setString(1, string4);
            statement.setString(2, string3);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String string5 = resultSet.getString(1);
                if (string5 == null) continue;
                vector.add(string5);
            }
            stringArray = new String[vector.size()];
            System.arraycopy(vector.toArray(), 0, stringArray, 0, vector.size());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            stringArray = null;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
        }
        return stringArray;
    }

    public String[] getModelNames(Connection connection, String[] stringArray, String[] stringArray2) {
        return this.getModelNames(connection, stringArray, stringArray2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getModelNames(Connection connection, String[] stringArray, String[] stringArray2, boolean bl) {
        Statement statement = null;
        ResultSet resultSet = null;
        String[] stringArray3 = null;
        try {
            CharSequence charSequence;
            CharSequence charSequence2;
            int n;
            boolean bl2 = false;
            StringBuffer stringBuffer = new StringBuffer();
            for (n = 0; n < stringArray.length; ++n) {
                charSequence2 = stringArray[n];
                if (charSequence2 == ANOMALY_DETECTION) {
                    charSequence2 = CLASSIFICATION;
                }
                if (charSequence2 == ALL_TYPE) {
                    bl2 = true;
                    break;
                }
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("'" + (String)charSequence2 + "'");
            }
            n = 0;
            charSequence2 = new StringBuffer();
            for (int i = 0; i < stringArray2.length; ++i) {
                charSequence = stringArray2[i];
                if (charSequence == ONE_CLASS_SVM_MODEL) {
                    charSequence = SUPPORT_VECTOR_MACHINES_MODEL;
                }
                if (charSequence == ALL_TYPE) {
                    n = 1;
                    break;
                }
                if (i > 0) {
                    ((StringBuffer)charSequence2).append(", ");
                }
                ((StringBuffer)charSequence2).append("'" + (String)charSequence + "'");
            }
            Vector<String> vector = new Vector<String>();
            charSequence = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            if (!bl2 || n == 0) {
                stringBuffer2.append("WHERE ");
            }
            int n2 = 0;
            if (!bl2) {
                stringBuffer2.append("DM_USER_MODELS.FUNCTION_NAME in (" + stringBuffer.toString() + ") ");
                ++n2;
            }
            if (n == 0) {
                if (n2 > 0) {
                    stringBuffer2.append("AND ");
                }
                stringBuffer2.append("DM_USER_MODELS.ALGORITHM_NAME in (" + ((StringBuffer)charSequence2).toString() + ") ");
                ++n2;
            }
            if (stringArray.length == 1 && stringArray[0] == CLASSIFICATION || stringArray2.length == 1 && (stringArray2[0] == ADAPTIVE_BAYES_NETWORK_MODEL || stringArray2[0] == NAIVE_BAYES_MODEL || stringArray2[0] == SUPPORT_VECTOR_MACHINES_MODEL || stringArray2[0] == GENERALIZED_LINEAR_MODEL || stringArray2[0] == DECISION_TREE_MODEL || stringArray2[0] == ATTRIBUTE_IMPORTANCE)) {
                if (n2 > 0) {
                    stringBuffer2.append("AND ");
                }
                stringBuffer2.append("DM_USER_MODELS.TARGET_ATTRIBUTE IS NOT NULL ");
                ++n2;
            }
            if (stringArray.length == 1 && stringArray[0] == ANOMALY_DETECTION || stringArray2.length == 1 && stringArray2[0] == ONE_CLASS_SVM_MODEL) {
                if (n2 > 0) {
                    stringBuffer2.append("AND ");
                }
                stringBuffer2.append("DM_USER_MODELS.TARGET_ATTRIBUTE IS NULL ");
                ++n2;
            }
            if (bl) {
                ((StringBuffer)charSequence).append("SELECT DISTINCT A.NAME FROM  ");
                ((StringBuffer)charSequence).append("(SELECT DISTINCT NAME FROM DM_USER_MODELS , DM4J$MODEL_RESULTS_V ");
                ((StringBuffer)charSequence).append(stringBuffer2.toString());
                ((StringBuffer)charSequence).append(" AND ");
                ((StringBuffer)charSequence).append("DM_USER_MODELS.NAME != DM4J$MODEL_RESULTS_V.MODEL_NAME(+) ");
                ((StringBuffer)charSequence).append(" UNION ");
                ((StringBuffer)charSequence).append("SELECT DISTINCT NAME FROM DM_USER_MODELS , DM4J$MODEL_RESULTS_V ");
                ((StringBuffer)charSequence).append(stringBuffer2.toString());
                ((StringBuffer)charSequence).append(" AND ");
                ((StringBuffer)charSequence).append("DM_USER_MODELS.NAME = DM4J$MODEL_RESULTS_V.MODEL_NAME(+) ");
                ((StringBuffer)charSequence).append("AND 'DM4J$UNKNOWN' = DM4J$MODEL_RESULTS_V.ACTIVITY_NAME(+)) A ");
                ((StringBuffer)charSequence).append(" ORDER BY A.NAME ASC");
            } else {
                ((StringBuffer)charSequence).append("SELECT DISTINCT NAME FROM DM_USER_MODELS ");
                ((StringBuffer)charSequence).append(stringBuffer2.toString());
                ((StringBuffer)charSequence).append(" ORDER BY DM_USER_MODELS.NAME ASC");
            }
            statement = connection.prepareStatement(((StringBuffer)charSequence).toString());
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                if (string == null) continue;
                vector.add(string);
            }
            stringArray3 = new String[vector.size()];
            System.arraycopy(vector.toArray(), 0, stringArray3, 0, vector.size());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            stringArray3 = null;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
        }
        return stringArray3;
    }

    public String[] getModelNames(Connection connection, String[] stringArray) {
        return this.getModelNames(connection, stringArray, new String[]{ALL_TYPE});
    }

    public String[] getModelNames(Connection connection, String string) {
        return this.getModelNames(connection, new String[]{string});
    }

    public String[] getModelNames(Connection connection, String string, String string2) {
        return this.getModelNames(connection, new String[]{string}, new String[]{string2});
    }

    public Vector getTasks(Connection connection) throws Exception {
        return this.getTasks(connection, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getTasks(Connection connection, Integer n) throws Exception {
        Statement statement = null;
        ResultSet resultSet = null;
        Vector vector = null;
        try {
            String string = null;
            string = n == null ? "select TASK_NAME, TYPE, STATE, CREATION_DATE from DM4J$RESULTS_STATE_V" : "select TASK_NAME, TYPE, STATE, CREATION_DATE from DM4J$RESULTS_STATE_V where (CREATION_DATE > (SYSDATE - INTERVAL '" + n + "' MINUTE))" + "OR " + STATE_COLUMN + "='RUNNING'";
            string = string + " ORDER BY CREATION_DATE DESC";
            statement = connection.prepareStatement(string);
            resultSet = statement.executeQuery();
            vector = new Vector();
            while (resultSet.next()) {
                String string2;
                int n2 = 1;
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                hashtable.put("TASK_NAME", (string2 = resultSet.getString(n2++)) == null ? "" : string2);
                String string3 = resultSet.getString(n2++);
                hashtable.put(TASK_TYPE, string3 == null ? "" : string3);
                String string4 = resultSet.getString(n2++);
                hashtable.put(TASK_STATE, string4 == null ? "" : string4);
                Timestamp timestamp = resultSet.getTimestamp(n2++);
                if (timestamp == null) {
                    timestamp = resultSet.getTimestamp(n2);
                }
                java.util.Date date = timestamp == null ? new java.util.Date(0L) : new java.util.Date(timestamp.getTime());
                hashtable.put(TASK_DATE, date);
                vector.add(hashtable);
            }
        }
        finally {
            try {
                if (null != statement) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (null != resultSet) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {}
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTaskNameForMiningObject(Connection connection, String string, String string2) throws Exception {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string3 = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT TASK_NAME FROM DM4J$RESULTS WHERE TYPE = ? AND RESULT_NAME = ? ORDER BY CREATION_DATE DESC");
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, DM4JStringUtils.isDoubleQuotedString(string2) ? DM4JStringUtils.trimDoubleQuotes(string2) : string2);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                string3 = resultSet.getString(1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {}
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getTaskNamesForMiningObject(Connection connection, String string, String string2) throws Exception {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string3 = null;
        Vector<String> vector = new Vector<String>();
        try {
            preparedStatement = connection.prepareStatement("SELECT TASK_NAME FROM DM4J$RESULTS WHERE TYPE = ? AND RESULT_NAME = ?");
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, DM4JStringUtils.isDoubleQuotedString(string2) ? DM4JStringUtils.trimDoubleQuotes(string2) : string2);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                string3 = resultSet.getString("TASK_NAME");
                vector.add(string3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int objectOwnedByActivityCount(Connection connection, String string, String string2, String string3) throws Exception {
        String string4 = "SELECT COUNT(DISTINCT ACTIVITY_NAME) FROM DM4J$RESULTS WHERE TYPE LIKE ? AND RESULT_NAME = ? AND ACTIVITY_NAME NOT IN (?, ?)";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        int n = 0;
        try {
            preparedStatement = connection.prepareStatement(string4);
            String string5 = string == ALL_TYPE ? "%" : string;
            preparedStatement.setString(1, string5);
            preparedStatement.setString(2, DM4JStringUtils.isDoubleQuotedString(string2) ? string2 : string2.toUpperCase());
            preparedStatement.setString(3, UNKNOWN_VALUE);
            if (string3 != null) {
                preparedStatement.setString(4, string3);
            } else {
                preparedStatement.setString(4, UNKNOWN_VALUE);
            }
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getActivityNamesForMiningObject(Connection connection, String string, String string2) throws Exception {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string3 = null;
        Vector<String> vector = new Vector<String>();
        try {
            preparedStatement = connection.prepareStatement("SELECT DISTINCT ACTIVITY_NAME FROM DM4J$RESULTS WHERE TYPE LIKE ? AND RESULT_NAME = ? AND ACTIVITY_NAME != ?");
            String string4 = string == ALL_TYPE ? "%" : string;
            preparedStatement.setString(1, string4);
            preparedStatement.setString(2, DM4JStringUtils.isDoubleQuotedString(string2) ? string2 : string2.toUpperCase());
            preparedStatement.setString(3, UNKNOWN_VALUE);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                string3 = resultSet.getString("ACTIVITY_NAME");
                vector.add(string3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBuildActivityNameForModel(Connection connection, String string) throws Exception {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string2 = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT DISTINCT ACTIVITY_NAME FROM DM4J$RESULTS WHERE TYPE LIKE ? AND MODEL_NAME = ? AND ACTIVITY_NAME != ?");
            preparedStatement.setString(1, BUILD_TYPE);
            preparedStatement.setString(2, DM4JStringUtils.isDoubleQuotedString(string) ? string : string.toUpperCase());
            preparedStatement.setString(3, UNKNOWN_VALUE);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                string2 = resultSet.getString("ACTIVITY_NAME");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getTestActivityNameForModel(Connection connection, String string) throws Exception {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string2 = null;
        Vector<String> vector = new Vector<String>();
        try {
            preparedStatement = connection.prepareStatement("SELECT DISTINCT ACTIVITY_NAME, CREATION_DATE FROM DM4J$RESULTS WHERE TYPE = 'TEST' AND MODEL_NAME = ? AND ACTIVITY_NAME != 'DM4J$UNKNOWN' AND ACTIVITY_NAME NOT IN   (SELECT DISTINCT ACTIVITY_NAME   FROM DM4J$RESULTS WHERE TYPE = 'BUILD' AND MODEL_NAME = ? AND ACTIVITY_NAME != 'DM4J$UNKNOWN') ORDER BY CREATION_DATE DESC");
            preparedStatement.setString(1, DM4JStringUtils.isDoubleQuotedString(string) ? DM4JStringUtils.trimDoubleQuotes(string) : string.toUpperCase());
            preparedStatement.setString(2, DM4JStringUtils.isDoubleQuotedString(string) ? DM4JStringUtils.trimDoubleQuotes(string) : string.toUpperCase());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                string2 = resultSet.getString("ACTIVITY_NAME");
                vector.add(string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTaskState(Connection connection, String string) throws Exception {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string2 = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT STATE FROM DM4J$RESULTS_STATE_V WHERE TASK_NAME = ?");
            preparedStatement.setString(1, DM4JStringUtils.isDoubleQuotedString(string) ? DM4JStringUtils.trimDoubleQuotes(string) : string);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                string2 = resultSet.getString(STATE_COLUMN);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {}
        }
        return string2;
    }

    public boolean isTaskRunning(Connection connection, String string) throws Exception {
        boolean bl = true;
        String string2 = this.getTaskState(connection, string);
        if (string2.equalsIgnoreCase("SUCCEEDED") || string2.equalsIgnoreCase("FAILED") || string2.equalsIgnoreCase("STOPPED") || string2.equalsIgnoreCase("DISABLED")) {
            bl = false;
        }
        return bl;
    }

    public boolean isTaskSuccessful(Connection connection, String string) throws Exception {
        boolean bl = false;
        String string2 = this.getTaskState(connection, string);
        if (string2.equalsIgnoreCase("SUCCEEDED")) {
            bl = true;
        }
        return bl;
    }

    public boolean isTaskFailed(Connection connection, String string) throws Exception {
        boolean bl = false;
        String string2 = this.getTaskState(connection, string);
        if (string2.equalsIgnoreCase("FAILED")) {
            bl = true;
        }
        return bl;
    }

    public boolean isTaskDisabled(Connection connection, String string) throws Exception {
        boolean bl = false;
        String string2 = this.getTaskState(connection, string);
        if (string2.equalsIgnoreCase("DISABLED")) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getAllModels(Connection connection) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Vector<String> vector = null;
        try {
            String string = "SELECT name FROM DM_USER_MODELS UNION ( SELECT UPPER(value) FROM ( SELECT j.job_name, j.program_name, j.end_date,a.argument_name, a.value FROM USER_SCHEDULER_JOB_ARGS a, USER_SCHEDULER_JOBS j WHERE j.job_name=a.job_name and j.state<>'ERROR' and j.program_name='BUILD_PROGRAM' ) WHERE argument_name='MODEL_NAME' )";
            preparedStatement = connection.prepareStatement(string);
            resultSet = preparedStatement.executeQuery();
            vector = new Vector<String>();
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                vector.add(string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            vector = null;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {}
        }
        return vector != null ? (vector.size() == 0 ? null : vector) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getAllModelsHash(Connection connection) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        HashMap<String, String> hashMap = null;
        try {
            String string = "SELECT name FROM DM_USER_MODELS UNION ( SELECT UPPER(value) FROM ( SELECT j.job_name, j.program_name, j.end_date,a.argument_name, a.value FROM USER_SCHEDULER_JOB_ARGS a, USER_SCHEDULER_JOBS j WHERE j.job_name=a.job_name and j.state<>'ERROR' and j.program_name='BUILD_PROGRAM' ) WHERE argument_name='MODEL_NAME' )";
            preparedStatement = connection.prepareStatement(string);
            resultSet = preparedStatement.executeQuery();
            hashMap = new HashMap<String, String>();
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                hashMap.put(string2, string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            hashMap = null;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {}
        }
        return hashMap != null ? (hashMap.size() == 0 ? null : hashMap) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getModelType(Connection connection, String string) throws Exception {
        String string2;
        block18: {
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            string2 = null;
            String string3 = null;
            if (null == string) {
                throw new Exception("Cannot determine model type, model name cannot be null.");
            }
            try {
                preparedStatement = connection.prepareStatement("SELECT FUNCTION_NAME, TARGET_ATTRIBUTE FROM DM_USER_MODELS WHERE NAME = ?");
                preparedStatement.setString(1, DM4JStringUtils.isDoubleQuotedString(string) ? string : string.toUpperCase());
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    string2 = resultSet.getString(FUNCTION_NAME_COLUMN);
                    if (null == string2) {
                        throw new Exception("Failed to determine model type.");
                    }
                    string3 = resultSet.getString(TARGET_ATTRIBUTE_COLUMN);
                    if (string2.compareToIgnoreCase(CLASSIFICATION) == 0 && string3 == null) {
                        string2 = ANOMALY_DETECTION;
                    }
                    break block18;
                }
                throw new Exception("Failed to determine model type because model does not exist.");
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (null == string2) {
            throw new Exception("Cannot determine model type");
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getModelAlgoType(Connection connection, String string) throws Exception {
        String string2;
        block18: {
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            string2 = null;
            String string3 = null;
            String string4 = null;
            if (null == string) {
                throw new Exception("Cannot determine model type, model name cannot be null.");
            }
            try {
                preparedStatement = connection.prepareStatement("SELECT ALGORITHM_NAME, FUNCTION_NAME, TARGET_ATTRIBUTE FROM DM_USER_MODELS WHERE NAME = ?");
                preparedStatement.setString(1, DM4JStringUtils.isDoubleQuotedString(string) ? string : string.toUpperCase());
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    string2 = resultSet.getString(ALGORITHM_NAME_COLUMN);
                    if (null == string2) {
                        throw new Exception("Failed to determine model type.");
                    }
                    string3 = resultSet.getString(FUNCTION_NAME_COLUMN);
                    string4 = resultSet.getString(TARGET_ATTRIBUTE_COLUMN);
                    if (string3.compareToIgnoreCase(CLASSIFICATION) == 0 && string4 == null) {
                        string2 = ONE_CLASS_SVM_MODEL;
                    }
                    break block18;
                }
                throw new Exception("Failed to determine model algorithm type because model does not exist.");
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (null == string2) {
            throw new Exception("Cannot determine model algorithm type");
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getModelNameForResult(Connection connection, String string, String string2) throws Exception {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string3 = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT MODEL_NAME FROM DM4J$RESULTS WHERE TYPE = ? AND RESULT_NAME = ?");
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, DM4JStringUtils.isDoubleQuotedString(string2) ? DM4JStringUtils.trimDoubleQuotes(string2) : string2.toUpperCase());
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                string3 = resultSet.getString("MODEL_NAME");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {}
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getModelNameForTask(Connection connection, String string, String string2) throws Exception {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string3 = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT MODEL_NAME FROM DM4J$RESULTS WHERE TYPE = ? AND TASK_NAME = ?");
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, DM4JStringUtils.isDoubleQuotedString(string2) ? DM4JStringUtils.trimDoubleQuotes(string2) : string2.toUpperCase());
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                string3 = resultSet.getString("MODEL_NAME");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {}
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doesModelExist(Connection connection, String string) throws Exception {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string2 = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT NAME FROM DM_USER_MODELS WHERE NAME = ?");
            preparedStatement.setString(1, DM4JStringUtils.isDoubleQuotedString(string) ? string : string.toUpperCase());
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                string2 = resultSet.getString(NAME_COLUMN);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {}
        }
        return string2 != null;
    }

    public synchronized void insertXformTableRec(Connection connection, String string, String string2, String string3, String string4) throws Exception {
        if (string4 == null) {
            return;
        }
        PreparedStatement preparedStatement = null;
        int n = 1;
        try {
            preparedStatement = connection.prepareStatement("INSERT INTO DM4J$TRANSFORMS(TASK_NAME,MODEL_NAME,TYPE,XFORM_TABLE) VALUES (?, ?, ?, ?)");
            if (string != null) {
                preparedStatement.setString(n++, DMEMetadata.fixObjectNameWhenSave(string));
            } else {
                preparedStatement.setNull(n++, 12);
            }
            preparedStatement.setString(n++, string2.toUpperCase());
            preparedStatement.setString(n++, string3);
            preparedStatement.setString(n, DMEMetadata.fixObjectNameWhenSave(string4));
            preparedStatement.executeUpdate();
            connection.commit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            if (null != preparedStatement) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public synchronized boolean isTransparencyTableInUse(Connection connection, String string, Vector vector) throws Exception {
        int n;
        if (vector == null || vector.isEmpty()) {
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer("SELECT count (*) from DM4J$TRANSFORMS WHERE XFORM_TABLE IN (");
        for (n = 0; n < vector.size(); ++n) {
            stringBuffer.append("'" + vector.elementAt(n) + "'");
            if (n >= vector.size() - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(") and MODEL != ?");
        n = 0;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(stringBuffer.toString());
            preparedStatement.setString(1, DM4JStringUtils.isDoubleQuotedString(string) ? string : string.toUpperCase());
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
        }
        catch (SQLException sQLException) {
            System.out.println(sQLException);
            throw sQLException;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        return n > 0;
    }

    public synchronized Hashtable getTransparencyTables(Connection connection, String string, String string2) throws Exception {
        if (string2 == null) {
            throw new Exception();
        }
        if (string == null) {
            string = this.getTaskNameForMiningObject(connection, BUILD_TYPE, string2);
        }
        Hashtable<String, String> hashtable = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        int n = 1;
        try {
            preparedStatement = connection.prepareStatement("SELECT XFORM_TABLE, TYPE FROM DM4J$TRANSFORMS WHERE TASK_NAME= ? AND MODEL_NAME= ?");
            preparedStatement.setString(n++, string);
            preparedStatement.setString(n, DM4JStringUtils.isDoubleQuotedString(string2) ? string2 : string2.toUpperCase());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                if (hashtable == null) {
                    hashtable = new Hashtable<String, String>();
                }
                String string3 = resultSet.getString(XFORM_TABLE);
                String string4 = resultSet.getString(TYPE_COLUMN);
                if (string3 == null || string4 == null) {
                    throw new Exception();
                }
                hashtable.put(string4, string3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            if (null != resultSet) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (null != preparedStatement) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
        return hashtable;
    }

    public synchronized Hashtable getRegressionNormTableDetails(Connection connection, String string, String string2) throws Exception {
        if (string == null) {
            throw new Exception();
        }
        if (string2 == null) {
            throw new Exception();
        }
        String string3 = "SELECT COL, SHIFT, SCALE FROM " + (DM4JStringUtils.isDoubleQuotedString(string) ? string : string.toUpperCase()) + " WHERE " + " COL = ?";
        Hashtable<String, Double> hashtable = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        int n = 1;
        try {
            preparedStatement = connection.prepareStatement(string3);
            preparedStatement.setString(n++, DM4JStringUtils.isDoubleQuotedString(string2) ? string2 : string2);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                if (hashtable == null) {
                    hashtable = new Hashtable<String, Double>();
                }
                double d = resultSet.getDouble(XNORM_SHIFT);
                double d2 = resultSet.getDouble(XNORM_SCALE);
                hashtable.put(XNORM_SHIFT, new Double(d));
                hashtable.put(XNORM_SCALE, new Double(d2));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            if (null != resultSet) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (null != preparedStatement) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
        return hashtable;
    }

    public synchronized Double getPredictiveConfidence(Connection connection, String string) throws Exception {
        if (string == null) {
            throw new Exception();
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Double d = null;
        int n = 1;
        try {
            preparedStatement = connection.prepareStatement("with a as (select TASK_NAME, MODEL_NAME from DM4J$RESULTS where RESULT_NAME = ?) select XFORM_TABLE from DM4J$TRANSFORMS t, a where t.TYPE = ? and t.TASK_NAME = a.TASK_NAME and t.MODEL_NAME = a.MODEL_NAME");
            preparedStatement.setString(n++, string);
            preparedStatement.setString(n++, XPCV);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String string2 = resultSet.getString(1);
                d = Double.valueOf(string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            if (null != resultSet) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (null != preparedStatement) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTableEmpty(Connection connection, String string) {
        String string2 = "SELECT COUNT (*) FROM " + string;
        Statement statement = null;
        ResultSet resultSet = null;
        int n = 0;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2);
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
        return n <= 0;
    }

    public static String mapAlgTypeToLeafNodeType(String string, String string2) {
        String string3 = null;
        if (string.equals(ADAPTIVE_BAYES_NETWORK_MODEL)) {
            string3 = "ABN_MODEL";
        } else if (string.equals(NAIVE_BAYES_MODEL)) {
            string3 = "NB_MODEL";
        } else if (string.equals(SUPPORT_VECTOR_MACHINES_MODEL)) {
            string3 = string2.equals(CLASSIFICATION) ? "SVM_CLASSIFICATION_MODEL" : "SVM_REGRESSION_MODEL";
        } else if (string.equals(ONE_CLASS_SVM_MODEL)) {
            string3 = "SVM_ONE_CLASS_MODEL";
        } else if (string.equals(DECISION_TREE_MODEL)) {
            string3 = "DT_MODEL";
        } else if (string.equals(KMEANS_MODEL)) {
            string3 = "CLUSTERING_KMEANS_MODEL";
        } else if (string.equals(O_CLUSTER_MODEL)) {
            string3 = "CLUSTERING_OCLUSTER_MODEL";
        } else if (string.equals(APRIORI_ASSOCIATION_RULES_MODEL)) {
            string3 = "ASSOCIATION_RULES_MODEL";
        } else if (string.equals(MINIMUM_DESCRIPTION_LENGTH_MODEL)) {
            string3 = "ATTRIBUTE_IMPORTANCE_MODEL";
        } else if (string.equals(NONNEGATIVE_MATRIX_FACTOR_MODEL)) {
            string3 = "NMF_MODEL";
        }
        return string3;
    }

    public static Vector getActivityList(Connection connection, String[] stringArray) throws Exception {
        Statement statement = null;
        ResultSet resultSet = null;
        Vector<Object[]> vector = new Vector<Object[]>(300);
        try {
            String string = new String();
            if (null != stringArray) {
                for (int i = 0; i < stringArray.length; ++i) {
                    string = i == stringArray.length - 1 ? string + "'" + stringArray[i] + "'" + ")" : string + "'" + stringArray[i] + "'" + ", ";
                }
            }
            String string2 = "SELECT \"NAME\" ,\"TYPE\" ,\"COMMENTS\" ,\"CREATION_DATE\"  FROM \"DM4J$ACTIVITIES\"  WHERE TYPE IN( " + string + " ORDER BY \"" + NAME_COLUMN + "\"";
            Object[] objectArray = null;
            statement = connection.prepareStatement(string2);
            resultSet = statement.executeQuery();
            String string3 = null;
            ActivityType activityType = null;
            String string4 = null;
            LeafNodeData leafNodeData = null;
            String string5 = null;
            while (resultSet.next()) {
                objectArray = new Object[6];
                string3 = resultSet.getString(TYPE_COLUMN);
                objectArray[5] = resultSet.getString("COMMENTS");
                objectArray[4] = resultSet.getDate(CREATION_DATE_COLUMN);
                string5 = resultSet.getString(NAME_COLUMN);
                activityType = ActivityType.getInstance(string3);
                string4 = ActivityType.getNodeType(activityType);
                leafNodeData = new LeafNodeData(string5, string4);
                JLabelNode jLabelNode = new JLabelNode(leafNodeData);
                objectArray[0] = jLabelNode;
                objectArray[1] = ActivityType.getActivityGroupType(activityType);
                objectArray[2] = ActivityType.getFunctionName(activityType);
                objectArray[3] = ActivityType.getAlgorithmName(activityType);
                vector.add(objectArray);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return vector;
    }

    public static Vector getModelList(Connection connection, String string) throws Exception {
        Statement statement = null;
        ResultSet resultSet = null;
        Vector<Object[]> vector = new Vector<Object[]>(300);
        try {
            String string2 = string;
            String string3 = "";
            if (string == ANOMALY_DETECTION) {
                string3 = "AND A.TARGET_ATTRIBUTE IS NULL ";
                string = CLASSIFICATION;
            }
            String string4 = "SELECT  A.NAME ,'Mining Model' as TYPE ,B.ACTIVITY_NAME ,A.FUNCTION_NAME ,A.ALGORITHM_NAME ,A.CREATION_DATE ,A.MODEL_SIZE ,A.BUILD_DURATION ,B.TASK_NAME  FROM DM_USER_MODELS A, DM4J$MODEL_RESULTS_V B  WHERE A.FUNCTION_NAME = '" + string + "' " + "AND A." + NAME_COLUMN + " = B." + "MODEL_NAME" + "(+) " + "AND   'BUILD' =  B." + TYPE_COLUMN + "(+) " + string3 + " ORDER BY A." + NAME_COLUMN;
            Object[] objectArray = null;
            statement = connection.prepareStatement(string4);
            resultSet = statement.executeQuery();
            LeafNodeData leafNodeData = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            String string8 = null;
            String string9 = null;
            while (resultSet.next()) {
                objectArray = new Object[9];
                string5 = resultSet.getString(NAME_COLUMN);
                objectArray[1] = resultSet.getString(TYPE_COLUMN);
                string9 = resultSet.getString("ACTIVITY_NAME");
                if (string9 != null) {
                    objectArray[2] = string9.equals(UNKNOWN_VALUE) ? null : string9;
                }
                string7 = string2;
                objectArray[3] = string7;
                string6 = resultSet.getString(ALGORITHM_NAME_COLUMN);
                objectArray[4] = string6;
                objectArray[5] = resultSet.getDate(CREATION_DATE_COLUMN);
                objectArray[6] = new Double(resultSet.getDouble(MODEL_SIZE_COLUMN));
                objectArray[7] = new Double(resultSet.getDouble(BUILD_DURATION_COLUMN));
                objectArray[8] = resultSet.getString("TASK_NAME");
                string8 = DMEMetadata.getModelNodeType(string7, string6);
                leafNodeData = new LeafNodeData(string5, string8);
                JLabelNode jLabelNode = new JLabelNode(leafNodeData);
                objectArray[0] = jLabelNode;
                vector.add(objectArray);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return vector;
    }

    public static Vector getResultList(Connection connection, String string, String string2) throws Exception {
        Statement statement = null;
        ResultSet resultSet = null;
        Vector<Object[]> vector = new Vector<Object[]>(300);
        String string3 = string2 == null ? "%" : string2.toUpperCase();
        try {
            String string4 = string == ALL_TYPE ? "%" : string;
            String string5 = "SELECT  RESULT_NAME ,TYPE ,ACTIVITY_NAME ,MODEL_NAME ,CREATION_DATE ,TASK_NAME  FROM DM4J$RESULTS_STATE_V   WHERE TYPE LIKE ? AND MODEL_NAME LIKE ? AND STATE ='SUCCEEDED'  ORDER BY RESULT_NAME";
            Object[] objectArray = null;
            statement = connection.prepareStatement(string5);
            statement.setString(1, string4);
            statement.setString(2, string3);
            resultSet = statement.executeQuery();
            LeafNodeData leafNodeData = null;
            String string6 = null;
            String string7 = null;
            String string8 = null;
            String string9 = null;
            while (resultSet.next()) {
                objectArray = new Object[6];
                string6 = resultSet.getString(RESULT_COLUMN);
                string9 = resultSet.getString(TYPE_COLUMN);
                objectArray[1] = string9;
                string8 = resultSet.getString("ACTIVITY_NAME");
                if (string8 != null) {
                    objectArray[2] = string8.equals(UNKNOWN_VALUE) ? null : string8;
                }
                objectArray[3] = resultSet.getString("MODEL_NAME");
                objectArray[4] = resultSet.getDate(CREATION_DATE_COLUMN);
                objectArray[5] = resultSet.getString("TASK_NAME");
                string7 = DMEMetadata.getResultNodeType(string9);
                leafNodeData = new LeafNodeData(string6, string7);
                JLabelNode jLabelNode = new JLabelNode(leafNodeData);
                objectArray[0] = jLabelNode;
                vector.add(objectArray);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return vector;
    }

    public static String getResultNodeType(String string) {
        String string2 = null;
        if (string.equals(TEST_TYPE)) {
            string2 = "TEST_METRIC_RESULT";
        } else if (string.equals(APPLY_TYPE)) {
            string2 = "APPLY_RESULT";
        } else if (string.equals(RESIDUAL_PLOT_TYPE)) {
            string2 = "RESIDUAL_PLOT_RESULT";
        } else if (string.equals(PREDICT_TYPE)) {
            string2 = "PREDICT_RESULT";
        } else if (string.equals(EXPLAIN_TYPE)) {
            string2 = "EXPLAIN_RESULT";
        } else if (string.equals(BUILD_TYPE)) {
            string2 = "BUILD_RESULT";
        } else if (string.equals(XFORM_TEXT_TYPE)) {
            string2 = "TEXT_RESULT";
        }
        return string2;
    }

    public static String getModelNodeType(String string, String string2) {
        String string3 = null;
        if (string.equals(CLASSIFICATION)) {
            if (string2.equals(DECISION_TREE_MODEL)) {
                string3 = "DT_MODEL";
            } else if (string2.equals(ADAPTIVE_BAYES_NETWORK_MODEL)) {
                string3 = "ABN_MODEL";
            } else if (string2.equals(NAIVE_BAYES_MODEL)) {
                string3 = "NB_MODEL";
            } else if (string2.equals(SUPPORT_VECTOR_MACHINES_MODEL)) {
                string3 = "SVM_CLASSIFICATION_MODEL";
            } else if (string2.equals(GENERALIZED_LINEAR_MODEL)) {
                string3 = "GLM_CLASSIFICATION_MODEL";
            }
        } else if (string.equals(ASSOCIATION_RULES)) {
            string3 = "ASSOCIATION_RULES_MODEL";
        } else if (string.equals(ATTRIBUTE_IMPORTANCE)) {
            string3 = "ATTRIBUTE_IMPORTANCE_MODEL";
        } else if (string.equals(CLUSTERING)) {
            if (string2.equals(O_CLUSTER_MODEL)) {
                string3 = "CLUSTERING_OCLUSTER_MODEL";
            } else if (string2.equals(KMEANS_MODEL)) {
                string3 = "CLUSTERING_KMEANS_MODEL";
            }
        } else if (string.equals(ANOMALY_DETECTION)) {
            string3 = "SVM_ONE_CLASS_MODEL";
        } else if (string.equals(REGRESSION)) {
            if (string2.equals(SUPPORT_VECTOR_MACHINES_MODEL)) {
                string3 = "SVM_REGRESSION_MODEL";
            } else if (string2.equals(GENERALIZED_LINEAR_MODEL)) {
                string3 = "GLM_REGRESSION_MODEL";
            }
        } else if (string.equals(FEATURE_EXTRACTION)) {
            string3 = "NMF_MODEL";
        }
        return string3;
    }

    public synchronized void getTransparencyTables(Connection connection, String string, String string2, Hashtable hashtable) throws Exception {
        if (string2 == null || hashtable == null) {
            throw new Exception();
        }
        if (string == null) {
            string = this.getTaskNameForMiningObject(connection, BUILD_TYPE, string2);
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        int n = 1;
        try {
            preparedStatement = connection.prepareStatement("SELECT XFORM_TABLE, TYPE FROM DM4J$TRANSFORMS WHERE TASK_NAME= ? AND MODEL_NAME= ?");
            preparedStatement.setString(n++, string);
            preparedStatement.setString(n, DM4JStringUtils.isDoubleQuotedString(string2) ? string2 : string2.toUpperCase());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string3 = resultSet.getString(XFORM_TABLE);
                String string4 = resultSet.getString(TYPE_COLUMN);
                if (string3 == null || string4 == null) {
                    throw new Exception();
                }
                hashtable.put(string4, string3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            if (null != resultSet) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (null != preparedStatement) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static Vector getCodeGenActivityList(Connection connection, Hashtable hashtable) throws Exception {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Vector vector = new Vector();
        try {
            preparedStatement = connection.prepareStatement(ACTIVITIES_LIST);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                String string = resultSet.getString("ACTIVITY_NAME");
                boolean bl = null != hashtable && null != hashtable.get(string);
                String string2 = resultSet.getString("MODEL_NAME");
                if (string2 == null) {
                    string2 = "";
                }
                String string3 = resultSet.getString(CG_ACTIVITY_TYPE);
                ActivityType activityType = ActivityType.getInstance(string3);
                String string4 = ActivityType.getCodeGenFunctionName(activityType);
                String string5 = ActivityType.getCodeGenAlgorithmName(activityType);
                Date date = resultSet.getDate(CG_ACTIVITY_CREATION_DATE);
                String string6 = resultSet.getString(CG_ACTIVITY_COMMENTS);
                arrayList.add(CG_ACTIVITY_SELECTED_COLUMN, new Boolean(bl));
                arrayList.add(CG_ACTIVITY_NAME_COLUMN, string);
                arrayList.add(CG_ACTIVITY_TYPE_COLUMN, string3);
                arrayList.add(CG_ACTIVITY_FUNCTION_NAME_COLUMN, string4);
                arrayList.add(CG_ACTIVITY_ALG_NAME_COLUMN, string5);
                arrayList.add(CG_ACTIVITY_MODEL_COLUMN, string2);
                arrayList.add(CG_ACTIVITY_CREATION_DATE_COLUMN, date);
                arrayList.add(CG_ACTIVITY_COMMENT_COLUMN, resultSet.wasNull() ? "" : string6);
                if (bl) {
                    vector.insertElementAt(arrayList, 0);
                    continue;
                }
                vector.add(arrayList);
            }
        }
        catch (Exception exception) {
            vector.clear();
            throw exception;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {}
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isActivtyTableAvailable(Connection connection) {
        Statement statement = null;
        ResultSet resultSet = null;
        int n = 0;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(ACTIVITIES_TABLE_CHECK);
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
        }
        return n > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable getAllPackages(Connection connection) {
        Statement statement = null;
        ResultSet resultSet = null;
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(ALL_PACKAGES);
            while (resultSet.next()) {
                hashtable.put(resultSet.getString(1), new String[2]);
            }
        }
        catch (Exception exception) {
            hashtable.clear();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doesObjectExist(Connection connection, String string) throws Exception {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        int n = 0;
        try {
            preparedStatement = connection.prepareStatement("SELECT count(*) FROM all_objects WHERE object_name = ?");
            preparedStatement.setString(1, DM4JStringUtils.isDoubleQuotedString(string) ? string : string.toUpperCase());
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            n = 0;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {}
        }
        return n > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doObjectExist(Connection connection, Vector vector) throws Exception {
        StringBuffer stringBuffer = new StringBuffer("SELECT count(*) FROM all_objects WHERE ");
        String string = " object_name = ? ";
        String string2 = " OR ";
        for (int i = 0; i < vector.size(); ++i) {
            stringBuffer.append(string);
            if (i >= vector.size() - 1) continue;
            stringBuffer.append(string2);
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        int n = 0;
        try {
            preparedStatement = connection.prepareStatement(stringBuffer.toString());
            for (int i = 0; i < vector.size(); ++i) {
                String string3 = (String)vector.elementAt(i);
                preparedStatement.setString(i + 1, DM4JStringUtils.isDoubleQuotedString(string3) ? string3 : string3.toUpperCase());
            }
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            n = 0;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return n > 0;
    }

    public static boolean validateRequiredUserGrants(Connection connection) {
        boolean bl = false;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            int n;
            preparedStatement = connection.prepareStatement("select \n  COUNT(DISTINCT(CASE WHEN \"PRIVILEGE\" =  'CREATE ANY JOB' THEN 'CREATE JOB'\n        WHEN \"PRIVILEGE\" =  'CREATE JOB' THEN 'CREATE JOB'\n        WHEN \"PRIVILEGE\" =  'CREATE ANY TYPE' THEN 'CREATE TYPE'        \n        WHEN \"PRIVILEGE\" =  'CREATE TYPE' THEN 'CREATE TYPE'        \n        WHEN \"PRIVILEGE\" =  'CREATE ANY SESSION' THEN 'CREATE SESSION'        \n        WHEN \"PRIVILEGE\" =  'CREATE SESSION' THEN 'CREATE SESSION'                \n        WHEN \"PRIVILEGE\" =  'CREATE ANY TABLE' THEN 'CREATE TABLE'        \n        WHEN \"PRIVILEGE\" =  'CREATE TABLE' THEN 'CREATE TABLE'             \n        WHEN \"PRIVILEGE\" =  'CREATE ANY SEQUENCE' THEN 'CREATE SEQUENCE'        \n        WHEN \"PRIVILEGE\" =  'CREATE SEQUENCE' THEN 'CREATE SEQUENCE'             \n        WHEN \"PRIVILEGE\" =  'CREATE ANY VIEW' THEN 'CREATE VIEW'        \n        WHEN \"PRIVILEGE\" =  'CREATE VIEW' THEN 'CREATE VIEW'             \n        WHEN \"PRIVILEGE\" =  'CREATE ANY SYNONYM' THEN 'CREATE SYNONYM'        \n        WHEN \"PRIVILEGE\" =  'CREATE SYNONYM' THEN 'CREATE SYNONYM'             \n        WHEN \"PRIVILEGE\" =  'CREATE ANY PROCEDURE' THEN 'CREATE PROCEDURE'        \n        WHEN \"PRIVILEGE\" =  'CREATE PROCEDURE' THEN 'CREATE PROCEDURE'        \n        ELSE NULL END)) \"PRIVILEGE\"\nfrom \n(select privilege from USER_SYS_PRIVS\nwhere privilege in ('CREATE JOB', 'CREATE TYPE', 'CREATE SESSION', 'CREATE TABLE', 'CREATE SEQUENCE',  \n                        'CREATE VIEW', 'CREATE SYNONYM', 'CREATE PROCEDURE',\n                    'CREATE ANY JOB', 'CREATE ANY TYPE', 'CREATE ANY SESSION', 'CREATE ANY TABLE', 'CREATE ANY SEQUENCE',  \n                        'CREATE ANY VIEW', 'CREATE ANY SYNONYM', 'CREATE ANY PROCEDURE', 'EXECUTE ANY PROCEDURE')  \nUNION\nselect privilege from ROLE_SYS_PRIVS\nwhere privilege in ('CREATE JOB', 'CREATE TYPE', 'CREATE SESSION', 'CREATE TABLE', 'CREATE SEQUENCE',  \n                        'CREATE VIEW', 'CREATE SYNONYM', 'CREATE PROCEDURE',\n                    'CREATE ANY JOB', 'CREATE ANY TYPE', 'CREATE ANY SESSION', 'CREATE ANY TABLE', 'CREATE ANY SEQUENCE',  \n                        'CREATE ANY VIEW', 'CREATE ANY SYNONYM', 'CREATE ANY PROCEDURE', 'EXECUTE ANY PROCEDURE')      \n      AND role in (select GRANTED_ROLE from USER_ROLE_PRIVS \n                  union\n                  select granted_role from ROLE_ROLE_PRIVS\n                  where role in (select GRANTED_ROLE from USER_ROLE_PRIVS))\n) T");
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next() && (n = resultSet.getInt(1)) == 8) {
                bl = true;
            }
            resultSet.close();
            resultSet = null;
            preparedStatement.close();
            preparedStatement = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    public static boolean validateCreateModelGrants(Connection connection) {
        boolean bl = false;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            int n;
            preparedStatement = connection.prepareStatement("select \n  COUNT(DISTINCT(CASE         WHEN \"PRIVILEGE\" =  'CREATE MINING MODEL' THEN 'CREATE MINING MODEL'        \n        ELSE NULL END)) \"PRIVILEGE\"\nfrom \n(select privilege from USER_SYS_PRIVS\nwhere privilege in ('CREATE MINING MODEL')  \nUNION\nselect privilege from ROLE_SYS_PRIVS\nwhere privilege in ('CREATE MINING MODEL')      \n      AND role in (select GRANTED_ROLE from USER_ROLE_PRIVS \n                  union\n                  select granted_role from ROLE_ROLE_PRIVS\n                  where role in (select GRANTED_ROLE from USER_ROLE_PRIVS))\n) T");
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next() && (n = resultSet.getInt(1)) == 1) {
                bl = true;
            }
            resultSet.close();
            resultSet = null;
            preparedStatement.close();
            preparedStatement = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    public static boolean validateContextUserGrants(Connection connection) {
        boolean bl = false;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            int n;
            preparedStatement = connection.prepareStatement("select \n  COUNT(DISTINCT(CASE         WHEN \"PRIVILEGE\" =  'CTX_DLL' THEN 'CTX_DLL'        \n        WHEN \"PRIVILEGE\" =  'EXECUTE ANY PROCEDURE' THEN 'CTX_DLL'        \n        ELSE NULL END)) \"PRIVILEGE\"\nfrom \n( \nselect 'CTX_DLL' as privilege from user_tab_privs\nwhere owner = 'CTXSYS' AND table_name = 'CTX_DDL'\nUNION\nselect 'CTX_DLL' as privilege from role_tab_privs\nwhere owner = 'CTXSYS' AND table_name = 'CTX_DDL'\n) T");
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next() && (n = resultSet.getInt(1)) == 1) {
                bl = true;
            }
            resultSet.close();
            resultSet = null;
            preparedStatement.close();
            preparedStatement = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    public synchronized Hashtable getSVModelShiftScale(Connection connection, String string) throws Exception {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string2 = null;
        double d = 0.0;
        double d2 = 1.0;
        Hashtable<String, Double> hashtable = new Hashtable<String, Double>();
        try {
            String string3 = "select XFORM_TABLE from DM4J$TRANSFORMS where TYPE = 'XNORM' and MODEL_NAME = ?";
            String string4 = "select SHIFT, SCALE from <xform_table> x, DM_USER_MODELS m where m.name = ? and x.col = m.target_attribute";
            preparedStatement = connection.prepareStatement(string3);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                string2 = resultSet.getString(XFORM_TABLE);
            }
            resultSet.close();
            preparedStatement.close();
            if (string2 == null || 0 == string2.length()) {
                hashtable.put(XNORM_SHIFT, new Double(d));
                hashtable.put(XNORM_SCALE, new Double(d2));
                Hashtable<String, Double> hashtable2 = hashtable;
                return hashtable2;
            }
            String string5 = BrowserUtils.getReplacedString(string4, "<xform_table>", string2);
            preparedStatement = connection.prepareStatement(string5);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                d = resultSet.getDouble(XNORM_SHIFT);
                d2 = resultSet.getDouble(XNORM_SCALE);
            }
            hashtable.put(XNORM_SHIFT, new Double(d));
            hashtable.put(XNORM_SCALE, new Double(d2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return hashtable;
    }
}

