/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.sql.Connection;
import java.util.Map;
import java.util.Vector;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.NumericOneDModel;
import oracle.bali.ewt.model.SortableTwoDModel;
import oracle.dmt.dm4j.wizard.state.commonsteps.DataState;
import oracle.dmt.jdm.resource.OraConnection;

public abstract class DM4JDataSource
extends SortableTwoDModel
implements Runnable {
    protected DataState m_dataState = null;
    protected javax.datamining.resource.Connection m_jdmConn;
    protected Connection m_conn;
    protected String m_schema;
    protected String m_table;
    protected ArrayOneDModel m_columnModel;
    protected boolean m_loadFromDMS = false;
    protected NumericOneDModel m_rowModel = null;
    protected String m_odmObjectName = "";
    private Exception m_exception = null;

    public DM4JDataSource() throws Exception {
        super(0, 0);
        this.m_columnModel = this.createColumns();
        this.createData();
        this.createRowHeader();
    }

    public DM4JDataSource(javax.datamining.resource.Connection connection, String string, String string2) {
        super(0, 0);
        this.m_jdmConn = connection;
        this.m_schema = string;
        this.m_table = string2;
        this.m_loadFromDMS = true;
    }

    public DM4JDataSource(Connection connection, String string, String string2) {
        super(0, 0);
        this.m_conn = connection;
        this.m_schema = string;
        this.m_table = string2;
        this.m_loadFromDMS = true;
    }

    public DM4JDataSource(Connection connection, DataState dataState, String string, String string2) {
        super(0, 0);
        this.m_dataState = dataState;
        this.m_conn = connection;
        this.m_schema = string;
        this.m_table = string2;
        this.m_loadFromDMS = true;
    }

    public DM4JDataSource(Map map) {
        super(0, 0);
        this.m_loadFromDMS = false;
    }

    public DM4JDataSource(javax.datamining.resource.Connection connection, String string) {
        super(0, 0);
        this.m_jdmConn = connection;
        this.m_loadFromDMS = true;
        this.m_odmObjectName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            if (this.m_loadFromDMS && this.m_jdmConn != null) {
                OraConnection oraConnection = (OraConnection)this.m_jdmConn;
                this.m_conn = oraConnection.getDatabaseConnection();
            }
            this.m_columnModel = this.createColumns();
            this.createData();
            this.createRowHeader();
        }
        catch (Exception exception) {
            this.setException(exception);
            exception.printStackTrace();
        }
        finally {
            try {
                if (this.m_loadFromDMS) {
                    if (this.m_jdmConn != null) {
                        this.m_jdmConn.close();
                        this.m_jdmConn = null;
                    } else {
                        this.m_conn.close();
                    }
                    this.m_conn = null;
                }
            }
            catch (Exception exception) {
                this.setException(exception);
                exception.printStackTrace();
            }
        }
    }

    protected abstract void createData() throws Exception;

    protected abstract ArrayOneDModel createColumns() throws Exception;

    public Vector getAttributes(int n) {
        Vector<Object> vector = new Vector<Object>(this.getRowCount());
        for (int i = 0; i < this.getRowCount(); ++i) {
            vector.add(this.getData(n, i));
        }
        return vector;
    }

    public int getFirstRowByColumnValue(int n, String string) {
        int n2 = -1;
        for (int i = 0; i < this.getRowCount(); ++i) {
            String string2 = (String)this.getData(n, i);
            if (!string.equals(string2)) continue;
            n2 = i;
            i = this.getRowCount();
        }
        return n2;
    }

    public ArrayOneDModel getColumnDataSource() {
        return this.m_columnModel;
    }

    public NumericOneDModel getRowDataSource() {
        if (this.m_rowModel.getItemCount() < this.getRowCount()) {
            this.m_rowModel = new NumericOneDModel(this.getRowCount());
        }
        return this.m_rowModel;
    }

    protected void createRowHeader() {
        this.m_rowModel = new NumericOneDModel(this.getRowCount());
    }

    protected void setException(Exception exception) {
        this.m_exception = exception;
    }

    public Exception getException() {
        return this.m_exception;
    }
}

