/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.sql.Connection;
import java.sql.Statement;
import java.util.Vector;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.NumericOneDModel;
import oracle.bali.ewt.model.SortableTwoDModel;
import oracle.dmt.dm4j.browser.ProgressBar;

public abstract class DBDataSource
extends SortableTwoDModel
implements Runnable,
Cancelable {
    protected Connection m_conn;
    protected Statement m_statement;
    protected ArrayOneDModel m_columnModel;
    protected NumericOneDModel m_rowModel = null;
    private ProgressBar m_progressBar = null;
    private Exception m_exception = null;
    private boolean m_canceled = false;

    public DBDataSource(Connection connection) {
        super(0, 0);
        this.m_conn = connection;
    }

    public void setProgressBar(ProgressBar progressBar) {
        this.m_progressBar = progressBar;
    }

    protected void setException(Exception exception) {
        this.m_exception = exception;
    }

    protected ProgressBar getProgressBar() {
        return this.m_progressBar;
    }

    public Exception getException() {
        return this.m_exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.m_columnModel = this.createColumns();
            this.createData();
            this.createRowHeader();
            if (this.getProgressBar() != null) {
                this.getProgressBar().setDoneStatus();
            }
        }
        catch (Exception exception) {
            this.setException(exception);
            if (this.getProgressBar() != null) {
                this.getProgressBar().setDoneStatus();
            }
        }
    }

    protected abstract void createData() throws Exception;

    protected abstract ArrayOneDModel createColumns() throws Exception;

    public Vector getAttributes(int n) {
        Vector<Object> vector = new Vector<Object>(this.getRowCount());
        for (int i = 0; i < this.getRowCount(); ++i) {
            vector.add(this.getData(n, i));
        }
        return vector;
    }

    public int getFirstRowByColumnValue(int n, String string) {
        int n2 = -1;
        for (int i = 0; i < this.getRowCount(); ++i) {
            String string2 = (String)this.getData(n, i);
            if (!string.equals(string2)) continue;
            n2 = i;
            i = this.getRowCount();
        }
        return n2;
    }

    public ArrayOneDModel getColumnDataSource() {
        return this.m_columnModel;
    }

    public NumericOneDModel getRowDataSource() {
        if (this.m_rowModel.getItemCount() < this.getRowCount()) {
            this.m_rowModel = new NumericOneDModel(this.getRowCount());
        }
        return this.m_rowModel;
    }

    protected void createRowHeader() {
        this.m_rowModel = new NumericOneDModel(this.getRowCount());
    }

    public boolean isCancelled() {
        return this.m_canceled;
    }

    public void cancel() {
        if (this.m_statement != null) {
            try {
                this.m_statement.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_canceled = true;
    }
}

