/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Vector;
import javax.datamining.JDMException;
import javax.datamining.NamedObject;
import javax.datamining.data.CategorySet;
import javax.datamining.resource.Connection;
import javax.datamining.supervised.classification.ClassificationModel;
import javax.swing.JOptionPane;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.datasources.DM4JDataSource;
import oracle.dmt.dm4j.wizard.director.minings.ClassificationModelApplyBuilder;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;

public class ClassificationTargetSource
extends DM4JDataSource {
    private HashMap m_targetPredictionColumns = null;
    private Vector m_selectedTargetValues = null;
    protected static final int COLUMN_COUNT = 3;
    public static final int INCLUDE = 0;
    public static final int TARGET_VALUE = 1;
    public static final int TARGET_PREDICTION = 2;

    public ClassificationTargetSource(Connection connection, String string) {
        this(connection, string, null, null);
    }

    public ClassificationTargetSource(Connection connection, String string, HashMap hashMap, Vector vector) {
        super(connection, string);
        this.m_targetPredictionColumns = hashMap;
        this.m_selectedTargetValues = vector;
    }

    protected void createData() throws SQLException, JDMException {
        this.createDataFromDB();
    }

    protected void createDataFromDB() throws SQLException, JDMException {
        ClassificationModel classificationModel = (ClassificationModel)this.m_jdmConn.retrieveObject(this.m_odmObjectName.toUpperCase(), NamedObject.model);
        CategorySet categorySet = classificationModel.getTargetCategorySet();
        int n = categorySet.getSize();
        boolean bl = false;
        if (this.m_targetPredictionColumns != null && this.m_targetPredictionColumns.size() > 0) {
            bl = true;
        }
        for (int i = 0; i < n; ++i) {
            this.addRows(i, 1);
            Object object = categorySet.getValue(i);
            this.setData(1, i, object);
            String string = null;
            string = bl ? (String)this.m_targetPredictionColumns.get(object) : object.toString();
            this.setData(2, i, string);
            boolean bl2 = false;
            if (this.m_selectedTargetValues != null) {
                bl2 = this.m_selectedTargetValues.contains(object);
            }
            this.setData(0, i, bl2 ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    protected ArrayOneDModel createColumns() throws Exception {
        this.addColumns(0, 3);
        Object[] objectArray = new String[]{ResourceUtilities.getUILabel("DATA_USAGE_INCLUDE"), ResourceUtilities.getUILabel("TARGET_VALUE"), ResourceUtilities.getUILabel("TARGET_PREDICTION_COLUMN")};
        return new ArrayOneDModel(objectArray);
    }

    public int getIncludedCount() {
        int n = 0;
        Boolean bl = new Boolean(false);
        for (int i = 0; i < this.getRowCount(); ++i) {
            bl = (Boolean)this.getData(0, i);
            if (!bl.booleanValue()) continue;
            ++n;
        }
        return n;
    }

    public Vector getIncludedTargetValues(boolean bl) {
        Vector<Object> vector = new Vector<Object>(this.getRowCount());
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (bl) {
                Boolean bl2 = (Boolean)this.getData(0, i);
                if (!bl2.booleanValue()) continue;
                vector.add(this.getData(1, i));
                continue;
            }
            vector.add(this.getData(1, i));
        }
        return vector;
    }

    public HashMap getTargetPredictionColumns(boolean bl) {
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            Object object = this.getData(1, i);
            String string = (String)this.getData(2, i);
            if (bl) {
                Boolean bl2 = (Boolean)this.getData(0, i);
                if (!bl2.booleanValue()) continue;
                hashMap.put(object, string);
                continue;
            }
            hashMap.put(object, string);
        }
        return hashMap;
    }

    private int getAttributeIndex(String string) {
        int n = -1;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!((String)this.getData(2, i)).equals(string)) continue;
            n = i;
            break;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateBaseColumnName(String string) {
        int n = 0;
        n = Math.max(30 - (new String(ClassificationModelApplyBuilder.COST_COLUMN_NAME).length() + 1), n);
        n = Math.max(30 - (new String(ClassificationModelApplyBuilder.PROBABILITY_COLUMN_NAME).length() + 1), n);
        n = Math.max(30 - (new String(ClassificationModelApplyBuilder.NODEID_COLUMN_NAME).length() + 1), n);
        n = Math.max(30 - (new String(ClassificationModelApplyBuilder.RULEID_COLUMN_NAME).length() + 1), n);
        String string2 = null;
        if (string == null) {
            String string3 = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            Object[] objectArray = new Object[]{ResourceUtilities.getUILabel("COLUMN_NAME_ONLY")};
            string2 = MessageFormat.format(string3, objectArray);
        } else {
            boolean bl = DM4JStringUtils.isDoubleQuotedString(string);
            if (bl) {
                string = DM4JStringUtils.trimDoubleQuotes(string);
            }
            if (!ValidationUtil.checkStringLength(string, n)) {
                String string4 = ResourceUtilities.getstateExceptionMessage("FIELD_LENGTH_EXCEEDED");
                Object[] objectArray = new Object[]{ResourceUtilities.getUILabel("COLUMN_NAME_ONLY"), Integer.toString(n)};
                string2 = MessageFormat.format(string4, objectArray);
            } else {
                java.sql.Connection connection = null;
                try {
                    connection = DM4JConnectionManager.getDbConnection();
                    if (!ValidationUtil.checkStringDBLengthMax(string, connection, n)) {
                        String string5 = ResourceUtilities.getstateExceptionMessage("APPLY_OUTPUT_COLUMN_NAME_MAX_BTYES_EXCEEDED");
                        Object[] objectArray = new Object[]{Integer.toString(n)};
                        string2 = MessageFormat.format(string5, objectArray);
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
        if (string2 != null) {
            JOptionPane.showOptionDialog(BrowserFrame.getMainFrame(), string2, DM4JVersion.getFullBrowserName(), -1, 0, null, null, null);
            return false;
        }
        return true;
    }

    public String setTargetPredictionAtIndex(int n, String string) {
        int n2 = this.getAttributeIndex(string);
        if (n2 >= 0 && n >= 0 && n != n2) {
            String string2 = ResourceUtilities.getstateExceptionMessage("OUTPUT_COLUMN_DUPLICATE_NAME");
            JOptionPane.showOptionDialog(BrowserFrame.getMainFrame(), string2, DM4JVersion.getFullBrowserName(), -1, 0, null, null, null);
            String string3 = (String)this.getData(2, n);
            return string3;
        }
        if (!this.validateBaseColumnName(string)) {
            String string4 = (String)this.getData(2, n);
            return string4;
        }
        return string;
    }
}

