/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.datamining.data.AttributeType;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.activity.data.Column;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.datasources.DiscretizationLDSDataSource;
import oracle.dmt.dm4j.datasources.DiscretizeDataSource;
import oracle.dmt.dm4j.datasources.DiscretizePredefinedCategoricTreatment;
import oracle.dmt.dm4j.datasources.TXColumn;
import oracle.dmt.dm4j.wizard.director.transforms.TransformsDirector;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.odm.binning.Bin;
import oracle.dmt.odm.binning.BinningType;
import oracle.dmt.odm.binning.CategoricBin;
import oracle.dmt.odm.binning.DM4JTransformation;
import oracle.jdbc.OraclePreparedStatement;

public class CategoricDiscretizeDataSource
extends DiscretizeDataSource {
    public static final int MAXIMUM_CATEGORICAL_BIN_NUMBER = 125;
    private static int A = 0;
    private static int COLUMN_COUNT = COLUMN_NAMES.LAST;
    protected static String[] items = new String[COLUMN_COUNT];

    public CategoricDiscretizeDataSource(Connection connection) throws Exception {
        super(connection);
    }

    protected void doDefaultTreatment() {
        if (this.m_bAutoRun) {
            return;
        }
        DiscretizePredefinedCategoricTreatment discretizePredefinedCategoricTreatment = new DiscretizePredefinedCategoricTreatment(this);
        discretizePredefinedCategoricTreatment.processAttributes(this.m_context.getActivity().getType());
    }

    public void cleanUp() {
        this.m_NameRow.clear();
        this.removeRows(0, this.getRowCount());
        if (this.m_rowModel != null) {
            this.m_rowModel.removeItems(0, this.m_rowModel.getItemCount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createDataFrom2DSource() throws Exception {
        try {
            if (this.m_collectColumnNames) {
                this.m_tableColumns = this.m_lds.getAllAttributes();
            }
            int n = 0;
            Vector vector = this.m_lds.getNonUniqueAttributes();
            Vector<String> vector2 = new Vector<String>();
            Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
            boolean bl = false;
            if (this.m_context != null && this.m_context.getLaunchPoint() == LaunchPoint.ACTIVITY_GUIDE) {
                bl = true;
            }
            for (int i = 0; i < vector.size(); ++i) {
                String string = (String)vector.elementAt(i);
                String string2 = this.m_lds.getMiningType(string);
                AttributeType attributeType = (AttributeType)m_AttributeType.get(string2);
                String string3 = this.m_lds.getDataType(string);
                if (!bl && (string3 == null || string3.equals("DM_NESTED_CATEGORICALS")) || attributeType == null || !attributeType.equals(AttributeType.categorical)) continue;
                this.addRows(++n - 1, 1);
                this.setAttributeName(n - 1, string);
                this.setMiningType(n - 1, this.m_lds.getMiningType(string));
                this.setDataType(n - 1, string3);
                this.setBinTypeNONE(n - 1);
                this.setNumberOfBins(n - 1);
                this.setViewDefinition(n - 1, null);
                this.setDisplayNames(n - 1, null);
                this.setBinBounds(n - 1, null);
                vector2.add(this.getColumnName(string));
                hashtable.put(this.getColumnName(string), new Integer(n - 1));
            }
            this.addCategoricStats2D(this.m_conn, vector2, hashtable, null);
            hashtable.clear();
            vector2.clear();
        }
        catch (Exception exception) {
            if (CategoricDiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
    }

    protected void createDataFromTXSource() throws Exception {
        try {
            if (this.m_collectColumnNames) {
                this.m_tableColumns = this.m_lds.getAllAttributes();
            }
            int n = 0;
            Vector vector = this.m_lds.getNonUniqueAttributes();
            Vector<String> vector2 = new Vector<String>();
            Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
            for (int i = 0; i < vector.size(); ++i) {
                String string = (String)vector.elementAt(i);
                int n2 = this.m_lds.getAttributeIndex(string);
                String string2 = (String)this.m_lds.getData(3, n2);
                AttributeType attributeType = (AttributeType)m_AttributeType.get(string2);
                if (attributeType == null || !attributeType.equals(AttributeType.categorical)) continue;
                this.addRows(++n - 1, 1);
                this.setAttributeName(n - 1, string);
                this.setMiningType(n - 1, string2);
                String string3 = (String)this.m_lds.getData(2, n2);
                this.setDataType(n - 1, string3);
                this.setBinTypeNONE(n - 1);
                this.setNumberOfBins(n - 1);
                this.setViewDefinition(n - 1, null);
                this.setDisplayNames(n - 1, null);
                this.setBinBounds(n - 1, null);
                vector2.add(string);
                hashtable.put(string, new Integer(n - 1));
            }
            this.addCategoricStatsTX(this.m_conn, vector2, hashtable, this.m_sDataLocation);
            hashtable.clear();
        }
        catch (Exception exception) {
            if (CategoricDiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCategoricStatsTX(Connection connection, Vector vector, Hashtable hashtable, String string) {
        if (vector == null || vector.isEmpty()) {
            return;
        }
        String string2 = "SELECT {0} ANAME, count({1}) as N, count(distinct {1}) as D, stats_mode({1}) as S, count(*) as T from {2} group by {0}";
        String string3 = MessageFormat.format(string2, "\"" + this.m_attributeMapping + "\"", "\"" + this.m_valueMapping + "\"", string == null ? this.getSampledDataLocation() : string);
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                String string4 = resultSet.getString("ANAME");
                Integer n = (Integer)hashtable.get(string4);
                if (n == null) continue;
                int n2 = resultSet.getInt("N");
                this.setData(COLUMN_NAMES.TOTAL, n, new Integer(n2));
                int n3 = resultSet.getInt("D");
                this.setData(COLUMN_NAMES.DISTINCT, n, new Integer(n3));
                String string5 = resultSet.getString("S");
                this.setData(COLUMN_NAMES.MODE, n, string5);
                int n4 = resultSet.getInt("T");
                int n5 = n4 - n2;
                double d = (double)n5 / (double)n4;
                this.setData(COLUMN_NAMES.MISSING_PERCENT, n, new Double(d));
            }
        }
        catch (Exception exception) {
            if (CategoricDiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCategoricStats2D(Connection connection, Vector vector, Hashtable hashtable, String string) {
        if (vector == null || vector.isEmpty()) {
            return;
        }
        int n = vector.size() / 1000 + 1;
        String string2 = "count({0}) as N{1}, count(distinct {0}) as D{1}, stats_mode({0}) as S{1} ";
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            int n2 = Math.min(vector.size(), 1000 * (i + 1));
            int n3 = 1000 * i;
            StringBuffer stringBuffer = new StringBuffer("SELECT /*+ parallel (t) */ count (*) as TOTAL,");
            for (int j = n3; j < n2; ++j) {
                object2 = (String)vector.elementAt(j);
                object = MessageFormat.format(string2, "\"" + (String)object2 + "\"", String.valueOf(j));
                if (j > n3) {
                    stringBuffer.append(",\n");
                }
                stringBuffer.append((String)object);
            }
            String string3 = MessageFormat.format(" from ({0} t)", string == null ? this.getSampledDataLocation() : string);
            stringBuffer.append(string3);
            object2 = null;
            object = null;
            try {
                object2 = connection.createStatement();
                object = object2.executeQuery(stringBuffer.toString());
                if (!object.next()) continue;
                int n4 = object.getInt("TOTAL");
                for (int j = n3; j < n2; ++j) {
                    String string4 = String.valueOf(j);
                    String string5 = (String)vector.elementAt(j);
                    Integer n5 = (Integer)hashtable.get(string5);
                    if (n5 == null) continue;
                    int n6 = object.getInt("N" + string4);
                    this.setData(COLUMN_NAMES.TOTAL, n5, new Integer(n6));
                    int n7 = object.getInt("D" + string4);
                    this.setData(COLUMN_NAMES.DISTINCT, n5, new Integer(n7));
                    String string6 = object.getString("S" + string4);
                    this.setData(COLUMN_NAMES.MODE, n5, string6);
                    int n8 = n4 - n6;
                    double d = (double)n8 / (double)n4 * 100.0;
                    this.setData(COLUMN_NAMES.MISSING_PERCENT, n5, new Double(d));
                    this.setData(COLUMN_NAMES.SPARSITY_FLAG, n5, new Boolean(d >= this.m_preferences.getSparsityCutoff()));
                }
                continue;
            }
            catch (Exception exception) {
                if (!CategoricDiscretizeDataSource.isDebug()) continue;
                exception.printStackTrace();
                continue;
            }
            finally {
                try {
                    object.close();
                    object2.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected ArrayOneDModel createColumns() throws Exception {
        this.addColumns(0, COLUMN_COUNT);
        return new ArrayOneDModel((Object[])items);
    }

    public StringBuffer getViewDefinition(Connection connection, int[] nArray, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer = this.isLabels() ? this.createCategoricalViewDefinition(this.m_tableColumns, nArray, this.getSampledDataLocation(), this.m_userSchemaName, this.m_resultViewName, bl) : this.createCategoricalViewDefinitionNumbers(this.m_tableColumns, nArray, this.getSampledDataLocation(), this.m_userSchemaName, this.m_resultViewName, bl);
            this.splitViewDefinition(stringBuffer, nArray);
        }
        catch (Exception exception) {
            if (CategoricDiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
            stringBuffer = new StringBuffer();
        }
        return stringBuffer;
    }

    private StringBuffer createCategoricalViewDefinition(Vector vector, int[] nArray, String string, String string2, String string3, boolean bl) {
        Object object;
        String string4;
        String string5;
        int n;
        Object object2;
        if (this.m_isTransactional && !this.m_bSingleMetric) {
            return this.createCategoricOpenEndedViewDefinitionTX(vector, nArray, string2, string3, bl);
        }
        StringBuffer stringBuffer = new StringBuffer("CREATE VIEW " + string2 + "." + string3 + " AS SELECT " + "\n");
        int n2 = vector.size();
        Hashtable<String, Vector> hashtable = new Hashtable<String, Vector>(n2);
        for (int i = 0; i < nArray.length; ++i) {
            object2 = this.getAttributeName(nArray[i]);
            Vector vector2 = this.getBinBounds(nArray[i]);
            if (vector2 == null || vector2.size() == 0) continue;
            hashtable.put("\"" + (String)object2 + "\"", vector2);
        }
        Vector<String> vector3 = new Vector<String>();
        object2 = new Vector();
        for (n = 0; n < n2; ++n) {
            string5 = (String)vector.elementAt(n);
            string4 = this.m_lds.getComplexAttributeInfo(string5);
            if (string4 != null) {
                vector3.add(string5);
                continue;
            }
            ((Vector)object2).add(string5);
        }
        for (n = 0; n < ((Vector)object2).size(); ++n) {
            string5 = (String)vector.elementAt(n);
            string4 = "\"" + string5 + "\"";
            if (null == hashtable.get(string4)) {
                stringBuffer.append(string4);
            } else {
                stringBuffer.append(" DECODE (" + string4);
                stringBuffer.append("\n");
                object = (Vector)hashtable.get(string4);
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    CategoricBin categoricBin = (CategoricBin)((Vector)object).elementAt(i);
                    for (int j = 0; j < categoricBin.values.size(); ++j) {
                        stringBuffer.append(",");
                        stringBuffer.append("'" + (String)categoricBin.values.elementAt(j) + "'" + "," + "'" + categoricBin.category + "'");
                        stringBuffer.append("\n");
                    }
                }
                stringBuffer.append(",NULL,NULL,'" + ResourceUtilities.getUILabel("HISTOGRAM_OTHER") + "'" + ")" + string4);
            }
            if (n < ((Vector)object2).size() - 1) {
                stringBuffer.append(",");
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append(" FROM " + string);
        for (n = 0; n < vector3.size(); ++n) {
            TXColumn tXColumn;
            string5 = (String)vector3.elementAt(n);
            int n3 = this.getAttributeRow(string5);
            if (!this.isSelected(nArray, n3) || (object = this.m_lds.getComplexAttributeInfo(string5)) == null || (tXColumn = this.m_sampledInputCDS.getTXColumn((String)object)) == null) continue;
            try {
                int n4 = this.getAttributeRow(string5);
                if (n4 == -1) continue;
                this.processCatTxSource(string5, tXColumn.getValueColumn(), (String)object, (Vector)hashtable.get("\"" + string5 + "\""));
                continue;
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
        hashtable.clear();
        return stringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer createCategoricOpenEndedViewDefinitionTX(Vector vector, int[] nArray, String string, String string2, boolean bl) {
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            if (bl) {
                String string3 = "\"" + this.m_userSchemaName + "\".\"" + this.m_categoricalDiscretizationTableName + "\"";
                this.cleanBinBoundary(connection, string3, nArray);
            }
            this.populateGroupCategoricBinBoundaries(connection, nArray, this.m_categoricalDiscretizationTableName, this.m_userSchemaName);
        }
        catch (Exception exception) {
            if (CategoricDiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        return this.m_txSampledViewDefinition;
    }

    private StringBuffer createCategoricalViewDefinitionNumbers(Vector vector, int[] nArray, String string, String string2, String string3, boolean bl) {
        Serializable serializable;
        String string4;
        String string5;
        int n;
        Object object;
        if (this.m_isTransactional && !this.m_bSingleMetric) {
            return this.createCategoricOpenEndedViewDefinitionTX(vector, nArray, string2, string3, bl);
        }
        StringBuffer stringBuffer = new StringBuffer("CREATE VIEW " + string2 + "." + string3 + " AS SELECT " + "\n");
        int n2 = vector.size();
        Hashtable<String, Vector> hashtable = new Hashtable<String, Vector>(n2);
        for (int i = 0; i < nArray.length; ++i) {
            object = this.getAttributeName(nArray[i]);
            Vector vector2 = this.getBinBounds(nArray[i]);
            if (vector2 == null || vector2.size() == 0) continue;
            hashtable.put("\"" + (String)object + "\"", vector2);
        }
        Vector<String> vector3 = new Vector<String>();
        object = new Vector();
        for (n = 0; n < n2; ++n) {
            string5 = (String)vector.elementAt(n);
            string4 = this.m_lds.getComplexAttributeInfo(string5);
            if (string4 != null) {
                vector3.add(string5);
                continue;
            }
            ((Vector)object).add(string5);
        }
        for (n = 0; n < ((Vector)object).size(); ++n) {
            string5 = (String)((Vector)object).elementAt(n);
            string4 = "\"" + string5 + "\"";
            if (null == hashtable.get(string4)) {
                stringBuffer.append(string4);
            } else {
                stringBuffer.append(" DECODE (" + string4);
                stringBuffer.append("\n");
                serializable = (Vector)hashtable.get(string4);
                for (int i = 0; i < ((Vector)serializable).size(); ++i) {
                    CategoricBin categoricBin = (CategoricBin)((Vector)serializable).elementAt(i);
                    for (int j = 0; j < categoricBin.values.size(); ++j) {
                        stringBuffer.append(",");
                        stringBuffer.append("'" + (String)categoricBin.values.elementAt(j) + "'" + "," + "'" + (i + 1) + "'");
                        stringBuffer.append("\n");
                    }
                }
                stringBuffer.append(",NULL,NULL,'" + (((Vector)serializable).size() + 1) + "'" + ")" + string4);
            }
            if (n < ((Vector)object).size() - 1) {
                stringBuffer.append(",");
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append(" FROM " + string);
        for (n = 0; n < vector3.size(); ++n) {
            string5 = (String)vector3.elementAt(n);
            string4 = this.m_lds.getComplexAttributeInfo(string5);
            if (string4 == null || (serializable = this.m_sampledInputCDS.getTXColumn(string4)) == null) continue;
            try {
                int n3 = this.getAttributeRow(string5);
                if (n3 == -1) continue;
                this.processCatTxSource(string5, ((TXColumn)serializable).getValueColumn(), string4, (Vector)hashtable.get("\"" + string5 + "\""));
                continue;
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
        hashtable.clear();
        return stringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateGroupCategoricBinBoundaries(Connection connection, int[] nArray, String string, String string2) throws SQLException {
        if (nArray == null || nArray.length == 0) {
            return;
        }
        Object[] objectArray = new Object[]{string2, string};
        String string3 = MessageFormat.format("INSERT INTO {0}.{1} VALUES ( ?,?,?,?,?,?)", objectArray);
        Statement statement = null;
        boolean bl = false;
        boolean bl2 = true;
        try {
            bl2 = connection.getAutoCommit();
            connection.setAutoCommit(false);
            statement = connection.prepareStatement(string3);
            ((OraclePreparedStatement)statement).setExecuteBatch(100);
            for (int i = 0; i < nArray.length; ++i) {
                String string4 = this.getAttributeName(nArray[i]);
                Vector vector = this.getBinBounds(nArray[i]);
                CategoricBin[] categoricBinArray = new CategoricBin[vector.size()];
                categoricBinArray = vector.toArray(categoricBinArray);
                for (int j = 0; j < categoricBinArray.length; ++j) {
                    for (int k = 0; k < categoricBinArray[j].values.size(); ++k) {
                        String string5 = (String)categoricBinArray[j].values.elementAt(k);
                        String string6 = categoricBinArray[j].category;
                        this.insertBounds((PreparedStatement)statement, string4, Integer.parseInt(string6), string5, string5);
                    }
                }
            }
            if (!bl) {
                ((OraclePreparedStatement)statement).sendBatch();
                connection.commit();
            }
        }
        catch (Exception exception) {
            if (CategoricDiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            connection.setAutoCommit(bl2);
            if (statement != null) {
                statement.close();
            }
        }
    }

    private void insertBounds(PreparedStatement preparedStatement, String string, int n, String string2, String string3) {
        block4: {
            String string4 = "T";
            int n2 = 1;
            try {
                preparedStatement.setString(n2++, string);
                preparedStatement.setNull(n2++, 12);
                if (string2 == null) {
                    preparedStatement.setNull(n2++, 12);
                } else {
                    preparedStatement.setString(n2++, string2);
                }
                preparedStatement.setInt(n2++, n);
                preparedStatement.setString(n2++, string3);
                preparedStatement.setString(n2++, string4);
                preparedStatement.executeUpdate();
            }
            catch (Exception exception) {
                if (!CategoricDiscretizeDataSource.isDebug()) break block4;
                exception.printStackTrace();
            }
        }
    }

    public void splitViewDefinition(StringBuffer stringBuffer, int[] nArray) {
        if (this.m_isTransactional && !this.m_bSingleMetric) {
            this.splitViewDefinitionTX(stringBuffer, nArray);
            return;
        }
        StringBuffer stringBuffer2 = new StringBuffer("CREATE VIEW ");
        stringBuffer2.append("\"" + this.m_userSchemaName + "\".\"" + this.m_resultViewName + "\"");
        stringBuffer2.append(" AS SELECT ");
        String string = stringBuffer.toString();
        for (int i = 0; i < nArray.length; ++i) {
            if (!this.isTopNBinning(nArray[i])) continue;
            String string2 = this.getAttributeName(nArray[i]);
            String string3 = "\"" + string2 + "\"";
            int n = string.indexOf(" DECODE (" + string3);
            if (n == -1) {
                if (!CategoricDiscretizeDataSource.isDebug()) continue;
                System.out.println("Looking for: DECODE (" + string3);
                System.out.println("In string:" + string);
                continue;
            }
            String string4 = ")" + string3;
            int n2 = string.indexOf(string4);
            if (n2 == -1) {
                if (!CategoricDiscretizeDataSource.isDebug()) continue;
                System.out.println("Looking for:" + string4);
                System.out.println("In string:" + string);
                continue;
            }
            StringBuffer stringBuffer3 = new StringBuffer(stringBuffer2.toString());
            stringBuffer3.append(string.substring(n, n2));
            stringBuffer3.append(string4);
            stringBuffer3.append(" FROM ");
            stringBuffer3.append(this.getSampledDataLocation());
            this.setViewDefinition(nArray[i], stringBuffer3);
        }
    }

    public Object getViewDefinition(String string) {
        Object object;
        int n;
        Serializable serializable;
        int n2;
        String string2;
        int n3;
        if (this.m_isTransactional && !this.m_bSingleMetric) {
            return this.m_txViewDefinition;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append("CREATE VIEW ");
            stringBuffer.append(string);
        }
        stringBuffer.append(" AS SELECT ");
        int n4 = this.m_tableColumns.size();
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        for (n3 = 0; n3 < n4; ++n3) {
            String string3 = (String)this.m_tableColumns.elementAt(n3);
            string2 = this.m_lds.getComplexAttributeInfo(string3);
            if (string2 == null) {
                vector.add(string3);
                continue;
            }
            vector2.add(string3);
        }
        n3 = vector.size();
        for (n2 = 0; n2 < n3; ++n2) {
            Object object2;
            string2 = (String)vector.elementAt(n2);
            int n5 = this.getAttributeRow(string2);
            int n6 = this.m_parentSource.getAttributeRow(string2);
            if (n5 != -1) {
                object2 = this.getBinBounds(n5);
                serializable = this.getViewDefinition(n5);
                if (serializable != null && 0 != ((StringBuffer)serializable).length()) {
                    int n7;
                    int n8 = -1;
                    n = -1;
                    for (int i = n7 = ((StringBuffer)serializable).indexOf(" DECODE ("); i < ((StringBuffer)serializable).length(); ++i) {
                        if ('(' != ((StringBuffer)serializable).charAt(i)) continue;
                        n8 = i;
                        object = null;
                        object = this.isLabels() ? ",NULL,NULL,'" + ResourceUtilities.getUILabel("HISTOGRAM_OTHER") + "')" : ",NULL,NULL,'" + (((Vector)object2).size() + 1) + "')";
                        int n9 = ((StringBuffer)serializable).indexOf((String)object);
                        if (n9 == -1) break;
                        n = n9 + ((String)object).length();
                        break;
                    }
                    if (n8 == -1 || n == -1) {
                        if (!CategoricDiscretizeDataSource.isDebug()) continue;
                        System.out.println("malformed view definition");
                        continue;
                    }
                    String string4 = " DECODE (" + ((StringBuffer)serializable).substring(n8 + 1, n);
                    stringBuffer.append(string4);
                }
            } else if (n6 != -1) {
                stringBuffer.append(this.m_parentSource.getCaseStatement(n6));
            }
            object2 = this.getColumnName(string2);
            stringBuffer.append(" \"" + (String)object2 + "\"");
            if (n2 >= n3 - 1) continue;
            stringBuffer.append(",");
        }
        if (this.isSingleMetric()) {
            this.addSingleMetric(stringBuffer);
            stringBuffer.append(" FROM ");
        } else if (n4 == 0) {
            this.addSkippedAttributesToViewDefinition(stringBuffer, false);
            stringBuffer.append(" * FROM ");
        } else {
            this.addSkippedAttributesToViewDefinition(stringBuffer, true);
            stringBuffer.append(" FROM ");
        }
        for (n2 = 0; n2 < vector2.size(); ++n2) {
            TXColumn tXColumn;
            string2 = (String)vector2.elementAt(n2);
            String string5 = this.m_lds.getComplexAttributeInfo(string2);
            if (string5 == null || (tXColumn = this.m_sampledInputCDS.getTXColumn(string5)) == null) continue;
            try {
                int n10 = this.getAttributeRow(string2);
                serializable = this.m_context.getActivity().getTextColumn();
                String string6 = ((Column)serializable).getAlias();
                if (string6 != null && string6.equals(string2)) {
                    this.processTextTxSource(tXColumn.getValueColumn(), string5);
                    continue;
                }
                if (n10 != -1) {
                    this.processCatTxSource(string2, tXColumn.getValueColumn(), string5, this.getBinBounds(n10));
                    continue;
                }
                n = this.m_parentSource.getAttributeRow(string2);
                if (n == -1) continue;
                Hashtable<String, BinningType> hashtable = new Hashtable<String, BinningType>();
                hashtable.put(string2, this.m_parentSource.getBinningType(n));
                DiscretizeDataSource.BinBoundMap binBoundMap = new DiscretizeDataSource.BinBoundMap(1);
                object = this.m_parentSource.getBinBounds(n);
                if (object != null && ((Vector)object).size() != 0) {
                    Bin[] binArray = new Bin[((Vector)object).size()];
                    binArray = ((Vector)object).toArray(binArray);
                    for (int i = 0; i < binArray.length; ++i) {
                        int n11 = binArray[i].getBinNumber();
                        double d = binArray[i].getLowerBound();
                        double d2 = binArray[i].getUpperBound();
                        binBoundMap.addBinBound("\"" + string2 + "\"", new DiscretizeDataSource.BinBound(n11, d, d2));
                    }
                }
                this.m_parentSource.processNumTxSource(string2, tXColumn.getValueColumn(), string5, binBoundMap, hashtable);
                continue;
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
        return stringBuffer;
    }

    protected void addSkippedAttributesToViewDefinition(StringBuffer stringBuffer, boolean bl) {
        Vector vector = this.m_lds.getSkippedAttributes();
        if (vector.isEmpty()) {
            return;
        }
        int n = vector.size();
        if (bl) {
            stringBuffer.append(",");
        }
        for (int i = 0; i < n; ++i) {
            String string = (String)vector.elementAt(i);
            stringBuffer.append(" \"" + string + "\"");
            if (i >= n - 1) continue;
            stringBuffer.append(",");
        }
    }

    protected void addSingleMetric(StringBuffer stringBuffer) {
        stringBuffer.append(",");
        stringBuffer.append(" \"" + this.m_attributeMapping + "\"");
        stringBuffer.append(",");
        stringBuffer.append(" \"" + this.m_seqIdMapping + "\"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getCategoricAttributeFrequencyTX(Connection connection, int n, String string, String string2, boolean bl) {
        String string3;
        Statement statement = null;
        ResultSet resultSet = null;
        Vector vector = this.getBinBounds(n);
        int n2 = vector.size();
        int[] nArray = new int[n2 + 1];
        Hashtable<Integer, CategoricBin> hashtable = new Hashtable<Integer, CategoricBin>();
        StringBuffer stringBuffer = null;
        try {
            string3 = MessageFormat.format(DiscretizeDataSource.HISTOGRAM_VALUES_TX[0], "\"" + this.m_valueMapping + "\"");
            StringBuffer stringBuffer2 = new StringBuffer(string3);
            stringBuffer = this.getViewDefinition(n);
            if (stringBuffer == null) {
                stringBuffer = this.getViewDefinition(connection, new int[]{n}, bl);
            }
            if (stringBuffer == null) {
                int[] nArray2 = nArray = null;
                return nArray2;
            }
            int n3 = stringBuffer.toString().indexOf("SELECT");
            StringBuffer stringBuffer3 = new StringBuffer(stringBuffer.substring(n3));
            stringBuffer2.append(stringBuffer3);
            string3 = MessageFormat.format(DiscretizeDataSource.HISTOGRAM_VALUES_TX[1], "\"" + this.m_valueMapping + "\"", "'" + string + "'", "\"" + this.m_attributeMapping + "\"");
            stringBuffer2.append(string3);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(stringBuffer2.toString());
            while (resultSet.next()) {
                String string4 = resultSet.getString("BIN_NUMBER");
                int n4 = resultSet.getInt("FREQUENCY");
                String string5 = this.getLabel(vector, string4);
                if (string5 == null) {
                    string5 = ResourceUtilities.getUILabel("HISTOGRAM_NULL_VALUE");
                }
                boolean bl2 = false;
                for (int i = 0; i < n2; ++i) {
                    CategoricBin categoricBin = (CategoricBin)vector.elementAt(i);
                    for (int j = 0; j < categoricBin.values.size(); ++j) {
                        if (0 != string5.compareTo(categoricBin.getBinStringValues())) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl2) continue;
                    int n5 = i;
                    nArray[n5] = nArray[n5] + n4;
                    break;
                }
                if (bl2) continue;
                int n6 = n2;
                nArray[n6] = nArray[n6] + n4;
            }
            for (int i = 0; i < n2; ++i) {
                CategoricBin categoricBin = (CategoricBin)vector.elementAt(i);
                hashtable.put(new Integer(i), categoricBin);
            }
            String string6 = ResourceUtilities.getUILabel("HISTOGRAM_OTHER");
            Vector vector2 = this.getOther(vector, n);
            hashtable.put(new Integer(n2), new CategoricBin(string6, vector2));
        }
        catch (Exception exception) {
            if (CategoricDiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
            hashtable.clear();
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
        if (hashtable.isEmpty()) {
            return null;
        }
        this.setDisplayNames(n, hashtable);
        this.setNumberOfBins(n, n2);
        string3 = this.getBinType(n);
        this.setBinType(n, string3, n2);
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getCategoricAttributeFrequency(Connection connection, int n, String string, String string2, boolean bl) {
        String string3;
        if (this.m_isTransactional && !this.m_bSingleMetric) {
            return this.getCategoricAttributeFrequencyTX(connection, n, string, string2, bl);
        }
        Statement statement = null;
        ResultSet resultSet = null;
        Vector vector = this.getBinBounds(n);
        int n2 = vector.size();
        int[] nArray = new int[n2 + 1];
        Hashtable<Integer, CategoricBin> hashtable = new Hashtable<Integer, CategoricBin>();
        StringBuffer stringBuffer = null;
        try {
            string3 = MessageFormat.format(DiscretizeDataSource.HISTOGRAM_VALUES[0], "\"" + string + "\"");
            StringBuffer stringBuffer2 = new StringBuffer(string3);
            stringBuffer = this.getViewDefinition(n);
            if (stringBuffer == null) {
                stringBuffer = this.getViewDefinition(connection, new int[]{n}, bl);
            }
            if (stringBuffer == null) {
                int[] nArray2 = nArray = null;
                return nArray2;
            }
            int n3 = stringBuffer.toString().indexOf("SELECT");
            StringBuffer stringBuffer3 = new StringBuffer(stringBuffer.substring(n3));
            stringBuffer2.append(stringBuffer3);
            string3 = MessageFormat.format(DiscretizeDataSource.HISTOGRAM_VALUES[1], "\"" + string + "\"");
            stringBuffer2.append(string3);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(stringBuffer2.toString());
            while (resultSet.next()) {
                String string4 = resultSet.getString("BIN_NUMBER");
                int n4 = resultSet.getInt("FREQUENCY");
                String string5 = this.getLabel(vector, string4);
                if (string5 == null) {
                    string5 = ResourceUtilities.getUILabel("HISTOGRAM_NULL_VALUE");
                }
                boolean bl2 = false;
                for (int i = 0; i < n2; ++i) {
                    CategoricBin categoricBin = (CategoricBin)vector.elementAt(i);
                    for (int j = 0; j < categoricBin.values.size(); ++j) {
                        if (0 != string5.compareTo(categoricBin.getBinStringValues())) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl2) continue;
                    int n5 = i;
                    nArray[n5] = nArray[n5] + n4;
                    break;
                }
                if (bl2) continue;
                int n6 = n2;
                nArray[n6] = nArray[n6] + n4;
            }
            for (int i = 0; i < n2; ++i) {
                CategoricBin categoricBin = (CategoricBin)vector.elementAt(i);
                hashtable.put(new Integer(i), categoricBin);
            }
            String string6 = ResourceUtilities.getUILabel("HISTOGRAM_OTHER");
            Vector vector2 = this.getOther(vector, n);
            hashtable.put(new Integer(n2), new CategoricBin(string6, vector2));
        }
        catch (Exception exception) {
            if (CategoricDiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
            hashtable.clear();
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
        if (hashtable.isEmpty()) {
            return null;
        }
        this.setDisplayNames(n, hashtable);
        this.setNumberOfBins(n, n2);
        string3 = this.getBinType(n);
        this.setBinType(n, string3, n2);
        return nArray;
    }

    private String getLabel(Vector vector, String string) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < vector.size(); ++i) {
            CategoricBin categoricBin = (CategoricBin)vector.elementAt(i);
            if (0 != categoricBin.category.compareTo(string)) continue;
            return categoricBin.getBinStringValues();
        }
        return null;
    }

    public String getBinType(int n) {
        String string = (String)this.getData(COLUMN_NAMES.BINTYPE, n);
        int n2 = string.indexOf(":");
        if (n2 == -1) {
            return string;
        }
        return string.substring(0, n2);
    }

    public void setBinType(int n, String string, int n2) {
        if (0 == string.compareTo(BinningType.NONE.getName())) {
            this.setData(COLUMN_NAMES.BINTYPE, n, string);
        } else {
            this.setData(COLUMN_NAMES.BINTYPE, n, string + ":" + String.valueOf(n2));
        }
        if (this.options != null) {
            if (string.equalsIgnoreCase(BinningType.NONE.getName())) {
                this.options.setCategoricalDiscretizeTreatment(NONE);
            } else if (string.equalsIgnoreCase(BinningType.TOPN.getName())) {
                this.options.setCategoricalDiscretizeTreatment(TOPN_BINNING);
            }
        }
    }

    public void setBinTypeNONE(int n) {
        this.setData(COLUMN_NAMES.BINTYPE, n, BinningType.NONE.getName());
    }

    public Vector getBinBounds(int n) {
        return (Vector)this.getData(COLUMN_NAMES.BINBOUNDS, n);
    }

    public void setBinBounds(int n, Vector vector) {
        this.setData(COLUMN_NAMES.BINBOUNDS, n, vector);
    }

    public StringBuffer getViewDefinition(int n) {
        return (StringBuffer)this.getData(COLUMN_NAMES.VIEW_DEFN, n);
    }

    public void setViewDefinition(int n, StringBuffer stringBuffer) {
        this.setData(COLUMN_NAMES.VIEW_DEFN, n, stringBuffer);
    }

    public String getAttributeName(int n) {
        return (String)this.getData(COLUMN_NAMES.NAME, n);
    }

    public void setAttributeName(int n, String string) {
        this.setData(COLUMN_NAMES.NAME, n, string);
        this.m_NameRow.put(string, new Integer(n));
    }

    public String getMiningType(int n) {
        return (String)this.getData(COLUMN_NAMES.MTYPE, n);
    }

    public void setMiningType(int n, String string) {
        this.setData(COLUMN_NAMES.MTYPE, n, string);
    }

    public String getDataType(int n) {
        return (String)this.getData(COLUMN_NAMES.DTYPE, n);
    }

    public void setDataType(int n, String string) {
        this.setData(COLUMN_NAMES.DTYPE, n, string);
    }

    public Integer getNumberOfBins(int n) {
        return (Integer)this.getData(COLUMN_NAMES.BINNUMBER, n);
    }

    public void setNumberOfBins(int n, int n2) {
        this.setData(COLUMN_NAMES.BINNUMBER, n, new Integer(n2));
    }

    public void setNumberOfBins(int n) {
        this.setData(COLUMN_NAMES.BINNUMBER, n, null);
    }

    public Hashtable getDisplayNames(int n) {
        return (Hashtable)this.getData(COLUMN_NAMES.DISPLAY_NAMES, n);
    }

    public void setDisplayNames(int n, Hashtable hashtable) {
        this.setData(COLUMN_NAMES.DISPLAY_NAMES, n, hashtable);
    }

    public Integer getMissingValuePercent(int n) {
        return (Integer)this.getData(COLUMN_NAMES.MISSING_PERCENT, n);
    }

    public void setMissingValuePercent(int n, int n2) {
        this.setData(COLUMN_NAMES.MISSING_PERCENT, n, new Integer(n2));
    }

    public Integer getDistinctValue(int n) {
        return (Integer)this.getData(COLUMN_NAMES.DISTINCT, n);
    }

    public Integer getTotalCount(int n) {
        return (Integer)this.getData(COLUMN_NAMES.TOTAL, n);
    }

    public String getMode(int n) {
        return (String)this.getData(COLUMN_NAMES.MODE, n);
    }

    public void setActivityType(int n, ActivityType activityType) {
        this.setData(COLUMN_NAMES.DEFAULT_ALGORITHM, n, activityType);
    }

    public ActivityType getActivityType(int n) {
        return (ActivityType)this.getData(COLUMN_NAMES.DEFAULT_ALGORITHM, n);
    }

    public void setComplexAttribute(int n, String string) {
        this.setData(COLUMN_NAMES.COMPLEX_ATTRIBUTE, n, string);
    }

    public String getComplexAttribute(int n) {
        return (String)this.getData(COLUMN_NAMES.COMPLEX_ATTRIBUTE, n);
    }

    public void setSparsityFlag(int n, boolean bl) {
        this.setData(COLUMN_NAMES.SPARSITY_FLAG, n, new Boolean(bl));
    }

    public boolean getSparsityFlag(int n) {
        Boolean bl = (Boolean)this.getData(COLUMN_NAMES.SPARSITY_FLAG, n);
        return bl;
    }

    public void markAttributeUnBinned(int n) {
        this.setViewDefinition(n, null);
        this.setBinTypeNONE(n);
        this.setNumberOfBins(n);
        this.setBinBounds(n, null);
    }

    public void markAttributeBinned(int n, BinningType binningType, int n2) {
        this.setBinType(n, binningType.getName(), n2);
    }

    public void augmentDataSource(Connection connection, Hashtable hashtable, DiscretizationLDSDataSource discretizationLDSDataSource) throws Exception {
        this.m_lds = discretizationLDSDataSource;
        try {
            int n = this.getRowCount();
            Enumeration enumeration = hashtable.keys();
            Vector<String> vector = new Vector<String>();
            Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)hashtable.get(string);
                AttributeType attributeType = (AttributeType)m_AttributeType.get(string2);
                if (attributeType == null || !attributeType.equals(AttributeType.categorical)) continue;
                this.addRows(++n - 1, 1);
                this.setAttributeName(n - 1, string);
                this.setMiningType(n - 1, this.m_lds.getMiningType(string));
                this.setDataType(n - 1, this.m_lds.getDataType(string));
                this.setBinTypeNONE(n - 1);
                this.setNumberOfBins(n - 1);
                this.setViewDefinition(n - 1, null);
                this.setDisplayNames(n - 1, null);
                this.setBinBounds(n - 1, null);
                vector.add(string);
                hashtable2.put(string, new Integer(n - 1));
            }
            if (this.m_isTransactional && !this.m_bSingleMetric) {
                this.addCategoricStatsTX(connection, vector, hashtable2, this.m_sDataLocation);
            } else {
                this.addCategoricStats2D(connection, vector, hashtable2, null);
            }
            hashtable2.clear();
        }
        catch (Exception exception) {
            if (CategoricDiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCatedoricStats(Vector vector, Hashtable hashtable, String string) {
        if (vector == null || vector.isEmpty()) {
            return;
        }
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            if (this.m_isTransactional && !this.m_bSingleMetric) {
                this.addCategoricStatsTX(connection, vector, hashtable, this.m_sDataLocation);
            } else {
                this.addCategoricStats2D(connection, vector, hashtable, null);
            }
        }
        catch (Exception exception) {
            if (CategoricDiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getTopNStats(int n, int n2) {
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            this.getTopNStats(connection, n, n2);
        }
        catch (Exception exception) {
            if (CategoricDiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getTopNStats(Connection connection, int n, int n2) {
        if (this.m_isTransactional && !this.m_bSingleMetric) {
            this.getTopNStatsTX(connection, n, n2);
            return;
        }
        String string = String.valueOf(n2);
        String string2 = this.getColumnName(this.getAttributeName(n));
        Statement statement = null;
        ResultSet resultSet = null;
        Vector<CategoricBin> vector = new Vector<CategoricBin>();
        try {
            String string3 = MessageFormat.format("SELECT * FROM (SELECT {0} FROM {1} GROUP BY {0} HAVING {0} IS NOT NULL ORDER BY COUNT(*) DESC, {0} DESC) WHERE rownum <= {2}", "\"" + string2 + "\"", this.getSampledDataLocation(), string);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                Vector<String> vector2 = new Vector<String>();
                String string4 = resultSet.getString(1);
                String string5 = null;
                try {
                    string5 = TransformsDirector.getReplacedString(string4, "'", "''");
                }
                catch (Exception exception) {
                    string5 = string4;
                }
                vector2.add(string5);
                CategoricBin categoricBin = new CategoricBin(string5, vector2);
                vector.add(categoricBin);
            }
            this.setBinBounds(n, vector);
        }
        catch (Exception exception) {
            if (CategoricDiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getTopNStats(Connection connection, Vector vector, Hashtable hashtable, String string) {
        if (this.m_isTransactional && !this.m_bSingleMetric) {
            this.getTopNStatsTX(connection, vector, hashtable, string);
            return;
        }
        if (vector == null || vector.isEmpty()) {
            return;
        }
        String string2 = string == null ? this.getSampledDataLocation() : string;
        for (int i = 0; i < vector.size(); ++i) {
            String string3 = (String)vector.elementAt(i);
            Integer n = (Integer)hashtable.get(string3);
            if (n == null) continue;
            string3 = this.getColumnName(string3);
            Integer n2 = this.getNumberOfBins(n);
            if (n2 == null) continue;
            Statement statement = null;
            ResultSet resultSet = null;
            Vector<CategoricBin> vector2 = new Vector<CategoricBin>();
            try {
                String string4 = MessageFormat.format("SELECT * FROM (SELECT {0} FROM {1} GROUP BY {0} HAVING {0} IS NOT NULL ORDER BY COUNT(*) DESC, {0} DESC) WHERE rownum <= {2}", "\"" + string3 + "\"", string2, String.valueOf(n2));
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string4);
                while (resultSet.next()) {
                    Vector<String> vector3 = new Vector<String>();
                    String string5 = resultSet.getString(1);
                    String string6 = null;
                    try {
                        string6 = TransformsDirector.getReplacedString(string5, "'", "''");
                    }
                    catch (Exception exception) {
                        string6 = string5;
                    }
                    vector3.add(string6);
                    CategoricBin categoricBin = new CategoricBin(string6, vector3);
                    vector2.add(categoricBin);
                }
                this.setBinBounds(n, vector2);
                continue;
            }
            catch (Exception exception) {
                if (!CategoricDiscretizeDataSource.isDebug()) continue;
                exception.printStackTrace();
                continue;
            }
            finally {
                try {
                    resultSet.close();
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getTopNStatsTX(Connection connection, Vector vector, Hashtable hashtable, String string, int n) {
        if (vector == null || vector.isEmpty()) {
            return;
        }
        String string2 = string == null ? this.getSampledDataLocation() : string;
        String string3 = String.valueOf(n);
        for (int i = 0; i < vector.size(); ++i) {
            String string4 = (String)vector.elementAt(i);
            Integer n2 = (Integer)hashtable.get(string4);
            if (n2 == null) continue;
            Integer n3 = this.getDistinctValue(n2);
            if (n3 != null && n3 <= n) {
                this.markAttributeUnBinned(n2);
                continue;
            }
            Statement statement = null;
            ResultSet resultSet = null;
            Vector<CategoricBin> vector2 = new Vector<CategoricBin>();
            try {
                String string5 = MessageFormat.format("SELECT * FROM (SELECT {0} FROM {1}  WHERE {3}={4} GROUP BY {0} HAVING {0} IS NOT NULL ORDER BY COUNT(*) DESC, {0} DESC) WHERE rownum <= {2}", "\"" + this.m_valueMapping + "\"", string2, string3, "\"" + this.m_attributeMapping + "\"", "'" + string4 + "'");
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string5);
                while (resultSet.next()) {
                    Vector<String> vector3 = new Vector<String>();
                    String string6 = resultSet.getString(1);
                    vector3.add(string6);
                    CategoricBin categoricBin = new CategoricBin(string6, vector3, vector3);
                    vector2.add(categoricBin);
                }
                this.setBinBounds(n2, vector2);
                continue;
            }
            catch (Exception exception) {
                if (!CategoricDiscretizeDataSource.isDebug()) continue;
                exception.printStackTrace();
                continue;
            }
            finally {
                try {
                    resultSet.close();
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getTopNStatsTX(Connection connection, Vector vector, Hashtable hashtable, String string) {
        if (vector == null || vector.isEmpty()) {
            return;
        }
        String string2 = string == null ? this.getSampledDataLocation() : string;
        for (int i = 0; i < vector.size(); ++i) {
            String string3 = (String)vector.elementAt(i);
            Integer n = (Integer)hashtable.get(string3);
            if (n == null) continue;
            Integer n2 = this.getNumberOfBins(n);
            Statement statement = null;
            ResultSet resultSet = null;
            Vector<CategoricBin> vector2 = new Vector<CategoricBin>();
            try {
                String string4 = MessageFormat.format("SELECT * FROM (SELECT {0} FROM {1}  WHERE {3}={4} GROUP BY {0} HAVING {0} IS NOT NULL ORDER BY COUNT(*) DESC, {0} DESC) WHERE rownum <= {2}", "\"" + this.m_valueMapping + "\"", string2, String.valueOf(n2), "\"" + this.m_attributeMapping + "\"", "'" + string3 + "'");
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string4);
                while (resultSet.next()) {
                    Vector<String> vector3 = new Vector<String>();
                    String string5 = resultSet.getString(1);
                    vector3.add(string5);
                    CategoricBin categoricBin = new CategoricBin(string5, vector3, vector3);
                    vector2.add(categoricBin);
                }
                this.setBinBounds(n, vector2);
                continue;
            }
            catch (Exception exception) {
                if (!CategoricDiscretizeDataSource.isDebug()) continue;
                exception.printStackTrace();
                continue;
            }
            finally {
                try {
                    resultSet.close();
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getTopNStatsTX(Connection connection, int n, int n2) {
        String string = String.valueOf(n2);
        String string2 = this.getAttributeName(n);
        Statement statement = null;
        ResultSet resultSet = null;
        Vector<CategoricBin> vector = new Vector<CategoricBin>();
        try {
            String string3 = MessageFormat.format("SELECT * FROM (SELECT {0} FROM {1}  WHERE {3}={4} GROUP BY {0} HAVING {0} IS NOT NULL ORDER BY COUNT(*) DESC, {0} DESC) WHERE rownum <= {2}", "\"" + this.m_valueMapping + "\"", this.getSampledDataLocation(), string, "\"" + this.m_attributeMapping + "\"", "'" + string2 + "'");
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                Vector<String> vector2 = new Vector<String>();
                String string4 = resultSet.getString(1);
                vector2.add(string4);
                CategoricBin categoricBin = new CategoricBin(string4, vector2, vector2);
                vector.add(categoricBin);
            }
            this.setBinBounds(n, vector);
        }
        catch (Exception exception) {
            if (CategoricDiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getTopNStatsTXMultipleBins(Connection connection, Vector vector, Hashtable hashtable, String string) {
        String string2 = string == null ? this.getSampledDataLocation() : string;
        String string3 = "SELECT DISTINCT {0}, {1} FROM {2} ORDER BY 1 DESC";
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            Object object;
            Object object2;
            Object object3;
            String string4 = MessageFormat.format(string3, "\"" + this.m_attributeMapping + "\"", "\"" + this.m_valueMapping + "\"", string2);
            Hashtable hashtable2 = new Hashtable();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string4);
            while (resultSet.next()) {
                String string5 = resultSet.getString(1);
                object3 = (Integer)hashtable.get(string5);
                if (object3 == null) continue;
                int n = (Integer)object3;
                object2 = resultSet.getString(2);
                if (object2 == null) {
                    this.setViewDefinition(n, null);
                    this.setBinTypeNONE(n);
                    this.setNumberOfBins(n, 0);
                    this.setBinBounds(n, null);
                    continue;
                }
                Vector<CategoricBin> vector2 = (Vector<CategoricBin>)hashtable2.get(string5);
                if (null == vector2) {
                    vector2 = new Vector<CategoricBin>();
                    hashtable2.put(string5, vector2);
                    this.setBinBounds(n, vector2);
                }
                object = new Vector<Object>();
                ((Vector)object).add(object2);
                CategoricBin categoricBin = new CategoricBin((String)object2, (Vector)object, (Vector)object);
                vector2.add(categoricBin);
                if (vector2.size() != 124) continue;
                break;
            }
            hashtable2.clear();
            if (CategoricDiscretizeDataSource.isDebug()) {
                for (int i = 0; i < vector.size(); ++i) {
                    object3 = (String)vector.elementAt(i);
                    Integer n = (Integer)hashtable.get(object3);
                    object2 = this.getBinBounds(n);
                    for (int j = 0; j < ((Vector)object2).size(); ++j) {
                        object = (CategoricBin)((Vector)object2).elementAt(j);
                        System.out.println("Category:" + ((CategoricBin)object).category + "   Values:" + ((CategoricBin)object).getBinStringValues());
                    }
                }
            }
        }
        catch (Exception exception) {
            if (CategoricDiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    protected void processCatTxSource(String string, String string2, String string3, Vector vector) {
    }

    void processTextTxSource(String string, String string2) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateBinBoundaries() throws SQLException {
        boolean bl = false;
        boolean bl2 = true;
        Connection connection = null;
        Statement statement = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            if (this.m_categoricalDiscretizationTableName == null) {
                this.m_categoricalDiscretizationTableName = ValidationUtil.createUniqueTableName(CATEGORIC_BIN_TABLE_PREFIX, connection, "");
            }
            DM4JTransformation.CREATE_BIN_CAT(connection, this.m_categoricalDiscretizationTableName, this.m_userSchemaName);
            Object[] objectArray = new Object[]{this.m_userSchemaName, this.m_categoricalDiscretizationTableName};
            String string = MessageFormat.format("INSERT INTO {0}.{1} VALUES (?, ?, ?)", objectArray);
            bl2 = connection.getAutoCommit();
            connection.setAutoCommit(false);
            statement = connection.prepareStatement(string);
            ((OraclePreparedStatement)statement).setExecuteBatch(100);
            for (int i = 0; i < this.getRowCount(); ++i) {
                String string2 = this.getAttributeName(i);
                Vector vector = this.getBinBounds(i);
                if (vector == null) continue;
                CategoricBin[] categoricBinArray = new CategoricBin[vector.size()];
                categoricBinArray = vector.toArray(categoricBinArray);
                for (int j = 0; j < categoricBinArray.length; ++j) {
                    for (int k = 0; k < categoricBinArray[j].values.size(); ++k) {
                        String string3 = (String)categoricBinArray[j].values.elementAt(k);
                        this.insertBinCatFreq((PreparedStatement)statement, string2, j + 1, string3);
                        bl = true;
                    }
                }
                this.insertBinCatFreq((PreparedStatement)statement, string2, categoricBinArray.length + 1, ResourceUtilities.getUILabel("HISTOGRAM_OTHER"));
                this.insertBinCatFreq((PreparedStatement)statement, string2, categoricBinArray.length + 1, null);
            }
            if (bl) {
                ((OraclePreparedStatement)statement).sendBatch();
                connection.commit();
            }
        }
        catch (Exception exception) {
            if (CategoricDiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            connection.setAutoCommit(bl2);
            if (statement != null) {
                statement.close();
            }
            connection.close();
        }
    }

    private void insertBinCatFreq(PreparedStatement preparedStatement, String string, int n, String string2) {
        block6: {
            int n2 = 1;
            try {
                preparedStatement.setString(n2++, string);
                if (string2 == null) {
                    preparedStatement.setNull(n2++, 12);
                } else {
                    preparedStatement.setString(n2++, string2);
                }
                if (string2 == null) {
                    preparedStatement.setNull(n2++, 12);
                } else {
                    preparedStatement.setString(n2++, string2);
                }
                preparedStatement.executeUpdate();
            }
            catch (Exception exception) {
                if (!CategoricDiscretizeDataSource.isDebug()) break block6;
                exception.printStackTrace();
            }
        }
    }

    static /* synthetic */ int access$008() {
        return A++;
    }

    static /* synthetic */ int access$000() {
        return A;
    }

    static {
        CategoricDiscretizeDataSource.items[COLUMN_NAMES.NAME] = ResourceUtilities.getUILabel("DISCRETIZATION_SETTINGS_ATTRIBUTE_LIST_NAME");
        CategoricDiscretizeDataSource.items[COLUMN_NAMES.MTYPE] = "Mining Attribute Type";
        CategoricDiscretizeDataSource.items[COLUMN_NAMES.DTYPE] = "Attribute Data Type";
        CategoricDiscretizeDataSource.items[COLUMN_NAMES.BINNUMBER] = "Bins Number";
        CategoricDiscretizeDataSource.items[COLUMN_NAMES.BINBOUNDS] = "Bin Boundaries";
        CategoricDiscretizeDataSource.items[COLUMN_NAMES.MISSING_PERCENT] = ResourceUtilities.getUILabel("MISSING_VALUES_PERCENT");
        CategoricDiscretizeDataSource.items[COLUMN_NAMES.TOTAL] = ResourceUtilities.getUILabel("DISCRETIZATION_SETTINGS_ATTRIBUTE_SIZE");
        CategoricDiscretizeDataSource.items[COLUMN_NAMES.DISTINCT] = ResourceUtilities.getUILabel("DISTINCT_COUNT");
        CategoricDiscretizeDataSource.items[COLUMN_NAMES.MODE] = ResourceUtilities.getUILabel("STATS_MODE");
        CategoricDiscretizeDataSource.items[COLUMN_NAMES.DROP_ATTRIBUTE] = ResourceUtilities.getUILabel("DROP_ATTRIBUTE");
        CategoricDiscretizeDataSource.items[COLUMN_NAMES.BINTYPE] = ResourceUtilities.getUILabel("BINNING_STRATEGY_GRID_TITLE");
        CategoricDiscretizeDataSource.items[COLUMN_NAMES.VIEW_DEFN] = "View Definition";
        CategoricDiscretizeDataSource.items[COLUMN_NAMES.DISPLAY_NAMES] = "Display Names";
        CategoricDiscretizeDataSource.items[COLUMN_NAMES.EXTRA_DATA_1] = "";
        CategoricDiscretizeDataSource.items[COLUMN_NAMES.EXTRA_DATA_2] = "";
        CategoricDiscretizeDataSource.items[COLUMN_NAMES.EXTRA_DATA_3] = "";
        CategoricDiscretizeDataSource.items[COLUMN_NAMES.EXTRA_DATA_4] = "";
        CategoricDiscretizeDataSource.items[COLUMN_NAMES.EXTRA_DATA_5] = "";
        CategoricDiscretizeDataSource.items[COLUMN_NAMES.DEFAULT_ALGORITHM] = "";
        CategoricDiscretizeDataSource.items[COLUMN_NAMES.COMPLEX_ATTRIBUTE] = "";
        CategoricDiscretizeDataSource.items[COLUMN_NAMES.SPARSITY_FLAG] = ResourceUtilities.getUILabel("DATA_USAGE_SPARSITY");
        CategoricDiscretizeDataSource.items[COLUMN_NAMES.EXTRA_DATA_6] = "";
    }

    public static interface COLUMN_NAMES {
        public static final int NAME = CategoricDiscretizeDataSource.access$008();
        public static final int MTYPE = CategoricDiscretizeDataSource.access$008();
        public static final int DTYPE = CategoricDiscretizeDataSource.access$008();
        public static final int BINNUMBER = CategoricDiscretizeDataSource.access$008();
        public static final int BINBOUNDS = CategoricDiscretizeDataSource.access$008();
        public static final int MISSING_PERCENT = CategoricDiscretizeDataSource.access$008();
        public static final int TOTAL = CategoricDiscretizeDataSource.access$008();
        public static final int DISTINCT = CategoricDiscretizeDataSource.access$008();
        public static final int MODE = CategoricDiscretizeDataSource.access$008();
        public static final int DROP_ATTRIBUTE = CategoricDiscretizeDataSource.access$008();
        public static final int BINTYPE = CategoricDiscretizeDataSource.access$008();
        public static final int VIEW_DEFN = CategoricDiscretizeDataSource.access$008();
        public static final int DISPLAY_NAMES = CategoricDiscretizeDataSource.access$008();
        public static final int EXTRA_DATA_1 = CategoricDiscretizeDataSource.access$008();
        public static final int EXTRA_DATA_2 = CategoricDiscretizeDataSource.access$008();
        public static final int EXTRA_DATA_3 = CategoricDiscretizeDataSource.access$008();
        public static final int EXTRA_DATA_4 = CategoricDiscretizeDataSource.access$008();
        public static final int EXTRA_DATA_5 = CategoricDiscretizeDataSource.access$008();
        public static final int DEFAULT_ALGORITHM = CategoricDiscretizeDataSource.access$008();
        public static final int COMPLEX_ATTRIBUTE = CategoricDiscretizeDataSource.access$008();
        public static final int SPARSITY_FLAG = CategoricDiscretizeDataSource.access$008();
        public static final int EXTRA_DATA_6 = CategoricDiscretizeDataSource.access$008();
        public static final int LAST = CategoricDiscretizeDataSource.access$000();
    }
}

