/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.activity.data.ActivityUtils;
import oracle.dmt.dm4j.activity.data.Column;
import oracle.dmt.dm4j.activity.data.Table;
import oracle.dmt.dm4j.browser.UserPreferences;
import oracle.dmt.dm4j.datasources.ComplexDataStructure;
import oracle.dmt.dm4j.datasources.DiscretizeDataSource;
import oracle.dmt.dm4j.datasources.SummarizeDataSource;
import oracle.dmt.dm4j.datasources.TXColumn;
import oracle.dmt.dm4j.wizard.director.transforms.TransformsDirector;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.odm.binning.Bin;
import oracle.dmt.odm.binning.BinningType;
import oracle.dmt.odm.binning.CategoricBin;
import oracle.dmt.odm.binning.DM4JTransformation;

public class CDSStatsDataSource
extends SummarizeDataSource {
    protected Hashtable m_AttributeNameValueMap = new Hashtable();
    Vector m_numericAttributeNames = new Vector();
    Hashtable m_numericNameIDMap = new Hashtable();
    Vector m_categoricAttributeNames = new Vector();
    Hashtable m_categoricNameIDMap = new Hashtable();
    Hashtable m_numericNameIDMapTX = new Hashtable();
    Vector m_categoricAttributesTX = new Vector();
    Vector m_numericAttributesTX = new Vector();
    Hashtable m_categoricNameIDMapTX = new Hashtable();
    private int m_casecount = -1;
    private Table m_twoDdataSource;
    static String SQL_SAMPLING_VIEW_TX = " select tx.* from {0} tx, {1} sampled_view where sampled_view.{2} = tx.{3}";

    public CDSStatsDataSource(Connection connection, ComplexDataStructure complexDataStructure, Table table) throws Exception {
        this(connection, complexDataStructure);
        this.m_twoDdataSource = table;
    }

    public CDSStatsDataSource(Connection connection, ComplexDataStructure complexDataStructure) throws Exception {
        super(connection);
        this.m_sampledInputCDS = complexDataStructure;
        this.m_preferences = UserPreferences.getInstance();
        this.setLabels(false);
        this.m_userSchemaName = this.m_sampledInputCDS.getCaseSchema();
        this.m_resultViewName = ValidationUtil.createUniqueTableName(RESULT_VIEW_NAME, connection, "");
        this.m_bRemoveResultView = true;
        String string = this.m_sampledInputCDS.getCaseTable();
        String string2 = this.m_sampledInputCDS.getCaseSchema();
        if (string != null && string.length() != 0) {
            this.m_sDataLocation = string2 != null && string2.length() != 0 ? "\"" + string2 + "\".\"" + string + "\"" : "\"" + string + "\"";
            this.m_tableName = string;
            this.m_dataSourceSchemaName = string2;
        } else {
            this.m_isTransactional = true;
            this.m_bSingleMetric = this.m_sampledInputCDS.isSingleMetric();
            if (!this.m_bSingleMetric) {
                this.m_sDataLocation = this.m_sampledInputCDS.getDataLocation();
                this.m_userSchemaName = this.m_sampledInputCDS.getTXColumn().getTxSchemaName();
                this.m_samplingTableName = ValidationUtil.createUniqueTableName(SAMPLING_TABLE_PREFIX, connection, "");
                this.m_attributeMapping = this.m_sampledInputCDS.getAttributeNameColumn();
                this.m_valueMapping = this.m_sampledInputCDS.getValueColumn();
                this.m_seqIdMapping = this.m_sampledInputCDS.getCaseIdColumn();
                this.m_numericalDiscretizationTableName = ValidationUtil.createUniqueTableName(NUMERIC_BIN_TABLE_PREFIX, connection, "");
                this.m_categoricalDiscretizationTableName = ValidationUtil.createUniqueTableName(CATEGORIC_BIN_TABLE_PREFIX, connection, "");
                DM4JTransformation.createPhysicalTables(connection, this.m_numericalDiscretizationTableName, this.m_categoricalDiscretizationTableName, this.m_userSchemaName);
                this.m_txSampledViewDefinition = this.createTXViewDefinition(this.m_sampledInputCDS.getDataLocation(), this.m_userSchemaName, this.m_resultViewName);
                this.m_txViewDefinition = this.createTXViewDefinition(this.m_sDataLocation, this.m_userSchemaName, this.m_resultViewName);
            }
        }
    }

    public String getSampledDataLocation() {
        String string = null;
        if (this.m_sampledInputCDS != null) {
            try {
                String string2 = this.m_sampledInputCDS.getCaseTable();
                string = string2 != null ? DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(this.m_sampledInputCDS.getCaseSchema())) + "." + DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(string2)) : this.m_sampledInputCDS.getDataLocation();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return string;
        }
        return null;
    }

    protected void createData() throws Exception {
        if (this.m_isTransactional && !this.m_bSingleMetric) {
            this.createDataFromTXSource();
        } else {
            this.createDataFromCDS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createDataFromCDS() throws Exception {
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            TreeMap treeMap = this.m_sampledInputCDS.getColumnMap();
            if (treeMap != null && !treeMap.isEmpty()) {
                Set set = treeMap.keySet();
                for (String string : set) {
                    TXColumn tXColumn = (TXColumn)treeMap.get(string);
                    if (tXColumn == null) continue;
                    if (tXColumn.getIsSingleMetrics()) {
                        this.processSingleMetricTxData(connection, tXColumn.getTxTableName(), tXColumn.getTxSchemaName(), tXColumn.getNameColumn(), tXColumn.getValueColumn(), tXColumn.getUniqueName());
                        continue;
                    }
                    throw new Exception();
                }
            }
            if (this.m_twoDdataSource != null) {
                this.createDataFrom2DSource();
            } else {
                this.createDataFrom2DSource(connection);
            }
            this.addStatistics(connection);
        }
        catch (Exception exception) {
            if (CDSStatsDataSource.isDebug()) {
                System.out.println(exception);
            }
        }
        finally {
            if (connection != null) {
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    protected Hashtable getMiningTypes() {
        Hashtable<String, DiscretizeDataSource.DataInfo> hashtable = new Hashtable<String, DiscretizeDataSource.DataInfo>();
        LinkedHashMap linkedHashMap = this.m_twoDdataSource.getColumns();
        Collection collection = linkedHashMap.values();
        Object[] objectArray = collection.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            String string;
            String string2;
            boolean bl = false;
            String string3 = ((Column)objectArray[i]).getName();
            String string4 = ((Column)objectArray[i]).getDataType();
            if (string4.compareTo("NUMBER") == 0) {
                string2 = "numerical";
                string = string4;
            } else if (string4.compareTo("VARCHAR2") == 0 || string4.compareTo("CHAR") == 0 || string4.compareTo("NVARCHAR2") == 0 || string4.compareTo("NCHAR") == 0) {
                string2 = "categorical";
                string = string4;
            } else if (string4.compareTo("FLOAT") == 0) {
                string2 = "numerical";
                string = string4;
            } else if (ActivityUtils.isTextDataType(string3)) {
                string2 = "text";
                string = string4;
            } else {
                string = "";
                string2 = "";
                bl = true;
            }
            if (bl) continue;
            hashtable.put(string3, new DiscretizeDataSource.DataInfo(this, string2, string));
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createDataFrom2DSource(Connection connection) throws Exception {
        if (this.m_isTransactional) {
            return;
        }
        Hashtable hashtable = this.getMiningType2D();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = "SELECT COLUMN_NAME, DATA_TYPE FROM all_tab_columns WHERE owner = '" + this.getSrcSchemaName() + "' and table_name = '" + TransformsDirector.getReplacedString(this.getSrcTableName(), "'", "''") + "'" + " order by COLUMN_NAME";
        try {
            preparedStatement = connection.prepareStatement(string);
            resultSet = preparedStatement.executeQuery();
            int n = this.getRowCount();
            while (resultSet.next()) {
                String string2 = resultSet.getString("DATA_TYPE");
                String string3 = resultSet.getString("COLUMN_NAME");
                this.m_tableColumns.add(string3);
                if (0 != string2.compareTo("NUMBER") && 0 != string2.compareTo("CHAR") && 0 != string2.compareTo("VARCHAR2") && 0 != string2.compareTo("FLOAT") && 0 != string2.compareTo("NVARCHAR2") && 0 != string2.compareTo("NCHAR")) continue;
                this.addRows(n, 1);
                this.setAttributeName(n, string3);
                DiscretizeDataSource.DataInfo dataInfo = (DiscretizeDataSource.DataInfo)hashtable.get(string3);
                this.setData(DiscretizeDataSource.COLUMN_NAMES.MTYPE, n, dataInfo == null ? null : dataInfo.m_AttrType);
                this.setData(DiscretizeDataSource.COLUMN_NAMES.DTYPE, n, dataInfo == null ? null : dataInfo.m_DataType);
                this.setData(DiscretizeDataSource.COLUMN_NAMES.BINNUMBER, n, new Integer(DEFAULT_BIN_NUMBER));
                if (0 == string2.compareTo("NUMBER") || 0 == string2.compareTo("FLOAT")) {
                    this.m_numericAttributeNames.add(string3);
                    this.m_numericNameIDMap.put(string3, new Integer(n));
                    ++n;
                    continue;
                }
                if (0 != string2.compareTo("CHAR") && 0 != string2.compareTo("VARCHAR2") && 0 != string2.compareTo("NCHAR") && 0 != string2.compareTo("NVARCHAR2")) continue;
                this.m_categoricAttributeNames.add(string3);
                this.m_categoricNameIDMap.put(string3, new Integer(n));
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                resultSet.close();
                preparedStatement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSingleMetricTxData(Connection connection, String string, String string2, String string3, String string4, String string5) throws SQLException, Exception {
        String string6 = "SELECT c.COLUMN_NAME, c.DATA_TYPE, con.CONSTRAINT_TYPE FROM all_tab_columns c, (SELECT cn.OWNER, cn.TABLE_NAME, cn.COLUMN_NAME, cd.CONSTRAINT_TYPE FROM all_cons_columns cn, all_constraints cd WHERE cn.OWNER = cd.OWNER AND cn.TABLE_NAME = cd.TABLE_NAME AND cn.CONSTRAINT_NAME = cd.CONSTRAINT_NAME AND 'P' = cd.CONSTRAINT_TYPE AND 'ENABLED' = cd.STATUS) con WHERE c.OWNER = ? AND c.TABLE_NAME = ? AND c.COLUMN_NAME = ? AND c.OWNER = con.OWNER(+) AND c.TABLE_NAME = con.TABLE_NAME(+) AND c.COLUMN_NAME = con.COLUMN_NAME(+) ";
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        try {
            callableStatement = connection.prepareCall(string6);
            int n = 1;
            String string7 = "";
            callableStatement.setString(n++, string2);
            callableStatement.setString(n++, string);
            callableStatement.setString(n++, string4);
            resultSet = callableStatement.executeQuery();
            int n2 = this.getRowCount();
            if (resultSet.next()) {
                String string8;
                String string9 = resultSet.getString("DATA_TYPE");
                if (string9.compareTo("NUMBER") == 0) {
                    string8 = "numerical";
                    string7 = "DM_NESTED_NUMERICALS";
                } else if (string9.compareTo("VARCHAR2") == 0 || string9.compareTo("CHAR") == 0) {
                    string8 = "categorical";
                    string7 = "DM_NESTED_CATEGORICALS";
                } else if (string9.compareTo("FLOAT") == 0) {
                    string8 = "numerical";
                    string7 = string9;
                } else {
                    string7 = string9;
                    string8 = "notApplicable";
                }
                this.addRows(n2, 1);
                this.setData(DiscretizeDataSource.COLUMN_NAMES.NAME, n2, string5);
                this.setData(DiscretizeDataSource.COLUMN_NAMES.COMPLEX_ATTRIBUTE, n2, string5);
                this.m_tableColumns.add(string5);
                this.setAttributeName(n2, string5);
                this.addColumnNamesForStats(this.m_numericAttributesTX, this.m_numericNameIDMapTX, this.m_categoricAttributesTX, this.m_categoricNameIDMapTX, string5, string7, string8, n2);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (callableStatement != null) {
                callableStatement.close();
            }
        }
    }

    protected void addStatistics(Connection connection) {
        this.getTotalTableRowCount(connection);
        this.addAllStats(connection);
        this.m_numericNameIDMap.clear();
        this.m_numericAttributeNames.clear();
        this.m_categoricAttributeNames.clear();
        this.m_categoricNameIDMap.clear();
        if (!this.m_numericAttributesTX.isEmpty()) {
            this.getSampledDataLocation();
            for (int i = 0; i < this.m_numericAttributesTX.size(); ++i) {
                String string = (String)this.m_numericAttributesTX.elementAt(i);
                this.addNumericStatsTX(connection, string, this.m_numericNameIDMapTX);
            }
        }
        if (!this.m_categoricAttributesTX.isEmpty()) {
            String string = (String)this.m_categoricAttributesTX.elementAt(0);
            this.addCategoricStatsTX(connection, string, this.m_categoricNameIDMapTX);
        }
        this.m_numericNameIDMapTX.clear();
        this.m_categoricNameIDMapTX.clear();
        this.m_numericAttributesTX.clear();
        this.m_categoricAttributesTX.clear();
    }

    public String getComplexAttributeInfo(String string) {
        String string2 = null;
        int n = this.getAttributeRow(string);
        if (n >= 0) {
            string2 = (String)this.getData(DiscretizeDataSource.COLUMN_NAMES.COMPLEX_ATTRIBUTE, n);
        }
        return string2;
    }

    protected void addColumnNamesForStats(Vector vector, Hashtable hashtable, Vector vector2, Hashtable hashtable2, String string, String string2, String string3, int n) {
        if (string2.equals("FLOAT") || string2.equals("NUMBER") || string2.equals("DM_NESTED_NUMERICALS")) {
            if (string3.equals("categorical")) {
                vector2.add(string);
                hashtable2.put(string, new Integer(n));
            } else if (string3.equals("numerical")) {
                vector.add(string);
                hashtable.put(string, new Integer(n));
            }
        } else if ((string2.equals("CHAR") || string2.equals("VARCHAR2") || string2.equals("DM_NESTED_CATEGORICALS")) && string3.equals("categorical")) {
            vector2.add(string);
            hashtable2.put(string, new Integer(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNumericStatsTX(Connection connection, String string, Hashtable hashtable) {
        String string2 = this.getComplexAttributeInfo(string);
        TXColumn tXColumn = this.m_sampledInputCDS.getTXColumn(string2);
        if (tXColumn == null) {
            return;
        }
        String string3 = "SELECT count({0}) as N, count(distinct {0}) as COUNT, sum((abs({0})) - (floor({0}))) as FLOAT_IND, MIN({0}) MINV, MAX({0}) MAXV, AVG({0}) AVGV, VARIANCE({0}) as Variance from {1}";
        String string4 = MessageFormat.format(string3, tXColumn.getValueColumn(), tXColumn.getDataLocation());
        Statement statement = null;
        ResultSet resultSet = null;
        String string5 = null;
        String string6 = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string4);
            while (resultSet.next()) {
                Integer n = (Integer)hashtable.get(string);
                if (n == null) continue;
                int n2 = resultSet.getInt("N");
                this.setData(DiscretizeDataSource.COLUMN_NAMES.TOTAL, n, new Integer(n2));
                int n3 = resultSet.getInt("COUNT");
                double d = resultSet.getDouble("MAXV");
                this.setData(DiscretizeDataSource.COLUMN_NAMES.MAX, n, new Double(d));
                d = resultSet.getDouble("MINV");
                this.setData(DiscretizeDataSource.COLUMN_NAMES.MIN, n, new Double(d));
                d = resultSet.getDouble("AVGV");
                this.setData(DiscretizeDataSource.COLUMN_NAMES.AVG, n, new Double(d));
                d = resultSet.getDouble("Variance");
                this.setData(DiscretizeDataSource.COLUMN_NAMES.VAR, n, new Double(d));
                d = Math.sqrt(d);
                this.setData(DiscretizeDataSource.COLUMN_NAMES.STDDEV, n, new Double(d));
                double d2 = resultSet.getDouble("FLOAT_IND");
                if (d2 != 0.0) {
                    string5 = "FLOAT";
                    string6 = "numerical";
                } else {
                    string5 = "NUMBER";
                    string6 = "numerical";
                }
                this.setData(DiscretizeDataSource.COLUMN_NAMES.MTYPE, n, string6);
                this.setData(DiscretizeDataSource.COLUMN_NAMES.DTYPE, n, string5);
                this.setData(DiscretizeDataSource.COLUMN_NAMES.BINNUMBER, n, new Integer(DEFAULT_BIN_NUMBER));
            }
        }
        catch (Exception exception) {
            if (CDSStatsDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCategoricStatsTX(Connection connection, String string, Hashtable hashtable) {
        String string2 = this.getComplexAttributeInfo(string);
        TXColumn tXColumn = this.m_sampledInputCDS.getTXColumn(string2);
        if (tXColumn == null) {
            return;
        }
        String string3 = "SELECT count({0}) as N from {1}";
        String string4 = MessageFormat.format(string3, tXColumn.getValueColumn(), tXColumn.getDataLocation());
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string4);
            while (resultSet.next()) {
                Integer n = (Integer)hashtable.get(string);
                if (n == null) continue;
                int n2 = resultSet.getInt("N");
                this.setData(DiscretizeDataSource.COLUMN_NAMES.TOTAL, n, new Integer(n2));
                this.setData(DiscretizeDataSource.COLUMN_NAMES.MTYPE, n, "categorical");
                this.setData(DiscretizeDataSource.COLUMN_NAMES.DTYPE, n, "VARCHAR2");
                this.setData(DiscretizeDataSource.COLUMN_NAMES.BINNUMBER, n, new Integer(DEFAULT_BIN_NUMBER));
            }
        }
        catch (Exception exception) {
            if (CDSStatsDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    public BinningType getBinningType(int n) {
        return BinningType.NONE;
    }

    public boolean isAttributeBinned(int n) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int get2DDistinctCount(Connection connection, String string) {
        String string2 = this.getComplexAttributeInfo(string);
        if (string2 == null) {
            return super.get2DDistinctCount(connection, string);
        }
        TXColumn tXColumn = this.m_sampledInputCDS.getTXColumn(string2);
        if (tXColumn == null) {
            return 0;
        }
        String string3 = "select count ( distinct {0} ) from {1}";
        String string4 = MessageFormat.format(string3, tXColumn.getValueColumn(), tXColumn.getDataLocation());
        Statement statement = null;
        ResultSet resultSet = null;
        int n = 0;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string4);
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
        }
        catch (Exception exception) {
            if (CDSStatsDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getTopNStats(Connection connection, int n, int n2) {
        String string = this.getAttributeName(n);
        String string2 = this.getComplexAttributeInfo(string);
        if (string2 == null) {
            super.getTopNStats(connection, n, n2);
            return;
        }
        TXColumn tXColumn = this.m_sampledInputCDS.getTXColumn(string2);
        if (tXColumn == null) {
            return;
        }
        String string3 = String.valueOf(n2);
        Statement statement = null;
        ResultSet resultSet = null;
        Vector<CategoricBin> vector = new Vector<CategoricBin>();
        try {
            String string4 = MessageFormat.format("SELECT * FROM (SELECT {0} FROM {1} GROUP BY {0} HAVING {0} IS NOT NULL ORDER BY COUNT(*) DESC, {0} DESC) WHERE rownum <= {2}", tXColumn.getValueColumn(), tXColumn.getDataLocation(), string3);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string4);
            while (resultSet.next()) {
                Vector<String> vector2 = new Vector<String>();
                String string5 = resultSet.getString(1);
                vector2.add(string5);
                CategoricBin categoricBin = new CategoricBin(string5, vector2);
                vector.add(categoricBin);
            }
            this.setBinBounds(n, vector);
        }
        catch (Exception exception) {
            if (CDSStatsDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getStatsMode2D(Connection connection, String string) {
        String string2 = this.getComplexAttributeInfo(string);
        if (string2 == null) {
            return super.getStatsMode2D(connection, string);
        }
        TXColumn tXColumn = this.m_sampledInputCDS.getTXColumn(string2);
        if (tXColumn == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("SELECT  ");
        String string3 = MessageFormat.format("stats_mode({0}) ", tXColumn.getValueColumn());
        stringBuffer.append(string3);
        String string4 = MessageFormat.format(" from ({0} t)", tXColumn.getDataLocation());
        stringBuffer.append(string4);
        Statement statement = null;
        ResultSet resultSet = null;
        String string5 = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet.next()) {
                string5 = resultSet.getString(1);
            }
        }
        catch (Exception exception) {
            if (CDSStatsDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
        return string5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getCategoricAttributeFrequency(Connection connection, int n, String string, String string2) {
        Object object;
        Object object2;
        String string3 = this.getComplexAttributeInfo(string);
        if (string3 == null) {
            return super.getCategoricAttributeFrequency(connection, n, string, string2);
        }
        TXColumn tXColumn = this.m_sampledInputCDS.getTXColumn(string3);
        if (tXColumn == null) {
            return null;
        }
        String[] stringArray = new String[]{"select {0} DISPLAY_NAME, count(*) FREQUENCY ", "from {1} group by {0} order by FREQUENCY desc"};
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            object2 = MessageFormat.format(stringArray[i], tXColumn.getValueColumn(), tXColumn.getDataLocation());
            stringBuffer.append((String)object2);
        }
        Hashtable<Integer, CategoricBin> hashtable = new Hashtable<Integer, CategoricBin>();
        object2 = this.getBinBounds(n);
        int n2 = ((Vector)object2).size();
        int[] nArray = new int[n2 + 1];
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(stringBuffer.toString());
            object = preparedStatement.executeQuery();
            boolean bl = false;
            while (object.next()) {
                String string4 = object.getString("DISPLAY_NAME");
                if (string4 == null) {
                    string4 = ResourceUtilities.getUILabel("HISTOGRAM_NULL_VALUE");
                }
                int n3 = object.getInt("FREQUENCY");
                boolean bl2 = false;
                for (int i = 0; i < n2; ++i) {
                    CategoricBin categoricBin = (CategoricBin)((Vector)object2).elementAt(i);
                    for (int j = 0; j < categoricBin.values.size(); ++j) {
                        if (0 != string4.compareTo((String)categoricBin.values.elementAt(j))) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl2) continue;
                    int n4 = i;
                    nArray[n4] = nArray[n4] + n3;
                    break;
                }
                if (bl2) continue;
                int n5 = n2;
                nArray[n5] = nArray[n5] + n3;
            }
            for (int i = 0; i < n2; ++i) {
                CategoricBin categoricBin = (CategoricBin)((Vector)object2).elementAt(i);
                hashtable.put(new Integer(i), categoricBin);
            }
            String string5 = ResourceUtilities.getUILabel("HISTOGRAM_OTHER");
            Vector vector = this.getOther((Vector)object2, n);
            hashtable.put(new Integer(n2), new CategoricBin(string5, vector));
        }
        catch (Exception exception) {
            if (CDSStatsDataSource.isDebug()) {
                System.out.println(exception);
            }
            hashtable.clear();
        }
        finally {
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {}
        }
        if (hashtable.isEmpty()) {
            return null;
        }
        this.setDisplayNames(n, hashtable);
        this.setNumberOfBins(n, n2);
        object = this.getBinType(n);
        this.setBinType(n, (String)object, n2);
        return nArray;
    }

    public StringBuffer getSingleNumericAttributeViewDefinition(Connection connection, int n, boolean bl) {
        if (this.m_isTransactional && !this.m_bSingleMetric) {
            return super.getSingleNumericAttributeViewDefinition(connection, n, bl);
        }
        StringBuffer stringBuffer = null;
        try {
            Vector<String> vector = new Vector<String>();
            vector.add(this.getAttributeName(n));
            stringBuffer = this.createNumericOpenEndedViewDefinition(vector, n, this.getSampledDataLocation(), this.m_userSchemaName, this.m_resultViewName, bl);
        }
        catch (Exception exception) {
            if (CDSStatsDataSource.isDebug()) {
                System.out.println(exception);
            }
            this.setViewDefinition(n, null);
        }
        return stringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getNumericFrequency(Connection connection, String string, int n, boolean bl) {
        String string2;
        Serializable serializable;
        Object object;
        String string3 = this.getComplexAttributeInfo(string);
        if (string3 == null) {
            return super.getNumericFrequency(connection, string, n, bl);
        }
        TXColumn tXColumn = this.m_sampledInputCDS.getTXColumn(string3);
        if (tXColumn == null) {
            return null;
        }
        if (!this.isNumeric(n)) {
            return this.getCategoricAttributeFrequency(connection, n, string, this.getSampledDataLocation());
        }
        Statement statement = null;
        ResultSet resultSet = null;
        int[] nArray = null;
        StringBuffer stringBuffer = null;
        Vector<Integer> vector = new Vector<Integer>();
        Vector<String> vector2 = new Vector<String>();
        int n2 = 0;
        this.m_nullCount = 0;
        try {
            stringBuffer = this.getViewDefinition(n);
            if (stringBuffer == null) {
                stringBuffer = this.getSingleNumericAttributeViewDefinition(connection, n, bl);
            }
            if (stringBuffer == null) {
                int[] nArray2 = nArray;
                return nArray2;
            }
            object = null;
            object = !this.isLabels() ? MessageFormat.format(DiscretizeDataSource.HISTOGRAM_VALUES[0], "\"" + this.getColumnName(string) + "\"") : MessageFormat.format(DiscretizeDataSource.HISTOGRAM_VALUES_LABELS[0], "\"" + this.getColumnName(string) + "\"", this.prepareDecodeSatement(n));
            serializable = new StringBuffer((String)object);
            int n3 = stringBuffer.toString().indexOf("SELECT");
            StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.substring(n3));
            ((StringBuffer)serializable).append(stringBuffer2);
            object = !this.isLabels() ? MessageFormat.format(DiscretizeDataSource.HISTOGRAM_VALUES[1], "\"" + this.getColumnName(string) + "\"") : MessageFormat.format(DiscretizeDataSource.HISTOGRAM_VALUES_LABELS[1], "\"" + this.getColumnName(string) + "\"");
            ((StringBuffer)serializable).append((String)object);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(((StringBuffer)serializable).toString());
            int n4 = -1;
            String string4 = null;
            while (resultSet.next()) {
                string2 = resultSet.getString("BIN_NUMBER");
                int n5 = resultSet.getInt("FREQUENCY");
                if (string2 != null) {
                    if (-1 != string2.indexOf(">=")) {
                        n4 = n5;
                        string4 = string2;
                        continue;
                    }
                    ++n2;
                    vector.add(new Integer(n5));
                    vector2.add(string2);
                    continue;
                }
                this.m_nullCount = n5;
            }
            if (n4 != -1) {
                ++n2;
                vector.add(new Integer(n4));
                vector2.add(string4);
            }
        }
        catch (Exception exception) {
            if (CDSStatsDataSource.isDebug()) {
                System.out.println(exception);
            }
            nArray = null;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
        if (vector == null || vector.isEmpty()) {
            return null;
        }
        object = this.getAllCategorytoRangeList(n);
        serializable = null;
        Integer[] integerArray = null;
        if (object != null && !((Vector)object).isEmpty()) {
            int n6;
            serializable = new Vector();
            integerArray = new Integer[((Vector)object).size()];
            for (n6 = 0; n6 < ((Vector)object).size(); ++n6) {
                integerArray[n6] = 0;
                ((Vector)serializable).add(DM4JStringUtils.trimSingleQuotes((String)((Vector)object).elementAt(n6)));
            }
            block16: for (n6 = 0; n6 < ((Vector)serializable).size(); ++n6) {
                String string5 = (String)((Vector)serializable).elementAt(n6);
                for (int i = 0; i < vector2.size(); ++i) {
                    string2 = (String)vector2.elementAt(i);
                    if (!string2.equals(string5)) continue;
                    integerArray[n6] = (Integer)vector.elementAt(i);
                    continue block16;
                }
            }
        }
        if (serializable != null) {
            this.setNumberOfNonNulls(n, ((Vector)serializable).size());
            this.setBinCategories(n, new Vector(serializable));
        } else {
            this.setNumberOfNonNulls(n, n2);
            this.setBinCategories(n, vector2);
        }
        if (!this.isAttributeBinned(n)) {
            this.setNumberOfBins(n, n2);
            String string6 = this.getBinType(n);
            this.setBinType(n, string6, n2);
        }
        if (integerArray == null) {
            nArray = new int[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                Integer n7 = (Integer)vector.elementAt(i);
                nArray[i] = n7;
            }
        } else {
            nArray = new int[integerArray.length];
            for (int i = 0; i < integerArray.length; ++i) {
                Integer n8 = integerArray[i];
                nArray[i] = n8;
            }
        }
        return nArray;
    }

    protected StringBuffer createNumericOpenEndedViewDefinition(Vector vector, int n, String string, String string2, String string3, boolean bl) {
        Object object;
        String string4;
        int n2;
        Bin[] binArray;
        if (this.isLabels()) {
            return this.createNumericOpenEndedViewDefinitionLabels(vector, n, string, string2, string3);
        }
        if (this.m_isTransactional && !this.m_bSingleMetric) {
            return this.createNumericOpenEndedViewDefinitionTX(vector, new int[]{n}, string2, string3, bl);
        }
        StringBuffer stringBuffer = new StringBuffer("CREATE VIEW " + string2 + "." + string3 + " AS SELECT " + "\n");
        int n3 = vector.size();
        DiscretizeDataSource.BinBoundMap binBoundMap = new DiscretizeDataSource.BinBoundMap(n3);
        Hashtable<String, BinningType> hashtable = new Hashtable<String, BinningType>();
        String string5 = this.getAttributeName(n);
        string5 = this.getColumnName(string5);
        hashtable.put(string5, this.getBinningType(n));
        Vector vector2 = this.getBinBounds(n);
        if (vector2 != null && !vector2.isEmpty()) {
            binArray = new Bin[vector2.size()];
            binArray = vector2.toArray(binArray);
            for (int i = 0; i < binArray.length; ++i) {
                n2 = binArray[i].getBinNumber();
                double d = binArray[i].getLowerBound();
                double d2 = binArray[i].getUpperBound();
                binBoundMap.addBinBound("\"" + string5 + "\"", new DiscretizeDataSource.BinBound(n2, d, d2));
            }
        }
        binArray = new Vector();
        Vector<String> vector3 = new Vector<String>();
        for (n2 = 0; n2 < n3; ++n2) {
            String string6 = (String)vector.elementAt(n2);
            string4 = this.getComplexAttributeInfo(string6);
            if (string4 != null) {
                binArray.add(string6);
                continue;
            }
            vector3.add(string6);
        }
        for (n2 = 0; n2 < vector3.size(); ++n2) {
            String string7 = (String)vector.elementAt(n2);
            string4 = "\"" + this.getColumnName(string7) + "\"";
            String string8 = (String)vector3.elementAt(n2);
            object = (BinningType)hashtable.get(this.getColumnName(string8));
            if (binBoundMap.isEmpty(string4)) {
                stringBuffer.append(string4);
            } else if (binBoundMap.size(string4) == 1) {
                stringBuffer.append("( CASE ");
                stringBuffer.append("WHEN ");
                stringBuffer.append(string4);
                stringBuffer.append(" is not null then 1 end) " + string4);
                String string9 = ResourceUtilities.getUILabel("HISTOGRAM_NOT_NULL");
                Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
                Vector<String> vector4 = new Vector<String>();
                hashtable2.put(CDSStatsDataSource.appendSingleQuotes("1"), string9);
                vector4.add(CDSStatsDataSource.appendSingleQuotes("1"));
                this.setMapCategorytoRange(this.getAttributeRow(string7), hashtable2);
                this.setAllCategorytoRangeList(this.getAttributeRow(string7), vector4);
            } else if (((BinningType)object).equal(BinningType.QTILE)) {
                this.prepareQtileDefinition(stringBuffer, binBoundMap, string4, string7);
            } else {
                this.prepareEqWidthDefinition(stringBuffer, binBoundMap, string4, string7);
            }
            if (n2 < vector3.size() - 1) {
                stringBuffer.append(",");
            }
            stringBuffer.append("\n");
        }
        if (!vector3.isEmpty()) {
            stringBuffer.append(" FROM " + string);
            binBoundMap.clear();
            return stringBuffer;
        }
        for (n2 = 0; n2 < binArray.size(); ++n2) {
            String string10;
            String string11 = (String)binArray.elementAt(n2);
            int n4 = this.getAttributeRow(string11);
            if (n != n4 || (string10 = this.getComplexAttributeInfo(string11)) == null || (object = this.m_sampledInputCDS.getTXColumn(string10)) == null) continue;
            try {
                stringBuffer = this.processNumTXSource(string11, ((TXColumn)object).getValueColumn(), string10, binBoundMap, hashtable);
                continue;
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
        binBoundMap.clear();
        return stringBuffer;
    }

    protected StringBuffer processNumTXSource(String string, String string2, String string3, Object object, Hashtable hashtable) throws Exception {
        TXColumn tXColumn;
        int n = this.getAttributeRow(string);
        if (n == -1) {
            return null;
        }
        TXColumn tXColumn2 = this.m_sampledInputCDS.getTXColumn(string3);
        if (tXColumn2 == null) {
            return null;
        }
        if (this.m_sampledOutputCDS == null) {
            this.m_sampledOutputCDS = ComplexDataStructure.createOutputComplexDataStructure(this.m_sampledInputCDS.getName() + "_RESULT", this.m_sampledInputCDS, this.m_resultViewName);
        }
        if ((tXColumn = this.m_sampledOutputCDS.getTXColumn(string3)) == null) {
            return null;
        }
        DiscretizeDataSource.BinBoundMap binBoundMap = (DiscretizeDataSource.BinBoundMap)object;
        String string4 = tXColumn2.getNameColumn();
        String string5 = tXColumn2.getTxColumnCaseId();
        String string6 = tXColumn2.getUniqueName();
        if (0 == string6.compareTo(string2)) {
            string6 = string4;
        }
        StringBuffer stringBuffer = new StringBuffer("CREATE VIEW " + tXColumn.getDataLocation() + " AS SELECT " + (string4 == null ? "" : (DM4JStringUtils.isDoubleQuotedString(string4) ? string4 : DM4JStringUtils.addDoubleQuotes(string4)) + " AS " + (DM4JStringUtils.isDoubleQuotedString(string6) ? string6 : DM4JStringUtils.addDoubleQuotes(string6)) + ",") + (DM4JStringUtils.isDoubleQuotedString(string5) ? string5 : DM4JStringUtils.addDoubleQuotes(string5)) + "," + "\n");
        String string7 = "\"" + string2 + "\"";
        String string8 = "\"" + string + "\"";
        BinningType binningType = (BinningType)hashtable.get(string2);
        if (binBoundMap.isEmpty(string7)) {
            stringBuffer.append(string7);
        } else if (binBoundMap.size(string8) == 1) {
            stringBuffer.append("( CASE ");
            stringBuffer.append("WHEN ");
            stringBuffer.append(string7);
            stringBuffer.append(" is not null then 1 end) " + string7);
            String string9 = ResourceUtilities.getUILabel("HISTOGRAM_NOT_NULL");
            Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
            Vector<String> vector = new Vector<String>();
            hashtable2.put(DiscretizeDataSource.appendSingleQuotes("1"), string9);
            vector.add(DiscretizeDataSource.appendSingleQuotes("1"));
            this.setMapCategorytoRange(this.getAttributeRow(string7), hashtable2);
            this.setAllCategorytoRangeList(this.getAttributeRow(string7), vector);
        } else if (binningType.equal(BinningType.QTILE)) {
            this.prepareQtileDefinitionLabels(stringBuffer, binBoundMap, string7, string);
        } else {
            this.prepareEqWidthDefinitionLabels(stringBuffer, binBoundMap, string7, string);
        }
        stringBuffer.append("\n");
        stringBuffer.append(" FROM " + tXColumn2.getDataLocation());
        this.setViewDefinition(n, stringBuffer);
        tXColumn.setSqlQuery(stringBuffer);
        return stringBuffer;
    }

    public String getColumnName(String string) {
        if (this.m_AttributeNameValueMap.isEmpty()) {
            return string;
        }
        String string2 = (String)this.m_AttributeNameValueMap.get(string);
        return string2 != null ? string2 : string;
    }

    protected StringBuffer createNumericOpenEndedViewDefinitionLabels(Vector vector, int n, String string, String string2, String string3) {
        Object object;
        String string4;
        int n2;
        Bin[] binArray;
        StringBuffer stringBuffer = new StringBuffer("CREATE VIEW " + string2 + "." + string3 + " AS SELECT " + "\n");
        int n3 = vector.size();
        DiscretizeDataSource.BinBoundMap binBoundMap = new DiscretizeDataSource.BinBoundMap(n3);
        Hashtable<String, BinningType> hashtable = new Hashtable<String, BinningType>();
        String string5 = this.getAttributeName(n);
        string5 = this.getColumnName(string5);
        hashtable.put(string5, this.getBinningType(n));
        Vector vector2 = this.getBinBounds(n);
        if (vector2 != null && !vector2.isEmpty()) {
            binArray = new Bin[vector2.size()];
            binArray = vector2.toArray(binArray);
            for (int i = 0; i < binArray.length; ++i) {
                n2 = binArray[i].getBinNumber();
                double d = binArray[i].getLowerBound();
                double d2 = binArray[i].getUpperBound();
                binBoundMap.addBinBound("\"" + string5 + "\"", new DiscretizeDataSource.BinBound(n2, d, d2));
            }
        }
        binArray = new Vector();
        Vector<String> vector3 = new Vector<String>();
        for (n2 = 0; n2 < n3; ++n2) {
            String string6 = (String)vector.elementAt(n2);
            string4 = this.getComplexAttributeInfo(string6);
            if (string4 != null) {
                binArray.add(string6);
                continue;
            }
            vector3.add(string6);
        }
        for (n2 = 0; n2 < vector3.size(); ++n2) {
            String string7 = (String)vector.elementAt(n2);
            string4 = "\"" + this.getColumnName(string7) + "\"";
            String string8 = (String)vector3.elementAt(n2);
            object = (BinningType)hashtable.get(this.getColumnName(string8));
            if (binBoundMap.isEmpty(string4)) {
                stringBuffer.append(string4);
            } else if (binBoundMap.size(string4) == 1) {
                stringBuffer.append("( CASE ");
                stringBuffer.append("WHEN ");
                stringBuffer.append(string4);
                stringBuffer.append(" is not null then 1 end) " + string4);
                String string9 = ResourceUtilities.getUILabel("HISTOGRAM_NOT_NULL");
                Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
                Vector<String> vector4 = new Vector<String>();
                hashtable2.put(CDSStatsDataSource.appendSingleQuotes("1"), string9);
                vector4.add(CDSStatsDataSource.appendSingleQuotes("1"));
                this.setMapCategorytoRange(this.getAttributeRow(string7), hashtable2);
                this.setAllCategorytoRangeList(this.getAttributeRow(string7), vector4);
            } else if (((BinningType)object).equal(BinningType.QTILE)) {
                this.prepareQtileDefinitionLabels(stringBuffer, binBoundMap, string4, string7);
            } else {
                this.prepareEqWidthDefinitionLabels(stringBuffer, binBoundMap, string4, string7);
            }
            if (n2 < vector3.size() - 1) {
                stringBuffer.append(",");
            }
            stringBuffer.append("\n");
        }
        if (!vector3.isEmpty()) {
            stringBuffer.append(" FROM " + string);
            binBoundMap.clear();
            return stringBuffer;
        }
        for (n2 = 0; n2 < binArray.size(); ++n2) {
            String string10;
            String string11 = (String)binArray.elementAt(n2);
            int n4 = this.getAttributeRow(string11);
            if (n != n4 || (string10 = this.getComplexAttributeInfo(string11)) == null || (object = this.m_sampledInputCDS.getTXColumn(string10)) == null) continue;
            try {
                stringBuffer = this.processNumTXSource(string11, ((TXColumn)object).getValueColumn(), string10, binBoundMap, hashtable);
                continue;
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
        binBoundMap.clear();
        return stringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalTableRowCount(Connection connection) {
        if (this.m_casecount != -1) {
            return this.m_casecount;
        }
        StringBuffer stringBuffer = new StringBuffer("SELECT COUNT (*) ");
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            String string = MessageFormat.format(" from \"{0}\".\"{1}\"", this.m_sampledInputCDS.getCaseSchema(), this.m_sampledInputCDS.getCaseTable());
            stringBuffer.append(string);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet.next()) {
                this.m_casecount = resultSet.getInt(1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
        return this.m_casecount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNumStats(Connection connection, Vector vector, Hashtable hashtable, String string) {
        if (vector == null || vector.isEmpty()) {
            return;
        }
        int n = vector.size() / 1000 + 1;
        String string2 = "count({0}) as N{1}, count(distinct{0}) as COUNT{1}, avg({0}) as Average{1}, MAX({0}) Max{1}, MIN({0}) Min{1}, VARIANCE({0}) as Variance{1}, sum((abs({0})) - (floor({0}))) as FLOAT_IND{1}";
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            int n2 = Math.min(vector.size(), 1000 * (i + 1));
            int n3 = 1000 * i;
            StringBuffer stringBuffer = new StringBuffer("SELECT ");
            for (int j = n3; j < n2; ++j) {
                object2 = "\"" + (String)vector.elementAt(j) + "\"";
                object = MessageFormat.format(string2, object2, String.valueOf(j));
                stringBuffer.append((String)object);
                if (j >= n2 - 1) continue;
                stringBuffer.append(",\n");
            }
            String string3 = MessageFormat.format(" from ({0}) ", string == null ? this.getSampledDataLocation() : string);
            stringBuffer.append(string3);
            object2 = null;
            object = null;
            String string4 = null;
            String string5 = null;
            try {
                object2 = connection.createStatement();
                object = object2.executeQuery(stringBuffer.toString());
                if (!object.next()) continue;
                for (int j = n3; j < n2; ++j) {
                    String string6 = String.valueOf(j);
                    String string7 = (String)vector.elementAt(j);
                    Integer n4 = (Integer)hashtable.get(string7);
                    if (n4 == null) continue;
                    int n5 = object.getInt("N" + string6);
                    this.setData(DiscretizeDataSource.COLUMN_NAMES.TOTAL, n4, new Integer(n5));
                    int n6 = object.getInt("COUNT" + string6);
                    this.m_extraGrid.setDistinctCount(n4, new Integer(n6));
                    this.m_extraGrid.setNullCount(n4, new Integer(n5 - n6));
                    this.setData(DiscretizeDataSource.COLUMN_NAMES.EXTRA_DATA_1, n4, new Integer(this.m_casecount - n5));
                    double d = object.getDouble("Average" + string6);
                    this.setData(DiscretizeDataSource.COLUMN_NAMES.AVG, n4, new Double(d));
                    d = object.getDouble("Max" + string6);
                    this.setData(DiscretizeDataSource.COLUMN_NAMES.MAX, n4, new Double(d));
                    d = object.getDouble("Min" + string6);
                    this.setData(DiscretizeDataSource.COLUMN_NAMES.MIN, n4, new Double(d));
                    d = object.getDouble("Variance" + string6);
                    this.setData(DiscretizeDataSource.COLUMN_NAMES.VAR, n4, new Double(d));
                    d = Math.sqrt(d);
                    this.setData(DiscretizeDataSource.COLUMN_NAMES.STDDEV, n4, new Double(d));
                    if (!this.m_bApplyEuristics) continue;
                    double d2 = object.getDouble("FLOAT_IND" + string6);
                    if (d2 != 0.0) {
                        string4 = "FLOAT";
                        string5 = "numerical";
                    } else {
                        string4 = "NUMBER";
                        string5 = n6 <= this.m_preferences.getCutoffForNumberForCategorical() ? "categorical" : "numerical";
                    }
                    this.setData(DiscretizeDataSource.COLUMN_NAMES.MTYPE, n4, string5);
                    this.setData(DiscretizeDataSource.COLUMN_NAMES.DTYPE, n4, string4);
                }
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            finally {
                try {
                    object.close();
                    object2.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCatStats(Connection connection, Vector vector, Hashtable hashtable, String string) {
        if (vector == null || vector.isEmpty()) {
            return;
        }
        int n = vector.size() / 1000 + 1;
        String string2 = "count ({0}) as N{1}, count (distinct{0}) as D{1} ";
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            int n2 = Math.min(vector.size(), 1000 * (i + 1));
            int n3 = 1000 * i;
            StringBuffer stringBuffer = new StringBuffer("SELECT ");
            for (int j = n3; j < n2; ++j) {
                object2 = "\"" + (String)vector.elementAt(j) + "\"";
                object = MessageFormat.format(string2, object2, String.valueOf(j));
                stringBuffer.append((String)object);
                if (j >= n2 - 1) continue;
                stringBuffer.append(",");
            }
            String string3 = MessageFormat.format(" from ({0})", string == null ? this.getSampledDataLocation() : string);
            stringBuffer.append(string3);
            object2 = null;
            object = null;
            try {
                object2 = connection.createStatement();
                object = object2.executeQuery(stringBuffer.toString());
                if (!object.next()) continue;
                for (int j = n3; j < n2; ++j) {
                    String string4 = String.valueOf(j);
                    String string5 = (String)vector.elementAt(j);
                    Integer n4 = (Integer)hashtable.get(string5);
                    if (n4 == null) continue;
                    int n5 = object.getInt("N" + string4);
                    this.setData(DiscretizeDataSource.COLUMN_NAMES.TOTAL, n4, new Integer(n5));
                    int n6 = object.getInt("D" + string4);
                    this.m_extraGrid.setDistinctCount(n4, new Integer(n6));
                    this.m_extraGrid.setNullCount(n4, new Integer(n5 - n6));
                    this.setData(DiscretizeDataSource.COLUMN_NAMES.EXTRA_DATA_1, n4, new Integer(this.m_casecount - n5));
                }
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            finally {
                try {
                    object.close();
                    object2.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected void createDataFrom2DSource() throws Exception {
        if (this.m_isTransactional) {
            return;
        }
        Hashtable hashtable = this.getMiningTypes();
        int n = this.getRowCount();
        LinkedHashMap linkedHashMap = this.m_twoDdataSource.getColumns();
        Collection collection = linkedHashMap.values();
        Object[] objectArray = collection.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            String string = ((Column)objectArray[i]).getName();
            if (!((Column)objectArray[i]).getIsVisible() || 0 == string.compareTo(ActivityUtils.getCaseIdName())) continue;
            String string2 = ((Column)objectArray[i]).getDataType();
            this.m_tableColumns.add(string);
            if (0 != string2.compareTo("NUMBER") && 0 != string2.compareTo("CHAR") && 0 != string2.compareTo("VARCHAR2") && 0 != string2.compareTo("FLOAT") && 0 != string2.compareTo("NVARCHAR2") && 0 != string2.compareTo("NCHAR")) continue;
            this.addRows(n, 1);
            this.setAttributeName(n, string);
            DiscretizeDataSource.DataInfo dataInfo = (DiscretizeDataSource.DataInfo)hashtable.get(string);
            this.setData(DiscretizeDataSource.COLUMN_NAMES.MTYPE, n, dataInfo == null ? null : dataInfo.m_AttrType);
            this.setData(DiscretizeDataSource.COLUMN_NAMES.DTYPE, n, dataInfo == null ? null : dataInfo.m_DataType);
            this.setData(DiscretizeDataSource.COLUMN_NAMES.BINNUMBER, n, new Integer(DEFAULT_BIN_NUMBER));
            if (0 == string2.compareTo("NUMBER") || 0 == string2.compareTo("FLOAT")) {
                this.m_numericAttributeNames.add(string);
                this.m_numericNameIDMap.put(string, new Integer(n));
                ++n;
                continue;
            }
            if (0 != string2.compareTo("CHAR") && 0 != string2.compareTo("VARCHAR2") && 0 != string2.compareTo("NCHAR") && 0 != string2.compareTo("NVARCHAR2")) continue;
            this.m_categoricAttributeNames.add(string);
            this.m_categoricNameIDMap.put(string, new Integer(n));
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAllStats(Connection connection) {
        Object object;
        Object object2;
        int n;
        if ((this.m_numericAttributeNames == null || this.m_numericAttributeNames.isEmpty()) && (this.m_categoricAttributeNames == null || this.m_categoricAttributeNames.isEmpty())) {
            return;
        }
        String string = "count({0}) as N{1}, count(distinct {0}) as COUNT{1}, avg({0}) as Average{1}, MAX({0}) Max{1}, MIN({0}) Min{1}, VARIANCE({0}) as Variance{1}, sum((abs({0})) - (floor({0}))) as FLOAT_IND{1}";
        String string2 = "count({0}) as N{1}, count(distinct {0}) as COUNT{1}";
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer("SELECT ");
        for (n = 0; n < this.m_numericAttributeNames.size(); ++n) {
            object2 = "\"" + (String)this.m_numericAttributeNames.elementAt(n) + "\"";
            vector.add((String)this.m_numericAttributeNames.elementAt(n));
            object = MessageFormat.format(string, object2, String.valueOf(n2++));
            stringBuffer.append((String)object);
            if (n >= this.m_numericAttributeNames.size() - 1) continue;
            stringBuffer.append(",\n");
        }
        if (!this.m_numericAttributeNames.isEmpty() && !this.m_categoricAttributeNames.isEmpty()) {
            stringBuffer.append(",\n");
        }
        for (n = 0; n < this.m_categoricAttributeNames.size(); ++n) {
            object2 = "\"" + (String)this.m_categoricAttributeNames.elementAt(n) + "\"";
            vector.add((String)this.m_categoricAttributeNames.elementAt(n));
            object = MessageFormat.format(string2, object2, String.valueOf(n2++));
            stringBuffer.append((String)object);
            if (n >= this.m_categoricAttributeNames.size() - 1) continue;
            stringBuffer.append(",\n");
        }
        String string3 = MessageFormat.format(" from ({0}) ", this.getSampledDataLocation());
        stringBuffer.append(string3);
        object2 = null;
        object = null;
        String string4 = null;
        String string5 = null;
        try {
            object2 = connection.createStatement();
            object = object2.executeQuery(stringBuffer.toString());
            if (object.next()) {
                for (int i = 0; i < vector.size(); ++i) {
                    String string6 = String.valueOf(i);
                    String string7 = (String)vector.elementAt(i);
                    boolean bl = false;
                    Integer n3 = (Integer)this.m_numericNameIDMap.get(string7);
                    if (n3 == null) {
                        n3 = (Integer)this.m_categoricNameIDMap.get(string7);
                        if (n3 == null) {
                            continue;
                        }
                    } else {
                        bl = true;
                    }
                    int n4 = object.getInt("N" + string6);
                    this.setData(DiscretizeDataSource.COLUMN_NAMES.TOTAL, n3, new Integer(n4));
                    int n5 = object.getInt("COUNT" + string6);
                    this.m_extraGrid.setDistinctCount(n3, new Integer(n5));
                    this.m_extraGrid.setNullCount(n3, new Integer(n4 - n5));
                    this.setData(DiscretizeDataSource.COLUMN_NAMES.EXTRA_DATA_1, n3, new Integer(this.m_casecount - n4));
                    if (!bl) continue;
                    double d = object.getDouble("Average" + string6);
                    this.setData(DiscretizeDataSource.COLUMN_NAMES.AVG, n3, new Double(d));
                    d = object.getDouble("Max" + string6);
                    this.setData(DiscretizeDataSource.COLUMN_NAMES.MAX, n3, new Double(d));
                    d = object.getDouble("Min" + string6);
                    this.setData(DiscretizeDataSource.COLUMN_NAMES.MIN, n3, new Double(d));
                    d = object.getDouble("Variance" + string6);
                    this.setData(DiscretizeDataSource.COLUMN_NAMES.VAR, n3, new Double(d));
                    d = Math.sqrt(d);
                    this.setData(DiscretizeDataSource.COLUMN_NAMES.STDDEV, n3, new Double(d));
                    if (!this.m_bApplyEuristics) continue;
                    double d2 = object.getDouble("FLOAT_IND" + string6);
                    if (d2 != 0.0) {
                        string4 = "FLOAT";
                        string5 = "numerical";
                    } else {
                        string4 = "NUMBER";
                        string5 = n5 <= this.m_preferences.getCutoffForNumberForCategorical() ? "categorical" : "numerical";
                    }
                    this.setData(DiscretizeDataSource.COLUMN_NAMES.MTYPE, n3, string5);
                    this.setData(DiscretizeDataSource.COLUMN_NAMES.DTYPE, n3, string4);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                object.close();
                object2.close();
            }
            catch (Exception exception) {}
        }
    }
}

