/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.datasources.ComplexDataStructure;
import oracle.dmt.dm4j.datasources.DiscretizeDataSource;
import oracle.dmt.dm4j.datasources.NormalizeDataSource;
import oracle.dmt.dm4j.datasources.NumericDataSource;
import oracle.dmt.dm4j.datasources.TXColumn;
import oracle.dmt.dm4j.wizard.director.transforms.TransformsDirector;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.odm.binning.BinningType;

public class CDSNumericDataSource
extends NumericDataSource {
    TXColumn m_txTable;
    String m_uniqueName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CDSNumericDataSource(Connection connection, String string, String string2, ComplexDataStructure complexDataStructure, NormalizeDataSource normalizeDataSource, int n, double d) throws Exception {
        super(COLUMN_COUNT, 1);
        this.m_sampleCDS = complexDataStructure;
        this.m_cdsModel = normalizeDataSource;
        this.m_conn = connection;
        this.m_isTransactional = false;
        try {
            int n2;
            this.m_functionName = string;
            this.m_attributeName = TransformsDirector.getReplacedString(string2, "'", "''");
            this.m_attributeName = "'" + this.m_attributeName + "'";
            if (normalizeDataSource != null) {
                n2 = normalizeDataSource.getAttributeRow(string2);
                this.m_uniqueName = normalizeDataSource.getComplexAttribute(n2);
            }
            if (this.m_uniqueName != null) {
                this.m_txTable = complexDataStructure.getTXColumn(this.m_uniqueName);
                this.m_originlDataLocation = this.m_txTable.getDataLocation();
                this.m_dataSourceSchemaName = this.m_txTable.getTxSchemaName();
            } else {
                this.m_tableName = this.m_sampleCDS.getCaseTable();
                this.m_dataSourceSchemaName = this.m_sampleCDS.getCaseSchema();
                this.m_originlDataLocation = this.m_dataSourceSchemaName + "." + this.m_tableName;
            }
            this.m_userSchemaName = DM4JConnectionManager.getUser();
            n2 = 0;
            String string3 = string2;
            this.setData(NumericDataSource.COLUMN_NAMES.NAME, n2, string3);
            this.setData(NumericDataSource.COLUMN_NAMES.BINNUMBER, n2, new Integer(n));
            this.setData(NumericDataSource.COLUMN_NAMES.TAILPERCENT, n2, new Double(d));
            this.setComplexAttribute(n2, this.m_uniqueName);
            double[] dArray = this.getWinsorizedStats(this.m_conn, string, d);
            this.setStatistics(dArray);
            this.setBinningType(BinningType.EQ_WIDTH);
            this.createFunctionBasedView2D(this.m_conn);
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                System.out.println(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected double[] getEqualWidthStats2D(Connection connection, String string) {
        if (this.m_uniqueName == null) {
            return super.getEqualWidthStats2D(connection, string);
        }
        Statement statement = null;
        ResultSet resultSet = null;
        Object[] objectArray = new Object[]{string, this.m_originlDataLocation};
        StringBuffer stringBuffer = new StringBuffer(STAT_SQL_EQ_WIDTH_1ST_ORDER_2D_PREFIX);
        stringBuffer.append(MessageFormat.format(STAT_SQL_EQ_WIDTH_1ST_ORDER_2D, objectArray));
        double[] dArray = new double[NUMBER_STATS];
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet.next()) {
                dArray[CDSNumericDataSource.STAT_TOTAL] = resultSet.getInt("N");
                dArray[CDSNumericDataSource.STAT_AVERAGE] = resultSet.getDouble("Average");
                dArray[CDSNumericDataSource.STAT_MAX] = resultSet.getDouble("Max");
                dArray[CDSNumericDataSource.STAT_MIN] = resultSet.getDouble("Min");
                dArray[CDSNumericDataSource.STAT_VARIANCE] = resultSet.getDouble("Variance");
                dArray[CDSNumericDataSource.STAT_STDEV] = Math.sqrt(dArray[STAT_VARIANCE]);
                resultSet.close();
                statement.close();
                statement = connection.createStatement();
                objectArray = new Object[]{String.valueOf(dArray[STAT_AVERAGE]), string, String.valueOf((int)dArray[STAT_TOTAL]), String.valueOf(dArray[STAT_STDEV]), this.m_originlDataLocation};
                String string2 = null;
                stringBuffer = null;
                stringBuffer = new StringBuffer();
                for (int i = 0; i < STAT_SQL_EQ_WIDTH_2ND_ORDER.length; ++i) {
                    string2 = MessageFormat.format(STAT_SQL_EQ_WIDTH_2ND_ORDER[i], objectArray);
                    stringBuffer.append(string2);
                }
                resultSet = statement.executeQuery(stringBuffer.toString());
                if (resultSet.next()) {
                    dArray[CDSNumericDataSource.STAT_SKEW] = resultSet.getDouble("Skew");
                    dArray[CDSNumericDataSource.STAT_KURT] = resultSet.getDouble("Kurtosis");
                }
            }
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                System.out.println(exception);
            }
            dArray = null;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
        return dArray;
    }

    public String getAttributeName() {
        if (this.m_txTable == null) {
            return super.getAttributeName();
        }
        return this.m_txTable.getValueColumn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createFunctionBasedView2D(Connection connection) throws SQLException {
        if (this.m_uniqueName == null) {
            super.createFunctionBasedView2D(connection);
            return;
        }
        Statement statement = null;
        String string = null;
        Object[] objectArray = null;
        this.m_functionBasedView = ValidationUtil.createUniqueTableName(FUNCTION_BASED_VIEW_PREFIX, connection, "");
        try {
            string = FUNCTION_BASED_VIEW_2D;
            objectArray = new Object[]{this.m_functionBasedView, this.m_functionName, "\"" + this.m_txTable.getValueColumn() + "\"", this.m_originlDataLocation};
            string = MessageFormat.format(string, objectArray);
            statement = connection.prepareCall(string);
            statement.execute();
            statement.close();
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                System.out.println(exception);
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    public int[] getFrequency(Connection connection, String string) {
        if (this.m_txTable == null) {
            return super.getFrequency(connection, string);
        }
        return this.getFrequency2D(connection, this.m_txTable.getValueColumn());
    }
}

