/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.AbstractMap;
import java.util.Hashtable;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JException;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.datasources.CDSExtraDataSource;
import oracle.dmt.dm4j.datasources.ComplexDataStructure;
import oracle.dmt.dm4j.datasources.DiscretizationLDSDataSource;
import oracle.dmt.dm4j.datasources.DiscretizeDataSource;
import oracle.dmt.dm4j.datasources.ExtraDataSource;
import oracle.dmt.dm4j.datasources.TXColumn;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.commonsteps.DataState;
import oracle.dmt.odm.binning.Bin;
import oracle.dmt.odm.binning.BinningType;
import oracle.dmt.odm.binning.CategoricBin;

public class CDSLDSDataSource
extends DiscretizationLDSDataSource {
    protected ComplexDataStructure m_cdsSampledData;
    protected ComplexDataStructure m_cdsOriginalData;

    public ComplexDataStructure getSampledDataStructure() {
        return this.m_cdsSampledData;
    }

    public ComplexDataStructure getOriginalDataStructure() {
        return this.m_cdsOriginalData;
    }

    public CDSLDSDataSource(Connection connection, DataState dataState, AbstractActivity abstractActivity, ComplexDataStructure complexDataStructure, ComplexDataStructure complexDataStructure2, String string, String string2, boolean bl, boolean bl2) {
        super(connection, dataState, string, string2, bl, bl2);
        this.m_activity = abstractActivity;
        this.m_cdsSampledData = complexDataStructure;
        this.m_cdsOriginalData = complexDataStructure2;
        this.m_bOverRideEuristics = true;
    }

    public CDSLDSDataSource(Connection connection, DataState dataState, AbstractActivity abstractActivity, ComplexDataStructure complexDataStructure, String string, String string2, boolean bl, boolean bl2) {
        this(connection, dataState, abstractActivity, complexDataStructure, null, string, string2, bl, bl2);
    }

    public CDSLDSDataSource(Connection connection, DataState dataState, AbstractActivity abstractActivity, ComplexDataStructure complexDataStructure, ComplexDataStructure complexDataStructure2, boolean bl, boolean bl2) {
        super(connection, dataState, null, null, bl, bl2);
        this.m_activity = abstractActivity;
        if (complexDataStructure == null) {
            complexDataStructure = complexDataStructure2;
        }
        this.m_cdsSampledData = complexDataStructure;
        this.m_cdsOriginalData = complexDataStructure2;
        this.m_bOverRideEuristics = true;
    }

    public CDSLDSDataSource(Connection connection, DataState dataState, AbstractActivity abstractActivity, ComplexDataStructure complexDataStructure, boolean bl, boolean bl2) {
        this(connection, dataState, abstractActivity, complexDataStructure, null, bl, bl2);
    }

    public String getDataSource() {
        return this.m_cdsSampledData.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createData() throws Exception {
        if (this.m_cdsSampledData == null) {
            throw new Exception();
        }
        Connection connection = null;
        try {
            Object object;
            connection = DM4JConnectionManager.getDbConnection();
            String string = DM4JStringUtils.trimDoubleQuotes(this.m_cdsSampledData.getCaseTable());
            String string2 = DM4JStringUtils.trimDoubleQuotes(this.m_cdsSampledData.getCaseSchema());
            if (string != null && string.length() != 0) {
                object = null;
                object = string2 != null && string2.length() != 0 ? "\"" + string2 + "\".\"" + string + "\"" : "\"" + string + "\"";
                this.setDataLocation((String)object);
                this.formLDSFrom2DDBTable(connection, string, string2);
                if (this.m_getStatistics) {
                    this.countCasesFrom2DDBTable(connection, string, string2);
                }
            }
            if ((object = this.m_cdsSampledData.getColumnMap()) != null && !((AbstractMap)object).isEmpty()) {
                Set set = ((TreeMap)object).keySet();
                for (String string3 : set) {
                    TXColumn tXColumn = (TXColumn)((TreeMap)object).get(string3);
                    if (tXColumn == null) continue;
                    if (tXColumn.getIsSingleMetrics()) {
                        this.processSingleMetricTxData(connection, tXColumn.getTxTableName(), tXColumn.getTxSchemaName(), tXColumn.getNameColumn(), tXColumn.getValueColumn(), tXColumn.getUniqueName());
                        int n = this.getAttributeIndex(tXColumn.getUniqueName());
                        String string4 = (String)this.getData(3, n);
                        int n2 = string4.equals("numerical") ? 0 : 1;
                        tXColumn.setDataType(n2);
                        continue;
                    }
                    this.formLDSFromTransactionalDBTable(connection, tXColumn.getTxTableName(), tXColumn.getTxSchemaName());
                    this.countCasesFromTransactionalDBTable(connection, tXColumn.getDataLocation());
                }
            }
            this.m_extraModel = new CDSExtraDataSource(this.m_cdsSampledData, this.getSamplingViewDefinition());
            this.m_extraModel.populateTable(this);
        }
        finally {
            if (this.m_progressBar != null) {
                this.m_progressBar.setDoneStatus();
            }
            if (connection != null) {
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSingleMetricTxData(Connection connection, String string, String string2, String string3, String string4, String string5) throws SQLException, Exception {
        String string6 = "SELECT c.COLUMN_NAME, c.DATA_TYPE, con.CONSTRAINT_TYPE FROM all_tab_columns c, (SELECT cn.OWNER, cn.TABLE_NAME, cn.COLUMN_NAME, cd.CONSTRAINT_TYPE FROM all_cons_columns cn, all_constraints cd WHERE cn.OWNER = cd.OWNER AND cn.TABLE_NAME = cd.TABLE_NAME AND cn.CONSTRAINT_NAME = cd.CONSTRAINT_NAME AND 'P' = cd.CONSTRAINT_TYPE AND 'ENABLED' = cd.STATUS) con WHERE c.OWNER = ? AND c.TABLE_NAME = ? AND c.COLUMN_NAME = ? AND c.OWNER = con.OWNER(+) AND c.TABLE_NAME = con.TABLE_NAME(+) AND c.COLUMN_NAME = con.COLUMN_NAME(+) ";
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        Hashtable hashtable = new Hashtable();
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Hashtable hashtable2 = new Hashtable();
        try {
            String string7;
            String string8;
            callableStatement = connection.prepareCall(string6);
            int n = 1;
            String string9 = "";
            callableStatement.setString(n++, string2);
            callableStatement.setString(n++, string);
            callableStatement.setString(n++, string4);
            resultSet = callableStatement.executeQuery();
            boolean bl = false;
            int n2 = this.getRowCount();
            if (resultSet.next()) {
                String string10;
                boolean bl2 = false;
                bl = true;
                string8 = resultSet.getString("DATA_TYPE");
                string7 = resultSet.getString("CONSTRAINT_TYPE");
                if (string8.compareTo("NUMBER") == 0) {
                    string10 = "numerical";
                    string9 = "DM_NESTED_NUMERICALS";
                } else if (string8.compareTo("VARCHAR2") == 0 || string8.compareTo("CHAR") == 0) {
                    string10 = "categorical";
                    string9 = "DM_NESTED_CATEGORICALS";
                } else if (string8.compareTo("FLOAT") == 0) {
                    string10 = "numerical";
                    string9 = string8;
                } else {
                    string9 = string8;
                    string10 = "notApplicable";
                    bl2 = true;
                }
                this.addRows(n2, 1);
                if (string7 == "ENABLED") {
                    this.setData(5, n2, "caseId");
                    this.setData(7, n2, "caseId");
                } else {
                    this.setData(5, n2, "active");
                    this.setData(7, n2, "active");
                }
                this.setData(0, n2, bl2 ? Boolean.FALSE : Boolean.TRUE);
                this.setData(8, n2, bl2 ? Boolean.FALSE : Boolean.TRUE);
                this.setData(1, n2, string5);
                this.m_NameRow.put(string5, new Integer(n2));
                this.m_allAttributes.add(string5);
                this.setData(2, n2, string9);
                this.setData(3, n2, string10);
                this.setData(6, n2, string10);
                this.setData(4, n2, Boolean.FALSE);
                this.setData(9, n2, Boolean.FALSE);
                this.setData(16, n2, string5);
                if (this.m_getStatistics) {
                    this.addColumnNamesForStats(vector2, hashtable, vector, hashtable2, string5, string9, string10, n2);
                }
            }
            if (this.getRowCount() > 0 && this.m_getStatistics) {
                if (!vector2.isEmpty()) {
                    String string11 = (String)vector2.elementAt(0);
                    this.addNumericStatsTXSingleMetrics(connection, string11, hashtable, string4, string, string2);
                }
                hashtable.clear();
                vector2.clear();
                hashtable2.clear();
                vector.clear();
                String string12 = (String)this.getData(3, n2);
                string8 = (String)this.getData(2, n2);
                this.addCategoricColumnNamesForStats(vector, hashtable2, string5, string8, string12, n2);
                if (!vector.isEmpty()) {
                    string7 = (String)vector.elementAt(0);
                    this.addCategoricStatsTXSingleMetrics(connection, string7, hashtable2, string4, string, string2);
                }
                hashtable.clear();
                vector2.clear();
                hashtable2.clear();
                vector.clear();
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (callableStatement != null) {
                callableStatement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNumericStatsTXSingleMetrics(Connection connection, String string, Hashtable hashtable, String string2, String string3, String string4) {
        String string5 = "count(distinct {1}) as COUNT2, count(distinct {0}) as COUNT, round((sum(nvl2({0},0,1))/Count(*))*100,3) as MISSING, sum((abs({0})) - (floor({0}))) as FLOAT_IND, min({0}) as MIN";
        StringBuffer stringBuffer = new StringBuffer("SELECT Count(*) as TOTAL, ");
        String string6 = MessageFormat.format(string5, string2, string2);
        stringBuffer.append(string6);
        String string7 = MessageFormat.format(" from ({0})", "\"" + string4 + "\".\"" + string3 + "\"");
        stringBuffer.append(string7);
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            Integer n;
            statement = connection.createStatement();
            resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet.next() && (n = (Integer)hashtable.get(string)) != null) {
                this.adjustNumericStats(resultSet, n, null);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCategoricStatsTXSingleMetrics(Connection connection, String string, Hashtable hashtable, String string2, String string3, String string4) {
        String string5 = "count(distinct {0}) as COUNT, round((sum(nvl2({0},0,1))/Count(*))*100,3) as MISSING";
        StringBuffer stringBuffer = new StringBuffer("SELECT Count(*) as TOTAL, ");
        String string6 = MessageFormat.format(string5, string2);
        stringBuffer.append(string6);
        String string7 = MessageFormat.format(" from ({0})", "\"" + string4 + "\".\"" + string3 + "\"");
        stringBuffer.append(string7);
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(stringBuffer.toString());
            int n = 0;
            int n2 = 0;
            boolean bl = false;
            if (resultSet.next()) {
                Integer n3 = (Integer)hashtable.get(string);
                if (n3 == null) {
                    return;
                }
                n2 = resultSet.getInt("TOTAL");
                this.setData(14, n3, new Integer(n2));
                n = resultSet.getInt("COUNT");
                this.setData(10, n3, new Integer(n));
                Float f = new Float(resultSet.getFloat("MISSING"));
                this.setData(11, n3, f);
                bl = false;
                if ((n2 == this.getSampleSize() && this.m_FormatIsTransactional || n2 == n && !this.m_FormatIsTransactional) && (n == n2 || (float)(n / n2) >= this.getUniquePercentage())) {
                    bl = true;
                }
                Boolean bl2 = Boolean.FALSE;
                if (n == n2 && n2 == this.getSampleSize() && this.m_FormatIsTransactional || n == n2 && !this.m_FormatIsTransactional) {
                    bl2 = new Boolean(n == n2);
                }
                this.setData(15, n3, bl2);
                if (this.m_adjustDataUsage && bl && !this.m_loadFromODM) {
                    this.setData(0, n3, Boolean.FALSE);
                    this.setData(8, n3, Boolean.FALSE);
                    this.setData(5, n3, "inactive");
                    this.setData(7, n3, "inactive");
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void formLDSFromTransactionalDBTable(Connection connection, String string, String string2) throws SQLException, DM4JException, Exception {
        String string3 = this.determineLDSTransactionalDataType(connection, string, string2);
        String string4 = this.m_cdsSampledData.getAttributeNameColumn();
        String string5 = " SELECT DISTINCT \"" + string4 + "\" as myDistincts FROM \"" + string2 + "\".\"" + string + "\" ORDER BY myDistincts ASC";
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        try {
            String string6;
            callableStatement = connection.prepareCall(string5);
            resultSet = callableStatement.executeQuery();
            int n = 0;
            while (resultSet.next()) {
                string6 = resultSet.getString("MYDISTINCTS");
                this.addRows(n, 1);
                super.setData(0, n, Boolean.TRUE);
                super.setData(8, n, Boolean.TRUE);
                super.setData(1, n, string6);
                this.m_NameRow.put(string6, new Integer(n));
                super.setData(2, n, string3);
                super.setData(3, n, "numerical");
                super.setData(5, n, "active");
                super.setData(7, n, "active");
                super.setData(6, n, "numerical");
                super.setData(4, n, Boolean.FALSE);
                super.setData(9, n, Boolean.FALSE);
                if (this.m_getStatistics) {
                    hashtable.put(string6, new Integer(n));
                }
                ++n;
            }
            if (this.getRowCount() > 0 && this.m_getStatistics) {
                string6 = this.m_cdsSampledData.getDataLocation();
                this.addNumericStatsTX(connection, hashtable, string6);
                hashtable.clear();
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (callableStatement != null) {
                callableStatement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String determineLDSTransactionalDataType(Connection connection, String string, String string2) throws SQLException, DM4JException, Exception {
        boolean bl = false;
        String string3 = null;
        String string4 = "SELECT c.COLUMN_NAME, c.DATA_TYPE, c.DATA_SCALE,c.DATA_PRECISION, c.DATA_LENGTH,con.CONSTRAINT_TYPE FROM all_tab_columns c, (SELECT cn.OWNER, cn.TABLE_NAME, cn.COLUMN_NAME, cd.CONSTRAINT_TYPE FROM all_cons_columns cn, all_constraints cd WHERE cn.OWNER = cd.OWNER AND cn.TABLE_NAME = cd.TABLE_NAME AND cn.CONSTRAINT_NAME = cd.CONSTRAINT_NAME AND 'P' = cd.CONSTRAINT_TYPE AND 'ENABLED' = cd.STATUS) con WHERE c.OWNER = ? AND c.TABLE_NAME = ? AND c.OWNER = con.OWNER(+) AND c.TABLE_NAME = con.TABLE_NAME(+) AND c.COLUMN_NAME = con.COLUMN_NAME(+) AND c.COLUMN_NAME = ? ORDER BY column_name ASC";
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        String string5 = this.m_cdsSampledData.getValueColumn();
        try {
            callableStatement = connection.prepareCall(string4);
            int n = 1;
            callableStatement.setString(n++, string2);
            callableStatement.setString(n++, string);
            callableStatement.setString(n++, string5);
            resultSet = callableStatement.executeQuery();
            boolean bl2 = false;
            boolean bl3 = false;
            while (resultSet.next()) {
                bl = true;
                String string6 = resultSet.getString("COLUMN_NAME");
                String string7 = resultSet.getString("DATA_TYPE");
                int n2 = resultSet.getInt("DATA_LENGTH");
                if (string7.compareTo("NUMBER") == 0) {
                    string3 = string7;
                    continue;
                }
                if (string7.compareTo("VARCHAR2") == 0 || string7.compareTo("CHAR") == 0) {
                    if (n2 == 1) {
                        string3 = "CHAR";
                        continue;
                    }
                    string3 = "VARCHAR2";
                    continue;
                }
                string3 = "";
                bl2 = true;
                this.m_skippedAttributes.add(string6);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (callableStatement != null) {
                callableStatement.close();
            }
        }
        if (!bl) {
            DM4JException dM4JException = new DM4JException("No column definition found in table for column name: " + string5);
            throw dM4JException;
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNumericStatsTX(Connection connection, Hashtable hashtable, String string) {
        String string2 = "SELECT {0} NAME, count ({1}) as TOTAL, count(distinct {1}) as COUNT, round((sum(nvl2({1},0,1))/count ({1}))*100,3) as MISSING, sum((abs({1})) - (floor({1}))) as FLOAT_IND, min({1}) as MIN from {2} WHERE {1} IS NOT NULL group by {0}";
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            String string3 = this.m_cdsSampledData.getAttributeNameColumn();
            String string4 = this.m_cdsSampledData.getValueColumn();
            String string5 = MessageFormat.format(string2, "\"" + string3 + "\"", "\"" + string4 + "\"", string);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string5);
            while (resultSet.next()) {
                String string6 = resultSet.getString("NAME");
                Integer n = (Integer)hashtable.get(string6);
                if (n == null) continue;
                this.adjustNumericStats(resultSet, n, null);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void countCasesFromTransactionalDBTable(Connection connection, String string) throws SQLException, Exception {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            String string2 = "select COUNT(DISTINCT (" + this.m_cdsSampledData.getCaseIdColumn() + ")) from " + string;
            statement = connection.prepareCall(string2);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                this.m_caseCount = resultSet.getInt(1);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getTopNStats2D(Connection connection, int n, int n2) {
        String string = (String)this.getData(16, n);
        if (string == null) {
            super.getTopNStats2D(connection, n, n2);
            return;
        }
        String string2 = String.valueOf(n2);
        TXColumn tXColumn = this.m_cdsSampledData.getTXColumn(string);
        Statement statement = null;
        ResultSet resultSet = null;
        Vector<CategoricBin> vector = new Vector<CategoricBin>();
        try {
            String string3 = MessageFormat.format("SELECT * FROM (SELECT {0} FROM {1} GROUP BY {0} HAVING {0} IS NOT NULL ORDER BY COUNT(*) DESC, {0} DESC) WHERE rownum <= {2}", "\"" + tXColumn.getValueColumn() + "\"", tXColumn.getDataLocation(), string2);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                Vector<String> vector2 = new Vector<String>();
                String string4 = resultSet.getString(1);
                vector2.add(string4);
                CategoricBin categoricBin = new CategoricBin(string4, vector2);
                vector.add(categoricBin);
            }
            this.setBinBounds(n, vector);
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getStatsMode2D(Connection connection, String string, int n) {
        if (string == null) {
            return;
        }
        String string2 = (String)this.getData(16, n);
        if (string2 == null) {
            super.getStatsMode2D(connection, string, n);
            return;
        }
        TXColumn tXColumn = this.m_cdsSampledData.getTXColumn(string2);
        StringBuffer stringBuffer = new StringBuffer("SELECT  ");
        String string3 = MessageFormat.format("stats_mode({0}), count({0}) ", "\"" + tXColumn.getValueColumn() + "\"");
        stringBuffer.append(string3);
        String string4 = MessageFormat.format(" from ({0} t)", tXColumn.getDataLocation());
        stringBuffer.append(string4);
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet.next()) {
                String string5 = resultSet.getString(1);
                int n2 = resultSet.getInt(2);
                this.setStatsMode(n, string5);
                this.setTotalCount(n, n2);
            }
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] getCategoricAttributeFrequency(Connection connection, int n, String string) {
        Object object;
        Object object2;
        String string2 = (String)this.getData(16, n);
        if (string2 == null) {
            return super.getCategoricAttributeFrequency(connection, n, string);
        }
        TXColumn tXColumn = this.m_cdsSampledData.getTXColumn(string2);
        String[] stringArray = new String[]{"select {0} DISPLAY_NAME, count(*) FREQUENCY ", "from {1} group by {0} order by FREQUENCY desc"};
        String string3 = "\"" + tXColumn.getValueColumn() + "\"";
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            object2 = MessageFormat.format(stringArray[i], string3, tXColumn.getDataLocation());
            stringBuffer.append((String)object2);
        }
        Hashtable<Integer, CategoricBin> hashtable = new Hashtable<Integer, CategoricBin>();
        object2 = this.getBinBounds(n);
        int n2 = ((Vector)object2).size();
        int[] nArray = new int[n2 + 1];
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(stringBuffer.toString());
            object = preparedStatement.executeQuery();
            boolean bl = false;
            while (object.next()) {
                String string4 = object.getString("DISPLAY_NAME");
                if (string4 == null) {
                    string4 = ResourceUtilities.getUILabel("HISTOGRAM_NULL_VALUE");
                }
                int n3 = object.getInt("FREQUENCY");
                boolean bl2 = false;
                for (int i = 0; i < n2; ++i) {
                    CategoricBin categoricBin = (CategoricBin)((Vector)object2).elementAt(i);
                    for (int j = 0; j < categoricBin.values.size(); ++j) {
                        if (0 != string4.compareTo((String)categoricBin.values.elementAt(j))) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl2) continue;
                    int n4 = i;
                    nArray[n4] = nArray[n4] + n3;
                    break;
                }
                if (bl2) continue;
                int n5 = n2;
                nArray[n5] = nArray[n5] + n3;
            }
            for (int i = 0; i < n2; ++i) {
                CategoricBin categoricBin = (CategoricBin)((Vector)object2).elementAt(i);
                hashtable.put(new Integer(i), categoricBin);
            }
            String string5 = ResourceUtilities.getUILabel("HISTOGRAM_OTHER");
            Vector vector = this.getOther((Vector)object2, n);
            hashtable.put(new Integer(n2), new CategoricBin(string5, vector));
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
            hashtable.clear();
        }
        finally {
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {}
        }
        if (hashtable.isEmpty()) {
            return null;
        }
        this.setDisplayNames(n, hashtable);
        this.setNumberOfBins(n, n2);
        object = this.getBinType(n);
        this.setBinType(n, (String)object, n2);
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] getNumericFrequency2D(Connection connection, String string, int n) {
        String string2;
        String string3 = (String)this.getData(16, n);
        if (string3 == null) {
            return super.getNumericFrequency2D(connection, string, n);
        }
        TXColumn tXColumn = this.m_cdsSampledData.getTXColumn(string3);
        Statement statement = null;
        ResultSet resultSet = null;
        int[] nArray = null;
        StringBuffer stringBuffer = null;
        Vector<Integer> vector = new Vector<Integer>();
        int n2 = 0;
        int n3 = 0;
        try {
            string2 = MessageFormat.format(DiscretizeDataSource.HISTOGRAM_VALUES[0], "\"" + tXColumn.getValueColumn() + "\"");
            StringBuffer stringBuffer2 = new StringBuffer(string2);
            stringBuffer = this.m_extraModel.getViewDefinition(n);
            if (stringBuffer == null) {
                stringBuffer = this.getSingleNumericAttributeViewDefinition(connection, n);
            }
            if (stringBuffer == null) {
                int[] nArray2 = nArray;
                return nArray2;
            }
            int n4 = stringBuffer.toString().indexOf("SELECT");
            StringBuffer stringBuffer3 = new StringBuffer(stringBuffer.substring(n4));
            stringBuffer2.append(stringBuffer3);
            string2 = MessageFormat.format(DiscretizeDataSource.HISTOGRAM_VALUES[1], "\"" + tXColumn.getValueColumn() + "\"");
            stringBuffer2.append(string2);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(stringBuffer2.toString());
            while (resultSet.next()) {
                String string4 = resultSet.getString("BIN_NUMBER");
                int n5 = resultSet.getInt("FREQUENCY");
                if (string4 != null) {
                    ++n2;
                    vector.add(new Integer(n5));
                    continue;
                }
                n3 = n5;
            }
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
            nArray = null;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
        if (vector == null || vector.isEmpty()) {
            return null;
        }
        this.setNumberOfBins(n, n2);
        this.setNullCount(n, n3);
        string2 = this.getBinType(n);
        this.setBinType(n, string2, n2);
        nArray = new int[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            Integer n6 = (Integer)vector.elementAt(i);
            nArray[i] = n6;
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getEqualWidthStats2D(Connection connection, Vector vector, Hashtable hashtable, int n) {
        if (vector.size() != 1) {
            this.getEqualWidthStats2D(connection, vector, hashtable, n);
            return;
        }
        String string = (String)vector.elementAt(0);
        String string2 = this.getComplexAttributeInfo(string);
        if (string2 == null) {
            super.getEqualWidthStats2D(connection, vector, hashtable, n);
            return;
        }
        TXColumn tXColumn = this.m_cdsSampledData.getTXColumn(string2);
        String string3 = "count({0}) as N, avg({0}) as Average, MAX({0}) Max , MIN({0}) Min, VARIANCE({0}) as Variance";
        StringBuffer stringBuffer = new StringBuffer("SELECT /*+ parallel (t) */");
        stringBuffer.append(MessageFormat.format(string3, tXColumn.getValueColumn()));
        String string4 = MessageFormat.format(" from ({0} t)", tXColumn.getDataLocation());
        stringBuffer.append(string4);
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet.next()) {
                Integer n2 = (Integer)hashtable.get(string);
                if (n2 == null) {
                    return;
                }
                int n3 = resultSet.getInt("N");
                this.setTotalCount(n2, n3);
                double d = resultSet.getDouble("Average");
                this.m_extraModel.setAverage(n2, d);
                double d2 = resultSet.getDouble("Max");
                this.m_extraModel.setMax(n2, d2);
                double d3 = resultSet.getDouble("Min");
                this.m_extraModel.setMin(n2, d3);
                d = resultSet.getDouble("Variance");
                this.setVariance(n2, d);
                d = Math.sqrt(d);
                this.setStdev(n2, d);
            }
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void quantileBinning2D(Connection connection, Vector vector, Hashtable hashtable, int n) {
        this.getEqualWidthStats2D(connection, vector, hashtable, n);
        String string = "SELECT MIN(val), MAX(val) FROM (SELECT {0} val,NTILE(TO_CHAR(ABS({1}))) OVER(ORDER BY {0} ASC) qtile FROM {2} WHERE {0} IS NOT NULL) GROUP BY qtile ORDER BY qtile ASC";
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = (String)vector.elementAt(i);
            Integer n2 = (Integer)hashtable.get(string2);
            if (n2 == null) continue;
            Vector<Double> vector2 = new Vector<Double>();
            Vector<Double> vector3 = new Vector<Double>();
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                DiscretizeDataSource.QuantileDefinition quantileDefinition;
                String string3 = this.getComplexAttributeInfo(string2);
                String string4 = null;
                if (string3 == null) {
                    string4 = MessageFormat.format(string, "\"" + string2 + "\"", new Integer(n), this.getSamplingViewDefinition());
                } else {
                    TXColumn tXColumn = this.m_cdsSampledData.getTXColumn(string3);
                    string4 = MessageFormat.format(string, "\"" + tXColumn.getValueColumn() + "\"", new Integer(n), tXColumn.getDataLocation());
                }
                int n3 = 0;
                statement = connection.prepareStatement(string4);
                resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    double d = resultSet.getDouble(1);
                    double d2 = resultSet.getDouble(2);
                    vector2.add(new Double(d));
                    vector3.add(new Double(d2));
                    ++n3;
                }
                Vector<DiscretizeDataSource.QuantileDefinition> vector4 = new Vector<DiscretizeDataSource.QuantileDefinition>();
                if (n3 == 0) continue;
                vector2.add((Double)vector3.elementAt(vector3.size() - 1));
                Double[] doubleArray = vector2.toArray(new Double[vector2.size()]);
                Double[] doubleArray2 = vector3.toArray(new Double[vector3.size()]);
                if (doubleArray[0].doubleValue() == doubleArray2[n3 - 1].doubleValue()) continue;
                int n4 = 0;
                for (int j = 0; j <= n3; ++j) {
                    if (j <= n3 - 1 && doubleArray[j].doubleValue() == doubleArray[j + 1].doubleValue()) continue;
                    quantileDefinition = new DiscretizeDataSource.QuantileDefinition(n4, doubleArray[j]);
                    vector4.add(quantileDefinition);
                    ++n4;
                }
                Vector<Bin> vector5 = new Vector<Bin>();
                quantileDefinition = null;
                for (int j = 0; j < vector4.size(); ++j) {
                    DiscretizeDataSource.QuantileDefinition quantileDefinition2 = (DiscretizeDataSource.QuantileDefinition)vector4.elementAt(j);
                    String string5 = String.valueOf(Double.MIN_VALUE);
                    Bin bin = new Bin(quantileDefinition2.getBinNumber(), j == 0 ? Double.parseDouble(string5) : quantileDefinition.getMinNumber(), quantileDefinition2.getMinNumber());
                    vector5.add(bin);
                    quantileDefinition = quantileDefinition2;
                }
                this.setBinBounds(n2, vector5);
                continue;
            }
            catch (Exception exception) {
                if (!DiscretizeDataSource.isDebug()) continue;
                exception.printStackTrace();
                continue;
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public StringBuffer getSingleNumericAttributeViewDefinition(Connection connection, int n) {
        String string = (String)this.getData(16, n);
        if (string == null) {
            return super.getSingleNumericAttributeViewDefinition(connection, n);
        }
        TXColumn tXColumn = this.m_cdsSampledData.getTXColumn(string);
        StringBuffer stringBuffer = null;
        try {
            Vector<String> vector = new Vector<String>();
            vector.add(this.getAttributeName(n));
            stringBuffer = this.createNumericOpenEndedViewDefinition(connection, vector, new int[]{n}, tXColumn.getDataLocation());
            this.setViewDefinition(n, stringBuffer);
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
            this.setViewDefinition(n, null);
        }
        return stringBuffer;
    }

    protected StringBuffer createNumericOpenEndedViewDefinition(Connection connection, Vector vector, int[] nArray, String string) {
        Object object;
        int n = vector.size();
        if (n != 1) {
            return this.createNumericOpenEndedViewDefinition(connection, vector, nArray, string);
        }
        String string2 = (String)vector.elementAt(0);
        String string3 = this.getComplexAttributeInfo(string2);
        if (string3 == null) {
            return super.createNumericOpenEndedViewDefinition(connection, vector, nArray, string);
        }
        TXColumn tXColumn = this.m_cdsSampledData.getTXColumn(string3);
        StringBuffer stringBuffer = new StringBuffer("SELECT \n");
        DiscretizeDataSource.BinBoundMap binBoundMap = new DiscretizeDataSource.BinBoundMap(n);
        Hashtable<String, BinningType> hashtable = new Hashtable<String, BinningType>();
        for (int i = 0; i < nArray.length; ++i) {
            object = this.getAttributeName(nArray[i]);
            hashtable.put((String)object, BinningType.getInstance(this.getBinType(nArray[i])));
            Vector vector2 = this.getBinBounds(nArray[i]);
            if (vector2 == null || vector2.size() == 0) continue;
            Bin[] binArray = new Bin[vector2.size()];
            binArray = vector2.toArray(binArray);
            for (int j = 0; j < binArray.length; ++j) {
                int n2 = binArray[j].getBinNumber();
                double d = binArray[j].getLowerBound();
                double d2 = binArray[j].getUpperBound();
                binBoundMap.addBinBound("\"" + (String)object + "\"", new DiscretizeDataSource.BinBound(n2, d, d2));
            }
        }
        String string4 = "\"" + string2 + "\"";
        object = (BinningType)hashtable.get(string2);
        if (binBoundMap.isEmpty(string4)) {
            stringBuffer.append(tXColumn.getValueColumn());
        } else if (binBoundMap.size(string4) == 1) {
            stringBuffer.append("( CASE ");
            stringBuffer.append("WHEN ");
            stringBuffer.append(tXColumn.getValueColumn());
            stringBuffer.append(" is not null then 1 end) " + string4);
        } else if (((BinningType)object).equal(BinningType.QTILE)) {
            this.prepareQtileDefinitionTXSingleM(stringBuffer, binBoundMap, string4, "\"" + tXColumn.getValueColumn() + "\"");
        } else {
            this.prepareEqWidthDefinitionTXSingleM(stringBuffer, binBoundMap, string4, "\"" + tXColumn.getValueColumn() + "\"");
        }
        stringBuffer.append("\n");
        binBoundMap.clear();
        stringBuffer.append(" FROM " + string);
        return stringBuffer;
    }

    protected void prepareQtileDefinitionTXSingleM(StringBuffer stringBuffer, DiscretizeDataSource.BinBoundMap binBoundMap, String string, String string2) {
        stringBuffer.append("( CASE ");
        Vector vector = binBoundMap.getBinBounds(string);
        for (int i = 1; i < vector.size(); ++i) {
            stringBuffer.append("WHEN ");
            DiscretizeDataSource.BinBound binBound = (DiscretizeDataSource.BinBound)vector.elementAt(i);
            if (i == 1) {
                stringBuffer.append(string2 + " < " + DM4JNumericFormat.SQLFormat(binBound.m_upperBound) + " THEN ");
                stringBuffer.append(String.valueOf(i));
            } else if (i == vector.size() - 1) {
                stringBuffer.append(string2 + " > " + DM4JNumericFormat.SQLFormat(binBound.m_lowerBound) + " THEN " + i);
            } else {
                stringBuffer.append(string2 + " <= " + DM4JNumericFormat.SQLFormat(binBound.m_upperBound) + " THEN " + i);
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append(" end) " + string2);
    }

    protected void prepareEqWidthDefinitionTXSingleM(StringBuffer stringBuffer, DiscretizeDataSource.BinBoundMap binBoundMap, String string, String string2) {
        stringBuffer.append("( CASE ");
        Vector vector = binBoundMap.getBinBounds(string);
        for (int i = 0; i < vector.size(); ++i) {
            stringBuffer.append("WHEN ");
            DiscretizeDataSource.BinBound binBound = (DiscretizeDataSource.BinBound)vector.elementAt(i);
            if (i == 0) {
                stringBuffer.append(string2 + " < " + DM4JNumericFormat.SQLFormat(binBound.m_upperBound) + " THEN ");
                stringBuffer.append(String.valueOf(i + 1));
            } else if (i == vector.size() - 1) {
                stringBuffer.append(string2 + " >= " + DM4JNumericFormat.SQLFormat(binBound.m_lowerBound) + " THEN " + (i + 1));
            } else {
                DiscretizeDataSource.BinBound binBound2 = (DiscretizeDataSource.BinBound)vector.elementAt(i - 1);
                stringBuffer.append(string2 + " >= " + DM4JNumericFormat.SQLFormat(binBound2.m_upperBound) + " AND " + string2 + " < " + DM4JNumericFormat.SQLFormat(binBound.m_upperBound) + " THEN " + (i + 1));
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append("else null end) " + string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void getEqualWidth2ndorderStats(Connection connection, int n, double[] dArray, String string) {
        Object object;
        String string2 = (String)this.getData(16, n);
        if (string2 == null) {
            super.getEqualWidth2ndorderStats(connection, n, dArray, string);
            return;
        }
        TXColumn tXColumn = this.m_cdsSampledData.getTXColumn(string2);
        Integer n2 = this.getTotalCount(n);
        Double d = this.getSigma(n);
        if (n2 == null || d == null) {
            object = this.getEqualWidthStdevCount(connection, "\"" + string + "\"", this.getSamplingViewDefinition());
            dArray[ExtraDataSource.STAT_TOTAL] = object[ExtraDataSource.STAT_TOTAL];
            dArray[ExtraDataSource.STAT_STDEV] = object[ExtraDataSource.STAT_STDEV];
            dArray[ExtraDataSource.STAT_VARIANCE] = object[ExtraDataSource.STAT_VARIANCE];
            this.setTotalCount(n, (int)dArray[ExtraDataSource.STAT_TOTAL]);
            this.setStdev(n, dArray[ExtraDataSource.STAT_STDEV]);
            this.setVariance(n, dArray[ExtraDataSource.STAT_VARIANCE]);
        }
        object = null;
        ResultSet resultSet = null;
        Object[] objectArray = new Object[]{String.valueOf(dArray[ExtraDataSource.STAT_AVERAGE]), "\"" + tXColumn.getValueColumn() + "\"", String.valueOf((int)dArray[ExtraDataSource.STAT_TOTAL]), String.valueOf(dArray[ExtraDataSource.STAT_STDEV]), tXColumn.getDataLocation()};
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < DiscretizeDataSource.STAT_SQL_EQ_WIDTH_2ND_ORDER.length; ++i) {
            String string3 = MessageFormat.format(DiscretizeDataSource.STAT_SQL_EQ_WIDTH_2ND_ORDER[i], objectArray);
            stringBuffer.append(string3);
        }
        if (dArray[ExtraDataSource.STAT_STDEV] != 0.0) {
            try {
                object = connection.createStatement();
                resultSet = object.executeQuery(stringBuffer.toString());
                if (!resultSet.next()) return;
                double d2 = resultSet.getDouble("Skew");
                double d3 = resultSet.getDouble("Kurtosis");
                this.setKurtosis(n, new Double(d3));
                this.setSkew(n, new Double(d2));
                return;
            }
            catch (Exception exception) {
                if (!DiscretizeDataSource.isDebug()) return;
                exception.printStackTrace();
                return;
            }
            finally {
                try {
                    resultSet.close();
                    object.close();
                }
                catch (Exception exception) {}
            }
        }
        this.setKurtosis(n, new Double(0.0));
        this.setSkew(n, new Double(0.0));
    }

    protected void addCategoricColumnNamesForStats(Vector vector, Hashtable hashtable, String string, String string2, String string3, int n) {
        if ((string2.equals("CHAR") || string2.equals("VARCHAR2") || string2.equals("DM_NESTED_CATEGORICALS") || string2.equals("DM_NESTED_NUMERICALS")) && string3.equals("categorical")) {
            vector.add(string);
            hashtable.put(string, new Integer(n));
        }
    }
}

