/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.datamining.data.AttributeType;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.browser.UserPreferences;
import oracle.dmt.dm4j.datasources.CDSDataSource;
import oracle.dmt.dm4j.datasources.CDSLDSDataSource;
import oracle.dmt.dm4j.datasources.ComplexDataStructure;
import oracle.dmt.dm4j.datasources.DiscretizationLDSDataSource;
import oracle.dmt.dm4j.datasources.DiscretizeDataSource;
import oracle.dmt.dm4j.datasources.TXColumn;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.odm.binning.DM4JTransformation;

public class CDSDiscretizeDataSource
extends DiscretizeDataSource {
    protected static String SQL_SAMPLING_VIEW_TX = " select tx.* from {0} tx, {1} sampled_view where sampled_view.{2} = tx.{3}";

    public boolean isLabels() {
        return false;
    }

    public CDSDiscretizeDataSource(Connection connection, DiscretizationLDSDataSource discretizationLDSDataSource, String string, String string2, String string3, boolean bl) throws Exception {
        this(connection, discretizationLDSDataSource, string, string2, string3);
        this.m_bAutoRun = bl;
        this.setLabels(false);
    }

    public CDSDiscretizeDataSource(Connection connection, DiscretizationLDSDataSource discretizationLDSDataSource, String string, String string2, String string3) throws Exception {
        super(connection);
        this.m_preferences = UserPreferences.getInstance();
        this.setLabels(false);
        this.m_lds = discretizationLDSDataSource;
        if (discretizationLDSDataSource instanceof CDSLDSDataSource) {
            this.m_sampledInputCDS = ((CDSLDSDataSource)discretizationLDSDataSource).getSampledDataStructure();
            this.m_origInputCDS = ((CDSLDSDataSource)discretizationLDSDataSource).getOriginalDataStructure();
        }
        this.m_userSchemaName = string;
        if (string2 == null) {
            this.m_resultViewName = ValidationUtil.createUniqueTableName(RESULT_VIEW_NAME, connection, "_S");
            this.m_bRemoveResultView = true;
        } else {
            this.m_resultViewName = string2;
        }
        if (string3 == null) {
            this.m_originalResultViewName = ValidationUtil.createUniqueTableName(RESULT_VIEW_NAME, connection, "");
            this.m_bRemoveResultView = true;
        } else {
            this.m_originalResultViewName = string3;
        }
        String string4 = this.m_sampledInputCDS.getCaseTable();
        String string5 = this.m_sampledInputCDS.getCaseSchema();
        if (string4 != null && string4.length() != 0) {
            this.m_sDataLocation = string5 != null && string5.length() != 0 ? "\"" + string5 + "\".\"" + string4 + "\"" : "\"" + string4 + "\"";
            this.getSampledDataLocation();
        } else if (!this.m_sampledInputCDS.isSingleMetric()) {
            this.m_sDataLocation = this.m_sampledInputCDS.getDataLocation();
            this.m_samplingTableName = ValidationUtil.createUniqueTableName(SAMPLING_TABLE_PREFIX, connection, "");
            this.m_attributeMapping = this.m_sampledInputCDS.getAttributeNameColumn();
            this.m_valueMapping = this.m_sampledInputCDS.getValueColumn();
            this.m_seqIdMapping = this.m_sampledInputCDS.getCaseIdColumn();
            this.m_isTransactional = true;
            this.m_numericalDiscretizationTableName = ValidationUtil.createUniqueTableName(NUMERIC_BIN_TABLE_PREFIX, connection, "");
            this.m_categoricalDiscretizationTableName = ValidationUtil.createUniqueTableName(CATEGORIC_BIN_TABLE_PREFIX, connection, "");
            DM4JTransformation.createPhysicalTables(connection, this.m_numericalDiscretizationTableName, this.m_categoricalDiscretizationTableName, this.m_userSchemaName);
            this.m_sampledInternallySampledCDS = new ComplexDataStructure(this.m_sampledInputCDS.getName() + "_SAMPLED", null, null, null);
            TXColumn tXColumn = this.m_sampledInputCDS.getTXColumn();
            this.m_sampledInternallySampledCDS.addTxDataSource(tXColumn);
            this.m_txSampledViewDefinition = this.createTXViewDefinition(this.m_sampledInternallySampledCDS.getDataLocation(), this.m_userSchemaName, this.m_resultViewName);
            this.m_txViewDefinition = this.createTXViewDefinition(this.m_sDataLocation, this.m_userSchemaName, this.m_resultViewName);
        } else {
            this.getSampledDataLocation();
        }
    }

    public String getSampledDataLocation() {
        if (this.m_sampledInputCDS == null) {
            return null;
        }
        if (this.m_helper == null) {
            this.m_helper = new CDSDataSource(this, this.m_collectColumnNames);
        }
        return this.m_helper.getSamplingViewDefinition();
    }

    protected void createData() throws Exception {
        this.m_helper.createData();
    }

    public void augmentDataSource(Connection connection, Hashtable hashtable, DiscretizationLDSDataSource discretizationLDSDataSource) throws Exception {
        block4: {
            this.m_lds = discretizationLDSDataSource;
            try {
                int n = this.getRowCount();
                Enumeration enumeration = hashtable.keys();
                Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>();
                Vector<String> vector = new Vector<String>();
                Vector<String> vector2 = new Vector<String>();
                Hashtable<String, Integer> hashtable3 = new Hashtable<String, Integer>();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    String string2 = (String)hashtable.get(string);
                    AttributeType attributeType = (AttributeType)m_AttributeType.get(string2);
                    if (attributeType == null || !attributeType.equals(AttributeType.numerical)) continue;
                    this.addRows(++n - 1, 1);
                    this.setAttributeName(n - 1, string);
                    this.setMiningType(n - 1, string2);
                    this.setData(DiscretizeDataSource.COLUMN_NAMES.DTYPE, n - 1, this.m_lds.getDataType(string));
                    this.setBinTypeNONE(n - 1);
                    this.setNumberOfBins(n - 1);
                    this.setData(DiscretizeDataSource.COLUMN_NAMES.TAILPERCENT, n - 1, null);
                    this.setViewDefinition(n - 1, null);
                    this.setDisplayNames(n - 1, null);
                    this.setData(DiscretizeDataSource.COLUMN_NAMES.SKEW, n - 1, null);
                    this.setData(DiscretizeDataSource.COLUMN_NAMES.KURT, n - 1, null);
                    String string3 = this.m_lds.getComplexAttributeInfo(string);
                    this.setComplexAttribute(n - 1, string3);
                    if (string3 == null) {
                        vector.add(string);
                        hashtable2.put(string, new Integer(n - 1));
                        continue;
                    }
                    vector2.add(string);
                    hashtable3.put(string, new Integer(n - 1));
                }
                this.addNumericStats2D(connection, vector, hashtable2, null);
                this.m_helper.addComplexStatsNum(connection, vector2, hashtable3);
                hashtable2.clear();
                vector.clear();
                vector2.clear();
                hashtable3.clear();
            }
            catch (Exception exception) {
                if (!CDSDiscretizeDataSource.isDebug()) break block4;
                exception.printStackTrace();
            }
        }
    }

    protected void getQtileStats(Connection connection, Vector vector, Hashtable hashtable, String string, int n) {
        this.m_helper.quantileBinning2D(connection, vector, hashtable, string, n);
    }

    protected void processNumTxSource(String string, String string2, String string3, Object object, Hashtable hashtable) throws Exception {
        this.m_helper.processNumTxSource(string, string2, string3, object, hashtable);
    }

    public int[] getNumericFrequency(Connection connection, String string, int n, boolean bl) {
        if (!this.isNumeric(n)) {
            return this.getCategoricAttributeFrequency(connection, n, string, this.getSampledDataLocation());
        }
        String string2 = this.getComplexAttribute(n);
        if (string2 == null) {
            return super.getNumericFrequency(connection, string, n, bl);
        }
        return this.m_helper.getNumericFrequency(connection, string, n, bl);
    }

    public void getEqualWidth2ndorderStats(Connection connection, int n, double[] dArray, String string, String string2) {
        String string3 = this.getComplexAttribute(n);
        if (string3 == null) {
            super.getEqualWidth2ndorderStats(connection, n, dArray, string, string2);
            return;
        }
        this.m_helper.getEqualWidth2ndorderStats(connection, n, dArray, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNumericStats(Vector vector, Hashtable hashtable, String string) {
        if (vector == null || vector.isEmpty()) {
            return;
        }
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            if (this.m_isTransactional) {
                this.addNumericStatsTX(connection, hashtable, string);
            } else {
                Vector<String> vector2 = new Vector<String>();
                Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>();
                Vector<String> vector3 = new Vector<String>();
                Hashtable<String, Integer> hashtable3 = new Hashtable<String, Integer>();
                for (int i = 0; i < vector.size(); ++i) {
                    String string2 = (String)vector.elementAt(i);
                    String string3 = this.m_lds.getComplexAttributeInfo(string2);
                    int n = this.getAttributeRow(string2);
                    if (string3 == null) {
                        vector2.add(string2);
                        hashtable2.put(string2, new Integer(n));
                        continue;
                    }
                    vector3.add(string2);
                    hashtable3.put(string2, new Integer(n));
                }
                this.addNumericStats2D(connection, vector2, hashtable2, string);
                this.m_helper.addComplexStatsNum(connection, vector3, hashtable3);
                hashtable2.clear();
                vector2.clear();
                vector3.clear();
                hashtable3.clear();
            }
        }
        catch (Exception exception) {
            if (CDSDiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getCustomStats(Connection connection, String string, double d, double d2) {
        String string2 = this.m_lds.getComplexAttributeInfo(string);
        if (string2 == null) {
            return super.getCustomStats(connection, string, d, d2);
        }
        TXColumn tXColumn = this.m_sampledInternallySampledCDS.getTXColumn(string2);
        Statement statement = null;
        ResultSet resultSet = null;
        Object[] objectArray = new Object[]{"\"" + tXColumn.getValueColumn() + "\"", tXColumn.getDataLocation(), DM4JNumericFormat.format(d), DM4JNumericFormat.SQLFormat(d2)};
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = null;
        for (int i = 0; i < STAT_SQL_CUSTOM_1ST_ORDER.length; ++i) {
            string3 = MessageFormat.format(STAT_SQL_CUSTOM_1ST_ORDER[i], objectArray);
            stringBuffer.append(string3);
        }
        double[] dArray = new double[NUMBER_STATS];
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(stringBuffer.toString());
            if (resultSet.next()) {
                dArray[CDSDiscretizeDataSource.STAT_TOTAL] = resultSet.getInt("N");
                dArray[CDSDiscretizeDataSource.STAT_AVERAGE] = resultSet.getDouble("Average");
                dArray[CDSDiscretizeDataSource.STAT_MAX] = resultSet.getDouble("Max");
                dArray[CDSDiscretizeDataSource.STAT_MIN] = resultSet.getDouble("Min");
                dArray[CDSDiscretizeDataSource.STAT_VARIANCE] = resultSet.getDouble("Variance");
                dArray[CDSDiscretizeDataSource.STAT_STDEV] = Math.sqrt(dArray[STAT_VARIANCE]);
            }
        }
        catch (Exception exception) {
            if (CDSDiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
            dArray = null;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
        return dArray;
    }

    public StringBuffer getSingleNumericAttributeViewDefinition(Connection connection, int n, boolean bl) {
        return this.m_helper.getSingleNumericAttributeViewDefinition(connection, n, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getCustom2ndorderStats(Connection connection, int n, double[] dArray, String string, double d, double d2) {
        Object object;
        String string2 = this.getComplexAttribute(n);
        if (string2 == null) {
            super.getCustom2ndorderStats(connection, n, dArray, string, d, d2);
            return;
        }
        TXColumn tXColumn = this.m_sampledInternallySampledCDS.getTXColumn(string2);
        String string3 = tXColumn.getValueColumn();
        Integer n2 = (Integer)this.getData(DiscretizeDataSource.COLUMN_NAMES.TOTAL, n);
        Double d3 = (Double)this.getData(DiscretizeDataSource.COLUMN_NAMES.STDDEV, n);
        if (n2 == null || d3 == null) {
            object = this.getCustomStdevCount(connection, "\"" + string3 + "\"", d, d2);
            dArray[CDSDiscretizeDataSource.STAT_TOTAL] = object[STAT_TOTAL];
            dArray[CDSDiscretizeDataSource.STAT_STDEV] = object[STAT_STDEV];
            dArray[CDSDiscretizeDataSource.STAT_VARIANCE] = object[STAT_VARIANCE];
            this.setData(DiscretizeDataSource.COLUMN_NAMES.TOTAL, n, new Integer((int)dArray[STAT_TOTAL]));
            this.setData(DiscretizeDataSource.COLUMN_NAMES.STDDEV, n, new Double(dArray[STAT_STDEV]));
            this.setData(DiscretizeDataSource.COLUMN_NAMES.VAR, n, new Double(dArray[STAT_VARIANCE]));
        }
        object = null;
        ResultSet resultSet = null;
        Object[] objectArray = new Object[]{String.valueOf(dArray[STAT_AVERAGE]), "\"" + string3 + "\"", String.valueOf((int)dArray[STAT_TOTAL]), String.valueOf(dArray[STAT_STDEV]), tXColumn.getDataLocation(), String.valueOf(d), String.valueOf(d2)};
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < STAT_SQL_CUSTOM_2ND_ORDER.length; ++i) {
            String string4 = MessageFormat.format(STAT_SQL_CUSTOM_2ND_ORDER[i], objectArray);
            stringBuffer.append(string4);
        }
        try {
            object = connection.createStatement();
            resultSet = object.executeQuery(stringBuffer.toString());
            if (resultSet.next()) {
                double d4 = resultSet.getDouble("Skew");
                double d5 = resultSet.getDouble("Kurtosis");
                this.setKurtosis(n, new Double(d5));
                this.setSkew(n, new Double(d4));
            }
        }
        catch (Exception exception) {
            if (CDSDiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                resultSet.close();
                object.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getEqualWidthStats(Connection connection, String string, String string2) {
        Object object2;
        String string3 = this.m_lds.getComplexAttributeInfo(string);
        if (string3 == null) {
            return super.getEqualWidthStats(connection, string, string2);
        }
        String string4 = null;
        TreeMap treeMap = this.m_sampledInternallySampledCDS.getColumnMap();
        if (treeMap == null || treeMap.isEmpty()) {
            return null;
        }
        TXColumn tXColumn = null;
        Set set = treeMap.keySet();
        for (Object object2 : set) {
            tXColumn = (TXColumn)treeMap.get(object2);
            if (tXColumn == null || 0 != string.compareTo(tXColumn.getUniqueName())) continue;
            string4 = tXColumn.getValueColumn();
            break;
        }
        if (string4 == null || 0 == string4.length() || tXColumn == null) {
            return null;
        }
        object2 = null;
        ResultSet resultSet = null;
        Object[] objectArray = new Object[]{"\"" + string4 + "\"", tXColumn.getDataLocation()};
        String string5 = MessageFormat.format(STAT_SQL_EQ_WIDTH_1ST_ORDER, objectArray);
        double[] dArray = new double[NUMBER_STATS];
        try {
            object2 = connection.createStatement();
            resultSet = object2.executeQuery(string5);
            if (resultSet.next()) {
                dArray[CDSDiscretizeDataSource.STAT_TOTAL] = resultSet.getInt("N");
                dArray[CDSDiscretizeDataSource.STAT_AVERAGE] = resultSet.getDouble("Average");
                dArray[CDSDiscretizeDataSource.STAT_MAX] = resultSet.getDouble("Max");
                dArray[CDSDiscretizeDataSource.STAT_MIN] = resultSet.getDouble("Min");
                dArray[CDSDiscretizeDataSource.STAT_VARIANCE] = resultSet.getDouble("Variance");
                dArray[CDSDiscretizeDataSource.STAT_STDEV] = Math.sqrt(dArray[STAT_VARIANCE]);
            }
        }
        catch (Exception exception) {
            if (CDSDiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
            dArray = null;
        }
        finally {
            try {
                resultSet.close();
                object2.close();
            }
            catch (Exception exception) {}
        }
        return dArray;
    }
}

