/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;
import javax.datamining.data.AttributeType;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.AttributeImportanceActivity;
import oracle.dmt.dm4j.activity.data.Column;
import oracle.dmt.dm4j.activity.data.RelationshipType;
import oracle.dmt.dm4j.activity.data.Table;
import oracle.dmt.dm4j.datasources.CDSOutlierDiscretizeDataSource;
import oracle.dmt.dm4j.datasources.CategoricDiscretizeDataSource;
import oracle.dmt.dm4j.datasources.ComplexDataStructure;
import oracle.dmt.dm4j.datasources.DiscretizationLDSDataSource;
import oracle.dmt.dm4j.datasources.DiscretizeDataSource;
import oracle.dmt.dm4j.datasources.TXColumn;
import oracle.dmt.dm4j.wizard.director.transforms.TransformsDirector;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.odm.binning.Bin;
import oracle.dmt.odm.binning.BinningType;
import oracle.dmt.odm.binning.CategoricBin;

public class CDSDataSource {
    private static String STATS_SQL_NUM = "count({0}) as N, count(distinct {0}) as D, count(*) as T,  avg({0}) as Average, MAX({0}) Max , MIN({0}) Min, VARIANCE({0}) as Variance";
    private String STATS_SQL_CAT = "count({0}) as N, count(distinct {0}) as D, stats_mode({0}) as S, count (*) as T";
    static String SQL_SAMPLING_VIEW_TX = " select tx.* from {0} tx, {1} sampled_view where sampled_view.{2} = tx.{3}";
    private boolean m_collectColumnNames;
    private DiscretizeDataSource m_targetDataSource;
    private DiscretizationLDSDataSource m_lds;
    private String m_targetColumn;
    private String m_caseidColumn;
    private String m_textColumn;
    private Hashtable m_excludedAttributes = new Hashtable();
    private HashSet m_sparseAttributes = new HashSet();

    CDSDataSource(DiscretizeDataSource discretizeDataSource, boolean bl) {
        this.m_targetDataSource = discretizeDataSource;
        this.m_lds = this.m_targetDataSource.m_lds;
        this.m_collectColumnNames = bl;
        this.initExcludedAttributes();
    }

    private void initExcludedAttributes() {
        Column column;
        Column column2;
        AbstractActivity abstractActivity = this.m_lds.getActivity();
        if (!(abstractActivity instanceof AttributeImportanceActivity) && (column2 = abstractActivity.getTargetColumn()) != null) {
            this.m_targetColumn = column2.getAlias();
            this.m_excludedAttributes.put(this.m_targetColumn, "TARGET");
        }
        if ((column2 = abstractActivity.getCaseColumn()) != null) {
            this.m_caseidColumn = column2.getAlias();
            this.m_excludedAttributes.put(this.m_caseidColumn, "CASEID");
        }
        if ((column = abstractActivity.getTextColumn()) != null) {
            this.m_textColumn = column.getAlias();
            this.m_excludedAttributes.put(this.m_textColumn, "TEXT");
        }
    }

    protected void intSparseAttributes() {
        AbstractActivity abstractActivity = this.m_lds.getActivity();
        LinkedHashSet linkedHashSet = abstractActivity.getTables();
        for (Table table : linkedHashSet) {
            RelationshipType relationshipType = table.getRelationship();
            if (!this.isTwoDimensional(relationshipType)) continue;
            LinkedHashMap linkedHashMap = table.getColumns();
            Set set = linkedHashMap.keySet();
            for (String string : set) {
                Column column = (Column)linkedHashMap.get(string);
                String string2 = column.getAlias();
                int n = this.m_targetDataSource.getAttributeRow(string2);
                if (n != -1) {
                    if (!this.m_targetDataSource.getSparsityFlag(n)) continue;
                    this.m_sparseAttributes.add(string2);
                    continue;
                }
                n = this.m_targetDataSource.m_additionalSource.getAttributeRow(string2);
                if (n == -1 || !this.m_targetDataSource.m_additionalSource.getSparsityFlag(n)) continue;
                this.m_sparseAttributes.add(string2);
            }
        }
    }

    private boolean isTwoDimensional(RelationshipType relationshipType) {
        return relationshipType.equals(0) || relationshipType.equals(1);
    }

    void createData() throws Exception {
        this.createDataFromComplexStructure();
        this.initializeComplexDataStructures();
        if (this.m_targetDataSource.isDefaultProcessing()) {
            this.m_targetDataSource.performDefaultTreatment();
        }
        this.m_targetDataSource.callCreateData();
    }

    void initializeComplexDataStructures() {
        DiscretizeDataSource discretizeDataSource = this.m_targetDataSource.m_additionalSource;
        if (this.m_targetDataSource.getSampledInputCDS() != null && this.m_targetDataSource.getSampledInternallySampledCDS() != null) {
            if (discretizeDataSource != null) {
                discretizeDataSource.setSampledInputCDS(this.m_targetDataSource.getSampledInputCDS());
                discretizeDataSource.setSampledInternallySampledCDS(this.m_targetDataSource.getSampledInternallySampledCDS());
            }
            if (null != this.m_targetDataSource.getSampledInternallySampledCDS().getCaseTable()) {
                this.m_targetDataSource.setSampledOutputCDS(ComplexDataStructure.createOutputComplexDataStructure(this.m_targetDataSource.getSampledInputCDS().getName() + "SAMPLED_RESULT", this.m_targetDataSource.getSampledInputCDS(), this.m_targetDataSource.getResultViewName()));
                ComplexDataStructure complexDataStructure = null;
                try {
                    complexDataStructure = new ComplexDataStructure(this.m_targetDataSource.getOriginalInputCDS().getName() + "ORIGINAL_RESULT", this.m_targetDataSource.getOriginalResultViewName(), this.m_targetDataSource.getSampledOutputCDS().getCaseSchema(), this.m_targetDataSource.getSampledOutputCDS().getCaseId());
                    complexDataStructure.setColumnMap(this.m_targetDataSource.getSampledOutputCDS().getColumnMap());
                }
                catch (Exception exception) {
                    complexDataStructure = null;
                    exception.printStackTrace();
                }
                this.m_targetDataSource.setOriginalOutputCDS(complexDataStructure);
                if (discretizeDataSource != null) {
                    discretizeDataSource.setOriginalOutputCDS(complexDataStructure);
                    discretizeDataSource.setOriginalInputCDS(this.m_targetDataSource.getOriginalInputCDS());
                }
            } else {
                this.m_targetDataSource.setSampledOutputCDS(new ComplexDataStructure(this.m_targetDataSource.getSampledInputCDS().getName() + "_RESULT", null, null, null));
                try {
                    this.m_targetDataSource.getSampledOutputCDS().addTxDataSourceTable(this.m_targetDataSource.getSampledInputCDS().getTXColumn(), this.m_targetDataSource.m_resultViewName);
                }
                catch (Exception exception) {
                    this.m_targetDataSource.setSampledOutputCDS(null);
                }
            }
            if (discretizeDataSource != null) {
                discretizeDataSource.setSampledOutputCDS(this.m_targetDataSource.getSampledOutputCDS());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createDataFromComplexStructure() throws Exception {
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            if (this.m_collectColumnNames) {
                this.m_targetDataSource.setColumns(this.m_lds.getAllAttributes());
            }
            int n = 0;
            Vector vector = this.m_lds.getAllAttributes();
            Vector<String> vector2 = new Vector<String>();
            Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
            Vector<String> vector3 = new Vector<String>();
            Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>();
            for (int i = 0; i < vector.size(); ++i) {
                String string;
                AttributeType attributeType;
                String string2 = (String)vector.elementAt(i);
                if (null != this.m_excludedAttributes.get(string2) || (attributeType = this.m_targetDataSource.getAttributeType(string = this.m_lds.getMiningType(string2))) == null || !attributeType.equals(AttributeType.numerical)) continue;
                this.m_targetDataSource.addRows(++n - 1, 1);
                this.m_targetDataSource.setAttributeName(n - 1, string2);
                this.m_targetDataSource.setMiningType(n - 1, string);
                this.m_targetDataSource.setData(DiscretizeDataSource.COLUMN_NAMES.DTYPE, n - 1, this.m_lds.getDataType(string2));
                this.m_targetDataSource.setBinTypeNONE(n - 1);
                this.m_targetDataSource.setNumberOfBins(n - 1);
                this.m_targetDataSource.setData(DiscretizeDataSource.COLUMN_NAMES.TAILPERCENT, n - 1, null);
                this.m_targetDataSource.setViewDefinition(n - 1, null);
                this.m_targetDataSource.setDisplayNames(n - 1, null);
                this.m_targetDataSource.setData(DiscretizeDataSource.COLUMN_NAMES.SKEW, n - 1, null);
                this.m_targetDataSource.setData(DiscretizeDataSource.COLUMN_NAMES.KURT, n - 1, null);
                String string3 = this.m_lds.getComplexAttributeInfo(string2);
                this.m_targetDataSource.setComplexAttribute(n - 1, string3);
                if (string3 == null) {
                    vector2.add(string2);
                    hashtable.put(string2, new Integer(n - 1));
                    continue;
                }
                vector3.add(string2);
                hashtable2.put(string2, new Integer(n - 1));
            }
            this.m_targetDataSource.addNumericStats2D(connection, vector2, hashtable, null);
            this.addComplexStatsNum(connection, vector3, hashtable2);
            hashtable.clear();
            vector2.clear();
            vector3.clear();
            hashtable2.clear();
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addComplexStatsNum(Connection connection, Vector vector, Hashtable hashtable) {
        if (vector == null || vector.isEmpty()) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            StringBuffer stringBuffer = new StringBuffer("SELECT /*+ parallel (t1) */");
            String string = (String)vector.elementAt(i);
            String string2 = this.m_lds.getComplexAttributeInfo(string);
            TXColumn tXColumn = this.m_targetDataSource.getSampledInternallySampledCDS().getTXColumn(string2);
            if (tXColumn == null) continue;
            String string3 = MessageFormat.format(STATS_SQL_NUM, "\"" + tXColumn.getValueColumn() + "\"", String.valueOf(i));
            stringBuffer.append(string3);
            String string4 = MessageFormat.format(" from (({0}) t1)", tXColumn.getDataLocation());
            stringBuffer.append(string4);
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                Integer n;
                statement = connection.createStatement();
                resultSet = statement.executeQuery(stringBuffer.toString());
                if (!resultSet.next() || (n = (Integer)hashtable.get(string)) == null) continue;
                int n2 = resultSet.getInt("N");
                this.m_targetDataSource.setData(DiscretizeDataSource.COLUMN_NAMES.TOTAL, n, new Integer(n2));
                int n3 = resultSet.getInt("T");
                int n4 = n3 - n2;
                double d = (double)n4 / (double)n3 * 100.0;
                this.m_targetDataSource.setData(DiscretizeDataSource.COLUMN_NAMES.MISSING_PERCENT, n, new Double(d));
                this.m_targetDataSource.setData(DiscretizeDataSource.COLUMN_NAMES.SPARSITY_FLAG, n, new Boolean(true));
                int n5 = resultSet.getInt("D");
                this.m_targetDataSource.setData(DiscretizeDataSource.COLUMN_NAMES.DISTINCT, n, new Integer(n5));
                double d2 = resultSet.getDouble("Average");
                this.m_targetDataSource.setData(DiscretizeDataSource.COLUMN_NAMES.AVG, n, new Double(d2));
                d2 = resultSet.getDouble("Max");
                this.m_targetDataSource.setData(DiscretizeDataSource.COLUMN_NAMES.MAX, n, new Double(d2));
                d2 = resultSet.getDouble("Min");
                this.m_targetDataSource.setData(DiscretizeDataSource.COLUMN_NAMES.MIN, n, new Double(d2));
                d2 = resultSet.getDouble("Variance");
                this.m_targetDataSource.setData(DiscretizeDataSource.COLUMN_NAMES.VAR, n, new Double(d2));
                d2 = Math.sqrt(d2);
                this.m_targetDataSource.setData(DiscretizeDataSource.COLUMN_NAMES.STDDEV, n, new Double(d2));
                continue;
            }
            catch (Exception exception) {
                if (!DiscretizeDataSource.isDebug()) continue;
                exception.printStackTrace();
                continue;
            }
            finally {
                try {
                    resultSet.close();
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    String getSamplingViewDefinition() {
        Object[] objectArray;
        String string;
        String string2;
        int n;
        if (!(this.m_targetDataSource instanceof CDSOutlierDiscretizeDataSource) && this.m_targetDataSource.getSampledInternallySampledCDS() != null) {
            return this.m_targetDataSource.getSampledInternallySampledCDS().getCaseTable();
        }
        Vector vector = new Vector();
        if (this.m_lds != null) {
            vector = this.m_lds.getAttributes(false, false);
        } else if (!this.m_targetDataSource.m_tableColumns.isEmpty()) {
            vector = this.m_targetDataSource.m_tableColumns;
        }
        if (vector.isEmpty()) {
            return null;
        }
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = null;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < vector.size(); ++n) {
            string2 = (String)vector.elementAt(n);
            string = this.m_lds.getComplexAttributeInfo(string2);
            if (string != null) {
                if (vector3 == null) {
                    vector3 = new Vector<String>();
                }
                vector3.add(string2);
                continue;
            }
            vector2.add(string2);
        }
        for (n = 0; n < vector2.size(); ++n) {
            string2 = (String)vector2.elementAt(n);
            stringBuffer.append(this.m_targetDataSource.applyTreatment(string2));
            if (n >= vector2.size() - 1) continue;
            stringBuffer.append(",");
        }
        String string3 = this.m_targetDataSource.getSampledInputCDS().getCaseTable();
        string2 = null;
        string = null;
        if (string3 != null && string3.length() != 0) {
            Object[] objectArray2 = new Object[]{stringBuffer.toString(), this.m_targetDataSource.getOriginalDataLocation(), String.valueOf(this.m_targetDataSource.m_preferences.getSampleSize())};
            string2 = MessageFormat.format("(SELECT {0} FROM (  WITH s AS (SELECT COUNT(*) c FROM {1})   SELECT t.* FROM s, (SELECT t.*, ROWNUM RNUM FROM {1} t) t WHERE ORA_HASH(RNUM,(s.c-1),0) < {2} ))", objectArray2);
            objectArray = new Object[]{stringBuffer.toString(), this.m_targetDataSource.getOriginalDataLocation(), String.valueOf(this.m_targetDataSource.m_preferences.getSampleSize()), "<case_count>"};
            string = MessageFormat.format("(SELECT {0} FROM (\n  SELECT t.* FROM (SELECT t.*, ROWNUM RNUM FROM {1} t) t WHERE ORA_HASH(RNUM,({3}-1),0) < {2} ))", objectArray);
        }
        this.m_targetDataSource.setSampledInternallySampledCDS(new ComplexDataStructure(this.m_targetDataSource.getSampledInputCDS().getName() + "_SAMPLED", string2, this.m_targetDataSource.getSampledInputCDS().getCaseSchema(), this.m_targetDataSource.getSampledInputCDS().getCaseId()));
        if (string != null) {
            this.m_targetDataSource.getSampledInternallySampledCDS().setSampledCaseTable(string);
        }
        if (vector3 == null || vector3.isEmpty()) {
            return this.m_targetDataSource.getSampledInternallySampledCDS().getCaseTable();
        }
        for (int i = 0; i < vector3.size(); ++i) {
            objectArray = (Object[])vector3.elementAt(i);
            String string4 = this.m_lds.getComplexAttributeInfo((String)objectArray);
            TXColumn tXColumn = this.m_targetDataSource.getSampledInputCDS().getTXColumn(string4);
            if (tXColumn == null) continue;
            String string5 = null;
            if (null != this.m_targetDataSource.getSampledInternallySampledCDS().getCaseTable()) {
                string5 = MessageFormat.format(SQL_SAMPLING_VIEW_TX, tXColumn.getDataLocation(), string2, this.m_targetDataSource.getSampledInternallySampledCDS().getCaseId(), tXColumn.getTxColumnCaseId());
                this.m_targetDataSource.getSampledInternallySampledCDS().addTxDataSourceView(this.m_targetDataSource.getSampledInputCDS().getTXColumn(string4), string5);
                continue;
            }
            try {
                string5 = tXColumn.getTxTableName();
            }
            catch (Exception exception) {
                string5 = null;
            }
            this.m_targetDataSource.getSampledInternallySampledCDS().addTxDataSourceTable(this.m_targetDataSource.getSampledInputCDS().getTXColumn(string4), string5);
        }
        return this.m_targetDataSource.getSampledInternallySampledCDS().getCaseTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void quantileBinning2D(Connection connection, Vector vector, Hashtable hashtable, String string, int n) {
        this.m_targetDataSource.getEqualWidthStats(vector, hashtable, string, n, false);
        String string2 = "SELECT MIN(val), MAX(val) FROM (SELECT {0} val,NTILE(TO_CHAR(ABS({1}))) OVER(ORDER BY {0} ASC) qtile FROM {2} WHERE {0} IS NOT NULL) GROUP BY qtile ORDER BY qtile ASC";
        for (int i = 0; i < vector.size(); ++i) {
            Serializable serializable;
            String string3 = (String)vector.elementAt(i);
            Integer n2 = (Integer)hashtable.get(string3);
            if (n2 == null) continue;
            String string4 = this.m_lds.getComplexAttributeInfo(string3);
            String string5 = null;
            String string6 = null;
            if (string4 != null) {
                serializable = this.m_targetDataSource.getSampledInternallySampledCDS().getTXColumn(string4);
                string6 = ((TXColumn)serializable).getValueColumn();
                string5 = this.m_targetDataSource instanceof CDSOutlierDiscretizeDataSource ? "(" + this.m_targetDataSource.applyTreatment(string3) + ")" : ((TXColumn)serializable).getDataLocation();
            } else {
                string5 = string == null ? this.m_targetDataSource.getSampledDataLocation() : string;
                string6 = string3;
            }
            serializable = new Vector();
            Vector<Double> vector2 = new Vector<Double>();
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                DiscretizeDataSource.QuantileDefinition quantileDefinition;
                String string7 = MessageFormat.format(string2, string6, new Integer(n), string5);
                int n3 = 0;
                statement = connection.prepareStatement(string7);
                resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    double d = resultSet.getDouble(1);
                    double d2 = resultSet.getDouble(2);
                    ((Vector)serializable).add(new Double(d));
                    vector2.add(new Double(d2));
                    ++n3;
                }
                Vector<DiscretizeDataSource.QuantileDefinition> vector3 = new Vector<DiscretizeDataSource.QuantileDefinition>();
                if (n3 == 0) continue;
                ((Vector)serializable).add(vector2.elementAt(vector2.size() - 1));
                Double[] doubleArray = ((Vector)serializable).toArray(new Double[((Vector)serializable).size()]);
                Double[] doubleArray2 = vector2.toArray(new Double[vector2.size()]);
                if (doubleArray[0].doubleValue() == doubleArray2[n3 - 1].doubleValue()) continue;
                int n4 = 0;
                for (int j = 0; j <= n3; ++j) {
                    if (j <= n3 - 1 && doubleArray[j].doubleValue() == doubleArray[j + 1].doubleValue()) continue;
                    quantileDefinition = new DiscretizeDataSource.QuantileDefinition(n4, doubleArray[j]);
                    vector3.add(quantileDefinition);
                    ++n4;
                }
                Vector<Bin> vector4 = new Vector<Bin>();
                quantileDefinition = (DiscretizeDataSource.QuantileDefinition)vector3.elementAt(0);
                for (int j = 1; j < vector3.size(); ++j) {
                    DiscretizeDataSource.QuantileDefinition quantileDefinition2 = (DiscretizeDataSource.QuantileDefinition)vector3.elementAt(j);
                    String string8 = String.valueOf(Double.MIN_VALUE);
                    Bin bin = new Bin(quantileDefinition2.getBinNumber() - 1, quantileDefinition.getMinNumber(), quantileDefinition2.getMinNumber());
                    vector4.add(bin);
                    quantileDefinition = quantileDefinition2;
                }
                this.m_targetDataSource.setBinBounds(n2, vector4);
                continue;
            }
            catch (Exception exception) {
                if (!DiscretizeDataSource.isDebug()) continue;
                exception.printStackTrace();
                continue;
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    double[] getEqualWidthStats(Connection connection, String string, String string2) {
        String string3 = this.m_lds.getComplexAttributeInfo(string);
        if (string3 == null) {
            return this.m_targetDataSource.getEqualWidthStats(connection, string, string2);
        }
        TXColumn tXColumn = this.m_targetDataSource.getSampledInternallySampledCDS().getTXColumn(string3);
        Statement statement = null;
        ResultSet resultSet = null;
        Object[] objectArray = new Object[]{"\"" + tXColumn.getValueColumn() + "\"", string2 == null ? tXColumn.getDataLocation() : string2};
        String string4 = MessageFormat.format(DiscretizeDataSource.STAT_SQL_EQ_WIDTH_1ST_ORDER, objectArray);
        double[] dArray = new double[DiscretizeDataSource.NUMBER_STATS];
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string4);
            if (resultSet.next()) {
                dArray[DiscretizeDataSource.STAT_TOTAL] = resultSet.getInt("N");
                dArray[DiscretizeDataSource.STAT_AVERAGE] = resultSet.getDouble("Average");
                dArray[DiscretizeDataSource.STAT_MAX] = resultSet.getDouble("Max");
                dArray[DiscretizeDataSource.STAT_MIN] = resultSet.getDouble("Min");
                dArray[DiscretizeDataSource.STAT_VARIANCE] = resultSet.getDouble("Variance");
                dArray[DiscretizeDataSource.STAT_STDEV] = Math.sqrt(dArray[DiscretizeDataSource.STAT_VARIANCE]);
            }
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
            dArray = null;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int[] getNumericFrequency(Connection connection, String string, int n, boolean bl) {
        Serializable serializable;
        String string2;
        Statement statement = null;
        ResultSet resultSet = null;
        int[] nArray = null;
        StringBuffer stringBuffer = null;
        Vector<Integer> vector = new Vector<Integer>();
        Vector<String> vector2 = new Vector<String>();
        int n2 = 0;
        this.m_targetDataSource.m_nullCount = 0;
        try {
            stringBuffer = this.m_targetDataSource.getViewDefinition(n);
            if (stringBuffer == null) {
                stringBuffer = this.m_targetDataSource.getSingleNumericAttributeViewDefinition(connection, n, bl);
            }
            if (stringBuffer == null) {
                int[] nArray2 = nArray;
                return nArray2;
            }
            string2 = this.m_targetDataSource.getComplexAttribute(n);
            serializable = this.m_targetDataSource.getSampledInternallySampledCDS().getTXColumn(string2);
            String string3 = null;
            string3 = !this.m_targetDataSource.isLabels() ? MessageFormat.format(DiscretizeDataSource.HISTOGRAM_VALUES[0], "\"" + ((TXColumn)serializable).getValueColumn() + "\"") : MessageFormat.format(DiscretizeDataSource.HISTOGRAM_VALUES_LABELS[0], "\"" + ((TXColumn)serializable).getValueColumn() + "\"", this.prepareDecodeSatementSingleMetricsTX(n, string));
            StringBuffer stringBuffer2 = new StringBuffer(string3);
            int n3 = stringBuffer.toString().indexOf("SELECT");
            StringBuffer stringBuffer3 = new StringBuffer(stringBuffer.substring(n3));
            stringBuffer2.append(stringBuffer3);
            string3 = !this.m_targetDataSource.isLabels() ? MessageFormat.format(DiscretizeDataSource.HISTOGRAM_VALUES[1], "\"" + ((TXColumn)serializable).getValueColumn() + "\"") : MessageFormat.format(DiscretizeDataSource.HISTOGRAM_VALUES_LABELS[1], "\"" + ((TXColumn)serializable).getValueColumn() + "\"");
            stringBuffer2.append(string3);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(stringBuffer2.toString());
            int n4 = -1;
            String string4 = null;
            while (resultSet.next()) {
                String string5 = resultSet.getString("BIN_NUMBER");
                int n5 = resultSet.getInt("FREQUENCY");
                if (string5 != null) {
                    if (-1 != string5.indexOf(">=")) {
                        n4 = n5;
                        string4 = string5;
                        continue;
                    }
                    ++n2;
                    vector.add(new Integer(n5));
                    vector2.add(string5);
                    continue;
                }
                this.m_targetDataSource.m_nullCount = n5;
            }
            if (n4 != -1) {
                ++n2;
                vector.add(new Integer(n4));
                vector2.add(string4);
            }
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
            nArray = null;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
        if (vector == null || vector.isEmpty()) {
            return null;
        }
        this.m_targetDataSource.setNumberOfNonNulls(n, n2);
        this.m_targetDataSource.setBinCategories(n, vector2);
        if (!this.m_targetDataSource.isAttributeBinned(n)) {
            this.m_targetDataSource.setNumberOfBins(n, n2);
            string2 = this.m_targetDataSource.getBinType(n);
            this.m_targetDataSource.setBinType(n, string2, n2);
        }
        nArray = new int[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            serializable = (Integer)vector.elementAt(i);
            nArray[i] = (Integer)serializable;
        }
        return nArray;
    }

    private String prepareDecodeSatementSingleMetricsTX(int n, String string) {
        DiscretizeDataSource.BinBoundMap binBoundMap = new DiscretizeDataSource.BinBoundMap(1);
        Vector vector = this.m_targetDataSource.getBinBounds(n);
        if (vector == null || vector.size() == 0) {
            return "";
        }
        Bin[] binArray = new Bin[vector.size()];
        binArray = vector.toArray(binArray);
        for (int i = 0; i < binArray.length; ++i) {
            int n2 = binArray[i].getBinNumber();
            double d = binArray[i].getLowerBound();
            double d2 = binArray[i].getUpperBound();
            binBoundMap.addBinBound(string, new DiscretizeDataSource.BinBound(n2, d, d2));
        }
        StringBuffer stringBuffer = new StringBuffer();
        BinningType binningType = this.m_targetDataSource.getBinningType(n);
        Vector vector2 = binBoundMap.getBinBounds(string.toUpperCase());
        for (int i = 0; i < vector2.size(); ++i) {
            String string2 = null;
            String string3 = null;
            String string4 = null;
            DiscretizeDataSource.BinBound binBound = (DiscretizeDataSource.BinBound)vector2.elementAt(i);
            if (binningType.equal(BinningType.QTILE)) {
                if (i == 0) {
                    string4 = " < " + DM4JNumericFormat.format(binBound.m_upperBound);
                    string2 = DiscretizeDataSource.appendSingleQuotes(string4);
                } else if (i == vector2.size() - 1) {
                    string4 = " >= " + DM4JNumericFormat.format(binBound.m_lowerBound);
                    string2 = DiscretizeDataSource.appendSingleQuotes(string4);
                } else {
                    string4 = DM4JNumericFormat.format(binBound.m_lowerBound) + " - " + DM4JNumericFormat.format(binBound.m_upperBound);
                    string2 = DiscretizeDataSource.appendSingleQuotes(string4);
                }
            } else if (i == 0) {
                string4 = " < " + DM4JNumericFormat.format(binBound.m_upperBound);
                string2 = DiscretizeDataSource.appendSingleQuotes(string4);
                string3 = " < " + DM4JNumericFormat.SQLFormat(binBound.m_upperBound);
            } else if (i == vector2.size() - 1) {
                string4 = " >= " + DM4JNumericFormat.format(binBound.m_lowerBound);
                string2 = DiscretizeDataSource.appendSingleQuotes(string4);
                string3 = " >= " + DM4JNumericFormat.SQLFormat(binBound.m_lowerBound);
            } else {
                DiscretizeDataSource.BinBound binBound2 = (DiscretizeDataSource.BinBound)vector2.elementAt(i - 1);
                string4 = DM4JNumericFormat.format(binBound2.m_upperBound) + " - " + DM4JNumericFormat.format(binBound.m_upperBound);
                string2 = DiscretizeDataSource.appendSingleQuotes(string4);
                string3 = " <= " + DM4JNumericFormat.SQLFormat(binBound.m_upperBound);
            }
            stringBuffer.append(string2);
            stringBuffer.append("," + (i + 1));
            if (i < vector2.size() - 1) {
                stringBuffer.append(",");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    StringBuffer getSingleNumericAttributeViewDefinition(Connection connection, int n, boolean bl) {
        StringBuffer stringBuffer = null;
        try {
            Vector<String> vector = new Vector<String>();
            vector.add(this.m_targetDataSource.getAttributeName(n));
            this.m_targetDataSource.createNumericOpenEndedViewDefinition(vector, new int[]{n}, this.m_targetDataSource.getSampledDataLocation(), this.m_targetDataSource.m_userSchemaName, this.m_targetDataSource.m_resultViewName, bl);
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
            this.m_targetDataSource.setViewDefinition(n, null);
        }
        return stringBuffer;
    }

    void processNumTxSource(String string, String string2, String string3, Object object, Hashtable hashtable) throws Exception {
        int n = this.m_targetDataSource.getAttributeRow(string);
        if (n == -1) {
            return;
        }
        TXColumn tXColumn = this.m_targetDataSource.getSampledInputCDS().getTXColumn(string3);
        if (tXColumn == null) {
            return;
        }
        TXColumn tXColumn2 = this.m_targetDataSource.getSampledOutputCDS().getTXColumn(string3);
        if (tXColumn2 == null) {
            return;
        }
        DiscretizeDataSource.BinBoundMap binBoundMap = (DiscretizeDataSource.BinBoundMap)object;
        String string4 = tXColumn.getNameColumn();
        String string5 = tXColumn.getTxColumnCaseId();
        StringBuffer stringBuffer = new StringBuffer("CREATE VIEW " + tXColumn2.getDataLocation() + " AS SELECT " + (string4 == null ? "" : (DM4JStringUtils.isDoubleQuotedString(string4) ? string4 : DM4JStringUtils.addDoubleQuotes(string4)) + ",") + (DM4JStringUtils.isDoubleQuotedString(string5) ? string5 : DM4JStringUtils.addDoubleQuotes(string5)) + "," + "\n");
        String string6 = "\"" + string2 + "\"";
        String string7 = "\"" + string + "\"";
        BinningType binningType = (BinningType)hashtable.get(string);
        if (binBoundMap.isEmpty(string7)) {
            stringBuffer.append(string6);
        } else if (binBoundMap.size(string7) == 1) {
            stringBuffer.append("( CASE ");
            stringBuffer.append("WHEN ");
            stringBuffer.append(string6);
            stringBuffer.append(" is not null then 1 end) " + string6);
            String string8 = ResourceUtilities.getUILabel("HISTOGRAM_NOT_NULL");
            Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
            Vector<String> vector = new Vector<String>();
            hashtable2.put(DiscretizeDataSource.appendSingleQuotes("1"), string8);
            vector.add(DiscretizeDataSource.appendSingleQuotes("1"));
            this.m_targetDataSource.setMapCategorytoRange(this.m_targetDataSource.getAttributeRow(string), hashtable2);
            this.m_targetDataSource.setAllCategorytoRangeList(this.m_targetDataSource.getAttributeRow(string), vector);
        } else if (binningType.equal(BinningType.QTILE)) {
            if (tXColumn.isNumeric()) {
                this.prepareQtileDefinition(stringBuffer, binBoundMap, string6, string);
            } else {
                this.prepareQtileDefinitionLabels(stringBuffer, binBoundMap, string6, string);
            }
        } else if (tXColumn.isNumeric()) {
            this.prepareEqWidthDefinition(stringBuffer, binBoundMap, string6, string);
        } else {
            this.prepareEqWidthDefinitionLabels(stringBuffer, binBoundMap, string6, string);
        }
        stringBuffer.append("\n");
        stringBuffer.append(" FROM " + tXColumn.getDataLocation());
        this.m_targetDataSource.setViewDefinition(n, stringBuffer);
        tXColumn2.setSqlQuery(stringBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void getEqualWidth2ndorderStats(Connection connection, int n, double[] dArray, String string, String string2) {
        Object object;
        String string3 = this.m_targetDataSource.getComplexAttribute(n);
        TXColumn tXColumn = this.m_targetDataSource.getSampledInternallySampledCDS().getTXColumn(string3);
        Integer n2 = (Integer)this.m_targetDataSource.getData(DiscretizeDataSource.COLUMN_NAMES.TOTAL, n);
        Double d = (Double)this.m_targetDataSource.getData(DiscretizeDataSource.COLUMN_NAMES.STDDEV, n);
        if (n2 == null || d == null) {
            object = this.m_targetDataSource.getEqualWidthStdevCount(connection, "\"" + tXColumn.getValueColumn() + "\"", tXColumn.getDataLocation());
            dArray[DiscretizeDataSource.STAT_TOTAL] = object[DiscretizeDataSource.STAT_TOTAL];
            dArray[DiscretizeDataSource.STAT_STDEV] = object[DiscretizeDataSource.STAT_STDEV];
            dArray[DiscretizeDataSource.STAT_VARIANCE] = object[DiscretizeDataSource.STAT_VARIANCE];
            this.m_targetDataSource.setData(DiscretizeDataSource.COLUMN_NAMES.TOTAL, n, new Integer((int)dArray[DiscretizeDataSource.STAT_TOTAL]));
            this.m_targetDataSource.setData(DiscretizeDataSource.COLUMN_NAMES.STDDEV, n, new Double(dArray[DiscretizeDataSource.STAT_STDEV]));
            this.m_targetDataSource.setData(DiscretizeDataSource.COLUMN_NAMES.VAR, n, new Double(dArray[DiscretizeDataSource.STAT_VARIANCE]));
        }
        object = null;
        ResultSet resultSet = null;
        Object[] objectArray = new Object[]{String.valueOf(dArray[DiscretizeDataSource.STAT_AVERAGE]), "\"" + tXColumn.getValueColumn() + "\"", String.valueOf((int)dArray[DiscretizeDataSource.STAT_TOTAL]), String.valueOf(dArray[DiscretizeDataSource.STAT_STDEV]), tXColumn.getDataLocation()};
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < DiscretizeDataSource.STAT_SQL_EQ_WIDTH_2ND_ORDER.length; ++i) {
            String string4 = MessageFormat.format(DiscretizeDataSource.STAT_SQL_EQ_WIDTH_2ND_ORDER[i], objectArray);
            stringBuffer.append(string4);
        }
        if (dArray[DiscretizeDataSource.STAT_STDEV] != 0.0) {
            try {
                object = connection.createStatement();
                resultSet = object.executeQuery(stringBuffer.toString());
                if (!resultSet.next()) return;
                double d2 = resultSet.getDouble("Skew");
                double d3 = resultSet.getDouble("Kurtosis");
                this.m_targetDataSource.setKurtosis(n, new Double(d3));
                this.m_targetDataSource.setSkew(n, new Double(d2));
                return;
            }
            catch (Exception exception) {
                if (!DiscretizeDataSource.isDebug()) return;
                exception.printStackTrace();
                return;
            }
            finally {
                try {
                    resultSet.close();
                    object.close();
                }
                catch (Exception exception) {}
            }
        }
        this.m_targetDataSource.setKurtosis(n, new Double(0.0));
        this.m_targetDataSource.setSkew(n, new Double(0.0));
    }

    void prepareEqWidthDefinitionLabels(StringBuffer stringBuffer, DiscretizeDataSource.BinBoundMap binBoundMap, String string, String string2) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Vector<String> vector = new Vector<String>();
        stringBuffer.append("( CASE ");
        Vector vector2 = binBoundMap.getBinBounds("\"" + string2 + "\"");
        for (int i = 0; i < vector2.size(); ++i) {
            String string3 = null;
            String string4 = null;
            String string5 = null;
            stringBuffer.append("WHEN ");
            DiscretizeDataSource.BinBound binBound = (DiscretizeDataSource.BinBound)vector2.elementAt(i);
            if (i == 0) {
                string5 = " < " + DM4JNumericFormat.format(binBound.m_upperBound);
                string3 = DiscretizeDataSource.appendSingleQuotes(string5);
                string4 = " < " + DM4JNumericFormat.SQLFormat(binBound.m_upperBound);
            } else if (i == vector2.size() - 1) {
                string5 = " >= " + DM4JNumericFormat.format(binBound.m_lowerBound);
                string3 = DiscretizeDataSource.appendSingleQuotes(string5);
                string4 = " >= " + DM4JNumericFormat.SQLFormat(binBound.m_lowerBound);
            } else {
                DiscretizeDataSource.BinBound binBound2 = (DiscretizeDataSource.BinBound)vector2.elementAt(i - 1);
                string5 = DM4JNumericFormat.format(binBound2.m_upperBound) + " - " + DM4JNumericFormat.format(binBound.m_upperBound);
                string3 = DiscretizeDataSource.appendSingleQuotes(string5);
                string4 = " <= " + DM4JNumericFormat.SQLFormat(binBound.m_upperBound);
            }
            stringBuffer.append(string + string4 + " THEN " + string3);
            stringBuffer.append("\n");
            hashtable.put(string3, string5);
            vector.add(string3);
        }
        stringBuffer.append("else null end) " + string);
        this.m_targetDataSource.setMapCategorytoRange(this.m_targetDataSource.getAttributeRow(string2), hashtable);
        this.m_targetDataSource.setAllCategorytoRangeList(this.m_targetDataSource.getAttributeRow(string2), vector);
    }

    protected void prepareEqWidthDefinition(StringBuffer stringBuffer, DiscretizeDataSource.BinBoundMap binBoundMap, String string, String string2) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Vector<String> vector = new Vector<String>();
        stringBuffer.append("( CASE ");
        Vector vector2 = binBoundMap.getBinBounds("\"" + string2 + "\"");
        for (int i = 0; i < vector2.size(); ++i) {
            String string3 = String.valueOf(i + 1);
            String string4 = null;
            String string5 = null;
            stringBuffer.append("WHEN ");
            DiscretizeDataSource.BinBound binBound = (DiscretizeDataSource.BinBound)vector2.elementAt(i);
            if (i == 0) {
                string4 = " < " + DM4JNumericFormat.SQLFormat(binBound.m_upperBound);
                string5 = " < " + DM4JNumericFormat.format(binBound.m_upperBound);
            } else if (i == vector2.size() - 1) {
                string4 = " >= " + DM4JNumericFormat.SQLFormat(binBound.m_lowerBound);
                string5 = " >= " + DM4JNumericFormat.format(binBound.m_lowerBound);
            } else {
                DiscretizeDataSource.BinBound binBound2 = (DiscretizeDataSource.BinBound)vector2.elementAt(i - 1);
                string4 = " >= " + DM4JNumericFormat.SQLFormat(binBound2.m_upperBound) + " AND " + string + " < " + DM4JNumericFormat.SQLFormat(binBound.m_upperBound);
                string5 = DM4JNumericFormat.format(binBound2.m_upperBound) + " - " + DM4JNumericFormat.format(binBound.m_upperBound);
            }
            stringBuffer.append(string + string4 + " THEN " + string3);
            stringBuffer.append("\n");
            hashtable.put(DiscretizeDataSource.appendSingleQuotes(string3), string5);
            vector.add(DiscretizeDataSource.appendSingleQuotes(string3));
        }
        stringBuffer.append("else null end) " + string);
        this.m_targetDataSource.setMapCategorytoRange(this.m_targetDataSource.getAttributeRow(string2), hashtable);
        this.m_targetDataSource.setAllCategorytoRangeList(this.m_targetDataSource.getAttributeRow(string2), vector);
    }

    void prepareQtileDefinitionLabels(StringBuffer stringBuffer, DiscretizeDataSource.BinBoundMap binBoundMap, String string, String string2) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Vector<String> vector = new Vector<String>();
        stringBuffer.append("( CASE ");
        Vector vector2 = binBoundMap.getBinBounds("\"" + string2 + "\"");
        for (int i = 0; i < vector2.size(); ++i) {
            String string3 = null;
            String string4 = null;
            String string5 = null;
            stringBuffer.append("WHEN ");
            DiscretizeDataSource.BinBound binBound = (DiscretizeDataSource.BinBound)vector2.elementAt(i);
            if (i == 0) {
                string5 = " < " + DM4JNumericFormat.format(binBound.m_upperBound);
                string3 = DiscretizeDataSource.appendSingleQuotes(string5);
                string4 = " < " + DM4JNumericFormat.SQLFormat(binBound.m_upperBound);
            } else if (i == vector2.size() - 1) {
                string5 = " >= " + DM4JNumericFormat.format(binBound.m_lowerBound);
                string3 = DiscretizeDataSource.appendSingleQuotes(string5);
                string4 = " >= " + DM4JNumericFormat.SQLFormat(binBound.m_lowerBound);
            } else {
                string5 = DM4JNumericFormat.format(binBound.m_lowerBound) + " - " + DM4JNumericFormat.format(binBound.m_upperBound);
                string3 = DiscretizeDataSource.appendSingleQuotes(string5);
                string4 = " <= " + DM4JNumericFormat.SQLFormat(binBound.m_upperBound);
            }
            stringBuffer.append(string + string4 + " THEN " + string3);
            stringBuffer.append("\n");
            hashtable.put(string3, string5);
            vector.add(string3);
        }
        stringBuffer.append("else null end) " + string);
        this.m_targetDataSource.setMapCategorytoRange(this.m_targetDataSource.getAttributeRow(string2), hashtable);
        this.m_targetDataSource.setAllCategorytoRangeList(this.m_targetDataSource.getAttributeRow(string2), vector);
    }

    protected void prepareQtileDefinition(StringBuffer stringBuffer, DiscretizeDataSource.BinBoundMap binBoundMap, String string, String string2) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Vector<String> vector = new Vector<String>();
        stringBuffer.append("( CASE ");
        Vector vector2 = binBoundMap.getBinBounds("\"" + string2 + "\"");
        for (int i = 0; i < vector2.size(); ++i) {
            String string3 = String.valueOf(i + 1);
            String string4 = null;
            String string5 = null;
            stringBuffer.append("WHEN ");
            DiscretizeDataSource.BinBound binBound = (DiscretizeDataSource.BinBound)vector2.elementAt(i);
            if (i == 0) {
                string4 = " < " + DM4JNumericFormat.SQLFormat(binBound.m_upperBound);
                string5 = " < " + DM4JNumericFormat.format(binBound.m_upperBound);
            } else if (i == vector2.size() - 1) {
                string4 = " >= " + DM4JNumericFormat.SQLFormat(binBound.m_lowerBound);
                string5 = " >= " + DM4JNumericFormat.format(binBound.m_lowerBound);
            } else {
                string4 = " <= " + DM4JNumericFormat.SQLFormat(binBound.m_upperBound);
                string5 = DM4JNumericFormat.format(binBound.m_lowerBound) + " - " + DM4JNumericFormat.format(binBound.m_upperBound);
            }
            stringBuffer.append(string + string4 + " THEN " + string3);
            stringBuffer.append("\n");
            hashtable.put(DiscretizeDataSource.appendSingleQuotes(string3), string5);
            vector.add(DiscretizeDataSource.appendSingleQuotes(string3));
        }
        stringBuffer.append(" end) " + string);
        this.m_targetDataSource.setMapCategorytoRange(this.m_targetDataSource.getAttributeRow(string2), hashtable);
        this.m_targetDataSource.setAllCategorytoRangeList(this.m_targetDataSource.getAttributeRow(string2), vector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createDataFrom2DSource() throws Exception {
        Connection connection = null;
        CategoricDiscretizeDataSource categoricDiscretizeDataSource = (CategoricDiscretizeDataSource)this.m_targetDataSource.m_additionalSource;
        if (categoricDiscretizeDataSource == null) {
            return;
        }
        try {
            connection = DM4JConnectionManager.getDbConnection();
            if (this.m_collectColumnNames) {
                categoricDiscretizeDataSource.m_tableColumns = this.m_lds.getAllAttributes();
            }
            int n = 0;
            Vector vector = this.m_lds.getAllAttributes();
            Vector<String> vector2 = new Vector<String>();
            Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
            Vector<String> vector3 = new Vector<String>();
            Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>();
            for (int i = 0; i < vector.size(); ++i) {
                String string;
                AttributeType attributeType;
                String string2 = (String)vector.elementAt(i);
                if (null != this.m_excludedAttributes.get(string2) || (attributeType = this.m_targetDataSource.getAttributeType(string = this.m_lds.getMiningType(string2))) == null || !attributeType.equals(AttributeType.categorical)) continue;
                categoricDiscretizeDataSource.addRows(++n - 1, 1);
                categoricDiscretizeDataSource.setAttributeName(n - 1, string2);
                categoricDiscretizeDataSource.setMiningType(n - 1, this.m_lds.getMiningType(string2));
                categoricDiscretizeDataSource.setDataType(n - 1, this.m_lds.getDataType(string2));
                categoricDiscretizeDataSource.setBinTypeNONE(n - 1);
                categoricDiscretizeDataSource.setNumberOfBins(n - 1);
                categoricDiscretizeDataSource.setViewDefinition(n - 1, null);
                categoricDiscretizeDataSource.setDisplayNames(n - 1, null);
                categoricDiscretizeDataSource.setBinBounds(n - 1, null);
                String string3 = this.m_lds.getComplexAttributeInfo(string2);
                categoricDiscretizeDataSource.setComplexAttribute(n - 1, string3);
                if (string3 == null) {
                    vector2.add(string2);
                    hashtable.put(string2, new Integer(n - 1));
                    continue;
                }
                vector3.add(string2);
                hashtable2.put(string2, new Integer(n - 1));
            }
            categoricDiscretizeDataSource.addCategoricStats2D(connection, vector2, hashtable, null);
            this.addComplexStatsCat(connection, vector3, hashtable2);
            hashtable.clear();
            vector2.clear();
            vector3.clear();
            hashtable2.clear();
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addComplexStatsCat(Connection connection, Vector vector, Hashtable hashtable) {
        if (vector == null || vector.isEmpty()) {
            return;
        }
        CategoricDiscretizeDataSource categoricDiscretizeDataSource = (CategoricDiscretizeDataSource)this.m_targetDataSource.m_additionalSource;
        for (int i = 0; i < vector.size(); ++i) {
            StringBuffer stringBuffer = new StringBuffer("SELECT /*+ parallel (t1) */");
            String string = (String)vector.elementAt(i);
            String string2 = this.m_lds.getComplexAttributeInfo(string);
            TXColumn tXColumn = categoricDiscretizeDataSource.getSampledInternallySampledCDS().getTXColumn(string2);
            if (tXColumn == null) continue;
            String string3 = MessageFormat.format(this.STATS_SQL_CAT, "\"" + tXColumn.getValueColumn() + "\"", String.valueOf(i));
            stringBuffer.append(string3);
            String string4 = MessageFormat.format(" from (({0}) t1)", tXColumn.getDataLocation());
            stringBuffer.append(string4);
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                Integer n;
                statement = connection.createStatement();
                resultSet = statement.executeQuery(stringBuffer.toString());
                if (!resultSet.next() || (n = (Integer)hashtable.get(string)) == null) continue;
                int n2 = resultSet.getInt("N");
                categoricDiscretizeDataSource.setData(CategoricDiscretizeDataSource.COLUMN_NAMES.TOTAL, n, new Integer(n2));
                int n3 = resultSet.getInt("D");
                categoricDiscretizeDataSource.setData(CategoricDiscretizeDataSource.COLUMN_NAMES.DISTINCT, n, new Integer(n3));
                String string5 = resultSet.getString("S");
                categoricDiscretizeDataSource.setData(CategoricDiscretizeDataSource.COLUMN_NAMES.MODE, n, string5);
                int n4 = resultSet.getInt("T");
                int n5 = n4 - n2;
                double d = (double)n5 / (double)n4 * 100.0;
                categoricDiscretizeDataSource.setData(CategoricDiscretizeDataSource.COLUMN_NAMES.MISSING_PERCENT, n, new Double(d));
                categoricDiscretizeDataSource.setData(CategoricDiscretizeDataSource.COLUMN_NAMES.SPARSITY_FLAG, n, new Boolean(true));
                continue;
            }
            catch (Exception exception) {
                if (!DiscretizeDataSource.isDebug()) continue;
                exception.printStackTrace();
                continue;
            }
            finally {
                try {
                    resultSet.close();
                    statement.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getTopNStats(Connection connection, Vector vector, Hashtable hashtable, String string) {
        String string2;
        int n;
        if (vector == null || vector.isEmpty()) {
            return;
        }
        CategoricDiscretizeDataSource categoricDiscretizeDataSource = (CategoricDiscretizeDataSource)this.m_targetDataSource.m_additionalSource;
        if (categoricDiscretizeDataSource == null) {
            return;
        }
        String string3 = string;
        if (string3 == null) {
            if (categoricDiscretizeDataSource.m_lds != null) {
                n = categoricDiscretizeDataSource.m_lds.getCaseCount();
                string2 = categoricDiscretizeDataSource.getSampledInternallySampledCDS().getSampledCaseTable();
                string3 = DM4JStringUtils.getReplacedString(string2, "<case_count>", String.valueOf(n));
            } else {
                string3 = categoricDiscretizeDataSource.getSampledDataLocation();
            }
        }
        for (n = 0; n < vector.size(); ++n) {
            Integer n2;
            string2 = (String)vector.elementAt(n);
            Integer n3 = (Integer)hashtable.get(string2);
            if (n3 == null || (n2 = categoricDiscretizeDataSource.getNumberOfBins(n3)) == null) continue;
            Statement statement = null;
            ResultSet resultSet = null;
            Vector<CategoricBin> vector2 = new Vector<CategoricBin>();
            String string4 = this.m_lds.getComplexAttributeInfo(string2);
            try {
                Object object;
                Object object2;
                Object object3;
                String string5 = null;
                if (string4 == null) {
                    string5 = MessageFormat.format("SELECT * FROM (SELECT {0} FROM {1} GROUP BY {0} HAVING {0} IS NOT NULL ORDER BY COUNT(*) DESC, {0} DESC) WHERE rownum <= {2}", "\"" + string2 + "\"", string3, String.valueOf(n2));
                } else {
                    object3 = categoricDiscretizeDataSource.getSampledInternallySampledCDS().getValueColumn(string4);
                    object2 = categoricDiscretizeDataSource.getSampledInternallySampledCDS().getTXColumn(string4);
                    object = ((TXColumn)object2).getDataLocation();
                    string5 = MessageFormat.format("SELECT * FROM (SELECT {0} FROM {1} GROUP BY {0} HAVING {0} IS NOT NULL ORDER BY COUNT(*) DESC, {0} DESC) WHERE rownum <= {2}", "\"" + (String)object3 + "\"", object, String.valueOf(n2));
                }
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string5);
                while (resultSet.next()) {
                    object3 = new Vector();
                    object2 = resultSet.getString(1);
                    object = null;
                    try {
                        object = TransformsDirector.getReplacedString((String)object2, "'", "''");
                    }
                    catch (Exception exception) {
                        object = object2;
                    }
                    ((Vector)object3).add(object);
                    CategoricBin categoricBin = new CategoricBin((String)object, (Vector)object3);
                    vector2.add(categoricBin);
                }
                categoricDiscretizeDataSource.setBinBounds(n3, vector2);
                continue;
            }
            catch (Exception exception) {
                if (!DiscretizeDataSource.isDebug()) continue;
                exception.printStackTrace();
                continue;
            }
            finally {
                try {
                    resultSet.close();
                    statement.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getTopNStats(Connection connection, int n, int n2) {
        CategoricDiscretizeDataSource categoricDiscretizeDataSource = (CategoricDiscretizeDataSource)this.m_targetDataSource.m_additionalSource;
        if (categoricDiscretizeDataSource == null) {
            return;
        }
        String string = categoricDiscretizeDataSource.getComplexAttribute(n);
        TXColumn tXColumn = categoricDiscretizeDataSource.getSampledInternallySampledCDS().getTXColumn(string);
        String string2 = String.valueOf(n2);
        String string3 = categoricDiscretizeDataSource.getAttributeName(n);
        Statement statement = null;
        ResultSet resultSet = null;
        Vector<CategoricBin> vector = new Vector<CategoricBin>();
        try {
            String string4 = MessageFormat.format("SELECT * FROM (SELECT {0} FROM {1} GROUP BY {0} HAVING {0} IS NOT NULL ORDER BY COUNT(*) DESC, {0} DESC) WHERE rownum <= {2}", "\"" + tXColumn.getValueColumn() + "\"", tXColumn.getDataLocation(), string2);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string4);
            while (resultSet.next()) {
                Vector<String> vector2 = new Vector<String>();
                String string5 = resultSet.getString(1);
                String string6 = null;
                try {
                    string6 = TransformsDirector.getReplacedString(string5, "'", "''");
                }
                catch (Exception exception) {
                    string6 = string5;
                }
                vector2.add(string6);
                CategoricBin categoricBin = new CategoricBin(string6, vector2);
                vector.add(categoricBin);
            }
            categoricDiscretizeDataSource.setBinBounds(n, vector);
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int[] getCategoricAttributeFrequency(Connection connection, int n) {
        Object object;
        Object object2;
        CategoricDiscretizeDataSource categoricDiscretizeDataSource = (CategoricDiscretizeDataSource)this.m_targetDataSource.m_additionalSource;
        if (categoricDiscretizeDataSource == null) {
            return null;
        }
        String string = categoricDiscretizeDataSource.getComplexAttribute(n);
        String[] stringArray = new String[]{"select {0} DISPLAY_NAME, count(*) FREQUENCY ", "from {1} group by {0} order by FREQUENCY desc"};
        TXColumn tXColumn = categoricDiscretizeDataSource.getSampledInternallySampledCDS().getTXColumn(string);
        String string2 = "\"" + tXColumn.getValueColumn() + "\"";
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            object2 = MessageFormat.format(stringArray[i], string2, tXColumn.getDataLocation());
            stringBuffer.append((String)object2);
        }
        Hashtable<Integer, CategoricBin> hashtable = new Hashtable<Integer, CategoricBin>();
        object2 = categoricDiscretizeDataSource.getBinBounds(n);
        int n2 = ((Vector)object2).size();
        int[] nArray = new int[n2 + 1];
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(stringBuffer.toString());
            object = preparedStatement.executeQuery();
            boolean bl = false;
            while (object.next()) {
                String string3 = object.getString("DISPLAY_NAME");
                if (string3 == null) {
                    string3 = ResourceUtilities.getUILabel("HISTOGRAM_NULL_VALUE");
                }
                int n3 = object.getInt("FREQUENCY");
                boolean bl2 = false;
                for (int i = 0; i < n2; ++i) {
                    CategoricBin categoricBin = (CategoricBin)((Vector)object2).elementAt(i);
                    for (int j = 0; j < categoricBin.values.size(); ++j) {
                        if (0 != string3.compareTo((String)categoricBin.values.elementAt(j))) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl2) continue;
                    int n4 = i;
                    nArray[n4] = nArray[n4] + n3;
                    break;
                }
                if (bl2) continue;
                int n5 = n2;
                nArray[n5] = nArray[n5] + n3;
            }
            for (int i = 0; i < n2; ++i) {
                CategoricBin categoricBin = (CategoricBin)((Vector)object2).elementAt(i);
                hashtable.put(new Integer(i), categoricBin);
            }
            String string4 = ResourceUtilities.getUILabel("HISTOGRAM_OTHER");
            Vector vector = categoricDiscretizeDataSource.getOther((Vector)object2, n);
            hashtable.put(new Integer(n2), new CategoricBin(string4, vector));
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
            hashtable.clear();
        }
        finally {
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {}
        }
        if (hashtable.isEmpty()) {
            return null;
        }
        categoricDiscretizeDataSource.setDisplayNames(n, hashtable);
        categoricDiscretizeDataSource.setNumberOfBins(n, n2);
        object = categoricDiscretizeDataSource.getBinType(n);
        categoricDiscretizeDataSource.setBinType(n, (String)object, n2);
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Vector get2DDistinctValues(Connection connection, String string) {
        CategoricDiscretizeDataSource categoricDiscretizeDataSource = (CategoricDiscretizeDataSource)this.m_targetDataSource.m_additionalSource;
        if (categoricDiscretizeDataSource == null) {
            return null;
        }
        String string2 = this.m_lds.getComplexAttributeInfo(string);
        TXColumn tXColumn = categoricDiscretizeDataSource.getSampledInternallySampledCDS().getTXColumn(string2);
        String string3 = "select distinct {0} from {1} where {0} is not null";
        String string4 = MessageFormat.format(string3, "\"" + tXColumn.getValueColumn() + "\"", tXColumn.getDataLocation());
        Statement statement = null;
        ResultSet resultSet = null;
        Vector<String> vector = new Vector<String>();
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string4);
            while (resultSet.next()) {
                String string5 = resultSet.getString(1);
                vector.add(string5);
            }
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
        return vector;
    }
}

